##############################################################################
# Module : webtest.py
# Author :
# Date   :
# Updated and modified for ABC_OKC : Old King Cole
#
# Description : Web service tests
#
##############################################################################
import socket
from sys import argv, exit
from time import sleep


class WebClient:
    def __init__(self, ip, port):
        self.ip = ip
        self.port = port

    def sendmesg(self, mesg):
        s = None
        for res in socket.getaddrinfo(self.ip, self.port, socket.AF_UNSPEC, socket.SOCK_STREAM):
            af, socktype, proto, canonname, sa = res
            try:
                s = socket.socket(af, socktype, proto)
            except socket.error, msg:
                s = None
                continue
            try:
                s.connect(sa)
            except socket.error, msg:
                s.close()
                s = None
                continue
            break
        if s is None:
            return "Can't connect ABC web service" 
        s.send(mesg)
        retmesg = s.recv(300000)
        s.close()
        return retmesg

######## Test #########
if len(argv) != 4:
    print "Usage: webtest.py <unique key> <IP> <Port>"
    exit(0)
    
KEY = argv[1]
IP = argv[2]
PORT = argv[3]

wc = WebClient(argv[2], argv[3])
print "--------------- Start Testing Web Service ---------------------"
#print "Query Command :"
#ret = wc.sendmesg("ID|" + KEY + "\nQUERY|")
#line = ret.split("\n")
#key = line[0].split("|")
#dict = {}
#for i in key:
#    dict[i] = ""
#if len(line) > 1:
#    for i in xrange(1, len(line) - 1):
#        result = line[i].split("|")
#        for j in xrange(len(key)):
#            dict[key[j]] = result[j]
#            print key[j] + " = " + dict[key[j]]
#        print "--------"
#
#print "---------------------------------------------------------------"
#
#print "Getparam Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nGETPARAM|fastresume,language_file,confirmonclose")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Setparam Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nSETPARAM|fastresume=1|urm=0")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Getstring Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nGETSTRING|aboutabc")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Add Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nADD|http://torrentserver/dummy.torrent")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Priority Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nPRIORITY|85243bdb86bbf9c111ed17e5e6b64d1abec4992f,4|c1ad55a0ee442e31693377c16296c91a1c4aec16,0")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Priority Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nPRIORITY|85243bdb86bbf9c111ed17e5e6b64d1abec4992f,2|c1ad55a0ee442e31693377c16296c91a1c4aec16,2")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Stop Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nSTOP|85243bdb86bbf9c111ed17e5e6b64d1abec4992f,c1ad55a0ee442e31693377c16296c91a1c4aec16")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Queue Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nQUEUE|85243bdb86bbf9c111ed17e5e6b64d1abec4992f,c1ad55a0ee442e31693377c16296c91a1c4aec16")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Stop Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nSTOP|85243bdb86bbf9c111ed17e5e6b64d1abec4992f,c1ad55a0ee442e31693377c16296c91a1c4aec16")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Resume Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nRESUME|85243bdb86bbf9c111ed17e5e6b64d1abec4992f,c1ad55a0ee442e31693377c16296c91a1c4aec16")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Pause Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nPAUSE|85243bdb86bbf9c111ed17e5e6b64d1abec4992f,c1ad55a0ee442e31693377c16296c91a1c4aec16")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Unpause Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nUNPAUSE|85243bdb86bbf9c111ed17e5e6b64d1abec4992f,c1ad55a0ee442e31693377c16296c91a1c4aec16")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Stop Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nSTOP|85243bdb86bbf9c111ed17e5e6b64d1abec4992f,c1ad55a0ee442e31693377c16296c91a1c4aec16")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Stop ALL Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nSTOP|ALL")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Move up Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nMOVEUP|85243bdb86bbf9c111ed17e5e6b64d1abec4992f,c1ad55a0ee442e31693377c16296c91a1c4aec16")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Move down Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nMOVEDOWN|85243bdb86bbf9c111ed17e5e6b64d1abec4992f,c1ad55a0ee442e31693377c16296c91a1c4aec16")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Move top Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nMOVETOP|85243bdb86bbf9c111ed17e5e6b64d1abec4992f,c1ad55a0ee442e31693377c16296c91a1c4aec16")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Move bottom Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nMOVEBOTTOM|85243bdb86bbf9c111ed17e5e6b64d1abec4992f,c1ad55a0ee442e31693377c16296c91a1c4aec16")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Move below completed Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nMOVEBELOWCOMPLETED|85243bdb86bbf9c111ed17e5e6b64d1abec4992f,c1ad55a0ee442e31693377c16296c91a1c4aec16")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Check Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nCHECK|85243bdb86bbf9c111ed17e5e6b64d1abec4992f,c1ad55a0ee442e31693377c16296c91a1c4aec16")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Superseed Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nSUPERSEED|85243bdb86bbf9c111ed17e5e6b64d1abec4992f,c1ad55a0ee442e31693377c16296c91a1c4aec16")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Get torrent parameters Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nGETTORRENTPARAM|85243bdb86bbf9c111ed17e5e6b64d1abec4992f")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Set torrent parameters Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nSETTORRENTPARAM|85243bdb86bbf9c111ed17e5e6b64d1abec4992f|NewLabel|100|4|80|2|3|45|80|1|0|1|1|1|1|1|1|300|180|10|d:\\test\\down|1|http://dummy.com")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Get torrent parameters Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nGETTORRENTPARAM|85243bdb86bbf9c111ed17e5e6b64d1abec4992f")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Get torrent data (main) Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nGETTORRENTDATA|85243bdb86bbf9c111ed17e5e6b64d1abec4992f|MAIN")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Get torrent data (files) Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nGETTORRENTDATA|85243bdb86bbf9c111ed17e5e6b64d1abec4992f|FILES")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Get torrent data (all) Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nGETTORRENTDATA|85243bdb86bbf9c111ed17e5e6b64d1abec4992f|ALL")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Set torrent file priority Command with wrong priority number :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nSETTORRENTFILEPRIO|85243bdb86bbf9c111ed17e5e6b64d1abec4992f|2|3")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Set torrent file priority Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nSETTORRENTFILEPRIO|85243bdb86bbf9c111ed17e5e6b64d1abec4992f|0|-1")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Rename torrent (without renaming destination) :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nRENAME|85243bdb86bbf9c111ed17e5e6b64d1abec4992f|New Name 100|0")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Rename torrent (and rename destination) :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nRENAME|85243bdb86bbf9c111ed17e5e6b64d1abec4992f|New Name 200|1")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Change download destination :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nSETDOWNDEST|85243bdb86bbf9c111ed17e5e6b64d1abec4992f|c:\\downtest|test1|0|0")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Change download destination (and move data) :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nSETDOWNDEST|85243bdb86bbf9c111ed17e5e6b64d1abec4992f|c:\\downtest|test2|0|1")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Change download destination (and rename) :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nSETDOWNDEST|85243bdb86bbf9c111ed17e5e6b64d1abec4992f|c:\\downtest|test3|1|0")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Rename file inside torrent 1 :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nRENAMETORRENTFILE|c1ad55a0ee442e31693377c16296c91a1c4aec16|2|NewName.txt")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Rename file inside torrent 2 :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nRENAMETORRENTFILE|c1ad55a0ee442e31693377c16296c91a1c4aec16|2,4|test")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Reset file names inside torrent :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nRESETTORRENTFILENAME|c1ad55a0ee442e31693377c16296c91a1c4aec16|2")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Rename file inside torrent 3 :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nRENAMETORRENTFILE|c1ad55a0ee442e31693377c16296c91a1c4aec16|2|NewName222.rar")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Reset all file names inside torrent :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nRESETTORRENTFILENAME|c1ad55a0ee442e31693377c16296c91a1c4aec16|ALL")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Change download destination (and rename and move data) :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nSETDOWNDEST|85243bdb86bbf9c111ed17e5e6b64d1abec4992f|c:\\downtest|test4|1|1")
#print "---------------------------------------------------------------"
#sleep(2)
#
##print "Clear Completed Command :"
##sleep(3)
##print wc.sendmesg("ID|" + KEY + "\nDELETE|COMPLETED")
##print "---------------------------------------------------------------"
##sleep(2)
##
#print "Queue ALL Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nQUEUE|ALL")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Stop ALL Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nSTOP|ALL")
#print "---------------------------------------------------------------"
#sleep(2)
#
##print "Delete Command :"
##sleep(3)
##print wc.sendmesg("ID|" + KEY + "\nDELETE|6f482f8fec4a420a5a9b94d02c44199e37226b70")
##print "---------------------------------------------------------------"
##sleep(2)
##
#print "Query only name, %ul/dl, dlsize :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nQUERY|filename,ratio,dlsize")
#print "----------------------------------------------------------------"
#sleep(2)
#
#print "Try Query Error :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nQUERY|filename,error,ratio")
#print "----------------------------------------------------------------"
#sleep(2)
#
#print "Query by name (old style) :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nQUERY|filename,progress,btstatus,eta,dlspeed,ulspeed,ratio,peers,seeds,copies,dlsize,ulsize,peeravgprogress,totalspeed,totalsize")
#print "----------------------------------------------------------------"
#sleep(2)
#
#print "Query by column numbers :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nQUERY|4,5,6,7,8,25")
#print "----------------------------------------------------------------"
#
#print "Queue ALL Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nQUEUE|ALL")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Automatic mode :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nMODEAUTO|")
#print "----------------------------------------------------------------"
#sleep(2)
#
#print "Manual mode :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nMODEMANU|")
#print "----------------------------------------------------------------"
#sleep(2)
#
#print "Automatic mode :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nMODEAUTO|")
#print "----------------------------------------------------------------"
#sleep(2)
#
#print "Reseed Resume Command :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nRESEEDRESUME|85243bdb86bbf9c111ed17e5e6b64d1abec4992f,c1ad55a0ee442e31693377c16296c91a1c4aec16")
#print "---------------------------------------------------------------"
#sleep(2)
#
#print "Stop all traffic :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nSTOPTRAFFIC|")
#print "----------------------------------------------------------------"
#sleep(2)
#
#print "Command scheduler on :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nCOMMANDSCHEDULERON|")
#print "----------------------------------------------------------------"
#sleep(2)
#
#print "Command scheduler off :"
#sleep(3)
#print wc.sendmesg("ID|" + KEY + "\nCOMMANDSCHEDULEROFF|")
#print "----------------------------------------------------------------"
#sleep(2)
