##############################################################################
# Module : webservice.py
# Author :
# Date   :
# Updated and modified for ABC_OKC : Old King Cole
#
# Description : Web service
#
##############################################################################
import sys, wx, socket
from threading import Event

from BitTornado.utility import sysencoding


class WebListener:
    def __init__(self, ip, port, utility):
        self.s = None
        self.port = port
        self.ip = ip
        self.utility = utility
        self.localize = self.utility.lang.get

    def start(self, parent):
        self.window = parent
        self.frame = self.window.parent
        for res in socket.getaddrinfo(self.ip, self.port, socket.AF_UNSPEC, socket.SOCK_STREAM, 0, socket.AI_PASSIVE):
            af, socktype, proto, canonname, sa = res
            try:
                self.s = socket.socket(af, socktype, proto)
            except socket.error, msg:
                self.s = None
                continue
            try:
                self.s.bind(sa)
                self.s.listen(1)
            except socket.error, msg:
                self.s.close()
                self.s = None
                continue
            break
        if self.s is None:
            dlg = wx.MessageDialog(self.frame, self.localize('cantopensocket'),
                                   self.localize('socketerror'), wx.OK | wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            if self.frame.abcwebdlg:
                self.frame.abcwebdlg.actionbtn.SetLabel(self.localize('startservice'))
                self.frame.abcwebdlg.porttext.SetEditable(True)
                self.frame.abcwebdlg.keytext.SetEditable(True)
            self.frame.webserver = None
            self.window.webservicebutton.SetValue(False)
            return
        WebServiceCmd(self).go()
        self.s.close()
        self.s = None


class WebClient:
    def __init__(self, ip, port, utility):
        self.ip = ip
        self.port = port
        self.utility = utility
        self.localize = self.utility.lang.get

    def sendMesg(self, displaywin, mesg):
        s = None
        for res in socket.getaddrinfo(self.ip, self.port, socket.AF_UNSPEC, socket.SOCK_STREAM):
            af, socktype, proto, canonname, sa = res
            try:
                s = socket.socket(af, socktype, proto)
            except socket.error, msg:
                s = None
                continue
            try:
                s.connect(sa)
            except socket.error, msg:
                s.close()
                s = None
                continue
            break
        if s is None:
            dlg = wx.MessageDialog(displaywin, self.localize('cantconnectabcwebinterface'),
                                   self.localize('socketerror'), wx.OK | wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()            
            return False

        s.send(mesg)
        s.recv(1024)
        s.close()
        return True


class WebServiceCmd:
    def __init__(self, parent):
        self.parent = parent
        self.window = self.parent.window
        self.queue = self.window.queue
        self.utility = self.parent.utility
        self.localize = self.utility.lang.get

    def testPermission(self, command, permission, connection):
        if self.utility.webparams[permission] == "0":
            connection.send("Feedback\nError=" + command + ",Permission denied")
            connection.close()
            return False
        return True

    def go(self):
        while True:
            conn, addr = self.parent.s.accept()
            try:
                try:
                    data = conn.recv(5048)
                except:
                    try:
                        conn.close()
                    except:
                        pass
                    continue

                if self.utility.webparams['webcoder'] == '0':
                    webcoder = 'utf_8'
                else:
                    webcoder = sysencoding
                try:
                    data = data.decode(webcoder)
                except:
                    conn.send("Feedback\nError=Can't decode command")
                    conn.close()
                    continue

                try:
                    idline, cmdline = data.split("\n")
                except:
                    conn.send("Feedback\nError=You need unique ID to command ABC!")
                    conn.close()
                    continue

                try:
                    idtag = idline.split("|")
                    idkey = idtag[0]
                    idvalue = idtag[1]
                except:
                    conn.send("Feedback\nError=You need unique ID to command ABC!")
                    conn.close()
                    continue

                if idkey != "ID":
                    conn.send("Feedback\nError=You need unique ID to command ABC!")
                    conn.close()
                    continue
                elif idvalue != self.utility.webparams['webID']:                        
                    conn.send("Feedback\nError=Incorrect unique ID")
                    conn.close()
                    continue

                try:                
                    cmd, info = cmdline.split("|", 1)
                except:
                    # Bad Command
                    conn.send("Feedback\nError=Command should end with |")
                    conn.close()
                    continue

                #sys.stdout.write('Web Request Received.\n' + data + '\n')
                if cmd == "CLOSE":
                    conn.send("Feedback\nOK")
                    conn.close()
                    return

                elif cmd == "QUERY":    #QUERY|   or QUERY|<field1>,..,<field N>
                    if self.testPermission(cmd, 'allow_query', conn):
                        if info == "":
                            self.queue.invokeLater(self.queue.queryAll, [conn])
                        else:
                            self.queue.invokeLater(self.queue.queryField, [info.split(","), conn])

                elif cmd == "ADD":      #ADD|URL
                    if self.testPermission(cmd, 'allow_add', conn):
                        self.queue.invokeLater(self.window.addTorrentURLFromWeb, [info, conn])

                elif cmd == "DELETE":   #DELETE|COMPLETED or DELETE|list(INFO_HASH)
                    if info == "COMPLETED":
                        if self.testPermission(cmd, 'allow_clearcompleted', conn):
                            self.queue.invokeLater(self.window.onClearAllOverFromWeb, [conn])
                    elif self.testPermission(cmd, 'allow_delete', conn):
                        self.queue.invokeLater(self.window.onRemoveFromWeb, [info, conn])

                elif cmd == "RESUME":   #RESUME|ALL or RESUME|list(INFO_HASH)
                    if self.testPermission(cmd, 'allow_resume', conn):
                        if info == "ALL":
                            self.queue.invokeLater(self.window.onResumeAllFromWeb, [conn])
                        else:
                            self.queue.invokeLater(self.window.onResumeFromWeb, [info, conn])

                elif cmd == "RESEEDRESUME":   #RESEEDRESUME|list(INFO_HASH)
                    if self.testPermission(cmd, 'allow_resume', conn):
                        self.queue.invokeLater(self.window.onReseedResumeFromWeb, [info, conn])

                elif cmd == "STOP":   #STOP|ALL or STOP|list(INFO_HASH)
                    if self.testPermission(cmd, 'allow_pause', conn):
                        if info == "ALL":
                            self.queue.invokeLater(self.window.onStopAllFromWeb, [conn])
                        else:
                            self.queue.invokeLater(self.window.onStopFromWeb, [info, conn])

                elif cmd == "PAUSE":   #PAUSE|ALL or PAUSE|list(INFO_HASH)
                    if self.testPermission(cmd, 'allow_onhold', conn):
                        if info == "ALL":
                            self.queue.invokeLater(self.window.onPauseAllFromWeb, [1, conn])
                        else:
                            self.queue.invokeLater(self.window.onPauseFromWeb, [info, conn])

                elif cmd == "UNPAUSE":   #UNPAUSE|ALL or UNPAUSE|list(INFO_HASH)
                    if self.testPermission(cmd, 'allow_resume', conn):
                        if info == "ALL":
                            self.queue.invokeLater(self.window.onPauseAllFromWeb, [0, conn])
                        else:
                            self.queue.invokeLater(self.window.onResumeFromWeb, [info, conn])

                elif cmd == "QUEUE":   #QUEUE|ALL or QUEUE|list(INFO_HASH)
                    if self.testPermission(cmd, 'allow_queue', conn):
                        if info == "ALL":
                            self.queue.invokeLater(self.window.onQueueAllFromWeb, [conn])
                        else:
                            self.queue.invokeLater(self.window.onQueueFromWeb, [info, conn])

                elif cmd == "PRIORITY": #PRIORITY|seq(INFO_HASH,PRIO)
                    if self.testPermission(cmd, 'allow_setprio', conn):
                        priorities = []
                        error = False
                        for field in [t.split(",") for t in info.split("|")]:
                            if len(field) != 2:
                                error = True
                                conn.send("Feedback\nError=Bad arguments")
                                conn.close()
                                break
                            if field[1].isdigit():
                                prio = int(field[1])
                                if prio < 0 or prio > 4:
                                    error = True
                                    conn.send("Feedback\nError=Invalid priority number")
                                    conn.close()
                                    break
                                priorities.append((field[0], prio))
                            else:
                                error = True
                                conn.send("Feedback\nError=Priority is not a number")
                                conn.close()
                                break
                        if not error:
                            self.queue.invokeLater(self.window.onPrioFromWeb, [priorities, conn])

                elif cmd == "VERSION":   #GETVERSION|
                    conn.send("Version\n" + self.utility.encodeWebServiceData(self.localize('version')))
                    conn.close()

                elif cmd == "GETSTRING":   #GETSTRING|string
                    retstring = self.localize(info, warning = False)
                    if retstring is None:
                        retmsg = u'<unknown string>'
                    else:
                        retmsg = retstring
                    conn.send("String\n" + self.utility.encodeWebServiceData(retmsg))
                    conn.close()

                elif cmd == "SETPARAM":   #SETPARAM|seq(param=value)
                    if self.testPermission(cmd, 'allow_setparam', conn):
                        error = False
                        for field in [t.split("=") for t in info.split("|")]:
                            if len(field) != 2:
                                error = True
                                break
                            self.utility.abcparams[field[0]] = field[1]
                        if error:
                            conn.send("Feedback\nError=Bad arguments")
                        else:
                            conn.send("Feedback\nOK")
                        conn.close()

                elif cmd == "GETPARAM":   #GETPARAM|list(param)
                    if self.testPermission(cmd, 'allow_getparam', conn):
                        retmsg = u''
                        for param in info.split(','):
                            if param in self.utility.abcparams:
                                retmsg += self.utility.abcparams[param] + '|'
                            else:
                                retmsg += '<unknown parameter>|'
                        conn.send("Feedback\n" + self.utility.encodeWebServiceData(retmsg[:-1]))
                        conn.close()

                elif cmd == "MODEAUTO":   #MODEAUTO
                    if self.testPermission(cmd, 'allow_pause', conn):
                        self.queue.invokeLater(self.window.onModeToggle, kwargs = {'mode': 1})
                        conn.send("Feedback\nOK")
                        conn.close()

                elif cmd == "MODEMANU":   #MODEMANU
                    if self.testPermission(cmd, 'allow_pause', conn):
                        self.queue.invokeLater(self.window.onModeToggle, kwargs = {'mode': 0})
                        conn.send("Feedback\nOK")
                        conn.close()

                elif cmd == "STOPTRAFFIC":   #STOPTRAFFIC
                    if self.testPermission(cmd, 'allow_pause', conn):
                        self.queue.invokeLater(self.window.onModeToggle, kwargs = {'mode': 0, 'queue': 1})
                        conn.send("Feedback\nOK")
                        conn.close()

                elif cmd == "MOVEUP":   #MOVEUP|list(INFO_HASH)
                    if self.testPermission(cmd, 'allow_move', conn):
                        self.queue.invokeLater(self.window.onMoveUpFromWeb, [info, conn])

                elif cmd == "MOVEDOWN":   #MOVEDOWN|list(INFO_HASH)
                    if self.testPermission(cmd, 'allow_move', conn):
                        self.queue.invokeLater(self.window.onMoveDownFromWeb, [info, conn])

                elif cmd == "MOVETOP":   #MOVETOP|list(INFO_HASH)
                    if self.testPermission(cmd, 'allow_move', conn):
                        self.queue.invokeLater(self.window.onMoveTopFromWeb, [info, conn])

                elif cmd == "MOVEBOTTOM":   #MOVEBOTTOM|list(INFO_HASH)
                    if self.testPermission(cmd, 'allow_move', conn):
                        self.queue.invokeLater(self.window.onMoveBottomFromWeb, [info, conn])

                elif cmd == "MOVEBELOWCOMPLETED":   #MOVEBELOWCOMPLETED|list(INFO_HASH)
                    if self.testPermission(cmd, 'allow_move', conn):
                        self.queue.invokeLater(self.window.onMoveBelowCompletedFromWeb, [info, conn])

                elif cmd == "SUPERSEED":   #SUPERSEED|list(INFO_HASH)
                    if self.testPermission(cmd, 'allow_superseed', conn):
                        self.queue.invokeLater(self.window.onSuperseedFromWeb, [info, conn])

                elif cmd == "CHECK":   #CHECK|list(INFO_HASH)
                    if self.testPermission(cmd, 'allow_resume', conn):
                        self.queue.invokeLater(self.window.onCheckFromWeb, [info, conn])

                elif cmd == "GETTORRENTPARAM":   #GETTORRENTPARAM|INFO_HASH
                    if self.testPermission(cmd, 'allow_gettorparam', conn):
                        self.queue.invokeLater(self.window.onGetTorrentParamFromWeb, [info, conn])

                elif cmd == "SETTORRENTPARAM":   #SETTORRENTPARAM|INFO_HASH|seq(value)
                    if self.testPermission(cmd, 'allow_settorparam', conn):
                        values = info.split("|")
                        if len(values) != 27:
                            conn.send("Feedback\nError=Bad arguments")
                            conn.close()
                        else:
                            self.queue.invokeLater(self.window.onSetTorrentParamFromWeb, [values, conn])

                elif cmd == "SETTORRENTFILEPRIO":   #SETTORRENTFILEPRIO|INFO_HASH|FILE_NUMBER|FILE_PRIORITY
                    if self.testPermission(cmd, 'allow_settorparam', conn):
                        values = info.split("|")
                        if len(values) != 3:
                            conn.send("Feedback\nError=Bad arguments")
                            conn.close()
                        elif not values[1].isdigit():
                            conn.send("Feedback\nError=Invalid file number")
                            conn.close()
                        else:
                            try:
                                prio = int(values[2])
                            except:
                                conn.send("Feedback\nError=Invalid priority number")
                                conn.close()
                                continue
                            if prio < -1 or prio > 2:
                                conn.send("Feedback\nError=Invalid priority number")
                                conn.close()
                            else:
                                self.queue.invokeLater(self.window.onSetTorrentFilePrioFromWeb, [values, conn])

                elif cmd == "RENAME":   #RENAME|INFO_HASH|NEW_TORRENT_NAME|REN_DEST_WITH_TOR
                    if self.testPermission(cmd, 'allow_settorparam', conn):
                        values = info.split("|")
                        if len(values) != 3:
                            conn.send("Feedback\nError=Bad arguments")
                            conn.close()
                        elif not values[2].isdigit():
                            conn.send("Feedback\nError=Invalid ren_dest_with_tor value")
                            conn.close()
                        else:
                            rendestwithtor = int(values[2])
                            if rendestwithtor < 0 or rendestwithtor > 1:
                                conn.send("Feedback\nError=Invalid ren_dest_with_tor value")
                                conn.close()
                            else:
                                self.queue.invokeLater(self.window.onRenameFromWeb, [values, conn])

                elif cmd == "SETDOWNDEST":   #SETDOWNDEST|INFO_HASH|NEW_DOWN_DIR_LOC|NEW_DOWN_NAME|REN_TOR_WITH_DEST|MOVE_DATA
                    if self.testPermission(cmd, 'allow_settorparam', conn):
                        values = info.split("|")
                        if len(values) != 5:
                            conn.send("Feedback\nError=Bad arguments")
                            conn.close()
                        elif not values[3].isdigit():
                            conn.send("Feedback\nError=Invalid ren_tor_with_dest value")
                            conn.close()
                        else:
                            rentorwithdest = int(values[3])
                            if rentorwithdest < 0 or rentorwithdest > 1:
                                conn.send("Feedback\nError=Invalid ren_tor_with_dest value")
                                conn.close()
                            elif not values[4].isdigit():
                                conn.send("Feedback\nError=Invalid move_data value")
                                conn.close()
                            else:
                                movedata = int(values[4])
                                if movedata < 0 or movedata > 1:
                                    conn.send("Feedback\nError=Invalid move_data value")
                                    conn.close()
                                else:
                                    self.queue.invokeLater(self.window.onSetDownDestFromWeb, [values, conn])

                elif cmd == "GETTORRENTDATA":   #GETTORRENTDATA|INFO_HASH|ALL or MAIN or FILES
                    if self.testPermission(cmd, 'allow_gettorparam', conn):
                        values = info.split("|")
                        if len(values) != 2 or (values[1] != 'ALL' and values[1] != 'MAIN' and values[1] != 'FILES'):
                            conn.send("Feedback\nError=Bad arguments")
                            conn.close()
                        else:
                            self.queue.invokeLater(self.window.onGetTorrentDataFromWeb, [values, conn])

                elif cmd == "RENAMETORRENTFILE":   #RENAMETORRENTFILE|INFO_HASH|list(FILE_NUMBER)|NEW_FILE_NAME
                    if self.testPermission(cmd, 'allow_settorparam', conn):
                        values = info.split("|")
                        if len(values) != 3:
                            conn.send("Feedback\nError=Bad arguments")
                            conn.close()
                        else:
                            error = False
                            filenumbers = values[1].split(",")
                            if not filenumbers:
                                error = True
                            else:
                                for n in filenumbers:
                                    if not n.isdigit():
                                        error = True
                                        break
                            if error:
                                conn.send("Feedback\nError=Invalid file number")
                                conn.close()
                            else:
                                self.queue.invokeLater(self.window.onRenameTorrentFileFromWeb, [values, conn])

                elif cmd == "COMMANDSCHEDULERON":   #COMMANDSCHEDULERON
                    if self.testPermission(cmd, 'allow_scheduler', conn):
                        self.queue.invokeLater(self.window.onCommandSchedulerToggle, kwargs = {'status': 1})
                        conn.send("Feedback\nOK")
                        conn.close()

                elif cmd == "COMMANDSCHEDULEROFF":   #COMMANDSCHEDULEROFF
                    if self.testPermission(cmd, 'allow_scheduler', conn):
                        self.queue.invokeLater(self.window.onCommandSchedulerToggle, kwargs = {'status': 0})
                        conn.send("Feedback\nOK")
                        conn.close()

                else: # Bad command
                    conn.send("Feedback\nError=Command not found : " + cmd)
                    conn.close()

            except:
                conn.close()
