##############################################################################
# Module : scrape.py
# Author :
# Date   :
# Updated and modified for ABC_OKC : Old King Cole
#
# Description : Scrape thread
#
##############################################################################
from hashlib import sha1
from urllib import quote
from threading import Thread
from time import clock
from random import shuffle
from urlparse import urlparse
from binascii import b2a_hex

from BitTornado.bencode import bdecode
from BitTornado.zurllib import urlopen, udpurlopen

def toint(s):
    return long(b2a_hex(s), 16)


class ScrapeThread(Thread):
    def __init__(self, queue, torrent, scrapetime, autoscraping = False, standby = False, ctrlscrape = False):
        Thread.__init__(self)
        self.daemon = False
        self.queue = queue
        self.torrent = torrent
        self.utility = self.queue.utility
        self.localize = self.utility.lang.get
        self.autoscraping = autoscraping
        self.standby = standby
        if self.utility.abcparams['ctrlscraperescanstrackers'] == '1':
            self.scanalltrackers = ctrlscrape
        else:
            self.scanalltrackers = not ctrlscrape
        self.extra = self.torrent.exttracker or self.torrent.extrainttracker
        self.scrapetime = scrapetime

        # Build tracker list for scraping
        if self.extra or not self.torrent.multitracker \
           or self.torrent.abcengine and self.torrent.defaulttracker != '':
            self.trackerlist = [self.torrent.getTracker()]
        else:
            self.trackerlist = []
            for tier in self.torrent.getResponse()['announce-list']:
                tier_ = []
                for t in tier:
                    tier_.append(self.utility.decodeString(t))
                if len(tier_) > 1:
                    shuffle(tier_)
                self.trackerlist.extend(tier_)
            if self.torrent.defaulttracker != '' and not self.scanalltrackers:
                for t in self.trackerlist[:]:
                    if t == self.torrent.defaulttracker:
                        self.trackerlist.remove(t)
                self.trackerlist.insert(0, self.torrent.defaulttracker)

    def run(self):
        try:
            currentseed = currentpeer = self.utility.notrackeranswermarker
            status = None

            # Connect scrape at tracker and get data
            # If error put out notrackeranswermarker
            for t in self.trackerlist:
                if self.scrapetime < self.torrent.lastscrapetime:
                    # Another scrape was started after the current one : stop the current one
                    break
                if urlparse(t).scheme == 'udp':
                    try:
                        scrapedata = udpurlopen(t, (2, self.torrent.infohash))
                        if len(scrapedata) < 8:
                            continue
                        cp = toint(scrapedata[16:20])
                        if cp >= 0:
                            currentpeer = str(cp)
                        cs = toint(scrapedata[8:12])
                        if cs >= 0:
                            currentseed = str(cs)
                        status = self.localize('scrapingdone')
                        break
                    except:
                        pass
                else:
                    surl = t[:]
                    lastslash = surl.rfind('/')
                    if lastslash >= 0 and surl[lastslash + 1:lastslash + 9] == 'announce':
                        if surl[-1] == '&':
                            infohashprefix = ''
                        elif '?' in surl[lastslash + 9:]:
                            infohashprefix = '&'
                        else:
                            infohashprefix = '?'
                        surl = surl[:lastslash + 1] + 'scrape' + surl[lastslash + 9:] + infohashprefix + 'info_hash=' + quote(self.torrent.infohash, '')
                        # Connect scrape URL
                        try :
                            h = urlopen(surl)
                            scrapedata = h.read()
                            h.close()
                            scrapedata = bdecode(scrapedata)
                            scrapedata = scrapedata['files']
                            for i in scrapedata.keys():
                                if i == self.torrent.infohash:
                                    cp = scrapedata[i]['incomplete']
                                    if type(cp) == int and cp >= 0:
                                        currentpeer = str(cp)
                                    cs = scrapedata[i]['complete']
                                    if type(cs) == int and cs >= 0:
                                        currentseed = str(cs)
                                    status = self.localize('scrapingdone')
                                    break
                            if status is not None:
                                break
                        except:
                            try:
                                h.close()
                            except:
                                pass

            if status is None:
                status = self.localize('cantgetdatafromtracker')
                trackerok = ''
            else:
                trackerok = t

            # The scrape thread will post an event to update the list with its scraping infos
            self.queue.invokeLater(self.queue.displayScrapeResult, [self.torrent, status, currentseed, currentpeer, self.autoscraping, self.standby, trackerok, self.extra, self.scrapetime])
        except:
            pass
