##############################################################################
# Module : peerdict.py
# Author : Old King Cole
# Date   : 03/06/2009
#
# Description : Dictionary of lists of peers from key infohash
#
##############################################################################
from UserDict import DictMixin
from types import ListType
from random import sample
from time import clock


class PeerDict(DictMixin):
    def __init__(self):
        self.peers = {}

    def __getitem__(self, key):
        val = self.peers[key]
        return ([v[0] for v in val[0]], val[1])

    def __setitem__(self, key, value):
        # Append new value to existing value list
        val = self.peers.get(key)
        if val is None:
            self.peers[key] = [[(value[0], clock())], value[1]]
        else:
            try:
                i = [v[0] for v in val[0]].index(value[0])
            except:
                pass
            else:
                del val[0][i]
            val[0].append((value[0], clock()))
            if value[1]:
                val[1] = True

    def __delitem__(self, key):
        del self.peers[key]

    def keys(self):
        return self.peers.keys()

    def expire(self, t):
        # Delete values older than t for each key
        for k in self.peers.keys():
            p = self.peers[k][0]
            i = 0
            for v in p:
                if v[1] >= t:
                    del p[:i]
                    break
                i += 1
            else:
                del self.peers[k]

    def sample(self, key, n):
        # Return n random peers from key
        p = self.peers[key][0]
        if len(p) > n:
            return [v[0] for v in sample(p, n)]
        else:
            return [v[0] for v in p]
