# Copyright 2002-2003 Andrew Loewenstern, All Rights Reserved
# See khashmir.py for license information
# Updated and modified for ABC_OKC : Old King Cole

import sys
from traceback import format_exception

from BitTornado.bencode import bencode, bdecode
from BitTornado.CurrentRateMeasure import Measure
from defer import Deferred
from expiringdict import ExpiringDict
from actions import Expirer
from const import KRPC_TIMEOUT, KRPC_AGE, KRPC_DELAY

# commands
TID = 't'
REQ = 'q'
RSP = 'r'
TYP = 'y'
ARG = 'a'
ERR = 'e'

# errors
KRPC_ERROR_RECEIVED_UNKNOWN = 1
KRPC_ERROR_TIMEOUT = 2
KRPC_SOCKET_ERROR = 3


class Hostbroker:       
    def __init__(self, server, addr, sock, sched):
        self.server = server
        self.addr = addr
        self.sock = sock
        self.sched = sched
        self.connections = ExpiringDict()
        self.maxuprateperiod = 10.
        Expirer(self.connections, self.sched, KRPC_AGE, KRPC_DELAY, KRPC_DELAY)
        self.uprate = Measure(self.maxuprateperiod)
        self.dhtreqrate = Measure(10.)

    def connectionForAddr(self, addr):
        conn = self.connections.get(addr)
        if conn:
            self.connections.touch(addr)
        else:
            conn = KRPC(addr, self.server, self.sock, self.sched, self)
            self.connections[addr] = conn
        return conn

    def data_came_in(self, datagram, addr):
        c = self.connectionForAddr(addr)
        c.datagramReceived(datagram)

    def connection_lost(self):
        pass

    def connection_flushed(self):
        pass

    def getRawServerParams(self, time, events):
        return 0.01, True


# Connection
class KRPC:
    noisy = 0
    def __init__(self, addr, server, sock, sched, udp):
        self.addr = addr
        self.server = server
        self.utility = server.utility
        self.sock = sock
        self.sched = sched
        self.udp = udp
        self.tids = {}
        self.mtid = 0
        if self.server.ipv6:
            self.compactip = self.server.compactPeerInfo6(self.addr[0], self.addr[1])
        else:
            self.compactip = self.server.compactPeerInfo(self.addr[0], self.addr[1])

    def datagramReceived(self, str):
        # bdecode
        try:
            msg = bdecode(str[:])
        except Exception, e:
            str.release()
            if self.noisy:
                print "Response decode error : " + `e`
        else:
            #print 'RECEIVED MESSAGE FROM', self.addr, ':', msg
            str.release()
            # look at msg type
            if msg[TYP] == REQ:
                #print 'RECEIVED REQUEST FROM', self.addr, ':', msg
                # if request
                # tell server to handle
                if self.udp.dhtreqrate.update_rate(1) <= self.utility.dhtmaxreqrate:
                    f = getattr(self.server, "krpc_" + msg[REQ], None)
                    msg[ARG]['_krpc_sender'] = self.addr
                    if f:
                        try:
                            ret = apply(f, (), msg[ARG])
                        except Exception, e:
                            # error
                            #resp = {TID: msg[TID], TYP: ERR, ERR: [203, `format_exception(type(e), e, sys.exc_info()[2])`]}
                            resp = {TID: msg[TID], TYP: ERR, ERR: [203, 'protocol error']}
                        else:
                            # response
                            resp = {TID: msg[TID], TYP: RSP, RSP: ret}
                    else:
                        # unknown method
                        if self.noisy:
                            print "Don't know about method : %s" % msg[REQ]
                        resp = {TID: msg[TID], TYP: ERR, ERR: [204, 'method unknown : ' + msg[REQ]]}
                    if self.utility.dhtsecurityextension:
                        resp['ip'] = self.compactip
                    self.sendResp(resp)
            elif msg[TYP] == RSP:
                # if response
                if self.tids.has_key(msg[TID]):
                    if self.utility.dhtsecurityextension:
                        try:
                            ipdht = msg['ip']
                        except:
                            pass
                        else:
                            self.server.checkIPDHT(ipdht, self.addr[0])
                    df = self.tids[msg[TID]]
                    # callback
                    df.callback({'rsp': msg[RSP], '_krpc_sender': self.addr})
                    del self.tids[msg[TID]]
                #else:
                    # no tid, this transaction timed out already...
                    #print 'Timeout : ' + `msg[RSP]['id']`
            elif msg[TYP] == ERR:
                # if error
                if self.tids.has_key(msg[TID]):
                    df = self.tids[msg[TID]]
                    # 	callback
                    df.errback(msg[ERR])
                    del self.tids[msg[TID]]
            else:
                # unknown message type
                #print "Unknown message type : " + `msg`
                if self.tids.has_key(msg[TID]):
                    df = self.tids[msg[TID]]
                    # callback
                    df.errback(KRPC_ERROR_RECEIVED_UNKNOWN)
                    del self.tids[msg[TID]]

    def sendResp(self, msg, delay = 0):
        dhtresprate = self.udp.uprate.get_rate()
        if dhtresprate > self.utility.dhtmaxresprate:
            moredelay = (1 - self.utility.dhtmaxresprate / dhtresprate) * self.udp.maxuprateperiod
            delay += moredelay
            if delay <= KRPC_TIMEOUT:
                #print "DELAYING RESPONSE by", moredelay, '; total delay :', delay 
                self.sched(self.sendResp, moredelay, [msg, delay])
        else:
            #print 'RESPONDING TO', self.addr, ':', msg
            encodedmsg = bencode(msg)
            try:
                self.sock.sendto(encodedmsg, 0, self.addr)
            except:
                #print ">>>>>> KRPC_SOCKET_ERROR"
                pass
            else:
                self.udp.uprate.update_rate(len(encodedmsg))

    def timeOut(self, id):
        if self.tids.has_key(id):
            df = self.tids[id]
            #print ">>>>>> KRPC_ERROR_TIMEOUT"
            df.errback(KRPC_ERROR_TIMEOUT)
            del self.tids[id]

    def sendRequest(self, method, args):
        # make message
        # send it
        msg = {TID: chr(self.mtid), TYP: REQ, REQ: method, ARG: args}
        self.mtid = (self.mtid + 1) % 256
        d = Deferred()
        self.tids[msg[TID]] = d
        self.sched(self.sendReq, 0, [msg])
        return d
 
    def sendReq(self, msg):
        mtid = msg[TID]
        encodedmsg = bencode(msg)
        self.sched(self.timeOut, KRPC_TIMEOUT, [mtid])
        #print 'SENDING REQUEST TO', self.addr, ':', msg
        try:
            self.sock.sendto(encodedmsg, 0, self.addr)
        except:
            df = self.tids[mtid]
            #print ">>>>>> KRPC_SOCKET_ERROR"
            df.errback(KRPC_SOCKET_ERROR)
            del self.tids[mtid]
        else:
            self.udp.uprate.update_rate(len(encodedmsg))
