# Copyright 2002-2004 Andrew Loewenstern, All Rights Reserved
# See khashmir.py for license information
# Updated and modified for ABC_OKC : Old King Cole

from node import Node
from const import NULL_ID


class KNodeBase(Node):
    def checkSender(self, dict):
        rsp = dict['rsp']
        try:
            senderid = rsp['id']
        except KeyError:
            #print ">>>> No peer id in response"
            raise Exception, "No peer id in response"
        if self.id != NULL_ID and senderid != self.id:
            #print "Got response from different node than expected"
            self.dht.table.invalidateNode(self)
        else:
            if self.id == NULL_ID:
                self.id = senderid
            self.dht.insertNode(self, contacted = 1)
        try:
            self.dht.tokens[self.id] = rsp['token']
        except:
            pass
        return dict

    def errBack(self, err):
        #print ">>>", err
        return err

    def ping(self, id):
        self.pinging = True
        df = self.dht.udp.connectionForAddr((self.host, self.port)).sendRequest('ping', {"id": id})
        df.addErrback(self.errBack)
        df.addCallback(self.checkSender)
        return df

    def findNode(self, target, id):
        findnodedict = {"target": target, "id": id}
        if self.dht.ipv6:
            findnodedict['want'] = ['n4', 'n6']
        df = self.dht.udp.connectionForAddr((self.host, self.port)).sendRequest('find_node', findnodedict)
        df.addErrback(self.errBack)
        df.addCallback(self.checkSender)
        return df

    def isIPv6(self):
        return (self.host.find(':') >= 0)


class KNodeRead(KNodeBase):
    def valueForKey(self, key, id):
        getpeersdict = {"info_hash": key, "id": id}
        if self.dht.ipv6:
            getpeersdict['want'] = ['n4', 'n6']
        df = self.dht.udp.connectionForAddr((self.host, self.port)).sendRequest('get_peers', getpeersdict)
        df.addErrback(self.errBack)
        df.addCallback(self.checkSender)
        return df


class KNodeWrite(KNodeRead):
    def storeValue(self, key, value, id, token):
        df = self.dht.udp.connectionForAddr((self.host, self.port)).sendRequest('announce_peer', {"info_hash": key, "port": value, "id": id, "token": token})
        df.addErrback(self.errBack)
        df.addCallback(self.checkSender)
        return df
