##############################################################################
# Module : expiringdict.py
# Author : Old King Cole
# Date   : 03/07/2009
#
# Description : Dictionary with expiring keys
#
##############################################################################
from UserDict import DictMixin
from time import clock


class ExpiringDict(DictMixin):
    def __init__(self):
        self.d = {}
        self.keysbyage = []

    def __getitem__(self, key):
        return self.d[key]

    def __setitem__(self, key, value):
        if key in self.d:
            self.removeKeyTime(key)
        self.d[key] = value
        self.keysbyage.append((key, clock()))

    def __delitem__(self, key):
        del self.d[key]
        self.removeKeyTime(key)

    def keys(self):
        return self.d.keys()

    def touch(self, key):
        self.removeKeyTime(key)
        self.keysbyage.append((key, clock()))

    def expire(self, t):
        # Delete values older than t
        i = 0
        for keytime in self.keysbyage:
            if keytime[1] >= t:
                break
            del self.d[keytime[0]]
            i += 1
        del self.keysbyage[:i]

    def removeKeyTime(self, key):
        i = 0
        for keytime in self.keysbyage:
            if keytime[0] == key:
                del self.keysbyage[i]
                break
            i += 1
        
