# Utility to clean up ABC_OKC torrent directory
# Author : Old King Cole
# All torrent files not referred to in torrent.lst are moved from the folder 'torrent' to the folder 'notloaded'
# These torrents are not in torrent.lst and could be deleted
# Argument : <ABC_OKC_user_app_data_path_containing_dir_torrent_and_file_torrent.lst>


from sys import argv, exit, getfilesystemencoding
from os import mkdir, rename
from os.path import exists, join
from shutil import move

sysencoding = getfilesystemencoding()

if len(argv) != 2 or not exists(argv[1]):
    print "Bad argument", argv[1]
    exit()

loaded = join(argv[1], 'loaded')
notloaded = join(argv[1], 'notloaded')
if not exists(loaded):
    try:
        mkdir(loaded)
    except:
        print "Can't create directory", loaded
        exit()

list = join(argv[1], 'torrent.lst')
torfile = []
try:
    torlist = open(list, 'r+')
    linenb = 0
    while True:
        linenb += 1
        configline = torlist.readline()
        if linenb == 1:
            if configline[:3] == '\xef\xbb\xbf':
                encoding = 'utf_8'
                # Skip BOM
                configline = configline[3:]
            else:
                encoding = sysencoding
        if configline == "" or configline == "\n":
            break
        configmap = configline.decode(encoding).split("|")
        size = len(configmap)
        if linenb == 1 and size == 1:
            # Header line : read next line
            linenb += 1
            configline = torlist.readline()
            if configline == "" or configline == "\n":
                break
            configmap = configline.decode(encoding).split("|")
        torfile.append(configmap[1])
    torlist.close()
except:
    print "Can't read", list
    exit()

torrentpath = join(argv[1], 'torrent')
for torrent in torfile:
    torpath = join(torrentpath, torrent)
    if exists(torpath):
        move(torpath, loaded)
        if exists(torpath + '.pri'):
            move(torpath + '.pri', loaded)
        if exists(torpath + '.pro'):
            move(torpath + '.pro', loaded)
        if exists(torpath + '.nam'):
            move(torpath + '.nam', loaded)
        if exists(torpath + '.fns'):
            move(torpath + '.fns', loaded)
        if exists(torpath + '.prs'):
            move(torpath + '.prs', loaded)
rename(torrentpath, notloaded)
rename(loaded, torrentpath)
print "Complete"
print "See directory", notloaded
