##############################################################################
# Module : abctorrent.py
# Author : Old King Cole
# Date   : 10/15/2005
#
# Description : Torrent
#
##############################################################################
import sys, wx

from os import remove, listdir, mkdir, rmdir, renames
from os.path import join, exists, normpath, split, commonprefix, splitdrive, getsize, isdir, isfile
from time import clock, time, localtime, strftime, sleep
from threading import Event, Timer
from binascii import hexlify, unhexlify

from win32file import GetDiskFreeSpaceEx

from utility import FileTree
from Dialogs.filenamescheckresultdlg import FileNamesCheckResultDialog
from Dialogs.filerenamedlg import FileRenDialog

from BitTornado.bencode import bdecode


class ABCTorrent:
    def __init__(self, parent, src, dest, singlefile, status, priority, name,
                 maxupload, maxlocaluploadrate, maxlocaldownloadrate, uploadoption,
                 uploadtimeh, uploadtimem, uploadratio, downsize, upsize, piecelength,
                 totalsize, infohash, progress, seedingtime, totalseedingtime, filesnumber,
                 label, shortlabel, timeoutswitch, timeoutaction, timeoutwork,
                 timeoutworkdown, timeoutworktrack, timeoutseed, timeoutseedup,
                 timeoutseedtrack, timeouttracker, timeoutdownload, timeoutupload,
                 movefolder, exttracker, exttrackerurl, termevt, defaulttracker,
                 private, multitracker, magnet, magnetname, prioritizedown, prioritizeup,
                 checkinttrackwait, extrainttracker, inttrackerurl,
                 inactivitytime, trackererrortime, sbtime, onlygetmetadata, restoreindex, index):
        self.parent = parent
        self.utility = parent.utility
        self.localize = self.utility.lang.get
        self.abcparams = self.utility.abcparams
        self.abcengine = None
        self.src = src
        self.dest = dest
        self.singlefile = singlefile
        self.status = status
        self.priority = priority
        self.name = name
        self.maxupload = maxupload
        self.maxuploadrate = 0.
        self.bdcalcupbase = 0.
        self.maxlocaluploadrate = maxlocaluploadrate
        self.maxdownloadrate = 0.
        self.bdcalcdownbase = 0.
        self.maxlocaldownloadrate = maxlocaldownloadrate
        self.uploadtillcopycomplete, self.uploadoption = divmod(uploadoption, 10)
        self.uploadtimeh = uploadtimeh
        self.uploadtimem = uploadtimem
        self.uploadtimemax = float(uploadtimeh * 3600 + uploadtimem * 60)
        self.uploadratio = uploadratio
        self.detailwin = None
        self.infowin = None
        self.downsize = downsize
        self.upsize = upsize
        # Torrent old status
        self.oldstatus = ""
        # Torrent old status before checking
        self.oldstatusbeforecheck = ""
        self.piecelength = piecelength
        self.totalsize = totalsize
        self.requestedsize = float(totalsize)
        self.infohash = infohash
        self.progress = float(progress)
        self.complete = (progress == "100")
        self.checkedonce = False
        self.scrapedonce = False
        self.seedingtime = seedingtime
        self.totalseedingtime = totalseedingtime
        self.initSeedingTimeLeft()
        self.filesnumber = filesnumber
        self.filespriority = None
        self.filesname = None
        self.label = label
        self.shortlabel = shortlabel
        self.timeoutswitch = timeoutswitch
        self.timeoutaction = timeoutaction
        self.timeoutwork = timeoutwork
        self.timeoutworkdown = timeoutworkdown
        self.timeoutworktrack = timeoutworktrack
        self.timeoutseed = timeoutseed
        self.timeoutseedup = timeoutseedup
        self.timeoutseedtrack = timeoutseedtrack
        self.timeouttracker = timeouttracker
        self.timeoutdownload = timeoutdownload
        self.timeoutupload = timeoutupload
        self.movefolder = movefolder
        self.activity = 0
        self.unwantedfiles = 0
        self.scraping = False
        self.scrapeisfresh = False
        self.exttracker = exttracker
        self.exttrackerurl = exttrackerurl
        self.filesprogress = None
        self.lastpeers = []
        self.lastgetscrape = 0
        self.lastgetscrapemanual = 0
        if self.status == 'standby':
            self.lastabsactivity = self.standbylastscrape = clock()
            self.sbstart = self.lastabsactivity - sbtime
        else:
            self.sbstart = self.standbylastscrape = self.lastabsactivity = 0.
        # sbstart is only used to check standby timeout
        # sbstart is not changed when a standby torrent awakes to try to find sharing
        # opportunities and then returns to standby because it could not find any
        self.termevt = self.prevtermevt = termevt
        self.defaulttracker = defaulttracker
        self.private = private
        self.coltrackernotrunning = self.utility.colnoeng
        self.multitracker = multitracker
        # magnet : 0 : metadata complete ;
        #          1 : metadata not complete ;
        #          2 : metadata not complete and keep dest when turning torrent ;
        self.magnet = magnet
        self.magnetname = magnetname
        self.prioritizedown = prioritizedown
        self.prioritizeup = prioritizeup
        self.checkinttrackwait = checkinttrackwait
        self.extrainttracker = extrainttracker
        self.inttrackerurl = inttrackerurl
        self.inactivitytime = inactivitytime
        self.trackererrortime = trackererrortime
        # List of status for each file name inside torrent, built from 4 bits :
        # 1 : char not fixed ;
        # 2 : too long name in path
        # 3 : too long path
        # 4 : too long destination path
        # None if all files are OK
        self.filenamestatus = None
        # # Seeds and peers seen by tracker and number of complete copies
        self.seed = self.peer = self.utility.notrackeranswermarker
        self.numcopy = '?'
        self.forceseeding = False
        self.message = ''
        # True/False when there's sparse1 background allocation for a torrent without engine, else None
        # Used to toggle background allocation mark and display warning when trying to delete this torrent
        self.ongoing = None
        # Timer for delayed resume when move data option is set to 'When completed'
        self.delayedresumetimer = None
        # True if torrent is moving its data
        self.ismovingdata = False
        # True if torrent is being deleted
        self.isbeingdeleted = False
        # Previous index to undo torrent list sorting
        self.previndex = -1
        # Indexes to save and restore torrent list sorting orders
        self.restoreindex = restoreindex
        # One more place to undo restoring list order 0-9
        self.restoreindexundo = -1
        # Index in torrent list
        self.index = index
        # To keep track of change in uploadtimemax to correct seeding times
        self.olduploadtimemax = self.uploadtimemax
        # If True for a magnet, the torrent will stop when metadata are retrieved
        self.onlygetmetadata = onlygetmetadata

    def displayStatus(self, status = None):
        if self.ismovingdata and status != 'moving':
            return
        if status is None:
            status = self.status
        localizedstatus = self.localize(status)
        rank = self.parent.guiman.getRankfromID(6)
        if rank != -1:
            self.parent.list.SetStringItem(self.index, rank, localizedstatus)
        if self.infowin is not None:
            self.infowin.status.SetLabel(localizedstatus)
        if self.detailwin is not None:
            self.detailwin.status.SetLabel(localizedstatus)

    def displayFinished(self):
        for rank in [self.parent.guiman.getRankfromID(colid) for colid in [8, 14, 15, 16, 17, 20]]:
            if rank != -1:
                self.parent.list.SetStringItem(self.index, rank, "")
        rank = self.parent.guiman.getRankfromID(11)
        if rank != -1:
            self.parent.list.SetStringItem(self.index, rank, self.utility.formatedRate(None, self.prioritizeup)[0])
        rank = self.parent.guiman.getRankfromID(12)
        if rank != -1:
            if self.requestedsize <= 0 and not self.magnet:
                self.parent.list.SetStringItem(self.index, rank, '999.9%')
            elif self.progress <= 0:
                self.parent.list.SetStringItem(self.index, rank, '0.0%')
            else:
                self.parent.list.SetStringItem(self.index, rank, '%.1f' % (float(self.upsize) / self.requestedsize / self.progress * 10000) + "%")
        self.seed = self.peer = self.utility.notrackeranswermarker
        self.numcopy = '?'
        if self.infowin is not None:
            self.infowin.init()
            self.infowin.colour.SetBackgroundColour(self.utility.colnoeng)
            self.infowin.colour.Refresh()
        if self.detailwin is not None:
            self.detailwin.init()
            self.detailwin.colour.SetBackgroundColour(self.utility.colnoeng)
            self.detailwin.colour.Refresh()
            self.detailwin.trackercolour.SetBackgroundColour(self.coltrackernotrunning)
            self.detailwin.trackercolour.Refresh()

    def clearMessage(self, oldmsg = None, rank = None):
        self.displayMessage('', oldmsg = oldmsg, rank = rank)

    def displayMessage(self, msg, oldmsg = None, rank = None, keeptermevtmsg = None, msgindetails = None):
        if rank is None:
            rank = self.parent.guiman.getRankfromID(13)
        if keeptermevtmsg is None:
            keeptermevtmsg = (self.abcparams['keeptermevtmsg'] == '1')
        if not msg and keeptermevtmsg:
            msg = self.termEvtMsg()

        if oldmsg is None or self.message[self.utility.timestamplen + self.utility.messageheaderlen:] == oldmsg:
        # If oldmsg is not None, display msg only if current message ends with oldmsg (without time stamp and header)
            self.message = msg
            if rank != -1:
                self.parent.list.SetStringItem(self.index, rank, msg)
            if self.infowin is not None:
                if msgindetails is None:
                    msgindetails = (self.abcparams['msgindetails'] == "1")
                if msgindetails:
                    if msg or self.abcparams['emptymsgindetails'] == "1":
                        self.infowin.showMessage()
                    else:
                        self.infowin.hideMessage()

    def checkComplete(self, statistics = None):
        # Check if all wanted files of a multifiles torrent are done
        if self.abcengine:
            self.abcengine.reportProgress(statistics)
        for index in xrange(self.filesnumber):
            if (self.filespriority is None or self.filespriority[index] != -1) \
               and (self.filesprogress is None or (self.filesprogress[index] != 'Done'
                                                   and self.filesprogress[index] != '100%')):
                return False
        return True

    def setActivity(self, activity = -1, countextra = False):
        if activity == -1:
            # Just reset times of current activity
            activity = self.activity
        if activity == 1:
            if self.abcengine:
                self.abcengine.timeractivityon = clock()
                if self.activity == 0 and self.status != 'onhold' and self.status != 'pause':
                    if self.status == 'completed':
                        self.parent.torrentinactiveseed -= 1
                        if countextra and self.parent.extratobestoppedmode:
                            self.parent.extratobestoppedseed += 1
                            self.parent.freshactivetorrentsseed.append(self)
                    else:
                        self.parent.torrentinactive -= 1
                        if countextra and self.parent.extratobestoppedmode:
                            self.parent.extratobestopped += 1
                            self.parent.freshactivetorrents.append(self)
        elif activity == 0:
            if self.abcengine:
                self.abcengine.timeractivityoff = clock()
                if self.activity == 1 and self.status != 'onhold' and self.status != 'pause':
                    if self.status == 'completed':
                        self.parent.torrentinactiveseed += 1
                        if countextra and self.parent.extratobestoppedmode:
                            self.parent.extratobestoppedseed -= 1
                    else:
                        self.parent.torrentinactive += 1
                        if countextra and self.parent.extratobestoppedmode:
                            self.parent.extratobestopped -= 1
        activityhaschanged = (activity != self.activity)
        self.activity = activity
        if activityhaschanged:
            rank = self.parent.guiman.getRankfromID(25)
            if rank != -1:
                self.parent.list.SetStringItem(self.index, rank, self.activityMarker())
        return activityhaschanged

    def formatedProgress(self, progress = None):
        if progress is None:
            progress = self.progress
        if progress == -1:
            return '  ?  %' + self.partialMarker()
        progressstring = str(.1 * int(10 * progress))
        if progressstring == '100.0':
            if self.isWaiting() or self.isCheckingOrAllocating() or self.complete:
                return '100%' + self.partialMarker()
            return '99.9%' + self.partialMarker()
        return progressstring + '%' + self.partialMarker()

    def isCheckingOrAllocating(self):
        return self.abcengine and self.abcengine.btstatus.startswith(("init", "checkingexistingdata",
                                                                      "allocatingdiskspace", "movingdata"))

    def isWaiting(self):
        return self.abcengine and self.abcengine.btstatus == "waiting"

    def isBlockedWaiting(self):
        if self.isWaiting():
            self.abcengine.readwaiting.wait()
            return self.abcengine.dow.blockedwaiting or (self.abcengine.dow.storage and self.abcengine.dow.storage.blockedwaiting)
        return False

    def writeFilePriorities(self):
        try:
            prioritiesfile = open(self.src + '.pri', "w")
            prioritiesfile.writelines([str(p) + '\n' for p in self.filespriority])
            prioritiesfile.close()
        except:
            pass

    def readFilePriorities(self, filesinfo):
        try:
            prioritiesfile = open(self.src + '.pri', "r")
        except:
            self.filespriority = None
            self.unwantedfiles = 0
            return
        self.filespriority = []
        i = 0
        while True:
            templine = prioritiesfile.readline()
            if templine == "" or templine == "\n":
                break
            else:
                try:
                    priority = int(templine)
                except:
                    # Corrupted priorities file
                    prioritiesfile.close()
                    self.filespriority = None
                    self.unwantedfiles = 0
                    remove(self.src + '.pri')
                    return
                self.filespriority.append(priority)
                if priority == -1:
                    self.unwantedfiles += 1
                    self.requestedsize -= filesinfo[i]['length']
            i += 1
        prioritiesfile.close()
        if len(self.filespriority) != self.filesnumber:
            # Corrupted priorities file
            self.filespriority = None
            self.unwantedfiles = 0
            remove(self.src + '.pri')

    def writeFileNameStatus(self):
        try:
            fnsfile = open(self.src + '.fns', "w")
            fnsfile.writelines([str(v) + '\n' for v in self.filenamestatus])
            fnsfile.close()
        except:
            pass

    def readFileNameStatus(self):
        try:
            fnsfile = open(self.src + '.fns', "r")
        except:
            self.filenamestatus = None
            return
        self.filenamestatus = []
        i = 0
        while True:
            templine = fnsfile.readline()
            if templine == "" or templine == "\n":
                break
            else:
                try:
                    validity = int(templine)
                except:
                    # Corrupted validities file
                    fnsfile.close()
                    self.filenamestatus = None
                    remove(self.src + '.fns')
                    return
                self.filenamestatus.append(validity)
            i += 1
        fnsfile.close()
        if len(self.filenamestatus) != self.filesnumber:
            # Corrupted validities file
            self.filenamestatus = None
            remove(self.src + '.fns')

    def writeFileNames(self):
        try:
            namesfile = open(self.src + '.nam', "w")
            namesfile.writelines([n.encode('utf_8') + '\n' for n in self.filesname])
            namesfile.close()
        except:
            pass

    def readFileNames(self):
        try:
            namesfile = open(self.src + '.nam', "r")
        except:
            self.filesname = None
            return
        self.filesname = []
        while True:
            templine = namesfile.readline()
            if templine == "" or templine == "\n":
                break
            else:
                try:
                    self.filesname.append(templine[:-1].decode('utf_8'))
                except:
                    # Corrupted names file
                    namesfile.close()
                    self.filesname = None
                    remove(self.src + '.nam')
                    return
        namesfile.close()
        if len(self.filesname) != self.filesnumber:
            # Corrupted names file
            self.filesname = None
            remove(self.src + '.nam')

    def changeFilePriorities(self, newpriorities, index, filesinfo = None):
        if filesinfo is None:
            filesinfo = self.getResponse()['info']['files']
        updatenever = False
        if self.filespriority is None:
            self.filespriority = self.filesnumber * [1]

        # Update new priorities
        for p in newpriorities:
            if not updatenever and (self.filespriority[p[0]] == -1 or p[1] == -1):
                updatenever = True
            self.filespriority[p[0]] = p[1]
            if self.infowin is not None:
                self.infowin.updateFilePriority(p)
        if self.abcengine:
            self.abcengine.dow.setPriorities(self.filespriority)

        if updatenever:
            # If pool of "Never download" files has changed
            self.requestedsize = 0.
            self.unwantedfiles = 0
            downedbynotneversize = 0.
            refreshprogress = False
            for i in xrange(self.filesnumber):
                if self.filespriority[i] == -1:
                    self.unwantedfiles += 1
                    if self.filesprogress is not None:
                        self.filesprogress[i] = '0'
                        refreshprogress = True
                else:
                    self.requestedsize += filesinfo[i]['length']
                    if self.filesprogress is not None:
                        fileprogressstr = self.filesprogress[i]
                        if fileprogressstr == 'Done':
                            fileprogress = 100.
                        else:
                            fileprogress = float(fileprogressstr)
                    else:
                        fileprogress = 0.
                    downedbynotneversize += filesinfo[i]['length'] * fileprogress / 100.
            if self.infowin is not None and refreshprogress:
                self.infowin.refreshFileProgress()

            sizerank = self.parent.guiman.getRankfromID(9)
            if sizerank != -1:
                self.parent.list.SetStringItem(index, sizerank, self.utility.formatedSize(self.requestedsize)[0])

            oldcomplete = self.complete
            self.complete = self.checkComplete()
            if self.abcengine:
                self.abcengine.btcomplete = self.complete

            if self.abcengine and self.status != 'pause' and self.status != 'onhold':
                # Check for torrents switching from seeding to working
                # Check for ending forcerunning status in BitTornado
                if not self.unwantedfiles and self.abcengine.dow.forcerunning:
                    self.abcengine.dow.forcerunning = False
                    self.abcengine.dow._finished()
                elif not self.complete and oldcomplete:
                    self.abcengine.stopSeedingTimers()
                    self.status = self.abcengine.btstatus = 'working'
                    self.abcengine.fin = False
                    self.abcengine.lasttorrentactive = clock()
                    self.termevt = self.prevtermevt = ''
                    self.parent.torrentavailable -= 1
                    self.parent.torrentseeding -= 1
                    self.parent.torrentdownloading += 1
                    if not self.abcengine.sbwaitingforleechers:
                        self.parent.currentproc += 1
                        self.parent.currentprocseed -= 1
                        if not self.activity:
                            self.parent.torrentinactive += 1
                            self.parent.torrentinactiveseed -= 1
                    if self.abcengine.networkdisconnected > 1:
                        self.abcengine.networkdisconnected = 1
                    self.parent.updateRunningTorrentCounters()

                    if self.exttracker:
                        if self.utility.checkinttrack == 1:
                            if self.checkinttrackwait:
                                self.abcengine.checkinginttrack = True
                                self.switchTracker(0)
                            else:
                                self.switchTrackerExternal()
                        else:
                            self.reannounce(force = True)
                    else:
                        self.reannounce(force = True)

                if self.infowin is not None:
                    self.infowin.updateSize()
                    if self.abcengine.statistics is not None:
                        self.abcengine.statistics.filelistupdated.set()
            else:
                # Compute new progress according to files not set to "Never download"
                if self.requestedsize:
                    self.progress = downedbynotneversize / self.requestedsize * 100.
                    if self.progress > 100.:
                        self.progress = 100.
                    elif self.progress < 0.:
                        self.progress = 0.
                else:
                    self.progress = 100.

                # Check new status for paused torrent
                if self.abcengine:
                    if not self.complete and oldcomplete:
                        self.abcengine.fin = False
                        self.termevt = self.prevtermevt = ''
                        self.parent.torrentavailable -= 1
                        if not self.abcengine.sbwaitingforleechers:
                            self.parent.currentproc += 1
                            self.parent.currentprocseed -= 1
                        self.parent.updateRunningTorrentCounters()
                # Check new status for not running torrent
                elif self.status == 'standby':
                    if self.complete and not oldcomplete:
                        if self.utility.countsbasseed \
                           and (self.uploadoption == 1 or self.uploadoption == 3) \
                           and self.abcparams['mode'] == '1':
                            self.initStandbySeedingTime(clock())
                        self.termevt = self.prevtermevt = time()
                        self.displayMessage(self.termEvtMsg())
                        self.parent.torrentavailable += 1
                    elif not self.complete and oldcomplete:
                        self.termevt = self.prevtermevt = ''
                        self.parent.torrentavailable -= 1
                    self.parent.updateRunningTorrentCounters()
                elif self.status == 'stop' and self.complete:
                    ################
                    # Torrent has turned completed or finished
                    # if (self.uploadoption == 1 or self.uploadoption == 3) and self.seedingtimeleft == 0 \
                       # or (self.uploadoption == 2 or self.uploadoption == 3) and self.ratioIsReached():
                        # self.status = 'finished'
                        # self.parent.torrentfinished += 1
                    # else:
                        # self.status = 'completed'
                    ################
                    # Torrent has turned completed
                    # It will possibly turn finished when it's started
                    self.status = 'completed'
                    ################
                    self.displayStatus()
                    self.termevt = self.prevtermevt = time()
                    self.displayMessage(self.termEvtMsg())
                    self.parent.torrentavailable += 1
                    self.parent.updateRunningTorrentCounters()
                elif (self.status == 'completed' or self.status == 'finished') and not self.complete:
                    # Torrent has turned stopped
                    if self.status == 'finished':
                        self.parent.torrentfinished -= 1
                    self.status = 'stop'
                    self.displayStatus()
                    self.termevt = self.prevtermevt = ''
                    self.parent.torrentavailable -= 1
                    self.parent.updateRunningTorrentCounters()
                elif self.status == 'queue':
                    if self.complete and not oldcomplete:
                        self.termevt = self.prevtermevt = time()
                        self.displayMessage(self.termEvtMsg())
                        self.parent.torrentavailable += 1
                    elif not self.complete and oldcomplete:
                        self.termevt = self.prevtermevt = ''
                        self.parent.torrentavailable -= 1
                    self.parent.scheduler(True)

                progress = self.formatedProgress()
                if self.infowin is not None:
                    self.infowin.updateSize()
                    self.infowin.totalprogress.SetLabel(progress)
                if self.detailwin is not None:
                    self.detailwin.totalprogress.SetLabel(progress)
                progressrank = self.parent.guiman.getRankfromID(5)
                if progressrank != -1:
                    self.parent.list.SetStringItem(index, progressrank, progress)

                if self.abcparams['keepeta'] == "1":
                    # Display ETA
                    etarank = self.parent.guiman.getRankfromID(8)
                    if etarank != -1:
                        if self.status == 'finished':
                            self.parent.list.SetStringItem(index, etarank, "")
                        elif self.complete:
                            if self.uploadoption == 0:
                                self.parent.list.SetStringItem(index, etarank, self.localize('etaS') + "     oo")
                            elif self.uploadoption == 2:
                                self.parent.list.SetStringItem(index, etarank, self.localize('etaS') + "      ?")
                            else:
                                self.parent.list.SetStringItem(index, etarank, self.localize('etaS') + " " + self.utility.eta_value(self.seedingtimeleft))
                        else:
                            self.parent.list.SetStringItem(index, etarank, self.localize('etaD') + "      ?")

        # Write priorities to disk
        for i in xrange(self.filesnumber):
            if self.filespriority[i] != 1:
                break
        if self.filespriority[i] == 1:
            self.filespriority = None
            try:
                remove(self.src + '.pri')
            except:
                pass
        else:
            self.writeFilePriorities()

    def getResponse(self):
        if self.abcengine:
            metainfo = self.abcengine.dow.getResponse()
            return metainfo
        try:
            metainfo_file = open(self.src, 'rb')
            metainfo = bdecode(metainfo_file.read(), sloppy = 1)
        except:
            metainfo = None
        try:
            metainfo_file.close()
        except:
            pass
        return metainfo

    def getFinalDest(self):
        return join(self.utility.completePath(self.movefolder), self.name)

    def canWriteToDisk(self, nexttobeallocated):
        drive = splitdrive(self.utility.completePath(self.dest))[0]
        try:
            freespace = GetDiskFreeSpaceEx(drive + '\\')[0]
        except:
            return False, self.localize('error') + ' : ' + self.localize('cantaccessdisk')
        if freespace < 1048576 * int(self.abcparams['diskfullth']) + nexttobeallocated:
            return False, self.localize('error') + ' : ' + self.localize('diskfull') + ' (' + drive + ')'
        else:
            return True, ''

    def partialMarker(self):
        if self.unwantedfiles:
            return self.utility.partialmarker
        return ''

    def activityMarker(self):
        if self.activity == 1:
            return self.utility.activitymarker
        if self.activity == 2:
            return self.utility.standbymarker
        return self.utility.inactivitymarker

    def writeFileProgress(self):
        if self.filesprogress is not None:
            # Save progress in file
            try:
                progressfile = open(self.src + '.pro', "w")
                progressfile.writelines([p + '\n' for p in self.filesprogress])
                progressfile.close()
            except:
                pass

    def readFileProgress(self):
        try:
            progressfile = open(self.src + '.pro', "r")
        except:
            self.filesprogress = None
        else:
            self.filesprogress = []
            while True:
                templine = progressfile.readline()
                if templine == "" or templine == "\n":
                    break
                else:
                    self.filesprogress.append(templine[:-1].rstrip('%'))
                    # Drop '%' last character to match old format
            progressfile.close()
            if len(self.filesprogress) != self.filesnumber:
                # Corrupted progress file
                self.filesprogress = None
                remove(self.src + '.pro')

    def writePeers(self):
        if not self.lastpeers:
            return
        try:
            peersfile = open(self.src + '.prs', "w")
        except:
            return
        encodedpeers = []
        for host, port in self.lastpeers:
            if ':' in host:
                encodedpeers.append(''.join([host[i:i + 4] for i in xrange(0, 40, 5)]) \
                                    + hexlify(chr((port & 0xFF00) >> 8) + chr(port & 0xFF)))
            else:
                encodedpeers.append(hexlify(''.join([chr(int(i)) for i in host.split('.')]) \
                                    + chr((port & 0xFF00) >> 8) + chr(port & 0xFF)))
        peersfile.writelines([p.encode('utf_8') + '\n' for p in encodedpeers])
        peersfile.close()

    def readPeers(self):
        try:
            peersfile = open(self.src + '.prs', "r")
        except:
            return
        while True:
            templine = peersfile.readline()
            if templine == "" or templine == "\n":
                break
            try:
                peer = templine[:-1].decode('utf_8')
                if self.utility.ipv6enabled:
                    if len(peer) == 36:
                        port = unhexlify(peer[32:])
                        peer = (':'.join([peer[i:i + 4] for i in xrange(0, 32, 4)]), (ord(port[0]) << 8) + ord(port[1]))
                    else:
                        continue
                elif len(peer) == 12:
                    peer = unhexlify(peer)
                    peer = ('.'.join([str(ord(peer[i])) for i in xrange(4)]), (ord(peer[4]) << 8) + ord(peer[5]))
                else:
                    continue
                self.lastpeers.append(peer)
            except:
                continue
        peersfile.close()

    def updateName(self, name):
        # Update torrent name
        self.name = name
        # Update name in list
        rank = self.parent.guiman.getRankfromID(4)
        if rank != -1:
            self.parent.list.SetStringItem(self.index, rank, name)
        # Update name in details and advanced details windows
        if self.infowin is not None:
            self.infowin.updateTorrentName()
        if self.detailwin is not None:
            self.detailwin.updateTorrentName()

    def updateDestination(self, dest):
        self.dest = dest
        rank = self.parent.guiman.getRankfromID(26)
        if rank != -1:
            if self.magnet == 1:
                self.parent.list.SetStringItem(self.index, rank, join(split(dest)[0], self.localize('notorrentinfo')))
            else:
                self.parent.list.SetStringItem(self.index, rank, dest)
        if self.infowin is not None:
            self.infowin.updateDestination()

    def destIsMove(self):
        # True if dest folder is the same as move folder
        return (normpath(self.utility.completePath(self.movefolder)).lower() == normpath(split(self.utility.completePath(self.dest))[0]).lower())

    def ratioIsReached(self):
        if self.abcengine:
            return (self.abcengine.shareratio >= self.uploadratio)
        if self.requestedsize <= 0:
            shareratio = 999.9
        elif self.progress <= 0:
            shareratio = 0.
        else:
            shareratio = float(self.upsize) / self.requestedsize / self.progress * 10000
        return shareratio >= self.uploadratio

    def getOriginalFileNames(self, filesinfo):
        filesname = []
        for f in filesinfo:
            filename = u''
            if f.has_key('path.utf-8'):
                pathkey = 'path.utf-8'
            else:
                pathkey = 'path'
            for item in f[pathkey]:
                filename = join(filename, self.utility.decodeString(item))
            filesname.append(filename)
        return filesname

    def getFileNames(self, filesinfo = None):
        if self.filesname is None:
            if filesinfo is None:
                filesinfo = self.getResponse()['info']['files']
            return self.getOriginalFileNames(filesinfo)
        return self.filesname

    def deleteUnwanted(self):
        # Delete unwanted files and dir tree for a stopped multifile torrent
        if not self.unwantedfiles:
            return
        removedest = self.utility.completePath(self.dest)
        parentdir = split(removedest)[0]
        i = 0
        for filename in self.getFileNames():
            if self.filespriority[i] == -1:
                destname = join(removedest, filename)
                try:
                    remove(destname)
                except:
                    pass
                dir = split(destname)[0]
                try:
                    while not listdir(dir) and dir != parentdir:
                        rmdir(dir)
                        dir = split(dir)[0]
                except:
                    pass
            i += 1

    def resetFileNameStatus(self, files = None, mask = 31):
        # Reset bit of file name status for files according to mask
        if files is None:
            files = xrange(self.filesnumber)
        if self.filenamestatus:
            for i in files:
                self.filenamestatus[i] &= ~mask
            if any(self.filenamestatus):
                self.writeFileNameStatus()
            else:
                self.filenamestatus = None
                try:
                    remove(self.src + '.fns')
                except:
                    pass
            if self.infowin is not None:
                self.infowin.displayFileNameStatus(files)

    def setAllFileNameStatus(self, status, mask = 31):
        # Set bit of file name status for all files according to mask and from status
        if self.filenamestatus:
            statusexists = True
        else:
            statusexists = False
            self.filenamestatus = self.filesnumber * [0]
        for i in xrange(self.filesnumber):
            if status[i]:
                self.filenamestatus[i] |= mask
            else:
                self.filenamestatus[i] &= ~mask
        if any(self.filenamestatus):
            self.writeFileNameStatus()
        else:
            self.filenamestatus = None
            if statusexists:
                try:
                    remove(self.src + '.fns')
                except:
                    pass
        if self.infowin is not None:
            self.infowin.displayFileNameStatus(range(self.filesnumber))

    def renameFiles(self, files, filesname, newname = None, filesinfo = None, caller = ''):
        # Note that when called from abcmetainfoframe/Rename, newname is None because it is
        # manually entered after checking if there's really something to rename
        if filesinfo is None:
            filesinfo = self.getResponse()['info']['files']
        if len(files) == 1:
            editable = filesname[files[0]]
            editablelength = len(editable)
            editablefordialog = editable
            fixedlength = None
        else:
            cp = split(commonprefix([filesname[i].lower() for i in files]))[0]
            editablelength = len(cp)
            editable = filesname[files[0]][:editablelength]
            if editable:
                editablefordialog = editable + '\\'
            else:
                editablefordialog = ''
            # Length of the part of the longest file name among selected files which is behind editablefordialog
            # This number will not change while editing ; It is used to compute the max path length inside the torrent
            fixedlength = max([len(filesname[i]) for i in files]) - len(editablefordialog)

        if newname is None:
            dialog = FileRenDialog(self.infowin, -1, editablefordialog, self.utility.completePath(self.dest), fixedlength)
            result = dialog.ShowModal()
            edited = dialog.editfilepath.GetValue()
            self.abcparams['renfilew'] = str(dialog.GetSizeTuple()[0])
            dialog.Destroy()
        else:
            result = wx.ID_OK
            edited = newname

        if result != wx.ID_OK:
            return 'Nothing to rename'

        # Check if path is relative
        if not self.utility.isPathRelative(edited):
            if caller != 'web':
                dlg = wx.MessageDialog(self.infowin, self.localize('errorfilerenamerelative'),
                                       self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
            return 'The new path must be relative'

        if len(files) > 1 and edited:
            edited = edited.rstrip('\\')
        if edited == editable:
            return ''
        if len(files) == 1 and not split(edited)[1]:
            if caller != 'web':
                dlg = wx.MessageDialog(self.infowin, self.localize('errorfilerenameempty'),
                                       self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
            return 'The new file name is empty'

        # Check that file or folder name is valid
        completedest = self.utility.completePath(self.dest)
        if caller == 'web':
            parent = None
        else:
            parent = self.infowin
        if not self.utility.checkWinPath(parent, join(completedest, edited), checklength = False):
            return 'Invalid path name'

        # Check for file and folder name conflicts
        errorfileconflict = False
        # Accept new name if it differs only by the case
        if edited.lower() != editable.lower():
            filetree = FileTree(filesname, self.dest, self.utility)
            for i in files:
                if edited:
                    if editablelength:
                        newname = edited + filesname[i][editablelength:]
                    else:
                        newname = edited + '\\' + filesname[i]
                else:
                    newname = filesname[i][editablelength + 1:]
                if filetree.hasDir(newname):
                    errorfileconflict = True
                    break
                item = newname
                while item:
                    if filetree.hasFile(item):
                        errorfileconflict = True
                        break
                    item = split(item)[0]
                if errorfileconflict:
                    break
        if errorfileconflict:
            if caller != 'web':
                dlg = wx.MessageDialog(self.infowin, self.localize('errorfileconflict'),
                                       self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
            return 'Some of the new path names already exist'

        # Rename files and folders
        errortoolongname = []
        errortoolongpath = []
        errortoolongdest = []
        filesoktoberenamed = []
        newnames = []
        destlen = len(completedest)
        for i in files:
            if edited:
                if editablelength:
                    newname = edited + filesname[i][editablelength:]
                else:
                    newname = edited + '\\' + filesname[i]
            else:
                newname = filesname[i][editablelength + 1:]

            errortoolongname.append(len(split(newname)[1]) > self.utility.filenamemaxlength)
            errortoolongpath.append(len(newname) > self.utility.filepathmaxlength or len(split(newname)[0]) > self.utility.pathmaxlength - 3)
            errortoolongdest.append(len(newname) + destlen >= self.utility.filepathmaxlength or len(split(newname)[0]) + destlen >= self.utility.pathmaxlength)

            # Renaming must not set a correct name to an error status
            # But a name already in error may be renamed with an error
            if errortoolongname[-1] and (self.filenamestatus is None or not self.filenamestatus[i] & 2) or \
               errortoolongpath[-1] and (self.filenamestatus is None or not self.filenamestatus[i] & 4) or \
               errortoolongdest[-1] and (self.filenamestatus is None or not self.filenamestatus[i] & 8):
                continue

            if self.filenamestatus is not None:
                if not errortoolongname[-1]:
                    self.filenamestatus[i] &= ~2
                if not errortoolongpath[-1]:
                    self.filenamestatus[i] &= ~4
                if not errortoolongdest[-1]:
                    self.filenamestatus[i] &= ~8

            filesoktoberenamed.append(i)
            newnames.append(newname)

        errormessage = []
        returnmessage = []
        if any(errortoolongname):
            if caller != 'web':
                errormessage.append(self.localize('errortoolongname'))
            returnmessage.append('Too long file name')
        if any(errortoolongpath):
            if caller != 'web':
                errormessage.append(self.localize('errortoolongpath'))
            returnmessage.append('Too long path name')
        if any(errortoolongdest):
            if caller != 'web':
                errormessage.append(self.localize('errortoolongdest'))
            returnmessage.append('Too long destination path name')
        if errormessage:
            dlg = wx.MessageDialog(self.infowin, '\n'.join(errormessage),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()

        status = self.renameData(filesname, filesoktoberenamed, newnames, caller = caller)
        if status:
            returnmessage.append(status)

        if self.filenamestatus:
            if any(self.filenamestatus):
                self.writeFileNameStatus()
            else:
                self.filenamestatus = None
                try:
                    remove(self.src + '.fns')
                except:
                    pass
        if self.infowin is not None:
            self.infowin.displayFileNameStatus(filesoktoberenamed)

        if filesname == self.getOriginalFileNames(filesinfo):
            if self.filesname is not None:
                self.filesname = None
                try:
                    remove(self.src + '.nam')
                except:
                    pass
        else:
            self.filesname = filesname
            self.writeFileNames()

        return ' ; '.join(returnmessage)

    def renameData(self, filesname, files, newnames, caller = ''):
        # Rename files in torrent and already received data
        destfolder = self.utility.completePath(self.dest)
        error = False
        # To prevent renames from deleting destination root if empty
        dummyname = self.utility.findUniqueFileName(join(split(destfolder)[0], 'dummy'), src = 'dum')
        if dummyname is None:
            error = True
        else:
            try:
                file(dummyname, 'w').close()
            except:
                error = True
            else:
                for f in xrange(len(files)):
                    oldname = join(destfolder, filesname[files[f]])
                    filesname[files[f]] = newnames[f]
                    newname = join(destfolder, newnames[f])
                    if newname != oldname and exists(oldname):
                        try:
                            renames(oldname, newname)
                        except:
                            error = True
            try:
                remove(dummyname)
            except:
                pass
        if error:
            if caller != 'web':
                dlg = wx.MessageDialog(self.infowin, self.localize('errordatarename'),
                                       self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
            return 'Unable to rename some already received data'

    def checkForReseed(self):
        # Test if a torrent has all its files downloaded and with the right size
        # so that reseed may or may not be started
        if not self.complete:
            return False
        if self.singlefile:
            dest = self.utility.completePath(self.dest)
            if not exists(dest) or isdir(dest) or getsize(dest) != self.totalsize:
                return False
        else:
            filesizes = []
            try:
                filesinfo = self.getResponse()['info']['files']
            except:
                return False
            for info in filesinfo:
                filesizes.append(info['length'])
            i = 0
            for f in self.getFileNames(filesinfo):
                f = join(self.utility.completePath(self.dest), f)
                if not exists(f) or isdir(f) or getsize(f) != filesizes[i]:
                    return False
                i += 1
        return True

    def updateLimiters(self, value):
        # Update connections limiters counters by value
        if self.label not in self.parent.templates:
            # To deal with torrents with template labels not in templates
            return False
        templimiters = self.parent.templates[self.label].conlimiters
        if self.complete and not self.unwantedfiles:
            # Seeding
            for limiter in templimiters:
                conlimiter = self.parent.conlimiters[limiter]
                conlimiter.nbseeding += value
                if conlimiter.nbseeding < 0:
                    conlimiter.nbseeding = 0
                #print self.name, ':', self.label, ':', limiter, ': s =', conlimiter.nbseeding, ': w =', conlimiter.nbworking, ': o =', conlimiter.nbseeding + conlimiter.nbworking
        else:
            # Working
            for limiter in templimiters:
                conlimiter = self.parent.conlimiters[limiter]
                conlimiter.nbworking += value
                if conlimiter.nbworking < 0:
                    conlimiter.nbworking = 0
                #print self.name, ':', self.label, ':', limiter, ': s =', conlimiter.nbseeding, ': w =', conlimiter.nbworking, ': o =', conlimiter.nbseeding + conlimiter.nbworking
        #if templimiters:
        #    return True
        #return False

    def applyRealCompleteStatusToLimiters(self):
        # A not partial torrent that was declared as complete before starting up is first counted as seeding in the limiters counters.
        # This is done this way because always counting the torrents as "working" at start up in the limiters counters would have a consequence on
        # when the max of working would be reached, and it could trigger torrents from other templates farther in the list.
        # But when the checking at starting up fails meaning that the torrent was in fact uncomplete, the counters must be updated.
        # The contrary is also true : A not partial torrent started as uncomplete can reveal complete after a check ; counters must be updated here too.
        if not self.unwantedfiles:
            # Resync connections limiters counters
            if self.label not in self.parent.templates:
                return
            templimiters = self.parent.templates[self.label].conlimiters
            if self.abcengine.btcomplete:
                if not self.complete:
                    for limiter in templimiters:
                        conlimiter = self.parent.conlimiters[limiter]
                        conlimiter.nbseeding += 1
                        conlimiter.nbworking -= 1
                        if conlimiter.nbworking < 0:
                            conlimiter.nbworking = 0
                        #print self.name, ':', self.label, ':', limiter, ': s =', conlimiter.nbseeding, ': w =', conlimiter.nbworking, ': o =', conlimiter.nbseeding + conlimiter.nbworking
            elif self.complete:
                for limiter in templimiters:
                    conlimiter = self.parent.conlimiters[limiter]
                    conlimiter.nbseeding -= 1
                    if conlimiter.nbseeding < 0:
                        conlimiter.nbseeding = 0
                    conlimiter.nbworking += 1
                    #print self.name, ':', self.label, ':', limiter, ': s =', conlimiter.nbseeding, ': w =', conlimiter.nbworking, ': o =', conlimiter.nbseeding + conlimiter.nbworking

    def updateLimitersWhenSeeding(self):
        # Update connections limiters when the torrent turns seeding
        if self.unwantedfiles or self.label not in self.parent.templates:
            return
        templimiters = self.parent.templates[self.label].conlimiters
        for limiter in templimiters:
            conlimiter = self.parent.conlimiters[limiter]
            conlimiter.nbworking -= 1
            if conlimiter.nbworking < 0:
                conlimiter.nbworking = 0
            conlimiter.nbseeding += 1
            #print self.name, ':', self.label, ':', limiter, ': s =', conlimiter.nbseeding, ': w =', conlimiter.nbworking, ': o =', conlimiter.nbseeding + conlimiter.nbworking

    def isNotLimited(self):
        # Returns True if not limited by connections limiters
        if self.label not in self.parent.templates:
            return True
        templimiters = self.parent.templates[self.label].conlimiters
        # Check number of connected
        for limiter in templimiters:
            conlimiter = self.parent.conlimiters[limiter]
            if conlimiter.maxoverall and conlimiter.nbseeding + conlimiter.nbworking >= conlimiter.maxoverall:
                return False
        # Check number of seeding and working
        if self.complete and not self.unwantedfiles:
            for limiter in templimiters:
                conlimiter = self.parent.conlimiters[limiter]
                if conlimiter.maxseeding and conlimiter.nbseeding >= conlimiter.maxseeding:
                    return False
        else:
            for limiter in templimiters:
                conlimiter = self.parent.conlimiters[limiter]
                if conlimiter.maxworking and conlimiter.nbworking >= conlimiter.maxworking:
                    return False
            # Check number of completed prevented from seeding (locked completed)
            # A locked completed is a completed torrent limited by the same limiters as the current torrent
            # and with a greater priority than the torrent's one, and that could not be started because
            # it was limited in upload (that is the number of seeds of one of its limiters had reached its max seeding value)
            if self.abcparams['lockedcompletedcheck'] == '1':
                sbqueued = (self.abcparams['sbqueued'] == '1')
                torindex = self.index
                self.parent.conlimitermanager.resetLockedCompletedCounters()
                for i in xrange(len(self.parent.proctab)):
                    t = self.parent.proctab[i]
                    if t.complete and not t.unwantedfiles \
                       and (t.status == 'queue' or sbqueued and t.status == 'standby') \
                       and (i < torindex and t.priority <= self.priority or i > torindex and t.priority < self.priority) \
                       and t.label in self.parent.templates:
                        templims = self.parent.templates[t.label].conlimiters
                        for limiter in templims:
                            conlimiter = self.parent.conlimiters[limiter]
                            if limiter in templimiters and conlimiter.maxseeding and conlimiter.nbseeding >= conlimiter.maxseeding:
                                conlimiter.nblockedcompleted += 1
                lockedcompletedmax = int(self.abcparams['lockedcompletedmax'])
                for limiter in templimiters:
                    conlimiter = self.parent.conlimiters[limiter]
                    if conlimiter.nblockedcompleted >= lockedcompletedmax:
                        return False
        return True

    def isOverSeedingLimit(self):
        # Returns True is torrent connections counters are over the max of seeding for at least one limiter
        if self.unwantedfiles or not self.complete or self.label not in self.parent.templates:
            return False
        templimiters = self.parent.templates[self.label].conlimiters
        for limiter in templimiters:
            conlimiter = self.parent.conlimiters[limiter]
            if conlimiter.maxseeding and conlimiter.nbseeding > conlimiter.maxseeding:
                return True
        return False

    def isOverDownloadingLimit(self):
        # Returns True is torrent connections counters are over the max of downloading for at least one limiter
        if self.label not in self.parent.templates:
            return False
        templimiters = self.parent.templates[self.label].conlimiters
        for limiter in templimiters:
            conlimiter = self.parent.conlimiters[limiter]
            if conlimiter.maxworking and conlimiter.nbworking > conlimiter.maxworking:
                return True
        return False

    def updateScrapeData(self, seed, peer, autoscraping, message, oldmsg = None):
        self.scrapeisfresh = True
        self.scrapedonce = True
        if autoscraping and seed == self.utility.notrackeranswermarker:
            return

        if not seed:
            seed = self.utility.notrackeranswermarker
        self.seed = seed
        if self.abcengine:
            newseed = self.abcengine.numseedtext[:self.abcengine.numseedtext.index('(') + 1] + seed + ')'
        else:
            newseed = '0 (' + seed + ')'

        if not peer:
            peer = self.utility.notrackeranswermarker
        self.peer = peer
        if self.abcengine:
            newpeer = self.abcengine.numpeertext[:self.abcengine.numpeertext.index('(') + 1] + peer + ')'
        else:
            newpeer = '0 (' + peer + ')'

        rank = self.parent.guiman.getRankfromID(14)
        if rank != -1:
            self.parent.list.SetStringItem(self.index, rank, newseed)
        rank = self.parent.guiman.getRankfromID(15)
        if rank != -1:
            self.parent.list.SetStringItem(self.index, rank, newpeer)

        # Display in advanced details window
        if self.detailwin is not None:
            self.detailwin.numseed.SetLabel(newseed)
            self.detailwin.numpeer.SetLabel(newpeer)

        if message is not None and not autoscraping:
            self.displayMessage(message, oldmsg = oldmsg)

    def termEvtMsg(self):
        if self.termevt:
            if type(self.termevt) is float:
                if self.status == 'finished':
                    return strftime(self.utility.timestamp, localtime(self.termevt)) + self.utility.messageheader + self.localize('torisfinished')
                return strftime(self.utility.timestamp, localtime(self.termevt)) + self.utility.messageheader + self.localize('toriscompleted')
            return self.termevt
        return ''

    def getTracker(self):
        if self.exttracker and (not self.abcengine or not self.abcengine.checkinginttrack):
            return self.exttrackerurl
        if self.extrainttracker:
            return self.inttrackerurl
        return self.defaulttracker

    def reannounce(self, tracker = None, url = None, force = False):
        if self.abcengine.dow:
            if force:
                self.abcengine.reannouncelast = 0
            if self.abcengine.reannouncelast == 0 or clock() - self.abcengine.reannouncelast > 60:
                self.abcengine.reannouncelast = clock()
                self.abcengine.dow.reannounce(tracker = tracker, special = url)

    def initSeedingTimeLeft(self):
        # Computes default seeding time left for a torrent when there is no abcengine
        if (self.uploadoption == 2 or self.uploadoption == 3) and self.ratioIsReached():
            self.seedingtimeleft = 0
        elif self.uploadoption == 1 or self.uploadoption == 3:
            self.seedingtimeleft = max(self.uploadtimemax - self.seedingtime, 0)
        else:
            # Set to 101 days, equivalent to infinite
            self.seedingtimeleft = 8726400

    def incDecPriority(self, direction, priorank = None):
        if priorank is None:
            priorank = self.parent.guiman.getRankfromID(7)
        newprio = self.priority - direction
        if newprio > 4 or newprio < 0:
            return
        self.priority = newprio
        if priorank != -1:
            self.parent.list.SetStringItem(self.index, priorank, self.utility.priorities_s[newprio])

    def longPathAutoFix(self, completedest = None, filesname = None, filesinfo = None):
        if completedest is None:
            completedest = self.utility.completePath(self.dest)
        if filesname is None:
            if self.filesname is not None:
                filesname = self.filesname
            else:
                if filesinfo is None:
                    filesinfo = self.getResponse()['info']['files']
                filesname = self.getFileNames(filesinfo)
        fixed = False
        i = 0
        for f in filesname:
            if not self.filenamestatus[i] & 1 and not self.filenamestatus[i] & 16 \
               and (self.filenamestatus[i] & 2 or self.filenamestatus[i] & 8):
                fixedname = self.utility.findUniqueFileName(join(completedest, f), extraext = False)
                if fixedname is not None:
                    filesname[i] = fixedname[len(completedest) + 1:]
                    self.filenamestatus[i] = 0
                    fixed = True
            i += 1
        if fixed:
            if filesinfo is None:
                filesinfo = self.getResponse()['info']['files']
            origfilenames = self.getOriginalFileNames(filesinfo)
            origfilenames.sort()
            origfilenamesstatus = self.writeOriginalFileNames(origfilenames)
        else:
            origfilenamesstatus = 0
            
        return fixed, filesname, origfilenamesstatus

    def checkFileNames(self, parent, filesinfo = None, showmessage = True, lengthautofix = None):
        # Try to fix characters and check length in items from file path
        if filesinfo is None:
            filesinfo = self.getResponse()['info']['files']
        filesname = self.getFileNames(filesinfo)
        torrentfiletree = FileTree(filesname, self.dest, self.utility)
        fixed, self.filenamestatus = torrentfiletree.fixWinNames()
        if fixed:
            # Set new file names in torrent
            filesname = torrentfiletree.getFileNames()
        # Check for total length of path name and path + file name of each file
        completedest = self.utility.completePath(self.dest)
        destlen = len(completedest)
        i = 0
        for f in filesname:
            # Limits for Windows XP : path : 247 char (including unit prefix (C:\)) ; path + file : 259 char (+ NULL)
            # Don't forget additional '\' between dest and f
            if len(f) > self.utility.filepathmaxlength or len(split(f)[0]) > self.utility.pathmaxlength - 3:
                # Too long name inside the torrent ; bit 3
                self.filenamestatus[i] |= 4
            if len(f) + destlen >= self.utility.filepathmaxlength or len(split(f)[0]) + destlen >= self.utility.pathmaxlength:
                # Too long name including destination path ; bit 4
                self.filenamestatus[i] |= 8
            i += 1

        # Try to fix automatically too long file path names
        if lengthautofix is None and self.abcparams['longpath'] == '0' or lengthautofix:
            lengthautofixed, filesname, origfilenamesstatus = self.longPathAutoFix(completedest, filesname)
        else:
            lengthautofixed = False
            origfilenamesstatus = 0
                    
        if fixed or lengthautofixed:
            self.filesname = filesname
            self.writeFileNames()

        # Compute and display results sum up
        checkstatus = 0
        for status in self.filenamestatus:
            checkstatus |= status
        if checkstatus:
            self.writeFileNameStatus()
        else:
            self.filenamestatus = None
            try:
                remove(self.src + '.fns')
            except:
                pass

        if origfilenamesstatus:
            checkstatus |= 32
        if checkstatus:
            if showmessage:
                sumupmessage = self.localize('filenamescheckresultprefix') + self.name \
                               + '\n' + self.localize('cantfixnameintorrent0')
                # Some automatic fixing failed
                if checkstatus & 1:
                    sumupmessage += self.localize('cantfixnameintorrent1')
                if checkstatus & 2:
                    sumupmessage += self.localize('cantfixnameintorrent2')
                if checkstatus & 4:
                    sumupmessage += self.localize('cantfixnameintorrent3')
                elif checkstatus & 8:
                    sumupmessage += self.localize('cantfixnameintorrent4')
                if checkstatus & 16:
                    sumupmessage += self.localize('cantfixnameintorrent5')
                # Could not write original file name list
                if checkstatus & 32:
                    sumupmessage += self.localize('cantfixnameintorrent6')
                # Show checks results sum up
                dlg = FileNamesCheckResultDialog(parent, -1, self.localize('filenamescheckresult'),
                                                 sumupmessage, opendetailsbtn = (self.infowin is None) and checkstatus != 32)
                if parent is not self.infowin:
                    self.parent.frame.restore()
                result = dlg.ShowModal()
                x, y = dlg.GetPositionTuple()
                self.abcparams['filenamescheckresdlgx'], self.abcparams['filenamescheckresdlgy'] = str(x), str(y)
                dlg.Destroy()
                showdetails = (result == wx.ID_OK)
            else:
                showdetails = False
        else:
            showdetails = False

        return checkstatus, showdetails

    def setDefaultTracker(self, deftracker):
        if deftracker != self.defaulttracker:
            if self.infowin is not None:
                self.infowin.clearDefaultTracker()
                self.infowin.markDefaultTracker(deftracker)
            if self.status == 'standby':
                self.parent.trackerstandbycount[self.defaulttracker] -= 1
                if self.parent.trackerstandbycount[self.defaulttracker] == 0:
                    del self.parent.trackerstandbycount[self.defaulttracker]
                if deftracker in self.parent.trackerstandbycount:
                    self.parent.trackerstandbycount[deftracker] += 1
                else:
                    self.parent.trackerstandbycount[deftracker] = 1
            self.defaulttracker = deftracker

    def updateData(self, src, dest, singlefile, name, piecelength, totalsize, filesnumber, defaulttracker, private, multitracker, magnet):
        self.src = src
        self.dest = dest
        self.singlefile = singlefile
        self.magnetname = self.name
        self.name = name
        self.piecelength = piecelength
        self.totalsize = totalsize
        self.requestedsize = float(totalsize)
        self.progress = 0.0
        self.initSeedingTimeLeft()
        self.filesnumber = filesnumber
        self.defaulttracker = defaulttracker
        self.private = private
        self.multitracker = multitracker
        self.magnet = magnet
        if self.abcengine:
            updatedataflag = Event()
            self.abcengine.dow.updateData(src, dest, private, updatedataflag)
            updatedataflag.wait()
            self.abcengine.statistics = None

    def getMaxUpRate(self):
        if self.maxuploadrate == -1:
            return self.abcengine.uprate
        return self.maxuploadrate

    def getMaxDownRate(self):
        if self.maxdownloadrate == -1:
            return self.abcengine.downrate
        return self.maxdownloadrate

    def checkPrivateWithoutTrackers(self):
        if self.private and self.defaulttracker is None and not self.exttracker and not self.extrainttracker:
            self.displayMessage(strftime(self.utility.timestamp) + self.utility.messageheader + self.localize('warning') \
                                + ' : ' + self.localize('notrackerprivate')[:-3])

    def toggleCheckIntTrack(self):
        self.abcengine.checkinginttrack = not self.abcengine.checkinginttrack
        if not self.abcengine.checkinginttrack:
            self.abcengine.startcheckinginttrack = -1
        self.exttracker = 1 - self.exttracker
        if self.detailwin is not None:
            self.detailwin.toggleTrackerBut(0)

    def switchTracker(self, value, updatebut = True):
        if (not value or not self.abcengine or not self.abcengine.checkinginttrack) and value == self.exttracker:
            return
        if self.detailwin is not None:
            self.detailwin.toggleTrackerBut(value, updatebut)

        if value:
            self.exttracker = 1
            if self.infowin is not None:
                self.infowin.showExtTrackerUrl(self.exttrackerurl)
            if self.status == 'standby':
                if self.extrainttracker:
                    oldtracker = self.inttrackerurl
                else:
                    oldtracker = self.defaulttracker
                self.parent.trackerstandbycount[oldtracker] -= 1
                if self.parent.trackerstandbycount[oldtracker] == 0:
                    del self.parent.trackerstandbycount[oldtracker]
                if self.exttrackerurl in self.parent.trackerstandbycount:
                    self.parent.trackerstandbycount[self.exttrackerurl] += 1
                else:
                    self.parent.trackerstandbycount[self.exttrackerurl] = 1
            self.lastgetscrape = 0
            self.lastgetscrapemanual = 0
            if self.abcengine:
                self.abcengine.checkinginttrack = False
                self.abcengine.startcheckinginttrack = -1
                self.reannounce(tracker = 'ext', url = self.exttrackerurl, force = True)
            elif self.scraping:
                self.parent.getScrapeData(self, autoscraping = self.scrapingcontext[0], standby = self.scrapingcontext[1])
        else:
            if self.abcengine:
                # exttracker is not switched for transient internal tracker states
                if self.abcengine.checkinginttrack:
                    self.exttracker = 1
                else:
                    self.exttracker = 0
            else:
                self.exttracker = 0
            if self.infowin is not None:
                if self.extrainttracker:
                    self.infowin.showExtTrackerUrl(self.inttrackerurl)
                else:
                    self.infowin.hideExtTrackerUrl()
            if self.status == 'standby':
                self.parent.trackerstandbycount[self.exttrackerurl] -= 1
                if self.parent.trackerstandbycount[self.exttrackerurl] == 0:
                    del self.parent.trackerstandbycount[self.exttrackerurl]
                if self.extrainttracker:
                    newtracker = self.inttrackerurl
                else:
                    newtracker = self.defaulttracker
                if newtracker in self.parent.trackerstandbycount:
                    self.parent.trackerstandbycount[newtracker] += 1
                else:
                    self.parent.trackerstandbycount[newtracker] = 1
            self.lastgetscrape = 0
            self.lastgetscrapemanual = 0
            if self.abcengine:
                if self.extrainttracker:
                    self.reannounce(tracker = 'ext', url = self.inttrackerurl, force = True)
                else:
                    self.reannounce(tracker = 'int', force = True)
            elif self.scraping:
                self.parent.getScrapeData(self, autoscraping = self.scrapingcontext[0], standby = self.scrapingcontext[1])
            if not self.extrainttracker and self.defaulttracker is None:
                if self.private:
                    self.displayMessage(strftime(self.utility.timestamp) + self.utility.messageheader + self.localize('warning')
                                        + ' : ' + self.localize('notrackerprivate')[:-3])
                elif not self.parent.dht:
                    self.displayMessage(strftime(self.utility.timestamp) + self.utility.messageheader + self.localize('warning')
                                        + ' : ' + self.localize('notrackernodht')[:-3])

    def switchTrackerExternal(self):
        self.abcengine.checkinginttrack = True
        self.switchTracker(0)
        if self.detailwin is not None:
            # To make visible the switch of the button
            sleep(0.2)
        self.switchTracker(1)

    def setDHTDisconnected(self, value):
        if self.abcengine:
            self.abcengine.dow.setDHTDisconnected(value)

    def initStandbySeedingTime(self, t):
        # sbseedstart, sblastseedingtime and sblasttotalseedingtime are only used to 
        # count seeding time for standy torrents when "Count seeding time also for
        # standby torrents" is on 
        self.sbseedstart = t
        self.sblastseedingtime = self.seedingtime
        self.sblasttotalseedingtime = self.totalseedingtime

    def writeOriginalFileNames(self, sortedorigfiles):
        completedest = self.utility.completePath(self.dest)
        try:
            if not exists(completedest):
                mkdir(completedest)
            ofnfile = open(join(self.utility.completePath(self.dest), self.abcparams['originalfilenameslist']), "w")
            if self.abcparams['originalfilenameslistbom'] == '1':
                ofnfile.writelines('\xef\xbb\xbf')
            ofnfile.writelines([n.encode('utf_8') + '\n' for n in sortedorigfiles])
            ofnfile.close()
            return 0
        except:
            return 1

    def isSingleFile(self, completedest = None):
        if completedest is None:
            completedest = self.utility.completePath(self.dest)
        if self.magnet == 1 or self.magnet == 2 and not exists(completedest):
            return None
        return (not self.magnet and self.singlefile) or (self.magnet and isfile(completedest))

    def getRebuiltDest(self):
        if self.magnet == 1:
            return join(split(self.dest)[0], self.localize('notorrentinfo'))
        return self.dest

    def decodeMetainfoWarnings(self, metainfowarning):
        self.message = strftime(self.utility.timestamp) + self.utility.messageheader + self.localize('warning') + ' : '
        if metainfowarning & 8:
            self.message += self.localize('badfilenames1')
        if metainfowarning & 16:
            self.message += self.localize('badfilenames2')
        if metainfowarning & 32:
            self.message += self.localize('badfilenames3')
        elif metainfowarning & 64:
            self.message += self.localize('badfilenames4')
        if metainfowarning & 128:
            self.message += self.localize('badfilenames5')
        if metainfowarning & 1:
            self.message += self.localize('baddataintorrent')
        if metainfowarning & 2:
            self.message += self.localize('notrackerprivate')
        elif metainfowarning & 4:
            self.message += self.localize('notrackernodht')
        if metainfowarning & 256:
            self.message += self.localize('cantwriteorigfilenameslist')
        self.message = self.message[:-3]
        return self.message

    def displayOnGoing(self, endtopoffflag):
        # To display sparse1 allocating mark in progress field for torrents without engine
        self.ongoing = True
        self._displayOnGoing(endtopoffflag)

    def _displayOnGoing(self, endtopoffflag):
        self.parent.invokeLater(self.__displayOnGoing, [endtopoffflag])

    def __displayOnGoing(self, endtopoffflag):
        if endtopoffflag.isSet():
            # End of sparse1 allocation
            rank = self.parent.guiman.getRankfromID(5)
            if rank != -1:
                self.parent.list.SetStringItem(self.index, rank, self.formatedProgress())
            if self.infowin:
                self.infowin.totalprogress.SetLabel(self.formatedProgress())
            if self.detailwin:
                self.detailwin.totalprogress.SetLabel(self.formatedProgress())
            self.ongoing = None
        else:
            if self.ongoing:
                ongoing = self.abcparams['progressongoing']
            else:
                ongoing = self.abcparams['progressongoing2']
            self.ongoing = not self.ongoing
            rank = self.parent.guiman.getRankfromID(5)
            if rank != -1:
                self.parent.list.SetStringItem(self.index, rank, self.formatedProgress() + ongoing)
            if self.infowin:
                self.infowin.totalprogress.SetLabel(self.formatedProgress() + ongoing)
            if self.detailwin:
                self.detailwin.totalprogress.SetLabel(self.formatedProgress() + ongoing)
            Timer(1, self._displayOnGoing, [endtopoffflag]).start()
