##############################################################################
# Module : abcmetainfoframe.py
# Author :
# Date   :
# Updated and modified for ABC_OKC : Old King Cole
#
# Description : Torrent details window
#
##############################################################################
import sys, wx, re
from binascii import hexlify
from webbrowser import open_new
from threading import Thread, Timer
from time import localtime, strftime
from os.path import join, exists, split
from os import startfile, remove

import abcdetailframe
from Dialogs.renfromclipdlg import RenFromClipDialog

DETAILSMINWIDTH = 488


class ABCMetaInfoFrame(wx.Frame):
    def __init__(self, parent, ID, title, utility, index, position, size, centeratpointer = False):
        self.parent = parent
        self.utility = utility
        self.abcparams = self.utility.abcparams
        self.localize = self.utility.lang.get
        self.guiman = self.parent.guiman
        self.invokeLater = self.parent.queue.invokeLater
        self.popupmenu = None
        self.popupannmenu = None
        self.resettingframe = False
        self.index = index
        self.torrent = self.parent.queue.proctab[index]
        self.desiredwidth, self.desiredheight = size
        self.widthfornext, self.heightfornext = size
        self.selectedfilesnumber = 0
        # List row selected by a left or a right click
        self.selectedrow = -1
        # File list dragging mode :
        # 0 : no dragging
        # 1 : select torrent
        self.listdraggingmode = 0

        if position is None or position < 0:
            pos = wx.DefaultPosition
        else:
            pos = position
        wx.Frame.__init__(self, parent, ID, title, pos, (max(DETAILSMINWIDTH, self.desiredwidth), -1))
        self.const = False
        self.SetAcceleratorTable(self.parent.parent.accelerators)
        self.fileprio = []
        # To save pos and size for an opened window currently browsed in another one
        self.wintorestore = None
        # 1 : original file names column is shown ; O : original file names column is not shown
        self.originalfilenamesshown = 0

        if sys.platform == 'win32':
            self.icon = wx.Icon(join(self.utility.abcpath, 'icon_abc.ico'), wx.BITMAP_TYPE_ICO)
            self.SetIcon(self.icon)

        self.panel = wx.Panel(self, -1)

        colsizer = wx.FlexGridSizer(cols = 1, vgap = 3)
        colsizer.AddGrowableCol(0)
        colsizer.AddGrowableRow(2)

        toppanel = wx.Panel(self.panel, -1)

        topsizer = wx.BoxSizer(wx.VERTICAL)

        self.abouttitle = wx.StaticText(toppanel, -1, u'')
        self.abouttitle.SetFont(wx.Font(14, wx.DEFAULT, wx.NORMAL, wx.NORMAL, False))
        topsizer.Add(self.abouttitle, 0, wx.EXPAND)

        toppanel.SetSizer(topsizer)
        toppanel.SetAutoLayout(True)
        colsizer.Add(toppanel, 0, wx.EXPAND | wx.TOP, -2)

        detailSizer = wx.FlexGridSizer(cols = 2, vgap = 3, hgap = 3)
        detailSizer.AddGrowableCol(1)
        detail1Sizer = wx.BoxSizer(wx.HORIZONTAL)

        destinationhead = wx.StaticText(self.panel, -1, self.localize('destination'))
        destinationhead.SetForegroundColour('Blue')
        detail1Sizer.Add(destinationhead, 0, wx.ALIGN_CENTER_VERTICAL)
        self.destinationtext = wx.TextCtrl(self.panel, -1, '', style = wx.TE_READONLY)
        detail1Sizer.Add(self.destinationtext, 1, wx.EXPAND | wx.LEFT, 3)

        colsizer.Add(detail1Sizer, 1, wx.TOP | wx.EXPAND, 1)

        # List for multi-file 
        self.filelist = wx.ListCtrl(self.panel, -1, size = (-1, self.utility.torrentfilelistheight), style = wx.LC_REPORT | wx.LC_VRULES | wx.LC_HRULES)
        self.fileprio_s = [self.localize('fileprioritynever_s'),
                           self.localize('filepriorityhigh_s'),
                           self.localize('fileprioritynormal_s'),
                           self.localize('fileprioritylow_s')]
        self.scrolltimer = None
        # Events
        self.filelist.Bind(wx.EVT_LIST_ITEM_RIGHT_CLICK, self.onListRightClick)
        self.filelist.Bind(wx.EVT_LIST_COL_CLICK, self.onListColLeftClick)
        self.filelist.Bind(wx.EVT_LIST_COL_RIGHT_CLICK, self.onListColRightClick)
        self.filelist.Bind(wx.EVT_RIGHT_DOWN, self.onRightDown)
        self.filelist.Bind(wx.EVT_RIGHT_UP, self.onRightUp)
        self.filelist.Bind(wx.EVT_LEFT_UP, self.onLeftUp)
        self.filelist.Bind(wx.EVT_LEFT_DOWN, self.onLeftDown)
        self.filelist.Bind(wx.EVT_LEAVE_WINDOW, self.onLeaveList)
        self.filelist.Bind(wx.EVT_ENTER_WINDOW, self.onEnterList)
        self.filelist.Bind(wx.EVT_LIST_BEGIN_DRAG, self.onLeftDragList)
        self.filelist.Bind(wx.EVT_LIST_BEGIN_RDRAG, self.onRightDragList)
        self.filelist.Bind(wx.EVT_MOTION, self.onMotionInList)
        self.filelist.Bind(wx.EVT_MOUSEWHEEL, self.onMouseWheel)
        self.filelist.Bind(wx.EVT_LEFT_DCLICK, self.onListDoubleClick)
        self.filelist.Bind(wx.EVT_KEY_DOWN, self.onKeyInList)
        self.filelist.Bind(wx.EVT_LIST_ITEM_SELECTED, self.onChangeSelected)
        self.filelist.Bind(wx.EVT_LIST_ITEM_DESELECTED, self.onChangeSelected)
        self.filelist.SetAutoLayout(True)
        self.filelist.InsertColumn(0, self.localize('filepriorityheader'), width = self.utility.torrentfilelistwidth0)
        self.filelist.InsertColumn(1, '')
        self.filelist.InsertColumn(2, self.localize('size'), wx.LIST_FORMAT_RIGHT)
        self.filelist.InsertColumn(3, self.localize('progress'), wx.LIST_FORMAT_RIGHT, width = self.utility.torrentfilelistwidth3)
        # self.filelist.InsertColumn(4, self.localize('md5sum'), width = self.utility.torrentfilelistwidth4)
        self.filelist.InsertColumn(4, '', width = self.utility.torrentfilelistwidth5)
        colsizer.Add(self.filelist, 1, wx.EXPAND)

        # Md5 for single file
        # self.md5title = wx.StaticText(self.panel, -1, self.localize('md5hash'))
        # detailSizer.Add(self.md5title)
        # self.md5 = wx.StaticText(self.panel, -1, '')
        # detailSizer.Add(self.md5)
        # self.md5title.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        # self.md5.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)

        # Infohash
        infohashtitle = wx.StaticText(self.panel, -1, self.localize('infohash'))
        detailSizer.Add(infohashtitle, 0, wx.ALIGN_CENTER_VERTICAL)
        self.infohash = wx.TextCtrl(self.panel, -1, '', style = wx.TE_READONLY)
        detailSizer.Add(self.infohash, 1, wx.EXPAND)

        # Size, pieces, date, DHT nodes, progress, status, private
        sizepiecesdatetitlebox = wx.BoxSizer(wx.VERTICAL)

        self.filesizetitle = wx.StaticText(self.panel, -1, self.localize('archivesize'))
        sizepiecesdatetitlebox.Add(self.filesizetitle)

        piecestitle = wx.StaticText(self.panel, -1, self.localize('pieces'))
        sizepiecesdatetitlebox.Add(piecestitle, 0, wx.TOP, 3)

        datetitle = wx.StaticText(self.panel, -1, self.localize('creationdate'))
        sizepiecesdatetitlebox.Add(datetitle, 0, wx.TOP, 3)

        nbdhtnodestitle = wx.StaticText(self.panel, -1, self.localize('nbdhtnodes'))
        sizepiecesdatetitlebox.Add(nbdhtnodestitle, 0, wx.TOP, 3)

        detailSizer.Add(sizepiecesdatetitlebox)

        sizepiecesdatebox = wx.BoxSizer(wx.VERTICAL)

        self.filesize = wx.StaticText(self.panel, -1, '')
        sizepiecesdatebox.Add(self.filesize)

        self.pieces = wx.StaticText(self.panel, -1, '')
        sizepiecesdatebox.Add(self.pieces, 0, wx.TOP, 3)

        self.date = wx.StaticText(self.panel, -1, '')
        sizepiecesdatebox.Add(self.date, 0, wx.TOP, 3)

        self.nbdhtnodes = wx.StaticText(self.panel, -1, '')
        sizepiecesdatebox.Add(self.nbdhtnodes, 0, wx.TOP, 3)

        progressstatusratepanel = wx.Panel(self.panel, -1)
        progressstatusratepanel.SetDoubleBuffered(True)
        progressstatusratebox = wx.BoxSizer(wx.VERTICAL)

        progressbox = wx.BoxSizer(wx.HORIZONTAL)
        totalprogresstitle = wx.StaticText(progressstatusratepanel, -1, self.localize('totalprogress'))
        progressbox.Add(totalprogresstitle)
        self.totalprogress = wx.StaticText(progressstatusratepanel, -1, '')
        progressbox.Add(self.totalprogress, 0, wx.LEFT, 5)
        progressstatusratebox.Add(progressbox)

        statusbox = wx.BoxSizer(wx.HORIZONTAL)
        statustitle = wx.StaticText(progressstatusratepanel, -1, self.localize('statusdetwin'))
        statusbox.Add(statustitle)
        self.status = wx.StaticText(progressstatusratepanel, -1, '', size = (75 ,-1))
        statusbox.Add(self.status, 0, wx.LEFT, 5)
        self.colour = wx.Window(progressstatusratepanel, -1, size = (13, 13), style = wx.SIMPLE_BORDER)
        statusbox.Add(self.colour, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        progressstatusratebox.Add(statusbox, 0, wx.TOP, 3)

        ratesbox = wx.BoxSizer(wx.HORIZONTAL)
        downratetitle = wx.StaticText(progressstatusratepanel, -1, self.localize('downratedetwin'))
        self.downrate = wx.StaticText(progressstatusratepanel, -1, '', size = (68, -1))
        ratesbox.Add(downratetitle)
        ratesbox.Add(self.downrate, 0, wx.LEFT, 5)
        upratetitle = wx.StaticText(progressstatusratepanel, -1, self.localize('upratedetwin'))
        self.uprate = wx.StaticText(progressstatusratepanel, -1, '', size = (68, -1))
        ratesbox.Add(upratetitle, 0, wx.LEFT, 10)
        ratesbox.Add(self.uprate, 0, wx.LEFT, 5)
        progressstatusratebox.Add(ratesbox, 0, wx.TOP, 3)

        privatebox = wx.BoxSizer(wx.HORIZONTAL)
        privatetitle = wx.StaticText(progressstatusratepanel, -1, self.localize('private'))
        privatebox.Add(privatetitle)
        self.private = wx.StaticText(progressstatusratepanel, -1, '', size = (60, -1))
        privatebox.Add(self.private, 0, wx.LEFT, 5)
        progressstatusratebox.Add(privatebox, 0, wx.TOP, 3)

        progressstatusratepanel.SetSizer(progressstatusratebox)
        progressstatusratepanel.SetAutoLayout(True)

        sizepiecesprogstatbox = wx.BoxSizer(wx.HORIZONTAL)
        sizepiecesprogstatbox.Add(sizepiecesdatebox)
        sizepiecesprogstatbox.Add((0, 0), 1)
        sizepiecesprogstatbox.Add(progressstatusratepanel, 0, wx.RIGHT, 30)

        detailSizer.Add(sizepiecesprogstatbox, 1, wx.EXPAND)

        # No announce list
        self.announceurlhead1 = wx.StaticText(self.panel, -1, self.localize('announceurl'))
        self.announceurlhead1.SetForegroundColour('Blue')
        detailSizer.Add(self.announceurlhead1, 0, wx.ALIGN_CENTER_VERTICAL)
        self.announce = wx.TextCtrl(self.panel, -1, u'', style = wx.TE_READONLY)
        detailSizer.Add(self.announce, 1, wx.EXPAND)
        # Announce list exists
        self.announceurlhead2 = wx.StaticText(self.panel, -1, self.localize('announceurl'))
        self.announceurlhead2.SetForegroundColour('Blue')
        detailSizer.Add(self.announceurlhead2, 0, wx.ALIGN_CENTER_VERTICAL)
        self.trackerlist = wx.ListCtrl(self.panel, -1, size = (-1, self.utility.torrenttrackerlistheight), style = wx.LC_REPORT | wx.LC_SINGLE_SEL | wx.LC_NO_HEADER)
        self.trackerlist.SetAutoLayout(True)
        self.trackerlist.InsertColumn(0, "", width = self.utility.torrenttrackerlistwidth0)
        self.trackerlist.InsertColumn(1, "")
        self.trackerlist.InsertColumn(2, "")
        if self.utility.torrenttrackerlistwidth1:
            self.trackerlist.SetColumnWidth(1, self.utility.torrenttrackerlistwidth1)
        else:
            self.trackerlist.InsertStringItem(0, '')
            self.trackerlist.SetStringItem(0, 1, self.localize('defaulttrackermarker'))
            self.trackerlist.SetColumnWidth(1, -1)
        detailSizer.Add(self.trackerlist, 1, wx.EXPAND)
        self.panel.Bind(wx.EVT_LIST_ITEM_RIGHT_CLICK, self.onAnnounceListRightClick, self.trackerlist)
        self.trackerlist.Bind(wx.EVT_RIGHT_DOWN, self.onAnnounceListRightDown)
        self.trackerlist.Bind(wx.EVT_LIST_ITEM_SELECTED, self.onAnnounceListSelected)

        self.exttrackerurlhead = wx.StaticText(self.panel, -1, self.localize('announceexturl'))
        self.exttrackerurlhead.SetForegroundColour('Blue')
        detailSizer.Add(self.exttrackerurlhead, 0, wx.ALIGN_CENTER_VERTICAL)
        self.exttrackerurl = wx.TextCtrl(self.panel, -1, u'', style = wx.TE_READONLY)
        detailSizer.Add(self.exttrackerurl, 1, wx.EXPAND)

        # Comment (if exists and not empty)
        self.commenttitle = wx.StaticText(self.panel, -1, self.localize('comment'))
        detailSizer.Add(self.commenttitle, 0, wx.ALIGN_CENTER_VERTICAL)
        self.detailtext = wx.TextCtrl(self.panel, -1, u'', style = wx.TE_READONLY | wx.TE_MULTILINE)
        detailSizer.Add(self.detailtext, 1, wx.EXPAND)
        self.commenttitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)

        self.messagetexthead = wx.StaticText(self.panel, -1, self.localize('message'))
        detailSizer.Add(self.messagetexthead, 0, wx.ALIGN_CENTER_VERTICAL)
        self.messagetext = wx.TextCtrl(self.panel, -1, '', style = wx.TE_READONLY)
        detailSizer.Add(self.messagetext, 1, wx.EXPAND)

        colsizer.Add(detailSizer, 1, wx.EXPAND)

        buttonsizer = wx.BoxSizer(wx.HORIZONTAL)
        locatebut = wx.Button(self.panel, -1, self.localize('locate'), size = (55, -1))
        torrentparambut = wx.Button(self.panel, -1, self.localize('torrentparam'))
        self.advdetailsbut = wx.Button(self.panel, -1, self.localize('advdetails'))
        closebut = wx.Button(self.panel, -1, self.localize('close'), size = (55, -1))
        buttonsizer.Add(locatebut)
        buttonsizer.Add(torrentparambut, 0, wx.LEFT, 10)
        buttonsizer.Add(self.advdetailsbut, 0, wx.LEFT, 10)
        buttonsizer.Add(closebut, 0, wx.LEFT, 10)

        colsizer.Add(buttonsizer, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.TOP, 3)

        self.border = wx.BoxSizer(wx.HORIZONTAL)
        self.border.Add(colsizer, 1, wx.EXPAND | wx.ALL, 3)
        self.panel.SetSizer(self.border)
        self.panel.SetAutoLayout(True)

        self.Bind(wx.EVT_MOVE, self.onMoveDet)
        self.Bind(wx.EVT_SIZE, self.onSizeDet)
        self.Bind(wx.EVT_BUTTON, self.onLocate, locatebut)
        self.Bind(wx.EVT_BUTTON, self.onLocalSetting, torrentparambut)
        self.Bind(wx.EVT_BUTTON, self.onAdvDetails, self.advdetailsbut)
        self.Bind(wx.EVT_BUTTON, self.killInfo, closebut)
        self.Bind(wx.EVT_CLOSE, self.killInfo)
        self.abouttitle.Bind(wx.EVT_LEFT_DOWN, self.toggleFocusOnTitle)
        self.abouttitle.Bind(wx.EVT_MOUSEWHEEL, self.onMouseWheelTitle)
        destinationhead.Bind(wx.EVT_LEFT_DOWN, self.onDestination)
        self.announceurlhead1.Bind(wx.EVT_LEFT_DOWN, self.onIntAnnounce)
        self.announceurlhead2.Bind(wx.EVT_LEFT_DOWN, self.onIntAnnounce)
        self.exttrackerurlhead.Bind(wx.EVT_LEFT_DOWN, self.onExtAnnounce)
        self.panel.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        self.abouttitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        toppanel.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        progressstatusratepanel.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        destinationhead.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        infohashtitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        self.filesizetitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        self.filesize.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        totalprogresstitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        self.totalprogress.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        piecestitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        self.pieces.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        statustitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        self.status.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        downratetitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        self.downrate.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        upratetitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        self.uprate.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        self.announceurlhead1.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        self.announceurlhead2.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        self.exttrackerurlhead.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        self.messagetexthead.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        datetitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        self.date.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        nbdhtnodestitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        self.nbdhtnodes.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        privatetitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        self.private.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        self.colour.Bind(wx.EVT_RIGHT_UP, self.onRightUpDet)
        self.colour.Bind(wx.EVT_LEFT_DOWN, self.onLeftColour)
        self.colour.Bind(wx.EVT_MOUSEWHEEL, self.onMouseWheelColour)

        self.displayInfo()

        const = False
        if position == -1:
            self.Centre()
        elif position == -2:
            pos, const = self.utility.getPosCenteredOnWin(self.GetSize(), self.torrent.detailwin)
            self.Move(pos)
        elif position == -3:
            pos, const = self.utility.getPosCenteredOnWin(self.GetSize(), self.torrent.detailwin, aligntop = True)
            self.Move(pos)
        elif centeratpointer:
            self.Move(pos - wx.Point(self.GetSizeTuple()[0] / 2, 10))

        self.resettingframe = True
        self.Show()
        self.resettingframe = False
        # Placed here because first Show calls Move, resetting self.const
        self.const = const

    def refreshFileProgress(self):
        donestr = self.localize('done')
        progresscol = 3 + self.originalfilenamesshown
        if self.torrent.complete and not self.torrent.unwantedfiles:
            for x in xrange(self.torrent.filesnumber):
                self.filelist.SetStringItem(x, progresscol, donestr)
        elif self.torrent.filesprogress is None:
            for x in xrange(self.torrent.filesnumber):
                self.filelist.SetStringItem(x, progresscol, '0%')
        else:
            for x in xrange(self.torrent.filesnumber):
                prog = self.torrent.filesprogress[x]
                if prog == 'Done':
                    prog = donestr
                else:
                    prog = prog.split('.')[0] + '%'
                self.filelist.SetStringItem(x, progresscol, prog)

    def displayInfo(self):
        self.panel.Freeze()
        metainfo = self.torrent.getResponse()
        if metainfo is None:
            self.SetTitle(self.localize('torrentdetail') + self.torrent.name)
            self.abouttitle.SetLabel(self.torrent.name.replace('&', '&&'))
            self.destinationtext.SetValue('')
            # self.md5title.Hide()
            # self.md5.Hide()
            self.filelist.Hide()
            self.infohash.SetValue(self.localize('invalidtorrentdata'))
            self.filesize.SetLabel('')
            self.downrate.SetLabel(self.utility.rateWithUnit('', self.torrent.prioritizedown))
            self.uprate.SetLabel(self.utility.rateWithUnit('', self.torrent.prioritizeup))
            self.totalprogress.SetLabel(self.torrent.formatedProgress())
            self.status.SetLabel(self.localize(self.torrent.status))
            self.colour.SetBackgroundColour(self.utility.colnoeng)
            self.pieces.SetLabel('')
            self.date.SetLabel('')
            self.announceurlhead2.Hide()
            self.trackerlist.Hide()
            self.announceurlhead1.Show()
            self.announce.Show()
            self.announce.SetValue('')
            self.exttrackerurlhead.Hide()
            self.exttrackerurl.Hide()
            self.comment = ''
            self.commenttitle.Hide()
            self.detailtext.Hide()
            if self.abcparams['msgindetails'] == '0':
                self.messagetexthead.Hide()
                self.messagetext.Hide()
            else:
                if self.torrent.message or self.abcparams['emptymsgindetails'] == "1":
                    self.messagetexthead.Show()
                    self.messagetext.Show()
                    self.messagetext.SetValue(self.torrent.message)
                else:
                    self.messagetexthead.Hide()
                    self.messagetext.Hide()
            self.resetFrame()
            return

        if metainfo.has_key('announce'):
            announce = metainfo['announce']
        else:
            announce = None

        # Announce url that will be used to open an internal likely tracker in a browser
        self.selectedintannounce = announce

        if metainfo.has_key('announce-list'):
            announce_list = metainfo['announce-list']
        else:
            announce_list = None

        info = metainfo['info']
        piece_length = info['piece length']

        self.SetTitle(self.localize('torrentdetail') + self.torrent.name)
        self.abouttitle.SetLabel(self.torrent.name.replace('&', '&&'))
        self.destinationtext.SetValue(self.torrent.getRebuiltDest())

        if self.torrent.singlefile:
            # File
            self.filelist.Hide()
            # if info.has_key('md5sum'):
                # self.md5title.Show()
                # self.md5.Show()
                # self.md5.SetLabel(info['md5sum'])
            # else:
                # self.md5title.Hide()
                # self.md5.Hide()

        else:
            # Folder
            # self.md5title.Hide()
            # self.md5.Hide()
            for i in xrange(self.filelist.GetItemCount()):
                self.filelist.DeleteItem(0)
            if self.originalfilenamesshown:
                self.filelist.DeleteColumn(2)
                self.originalfilenamesshown = 0
            self.filesinfo = info['files']

            # Refresh immediately filesprogress
            if self.torrent.abcengine:
                self.torrent.abcengine.reportProgress()

            # Set number of files in Files header
            colitem = wx.ListItem()
            if self.torrent.filesname:
                renamedmarker = self.localize('filerenamedmarker')
            else:
                renamedmarker = ''
            if self.torrent.filenamestatus:
                invalidmarker = self.localize('filenameinvalidmarker')
                invalidnumber = self.torrent.filesnumber - self.torrent.filenamestatus.count(0)
            else:
                invalidmarker = ''
                invalidnumber = 0
            colitem.SetText(self.localize('files') + ' (0/' + str(self.torrent.filesnumber) 
                            + ')' + renamedmarker + invalidmarker)
            self.filelist.SetColumn(1, colitem)

            # Set number of invalid names in Name Status header
            colitem = wx.ListItem()
            colitem.SetText(self.localize('filenamestatus') + ' (' + str(invalidnumber) + ')')
            self.filelist.SetColumn(4 + self.originalfilenamesshown, colitem)

            self.filesname = self.torrent.getFileNames(filesinfo = self.filesinfo)
            i = 0
            for file in self.filesinfo:
                # File priority
                if self.torrent.filespriority is None:
                    self.filelist.InsertStringItem(i, self.fileprio_s[2])
                    self.fileprio.append(1)
                else:
                    prio = self.torrent.filespriority[i]
                    self.filelist.InsertStringItem(i, self.fileprio_s[prio + 1])
                    self.fileprio.append(prio)
                # File path
                self.filelist.SetStringItem(i, 1, self.filesname[i])
                # File size
                self.filelist.SetStringItem(i, 2, self.utility.commaFormat(file['length']))
                # File md5
                # filemd5sum = file.get('md5sum')
                # if filemd5sum is not None:
                    # self.filelist.SetStringItem(i, 4, ' [' + str(filemd5sum) + ']')
                i += 1
            # File progress
            self.refreshFileProgress()

            # File name status
            self.displayFileNameStatus(reset = False)

            self.filelist.SetColumnWidth(1, wx.LIST_AUTOSIZE_USEHEADER)
            self.filelist.SetColumnWidth(2, wx.LIST_AUTOSIZE_USEHEADER)
            self.filelist.Show()

        self.infohash.SetValue(hexlify(self.torrent.infohash))

        if self.torrent.magnet:
            self.filesize.SetLabel('?')
        else:
            self.updateSize()

        if self.torrent.abcengine:
            self.totalprogress.SetLabel(self.torrent.abcengine.formatedProgress())
            if self.torrent.status == 'pause' or self.torrent.status == 'onhold':
                self.status.SetLabel(self.localize(self.torrent.status))
                self.colour.SetBackgroundColour(self.utility.colnoeng)
                self.downrate.SetLabel(self.utility.rateWithUnit('', self.torrent.prioritizedown))
                self.uprate.SetLabel(self.utility.rateWithUnit('', self.torrent.prioritizeup))
            else:
                self.status.SetLabel(self.localize(self.torrent.abcengine.btstatus))
                self.colour.SetBackgroundColour(self.torrent.abcengine.colour)
                self.downrate.SetLabel(self.utility.rateWithUnit(self.torrent.abcengine.downloadrate, self.torrent.prioritizedown))
                self.uprate.SetLabel(self.utility.rateWithUnit(self.torrent.abcengine.uploadrate, self.torrent.prioritizeup))
        else:
            self.init()
            self.totalprogress.SetLabel(self.torrent.formatedProgress())
            if self.torrent.ismovingdata:
                self.status.SetLabel(self.localize('moving'))
            else:
                self.status.SetLabel(self.localize(self.torrent.status))
            self.colour.SetBackgroundColour(self.utility.colnoeng)
        self.colour.Refresh()

        if self.torrent.magnet:
            self.pieces.SetLabel('?')
        else:
            num_pieces = int((self.torrent.totalsize + piece_length - 1) / piece_length)
            self.pieces.SetLabel(self.localize('str2') % (num_pieces, self.utility.commaFormat(piece_length)))

        if metainfo.has_key('creation date'):
            try:
                self.date.SetLabel(strftime('%x %X', localtime(metainfo['creation date'])))
            except:
                self.date.SetLabel(self.localize('baddate'))
        else:
            self.date.SetLabel(self.localize('nodate'))

        if announce_list is None:
            self.announceurlhead2.Hide()
            self.trackerlist.Hide()
            if announce is None:
                self.announceurlhead1.Hide()
                self.announce.Hide()
            else:
                self.announceurlhead1.Show()
                self.announce.Show()
                self.announce.SetValue(self.utility.decodeString(announce))
        else:
            self.announceurlhead1.Hide()
            self.announce.Hide()
            self.announceurlhead2.Show()
            self.trackerlist.Show()
            for i in xrange(self.trackerlist.GetItemCount()):
                self.trackerlist.DeleteItem(0)
            x = 0
            for tier in xrange(len(announce_list)):
                for t in xrange(len(announce_list[tier])):
                    if t == 0:
                        self.trackerlist.InsertStringItem(x, self.localize('tier') + str(tier + 1) + ' :')
                    else:
                        self.trackerlist.InsertStringItem(x, '')
                    self.trackerlist.SetStringItem(x, 2, self.utility.decodeString(announce_list[tier][t]))
                    x += 1
            self.markDefaultTracker(self.torrent.defaulttracker)

            if announce is not None:
                self.trackerlist.InsertStringItem(x, '')
                self.trackerlist.InsertStringItem(x + 1, self.localize('single'))
                self.trackerlist.SetStringItem(x + 1, 2, self.utility.decodeString(announce))
            self.trackerlist.SetColumnWidth(2, -1)

        if self.torrent.exttracker:
            self.exttrackerurl.SetValue(self.torrent.exttrackerurl)
            self.exttrackerurlhead.Show()
            self.exttrackerurl.Show()
        elif self.torrent.extrainttracker:
            self.exttrackerurl.SetValue(self.torrent.inttrackerurl)
            self.exttrackerurlhead.Show()
            self.exttrackerurl.Show()
        else:
            self.exttrackerurlhead.Hide()
            self.exttrackerurl.Hide()

        if metainfo.has_key('nodes'):
            nbnodes = len(metainfo['nodes'])
        else:
            nbnodes = 0
        self.nbdhtnodes.SetLabel(str(nbnodes))
        if self.torrent.magnet:
            self.private.SetLabel('?')
        elif self.torrent.private:
            self.private.SetLabel(self.localize('privateyes'))
        else:
            self.private.SetLabel(self.localize('privateno'))

        if metainfo.has_key('comment.utf-8'):
            commentkey = 'comment.utf-8'
        elif metainfo.has_key('comment'):
            commentkey = 'comment'
        else:
            commentkey = ''
        if commentkey:
            self.comment = self.utility.decodeString(metainfo[commentkey])
            if self.comment:
                self.detailtext.SetWindowStyle(wx.TE_READONLY | wx.TE_MULTILINE)
                self.detailtext.SetValue(self.comment)
                self.commenttitle.Show()
                self.detailtext.Show()
            else:
                self.commenttitle.Hide()
                self.detailtext.Hide()
        else:
            self.comment = ''
            self.commenttitle.Hide()
            self.detailtext.Hide()

        if self.abcparams['msgindetails'] == '0':
            self.messagetexthead.Hide()
            self.messagetext.Hide()
        else:
            if self.torrent.message or self.abcparams['emptymsgindetails'] == "1":
                self.messagetexthead.Show()
                self.messagetext.Show()
                self.messagetext.SetValue(self.torrent.message)
            else:
                self.messagetexthead.Hide()
                self.messagetext.Hide()

        self.resetFrame()

        if self.torrent.abcengine:
            self.torrent.abcengine.dow.filedatflag.set()

    def resetFrame(self):
        self.resettingframe = True
        if self.comment:
            self.panel.SetSize((self.GetClientSize()[0], self.panel.GetBestSize()[1]))
            if self.detailtext.GetNumberOfLines() < 2:
                self.detailtext.SetWindowStyle(wx.TE_READONLY)
            else:
                self.detailtext.SetWindowStyle(wx.TE_READONLY | wx.TE_MULTILINE)
        self.panel.SetSize((self.GetClientSize()[0], self.panel.GetBestSize()[1]))
        self.SetMinSize((-1, -1))
        self.SetMaxSize((-1, -1))
        newminh = self.GetBestSize()[1]
        self.SetMinSize((DETAILSMINWIDTH, newminh))
        self.width = max(DETAILSMINWIDTH, self.desiredwidth)
        if self.torrent.singlefile:
            self.height = newminh
            self.SetMaxSize((-1, newminh))
        else:
            self.height = max(newminh, self.desiredheight)
        self.SetSize((self.width, self.height))
        self.panel.SetSize(self.GetClientSize())
        self.panel.Layout()
        self.sizeTitle()
        self.panel.Thaw()
        self.resettingframe = False

    def resizeFrame(self, vertshift):
        self.resettingframe = True
        minw, minh = self.GetMinSize()
        if vertshift < 0:
            self.SetMinSize((minw, minh + vertshift))
            if self.torrent.singlefile:
                self.SetMaxSize((-1, minh + vertshift))
        else:
            if self.torrent.singlefile:
                self.SetMaxSize((-1, minh + vertshift))
            self.SetMinSize((minw, minh + vertshift))
        self.height += vertshift
        self.SetSize((self.width, self.height))
        self.resettingframe = False

    def clearDefaultTracker(self):
        if self.defaulttrackerindex != -1:
            self.trackerlist.SetStringItem(self.defaulttrackerindex, 1, '')

    def markDefaultTracker(self, deftracker):
        if deftracker:
            for row in xrange(self.torrent.multitracker):
                if self.trackerlist.GetItem(row, 2).GetText() == deftracker:
                    self.trackerlist.SetStringItem(row, 1, self.localize('defaulttrackermarker'))
                    self.defaulttrackerindex = row
                    break
        else:
            self.defaulttrackerindex = -1

    def showMessage(self):
        self.messagetext.SetValue(self.torrent.message)
        if not self.messagetexthead.IsShown():
            self.panel.Freeze()
            self.messagetexthead.Show()
            self.messagetext.Show()
            self.resizeFrame(self.infohash.GetSize()[1] + 4)
            self.panel.Thaw()

    def hideMessage(self):
        if self.messagetexthead.IsShown():
            self.panel.Freeze()
            self.messagetexthead.Hide()
            self.messagetext.Hide()
            self.resizeFrame(-self.infohash.GetSize()[1] - 4)
            self.panel.Thaw()

    def showExtTrackerUrl(self, url):
        self.exttrackerurl.SetValue(url)
        if not self.exttrackerurl.IsShown():
            self.panel.Freeze()
            self.exttrackerurlhead.Show()
            self.exttrackerurl.Show()
            self.resizeFrame(self.infohash.GetSize()[1] + 4)
            self.panel.Thaw()

    def hideExtTrackerUrl(self):
        self.panel.Freeze()
        self.exttrackerurlhead.Hide()
        self.exttrackerurl.Hide()
        self.resizeFrame(-self.infohash.GetSize()[1] - 4)
        self.panel.Thaw()

    def toggleFocusOnTitle(self, event):
        focus = self.FindFocus()
        if focus is self.abouttitle:
            self.oldfocus.SetFocus()
        else:
            self.oldfocus = focus
            self.abouttitle.SetFocus()

    def onMoveDet(self, event):
       self.const = False
       event.Skip()

    def onSizeDet(self, event):
        if self.IsIconized():
            event.Skip()
            return
        if self.resettingframe:
            event.Skip()
            return
        newwidth, newheight = self.GetSizeTuple()
        minwidth, minheight = self.GetMinSize()
        if newheight != self.height and not self.torrent.singlefile:
            if newheight == minheight:
                self.desiredheight = 0
            else:
                self.desiredheight = newheight
        if newwidth != self.width:
            if newwidth == minwidth:
                self.desiredwidth = 0
            else:
                self.desiredwidth = newwidth
            self.panel.Freeze()
            self.resetFrame()
        else:
            self.height = newheight
            event.Skip()
        if not self.IsMaximized():
            self.widthfornext, self.heightfornext = self.desiredwidth, self.desiredheight

    def setSize(self, size):
        if size == self.GetSizeTuple():
            self.desiredwidth, self.desiredheight = size
        else:
            self.SetSize(size)

    def sizeTitle(self):
        if self.abouttitle.GetTextExtent(self.torrent.name)[0] > self.width - 14:
            self.abouttitle.SetSize((5000, -1))
            self.abouttitle.SetWindowStyle(wx.ALIGN_LEFT)
            self.abouttitle.SetToolTipString(self.torrent.name)
        else:
            self.abouttitle.SetSize((self.width - 14, -1))
            self.abouttitle.SetWindowStyle(wx.ALIGN_CENTER)
            self.abouttitle.SetToolTipString('')

    def onMouseWheelTitle(self, event):
        oldindex = index = self.index
        oldtorrent = torrent = self.torrent
        while True:
            if event.GetWheelRotation() > 0:
                if index > 0:
                    index -= 1
                else:
                    return
            elif index < self.parent.list.GetItemCount() - 1:
                index += 1
            else:
                return
            torrent = self.parent.queue.proctab[index]
            if not torrent.isbeingdeleted:
                self.index = index
                self.torrent = torrent
                break

        if self.wintorestore is not None:
            # Restore window for old torrent
            oldtorrent.infowin = ABCMetaInfoFrame(self.parent, -1, '', self.utility, oldindex,
                                                  self.wintorestore[0], self.wintorestore[1], centeratpointer = False)
            if oldtorrent.abcengine:
                oldtorrent.abcengine.infowin = oldtorrent.infowin
            self.abouttitle.SetFocus()
        else:
            oldtorrent.infowin = None
            if oldtorrent.abcengine:
                oldtorrent.abcengine.infowin = None

        if self.torrent.infowin is not None:
            # Kill window for new torrent and save position if not hidden for later restoration
            if self.torrent.infowin.IsShown():
                if self.torrent.infowin.IsIconized() or self.torrent.infowin.IsMaximized():
                    self.wintorestore = ((-1, -1), (self.guiman.getMetaWidth(), self.guiman.getMetaHeight()))
                else:
                    self.wintorestore = (self.torrent.infowin.GetPosition(), self.torrent.infowin.GetSize())
            else:
                self.wintorestore = None
            self.torrent.infowin.killInfo()
        else:
            self.wintorestore = None

        self.torrent.infowin = self
        if self.torrent.abcengine:
            self.torrent.abcengine.infowin = self
        self.displayInfo()

        # If the old selection in list matched the displayed info, change the selection in list
        if self.parent.list.GetSelectedItemCount() == 1 and self.parent.getSelected()[0] == oldindex:
            self.parent.list.SetItemState(oldindex, 0, wx.LIST_STATE_SELECTED)
            self.parent.list.Select(self.index)
            if event.GetWheelRotation() > 0:
                if self.index > 0:
                    self.parent.list.EnsureVisible(self.index - 1)
            elif self.index < self.parent.list.GetItemCount() - 1:
                self.parent.list.EnsureVisible(self.index + 1)
            self.parent.list.EnsureVisible(self.index)

        if oldtorrent.detailwin is not None and not oldtorrent.detailwin.IsShown():
            oldtorrent.detailwin.killAdv()

    def onRightUpDet(self, event):
        self.parent.makePopupMenu(self, False)
        self.PopupMenu(self.parent.popupmenu, self.panel.ScreenToClient(event.GetEventObject().ClientToScreen(event.GetPosition())))

    def onKeyInList(self, event):
        if event.ControlDown():
            keycode = event.GetKeyCode()
            if keycode == ord('a') or keycode == ord('A'):
                # Select all files
                for index in xrange(self.torrent.filesnumber):
                    self.filelist.Select(index)
            elif keycode == self.utility.selinvert1 or keycode == self.utility.selinvert2:
                # Invert file selection
                for index in xrange(self.torrent.filesnumber):
                    self.filelist.SetItemState(index, 4 - self.filelist.GetItemState(index, wx.LIST_STATE_SELECTED), wx.LIST_STATE_SELECTED)
            elif keycode == ord('z') or keycode == ord('Z'):
                # Unselect all files
                for index in xrange(self.torrent.filesnumber):
                    self.filelist.Select(index, 0)
            else:
                event.Skip()
        else:
            event.Skip()

    def onChangeSelected(self, event):
        self.selectedfilesnumber = self.filelist.GetSelectedItemCount()
        if self.torrent.filesname:
            renamedmarker = self.localize('filerenamedmarker')
        else:
            renamedmarker = ''
        if self.torrent.filenamestatus:
            invalidmarker = self.localize('filenameinvalidmarker')
        else:
            invalidmarker = ''
        colitem = wx.ListItem()
        colitem.SetText(self.localize('files') + ' (' + str(self.selectedfilesnumber) 
                        + '/' + str(self.torrent.filesnumber) + ')' + renamedmarker + invalidmarker)
        self.filelist.SetColumn(1, colitem)

    def updateTorrentName(self):
        self.SetTitle(self.localize('torrentdetail') + self.torrent.name)
        self.abouttitle.SetLabel(self.torrent.name.replace('&', '&&'))
        self.sizeTitle()

    def updateDestination(self):
        self.destinationtext.SetValue(self.torrent.getRebuiltDest())

    def onAnnCopy(self, event):
        # Copy the selected announce url to the clipboard
        if wx.TheClipboard.Open():
            wx.TheClipboard.SetData(wx.TextDataObject(self.selectedintannounce))
            wx.TheClipboard.Close()

    def onAnnUseAsExternalTracker(self, event):
        self.parent.queue.changeLocalInfo([self.index], 22 * [None] + [1, self.selectedintannounce] + 3 * [None])

    def onAnnRescanAll(self, event):
        if self.torrent.abcengine:
            self.torrent.reannounce(tracker = 'rescan')

    def initPopupAnnMenu(self):
        # Popup menu for tracker list
        self.popupannmenu = wx.Menu()
        self.Bind(wx.EVT_MENU, self.onAnnCopy, id = 919)
        self.popupannmenu.Append(919, self.localize('announcecopy'))
        self.Bind(wx.EVT_MENU, self.onAnnUseAsExternalTracker, id = 920)
        self.popupannmenu.Append(920, self.localize('announceuseasexttrack'))
        self.Bind(wx.EVT_MENU, self.onAnnRescanAll, id = 921)
        self.popupannmenu.Append(921, self.localize('announcerescanall'))

    def onAnnounceListRightDown(self, event):
        self.x, self.y = event.GetPosition()
        event.Skip()

    def onAnnounceListRightClick(self, event):
        if not self.selectedintannounce or wx.GetKeyState(wx.WXK_CONTROL) or wx.GetKeyState(wx.WXK_SHIFT) or wx.GetKeyState(wx.WXK_ALT):
            return
        if not self.popupannmenu:
            self.initPopupAnnMenu()
        self.PopupMenu(self.popupannmenu, self.panel.ScreenToClient(self.trackerlist.ClientToScreen((self.x, self.y))))

    def onAnnounceListSelected(self, event):
        # Read tracker column from selected line
        announce = self.trackerlist.GetItem(self.trackerlist.GetNextItem(-1, wx.LIST_NEXT_ALL, wx.LIST_STATE_SELECTED), 2).GetText()
        if announce != '':
            self.selectedintannounce = announce
        else:
            self.selectedintannounce = None

    def openLikelyTracker(self, url):
        thread = Thread(target = open_new, args = [url])
        thread.daemon = False
        thread.start()

    def onDestination(self, event):
        if self.torrent.magnet == 1:
            return
        self.parent.windowparent = self
        self.parent.commandfromlist = False
        self.parent.onOpenDest(shift = event.ShiftDown())

    def onIntAnnounce(self, event):
        # Open in browser single or selected one out of multi internal likely tracker
        if self.selectedintannounce is not None:
            self.openLikelyTracker(re.compile('(.*/)[^/]+').sub(r'\1', self.selectedintannounce))

    def onExtAnnounce(self, event):
        # Open in browser single external likely tracker
        error = False
        url = re.compile('(.*/)[^/]+').sub(r'\1', self.torrent.exttrackerurl)
        if url == '':
            error = True
        else:
            try:
                self.openLikelyTracker(url)
            except:
                error = True
        if error:
            dlg = wx.MessageDialog(self, self.localize('warningcantopenurl') + '\n"' + url + '"', self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()

    def onLocate(self, event):
        # Unselect all torrents in main ABC list
        for index in self.parent.getSelected():
            self.parent.list.SetItemState(index, 0, wx.LIST_STATE_SELECTED)
        self.parent.list.EnsureVisible(self.index)
        self.parent.list.Select(self.index)
        if not self.parent.list.IsShown():
            self.parent.parent.tb.ToggleTool(self.parent.parent.maintoolbarids[0], True)
            self.parent.displayTransfer()

    def onLocalSetting(self, event):
        self.parent.windowparent = self
        self.parent.commandfromlist = False
        self.parent.onLocalSetting()

    def onAdvDetails(self, event):
        ctrl = wx.GetKeyState(wx.WXK_CONTROL)
        if self.torrent.detailwin == None:
            centerdetoneachother = self.abcparams['centerdetoneachother']
            if centerdetoneachother == '0':
                detailwinpos = self.GetPosition()
            elif centerdetoneachother == '1':
                detailwinpos = -2
            else:
                detailwinpos = -3
            self.torrent.detailwin = abcdetailframe.ABCDetailFrame(self.parent, -1, '', self.utility,
                                                                   self.index,
                                                                   detailwinpos,
                                                                   self.guiman.getDetailSize())
            if self.torrent.abcengine:
                self.torrent.abcengine.detailwin = self.torrent.detailwin
        elif self.torrent.detailwin.IsShown():
            if self.torrent.detailwin.IsIconized():
                self.torrent.detailwin.Iconize(False)
            self.torrent.detailwin.Raise()
        else:
            #self.torrent.detailwin.setAllColumnWidths()
            centerdetoneachother = self.abcparams['centerdetoneachother']
            if centerdetoneachother == '0':
                detailwinpos = self.GetPosition()
                const = False
            elif centerdetoneachother == '1':
                detailwinpos, const = self.utility.getPosCenteredOnWin(self.torrent.detailwin.GetSize(), self)
            else:
                detailwinpos, const = self.utility.getPosCenteredOnWin(self.torrent.detailwin.GetSize(), self, aligntop = True)
            if not self.const:
                self.torrent.detailwin.Move(detailwinpos)
            self.torrent.detailwin.const = const
            self.torrent.detailwin.Show()
        if not ctrl:
            self.torrent.infowin.Hide()
        x, y, w, h = self.torrent.detailwin.detailsbut.GetRect()
        self.torrent.detailwin.WarpPointer(x + w / 2, y + h / 2)

    def killInfo(self, event = None):
        if self.torrent.detailwin is not None and not self.torrent.detailwin.IsShown():
            self.torrent.detailwin.killAdv()
        self.parent.queue.deleteInfoWin(self.index)
        if self.listdraggingmode:
            self.listdraggingmode = 0
            if self.scrolltimer:
                self.scrolltimer.cancel()
                self.scrolltimer = None
        if self.popupmenu:
            self.popupmenu.Destroy()
        if self.popupannmenu:
            self.popupannmenu.Destroy()
        self.Destroy()

    def init(self):
        self.downrate.SetLabel(self.utility.rateWithUnit('', self.torrent.prioritizedown))
        self.uprate.SetLabel(self.utility.rateWithUnit('', self.torrent.prioritizeup))

    def updateSize(self):
        # Update archive size display
        if self.torrent.unwantedfiles:
            self.filesize.SetLabel(self.localize('str1p') % (self.utility.sizeFormat(self.torrent.requestedsize),
                                                             self.utility.sizeFormat(self.torrent.totalsize),
                                                             self.utility.commaFormat(self.torrent.totalsize)))
        else:
            self.filesize.SetLabel(self.localize('str1') % (self.utility.sizeFormat(self.torrent.totalsize),
                                                            self.utility.commaFormat(self.torrent.totalsize)))

    def getSelected(self):
        selected = []
        index = self.filelist.GetNextItem(-1, wx.LIST_NEXT_ALL, wx.LIST_STATE_SELECTED)
        while index != -1:
            selected.append(index)
            index = self.filelist.GetNextItem(index, wx.LIST_NEXT_ALL, wx.LIST_STATE_SELECTED)
        return selected

    def onMouseWheel(self, event):
        if not event.LeftIsDown() and not event.ControlDown() and not event.ShiftDown():
            event.Skip()
            return
        if self.torrent.complete and not self.torrent.unwantedfiles:
            dlg = wx.MessageDialog(self, self.localize('torrentcomplete'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return
        if event.GetWheelRotation() > 0:
            direction = 1
        else:
            direction = -1
        if event.ShiftDown():
            pointedindex = self.filelist.HitTest(wx.Point(event.GetX(), event.GetY()))[0]
            if pointedindex >= 0:
                shiftindex = [pointedindex]
            else:
                shiftindex = []
        else:
            shiftindex = None
        self.onChangeFilePriority(None, direction = direction, shiftindex = shiftindex)

    def onChangeFilePriority(self, event, direction = 0, shiftindex = None):
        if self.torrent.abcengine and self.torrent.abcengine.initializingfiles:
            return
        if self.torrent.complete and not self.torrent.unwantedfiles:
            dlg = wx.MessageDialog(self, self.localize('torrentcomplete'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return
        selected = []
        filepriochanged = []
        if direction == 0:
            newprio = event.GetId() - 901
        if shiftindex is None:
            selected = self.getSelected()
        else:
            selected = shiftindex
        for index in selected:
            currentprio = self.fileprio[index]
            if direction:
                if direction == -1 and currentprio == 2:
                    newprio = -1
                elif direction == -1 and currentprio == -1:
                    newprio = -1
                elif direction == 1 and currentprio == 0:
                    newprio = 0
                elif direction == 1 and currentprio == -1:
                    newprio = 2
                else:
                    newprio = currentprio - direction
            if newprio < 3 and newprio > -2 and currentprio != newprio:
                filepriochanged.append((index, newprio))
        if filepriochanged:
            self.torrent.changeFilePriorities(filepriochanged, self.index, self.filesinfo)

    def onListRightClick(self, event):
        if wx.GetKeyState(wx.WXK_CONTROL) or wx.GetKeyState(wx.WXK_SHIFT) or wx.GetKeyState(wx.WXK_ALT):
            return
        if not self.popupmenu:
            self.initPopupMenu()
        if self.torrent.abcengine:
            self.popupmenu.Enable(917, False)
            self.popupmenu.Enable(927, False)
            self.popupmenu.Enable(1041, False)
            if self.torrent.abcengine.initializingfiles:
                self.popupmenu.Enable(916, False)
                self.popupmenu.Enable(901, False)
                self.popupmenu.Enable(902, False)
                self.popupmenu.Enable(903, False)
                self.popupmenu.Enable(900, False)
            else:
                self.popupmenu.Enable(916, True)
                self.popupmenu.Enable(901, True)
                self.popupmenu.Enable(902, True)
                self.popupmenu.Enable(903, True)
                self.popupmenu.Enable(900, True)
        else:
            if self.torrent.ongoing is not None:
                self.popupmenu.Enable(917, False)
                self.popupmenu.Enable(927, False)
                self.popupmenu.Enable(1041, False)
            else:
                self.popupmenu.Enable(917, True)
                self.popupmenu.Enable(927, True)
                self.popupmenu.Enable(1041, True)
            self.popupmenu.Enable(916, True)
            self.popupmenu.Enable(901, True)
            self.popupmenu.Enable(902, True)
            self.popupmenu.Enable(903, True)
            self.popupmenu.Enable(900, True)

        self.popupmenu.Check(self.fileprio[self.filelist.HitTest((self.x, self.y))[0]] + 901, True)
        self.popupmenu.Check(915, self.originalfilenamesshown)
        self.PopupMenu(self.popupmenu, self.panel.ScreenToClient(self.filelist.ClientToScreen((self.x, self.y))))

    def onLeftDown(self, event):
        self.x, self.y = event.GetPosition()
        self.selectedrow = self.filelist.HitTest((self.x, self.y))[0]
        if self.selectedrow >= 0:
            event.Skip()
        else:
            for index in self.getSelected():
                self.filelist.SetItemState(index, 0, wx.LIST_STATE_SELECTED)

    def onRightDown(self, event):
        self.x, self.y = event.GetPosition()
        self.selectedrow = self.filelist.HitTest((self.x, self.y))[0]
        if self.selectedrow >= 0:
            event.Skip()

    def onListDoubleClick(self, event):
        fileindex = self.filelist.GetNextItem(-1, wx.LIST_NEXT_ALL, wx.LIST_STATE_SELECTED)
        if fileindex == -1 or self.filelist.GetItem(fileindex, 3 + self.originalfilenamesshown).GetText() != self.localize('done'):
            return
        filename = self.filelist.GetItem(fileindex, 1).GetText()
        filepath = join(self.utility.completePath(self.torrent.dest), filename)
        error = False
        if not exists(filepath):
            if self.torrent.status != 'finished':
                error = True
            else:
                filepath = join(self.torrent.getFinalDest(), filename)
                if not exists(filepath):
                    error = True
        if error:
            dlg = wx.MessageDialog(self, split(filename)[1] + '\n' + self.localize('filenotfound'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
        else:
            try:
                startfile(filepath)
            except:
                pass

    def initPopupMenu(self):
        self.popupmenu = wx.Menu()
        self.popupmenu.Append(916, self.localize('downloadselected'), "")
        self.Bind(wx.EVT_MENU, self.onDownloadSelected, id = 916)
        self.popupmenu.AppendSeparator()
        self.popupmenu.AppendRadioItem(901, self.localize('filepriorityhigh'), "")
        self.popupmenu.AppendRadioItem(902, self.localize('fileprioritynormal'), "")
        self.popupmenu.AppendRadioItem(903, self.localize('fileprioritylow'), "")
        self.popupmenu.AppendRadioItem(900, self.localize('fileprioritynever'), "")
        self.Bind(wx.EVT_MENU, self.onChangeFilePriority, id = 900, id2 = 903)
        self.popupmenu.AppendSeparator()
        self.popupmenu.Append(1042, self.localize('findinfilenames'), "")
        self.Bind(wx.EVT_MENU, self.onFindInFileNames, id = 1042)
        self.popupmenu.Append(1043, self.localize('selectinvalidfilenames'), "")
        self.Bind(wx.EVT_MENU, self.onSelectInvalidFileNames, id = 1043)
        self.popupmenu.AppendSeparator()
        self.popupmenu.Append(918, self.localize('filenamecopy'), "")
        self.Bind(wx.EVT_MENU, self.onCopyFileNames, id = 918)
        self.popupmenu.Append(1040, self.localize('originalfilenamecopy'), "")
        self.Bind(wx.EVT_MENU, self.onCopyOriginalFileNames, id = 1040)
        self.popupmenu.AppendSeparator()
        self.popupmenu.Append(917, self.localize('filenamerename'), "")
        self.Bind(wx.EVT_MENU, self.onRenameFiles, id = 917)
        self.popupmenu.Append(927, self.localize('filenamerenamefromclipboard'), "")
        self.Bind(wx.EVT_MENU, self.onRenameFilesFromClipboard, id = 927)
        self.popupmenu.Append(1041, self.localize('filenameresettooriginal'), "")
        self.Bind(wx.EVT_MENU, self.onResetFilesToOriginalNames, id = 1041)
        self.popupmenu.Append(915, self.localize('filenameshoworiginal'), "", wx.ITEM_CHECK)
        self.Bind(wx.EVT_MENU, self.onShowOriginalFileNames, id = 915)

    def updateNames(self, files = None):
        # Update displayed file list with local file names
        if files is None:
            files = xrange(self.torrent.filesnumber)
        # Update Files column header
        item = wx.ListItem()
        if self.torrent.filesname:
            renamedmarker = self.localize('filerenamedmarker')
        else:
            renamedmarker = ''
        if self.torrent.filenamestatus:
            invalidmarker = self.localize('filenameinvalidmarker')
        else:
            invalidmarker = ''
        item.SetText(self.localize('files') + ' (' + str(self.selectedfilesnumber) 
                                   + '/' + str(self.torrent.filesnumber) + ')' + renamedmarker + invalidmarker)
        self.filelist.SetColumn(1, item)
        # Update file name
        origfiles = self.torrent.getOriginalFileNames(self.filesinfo)
        for i in files:
            self.filelist.SetStringItem(i, 1, self.filesname[i])
            if self.originalfilenamesshown:
                if self.filesname[i] != origfiles[i]:
                    if not self.filelist.GetItem(i, 2).GetText():
                        self.nbrenamed += 1
                    self.filelist.SetStringItem(i, 2, origfiles[i])
                else:
                    if self.filelist.GetItem(i, 2).GetText():
                        self.nbrenamed -= 1
                    self.filelist.SetStringItem(i, 2, '')
        self.filelist.SetColumnWidth(1, wx.LIST_AUTOSIZE_USEHEADER)
        # Update Original file name column header
        if self.originalfilenamesshown:
            colitem = wx.ListItem()
            colitem.SetText(self.localize('originalfilenames') + ' (' + str(self.nbrenamed) + ')')
            self.filelist.SetColumn(2, colitem)
            self.filelist.SetColumnWidth(2, wx.LIST_AUTOSIZE_USEHEADER)

    def displayFileNameStatus(self, files = None, reset = True):
        # Display in file list the status of file names
        if files is None:
            files = xrange(self.torrent.filesnumber)
        statuscol = 4 + self.originalfilenamesshown
        # Fill status and colour bad files in red
        invalidnumber = 0
        if self.torrent.filenamestatus:
            for i in files:
                s = self.torrent.filenamestatus[i]
                if s:
                    status = ''
                    if s & 1:
                        status += self.utility.filenamestatus[0] + ' ; '
                    if s & 2:
                        status += self.utility.filenamestatus[1] + ' ; '
                    if s & 4:
                        status += self.utility.filenamestatus[2] + ' ; '
                    elif s & 8:
                        status += self.utility.filenamestatus[3] + ' ; '
                    if s & 16:
                        status += self.utility.filenamestatus[4] + ' ; '
                    self.filelist.SetStringItem(i, statuscol, status[:-3])
                    self.filelist.SetItemTextColour(i, wx.Colour(255, 0, 0))
                elif reset:
                    self.filelist.SetStringItem(i, statuscol, '')
                    self.filelist.SetItemTextColour(i, wx.Colour(0, 0, 0))
            invalidnumber = len([s for s in self.torrent.filenamestatus if s])
        elif reset:
            for i in files:
                self.filelist.SetStringItem(i, statuscol, '')
                self.filelist.SetItemTextColour(i, wx.Colour(0, 0, 0))
            namecol = wx.ListItem()
            if self.torrent.filesname:
                renamedmarker = self.localize('filerenamedmarker')
            else:
                renamedmarker = ''
            namecol.SetText(self.localize('files') + ' (' + str(self.selectedfilesnumber) 
                            + '/' + str(self.torrent.filesnumber) + ')' + renamedmarker)
            self.filelist.SetColumn(1, namecol)
        statuscol = wx.ListItem()
        statuscol.SetText(self.localize('filenamestatus') + ' (' + str(invalidnumber) + ')')
        self.filelist.SetColumn(4 + self.originalfilenamesshown, statuscol)

    def onDownloadSelected(self, event):
        # Set to "Never download" all but selected
        if self.torrent.abcengine and self.torrent.abcengine.initializingfiles:
            return
        if self.torrent.complete and not self.torrent.unwantedfiles:
            dlg = wx.MessageDialog(self, self.localize('torrentcomplete'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return
        selected = self.getSelected()
        filepriochanged = []
        for index in xrange(self.torrent.filesnumber):
            if index in selected:
                if self.fileprio[index] == -1:
                    filepriochanged.append((index, 1))
            elif self.fileprio[index] != -1:
                filepriochanged.append((index, -1))
        if filepriochanged:
            self.torrent.changeFilePriorities(filepriochanged, self.index, self.filesinfo)

    def onFindInFileNames(self, event):
        dialog = wx.TextEntryDialog(self,
                                    self.localize('findstringinnames'),
                                    self.localize('findstringinnames_short'))
        wx.Dialog.SetWindowStyle(dialog, wx.CAPTION | wx.CLOSE_BOX | wx.TAB_TRAVERSAL | wx.RESIZE_BORDER)
        dialog.SetSize((int(self.abcparams['findinfilenamesw']), -1))
        height = dialog.GetSize()[1]
        dialog.SetMinSize((300, height))
        dialog.SetMaxSize((-1, height))
        dialog.Centre()
        result = dialog.ShowModal()
        findstring = dialog.GetValue().lower()
        self.abcparams['findinfilenamesw'] = str(dialog.GetSizeTuple()[0])
        dialog.Destroy()
        if result != wx.ID_OK:
            return

        if findstring:
            for row in xrange(self.torrent.filesnumber):
                if self.filelist.GetItem(row, 1).GetText().lower().find(findstring) >= 0:
                    self.filelist.Select(row)
                else:
                    self.filelist.Select(row, 0)
            if not self.getSelected():
                dlg = wx.MessageDialog(self, self.localize('warningfindinfilenames'),
                                       self.localize('abcokcwarning'), wx.ICON_WARNING)
                dlg.ShowModal()
                dlg.Destroy()
        else:
            for row in xrange(self.torrent.filesnumber):
                self.filelist.Select(row, 0)

    def onSelectInvalidFileNames(self, event = None):
        if self.torrent.filenamestatus:
            i = 0
            for s in self.torrent.filenamestatus:
                if s:
                    self.filelist.Select(i)
                else:
                    self.filelist.Select(i, 0)
                i += 1
        else:
            for row in xrange(self.torrent.filesnumber):
                self.filelist.Select(row, 0)

    def onCopyFileNames(self, event):
        clickedcol = self.utility.getListClickedColumn(self.filelist, self.x)
        if clickedcol == 1 or clickedcol == 2 and self.originalfilenamesshown:
            colrange = [clickedcol]
        else:
            colrange = xrange(self.filelist.GetColumnCount())
        names = []
        selected = self.getSelected()
        if selected:
            for index in selected:
                names.append('\t'.join([self.filelist.GetItem(index, col).GetText() for col in colrange]))
            if wx.TheClipboard.Open():
                wx.TheClipboard.SetData(wx.TextDataObject('\n'.join(names)))
                wx.TheClipboard.Close()

    def onCopyOriginalFileNames(self, event):
        names = []
        selected = self.getSelected()
        if selected:
            origfilenames = self.torrent.getOriginalFileNames(self.torrent.getResponse()['info']['files'])
            if wx.TheClipboard.Open():
                wx.TheClipboard.SetData(wx.TextDataObject('\n'.join([origfilenames[i] for i in selected])))
                wx.TheClipboard.Close()

    def onRenameFiles(self, event = None):
        if self.torrent.ismovingdata:
            return
        if self.torrent.abcengine or self.torrent.ongoing is not None:
            dlg = wx.MessageDialog(self, self.localize('errorfilerename'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return
        selected = self.getSelected()
        if selected:
            self.torrent.renameFiles(selected, self.filesname, filesinfo = self.filesinfo)
            self.updateNames(selected)

    def onRenameFilesFromClipboard(self, event = None):
        if self.torrent.ismovingdata:
            return
        if self.torrent.abcengine or self.torrent.ongoing is not None:
            dlg = wx.MessageDialog(self, self.localize('errorfilerename'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return
        selected = self.getSelected()
        if not wx.TheClipboard.IsOpened():
            wx.TheClipboard.Open()
            newnames = wx.TextDataObject()
            success = wx.TheClipboard.GetData(newnames)
            wx.TheClipboard.Close()
            if not success:
                return
            newnames = newnames.GetText().splitlines()
            # Check if number of lines matches number of selected names
            if len(newnames) != len(selected):
                dlg = wx.MessageDialog(self, self.localize('errorfilerenamefromclipboard'),
                                       self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return
            selectedrenamed = []
            status = ''
            caller = ''
            for i in xrange(len(selected)) :
                if status and caller != 'web':
                    dlg = RenFromClipDialog(self, -1, self.localize('abcokcerror'))
                    result = dlg.ShowModal()
                    dlg.Destroy()
                    if result == 1:
                        break
                    if result == 2:
                        # to skip the display of all error messages
                        caller = 'web'
                status = self.torrent.renameFiles([selected[i]], self.filesname, newname = newnames[i],
                                                  filesinfo = self.filesinfo, caller = caller)
                selectedrenamed.append(selected[i])
            self.updateNames(selectedrenamed)

    def onResetFilesToOriginalNames(self, event):
        if self.torrent.ismovingdata:
            return
        if self.torrent.abcengine:
            dlg = wx.MessageDialog(self, self.localize('errorfilerename'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return

        if self.torrent.filesname is not None:
            self.torrent.filesname = None
            try:
                remove(self.torrent.src + '.nam')
            except:
                pass

        if self.abcparams['skiplengthautofixonreset'] == '1':
            lengthautofix = False
        else:
            lengthautofix = None
        self.torrent.checkFileNames(self, self.filesinfo, lengthautofix = lengthautofix)
        self.filesname = self.torrent.getFileNames(filesinfo = self.filesinfo)
        self.updateNames()
        self.displayFileNameStatus()
        try:
            remove(join(self.utility.completePath(self.torrent.dest), self.abcparams['originalfilenameslist']))
        except:
            pass

    def onShowOriginalFileNames(self, event = None, show = True):
        if event is None and show or event is not None and event.IsChecked():
            header = self.localize('originalfilenames')
            self.filelist.InsertColumn(2, header, wx.LIST_AUTOSIZE_USEHEADER)
            self.originalfilenamesshown = 1
            origfiles = self.torrent.getOriginalFileNames(self.filesinfo)
            self.nbrenamed = 0
            if self.torrent.filesname:
                for i in xrange(self.torrent.filesnumber):
                    if self.filesname[i] != origfiles[i]:
                        self.filelist.SetStringItem(i, 2, origfiles[i])
                        self.nbrenamed += 1
            colitem = wx.ListItem()
            colitem.SetText(header + ' (' + str(self.nbrenamed) + ')')
            self.filelist.SetColumn(2, colitem)
            self.filelist.SetColumnWidth(2, wx.LIST_AUTOSIZE_USEHEADER)
        elif event is None and not show or event is not None and not event.IsChecked():
            self.filelist.DeleteColumn(2)
            self.originalfilenamesshown = 0

    def onLeftColour(self, event):
        if not self.torrent.singlefile:
            if wx.Window.FindFocus() == self.colour:
                self.filelist.SetFocus()
            else:
                if not self.selectedfilesnumber:
                    self.onSelectInvalidFileNames()
                self.colour.SetFocus()

    def onMouseWheelColour(self, event):
        if not self.torrent.singlefile and self.torrent.filesnumber:
            if event.GetWheelRotation() > 0:
                tobeshown = self.filelist.GetNextItem(self.filelist.GetTopItem(), wx.LIST_NEXT_ABOVE, wx.LIST_STATE_SELECTED)
                if tobeshown == -1:
                    lastfile = self.filelist.GetItemCount() - 1
                    if self.filelist.IsSelected(lastfile):
                        tobeshown = lastfile
                    else:
                        tobeshown = self.filelist.GetNextItem(lastfile, wx.LIST_NEXT_ABOVE, wx.LIST_STATE_SELECTED)
            else:
                tobeshown = self.filelist.GetNextItem(self.filelist.GetTopItem() + self.filelist.GetCountPerPage() - 1, wx.LIST_NEXT_ALL, wx.LIST_STATE_SELECTED)
                if tobeshown == -1:
                    tobeshown = self.filelist.GetNextItem(-1, wx.LIST_NEXT_ALL, wx.LIST_STATE_SELECTED)
            if tobeshown != -1:
                self.filelist.EnsureVisible(tobeshown)

    def onListColLeftClick(self, event):
        if event.m_col == 1:
            wx.CallAfter(self.onRenameFiles)
        elif event.m_col == 2:
            if self.originalfilenamesshown:
                self.onShowOriginalFileNames(show = False)
        elif event.m_col == 4 and not self.originalfilenamesshown or event.m_col == 5 and self.originalfilenamesshown:
            self.onSelectInvalidFileNames()

    def onListColRightClick(self, event):
        if self.originalfilenamesshown:
            self.onShowOriginalFileNames(show = False)
        else:
            self.onShowOriginalFileNames()

    def updateFilePriority(self, priority):
        self.filelist.SetStringItem(priority[0], 0, self.fileprio_s[priority[1] + 1])
        self.fileprio[priority[0]] = priority[1]

    def onLeftDragList(self, event):
        if self.abcparams['mousemode'] == '0':
            self.listdraggingmode = 0
        else:
            self.listdraggingmode =1

    def onRightDragList(self, event):
        if self.abcparams['mousemode'] == '0':
            self.listdraggingmode = 1
        else:
            self.listdraggingmode = 0

    def onMotionInList(self, event):
        selectedrow = self.filelist.HitTest(event.GetPosition())[0]
        # List scrolling
        if self.utility.scrolldelay and self.listdraggingmode:
            topitem = self.filelist.GetTopItem()
            botitem = max(topitem + self.filelist.GetCountPerPage() - 1, 0)
            if selectedrow == topitem:
                if not self.scrolltimer:
                    self.scrolltimer = Timer(self.utility.scrolldelay, self.invokeLater, [self.scrollList, [1, selectedrow]])
                    self.scrolltimer.start()
            elif selectedrow >= botitem:
                if not self.scrolltimer:
                    self.scrolltimer = Timer(self.utility.scrolldelay, self.invokeLater, [self.scrollList, [-1, selectedrow - (selectedrow > botitem)]])
                    self.scrolltimer.start()
            elif self.scrolltimer:
                self.scrolltimer.cancel()
                self.scrolltimer = None
        event.Skip()

    def scrollList(self, dir, row):
        if self.scrolltimer:
            row -= dir
            if 0 <= row < self.filelist.GetItemCount():
                self.filelist.EnsureVisible(row)
                self.scrolltimer = Timer(self.utility.scrolldelay, self.invokeLater, [self.scrollList, [dir, row]])
                self.scrolltimer.start()

    def endDraggingForSelecting(self, index):
        self.listdraggingmode = 0
        if self.scrolltimer:
            self.scrolltimer.cancel()
            self.scrolltimer = None
        if index >= 0 and self.selectedrow >= 0:
            if index > self.selectedrow:
                dir = 1
            else:
                dir = -1
            for i in xrange(self.selectedrow + dir, index + dir, dir):
                self.filelist.Select(i)

    def onRightUp(self, event):
        if self.abcparams['mousemode'] == '0':
            if self.listdraggingmode == 1:
                self.endDraggingForSelecting(self.filelist.HitTest((event.GetX(), event.GetY()))[0])
        else:
            self.listdraggingmode = 0

    def onLeftUp(self, event):
        if self.abcparams['mousemode'] == '0':
            self.listdraggingmode = 0
        else:
            if self.listdraggingmode == 1:
                self.endDraggingForSelecting(self.filelist.HitTest((event.GetX(), event.GetY()))[0])

    def onLeaveList(self, event):
        # To handle dragging the mouse out of the list with the left or right button pressed
        if self.scrolltimer:
            self.scrolltimer.cancel()
            self.scrolltimer = None
        event.Skip()

    def onEnterList(self, event):
        # To handle dragging the mouse back into the list without the left or right button pressed
        if self.listdraggingmode and not (event.LeftIsDown() or event.RightIsDown()) :
            self.listdraggingmode = 0
            if self.scrolltimer:
                self.scrolltimer.cancel()
                self.scrolltimer = None
        event.Skip()
