##############################################################################
# Module : abc_okc_proc.py
# Author : Old King Cole
# Date   : 04/16/2023
#
# Description : Checker for the end of process of ABC_OKC
#
##############################################################################

import wx, sys
from os import popen, path
from utility import Stderr
sys.stderr = Stderr()
from time import sleep
from commandline import getCommandLine, createProcess
from Dialogs.exitdlg import ExitDialog


class ABCProc(wx.App):
    def __init__(self, x, params):
        self.abcpath = path.split(params[0])[0]
        self.pos = (int(params[1]), int(params[2]))
        self.restart = params[3] == '1'
        self.restartparams = params[4]
        self.msg = params[5]
        wx.App.__init__(self, x)

    def OnInit(self):
        self.showProc()
        return True

    def showProc(self):
        exitdialog = ExitDialog(self.msg, self.pos)
        exitdialog.Show()
        sleep(.5)
        while self.isRunning():
            sleep(1)
        exitdialog.Destroy()
        if self.restart:
            self.restartProc()

    def isRunning(self):
        for p in popen('tasklist /FI "IMAGENAME eq abc_okc.exe" /NH').read().split('\n'):
            if "abc_okc.exe" in p.lower():
                return True
        return False

    def restartProc(self):
        proc = 'abc.exe'
        if self.restartparams:
            proc += " " + self.restartparams
        createProcess(path.join(self.abcpath, proc))

    def OnExit(self):
        return 0


app = ABCProc(0, getCommandLine())
app.MainLoop()
