!define PRODUCT "ABC_OKC"
!define VERSION "4.4.52"
!include "MUI.nsh"

;--------------------------------
;Configuration
 Unicode True

;General
 Name "${PRODUCT} ${VERSION}"
 OutFile "${PRODUCT}-win32.exe"

;Folder selection page
 InstallDir "$PROGRAMFILES\${PRODUCT}"
 
;Remember install folder
 InstallDirRegKey HKCU "Software\${PRODUCT}" "InstallDir"

 SetCompressor "lzma"

 CompletedText "Install Complete. Thank you for choosing ${PRODUCT}"

 BrandingText "${PRODUCT}"

;--------------------------------
;Modern UI Configuration

 !define MUI_ABORTWARNING
 !define MUI_HEADERIMAGE
 #!define MUI_HEADERIMAGE_BITMAP "${NSISDIR}\Contrib\Icons\modern-header.bmp"

;--------------------------------
;Pages

 !define MUI_LICENSEPAGE_RADIOBUTTONS
 !define MUI_LICENSEPAGE_RADIOBUTTONS_TEXT_ACCEPT "I accept"
 !define MUI_LICENSEPAGE_RADIOBUTTONS_TEXT_DECLINE "I decline"

 !insertmacro MUI_PAGE_LICENSE "LICENSE.txt"
 !insertmacro MUI_PAGE_COMPONENTS
 !insertmacro MUI_PAGE_DIRECTORY
 !insertmacro MUI_PAGE_INSTFILES
 
 !insertmacro MUI_UNPAGE_CONFIRM
 !insertmacro MUI_UNPAGE_INSTFILES

;--------------------------------
;Languages

 !insertmacro MUI_LANGUAGE "English"
 
;--------------------------------
;Language Strings

;Description
 LangString DESC_SecMain ${LANG_ENGLISH} "Install ${PRODUCT}"
 LangString DESC_SecDesk ${LANG_ENGLISH} "Create desktop shortcuts"
 LangString DESC_SecStart ${LANG_ENGLISH} "Create start menu shortcuts"
 LangString DESC_SecDefault ${LANG_ENGLISH} "Associate .torrent files and magnet URLs with ${PRODUCT}"

;--------------------------------
;Installer Sections

Section "!Main EXE" SecMain
 SectionIn RO
 SetOutPath "$INSTDIR"
;--------------------------------
;Move old config to ALLUSERSDATA
 Var /GLOBAL OLDCONFDIR
 ReadRegStr $OLDCONFDIR HKLM "Software\${PRODUCT}" "InstallDir"
 IfErrors invalidoldconfdir validoldconfdir
 invalidoldconfdir:
 StrCpy $OLDCONFDIR "$INSTDIR"
 validoldconfdir:
 SetShellVarContext all
 Var /GLOBAL OLDDATADIR
 StrCpy $OLDDATADIR "$APPDATA\${PRODUCT}\olddata"
 CreateDirectory "$APPDATA\${PRODUCT}\olddata"
 IfFileExists "$OLDCONFDIR\abc.conf" moveabcconf abcconf
 moveabcconf:
 CopyFiles /SILENT "$OLDCONFDIR\abc.conf" "$OLDDATADIR"
 IfErrors errorwhilemovingdata
 StrCmp $OLDCONFDIR $INSTDIR deleteabcconf abcconf
 deleteabcconf:
 Delete "$INSTDIR\abc.conf"
 abcconf:
 IfFileExists "$OLDCONFDIR\scheduler.conf" moveschedulerconf schedulerconf
 moveschedulerconf:
 CopyFiles /SILENT "$OLDCONFDIR\scheduler.conf" "$OLDDATADIR"
 IfErrors errorwhilemovingdata
 StrCmp $OLDCONFDIR $INSTDIR deleteschedulerconf schedulerconf
 deleteschedulerconf:
 Delete "$INSTDIR\scheduler.conf"
 schedulerconf:
 IfFileExists "$OLDCONFDIR\scanner.conf" movescannerconf scannerconf
 movescannerconf:
 CopyFiles /SILENT "$OLDCONFDIR\scanner.conf" "$OLDDATADIR"
 IfErrors errorwhilemovingdata
 StrCmp $OLDCONFDIR $INSTDIR deletescannerconf scannerconf
 deletescannerconf:
 Delete "$INSTDIR\scanner.conf"
 scannerconf:
 IfFileExists "$OLDCONFDIR\webservice.conf" movewebserviceconf webserviceconf
 movewebserviceconf:
 CopyFiles /SILENT "$OLDCONFDIR\webservice.conf" "$OLDDATADIR"
 IfErrors errorwhilemovingdata
 StrCmp $OLDCONFDIR $INSTDIR deletewebserviceconf webserviceconf
 deletewebserviceconf:
 Delete "$INSTDIR\webservice.conf"
 webserviceconf:
 IfFileExists "$OLDCONFDIR\abc.ini" moveabcini abcini
 moveabcini:
 CopyFiles /SILENT "$OLDCONFDIR\abc.ini" "$OLDDATADIR"
 IfErrors errorwhilemovingdata
 StrCmp $OLDCONFDIR $INSTDIR deleteabcini abcini
 deleteabcini:
 Delete "$INSTDIR\abc.ini"
 abcini:
 IfFileExists "$OLDCONFDIR\torrent.lst" movetorrentlst torrentlst
 movetorrentlst:
 CopyFiles /SILENT "$OLDCONFDIR\torrent.lst" "$OLDDATADIR"
 IfErrors errorwhilemovingdata
 StrCmp $OLDCONFDIR $INSTDIR deletetorrentlst torrentlst
 deletetorrentlst:
 Delete "$INSTDIR\torrent.lst"
 torrentlst:
 IfFileExists "$OLDCONFDIR\torrent.lst.sav1" movetorrentlstsav1 torrentlstsav1
 movetorrentlstsav1:
 CopyFiles /SILENT "$OLDCONFDIR\torrent.lst.sav1" "$OLDDATADIR"
 IfErrors errorwhilemovingdata
 StrCmp $OLDCONFDIR $INSTDIR deletetorrentlstsav1 torrentlstsav1
 deletetorrentlstsav1:
 Delete "$INSTDIR\torrent.lst.sav1"
 torrentlstsav1:
 IfFileExists "$OLDCONFDIR\torrent.lst.sav2" movetorrentlstsav2 torrentlstsav2
 movetorrentlstsav2:
 CopyFiles /SILENT "$OLDCONFDIR\torrent.lst.sav2" "$OLDDATADIR"
 IfErrors errorwhilemovingdata
 StrCmp $OLDCONFDIR $INSTDIR deletetorrentlstsav2 torrentlstsav2
 deletetorrentlstsav2:
 Delete "$INSTDIR\torrent.lst.sav2"
 torrentlstsav2:
 IfFileExists "$OLDCONFDIR\conlimiter.lst" moveconlimiterlst conlimiterlst
 moveconlimiterlst:
 CopyFiles /SILENT "$OLDCONFDIR\conlimiter.lst" "$OLDDATADIR"
 IfErrors errorwhilemovingdata
 StrCmp $OLDCONFDIR $INSTDIR deleteconlimiterlst conlimiterlst
 deleteconlimiterlst:
 Delete "$INSTDIR\conlimiter.lst"
 conlimiterlst:
 IfFileExists "$OLDCONFDIR\announce.lst" moveannouncelst announcelst
 moveannouncelst:
 CopyFiles /SILENT "$OLDCONFDIR\announce.lst" "$OLDDATADIR"
 IfErrors errorwhilemovingdata
 StrCmp $OLDCONFDIR $INSTDIR deleteannouncelst announcelst
 deleteannouncelst:
 Delete "$INSTDIR\announce.lst"
 announcelst:
 IfFileExists "$OLDCONFDIR\command.lst" movecommandlst commandlst
 movecommandlst:
 CopyFiles /SILENT "$OLDCONFDIR\command.lst" "$OLDDATADIR"
 IfErrors errorwhilemovingdata
 StrCmp $OLDCONFDIR $INSTDIR deletecommandlst commandlst
 deletecommandlst:
 Delete "$INSTDIR\command.lst"
 commandlst:
 IfFileExists "$OLDCONFDIR\rssfeed.lst" moverssfeedlst rssfeedlst
 moverssfeedlst:
 CopyFiles /SILENT "$OLDCONFDIR\rssfeed.lst" "$OLDDATADIR"
 IfErrors errorwhilemovingdata
 StrCmp $OLDCONFDIR $INSTDIR deleterssfeedlst rssfeedlst
 deleterssfeedlst:
 Delete "$INSTDIR\rssfeed.lst"
 rssfeedlst:
 IfFileExists "$OLDCONFDIR\rule.lst" moverulelst rulelst
 moverulelst:
 CopyFiles /SILENT "$OLDCONFDIR\rule.lst" "$OLDDATADIR"
 IfErrors errorwhilemovingdata
 StrCmp $OLDCONFDIR $INSTDIR deleterulelst rulelst
 deleterulelst:
 Delete "$INSTDIR\rule.lst"
 rulelst:
 IfFileExists "$OLDCONFDIR\search.lst" movesearchlst searchlst
 movesearchlst:
 CopyFiles /SILENT "$OLDCONFDIR\search.lst" "$OLDDATADIR"
 IfErrors errorwhilemovingdata
 StrCmp $OLDCONFDIR $INSTDIR deletesearchlst searchlst
 deletesearchlst:
 Delete "$INSTDIR\search.lst"
 searchlst:
 IfFileExists "$OLDCONFDIR\url.lst" moveurllst urllst
 moveurllst:
 CopyFiles /SILENT "$OLDCONFDIR\url.lst" "$OLDDATADIR"
 IfErrors errorwhilemovingdata
 StrCmp $OLDCONFDIR $INSTDIR deleteurllst urllst
 deleteurllst:
 Delete "$INSTDIR\url.lst"
 urllst:
 IfFileExists "$OLDCONFDIR\template.lst" movetemplatelst templatelst
 movetemplatelst:
 CopyFiles /SILENT "$OLDCONFDIR\template.lst" "$OLDDATADIR"
 IfErrors errorwhilemovingdata
 StrCmp $OLDCONFDIR $INSTDIR deletetemplatelst templatelst
 deletetemplatelst:
 Delete "$INSTDIR\template.lst"
 templatelst:
 IfFileExists "$OLDCONFDIR\torrent\*.*" movetorrent torrent
 movetorrent:
 CopyFiles /SILENT "$OLDCONFDIR\torrent" "$OLDDATADIR"
 IfErrors errorwhilemovingdata
 StrCmp $OLDCONFDIR $INSTDIR deletetorrent torrent
 deletetorrent:
 RMDir /r "$INSTDIR\torrent"
 torrent:
;--------------------------------
;Remove old HKLM keys
 DeleteRegKey HKLM "SOFTWARE\${PRODUCT}"
 DeleteRegKey HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT}"
;--------------------------------
;Remove created olddata directories if empty
 RMDir "$APPDATA\${PRODUCT}\olddata"
 RMDir "$APPDATA\${PRODUCT}"
;--------------------------------
;Install to INSTDIR
 Delete "$INSTDIR\*.manifest"
 File LICENSE.txt
 File *.ico
 File readme.txt
 File abc.exe
 File abc_okc.exe
 File abcproc.exe
 File AboutTheRSSFeedScanner.html
 File defdhtrouter.txt
 Delete "$INSTDIR\*.pyd"
 File *.pyd
 Delete "$INSTDIR\*.dll"
 File *.dll
 Delete "$INSTDIR\*.zip"
 File *.zip
 CreateDirectory "$INSTDIR\defaultconf"
 SetOutPath "$INSTDIR\defaultconf"
 File defaultconf\*.*
 CreateDirectory "$INSTDIR\icons"
 SetOutPath "$INSTDIR\icons"
 File icons\*.*
 CreateDirectory "$INSTDIR\lang"
 SetOutPath "$INSTDIR\lang"
 File lang\*.*
 CreateDirectory "$INSTDIR\locale\fr\LC_MESSAGES"
 SetOutPath "$INSTDIR\locale\fr\LC_MESSAGES"
 File locale\fr\LC_MESSAGES\wxstd.mo
;--------------------------------
; Registry
 WriteRegStr HKCU "Software\${PRODUCT}" "InstallDir" "$INSTDIR"
 WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT}" "DisplayName" "${PRODUCT} (remove only)"
 WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT}" "UninstallString" "$INSTDIR\Uninstall.exe"
;--------------------------------
; Remove old error log if present
 Delete "$INSTDIR\abc.exe.log"
 Delete "$INSTDIR\abc_okc.exe.log"
 Delete "$INSTDIR\abcproc.exe.log"
 WriteUninstaller "$INSTDIR\Uninstall.exe"
 Goto fin
;--------------------------------
; Errorwhilemovingdata
 errorwhilemovingdata:
 Abort "Error while moving data from installation directory to Windows all users data directory"
 fin:
SectionEnd

Section "Desktop Icons" SecDesk
;--------------------------------
;Try to remove old shortcuts for single user
 SetShellVarContext current
 Delete "$DESKTOP\${PRODUCT}.lnk"
;--------------------------------
;Create shortcuts for all user
 SetShellVarContext all
 SetOutPath "$INSTDIR"
 CreateShortCut "$DESKTOP\${PRODUCT}.lnk" "$INSTDIR\abc.exe"
SectionEnd

Section "Startmenu Icons" SecStart
;--------------------------------
;Try to remove old shortcuts for single user
 SetShellVarContext current
 RMDir /r "$SMPROGRAMS\${PRODUCT}"
;--------------------------------
;Create shortcuts for all user
 SetShellVarContext all
 SetOutPath "$INSTDIR"
 CreateDirectory "$SMPROGRAMS\${PRODUCT}"
 CreateShortCut "$SMPROGRAMS\${PRODUCT}\Uninstall ${PRODUCT}.lnk" "$INSTDIR\Uninstall.exe" "" "$INSTDIR\Uninstall.exe" 0
 CreateShortCut "$SMPROGRAMS\${PRODUCT}\${PRODUCT}.lnk" "$INSTDIR\abc.exe"
SectionEnd

Section "Make Default" SecDefault
 SetShellVarContext all
 ;Associate torrent files
 WriteRegStr HKCU "Software\Classes\.torrent" "" bittorrent 
 WriteRegStr HKCU "Software\Classes\.torrent" "Content Type" application/x-bittorrent
 WriteRegStr HKCU "Software\Classes\MIME\Database\Content Type\application/x-bittorrent" Extension .torrent
 WriteRegStr HKCU "Software\Classes\bittorrent" "" "TORRENT File"
 WriteRegBin HKCU "Software\Classes\bittorrent" EditFlags 00000100
 WriteRegStr HKCU "Software\Classes\bittorrent\shell" "" open
 WriteRegStr HKCU "Software\Classes\bittorrent\shell\open\command" "" '"$INSTDIR\abc.exe" -a "%1"'
 WriteRegStr HKCU "Software\Classes\bittorrent" "DefaultIcon" "$INSTDIR\torrenticon.ico"
 ;Associate magnet protocol
 WriteRegStr HKCU "Software\Classes\magnet" "" "URL:Magnet Protocol"
 WriteRegStr HKCU "Software\Classes\magnet" "URL Protocol" ""
 WriteRegStr HKCU "Software\Classes\magnet\DefaultIcon" "" "$INSTDIR\torrenticon.ico"
 WriteRegStr HKCU "Software\Classes\magnet\shell\open\command" "" '"$INSTDIR\abc.exe" -a "%1"'

SectionEnd

;--------------------------------
;Descriptions

!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
 !insertmacro MUI_DESCRIPTION_TEXT ${SecMain} $(DESC_SecMain)
 !insertmacro MUI_DESCRIPTION_TEXT ${SecDesk} $(DESC_SecDesk)
 !insertmacro MUI_DESCRIPTION_TEXT ${SecStart} $(DESC_SecStart)
; !insertmacro MUI_DESCRIPTION_TEXT ${SecLang} $(DESC_SecLang)
 !insertmacro MUI_DESCRIPTION_TEXT ${SecDefault} $(DESC_SecDefault)
!insertmacro MUI_FUNCTION_DESCRIPTION_END

;--------------------------------
;Uninstaller Section

Section "Uninstall"
 SetShellVarContext all
;--------------------------------
;INSTDIR
 RMDir /r "$INSTDIR\defaultconf"
 RMDir /r "$INSTDIR\icons"
 RMDir /r "$INSTDIR\lang"
 RMDir /r "$INSTDIR\locale"
 Delete "$INSTDIR\*.*"
 RMDir "$INSTDIR"
;--------------------------------
;Shortcuts
 Delete "$DESKTOP\${PRODUCT}.lnk"
 RMDir /r "$SMPROGRAMS\${PRODUCT}"
;--------------------------------
;Registry
 DeleteRegKey HKCU "SOFTWARE\${PRODUCT}"
 DeleteRegKey HKCU "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT}"
;--------------------------------
;Try to remove old shortcuts for single user
 SetShellVarContext current
 Delete "$DESKTOP\${PRODUCT}.lnk"
 RMDir /r "$SMPROGRAMS\${PRODUCT}"
SectionEnd

;--------------------------------
;Functions Section

Function .onInit
  System::Call 'kernel32::CreateMutexA(i 0, i 0, t "ABC") i .r1 ?e' 
  Pop $R0 
  StrCmp $R0 0 +3 
    MessageBox MB_OK "The installer is already running." 
    Abort 
FunctionEnd
