##############################################################################
# Module : webservicedlg.py
# Author :
# Date   :
# Updated and modified for ABC_OKC : Old King Cole
#
# Description : Dialog for editing web service parameters
#
##############################################################################
import wx, sys
from os import path

from BitTornado.utility import sysencoding

from filemanager import TorrentConfigFileManager


class WebDialog(wx.Dialog):
    def __init__(self, parent, ID, title, pos = wx.DefaultPosition, size = wx.DefaultSize,
                 style = wx.DEFAULT_DIALOG_STYLE):
        pre = wx.PreDialog()
        pre.Create(parent, ID, title, pos, size, style)
        self.this = pre.this
        self.parent = parent
        self.utility = self.parent.utility
        self.localize = self.utility.lang.get

        p = wx.Panel(self, -1)
        outerbox = wx.BoxSizer(wx.VERTICAL)

        webservicebox = wx.StaticBoxSizer(wx.StaticBox(p, -1, ''), wx.VERTICAL)

        ipandport_box = wx.BoxSizer(wx.HORIZONTAL)
        ipandport_box.Add(wx.StaticText(p, -1, self.localize('webip')), 0, wx.ALIGN_CENTER_VERTICAL)
        webip = [self.localize('automatic'), self.localize('loopback')]
        self.iptext = wx.ComboBox(p, -1, webip[int(self.utility.webparams['webIP'])], wx.Point(-1, -1), wx.Size(-1, -1),
                                  webip, wx.CB_DROPDOWN | wx.CB_READONLY)
        ipandport_box.Add(self.iptext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        
        ipandport_box.Add(wx.StaticText(p, -1, self.localize('webport')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 20)
        self.porttext = wx.TextCtrl(p, -1, self.utility.webparams['webport'], wx.Point(-1, -1), wx.Size(43, self.utility.digitheight), style = wx.TE_RIGHT)
        self.porttext.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.porttext.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        ipandport_box.Add(self.porttext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        webservicebox.Add(ipandport_box, 0, wx.TOP, 3)

        uniquekey_box = wx.BoxSizer(wx.HORIZONTAL)
        
        uniquekey_box.Add(wx.StaticText(p, -1, self.localize('uniquekey')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.keytext = wx.TextCtrl(p, -1, self.utility.webparams['webID'], wx.Point(-1, -1), wx.Size(165, -1))
        self.keytext.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.keytext.Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
        uniquekey_box.Add(self.keytext, 1, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        
        webservicebox.Add(uniquekey_box, 0, wx.EXPAND | wx.TOP, 3)

        permission_title = wx.StaticBox(p, -1, self.localize('commandpermission'))
        permission_box = wx.StaticBoxSizer(permission_title, wx.HORIZONTAL)

        self.allow_query = wx.CheckBox(p, -1, self.localize('webquery'), style = wx.NO_BORDER)
        self.allow_queue = wx.CheckBox(p, -1, self.localize('webqueue'), style = wx.NO_BORDER)
        self.allow_onhold = wx.CheckBox(p, -1, self.localize('webpause'), style = wx.NO_BORDER)
        self.allow_getparam = wx.CheckBox(p, -1, self.localize('webgetparam'), style = wx.NO_BORDER)
        self.allow_gettorparam = wx.CheckBox(p, -1, self.localize('webgettorparam'), style = wx.NO_BORDER)
        self.allow_scheduler = wx.CheckBox(p, -1, self.localize('webscheduler'), style = wx.NO_BORDER)

        column1_box = wx.BoxSizer(wx.VERTICAL)
        column1_box.Add(self.allow_query, 0, wx.TOP, 0)
        column1_box.Add(self.allow_queue, 0, wx.TOP, 3)
        column1_box.Add(self.allow_onhold, 0, wx.TOP, 3)
        column1_box.Add(self.allow_getparam, 0, wx.TOP, 3)
        column1_box.Add(self.allow_gettorparam, 0, wx.TOP, 3)
        column1_box.Add(self.allow_scheduler, 0, wx.TOP, 3)

        permission_box.Add(column1_box, 0)

        self.allow_delete = wx.CheckBox(p, -1, self.localize('webdelete'), style = wx.NO_BORDER)
        self.allow_pause = wx.CheckBox(p, -1, self.localize('webstopmode'), style = wx.NO_BORDER)
        self.allow_clearcompleted = wx.CheckBox(p, -1, self.localize('webclearallover'), style = wx.NO_BORDER)
        self.allow_setparam = wx.CheckBox(p, -1, self.localize('websetparam'), style = wx.NO_BORDER)
        self.allow_settorparam = wx.CheckBox(p, -1, self.localize('websettorparam'), style = wx.NO_BORDER)

        column2_box = wx.BoxSizer(wx.VERTICAL)
        column2_box.Add(self.allow_delete, 0, wx.TOP, 0)
        column2_box.Add(self.allow_pause, 0, wx.TOP, 3)
        column2_box.Add(self.allow_clearcompleted, 0, wx.TOP, 3)
        column2_box.Add(self.allow_setparam, 0, wx.TOP, 3)
        column2_box.Add(self.allow_settorparam, 0, wx.TOP, 3)

        permission_box.Add(column2_box, 0, wx.LEFT, 10)

        self.allow_add = wx.CheckBox(p, -1, self.localize('webadd'), style = wx.NO_BORDER)
        self.allow_resume = wx.CheckBox(p, -1, self.localize('webresume'), style = wx.NO_BORDER)
        self.allow_setprio = wx.CheckBox(p, -1, self.localize('webpriority'), style = wx.NO_BORDER)
        self.allow_move = wx.CheckBox(p, -1, self.localize('webmove'), style = wx.NO_BORDER)
        self.allow_superseed = wx.CheckBox(p, -1, self.localize('websuperseed'), style = wx.NO_BORDER)

        column3_box = wx.BoxSizer(wx.VERTICAL)
        column3_box.Add(self.allow_add, 0, wx.TOP, 0)
        column3_box.Add(self.allow_resume, 0, wx.TOP, 3)
        column3_box.Add(self.allow_setprio, 0, wx.TOP, 3)
        column3_box.Add(self.allow_move, 0, wx.TOP, 3)
        column3_box.Add(self.allow_superseed, 0, wx.TOP, 3)

        permission_box.Add(column3_box, 0, wx.LEFT, 10)

        webservicebox.Add(permission_box, 0, wx.EXPAND | wx.TOP, 3)

        webcoder_box = wx.BoxSizer(wx.HORIZONTAL)
        webcoder_box.Add(wx.StaticText(p, -1, self.localize('webcoder')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.webcoder = wx.ComboBox(p, -1, '', wx.Point(-1, -1), wx.Size(-1, -1),
                                    ['utf_8', self.localize('sysencoding') + sysencoding], wx.CB_DROPDOWN | wx.CB_READONLY)
        self.webcoder.SetSelection(int(self.utility.webparams['webcoder']))
        webcoder_box.Add(self.webcoder, 1, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        webservicebox.Add(webcoder_box, 0, wx.TOP, 3)

        self.webautostart = wx.CheckBox(p, -1, self.localize('webautostart'))

        webservicebox.Add(self.webautostart, 0, wx.TOP, 3)

        outerbox.Add(webservicebox, 0, wx.EXPAND | wx.TOP, -4)

        #CheckBox Set Value from Config
        #####################################
        if self.utility.webparams['allow_query'] == "1":
            self.allow_query.SetValue(True)
        if self.utility.webparams['allow_delete'] == "1":
            self.allow_delete.SetValue(True)
        if self.utility.webparams['allow_add'] == "1":
            self.allow_add.SetValue(True)
        if self.utility.webparams['allow_queue'] == "1":
            self.allow_queue.SetValue(True)
        if self.utility.webparams['allow_pause'] == "1":
            self.allow_pause.SetValue(True)
        if self.utility.webparams['allow_resume'] == "1":
            self.allow_resume.SetValue(True)
        if self.utility.webparams['allow_onhold'] == "1":
            self.allow_onhold.SetValue(True)
        if self.utility.webparams['allow_clearcompleted'] == "1":
            self.allow_clearcompleted.SetValue(True)        
        if self.utility.webparams['allow_getparam'] == "1":
            self.allow_getparam.SetValue(True)
        if self.utility.webparams['allow_setparam'] == "1":
            self.allow_setparam.SetValue(True)
        if self.utility.webparams['webautostart'] == "1":
            self.webautostart.SetValue(True)
        if self.utility.webparams['allow_setprio'] == "1":
            self.allow_setprio.SetValue(True)
        if self.utility.webparams['allow_move'] == "1":
            self.allow_move.SetValue(True)
        if self.utility.webparams['allow_gettorparam'] == "1":
            self.allow_gettorparam.SetValue(True)
        if self.utility.webparams['allow_settorparam'] == "1":
            self.allow_settorparam.SetValue(True)
        if self.utility.webparams['allow_superseed'] == "1":
            self.allow_superseed.SetValue(True)
        if self.utility.webparams['allow_scheduler'] == "1":
            self.allow_scheduler.SetValue(True)

        if not self.parent.webserver:            
            self.actionbtn = wx.Button(p, -1, self.localize('startservice'))
        else:
            self.iptext.Disable()
            self.porttext.Disable()
            self.keytext.Disable()
            self.actionbtn = wx.Button(p, -1, self.localize('stopservice'))
        okbtn = wx.Button(p, -1, self.localize('ok'))
        cancelbtn = wx.Button(p, -1, self.localize('cancel'))

        self.Bind(wx.EVT_BUTTON, self.onAction, self.actionbtn)
        self.Bind(wx.EVT_BUTTON, self.onOK, okbtn)
        self.Bind(wx.EVT_BUTTON, self.onCancel, cancelbtn)

        button_box = wx.BoxSizer(wx.HORIZONTAL)
        button_box.Add(self.actionbtn, 0, wx.ALL, 5)
        button_box.Add(okbtn, 0, wx.ALL, 5)
        button_box.Add(cancelbtn, 0, wx.ALL, 5)

        outerbox.Add(button_box, 0, wx.ALIGN_CENTER)

        p.SetAutoLayout(True)
        p.SetSizer(outerbox)
        p.Fit()
        self.SetClientSize(p.GetSize())

        if self.parent.abcparams['webservicedlgx'] != '-1':
            self.MoveXY(int(self.parent.abcparams['webservicedlgx']), int(self.parent.abcparams['webservicedlgy']))

    def onRightButtonText(self, event):
        pass

    def affectParams(self):
        # Update webparams
        self.utility.webparams['webIP'] = str(self.iptext.GetSelection())
        self.utility.webparams['webport'] = self.porttext.GetValue()
        self.utility.webparams['webID'] = self.keytext.GetValue()
        if self.allow_query.GetValue():
            self.utility.webparams['allow_query'] = "1"
        else:
            self.utility.webparams['allow_query'] = "0"

        if self.allow_delete.GetValue():
            self.utility.webparams['allow_delete'] = "1"
        else:
            self.utility.webparams['allow_delete'] = "0"

        if self.allow_add.GetValue():
            self.utility.webparams['allow_add'] = "1"
        else:
            self.utility.webparams['allow_add'] = "0"

        if self.allow_queue.GetValue():
            self.utility.webparams['allow_queue'] = "1"
        else:
            self.utility.webparams['allow_queue'] = "0"

        if self.allow_pause.GetValue():
            self.utility.webparams['allow_pause'] = "1"
        else:
            self.utility.webparams['allow_pause'] = "0"

        if self.allow_resume.GetValue():
            self.utility.webparams['allow_resume'] = "1"
        else:
            self.utility.webparams['allow_resume'] = "0"

        if self.allow_onhold.GetValue():
            self.utility.webparams['allow_onhold'] = "1"
        else:
            self.utility.webparams['allow_onhold'] = "0"

        if self.allow_clearcompleted.GetValue():
            self.utility.webparams['allow_clearcompleted'] = "1"
        else:
            self.utility.webparams['allow_clearcompleted'] = "0"

        if self.allow_setprio.GetValue():
            self.utility.webparams['allow_setprio'] = "1"
        else:
            self.utility.webparams['allow_setprio'] = "0"

        if self.allow_getparam.GetValue():
            self.utility.webparams['allow_getparam'] = "1"
        else:
            self.utility.webparams['allow_getparam'] = "0"

        if self.allow_setparam.GetValue():
            self.utility.webparams['allow_setparam'] = "1"
        else:
            self.utility.webparams['allow_setparam'] = "0"

        if self.allow_move.GetValue():
            self.utility.webparams['allow_move'] = "1"
        else:
            self.utility.webparams['allow_move'] = "0"

        if self.allow_gettorparam.GetValue():
            self.utility.webparams['allow_gettorparam'] = "1"
        else:
            self.utility.webparams['allow_gettorparam'] = "0"

        if self.allow_settorparam.GetValue():
            self.utility.webparams['allow_settorparam'] = "1"
        else:
            self.utility.webparams['allow_settorparam'] = "0"

        if self.allow_superseed.GetValue():
            self.utility.webparams['allow_superseed'] = "1"
        else:
            self.utility.webparams['allow_superseed'] = "0"

        if self.allow_scheduler.GetValue():
            self.utility.webparams['allow_scheduler'] = "1"
        else:
            self.utility.webparams['allow_scheduler'] = "0"

        self.utility.webparams['webcoder'] = str(self.webcoder.GetSelection())

        if self.webautostart.GetValue():
            self.utility.webparams['webautostart'] = "1"
        else:
            self.utility.webparams['webautostart'] = "0"

    def onCancel(self, event = None):
        self.EndModal(wx.ID_CANCEL)

    def onOK(self, event):
        if not self.validPort():
            return
        self.affectParams()
        self.writeWebServiceConf()
        self.EndModal(wx.ID_OK)

    def onAction(self, event):
        if not self.parent.webserver:
            if self.parent.window.torrentlistloading:
                return
            if not self.validPort():
                return
            self.affectParams()
            self.actionbtn.SetLabel(self.localize('stopservice'))
            self.parent.window.webservicebutton.SetValue(True)
            self.iptext.Disable()
            self.porttext.Disable()
            self.keytext.Disable()
            self.writeWebServiceConf()
            self.parent.window.startWebService()
        else:
            try:
                self.actionbtn.SetLabel(self.localize('startservice'))
            except:
                pass
            self.parent.window.webservicebutton.SetValue(False)
            self.parent.window.stopWebService()
            self.iptext.Enable()
            self.porttext.Enable()
            self.keytext.Enable()

    def forceStatus(self, status):
        self.iptext.SetSelection(int(self.utility.webparams['webIP']))
        self.porttext.ChangeValue(self.utility.webparams['webport'])
        self.keytext.ChangeValue(self.utility.webparams['webID'])
        if status:
            self.iptext.Disable()
            self.porttext.Disable()
            self.keytext.Disable()
            self.actionbtn.SetLabel(self.localize('stopservice'))
        else:
            self.iptext.Enable()
            self.porttext.Enable()
            self.keytext.Enable()
            self.actionbtn.SetLabel(self.localize('startservice'))

    def writeWebServiceConf(self):
        # Record new config to webservice.conf
        tcfm = TorrentConfigFileManager(path.join(self.utility.datapath, "webservice.conf"), self.utility.webparams)
        tcfm.writeAllConfig()

    def validPort(self):
        errortype = False
        try :
            port = int(self.porttext.GetValue())
        except:
            errortype = True
        if errortype or port < 0 or port > 65535:
            dlg = wx.MessageDialog(self.parent, self.localize('portmustbenumber'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False
        if port < 1024:
            dlg = wx.MessageDialog(self.parent, self.localize('warningportunder1024'),
                                   self.localize('abcokcwarning'), wx.YES_NO | wx.ICON_INFORMATION)
            result = dlg.ShowModal()
            dlg.Destroy()
            if result == wx.ID_NO:
                return False
        return True
