##############################################################################
# Module : version.py
# Author :
# Date   :
# Updated and modified for ABC_OKC : Old King Cole
#
# Description : Dialogs to display ABC_OKC version informations
#
##############################################################################
import wx
import wx.html

from webbrowser import open_new
from threading import Thread

from lang.lang import ABC_OKC_BUILD


class MyHtmlWindow(wx.html.HtmlWindow):
    def __init__(self, parent, id, size):
        wx.html.HtmlWindow.__init__(self, parent, id, size = size, style = wx.html.HW_DEFAULT_STYLE | wx.html.HW_NO_SELECTION)
        self.Bind(wx.EVT_SCROLLWIN, self.OnScroll)

    def OnScroll(self, event):
        event.Skip()

    def OnLinkClicked(self, linkinfo):
        thread = Thread(target = open_new, args = [linkinfo.GetHref()])
        thread.daemon = False
        thread.start()


class AboutMeDialog(wx.Dialog):
    def __init__(self, parent, ID, title, pos = wx.DefaultPosition, size = wx.DefaultSize,
                 style = wx.DEFAULT_DIALOG_STYLE):
        pre = wx.PreDialog()
        pre.Create(parent, ID, title, pos, size, style)
        self.this = pre.this
        self.parent = parent
        self.utility = self.parent.utility
        self.localize = self.utility.lang.get

        aboutbox = wx.StaticBoxSizer(wx.StaticBox(self, -1, ''), wx.VERTICAL)

        okbtn = wx.Button(self, wx.ID_OK, "OK")
        okbtn.SetDefault()      
        self.Bind(wx.EVT_BUTTON, self.onOK, okbtn)

        color = self.GetBackgroundColour()
        bgcolor = "#%02x%02x%02x" % (color.Red(), color.Green(), color.Blue())

        about_html = "<HTML><HEAD><TITLE>" + title + "</TITLE></HEAD>" + \
                     "<BODY BGCOLOR=" + bgcolor + " TEXT=#000000>" + \
                     "<B><CENTER>" + self.localize('title') + ' ' + self.localize('version') + "</CENTER></B>" + \
                     "<FONT SIZE=-1>" + \
                     "<P>" + self.localize('aboutauthor') + "Choopan Rattanapoka (choopanr@hotmail.com)" + \
                     "<BR>" + self.localize('aboutversion') + self.localize('version') + self.localize('version2') + ' ' + self.localize('build') + \
                     "<BR>" + self.localize('aboutforums') + "<A HREF=http://sourceforge.net/projects/pingpong-abc/forums/forum/303226>Open Discussion</A>" + \
                                  " |  <A HREF=http://sourceforge.net/projects/pingpong-abc/forums/forum/303227>Help</A>" + \
                     "<P>" + self.localize('aboutaddcode') + \
                     "<BR>" + "Old King Cole" + \
                     "<BR>" + "Tim Tucker (<A HREF=mailto:abc@timtucker.com>abc@timtucker.com</A>)" + \
                     "<BR>" + "Roee88" + \
                     "<BR>" + "NoirSoldats (<A HREF=mailto:noirsoldats@codemeu.com>noirsoldats@codemeu.com</A>)" + \
                     "<BR>" + self.localize('translate') + \
                     "<P>" + self.localize('aboutcore1') + "<A HREF=http://www.bittornado.com>BitTornado 0.3.18</A>" + \
                     "<BR>" + self.localize('aboutcore2') + \
                     "<P>" + self.localize('aboutrss1') + "Jeremy Arendt's g3rss" + \
                     "<BR>" + self.localize('aboutrss2') + "Mark Pilgrim : <A HREF=https://github.com/kurtmckee/feedparser>Universal Feed Parser 5.2.1</A>" + \
                     "<P>" + self.localize('aboutcrypto1') + "Andrew Kuchling : <A HREF=https://www.dlitz.net/software/pycrypto/>PyCrypto 2.6.1</A>" + \
                     "<P>" + self.localize('aboutdht1') + "Andrew Loewenstern" + \
                     "<P>" + self.localize('aboutthanks') + \
                     "<BR>Greg Fleming (www.darkproject.com)" + \
                     "<BR>Pir4nhaX (www.clanyakuza.com)" + \
                     "<BR>Michel Hartmann (php4abc.i-networx.de)" + \
                     "<BR>" + self.localize('aboutthanksupport') + \
                     "<P>" + self.localize('aboutpowered') + "<A HREF=http://www.python.org>Python 2.7.18</A>, " + \
                                   "<A HREF=http://www.wxpython.org>wxPython 2.8.12.1</A>, " + \
                                   "<A HREF=https://github.com/mhammond/pywin32>Python for Windows extensions 228</A>, " + \
                                   "<A HREF=http://www.py2exe.org/>py2exe 0.6.9</A>, " + \
                                   "<A HREF=http://nsis.sourceforge.net/>NSIS 3.11</A>" + \
                     "<P>" + self.localize('aboutcopyright') + "2003-2004, Choopan Rattanapoka" + \
                     "</FONT>" + \
                     "</BODY></HTML>"

        self.html = MyHtmlWindow(self, -1, size = (355, 280))
        self.html.SetPage(about_html)
        aboutbox.Add(self.html, 0, wx.EXPAND | wx.ALL, 5)

        buttonbox = wx.BoxSizer(wx.HORIZONTAL)
        buttonbox.Add(okbtn, 0, wx.ALL, 5)

        outerbox = wx.BoxSizer(wx.VERTICAL)
        outerbox.Add(aboutbox, 0, wx.TOP, -4)
        outerbox.Add(buttonbox, 0, wx.ALIGN_CENTER)

        self.SetAutoLayout(True)
        self.SetSizer(outerbox)
        self.Fit()

        if self.parent.abcparams['aboutmedlgx'] != '-1':
            self.MoveXY(int(self.parent.abcparams['aboutmedlgx']), int(self.parent.abcparams['aboutmedlgy']))

        self.html.SetFocus()

    def onOK(self, event = None):
        self.EndModal(wx.ID_OK)


class CheckLatestVersionDialog(wx.Dialog):
    def __init__(self, parent, ID, title, htmlcontent, pos = wx.DefaultPosition, size = wx.DefaultSize,
                 style = wx.DEFAULT_DIALOG_STYLE):
        pre = wx.PreDialog()
        pre.Create(parent, ID, title, pos, size, style)
        self.this = pre.this
        self.parent = parent
        self.utility = self.parent.utility
        self.localize = self.utility.lang.get

        versionbox = wx.StaticBoxSizer(wx.StaticBox(self, -1, ''), wx.VERTICAL)

        okbtn = wx.Button(self, wx.ID_OK, "OK")
        okbtn.SetDefault()      
        self.Bind(wx.EVT_BUTTON, self.onOK, okbtn)

        color = self.GetBackgroundColour()
        bgcolor = "#%02x%02x%02x" % (color.Red(), color.Green(), color.Blue())

        curbuild = int(ABC_OKC_BUILD)
        try:
            lastbuild = int(htmlcontent.split(' ', 2)[1])
        except:
            result = ''
        else:
            if curbuild < lastbuild:
                result = self.localize('newversion')
            else:
                result = self.localize('nonewversion')

        lastverhtmlbegin = "<HTML><HEAD><TITLE>" + title + "</TITLE></HEAD>" + \
                           "<BODY BGCOLOR=" + bgcolor + " TEXT=#000000>" + \
                           "<B><CENTER>" + result + "</CENTER></B>" + \
                           "<FONT SIZE=-1>" + \
                           "<P><CENTER>" + self.localize('abccurrentversion') + "</CENTER>" + \
                           "<BR><CENTER>" + self.localize('title') + ' ' + self.localize('version') + self.localize('version2') + ' ' + self.localize('build') + "</CENTER>"

        lastverhtmlend = "</FONT>" + \
                         "</BODY></HTML>"

        self.html = MyHtmlWindow(self, -1, size = (350, 240))
        self.html.SetPage(lastverhtmlbegin + htmlcontent + lastverhtmlend)
        versionbox.Add(self.html, 0, wx.EXPAND | wx.ALL, 5)

        buttonbox = wx.BoxSizer(wx.HORIZONTAL)
        buttonbox.Add(okbtn, 0, wx.ALL, 5)

        outerbox = wx.BoxSizer(wx.VERTICAL)
        outerbox.Add(versionbox, 0, wx.TOP, -4)
        outerbox.Add(buttonbox, 0, wx.ALIGN_CENTER)

        self.SetAutoLayout(True)
        self.SetSizer(outerbox)
        self.Fit()

        if self.parent.abcparams['checklatestdlgx'] != '-1':
            self.MoveXY(int(self.parent.abcparams['checklatestdlgx']), int(self.parent.abcparams['checklatestdlgy']))

        self.html.SetFocus()

    def onOK(self, event = None):
        self.EndModal(wx.ID_OK)
