##############################################################################
# Module : renfromclipdlg.py
# Author : Old King Cole
# Date   : 09/01/2025
#
# Description : Dialog on errors when renaming files from clipboard
#
##############################################################################
import wx


class RenFromClipDialog(wx.Dialog):
    def __init__(self, parent, ID, title, pos = wx.DefaultPosition, size = wx.DefaultSize,
                 style = wx.DEFAULT_DIALOG_STYLE):
        pre = wx.PreDialog()
        pre.Create(parent, ID, title, pos, size, style)
        self.this = pre.this
        self.localize = parent.utility.lang.get

        outerbox = wx.BoxSizer(wx.VERTICAL)

        outerbox.Add(wx.StaticText(self, -1, self.localize('errorfilerenamefromclipboard2')), 0, wx.ALL, 10)

        buttonbox = wx.BoxSizer(wx.HORIZONTAL)

        okbtn = wx.Button(self, -1, self.localize('ok'), size = (105, -1))
        buttonbox.Add(okbtn)
        self.Bind(wx.EVT_BUTTON, self.onOK, okbtn)
        skiperrormsgbtn = wx.Button(self, -1, self.localize('skiperrormsg'), size = (155, -1))
        buttonbox.Add(skiperrormsgbtn, 0, wx.LEFT, 10)
        self.Bind(wx.EVT_BUTTON, self.onSkipErrors, skiperrormsgbtn)
        cancelbtn = wx.Button(self, -1, self.localize('cancel'), size = (105, -1))
        buttonbox.Add(cancelbtn, 0, wx.LEFT, 10)
        self.Bind(wx.EVT_BUTTON, self.onCancel, cancelbtn)
        self.Bind(wx.EVT_CLOSE, self.onCancel)

        outerbox.Add(buttonbox, 0, wx.ALIGN_CENTER | wx.TOP | wx.BOTTOM, 10)

        self.SetAutoLayout(True)
        self.SetSizer(outerbox)
        self.Fit()

    def onCancel(self, event):
        self.EndModal(1)

    def onSkipErrors(self, event):
        self.EndModal(2)

    def onOK(self, event):
        self.EndModal(0)
