##############################################################################
# Module : filerenamedlg.py
# Author : Old King Cole
# Date   : 09/24/2024
#
# Description : Dialog for renaming file path inside torrent
#
##############################################################################
import wx


class FileRenDialog(wx.Dialog):
    def __init__(self, parent, ID, filepath, dest, fixedlength, pos = wx.DefaultPosition,
                 size = wx.DefaultSize, style = wx.CAPTION | wx.CLOSE_BOX | wx.TAB_TRAVERSAL | wx.RESIZE_BORDER):
        self.utility = parent.utility
        self.localize = self.utility.lang.get
        title = self.localize('editpath_short')
        self.destlength = len(dest) + 1
        self.fixedlength = fixedlength
        pre = wx.PreDialog()
        pre.Create(parent, ID, title, pos, size, style)
        self.this = pre.this

        outerbox = wx.BoxSizer(wx.VERTICAL)

        globalbox = wx.StaticBoxSizer(wx.StaticBox(self, -1, ''), wx.VERTICAL)

        globalbox.Add(wx.StaticText(self, -1, self.localize('editpath')), 0, wx.TOP, 3)
        self.editfilepath = wx.TextCtrl(self, -1, filepath, (-1, -1), (-1, -1))        
        globalbox.Add(self.editfilepath, 0, wx.EXPAND | wx.TOP, 3)

        self.pathlength = wx.StaticText(self, -1, self.buildLengthString(filepath, len(filepath) + self.destlength, self.fixedlength))
        globalbox.Add(self.pathlength, 0, wx.TOP, 3)

        outerbox.Add(globalbox, 0, wx.EXPAND | wx.TOP, -4)

        buttonbox = wx.BoxSizer(wx.HORIZONTAL)
        okbtn = wx.Button(self, -1, self.localize('ok'), size = (60, -1))
        cancelbtn = wx.Button(self, -1, self.localize('cancel'), size = (60, -1))
        buttonbox.Add(okbtn, 0, wx.ALL, 5)
        buttonbox.Add(cancelbtn, 0, wx.ALL, 5)

        outerbox.Add(buttonbox, 0, wx.ALIGN_CENTER)

        self.SetAutoLayout(True)
        self.SetSizer(outerbox)
        self.Fit()
        self.SetSize((int(self.utility.abcparams['renfilew']), -1))
        height = self.GetSize()[1]
        self.SetMinSize((300, height))
        self.SetMaxSize((-1, height))
        self.Centre()

        # Add events
        self.Bind(wx.EVT_BUTTON, self.onOK, okbtn)
        self.Bind(wx.EVT_BUTTON, self.onCancel, cancelbtn)
        self.Bind(wx.EVT_CLOSE, self.onCancel)
        self.editfilepath.Bind(wx.EVT_TEXT, self.onChangeFilePath)

    def buildEditLengthString(self, editstr):
        return '-'.join([str(len(p)) for p in editstr.split('\\')])

    def buildLengthString(self, editstr, uplen, fixedlen):
        if fixedlen:
            if editstr and editstr[-1] == '\\':
                editstr = editstr[:-1]
        editlen = self.buildEditLengthString(editstr)
        if fixedlen:
            return '/'.join([editlen, str(uplen), str(uplen + fixedlen)])
        return '/'.join([editlen, str(uplen)])

    def setLengthString(self):
        fixedlength = self.fixedlength
        editstr = self.editfilepath.GetValue()
        if fixedlength:
            if editstr and editstr[-1] != '\\':
                fixedlength += 1
        self.pathlength.SetLabel(self.buildLengthString(editstr, len(editstr) + self.destlength, fixedlength))

    def onChangeFilePath(self, event):
        wx.CallAfter(self.setLengthString)
        event.Skip()

    def onCancel(self, event = None):
        self.EndModal(wx.ID_CANCEL)

    def onOK(self, event):
        self.EndModal(wx.ID_OK)
