##############################################################################
# Module : filenamescheckresultdlg.py
# Author : Old King Cole
# Date   : 03/28/2008
#
# Description : Dialog to show file names check result
#
##############################################################################
import wx


class FileNamesCheckResultDialog(wx.Dialog):
    def __init__(self, parent, ID, title, message, opendetailsbtn = True,
                 pos = wx.DefaultPosition, size = wx.DefaultSize,
                 style = wx.DEFAULT_DIALOG_STYLE):
        pre = wx.PreDialog()
        pre.Create(parent, ID, title, pos, size, style)
        self.this = pre.this
        self.parent = parent
        self.utility = self.parent.utility
        self.localize = self.utility.lang.get

        p = wx.Panel(self, -1)
        outerbox = wx.BoxSizer(wx.VERTICAL)

        checkresultbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, ''), wx.VERTICAL)

        checkresultbox.Add(wx.StaticText(self, -1, message))

        outerbox.Add(checkresultbox, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.TOP, -4)

        buttonbox = wx.BoxSizer(wx.HORIZONTAL)
        if opendetailsbtn:
            # Show button to open details window
            viewdetailsbtn = wx.Button(p, -1, self.localize('viewdetails'), size = (-1, -1))
            buttonbox.Add(viewdetailsbtn, 0, wx.ALL, 5)
            self.Bind(wx.EVT_BUTTON, self.onViewDetails, viewdetailsbtn)
        closebtn = wx.Button(p, -1, self.localize('close'), size = (60, -1))
        buttonbox.Add(closebtn, 0, wx.ALL, 5)
        self.Bind(wx.EVT_BUTTON, self.onClose, closebtn)
        self.Bind(wx.EVT_CLOSE, self.onClose)

        outerbox.Add(buttonbox, 0, wx.ALIGN_CENTER)

        p.SetAutoLayout(True)
        p.SetSizer(outerbox)
        p.Fit()
        self.SetClientSize(p.GetSize())

        if opendetailsbtn:
            if self.utility.abcparams['filenamescheckresdlgx'] != '-1':
                self.MoveXY(int(self.utility.abcparams['filenamescheckresdlgx']), int(self.utility.abcparams['filenamescheckresdlgy']))
        else:
            self.CentreOnParent()


    def onClose(self, event):
        self.EndModal(wx.ID_CANCEL)

    def onViewDetails(self, event):
        self.EndModal(wx.ID_OK)
