##############################################################################
# Module : dhtaddnodedlg.py
# Author : Old King Cole
# Date   : 04/02/2009
#
# Description : Dialog for adding DHT nodes
#
##############################################################################
import wx, re
from os import path


class DHTAddNodeDialog(wx.Dialog):
    def __init__(self, parent, ID, title, dht,
                 pos = wx.DefaultPosition, size = wx.DefaultSize,
                 style = wx.DEFAULT_DIALOG_STYLE):
        pre = wx.PreDialog()
        pre.Create(parent, ID, title, pos, size, style)
        self.this = pre.this
        self.utility = parent.utility
        self.localize = self.utility.lang.get
        self.dht = dht

        outerbox = wx.BoxSizer(wx.VERTICAL)

        dhtnodesbox = wx.StaticBoxSizer(wx.StaticBox(self, -1, self.localize('dhtnodes')), wx.VERTICAL)

        self.dhtnodeslistctl = wx.TextCtrl(self, -1, '', size = (-1, 200), style = wx.TE_MULTILINE | wx.HSCROLL | wx.TE_DONTWRAP)
        try:
            dhtrouterfile = open(path.join(self.utility.datapath, "dhtrouter.txt"), "r")
        except:
            pass
        else:
            self.dhtnodeslistctl.SetValue(dhtrouterfile.read())
            dhtrouterfile.close()
        self.dhtnodeslistctl.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        dhtnodesbox.Add(self.dhtnodeslistctl, 0, wx.EXPAND | wx.TOP, 0)

        stattext = wx.StaticText(self, -1, self.localize('dhtnodeshelp'))
        dhtnodesbox.Add(stattext, 0, wx.EXPAND | wx.TOP, 3)

        outerbox.Add(dhtnodesbox, 0, wx.EXPAND | wx.ALL, 5)

        loaddefaultbtn = wx.Button(self, -1, self.localize('loaddefault'), size = (60, -1))
        applybtn = wx.Button(self, -1, self.localize('apply'), size = (60, -1))
        okbtn = wx.Button(self, -1, self.localize('ok'), size = (60, -1))
        cancelbtn = wx.Button(self, -1, self.localize('cancel'), size = (60, -1))

        buttonbox = wx.BoxSizer(wx.HORIZONTAL)
        buttonbox.Add(loaddefaultbtn, 0, wx.LEFT, 0)
        buttonbox.Add(applybtn, 0, wx.LEFT, 20)
        buttonbox.Add(okbtn, 0, wx.LEFT, 20)
        buttonbox.Add(cancelbtn, 0, wx.LEFT, 20)

        outerbox.Add(buttonbox, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.BOTTOM | wx.TOP, 6)

        self.SetAutoLayout(True)
        self.SetSizer(outerbox)
        self.Fit()

        # Add events
        ###########################
        self.Bind(wx.EVT_BUTTON, self.onLoadDefault, loaddefaultbtn)
        self.Bind(wx.EVT_BUTTON, self.onApply, applybtn)
        self.Bind(wx.EVT_BUTTON, self.onOK, okbtn)
        self.Bind(wx.EVT_BUTTON, self.onCancel, cancelbtn)
        self.Bind(wx.EVT_CLOSE, self.onCancel)

        if parent.abcparams['dhtaddnodedlgx'] != '-1':
            self.MoveXY(int(parent.abcparams['dhtaddnodedlgx']), int(parent.abcparams['dhtaddnodedlgy']))
        # To avoid selection of all text in textctrl due to default focus
        stattext.SetFocus()

    def onLoadDefault(self, event):
        try:
            defdhtrouterfile = open(path.join(self.utility.abcpath, "defdhtrouter.txt"), "r")
        except:
            pass
        else:
            self.dhtnodeslistctl.SetValue(defdhtrouterfile.read())
            defdhtrouterfile.close()

    def onCancel(self, event = None):
        self.EndModal(wx.ID_CANCEL)

    def onApply(self, event):
        nodes = self.dhtnodeslistctl.GetValue()
        rawnodelist = [s for s in re.split(r'[ \n]', nodes) if s]
        if rawnodelist == ['']:
            rawnodelistlen = 0
        else:
            rawnodelistlen = len(rawnodelist)
        if rawnodelistlen % 2:
            dlg = wx.MessageDialog(self, message = self.localize('dhtnodelistformaterror'), 
                                   caption = self.localize('abcokcerror'), style = wx.OK | wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False
        nodelist = []
        for i in xrange(0, rawnodelistlen, 2):
            ip = rawnodelist[i]
            if ip.find(':') >= 0:
                ipv6_exp = self.utility.expandIPv6(ip)
                if not ipv6_exp:
                    dlg = wx.MessageDialog(self, message = self.localize('dhtnodelistipv6error'),
                                           caption = self.localize('abcokcerror'), style = wx.OK | wx.ICON_ERROR)
                    dlg.ShowModal()
                    dlg.Destroy()
                    return False
                rawnodelist[i] = ipv6_exp
            nodeporttypeerror = False
            try:
                nodeport = int(rawnodelist[i + 1])
            except:
                nodeporttypeerror = True
            if nodeporttypeerror or nodeport < 0 or nodeport > 65535:
                dlg = wx.MessageDialog(self, message = self.localize('dhtnodelistporterror'),
                                       caption = self.localize('abcokcerror'), style = wx.OK | wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return False
            nodelist.append((rawnodelist[i], nodeport))
        for ip, port in nodelist:
            resolvedips = self.utility.getIpsByName(ip)
            for ri in resolvedips:
                self.dht.sched(self.dht.addContact, 0, [ri, port])
        dhtrouterfile = open(path.join(self.utility.datapath, "dhtrouter.txt"), "w")
        dhtrouterfile.write(nodes)
        dhtrouterfile.close()
        return True

    def onOK(self, event):
        if self.onApply(event):
            self.EndModal(wx.ID_OK)
