##############################################################################
# Module : utility.py
# Author : Old King Cole
# Date   : 10/15/2005
#
# Description : Utilities for BitTornado
#
##############################################################################
from sys import getfilesystemencoding

from buffer import PIECEREADBUFFERPOOL

sysencoding = getfilesystemencoding()

# To convert system errors to a Unicode string
def exceptionArgsToString(exception):
    exceptargs = u'('
    if exception.args:
        for a in exception.args:
            if type(a) is unicode:
                exceptargs += u"'" + a + u"'"
            elif type(a) is str:
                exceptargs += u"'" + a.decode(sysencoding) + u"'"
            else:
                exceptargs += str(a)
            exceptargs += u', '
        exceptargs = exceptargs[:-2]
    return exceptargs + u')'

def getABCUtility():
    global ABCUtility
    return ABCUtility

def setABCUtility(abcutility):
    global ABCUtility
    ABCUtility = abcutility
    # BitTornado global variable using lang strings
    global INIT_STATE
    INIT_STATE = [(abcutility.lang.get('remote'), abcutility.lang.get('remotecrypted')),
                  (abcutility.lang.get('local'), abcutility.lang.get('localcrypted'))]
    # Read buffer pool settings
    PIECEREADBUFFERPOOL.setCatMaxMem(int(abcutility.abcparams['readbuffermaxglobalsize']) * 1048576)
    PIECEREADBUFFERPOOL.setCatMaxNumber(int(abcutility.abcparams['readbuffermaxglobalnumber']))

def getINIT_STATE():
    global INIT_STATE
    return INIT_STATE
