##############################################################################
# Module : multibitfield.py
# Author : Old King Cole
# Date   : 31/08/2024
#
# Description : Multibitfields (for 8 bit values)
#
##############################################################################

class Multibitfield:
    def __init__(self, nbval = None, intlist = None, copyfrom = None, neg = None):
        # Can be created with "nbval" zero values
        # or initialized from a list of integers >=0 and <= 255 "intlist"
        # or duplicated from an existing Multibitfield "copyfrom"
        # neg is value to be translated to -1 if needed
        self.neg = neg
        if copyfrom is not None:
            self.nbval= copyfrom.nbval
            self.field = bytearray(copyfrom.field)
        else:
            if intlist is None:
                if nbval is None:
                    raise ValueError, "number of values is mandatory"
                self.field = bytearray(nbval)
                self.nbval = nbval
            else:
                self.field = bytearray(intlist)
                self.nbval = len(intlist)

    def __setitem__(self, index, value):
        if index < 0:
            index = self.nbbit + index
        if self.neg is not None and value == -1:
            value = self.neg
        self.field[index] = value

    def __getitem__(self, index):
        if index < 0:
            index = self.nbbit + index
        v = self.field[index]
        if self.neg == v:
            return -1
        return v

    def __len__(self):
        return self.nbval

    def __repr__(self):
        return ','.join([str(c) for c in self.field])

    def tostring(self):
        return str(self.field)
