# Written by Bram Cohen
# see LICENSE.txt for license information
# Updated and modified for ABC_OKC : Old King Cole

from SocketHandler import SocketHandler, UPnP_ERROR
from utility import exceptionArgsToString, sysencoding, getABCUtility
import socket
from StringIO import StringIO
from traceback import print_exc
from select import error
from threading import Event
from time import clock, sleep
import sys


def autodetect_ipv6():
    try:
        assert sys.version_info >= (2, 3)
        assert socket.has_ipv6
        socket.socket(socket.AF_INET6, socket.SOCK_STREAM)
    except:
        return 0
    return 1

def autodetect_socket_style():
    if sys.platform.find('linux') < 0:
        return 1
    try:
        f = open('/proc/sys/net/ipv6/bindv6only', 'r')
        dual_socket_style = int(f.read())
        f.close()
        return int(not dual_socket_style)
    except:
        return 0


class RawServer:
    def __init__(self, doneflag, timeout_check_interval, timeout, noisy = True,
                 ipv6_enable = True, failfunc = lambda x: None, errorfunc = None,
                 sockethandler = None, udp = False, readsize = 65536, wakeupflag = None):
        self.utility = getABCUtility()
        self.timeout_check_interval = timeout_check_interval
        self.doneflag = doneflag
        self.wakeupflag = wakeupflag
        self.noisy = noisy
        self.failfunc = failfunc
        self.errorfunc = errorfunc
        self.exccount = 0
        self.funcs = []
        self.udp = udp
        self.slowdown = self.slowdownmin = float(self.utility.abcparams['rawserverslowdown'])
        self.readsizemax = readsize
        self.setparamstime = -1

        if sockethandler is None:
            self.sockethandler = SocketHandler(timeout, ipv6_enable, udp = self.udp)
        else:
            self.sockethandler = sockethandler

    def add_task(self, func, delay = 0, args = []):
        time = clock() + delay
        i = 0
        for f in self.funcs:
            if f[0] > time:
                self.funcs.insert(i, (time, func, args))
                return
            i += 1
        self.funcs.append((time, func, args))

    def scan_for_timeouts(self):
        self.add_task(self.scan_for_timeouts, self.timeout_check_interval)
        self.sockethandler.scan_for_timeouts()

    def bind(self, port, bind = '', reuse = False,
             ipv6_socket_style = 1, upnp = False):
        return self.sockethandler.bind(port, bind, reuse, ipv6_socket_style, upnp)

    def find_and_bind(self, minport, maxport, bind = '', reuse = False,
                      ipv6_socket_style = 1, upnp = 0, randomizer = False):
        return self.sockethandler.find_and_bind(minport, maxport, bind, reuse,
                                                ipv6_socket_style, upnp, randomizer)

    def start_connection(self, dns, handler = None, randomize = False):
        return self.sockethandler.start_connection(dns, handler, randomize)

    def get_stats(self):
        return self.sockethandler.get_stats()

    def listen_forever(self, handler):
        self.sockethandler.set_handler(handler)
        if not self.udp:
            self.add_task(self.scan_for_timeouts, self.timeout_check_interval)

        while True:
            now = clock()
            try:
                events = self.sockethandler.do_poll(0.)

                if now - self.setparamstime > 0.1:
                    self.setparamstime = now
                    self.slowdown, usemaxreadsize = handler.getRawServerParams(now, events)
                    self.readsize = self.readsizemax if usemaxreadsize else 65536
                    
                if self.doneflag.isSet():
                    return False

                self.sockethandler.handle_events(events, self.readsize)

                self.sockethandler.close_dead()

                while self.funcs and self.funcs[0][0] <= now:
                    t, func, args = self.funcs.pop(0)
                    func(*args)

                if self.doneflag.isSet():
                    return False

                self.sockethandler.close_dead()

            except SystemError, e:
                self.failfunc(self.utility.lang.get('systemerror') + ' - ' + exceptionArgsToString(e))
                return True
            except MemoryError, e:
                self.failfunc(self.utility.lang.get('memoryerror') + ' - ' + exceptionArgsToString(e))
                return True
            except IOError, e:
                self.failfunc(self.utility.lang.get('ioerror') + ' - ' + exceptionArgsToString(e))
                return True
            except error:
                pass
            except:
                if self.noisy and self.errorfunc:
                    self.exception()
                    if self.exccount > 10:
                        return True

            sd = self.slowdown - clock() + now
            while sd > 0:
                if self.doneflag.isSet():
                    return False
                if self.wakeupflag and self.wakeupflag.isSet() and self.slowdown > self.slowdownmin:
                    break
                sleep(min(0.2, sd))
                sd -= 0.2

    def exception(self):
        self.exccount += 1
        data = StringIO()
        print_exc(file = data)
        self.errorfunc(data.getvalue().decode(sysencoding))

    def shutdown(self):
        self.funcs[:] = []
        self.sockethandler.shutdown()
