# Written by Bram Cohen
# see LICENSE.txt for license information
# Updated and modified for ABC_OKC : Old King Cole

from time import clock
from CurrentRateMeasure import Measure

DEBUG = False

MAX_UNITSIZE = 15.
MIN_UNITSIZE = 7.


class RateLimiter:
    def __init__(self, sched, config, sndbuf):
        self.sched = sched
        self.last = None
        self.unitsizestep = config['unit_size_step']
        self.unitsizeinctrig = config['unit_size_inc_trig']
        self.sndbuf = sndbuf
        self.upload_rate = 0.
        self.measure = Measure(config['max_rate_period'])
        self.bytes_sent = 0.
        self.last_time = clock()
        self.cycle = 0L

    def set_upload_rate(self, rate):
        if rate:
            rate = max(int(rate * 1024), 1)
        if rate == self.upload_rate:
            return
        if self.last is None:
            self.upload_rate = rate
        else:
            self.cycle += 1
            if rate > 0:
                # Here self.bytes_sent is > 0
                t = clock()
                if self.upload_rate:
                    self.bytes_sent -= (t - self.last_time) * self.upload_rate                    
                else:
                    self.bytes_sent = 0.
                self.last_time = t
                self.upload_rate = rate
                if self.bytes_sent > 0:
                    self.sched(self.try_send, self.bytes_sent / self.upload_rate, [self.cycle])
                else:
                    self.try_send(self.cycle)
            else:
                self.upload_rate = 0
                self.try_send(self.cycle)

    def queue(self, conn):
        if self.last is None:
            self.last = conn
            conn.next_upload = conn
            self.try_send(self.cycle, True)
        else:
            conn.next_upload = self.last.next_upload
            self.last.next_upload = conn
            self.last = conn

    def try_send(self, cycle, checktime = False):
        if cycle != self.cycle:
            return
        cur = self.last.next_upload

        if self.upload_rate > 0:
            if checktime:
                self.bytes_sent = 0.
            else:
                self.bytes_sent -= (clock() - self.last_time) * self.upload_rate
            firstloop = True
            firstofloop = cur
            while self.bytes_sent <= 0:
                trysend = int(2 ** cur.unitsize + 13)
                nbbytes = cur.send_partial(trysend)
                if nbbytes:
                    self.bytes_sent += nbbytes
                    cur.upload.measure.update_rate(nbbytes)
                    self.measure.update_rate(nbbytes)
                    bl = cur.backlogged()
                else:
                    bl = False
                if nbbytes == 0 or bl:
                    if bl and firstloop:
                        cur.unitsize = max(cur.unitsize - self.unitsizestep, MIN_UNITSIZE)
                        #print cur.get_ip(), 'DEC', cur.unitsize
                    if self.last is cur:
                        self.last = None
                        cur.next_upload = None
                        return
                    oldcur = cur
                    self.last.next_upload = cur.next_upload
                    cur.next_upload = None
                    cur = self.last.next_upload
                    if firstloop:
                        if oldcur is firstofloop:
                            firstofloop = cur
                        elif cur is firstofloop:
                            firstloop = False
                else:
                    if nbbytes == trysend:
                        if cur.unitsizeinccount == self.unitsizeinctrig:
                            cur.unitsize = min(cur.unitsize + self.unitsizestep, MAX_UNITSIZE)
                            cur.unitsizeinccount = 0
                            #print cur.get_ip(), 'INC', cur.unitsize
                        else:
                            cur.unitsizeinccount += 1
                    self.last = cur
                    cur = cur.next_upload
                    if firstloop and cur is firstofloop:
                        firstloop = False
            self.last_time = clock()
            self.sched(self.try_send, max(self.bytes_sent / self.upload_rate, 0), [cycle])
        else:
            # Try to send max ~500 kB per peer
            while True:
                # exit of main loop when there's nothing to send or all peers are backlogged
                # or all peers still in the send loop have sent the max
                if cur.bytes_sent == 524496:
                    if firstatmax is None:
                        firstatmax = cur
                    elif cur is firstatmax:
                        # All connections still in send loop are at max
                        while cur.bytes_sent:
                            # final loop to reset bytes_sent for each connection still in send loop
                            cur.bytes_sent = 0
                            cur = cur.next_upload
                        self.sched(self.try_send, 0, [cycle])
                        return
                    self.last = cur
                    cur = cur.next_upload
                else:
                    firstatmax = None
                    nbbytes = cur.send_partial(524496 - cur.bytes_sent)
                    if nbbytes:
                        cur.bytes_sent += nbbytes
                        cur.upload.measure.update_rate(nbbytes)
                        self.measure.update_rate(nbbytes)
                    if nbbytes == 0 or cur.backlogged():
                        cur.bytes_sent = 0
                        if self.last is cur:
                            self.last = None
                            cur.next_upload = None
                            return
                        self.last.next_upload = cur.next_upload
                        cur.next_upload = None
                        cur = self.last.next_upload
                    else:
                        self.last = cur
                        cur = cur.next_upload

    def adjust_sent(self, nbbytes):
        self.bytes_sent = min(self.bytes_sent + nbbytes, self.upload_rate * 3.)
        self.measure.update_rate(nbbytes)
