# Written by John Hoffman
# Updated and modified for ABC_OKC : Old King Cole

import os
from bencode import bencode, bdecode
from binascii import hexlify


class ConfigDir:
    ###### INITIALIZATION TASKS ######
    def __init__(self, dir_root):
        self.dir_root = dir_root
        self.dir_datacache = os.path.join(dir_root, 'datacache')
        self.dir_piececache = os.path.join(dir_root, 'piececache')

    ###### TORRENT DATA HANDLING ######
    def getTorrentData(self, t):
        t = os.path.join(self.dir_datacache, hexlify(t))
        if not os.path.exists(t):
            return None
        try:
            f = open(t, 'rb')
            r = bdecode(f.read())
        except:
            try:
                f.close()
            except:
                pass
            r = None
        else:
            f.close()
        return r

    def writeTorrentData(self, t, data):
        try:
            f = open(os.path.join(self.dir_datacache, hexlify(t)), 'wb')
            f.write(bencode(data))
        except:
            try:
                f.close()
            except:
                pass
            self.deleteTorrentData(t)
        else:
            f.close()

    def deleteTorrentData(self, t):
        try:
            os.remove(os.path.join(self.dir_datacache, hexlify(t)))
        except:
            pass

    def touchTorrentData(self, t):
        try:
            os.utime(os.path.join(self.dir_datacache, hexlify(t)), None)
        except:
            pass

    def getPieceDir(self, t):
        return os.path.join(self.dir_piececache, hexlify(t))
