# Written by Bram Cohen
# modified for multitracker operation by John Hoffman
# see LICENSE.txt for license information
# Updated and modified for ABC_OKC : Old King Cole

from BitTornado.zurllib import urlopen, udpurlopen
from urllib import quote
from BitTornado.utility import exceptionArgsToString, getABCUtility
from urlparse import urlparse
from socket import error as socketerror
from BitTornado.bencode import bdecode
from threading import Thread, Event
from random import shuffle, randint
from hashlib import sha1
from time import clock, time, sleep
from binascii import b2a_hex
try:
    from os import getpid
except ImportError:
    def getpid():
        return 1


keys = {}
basekeydata = unicode(getpid()) + repr(time()) + 'tracker'
ints = (long, int)
numbers = (long, int, float)

def add_key(tracker):
    keys[tracker] = sha1((basekeydata + tracker).encode('utf_8')).digest()[-4:]

def get_key(tracker):
    try:
        return keys[tracker]
    except:
        add_key(tracker)
        return keys[tracker]

def check_peers(message, ipv6enabled):
    if type(message) is not dict:
        raise ValueError
    if message.has_key('failure reason'):
        if type(message['failure reason']) is not str:
            raise ValueError
        return
    if message.has_key('warning message'):
        if type(message['warning message']) is not str:
            raise ValueError
    peers = message.get('peers')
    if type(peers) is list:
        for p in peers:
            if type(p) is not dict:
                raise ValueError
            if type(p.get('ip')) is not str:
                raise ValueError
            port = p.get('port')
            if type(port) not in ints:
                raise ValueError
            if not 0 <= int(port) <= 65535:
                raise ValueError
            if p.has_key('peer id'):
                id = p['peer id']
                if type(id) is not str:
                    raise ValueError
    elif type(peers) is not str or len(peers) % 6 != 0:
        raise ValueError
    if ipv6enabled:
        peers6 = message.get('peers6')
        if peers6 is not None and (type(peers6) is not str or len(peers6) % 18 != 0):
            raise ValueError
    interval = message.get('interval', 1)
    if type(interval) not in numbers:
        raise ValueError
    minint = message.get('min interval', 1)
    if type(minint) not in numbers:
        raise ValueError
    if type(message.get('tracker id', '')) is not str:
        raise ValueError
    npeers = message.get('num peers', 0)
    if type(npeers) not in ints or npeers < 0:
        raise ValueError
    dpeers = message.get('done peers', 0)
    if type(dpeers) not in ints or dpeers < 0:
        raise ValueError
    last = message.get('last', 0)
    if type(last) not in ints or last < 0:
        raise ValueError

def tobinary16(i):
    return (chr(i >> 8) + chr(i & 0xFF))

def tobinary(i):
    return (chr(i >> 24) + chr((i >> 16) & 0xFF) + 
            chr((i >> 8) & 0xFF) + chr(i & 0xFF))

def tobinary64(i):
    return (chr(i >> 56) + chr((i >> 48) & 0xFF) +
            chr((i >> 40) & 0xFF) + chr((i >> 32) & 0xFF) +
            chr((i >> 24) & 0xFF) + chr((i >> 16) & 0xFF) + 
            chr((i >> 8) & 0xFF) + chr(i & 0xFF))

def toint(s):
    return long(b2a_hex(s), 16)


class Rerequester:
    def __init__(self, port, myid, infohash, trackerlist, config,
                 sched, errorfunc, connect,
                 howmany, amount_left, up, down,
                 doneflag, unpauseflag, seededfunc = None, special = None,
                 trackerokfunc = None, trackerconnectingfunc = None,
                 updateseenpeersfunc = None, creatererequesterfunc = None,
                 rerequeststartedfunc = None, rejectexceptions = []):
        if port is None:
            port = 0
        self.config = config
        self.sched = sched
        self.errorfunc = errorfunc
        self.connect = connect
        self.howmany = howmany
        self.amount_left = amount_left
        self.up = up
        self.down = down
        self.upatstart = 0L
        self.downatstart = 0L
        self.doneflag = doneflag
        self.unpauseflag = unpauseflag
        self.seededfunc = seededfunc
        self.special = special
        self.trackerokfunc = trackerokfunc
        self.trackerconnectingfunc = trackerconnectingfunc
        self.updateseenpeersfunc = updateseenpeersfunc
        self.creatererequesterfunc = creatererequesterfunc
        self.rerequeststartedfunc = rerequeststartedfunc
        self.rejectexceptions = rejectexceptions

        self.ip = config.get('ip')
        self.resolvedip = None
        self.multihomeipv4 = quote(config.get('multihome_ipv4'), '')
        self.multihomeipv6 = quote(config.get('multihome_ipv6'), '')
        self.minpeers = config['min_peers']
        self.maxpeers = config['max_initiate']
        self.interval = config['rerequest_interval']
        self.ipv6enabled = config['ipv6_enabled']

        self.trackerlist = []
        for tier in trackerlist:
            if len(tier) > 1:
                shuffle(tier)
            self.trackerlist += [tier]
        self.defaulttracker = config['default_tracker']
        if not self.defaulttracker:
            self.defaulttracker = None

        self.trackerfirstcall = {}

        for tl in self.trackerlist:
            for t in tl:
                self.trackerfirstcall[t] = True
        if self.special is not None:
            self.trackerfirstcall[self.special] = True

        self.rejectedmessage = getABCUtility().lang.get('rejectedtracker') + ' - '

        self.url = ('info_hash=%s&peer_id=%s' % (quote(infohash, ''), quote(myid, '')))
        if not config.get('crypto_allowed'):
            self.url += "&port="
        else:
            self.url += "&supportcrypto=1"
            if not config.get('crypto_only'):
                    self.url += "&port="
            else:
                self.url += "&requirecrypto=1"            
                if not config.get('crypto_stealth'):
                    self.url += "&port="
                else:
                    self.url += "&port=0&cryptoport="
        self.url += str(port)

        seed_id = config.get('dedicated_seed_id')
        if seed_id:
            self.url += '&seed_id=' + quote(seed_id, '')
        if self.seededfunc:
            self.url += '&check_seeded=1'

        if not self.ipv6enabled:
            self.request = [infohash, myid, chr((port & 0xFF00) >> 8) + chr(port & 0xFF)]

        self.trackerid = {}
        self.announce_interval = 1800
        self.lastintsuccessful = None
        self.lastextsuccessful = False
        self.tryingtoconnect = True
        self.errorcodes = {}
        # True if one rejected message from trackers contains one string from the list rejectexceptions
        # In this case the torrent is not considered as definitely rejected and will not be stopped
        # if rejection immediately occurs after starting
        self.rejectexception = False
        self.last_announce = 0
        self.stopped = True
        self.first_reqcycle = True
        # To store the last connection time in a retry cycle for each tracker
        self.lastannouncedtracker = None
        self.cycleindex = 0
        self.rerequestqueue = []
        self.lastannounce = None
        # Tracker connection status : 0 : fail, 1 : success, +10 : finished, 20 : special pre fail-scheduling
        self.trackercnxstatus = 10

    def start(self, rescan = False):
        if self.stopped:
            self.stopped = False
            if rescan:
                self.announce(5)
            else:
                self.announce(0)

    def stop(self):
        if not self.stopped:
            self.stopped = True
            self.announce(2)

    def switchTracker(self, tracker, specialurl = None):
        if tracker == 'ext' and specialurl is None \
           or tracker == 'int' and self.special is None:
            return
        oldstop = self.stopped
        self.stop()
        if tracker == 'ext':
            self.special = specialurl
        elif tracker == 'int':
            self.special = None
        if self.unpauseflag.isSet() and not oldstop:
            self.start()

    def resetTracker(self, rescan = False):
        if not self.stopped:
            self.stop()
            if self.unpauseflag.isSet():
                self.start(rescan)

    def continueTracker(self):
        if not self.stopped:
            self.announce(4)

    def d(self, cycleindex):
        if cycleindex != self.cycleindex:
            return
        if not self.unpauseflag.isSet():
            self.stop()
            return
        if self.tryingtoconnect:
            self.announce(3)    
        elif self.howmany() < self.minpeers or clock() - self.last_announce > self.announce_interval:
            self.tryingtoconnect = True
            self.announce(3)
        else:
            self._d(cycleindex)

    def _d(self, cycleindex):
        if self.tryingtoconnect:
            # Retry every 60 seconds if never succeeded
            self.sched(self.d, 60, [cycleindex])
        else:
            self.first_reqcycle = False
            self.sched(self.d, self.interval, [cycleindex])

    def hit(self, event = 3):
        return
        #if not self.unpauseflag.isSet() and self.howmany() < self.minpeers:
        #    self.announce(event)

    def announce(self, event):
        # event :
        # 0 : started ; 1 : completed ; 2 : stopped ; 3 : continue ;
        # 4 : continue from manual reannounce ; 5 : started with rescan
        # 10 : create another rerequester ; 11 : start new dow rerequester
        if event not in (2, 10, 11) and not self.unpauseflag.isSet():
            return
        if event == 2:
            self.cycleindex += 1
            if self.doneflag.isSet():
                if not self.lastannounce:
                    return
                if self.lastannounce[0] == 2:
                    return
                thread = Thread(target = self._rerequestLastStopped, args = [self.lastannounce[1], self.cycleindex])
                thread.daemon = False
                thread.start()
                return

        self.rerequestqueue.append((event, self.special, self.cycleindex))
        if len(self.rerequestqueue) == 1:
            self.rerequest()

    def rerequest(self):
        if self.doneflag.isSet():
            return
        if self.trackercnxstatus < 10 or self.trackercnxstatus == 20:
            # If still waiting for prior rerequest to complete then retry in 1 seconds
            self.sched(self.rerequest, 1)
            return
        event, special, cycleindex = self.lastannounce = self.rerequestqueue.pop(0)
        if event == 10:
            self.creatererequesterfunc()
            if self.rerequestqueue:
                self.sched(self.rerequest)
            return
        if event == 11:
            self.rerequeststartedfunc()
            if self.rerequestqueue:
                self.sched(self.rerequest)
            return
        if event == 5 and special is None:
            self.lastintsuccessful = None
            event = 0
        elif event == 3 and (self.special is None and not self.lastintsuccessful
                             or self.special is not None and not self.lastextsuccessful):
            event = 0
        elif event == 1 or event == 2:
            if special is None and not self.lastintsuccessful \
               or special is not None and not self.lastextsuccessful:
                if self.rerequestqueue:
                    self.sched(self.rerequest)
                return
        if (event == 0 or event == 4) and special is None and not self.trackerlist:
            self.updateseenpeersfunc(getABCUtility().notrackermarker, getABCUtility().notrackermarker)
            if self.rerequestqueue:
                self.sched(self.rerequest)
            return
        if event == 0:
            if special is None:
                for tl in self.trackerlist:
                    for t in tl:
                        self.trackerfirstcall[t] = True
            else:
                self.trackerfirstcall[special] = True
            self.tryingtoconnect = True
        self.trackercnxstatus = 0
        if event != 2:
            self.trackerconnectingfunc()
        thread = Thread(target = self._rerequest, args = [event, special, cycleindex])
        thread.daemon = False
        thread.start()
        if self.rerequestqueue:
            self.sched(self.rerequest)

    def _rerequestLastStopped(self, special, cycleindex):
        while self.trackercnxstatus < 10:
            sleep(0.2)
        if special is None and not self.lastintsuccessful \
           or special is not None and not self.lastextsuccessful:
            return
        self.trackercnxstatus = 0
        self._rerequest(2, special, cycleindex)
    
    def _rerequest(self, event, special, cycleindex):
        if event == 0:
            callback = self._d
            self.upatstart = self.up()
            self.downatstart = self.down()
        elif event == 3:
            callback = self._d
        else:
            callback = None
            if event == 4:
                if special is None and not self.lastintsuccessful \
                   or special is not None and not self.lastextsuccessful:
                    self.upatstart = self.up()
                    self.downatstart = self.down()
                    event = 0
                else:
                    event = 3

        self.errorcodes = {}
        if self.ip:
            resolvedip = getABCUtility().getHostByName(self.ip)
            if resolvedip is None:
                self.errorcodes['troublecode'] = getABCUtility().lang.get('cantresolve') + self.ip
                if self.doneflag.isSet():
                    self.trackercnxstatus = 10
                    return
                self.trackercnxstatus = 20
                self.sched(self._fail, 0, [callback, special, cycleindex])
                return
            self.resolvedip = resolvedip
        self.rejectexception = False
        if special is None:
            if self.defaulttracker is not None:
                if self.rerequest_single(self.defaulttracker, event, callback, cycleindex):
                    if not self.doneflag.isSet():
                        for tlr in xrange(len(self.trackerlist)):
                            for tr in xrange(len(self.trackerlist[tlr])):
                                if self.trackerlist[tlr][tr] == self.defaulttracker:
                                    if tr != 0:
                                        del self.trackerlist[tlr][tr]
                                        self.trackerlist[tlr].insert(0, self.defaulttracker)
                                    break
                        self.defaulttracker = None
                    self.trackercnxstatus = 11
                    return
                if event == 2:
                    self.defaulttracker = None
                    self.trackercnxstatus = 10
                    return
                if event == 1 or event == 3:
                    self.upatstart = self.up()
                    self.downatstart = self.down()
                    event = 0
            elif self.lastintsuccessful is not None:
                if self.rerequest_single(self.lastintsuccessful, event, callback, cycleindex):
                    self.trackercnxstatus = 11
                    return
                if event == 2:
                    self.trackercnxstatus = 10
                    return
                if event == 1 or event == 3:
                    self.upatstart = self.up()
                    self.downatstart = self.down()
                    event = 0
            # Only null events reach this point
            for tlr in xrange(len(self.trackerlist)):
                for tr in xrange(len(self.trackerlist[tlr])):
                    if self.doneflag.isSet():
                        self.trackercnxstatus = 10
                        return
                    tracker = self.trackerlist[tlr][tr]
                    # Filter out default tracker or last successful if null events come after failed 1 or 3 event sent to them
                    if tracker == self.defaulttracker or tracker == self.lastintsuccessful:
                        continue
                    if tracker == '':
                        self.errorcodes['warning'] = getABCUtility().lang.get('missinginttracker')
                    elif self.rerequest_single(tracker, event, callback, cycleindex):
                        if tr != 0 and not self.doneflag.isSet():
                            del self.trackerlist[tlr][tr]
                            self.trackerlist[tlr].insert(0, tracker)
                        self.defaulttracker = None
                        self.trackercnxstatus = 11
                        return
            self.defaulttracker = None
        elif special == '':
            if event == 2:
                self.trackercnxstatus = 10
                return
            self.errorcodes['warning'] = getABCUtility().lang.get('missingexttracker')
            self.tryingtoconnect = False
        else:
            if self.rerequest_single(special, event, callback, cycleindex, external = True):
                self.trackercnxstatus = 11
                return
            if event == 2:
                self.trackercnxstatus = 10
                return
        # No success from any tracker
        if self.doneflag.isSet():
            self.trackercnxstatus = 10
            return
        self.trackercnxstatus = 20
        self.sched(self._fail, 0, [callback, special, cycleindex])

    def _fail(self, callback, special, cycleindex):
        errorfamily = None
        for f in ['rejected', 'bad_data', 'troublecode', 'warning']:
            if self.errorcodes.has_key(f):
                errorfamily = f
                r = self.errorcodes[f]
                break
        else:
            r = ''
        if r:
            self.errorfunc(r, self.first_reqcycle and errorfamily == 'rejected' and len(self.errorcodes) == 1 and not self.rejectexception,
                           special is not None, errorfamily == 'warning')
        self.updateseenpeersfunc(getABCUtility().notrackeranswermarker, getABCUtility().notrackeranswermarker)

        if special is None:
            self.lastintsuccessful = None
        else:
            self.lastextsuccessful = False
        if callback:
            callback(cycleindex)
        self.trackercnxstatus = 10

    def rerequest_single(self, t, event, callback, cycleindex, external = False):
        self._rerequest_single(t, event, callback, cycleindex)
        if self.trackercnxstatus == 1:
            if external:
                self.lastextsuccessful = True
            else:
                self.lastintsuccessful = t
            self.trackerokfunc(event != 2, t, external)
            return True
        return False

    def _rerequest_single(self, t, event, callback, cycleindex):
        if self.config['magnet']:
            # Some trackers don't include seeds in their answer when amountleft is null
            # In fact this value is unknown for magnets because the data size is unknown
            # So it's given some random value
            amountleft = randint(1024, 1048576)
        else:
            amountleft = self.amount_left()
        if urlparse(t).scheme == 'udp':
            if self.ip and self.resolvedip.find('.') >= 0:
                ip = ''.join([chr(int(i)) for i in self.resolvedip.split('.')])
            else:
                ip = "\x00\x00\x00\x00"
            if event == 2 or self.howmany() >= self.maxpeers:
                numwant = "\x00\x00\x00\x00"
            else:
                numwant = "\xFF\xFF\xFF\xFF"
            request = ''.join([self.request[0], self.request[1], tobinary64(self.down() - self.downatstart), tobinary64(amountleft),
                               tobinary64(self.up() - self.upatstart), tobinary([2, 1, 3, 0][event]), ip, get_key(t), numwant,
                               self.request[2]])
            self._rerequest_single_UDP(t, request, event, callback, cycleindex)
        else:
            s = ('%s&uploaded=%s&downloaded=%s&left=%s' %
                (self.url, str(self.up() - self.upatstart), str(self.down() - self.downatstart), str(amountleft)))
            tid = self.trackerid.get(t)
            if tid is not None:
                s += '&trackerid=' + quote(str(tid), '')
            if event == 2 or self.howmany() >= self.maxpeers:
                s += '&numwant=0'
            else:
                s += '&no_peer_id=1&compact=1'
            if event != 3:
                s += '&event=' + ['started', 'completed', 'stopped'][event]
            if self.ipv6enabled:
                if self.multihomeipv4:
                    s += '&ipv4=' + self.multihomeipv4
                if self.multihomeipv6:
                    s += '&ipv6=' + self.multihomeipv6
            if self.resolvedip:
                s += '&ip=' + self.resolvedip
            s += "&key=" + str(toint(get_key(t)))
            self._rerequest_single_HTTP(t, s, event, callback, cycleindex)

    def _rerequest_single_HTTP(self, t, s, event, callback, cycleindex):
        err = None
        query = urlparse(t)[4]
        if query and t[-1] != '&':
            infohashprefix = '&'
        elif not query and t[-1] != '?':
            infohashprefix = '?'
        else:
            infohashprefix = ''
        self.last_announce = clock()
        try:
            h = urlopen(t + infohashprefix + s)
            if event != 2:
                data = h.read()
        except (IOError, socketerror), e:
            err = getABCUtility().lang.get('cantreachtracker') + ' - ' + exceptionArgsToString(e)
        except:
            err = getABCUtility().lang.get('cantreachtracker')
        try:
            h.close()
        except:
            pass

        if event == 2:
            self.trackercnxstatus = 1
            return

        if err:
            self.errorcodes['troublecode'] = err
            return

        if data == '':
            self.errorcodes['troublecode'] = getABCUtility().lang.get('nodatatracker')
            return

        try:
            r = bdecode(data, sloppy = 1)
            check_peers(r, self.ipv6enabled)
        except ValueError, e:
            self.errorcodes['bad_data'] = getABCUtility().lang.get('baddatatracker') + ' - ' + exceptionArgsToString(e)
            return

        if r.has_key('failure reason'):
            failurereason = getABCUtility().decodeString(r['failure reason'])
            self.errorcodes['rejected'] = self.rejectedmessage + failurereason
            if not self.rejectexception:
                for s in self.rejectexceptions:
                    if failurereason.find(s) >= 0:
                        self.rejectexception = True
                        break
            return

        self.trackercnxstatus = 1     # success!
        self.tryingtoconnect = False

        self.sched(self.postrequest_HTTP, 0, [r, callback, t, cycleindex])

    def postrequest_HTTP(self, r, callback, t, cycleindex):
        if r.has_key('warning message'):
            self.errorfunc(getABCUtility().lang.get('warningtracker') + ' - ' + getABCUtility().decodeString(r['warning message']))
        self.announce_interval = r.get('interval')
        if self.announce_interval is None or self.announce_interval <= 0:
            self.announce_interval = 1800
        self.interval = r.get('min interval')
        if self.interval is None or self.interval <= 0:
            self.interval = self.config['rerequest_interval']
        tid = r.get('tracker id')
        if tid is not None:
            self.trackerid[t] = tid

        peers = []
        p = r.get('peers')
        if p is not None:
            if type(p) is str:
                lenpeers = len(p) / 6
            else:
                lenpeers = len(p)
            cflags = r.get('crypto_flags')
            if type(cflags) is not str or len(cflags) != lenpeers:
                cflags = None
            if cflags is None:
                cflags = lenpeers * [None]
            else:
                cflags = [ord(x) for x in cflags]
            if type(p) is str:
                for x in xrange(0, len(p), 6):
                    dup = False
                    for y in xrange(0, x, 6):
                        if p[x:x + 6] == p[y:y + 6]:
                            dup = True
                            break
                    if dup:
                        continue
                    ip = '.'.join([str(ord(i)) for i in p[x:x + 4]])
                    port = (ord(p[x + 4]) << 8) + ord(p[x + 5])
                    peers.append(((ip, port), 0, cflags[x / 6], None, 1))
            else:
                allipports =[]
                for i in xrange(lenpeers):
                    x = p[i]
                    ipport = (x['ip'].strip(), x['port'])
                    dup = False
                    for y in allipports:
                        if y == ipport:
                            dup = True
                            break
                    if dup:
                        continue
                    allipports.append(ipport)
                    peers.append((ipport,
                                  x.get('peer_id', 0), cflags[i], None, 1))
        if self.ipv6enabled:
            p6 = r.get('peers6')
            if p6 is not None:
                for x in xrange(0, len(p6), 18):
                    dup = False
                    for y in xrange(0, x, 18):
                        if p[x:x + 18] == p[y:y + 18]:
                            dup = True
                            break
                    if dup:
                        continue
                    hexpeerinfo = hexlify(p6[x:x + 16])
                    ip = ':'.join([hexpeerinfo[i:i + 4] for i in xrange(0, 32, 4)])
                    port = (ord(p6[x + 16]) << 8) + ord(p6[x + 17])
                    peers.append(((ip, port), 0, None, None, 1))

        comp = r.get('complete')
        if comp is None or type(comp) != int or comp < 0:
            numseenseeds = None
        else:
            numseenseeds = str(comp)
        incomp = r.get('incomplete')
        if incomp is None or type(incomp) != int or incomp < 0:
            numseenpeers = None
        else:
            numseenpeers = str(incomp)
        self.updateseenpeersfunc(numseenseeds, numseenpeers)

        if self.unpauseflag.isSet():
            if self.seededfunc and r.get('seeded'):
                self.seededfunc()
            elif peers:
                shuffle(peers)
                self.connect(peers, 1 - self.trackerfirstcall[t])
            self.trackerfirstcall[t] = False
        if callback:
            callback(cycleindex)

    def _rerequest_single_UDP(self, t, request, event, callback, cycleindex):
        err = None
        self.last_announce = clock()
        try:
            announcedata = udpurlopen(t, (1, request))
        except IOError, e:
            err = getABCUtility().lang.get('cantreachtracker') + ' - ' + exceptionArgsToString(e)
        except:
            err = getABCUtility().lang.get('cantreachtracker')

        if event == 2:
            self.trackercnxstatus = 1
            return

        if err:
            self.errorcodes['troublecode'] = err
            return

        if len(announcedata) < 20:
            self.errorcodes['troublecode'] = getABCUtility().lang.get('baddatatracker')
            return

        self.trackercnxstatus = 1     # success!
        self.tryingtoconnect = False

        self.sched(self.postrequest_UDP, 0, [announcedata, callback, t, cycleindex])

    def postrequest_UDP(self, announcedata, callback, t, cycleindex):
        self.announce_interval = toint(announcedata[8:12])
        if self.announce_interval <= 0:
            self.announce_interval = 1800
        self.interval = self.config['rerequest_interval']

        nsp = toint(announcedata[12:16])
        if nsp >= 0:
            numseenpeers = str(nsp)
        else:
            numseenpeers = None
        nss = toint(announcedata[16:20])
        if nss >= 0:
            numseenseeds = str(nss)
        else:
            numseenseeds = None
        self.updateseenpeersfunc(numseenseeds, numseenpeers)

        peers = []
        for x in xrange(20, len(announcedata), 6):
            dup = False
            for y in xrange(20, x, 6):
                if announcedata[x:x + 6] == announcedata[y:y + 6]:
                    dup = True
                    break
            if dup:
                continue
            ip = '.'.join([str(ord(i)) for i in announcedata[x:x + 4]])
            port = (ord(announcedata[x + 4]) << 8) + ord(announcedata[x + 5])
            peers.append(((ip, port), 0, None, None, 1))

        if self.unpauseflag.isSet():
            if peers:
                shuffle(peers)
                self.connect(peers, 1 - self.trackerfirstcall[t])
            self.trackerfirstcall[t] = False
        if callback:
            callback(cycleindex)
