##############################################################################
# Module : template.py
# Author : Old King Cole
# Date   : 01/29/2005
#
# Description : Parameters templates for torrents
#
##############################################################################
from os import remove, rename, path

from filemanager import TorrentConfigFileManager, TemplateListFileManager


##############################################################
# Class : Template
##############################################################
class Template:
    def __init__(self, description, hidden, linkable, sticky,
                 templabelswitch, shortlabel,
                 tempdownloadswitch, maxdownrate, prioritizedown,
                 tempuploadswitch, maxupload, maxuprate, prioritizeup,
                 tempseedingswitch, uploadoption, uploadtimeh, uploadtimem, uploadratio,
                 temptimeoutswitch, timeoutswitch, timeoutaction, timeoutwork, timeoutworkdown,
                 timeoutworktrack, timeoutseed, timeoutseedup, timeoutseedtrack, timeouttracker,
                 timeoutdownload, timeoutupload, tempmoveswitch, movefolder, temptrackerswitch,
                 exttracker, exttrackerurl, checkinttrackwait, extrainttracker, inttrackerurl,
                 defaultdownlocswitch, defaultdownloc,
                 ruletrigrank, ruleactive,
                 ruletracker, ruletrackersw, ruletorrent, ruletorrentsw,
                 ruletorrentfile, ruletorrentfilesw, rulereceived, rulereceivedsw,
                 rulesizeg, rulesizel):
        self.description = description
        self.hidden = hidden
        self.linkable = linkable
        self.sticky = sticky
        self.templabelswitch = templabelswitch
        self.shortlabel = shortlabel
        self.tempdownloadswitch = tempdownloadswitch
        self.maxdownrate = maxdownrate
        self.prioritizedown = prioritizedown
        self.tempuploadswitch = tempuploadswitch
        self.maxupload = maxupload
        self.maxuprate = maxuprate
        self.prioritizeup = prioritizeup
        self.tempseedingswitch = tempseedingswitch
        self.uploadtillcopycomplete, self.uploadoption = divmod(uploadoption, 10)
        self.uploadtimeh = uploadtimeh
        self.uploadtimem = uploadtimem
        self.uploadratio = uploadratio
        self.temptimeoutswitch = temptimeoutswitch
        self.timeoutswitch = timeoutswitch
        self.timeoutaction = timeoutaction
        self.timeoutwork = timeoutwork
        self.timeoutworkdown = timeoutworkdown
        self.timeoutworktrack = timeoutworktrack
        self.timeoutseed = timeoutseed
        self.timeoutseedup = timeoutseedup
        self.timeoutseedtrack = timeoutseedtrack
        self.timeouttracker = timeouttracker
        self.timeoutdownload = timeoutdownload
        self.timeoutupload = timeoutupload
        self.tempmoveswitch = tempmoveswitch
        self.movefolder = movefolder
        self.temptrackerswitch = temptrackerswitch
        self.exttracker = exttracker
        self.exttrackerurl = exttrackerurl
        self.checkinttrackwait = checkinttrackwait
        self.extrainttracker = extrainttracker
        self.inttrackerurl = inttrackerurl
        self.defaultdownlocswitch = defaultdownlocswitch
        self.defaultdownloc = defaultdownloc
        self.ruletrigrank = ruletrigrank
        self.ruleactive = ruleactive
        self.ruletracker = ruletracker
        self.ruletrackersw = ruletrackersw
        self.ruletorrent = ruletorrent
        self.ruletorrentsw = ruletorrentsw
        self.ruletorrentfile = ruletorrentfile
        self.ruletorrentfilesw = ruletorrentfilesw
        self.rulereceived = rulereceived
        self.rulereceivedsw = rulereceivedsw
        self.rulesizeg = rulesizeg
        self.rulesizel = rulesizel
        self.conlimiters = []
        self.previndex = self.previndextrig = 1000000000

    def isTriggerRuleActive(self):
        return self.ruleactive \
               and (self.ruletracker != '' or self.ruletorrent != '' or self.ruletorrentfile != '' 
                    or self.rulereceived != '' or self.rulesizeg != '' or self.rulesizel != '')

    def canBeTriggered(self, magnet):
        return self.ruleactive \
               and (self.ruletracker != '' or self.ruletorrent != '' or self.ruletorrentfile != ''
                    or self.rulereceived != '' or not magnet and (self.rulesizeg != '' or self.rulesizel != ''))


##############################################################
# Class : TemplateManager
##############################################################
class TemplateManager:
    def __init__(self, parent):
        self.parent = parent
        self.utility = parent.utility
        self.templates = {}
        self.tempbyindex = []
        self.tempbytrigrank = []

        templatelistfile = TemplateListFileManager(self)
        templatelistfile.open()
        index = -1
        while True:
            temp = templatelistfile.readList()
            if temp is None:
                break
            if len(temp) != 53:
                continue
            index += 1
            if temp[22] == '-1':
                temp[22] = str(index)
            self.templates[temp[0]] = Template(temp[1], int(temp[21]), int(temp[51]), int(temp[52]), int(temp[2]), temp[3], int(temp[18]), int(temp[19]),
                                               int(temp[39]), int(temp[4]), int(temp[5]), int(temp[6]), int(temp[40]), int(temp[20]), int(temp[7]),
                                               int(temp[8]), int(temp[9]), int(temp[10]), int(temp[11]), int(temp[12]), int(temp[38]), int(temp[32]),
                                               int(temp[33]), int(temp[34]), int(temp[35]), int(temp[36]), int(temp[37]), int(temp[13]), int(temp[14]),
                                               int(temp[15]), int(temp[16]), temp[17], int(temp[41]), int(temp[42]), temp[43], int(temp[44]),
                                               int(temp[45]), temp[46], int(temp[47]), temp[48], int(temp[22]), int(temp[23]), temp[24], int(temp[25]),
                                               temp[26], int(temp[27]), temp[28], int(temp[29]), temp[30], int(temp[31]), temp[49], temp[50])
            self.tempbyindex.append(temp[0])
        templatelistfile.close()
        # Check if default template exists
        nodefault = False
        if self.utility.abcparams['templatedefault'] not in self.templates:
            if 'default' not in self.templates:
                self.createFirstDefaultTemplate()
            self.utility.abcparams['templatedefault'] = 'default'
            nodefault = True

        trigrankandkey = [(self.templates[key].ruletrigrank, key) for key in self.templates.keys()]
        trigrankandkey.sort()
        self.tempbytrigrank = [t[1] for t in trigrankandkey]

        if nodefault:
            tcfm = TorrentConfigFileManager(path.join(self.utility.datapath, "abc.conf"), self.utility.abcparams)
            tcfm.writeAllConfig()
        if nodefault or templatelistfile.oldformat:
            templatelistfile.open('w+')
            try:
                templatelistfile.writeList(self.templates, self.tempbyindex, self.tempbytrigrank)
            except:
                templatelistfile.close()
            else:
                templatelistfile.close()
                try:
                    remove(templatelistfile.filename)
                except:
                    pass
                rename(templatelistfile.filename + '.part', templatelistfile.filename)

    def createFirstDefaultTemplate(self):
        self.templates['default'] = Template('Default template',
                                             0,
                                             0,
                                             0,
                                             1,
                                             'def',
                                             1,
                                             0,
                                             0,
                                             1,
                                             4,
                                             0,
                                             0,
                                             1,
                                             0,
                                             0,
                                             30,
                                             50,
                                             1,
                                             1,
                                             0,
                                             1,
                                             1,
                                             1,
                                             1,
                                             1,
                                             1,
                                             60,
                                             60,
                                             60,
                                             1,
                                             '',
                                             1,
                                             0,
                                             '',
                                             0,
                                             0,
                                             '',
                                             1,
                                             '',
                                             len(self.templates),
                                             0,
                                             '',
                                             0,
                                             '',
                                             0,
                                             '',
                                             0,
                                             '',
                                             0,
                                             '',
                                             ''
                                             )
        self.tempbyindex.append('default')
        self.tempbytrigrank.append('default')
    
    def createTemplate(self, dico, tempbyindex, tempbytrigrank, name, default):
        deftemp = dico[default]
        dico[name] = Template(deftemp.description,
                              deftemp.hidden,
                              deftemp.linkable,
                              deftemp.sticky,
                              deftemp.templabelswitch,
                              deftemp.shortlabel,
                              deftemp.tempdownloadswitch,
                              deftemp.maxdownrate,
                              deftemp.prioritizedown,
                              deftemp.tempuploadswitch,
                              deftemp.maxupload,
                              deftemp.maxuprate,
                              deftemp.prioritizeup,
                              deftemp.tempseedingswitch,
                              deftemp.uploadoption,
                              deftemp.uploadtimeh,
                              deftemp.uploadtimem,
                              deftemp.uploadratio,
                              deftemp.temptimeoutswitch,
                              deftemp.timeoutswitch,
                              deftemp.timeoutaction,
                              deftemp.timeoutwork,
                              deftemp.timeoutworkdown,
                              deftemp.timeoutworktrack,
                              deftemp.timeoutseed,
                              deftemp.timeoutseedup,
                              deftemp.timeoutseedtrack,
                              deftemp.timeouttracker,
                              deftemp.timeoutdownload,
                              deftemp.timeoutupload,
                              deftemp.tempmoveswitch,
                              deftemp.movefolder,
                              deftemp.temptrackerswitch,
                              deftemp.exttracker,
                              deftemp.exttrackerurl,
                              deftemp.checkinttrackwait,
                              deftemp.extrainttracker,
                              deftemp.inttrackerurl,
                              0,
                              deftemp.defaultdownloc,
                              len(self.templates),
                              deftemp.ruleactive,
                              deftemp.ruletracker,
                              deftemp.ruletrackersw,
                              deftemp.ruletorrent,
                              deftemp.ruletorrentsw,
                              deftemp.ruletorrentfile,
                              deftemp.ruletorrentfilesw,
                              deftemp.rulereceived,
                              deftemp.rulereceivedsw,
                              deftemp.rulesizeg,
                              deftemp.rulesizel
                              )
        tempbyindex.append(name)
        tempbytrigrank.append(name)

    def getDefaultTemplate(self):
        return self.templates[self.utility.abcparams['templatedefault']]

    def getTriggeredTemplates(self, magnet, torrentname, torrentfilename, trackerlist, filesname, filelength):
        # Search for first template with rule matching
        triggeredtemplates = []
        deftempkey = self.utility.abcparams['templatedefault']
        for templatekey in self.tempbytrigrank:
            if templatekey == deftempkey:
                continue
            template = self.templates[templatekey]
            if template.canBeTriggered(magnet):
                trackernamestrings = template.ruletracker.lower().split()
                namestrings = template.ruletorrent.lower().split()
                filenamestrings = template.ruletorrentfile.lower().split()
                receivedtrings = template.rulereceived.lower().split()
                sizeg = template.rulesizeg
                sizel = template.rulesizel
                match = True
                # Tracker name
                if trackernamestrings:
                    if not trackerlist:
                        continue
                    for tracker in trackerlist:
                        match = template.ruletrackersw
                        if match:
                            for substr in trackernamestrings:
                                if tracker.find(substr) < 0:
                                    match = False
                                    break
                        else:
                            for substr in trackernamestrings:
                                if tracker.find(substr) >= 0:
                                    match = True
                                    break
                        if match:
                            break
                    if not match:
                        continue
                # Torrent name
                if namestrings:
                    match = template.ruletorrentsw
                    if match:
                        for substr in namestrings:
                            if torrentname.find(substr) < 0:
                                match = False
                                break
                    else:
                        for substr in namestrings:
                            if torrentname.find(substr) >= 0:
                                match = True
                                break
                    if not match:
                        continue
                # Torrent file name
                if filenamestrings:
                    match = template.ruletorrentfilesw
                    if match:
                        for substr in filenamestrings:
                            if torrentfilename.find(substr) < 0:
                                match = False
                                break
                    else:
                        for substr in filenamestrings:
                            if torrentfilename.find(substr) >= 0:
                                match = True
                                break
                    if not match:
                        continue
                # Received files name
                if receivedtrings:
                    if not filesname:
                        continue
                    for receivedfile in filesname:
                        match = template.rulereceivedsw
                        if match:
                            for substr in receivedtrings:
                                if receivedfile.find(substr) < 0:
                                    match = False
                                    break
                        else:
                            for substr in receivedtrings:
                                if receivedfile.find(substr) >= 0:
                                    match = True
                                    break
                        if match:
                            break
                    if not match:
                        continue
                # Global size of all files
                if not magnet:
                    if sizeg:
                        try:
                            sizeg = int(sizeg)
                        except:
                            pass
                        else:
                            if filelength < sizeg:
                                continue
                    if sizel:
                        try:
                            sizel = int(sizel)
                        except:
                            pass
                        else:
                            if filelength > sizel:
                                continue

                triggeredtemplates.append(templatekey)
                if template.linkable:
                    continue
                break
        return triggeredtemplates

    def getTemplateDefaultDownLoc(self, templates):
        for template in reversed(templates):
            t = self.templates[template]
            if t.defaultdownlocswitch:
                return t.defaultdownloc
        return None
