##############################################################################
# Module : lang.py
# Author :
# Date   :
# Updated and modified for ABC_OKC : Old King Cole
#
# Description : Language
#
##############################################################################
import wx, sys, os

from filemanager import TorrentConfigFileManager

ABC_OKC_VERSION = '4.4.51'
#ABC_OKC_VERSION2 = ' test'
ABC_OKC_VERSION2 = ''
ABC_OKC_BUILD = '663'


class Lang:
    def __init__(self, parent, abcpath, filename = 'english.lang'):
        self.parent = parent
        self.translation = {}
        self.langwarning = False
        languagefile = os.path.join(abcpath, "lang", filename)
        # Special cases
        self.translation['version'] = ABC_OKC_VERSION
        self.translation['version2'] = ABC_OKC_VERSION2
        self.translation['build'] = 'build ' + ABC_OKC_BUILD
        if os.path.exists(languagefile):
            tcfm = TorrentConfigFileManager(languagefile, self.translation, enclosingquotes = True)
            tcfm.readAllConfig()
        else:
            messageframe = wx.Frame(None, -1, '')
            dlg = wx.MessageDialog(messageframe, 'The language file ' + languagefile + ' could not be found',
                                   'Error', wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            messageframe.Destroy()

    def get(self, label, warning = True):
        trans = self.translation.get(label)
        if trans is None:
            if self.translation.has_key(label + "_line1"):
                return self.getMultiline(label)
            if warning:
                self.error(label)
                return ""
        return trans

    def getMultiline(self, label):
        text = self.translation.get(label + "_line1")
        linelabel = label + "_line2"
        i = 2
        while self.translation.has_key(linelabel):
            text += "\n" + self.translation[linelabel]
            i += 1
            linelabel = label + "_line" + str(i)
        return text

    def error(self, label):
        # Display a warning once that the language file doesn't contain all the values
        if not self.langwarning:
            self.langwarning = True
            error_title = self.get('error')
            error_text = self.get('errorlanguagefile')
            if error_text == "":
                error_text = "Your language file is missing at least one string.\nPlease check to see if an updated version is available."
            messageframe = None
            if hasattr(self.parent, 'frame'):
                dlgparent = self.parent.frame
            else:
                dlgparent = messageframe = wx.Frame(None, -1, '')
            dlg = wx.MessageDialog(dlgparent, error_text, error_title, wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            if messageframe:
                messageframe.Destroy()
        sys.stderr.write("\nError reading language file !\n")
        sys.stderr.write("  Cannot find value for variable : " + label + "\n")
