# Copyright 2002-2003 Andrew Loewenstern, All Rights Reserved
# See khashmir.py for license information
# Updated and modified for ABC_OKC : Old King Cole

import khash
from time import clock
from types import *


class Node:
    """
        encapsulate contact info
    """
    def __init__(self):
        self.fails = 0
        self.lastSeen = 0
        self.id = self.host = self.port = ''
        self.pinging = False

    def init(self, id, host, port):
        self.id = id
        self.num = khash.intify(id)
        self.host = host
        self.port = port
        return self

    def updateLastSeen(self):
        self.lastSeen = clock()
        self.fails = 0

    def msgFailed(self):
        self.fails += 1
        return self.fails

    def __repr__(self):
        return `(self.id, self.host, self.port)`

    # these comparators let us bisect/index a list full of nodes with either a node or an int/long
    def __lt__(self, a):
        if type(a) == InstanceType:
            a = a.num
        return self.num < a

    def __le__(self, a):
        if type(a) == InstanceType:
            a = a.num
        return self.num <= a

    def __gt__(self, a):
        if type(a) == InstanceType:
            a = a.num
        return self.num > a

    def __ge__(self, a):
        if type(a) == InstanceType:
            a = a.num
        return self.num >= a

    def __eq__(self, a):
        if type(a) == InstanceType:
            a = a.num
        return self.num == a

    def __ne__(self, a):
        if type(a) == InstanceType:
            a = a.num
        return self.num != a
