## Copyright 2002-2003 Andrew Loewenstern, All Rights Reserved
# see LICENSE.txt for license information
# Updated and modified for ABC_OKC : Old King Cole

# magic id to use before we know a peer's id
NULL_ID =  20 * '\0'

# Kademlia "K" constant, this should be an even number
K = 8

# SHA1 is 160 bits long
HASH_LENGTH = 160

# checkpoint every this many seconds
CHECKPOINT_INTERVAL = 60 * 15 # 15 minutes

### SEARCHING/STORING
# concurrent xmlrpc calls per find node/value request!
CONCURRENT_REQS = 4

# how many hosts to post to
STORE_REDUNDANCY = 3

###  ROUTING TABLE STUFF
# how many times in a row a node can fail to respond before it's booted from the routing table
MAX_FAILURES = 3

# never ping a node more often than this
MIN_PING_INTERVAL = 60 * 15 # 15 minutes

# refresh buckets that haven't been touched in this long
BUCKET_STALENESS = 60 * 60 # 1 hour

# number of peers to return
NUM_PEERS = 50

###  TOKEN EXPIRER
# time between token expirer runs
TOKEN_DELAY = 60 * 5 # 5 minutes

# expire token entries older than this
TOKEN_AGE = 60 * 10 # 10 minutes

###  TOKEN SECRET RENEWER
# token secret renewal period
SECRET_RENEW = 60 * 5 # 5 minutes

###  KEY EXPIRER
# time before key expirer starts running
KE_INITIAL_DELAY = 15 # 15 seconds - to clean out old stuff in persistent db

# time between key expirer runs
KE_DELAY = 60 * 20 # 20 minutes

# expire key entries older than this
KE_AGE = 60 * 60 # 60 minutes

### KRPC
# Timeout
KRPC_TIMEOUT = 10

###  KRPC CONNECTIONS EXPIRER
# time between key expirer runs
KRPC_DELAY = KRPC_TIMEOUT * 2

# expire key entries older than this
KRPC_AGE = KRPC_TIMEOUT * 2
