##############################################################################
# Module : interconn.py
# Author :
# Date   :
# Updated and modified for ABC_OKC : Old King Cole
#
# Description : Communication between ABC_OKC and ABC_OKC starter
#
##############################################################################
import wx, sys, socket, win32con
from os.path import dirname, basename, join
from shutil import copy

from win32api import RegCreateKey, RegSetValueEx, RegCloseKey

from BitTornado.utility import sysencoding


###################################################################################################
# ServerListener Class :
#    Single instance opens local port for taking parameter from starter
###################################################################################################
class ServerListener:
    def __init__(self, ip = '127.0.0.1'):
        self.s = None
        self.ip = ip

    def start(self, parent):
        self.parent = parent
        for res in socket.getaddrinfo(self.ip, self.parent.utility.mainport, socket.AF_UNSPEC, socket.SOCK_STREAM, 0, socket.AI_PASSIVE):
            af, socktype, proto, canonname, sa = res
            try:
                self.s = socket.socket(af, socktype, proto)
            except socket.error, msg:
                self.s = None
                continue
            try:
                self.s.bind(sa)
                self.s.listen(1)
            except socket.error, msg:
                self.s.close()
                self.s = None
                continue
            break
        if self.s is None:
            print 'could not open socket'
            sys.exit(1)
        while True:
            try:
                conn, addr = self.s.accept()
                data = conn.recv(8191)
                conn.close()
                try:
                    params = data.decode('utf-8').split("|")
                except:
                    continue
                if params[0] == "Please close connection!!":
                    self.s.close()
                    self.s = None
                    break
                if params == [u'']:
                    # No parameters
                    self.parent.parent.onTaskBarActivate()
                elif len(params) == 1:
                    # Accept only 1 non empty parameter as the torrent to be added
                    params.insert(0, '-a')
                    self.parent.queue.invokeLater(self.parent.commandLineAddTorrent, [params, 0])
                else:
                    try:
                        a = params.index('-a')
                    except:
                        a = -1
                    try:
                        m = params.index('-m')
                    except:
                        pass
                    else:
                        if a == -1 or m < a:
                            self.parent.queue.invokeLater(self.parent.commandLineMode, [params, m])
                    if a >= 0:
                        self.parent.queue.invokeLater(self.parent.commandLineAddTorrent, [params, a])
                    try:
                        c = params.index('-c')
                    except:
                        pass
                    else:
                        if a == -1 or c < a:
                            self.parent.queue.invokeLater(self.parent.commandLineCommand, [params, c])
            except wx.PyDeadObjectError:
                sys.stderr.write("\nPlease wait until ABC finishes shutting down and retry\n")
                break


###################################################################################################
# clientPassParam :
#    ABC_OKC starter passes parameter to ABC_OKC single instance and closes immediately
###################################################################################################
def clientPassParam(arg, ip = None, port = None):
    params = arg[1:]
    shared = None
    addoptions = ''
    try:
        a = params.index('-a')
    except:
        a = -1
    if port is None:
        try:
            p = params.index('-p')
        except:
            port = 56666
        else:
            if a == -1 or p < a:
                try:
                    port = int(params[p + 1])
                except:
                    port = 56666
                else:
                    if port < 0 or port > 65535:
                        port = 56666
    if ip is None:
        if len(params) > 1:
            try:
                r = params.index('-r')
            except:
                r = -1
            if a == -1 or r < a:
                if r != -1:
                    try:
                        ip = params[r + 1]
                    except:
                        pass
                if ip is None:
                    try:
                        ra = params.index('-ra')
                    except:
                        ip = '127.0.0.1'
                    else:
                        if a == -1 or ra < a:
                            try:
                                ip = params[ra + 1]
                            except:
                                ip = '127.0.0.1'
                            else:
                                try:
                                    s = params.index('-s')
                                except:
                                    sys.exit(1)
                                else:
                                    if a == -1 or s < a:
                                        try:
                                            shared = params[s + 1]
                                        except:
                                            sys.exit(1)
                                        try:
                                            o = params.index('-o')
                                        except:
                                            pass
                                        else:
                                            if a == -1 or o < a:
                                                try:
                                                    addoptions = params[o + 1]
                                                except:
                                                    pass
                                        torAssociateToRemote(ip, port, shared, addoptions, dirname(arg[0]))
                                    else:
                                        sys.exit(1)
                        else:
                            ip = '127.0.0.1'
            else:
                ip = '127.0.0.1'
        else:
            # If there's only one parameter it is assumed to be a torrent (as if -a was prefixed) 
            ip = '127.0.0.1'

    if ip != '127.0.0.1' and a != -1:
        # Remote command
        if len(params) < a + 2:
            sys.exit(1)
        if shared is None:
            try:
                s = params.index('-s')
            except:
                pass
            else:
                if s < a:
                    try:
                        shared = params[s + 1]
                    except:
                        pass
        i = 1
        for source in params[a + 1:]:
            if not source.lower().startswith(('magnet:', 'http:', 'https:')):
                if shared is None:
                    del params[a + i]
                else:
                    # Copy torrent file to remote
                    dest = '\\\\' + ip + '\\' + shared
                    try:
                        copy(source, dest)
                    except:
                        del params[a + i]
                    else:
                        # Update torrent file location in parameters
                        params[a + i] = join(dest, basename(source))
            i += 1

    try:
        reslist = socket.getaddrinfo(ip, port, socket.AF_UNSPEC, socket.SOCK_STREAM)
    except:
        pass
    s = None
    for res in reslist:
        af, socktype, proto, canonname, sa = res
        try:
            s = socket.socket(af, socktype, proto)
        except socket.error, msg:
            s = None
            continue
        try:
            s.connect(sa)
        except socket.error, msg:
            s.close()
            s = None
            continue
        break
    if s is None:
        print 'Could not open socket'
        sys.exit(1)

    s.send('|'.join(params).encode('utf-8'))
    s.close()

def torAssociateToRemote(ip, port, shared, addoptions, abcpath):
    if port == 56666:
        commandlinemainport = ''
    else:
        commandlinemainport = ' -p ' + str(port)
    commandlineremoteip = ' -r ' + ip
    commandlineshared = ' -s ' + shared
    if addoptions:
        commandlineaddoption = ' -o ' + addoptions
    else:
        commandlineaddoption = ''
    # Associate .torrent files with ABC_OKC
    key = RegCreateKey(win32con.HKEY_CURRENT_USER, 'Software\\Classes\\.torrent')
    RegSetValueEx(key, '', 0, win32con.REG_SZ, 'bittorrent')
    RegSetValueEx(key, 'Content Type', 0, win32con.REG_SZ, 'application/x-bittorrent')
    RegCloseKey(key)
    key = RegCreateKey(win32con.HKEY_CURRENT_USER, 'Software\\Classes\\bittorrent')
    RegSetValueEx(key, '', 0, win32con.REG_SZ, 'TORRENT File')
    RegSetValueEx(key, 'DefaultIcon', 0, win32con.REG_SZ, join(abcpath.encode(sysencoding), 'torrenticon.ico'))
    RegSetValueEx(key, 'EditFlags', 0, win32con.REG_BINARY, '\x00\x00\x01\x00')
    RegCloseKey(key)
    key = RegCreateKey(win32con.HKEY_CURRENT_USER, 'Software\\Classes\\bittorrent\\shell')
    RegSetValueEx(key, '', 0, win32con.REG_SZ, 'open')
    RegCloseKey(key)
    key = RegCreateKey(win32con.HKEY_CURRENT_USER, 'Software\\Classes\\bittorrent\\shell\\open\\command')
    RegSetValueEx(key, '', 0, win32con.REG_SZ, '"' + join(abcpath.encode(sysencoding), 'abc.exe') + '"'
                  + commandlineremoteip + commandlinemainport + commandlineshared + commandlineaddoption + ' -a "%1"')
    RegCloseKey(key)
    # Associate magnet protocol with ABC_OKC
    key = RegCreateKey(win32con.HKEY_CURRENT_USER, 'Software\\Classes\\magnet')
    RegSetValueEx(key, '', 0, win32con.REG_SZ, 'URL:Magnet Protocol')
    RegSetValueEx(key, 'URL Protocol', 0, win32con.REG_SZ, '')
    RegCloseKey(key)
    key = RegCreateKey(win32con.HKEY_CURRENT_USER, 'Software\\Classes\\magnet\\DefaultIcon')
    RegSetValueEx(key, '', 0, win32con.REG_SZ, join(abcpath.encode(sysencoding), 'torrenticon.ico'))
    RegCloseKey(key)
    key = RegCreateKey(win32con.HKEY_CURRENT_USER, 'Software\\Classes\\magnet\\shell\\open\\command')
    RegSetValueEx(key, '', 0, win32con.REG_SZ, '"' + join(abcpath.encode(sysencoding), 'abc.exe') + '"'
                  + commandlineremoteip + commandlinemainport + commandlineshared + commandlineaddoption + ' -a "%1"')
    RegCloseKey(key)
