##############################################################################
# Module : guimanager.py
# Author :
# Date   :
# Updated and modified for ABC_OKC : Old King Cole
#
# Description : GUI manager
#
##############################################################################
import sys
from os import path, remove, rename

from BitTornado.utility import sysencoding


class GUIManager:
    def __init__(self, datapath):
        self.maxid = 29
        self.datapath = datapath
        # Read abc.ini
        nbparam = self.readIni()
        if nbparam < self.maxid:
            # Old format
            ini = open(path.join(self.datapath, "abc.ini"), "ab")
            if nbparam == 22:
                self.configdata.append([22, -1, "Stop", 71, "Stop seeding condition", 0, 0])
                ini.writelines("22|-1|Stop|71|Stop seeding condition|0|0\n")
            if nbparam == 22 or nbparam == 23:
                self.configdata.append([23, -1, "Lab", 50, "Short label", 0, 0])
                ini.writelines("23|-1|Lab|50|Short label|0|0\n")
                self.configdata.append([24, -1, "Label", 50, "Label (template name)", 0, 0])
                ini.writelines("24|-1|Label|50|Label (template name)|0|0\n")
            if nbparam == 22 or nbparam == 23 or nbparam == 25:
                self.configdata.append([25, -1, "A", 16, "Activity", 0, 0])
                ini.writelines("25|-1|A|16|Activity|0|0\n")
            if nbparam == 22 or nbparam == 23 or nbparam == 25 or nbparam == 26:
                self.configdata.append([26, -1, "Destination", 300, "Download destination", 0, 0])
                ini.writelines("26|-1|Destination|300|Download destination|0|0\n")
            if nbparam == 22 or nbparam == 23 or nbparam == 25 or nbparam == 26 or nbparam == 27:
                self.configdata.append([27, -1, "Seeding time", 56, "Seeding time", 0, 0])
                ini.writelines("27|-1|Seeding time|56|Seeding time|0|0\n")
                self.configdata.append([28, -1, "Total seeding", 56, "Total seeding time", 0, 0])
                ini.writelines("28|-1|Total seeding|56|Total seeding time|0|0\n")
            ini.close()

        self.arrangeRank()

    def reloadIni(self):
        self.readIni()
        self.arrangeRank()

    def readIni(self):
        self.configdata = []
        self.numcol = 0
        nbparam = 0
        oldformat = False
        ini = open(path.join(self.datapath, "abc.ini"), "r")
        firstline = True
        while True:
            iniline = ini.readline()
            if iniline == "" or iniline == "\n":
                break
            if firstline:
                if iniline[:3] == '\xef\xbb\xbf':
                    self.encoding = 'utf_8'
                    # Skip BOM
                    iniline = iniline[3:]
                    if iniline == "" or iniline == "\n":
                        break
                else:
                    self.encoding = sysencoding
                firstline = False
            nbparam += 1
            iniarg = iniline.decode(self.encoding).split("|")
            if len(iniarg) == 4:
                self.configdata.append([int(iniarg[0]), int(iniarg[1]), iniarg[2], int(iniarg[3][:-1]), u"", 0, 0])
                oldformat = True
            elif len(iniarg) == 5:
                self.configdata.append([int(iniarg[0]), int(iniarg[1]), iniarg[2], int(iniarg[3]), iniarg[4][:-1], 0, 0])
                oldformat = True
            elif len(iniarg) == 7:
                self.configdata.append([int(iniarg[0]), int(iniarg[1]), iniarg[2], int(iniarg[3]), iniarg[4], int(iniarg[5]), int(iniarg[6][:-1])])
            if int(iniarg[1]) != -1:
                self.numcol += 1
        ini.close()
        if oldformat:
            # New format to store main window, metainfo window and detail window width and height
            self.configdata[0][2] = self.configdata[0][3]
            self.configdata[0][3] = self.configdata[1][3]
            self.configdata[1][2] = 0
            self.configdata[1][3] = 0
            self.configdata[2][2] = self.configdata[2][3]
            self.configdata[2][3] = self.configdata[3][3]
            self.configdata[3][2] = 0
            self.configdata[3][3] = 0
            filename = path.join(self.datapath, "abc.ini")
            try:
                ini = open(filename + '.part', "w")
                ini.writelines('\xef\xbb\xbf')
                for i in xrange(nbparam):
                    if i < 4:
                        val1 = str(self.configdata[i][2])
                    else:
                        val1 = self.configdata[i][2]
                    ini.writelines((str(self.configdata[i][0]) + "|" + str(self.configdata[i][1]) + "|" + val1 + "|"
                                   + str(self.configdata[i][3]) + "|" + self.configdata[i][4] + "|" + str(self.configdata[i][5]) + "|"
                                   + str(self.configdata[i][6]) + "\n").encode('utf_8'))
            except:
                try:
                    ini.close()
                except:
                    pass
            else:
                ini.close()
                try:
                    remove(filename)
                except:
                    pass
                rename(filename + '.part', filename)
        else:
            for i in xrange(4):
                self.configdata[i][2] = int(self.configdata[i][2])
        return nbparam

    def writeIni(self):
        filename = path.join(self.datapath, "abc.ini")
        try:
            ini = open(filename + '.part', "w")
            ini.writelines('\xef\xbb\xbf')
            for i in xrange(self.maxid):
                if i < 4:
                    val1 = str(self.configdata[i][2])
                else:
                    val1 = self.configdata[i][2]
                ini.writelines((str(self.configdata[i][0]) + "|" + str(self.configdata[i][1]) + "|" + val1 + "|"
                                + str(self.configdata[i][3]) + "|" + self.configdata[i][4] + "|" + str(self.configdata[i][5]) + "|"
                                + str(self.configdata[i][6]) + "\n").encode('utf_8'))
        except:
            try:
                ini.close()
            except:
                pass
        else:
            ini.close()
            try:
                remove(filename)
            except:
                pass
            rename(filename + '.part', filename)

    def arrangeRank(self):
        self.colid = self.numcol * [0]

        for i in xrange(self.maxid):
            rank = self.configdata[i][1]
            if rank != -1:
                self.colid[rank] = self.configdata[i][0] #ID

    def getNumCol(self):
        return self.numcol

    def getRankfromID(self, id):
        return self.configdata[id][1]

    def getIDfromRank(self, rank):
        return self.colid[rank]
    
    def getText(self, id):
        return self.configdata[id][2]

    def getTextfromRank(self, rankid):
        return self.configdata[self.colid[rankid]][2]
    
    def getValue(self, id):
        return self.configdata[id][3]

    def setValue(self, id, val):
        self.configdata[id][3] = val

    def getValuefromRank(self, rankid):
        return self.configdata[self.colid[rankid]][3]

    def getMainWidth(self):
        return self.configdata[0][2]

    def setMainWidth(self, val):
        self.configdata[0][2] = val

    def getMainHeight(self):
        return self.configdata[0][3]

    def setMainHeight(self, val):
        self.configdata[0][3] = val

    def getMainSize(self):
        return (self.configdata[0][2], self.configdata[0][3])

    def getMetaWidth(self):
        return self.configdata[1][2]

    def setMetaWidth(self, val):
        self.configdata[1][2] = val

    def getMetaHeight(self):
        return self.configdata[1][3]

    def setMetaHeight(self, val):
        self.configdata[1][3] = val

    def getMetaSize(self):
        return (self.configdata[1][2], self.configdata[1][3])

    def getDetailWidth(self):
        return self.configdata[2][2]

    def setDetailWidth(self, val):
        self.configdata[2][2] = val

    def getDetailHeight(self):
        return self.configdata[2][3]

    def setDetailHeight(self, val):
        self.configdata[2][3] = val

    def getDetailSize(self):
        return (self.configdata[2][2], self.configdata[2][3])

    def getSortingOrder(self, id):
        return self.configdata[id][5]

    def getSortingLock(self, id):
        return self.configdata[id][6]
