##############################################################################
# Module : filemanager.py
# Author :
# Date   :
# Updated and modified for ABC_OKC : Old King Cole
#
# Description : Files manager
#
##############################################################################
import wx, sys
from os import path, remove, rename
from threading import Lock

from BitTornado.bencode import bdecode
from BitTornado.utility import sysencoding

LISTFILESEM = Lock()


class TorrentConfigFileManager:
    def __init__(self, filename, dic, enclosingquotes = False):
        self.filename = filename
        self.dic = dic
        self.enclosingquotes = enclosingquotes

    def readAllConfig(self):
        f = open(self.filename, "r")
        firstline = True
        while True:
            configline = f.readline()
            if firstline:
                firstline = False
                if configline[:3] == '\xef\xbb\xbf':
                    self.encoding = 'utf_8'
                    # Skip BOM
                    configline = configline[3:]
                else:
                    self.encoding = sysencoding
            if configline == "":
                break
            if configline == "\n" or configline[0] == '#':
                continue
            configmap = configline.decode(self.encoding).split("=", 1)
            if self.enclosingquotes:
                self.dic[configmap[0]] = configmap[1][1:-2].replace('\\n', '\n')
            else:
                self.dic[configmap[0]] = configmap[1][:-1].replace('\\n', '\n')
        f.close()

    def writeAllConfig(self):
        keys = self.dic.keys()
        keys.sort()
        try:
            f = open(self.filename + '.part', "w")
            f.writelines('\xef\xbb\xbf')
            for key in keys:
                f.writelines((key + "=" + self.dic[key] + "\n").encode('utf_8'))
        except:
            try:
                f.close()
            except:
                pass
        else:
            f.close()
            try:
                remove(self.filename)
            except:
                pass
            rename(self.filename + '.part', self.filename)


class TorrentListFileManager:
    def __init__(self, parent):
        self.parent = parent
        self.utility = parent.utility
        self.localize = self.utility.lang.get
        self.filename = path.join(self.utility.datapath, "torrent.lst")
        self.f = None
        self.version = None
        self.linenb = 0
        self.lastversion = '4.03.19'

    def open(self, mode = "r+"):
        LISTFILESEM.acquire()
        if not path.exists(self.filename):
            dlg = wx.MessageDialog(self.parent.parent, self.localize('notorrentlist'),
                                   self.localize('abcokcwarning'), wx.ICON_EXCLAMATION)
            dlg.ShowModal()
            dlg.Destroy()
            try:
                f = open(self.filename, "w")
                f.close()
            except:
                pass
        if mode[0] == 'w':
            filename = self.filename + '.part'
        else:
            filename = self.filename
        try:
            self.f = open(filename, mode)
        except:
            dlg = wx.MessageDialog(self.parent.parent, self.localize('notorrentlistaccess'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()

    def writeHeader(self):
        self.f.writelines('\xef\xbb\xbf' + self.lastversion.encode('utf_8') + '\n')

    def appendList(self, name, src, dest, status, prio, downsize, upsize, progress, maxupload, maxlocaluploadrate,
                   maxlocaldownloadrate, uploadopt, uploadtimeh, uploadtimem, uploadratio, seedingtime, totalseedingtime,
                   label, shortlabel, timeoutswitch, timeoutaction, timeoutwork, timeoutworkdown, timeoutworktrack, timeoutseed,
                   timeoutseedup, timeoutseedtrack, timeouttracker, timeoutdownload, timeoutupload, movefolder,
                   exttracker, exttrackerurl, termevt, magnetname, prioritizedown, prioritizeup, checkinttrackwait, extrainttracker,
                   inttrackerurl, inactivitytime, trackererrortime, sbtime, restoreindex, magnetprop):
        self.f.writelines((name + "|" + src + "|" + dest + "|" + status + "|" + str(prio) + "|" + str(downsize) + "|" + str(upsize)
                          + "|" + progress + "|" + str(maxupload) + "|" + str(maxlocaluploadrate) + "|" + str(uploadopt) + "|" + str(uploadtimeh)
                          + "|" + str(uploadtimem) + "|" + str(uploadratio) + "|" + str(seedingtime) + "|" + label + "|" + shortlabel
                          + "|" + str(timeoutswitch) + "|" + str(timeouttracker) + "|" + str(timeoutdownload) + "|" + str(timeoutupload)
                          + "|" + movefolder + "|" + str(maxlocaldownloadrate) + "|" + str(exttracker) + "|" + exttrackerurl
                          + "|" + str(timeoutwork) + "|" + str(timeoutworkdown) + "|" + str(timeoutworktrack)
                          + "|" + str(timeoutseed) + "|" + str(timeoutseedup) + "|" + str(timeoutseedtrack)
                          + "|" + unicode(termevt) + "|" + str(totalseedingtime) + "|" + str(timeoutaction) + "|" + magnetname
                          + "|" + str(prioritizedown) + "|" + str(prioritizeup) + "|" + str(checkinttrackwait) + "|" + str(extrainttracker)
                          + "|" + inttrackerurl + "|" + str(inactivitytime) + "|" + str(trackererrortime) + "|" + str(sbtime)
                          + "|" + "|".join(map(str, restoreindex)) + "|" + str(magnetprop) + "\n").encode('utf_8'))

    def readList(self):
        self.linenb += 1
        configline = self.f.readline()
        if self.linenb == 1:
            if configline[:3] == '\xef\xbb\xbf':
                self.encoding = 'utf_8'
                # Skip BOM
                configline = configline[3:]
            else:
                self.encoding = sysencoding
        if configline == "" or configline == "\n":
            return None
        configmap = configline.decode(self.encoding).split("|")
        size = len(configmap)
        if self.linenb == 1 and size == 1:
            # Header line
            self.version = configmap[0][:-1]
            # Read next line
            self.linenb += 1
            configline = self.f.readline()
            if configline == "" or configline == "\n":
                return None
            configmap = configline.decode(self.encoding).split("|")
            size = len(configmap)

        if self.version is None or self.version != self.lastversion:
            # Old file formats
            if size == 7:
                # The progress was not recorded set it to 0, or to 100% if the status is "completed"
                configmap[6] = configmap[6][:-1]
            if size == 8:
                configmap[7] = configmap[7][:-1]
            elif size == 7:
                if configmap[3] == self.localize('completed'):
                    configmap.append(u"100")
                else:
                    configmap.append(u"0")
            if size == 14:
                configmap[13] = configmap[13][:-1]
            elif size == 7 or size == 8:
                # The local upload settings were not recorded. Set them to global upload settings.
                # MaxUpload
                configmap.append(u"4")
                # MaxLocalUploadRate
                configmap.append(u"0")
                # UploadOpt
                configmap.append(u"0")
                # UploadTimeH
                configmap.append(u"0")
                # UploadTimeM
                configmap.append(u"30")
                # UploadRatio
                configmap.append(u"50")
            if size == 15:
                configmap[14] = configmap[14][:-1]
            elif size == 7 or size == 8 or size == 14:
                # SeedingTimeLeft
                configmap.append(u"1800")
            if size == 23:
                configmap[22] = configmap[22][:-1]
            elif size == 7 or size == 8 or size == 14 or size == 15:
                #Template name
                configmap.append(u'default')
                # shortlabel
                configmap.append(u'def')
                # timeoutswitch
                configmap.append(u'1')
                # timeouttracker
                configmap.append(u'60')
                # timeoutdownload
                configmap.append(u'60')
                # timeoutupload
                configmap.append(u'1')
                # movefolder
                configmap.append(u'')
                # activity
                configmap.append(u'1')
            if size == 25:
                configmap[24] = configmap[24][:-1]
            elif size == 7 or size == 8 or size == 14 or size == 15 or size == 23:
                # autoactivity
                configmap.append(u'0')
                # local download rate
                configmap.append(u'0')
            if size == 27 and self.version is None:
                configmap[26] = configmap[26][:-1]
            elif size == 7 or size == 8 or size == 14 or size == 15 or size == 23 or size == 25:
                # extracker
                configmap.append(u'0')
                # exttrackerurl
                configmap.append(u'')
            if size == 27 and self.version == '3.00.01':
                configmap[26] = configmap[26][:-1]
            elif size == 7 or size == 8 or size == 14 or size == 15 or size == 23 or size == 25 or (size == 27 and self.version is None):
                try:
                    metainfo_file = open(configmap[1], 'rb')
                    metainfo = bdecode(metainfo_file.read(), sloppy = 1)
                    metainfo_file.close()
                    info = metainfo['info']
                except:
                    try:
                        metainfo_file.close()
                    except:
                        pass
                    return configmap
                if not info.has_key('length'):
                    configmap[2] = path.join(configmap[2], configmap[0])
            if size == 33 and self.version == '3.00.02':
                configmap[32] = configmap[32][:-1]
            elif size == 7 or size == 8 or size == 14 or size == 15 or size == 23 or size == 25 or self.version == '3.00.01':
                # timeoutwork
                configmap.append(u'1')
                # timeoutworkdown
                configmap.append(u'1')
                # timeoutworktrack
                configmap.append(u'1')
                # timeoutseed
                configmap.append(u'1')
                # timeoutseedup
                configmap.append(u'1')
                # timeoutseedtrack
                configmap.append(u'1')
            if size == 34 and self.version == '3.03.01':
                configmap[33] = configmap[33][:-1]
            elif size == 7 or size == 8 or size == 14 or size == 15 or size == 23 or size == 25 or \
                 self.version == '3.00.01' or self.version == '3.00.02':
                # termevtmsg
                configmap.append(u'')
            if size == 34 and self.version == '3.06.01':
                configmap[33] = configmap[33][:-1]
            elif size == 7 or size == 8 or size == 14 or size == 15 or size == 23 or size == 25 or \
                 self.version == '3.00.01' or self.version == '3.00.02' or self.version == '3.03.01':
                # Cut off the path for torrents
                configmap[1] = path.split(configmap[1])[1]
            if size == 34 and self.version == '3.06.02':
                configmap[33] = configmap[33][:-1]
            elif size == 7 or size == 8 or size == 14 or size == 15 or size == 23 or size == 25 or \
                 self.version == '3.00.01' or self.version == '3.00.02' or self.version == '3.03.01' \
                 or self.version == '3.06.01':
                # seedingtime replaces seedingtimeleft
                if configmap[10] == '1':
                    configmap[14] = str(max(int(configmap[11]) * 3600 + int(configmap[12]) * 60 - int(configmap[14]), 0))
                else:
                    configmap[14] = '0'
            if size == 35 and self.version == '3.06.03':
                configmap[34] = configmap[34][:-1]
            elif size == 7 or size == 8 or size == 14 or size == 15 or size == 23 or size == 25 or \
                 self.version == '3.00.01' or self.version == '3.00.02' or self.version == '3.03.01' \
                 or self.version == '3.06.01' or self.version == '3.06.02':
                # Total seeding time
                configmap.append(configmap[14])
            if size == 35 and self.version == '3.06.04':
                configmap[34] = configmap[34][:-1]
            elif size == 7 or size == 8 or size == 14 or size == 15 or size == 23 or size == 25 or \
                 self.version == '3.00.01' or self.version == '3.00.02' or self.version == '3.03.01' \
                 or self.version == '3.06.01' or self.version == '3.06.02' or self.version == '3.06.03':
                # Change pause status to stop status
                if configmap[3] == 'pause':
                    configmap[3] = 'stop'
            if size == 33 and self.version == '3.06.05':
                configmap[32] = configmap[32][:-1]
            elif size == 7 or size == 8 or size == 14 or size == 15 or size == 23 or size == 25 or \
                 self.version == '3.00.01' or self.version == '3.00.02' or self.version == '3.03.01' \
                 or self.version == '3.06.01' or self.version == '3.06.02' or self.version == '3.06.03' \
                 or self.version == '3.06.04':
                # Don't use any more activity and autoactivity
                for i in xrange(22, 33):
                    configmap[i] = configmap[i + 2]
                del configmap[33:]
            if size == 34 and self.version == '3.07.01':
                configmap[33] = configmap[33][:-1]
            elif size == 7 or size == 8 or size == 14 or size == 15 or size == 23 or size == 25 or \
                 self.version == '3.00.01' or self.version == '3.00.02' or self.version == '3.03.01' \
                 or self.version == '3.06.01' or self.version == '3.06.02' or self.version == '3.06.03' \
                 or self.version == '3.06.04' or self.version == '3.06.05':
                # timeoutaction
                configmap.append(u'1')
            if size == 35 and self.version == '3.09.01':
                configmap[34] = configmap[34][:-1]
            elif size == 7 or size == 8 or size == 14 or size == 15 or size == 23 or size == 25 or \
                 self.version == '3.00.01' or self.version == '3.00.02' or self.version == '3.03.01' \
                 or self.version == '3.06.01' or self.version == '3.06.02' or self.version == '3.06.03' \
                 or self.version == '3.06.04' or self.version == '3.06.05' or self.version == '3.07.01':
                # magnetname
                configmap.append(u'')
            if size == 37 and self.version == '4.00.01':
                configmap[36] = configmap[36][:-1]
            elif size == 7 or size == 8 or size == 14 or size == 15 or size == 23 or size == 25 or \
                 self.version == '3.00.01' or self.version == '3.00.02' or self.version == '3.03.01' \
                 or self.version == '3.06.01' or self.version == '3.06.02' or self.version == '3.06.03' \
                 or self.version == '3.06.04' or self.version == '3.06.05' or self.version == '3.07.01' \
                 or self.version == '3.09.01':
                # prioritizedown
                configmap.append(u'0')
                # prioritizeup
                configmap.append(u'0')
            if size == 38 and self.version == '4.02.01':
                configmap[37] = configmap[37][:-1]
            elif size == 7 or size == 8 or size == 14 or size == 15 or size == 23 or size == 25 or \
                 self.version == '3.00.01' or self.version == '3.00.02' or self.version == '3.03.01' \
                 or self.version == '3.06.01' or self.version == '3.06.02' or self.version == '3.06.03' \
                 or self.version == '3.06.04' or self.version == '3.06.05' or self.version == '3.07.01' \
                 or self.version == '3.09.01' or self.version == '4.00.01':
                # checkinttrackwait
                configmap.append(u'0')
            if size == 40 and self.version == '4.02.02':
                configmap[39] = configmap[39][:-1]
            elif size == 7 or size == 8 or size == 14 or size == 15 or size == 23 or size == 25 or \
                 self.version == '3.00.01' or self.version == '3.00.02' or self.version == '3.03.01' \
                 or self.version == '3.06.01' or self.version == '3.06.02' or self.version == '3.06.03' \
                 or self.version == '3.06.04' or self.version == '3.06.05' or self.version == '3.07.01' \
                 or self.version == '3.09.01' or self.version == '4.00.01' or self.version == '4.02.01':
                # extrainttracker
                configmap.append(u'0')
                # inttrackerurl
                configmap.append(u'')
                # timeouts have no longer the 'oo' value ; this is converted into timeout on/off switching
                if configmap[18] == u'oo':
                    configmap[18] = u'60'
                    configmap[27] = u'0'
                    configmap[30] = u'0'
                if configmap[19] == u'oo':
                    configmap[19] = u'60'
                    configmap[26] = u'0'
                if configmap[20] == u'oo':
                    configmap[20] = u'60'
                    configmap[29] = u'0'
                else:
                    # timeout for upload is now in minutes and no longer in hours
                    configmap[20] = str(60 * int(configmap[20]))
            if size == 43 and self.version == '4.02.03':
                configmap[42] = configmap[42][:-1]
            elif size == 7 or size == 8 or size == 14 or size == 15 or size == 23 or size == 25 or \
                 self.version == '3.00.01' or self.version == '3.00.02' or self.version == '3.03.01' \
                 or self.version == '3.06.01' or self.version == '3.06.02' or self.version == '3.06.03' \
                 or self.version == '3.06.04' or self.version == '3.06.05' or self.version == '3.07.01' \
                 or self.version == '3.09.01' or self.version == '4.00.01' or self.version == '4.02.01' \
                 or self.version == '4.02.02':
                # inactivitytime
                configmap.append(u'0')
                # trackererrortime
                configmap.append(u'0')
                # sbtime
                configmap.append(u'0')
            if size == 53 and self.version == '4.02.04':
                configmap[52] = configmap[52][:-1]
            elif size == 7 or size == 8 or size == 14 or size == 15 or size == 23 or size == 25 or \
                 self.version == '3.00.01' or self.version == '3.00.02' or self.version == '3.03.01' \
                 or self.version == '3.06.01' or self.version == '3.06.02' or self.version == '3.06.03' \
                 or self.version == '3.06.04' or self.version == '3.06.05' or self.version == '3.07.01' \
                 or self.version == '3.09.01' or self.version == '4.00.01' or self.version == '4.02.01' \
                 or self.version == '4.02.02' or self.version == '4.02.03':
                # restoreindex
                configmap.extend(10 * [u'-1'])
            # 10 * onlygetmetadata + keepmagnetdest
            configmap.append(u'0')
        elif configmap:
            configmap[-1] = configmap[-1][:-1]
        return configmap
    
    def close(self):
        try:
            self.f.close()
        except:
            pass
        LISTFILESEM.release()


class TemplateListFileManager:
    def __init__(self, parent):
        self.parent = parent
        self.utility = parent.utility
        self.localize = self.utility.lang.get
        self.filename = path.join(self.utility.datapath, "template.lst")
        self.f = None
        self.oldformat = False
        self.version = None
        self.linenb = 0
        # self.lastversion = '4.02.02'
        # self.lastversion = '4.04.25'
        # self.lastversion = '4.04.30'
        # self.lastversion = '4.04.31'
        self.lastversion = '4.04.33'

    def open(self, mode = "r+"):
        if not path.exists(self.filename):
            dlg = wx.MessageDialog(self.parent.parent, self.localize('notemplatelist'),
                                   self.localize('abcokcwarning'), wx.ICON_EXCLAMATION)
            dlg.ShowModal()
            dlg.Destroy()
            try:
                self.f = open(self.filename, "w")
                self.f.close()
            except:
                pass
        if mode[0] == 'w':
            filename = self.filename + '.part'
        else:
            filename = self.filename
        try:
            self.f = open(filename, mode)
        except:
            dlg = wx.MessageDialog(self.parent.parent, self.localize('notemplatelistaccess'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()

    def writeHeader(self):
        self.f.writelines('\xef\xbb\xbf' + self.lastversion.encode('utf_8') + '\n')

    def readList(self):
        self.linenb += 1
        configline = self.f.readline()
        if self.linenb == 1:
            if configline[:3] == '\xef\xbb\xbf':
                self.encoding = 'utf_8'
                # Skip BOM
                configline = configline[3:]
            else:
                self.encoding = sysencoding
        if configline == "" or configline == "\n":
            return None
        configmap = configline.decode(self.encoding).split("|")
        size = len(configmap)
        if self.linenb == 1 and size == 1:
            # Header line
            self.version = configmap[0][:-1]
            # Read next line
            self.linenb += 1
            configline = self.f.readline()
            if configline == "" or configline == "\n":
                return None
            configmap = configline.decode(self.encoding).split("|")
            size = len(configmap)

        if self.version is None or self.version != self.lastversion:
            # Old file format
            self.oldformat = True
            if size == 20:
                configmap[19] = configmap[19][:-1]
            if size == 24:
                configmap[23] = configmap[23][:-1]
            elif size == 20:
                # autoactivity
                configmap.append(u"0")
                # tempdownloadswitch
                configmap.append(u"1")
                # maxdownrate
                configmap.append(u"0")
                # tempseedingswitch
                configmap.append(u"1")
            if size == 35:
                configmap[34] = configmap[34][:-1]
            elif size == 20 or size == 24:
                # hidden
                configmap.append(u'0')
                # ruletrigrank
                configmap.append(u'-1')
                # ruleactive
                configmap.append(u'0')
                # ruletracker
                configmap.append(u'')
                # ruletrackersw
                configmap.append(u'0')
                # ruletorrent
                configmap.append(u'')
                # ruletorrentsw
                configmap.append(u'0')
                # ruletorrentfile
                configmap.append(u'')
                # ruletorrentfilesw
                configmap.append(u'0')
                # rulereceived
                configmap.append(u'')
                # rulereceivedsw
                configmap.append(u'0')
            if size == 41 and self.version == '3.00.01':
                configmap[40] = configmap[40][:-1]
            elif size == 20 or size == 24 or size == 35:
                # timeoutwork
                configmap.append(u'1')
                # timeoutworkdown
                configmap.append(u'1')
                # timeoutworktrack
                configmap.append(u'1')
                # timeoutseed
                configmap.append(u'1')
                # timeoutseedup
                configmap.append(u'1')
                # timeoutseedtrack
                configmap.append(u'1')
            if size == 38 and self.version == '3.06.01':
                configmap[37] = configmap[37][:-1]
            elif size == 20 or size == 24 or size == 35 or self.version == '3.00.01':
                # Don't use any more tempactivityswitch, activity and autoactivity
                for i in xrange(18, 38):
                    configmap[i] = configmap[i + 3]
                del configmap[38:]
            if size == 39 and self.version == '3.07.01':
                configmap[38] = configmap[38][:-1]
            elif size == 20 or size == 24 or size == 35 or self.version == '3.00.01' or self.version == '3.06.01':
                # timeoutaction
                configmap.append(u'1')
            if size == 41 and self.version == '4.00.01':
                configmap[40] = configmap[40][:-1]
            elif size == 20 or size == 24 or size == 35 or self.version == '3.00.01' or self.version == '3.06.01' or self.version == '3.07.01':
                # prioritizedown
                configmap.append(u'0')
                # prioritizeup
                configmap.append(u'0')
            if size == 44 and self.version == '4.01.01':
                configmap[43] = configmap[43][:-1]
            elif size == 20 or size == 24 or size == 35 or self.version == '3.00.01' or self.version == '3.06.01' or self.version == '3.07.01' \
                  or self.version == '4.00.01':
                # temptrackerswitch
                if configmap[0] == self.utility.abcparams['templatedefault']:
                    configmap.append(u'1')
                else:
                    configmap.append(u'0')
                # exttracker
                configmap.append(u'0')
                # exttrackerurl
                configmap.append(u'')
            if size == 45 and self.version == '4.02.01':
                configmap[44] = configmap[44][:-1]
            elif size == 20 or size == 24 or size == 35 or self.version == '3.00.01' or self.version == '3.06.01' or self.version == '3.07.01' \
                  or self.version == '4.00.01' or self.version == '4.01.01':
                # checkinttrackwait
                configmap.append(u'0')
            if size == 47 and self.version == '4.02.02':
                configmap[46] = configmap[46][:-1]
            elif size == 20 or size == 24 or size == 35 or self.version == '3.00.01' or self.version == '3.06.01' or self.version == '3.07.01' \
                  or self.version == '4.00.01' or self.version == '4.01.01' or self.version == '4.02.01':
                # extrainttracker
                configmap.append(u'0')
                # inttrackerurl
                configmap.append(u'')
                # timeouts have no longer the 'oo' value ; this is converted into timeout on/off switching
                if configmap[13] == 'oo':
                    configmap[13] = '60'
                    configmap[34] = '0'
                    configmap[37] = '0'
                if configmap[14] == 'oo':
                    configmap[14] = '60'
                    configmap[33] = '0'
                if configmap[15] == 'oo':
                    configmap[15] = '60'
                    configmap[36] = '0'
                else:
                    # timeout for upload is now in minutes and no longer in hours
                    configmap[15] = str(60 * int(configmap[15]))
            if size == 49 and self.version == '4.04.25':
                configmap[48] = configmap[48][:-1]
            elif size == 20 or size == 24 or size == 35 or self.version == '3.00.01' or self.version == '3.06.01' or self.version == '3.07.01' \
                  or self.version == '4.00.01' or self.version == '4.01.01' or self.version == '4.02.01' or self.version == '4.02.02':
                # defaultdownlocswitch
                if configmap[0] == self.utility.abcparams['templatedefault']:
                    configmap.append(u"1")
                else:
                    configmap.append(u"0")
                # defaultdownloc
                configmap.append(u"")
            if size == 51 and self.version == '4.04.30':
                configmap[50] = configmap[50][:-1]
            elif size == 20 or size == 24 or size == 35 or self.version == '3.00.01' or self.version == '3.06.01' or self.version == '3.07.01' \
                  or self.version == '4.00.01' or self.version == '4.01.01' or self.version == '4.02.01' or self.version == '4.02.02' \
                  or self.version == '4.04.25':
                # Global file size rule (>=)
                configmap.append(u"")
                # Global file size rule (<=)
                configmap.append(u"")
            if size == 52 and self.version == '4.04.31':
                configmap[51] = configmap[51][:-1]
            elif size == 20 or size == 24 or size == 35 or self.version == '3.00.01' or self.version == '3.06.01' or self.version == '3.07.01' \
                  or self.version == '4.00.01' or self.version == '4.01.01' or self.version == '4.02.01' or self.version == '4.02.02' \
                  or self.version == '4.04.25' or self.version == '4.04.30':
                # linkable
                configmap.append(u"0")
            # sticky
            configmap.append(u"0")
        elif configmap:
            configmap[-1] = configmap[-1][:-1]
        return configmap

    def writeList(self, tempdic, tempbyindex, tempbytrigrank):
        self.writeHeader()
        for key in tempbyindex:
            temp = tempdic[key]
            self.f.writelines((key + "|" +
                              temp.description + "|" +
                              str(temp.templabelswitch) + "|" +
                              temp.shortlabel + "|" +
                              str(temp.tempuploadswitch) + "|" +
                              str(temp.maxupload) + "|" +
                              str(temp.maxuprate) + "|" +
                              str(10 * int(temp.uploadtillcopycomplete) + temp.uploadoption) + "|" +
                              str(temp.uploadtimeh) + "|" +
                              str(temp.uploadtimem) + "|" +
                              str(temp.uploadratio) + "|" +
                              str(temp.temptimeoutswitch) + "|" +
                              str(temp.timeoutswitch) + "|" +
                              str(temp.timeouttracker) + "|" +
                              str(temp.timeoutdownload) + "|" +
                              str(temp.timeoutupload )+ "|" +
                              str(temp.tempmoveswitch) + "|" +
                              temp.movefolder + "|" +
                              str(temp.tempdownloadswitch) + "|" +
                              str(temp.maxdownrate) + "|" +
                              str(temp.tempseedingswitch) + "|" +
                              str(temp.hidden) + "|" +
                              str(tempbytrigrank.index(key)) + "|" +
                              str(temp.ruleactive) + "|" +
                              temp.ruletracker + "|" +
                              str(temp.ruletrackersw) + "|" +
                              temp.ruletorrent + "|" +
                              str(temp.ruletorrentsw) + "|" +
                              temp.ruletorrentfile + "|" +
                              str(temp.ruletorrentfilesw) + "|" +
                              temp.rulereceived + "|" +
                              str(temp.rulereceivedsw) + "|" +
                              str(temp.timeoutwork) + "|" +
                              str(temp.timeoutworkdown) + "|" +
                              str(temp.timeoutworktrack) + "|" +
                              str(temp.timeoutseed) + "|" +
                              str(temp.timeoutseedup) + "|" +
                              str(temp.timeoutseedtrack) + "|" +
                              str(temp.timeoutaction) + "|" +
                              str(temp.prioritizedown) + "|" +
                              str(temp.prioritizeup) + "|" +
                              str(temp.temptrackerswitch) + "|" +
                              str(temp.exttracker) + "|" +
                              temp.exttrackerurl + "|" +
                              str(temp.checkinttrackwait) + "|" +
                              str(temp.extrainttracker) + "|" +
                              temp.inttrackerurl + "|" +
                              str(temp.defaultdownlocswitch) + "|" +
                              temp.defaultdownloc + "|" +
                              temp.rulesizeg + "|" +
                              temp.rulesizel + "|" +
                              str(temp.linkable) + "|" +
                              str(temp.sticky) + "\n").encode('utf_8'))

    def close(self):
        try:
            self.f.close()
        except:
            pass


class ConLimiterListFileManager:
    def __init__(self, parent):
        self.parent = parent
        self.utility = parent.utility
        self.localize = self.utility.lang.get
        self.filename = path.join(self.utility.datapath, "conlimiter.lst")
        self.f = None
        self.oldformat = False
        self.version = None
        self.linenb = 0
        self.lastversion = '3.50.01'

    def open(self, mode = "r+"):
        if not path.exists(self.filename):
            dlg = wx.MessageDialog(self.parent.parent, self.localize('noconlimiterlist'),
                                   self.localize('abcokcwarning'), wx.ICON_EXCLAMATION)
            dlg.ShowModal()
            dlg.Destroy()
            try:
                self.f = open(self.filename, "w")
                self.f.close()
            except:
                pass
        if mode[0] == 'w':
            filename = self.filename + '.part'
        else:
            filename = self.filename
        try:
            self.f = open(filename, mode)
        except:
            dlg = wx.MessageDialog(self.parent.parent, self.localize('noconlimiterlistaccess'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()

    def writeHeader(self):
        self.f.writelines('\xef\xbb\xbf' + self.lastversion.encode('utf_8') + '\n')

    def readList(self):
        self.linenb += 1
        configline = self.f.readline()
        if self.linenb == 1:
            if configline[:3] == '\xef\xbb\xbf':
                self.encoding = 'utf_8'
                # Skip BOM
                configline = configline[3:]
            else:
                self.encoding = sysencoding
        if configline == "" or configline == "\n":
            return None
        configmap = configline.decode(self.encoding).split("|")
        size = len(configmap)
        if self.linenb == 1 and size == 1:
            # Header line
            self.version = configmap[0][:-1]
            # Read next line
            self.linenb += 1
            configline = self.f.readline()
            if configline == "" or configline == "\n":
                return None
            configmap = configline.decode(self.encoding).split("|")

        if configmap:
            configmap[-1] = configmap[-1][:-1]
        return configmap

    def writeList(self, conlimiterdic, conlimiterbyindex):
        self.writeHeader()
        for key in conlimiterbyindex:
            conlimiter = conlimiterdic[key]
            self.f.writelines((key + "|" +
                              '\x01'.join(conlimiter.templates) + "|" +
                              str(conlimiter.maxseeding) + "|" +
                              str(conlimiter.maxworking) + "|" +
                              str(conlimiter.maxoverall) + "\n").encode('utf_8'))

    def close(self):
        try:
            self.f.close()
        except:
            pass


class CommandListFileManager:
    def __init__(self, parent):
        self.parent = parent
        self.utility = parent.utility
        self.localize = self.utility.lang.get
        self.filename = path.join(self.utility.datapath, "command.lst")
        self.f = None
        self.oldformat = False
        self.version = None
        self.linenb = 0
        self.lastversion = '3.03.01'

    def open(self, mode = "r+"):
        if not path.exists(self.filename):
            dlg = wx.MessageDialog(self.parent.parent, self.localize('nocommandlist'),
                                   self.localize('abcokcwarning'), wx.ICON_EXCLAMATION)
            dlg.ShowModal()
            dlg.Destroy()
            try:
                self.f = open(self.filename, "w")
                self.f.close()
            except:
                pass
        if mode[0] == 'w':
            filename = self.filename + '.part'
        else:
            filename = self.filename
        try:
            self.f = open(filename, mode)
        except:
            dlg = wx.MessageDialog(self.parent.parent, self.localize('nocommandlistaccess'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()

    def writeHeader(self):
        self.f.writelines('\xef\xbb\xbf' + self.lastversion.encode('utf_8') + '\n')

    def readList(self):
        self.linenb += 1
        configline = self.f.readline()
        if self.linenb == 1:
            if configline[:3] == '\xef\xbb\xbf':
                self.encoding = 'utf_8'
                # Skip BOM
                configline = configline[3:]
            else:
                self.encoding = sysencoding
        if configline == "" or configline == "\n":
            return None
        configmap = configline.decode(self.encoding).split("|")
        size = len(configmap)
        if self.linenb == 1 and size == 1:
            # Header line
            self.version = configmap[0][:-1]
            # Read next line
            self.linenb += 1
            configline = self.f.readline()
            if configline == "" or configline == "\n":
                return None
            configmap = configline.decode(self.encoding).split("|")

        if configmap:
            configmap[-1] = configmap[-1][:-1]
        return configmap

    def writeList(self, schedcommand):
        self.writeHeader()
        for sc in schedcommand:
            self.f.writelines((sc.activity + "|" +
                              sc.frequency + "|" +
                              sc.weekschedule + "|" +
                              str(sc.schedtime) + "|" +
                              str(sc.enddate) + "|" +
                              sc.command + "|" +
                              sc.value + "\n").encode('utf_8'))

    def close(self):
        try:
            self.f.close()
        except:
            pass
