##############################################################################
# Module : conlimiter.py
# Author : Old King Cole
# Date   : 02/12/2007
#
# Description : Connections limiters
#
##############################################################################
from filemanager import ConLimiterListFileManager


##############################################################
# Class : ConLimiter
##############################################################
class ConLimiter:
    def __init__(self, limitedtemplates, maxseeding, maxworking, maxoverall):
        self.templates = limitedtemplates
        self.maxseeding = maxseeding
        self.maxworking = maxworking
        self.maxoverall = maxoverall
        # Counters for seeding and working torrents
        self.nbseeding = 0
        self.nbworking = 0
        # Number of locked completed torrents (prevented from seeding because maxseeding has been reached)
        self.nblockedcompleted = 0
        # Previous index in limiter list in limiter dialog (to restore unsorted order)
        self.previndex = 1000000000

    def resetCounters(self):
        self.nbseeding = 0
        self.nbworking = 0
        self.nboverall = 0


##############################################################
# Class : ConLimiterManager
##############################################################
class ConLimiterManager:
    def __init__(self, parent):
        self.parent = parent
        self.utility = parent.utility
        self.templates = parent.tempmanager.templates
        self.conlimiters = {}
        self.conlimitersbyindex = []
        parent.tempmanager.conlimiters = self.conlimiters
        conlimiterlistfile = ConLimiterListFileManager(self)
        conlimiterlistfile.open()
        while True:
            conlimiter = conlimiterlistfile.readList()
            if conlimiter is None:
                break
            if len(conlimiter) != 5:
                continue
            if conlimiter[1]:
                limitedtemplates = conlimiter[1].split('\x01')
            else:
                limitedtemplates = []
            self.conlimiters[conlimiter[0]] = ConLimiter(limitedtemplates, int(conlimiter[2]), int(conlimiter[3]), int(conlimiter[4]))
            # Update templates
            for temp in limitedtemplates:
                template = self.templates.get(temp)
                if template:
                    template.conlimiters.append(conlimiter[0])
                else:
                    # Should never happen
                    self.conlimiters[conlimiter[0]].templates.remove(temp)
            self.conlimitersbyindex.append(conlimiter[0])
        conlimiterlistfile.close()

    def createConLimiter(self, dico, conlimitersbyindex, name, default = None):
        if default == None:
            dico[name] = ConLimiter([], 0, 0, 0)
        else:
            deflimiter = dico[default]
            dico[name] = ConLimiter([], deflimiter.maxseeding, deflimiter.maxworking, deflimiter.maxoverall)
        conlimitersbyindex.append(name)

    def computeAllCounters(self):
        for limiter in self.conlimiters:
            self.conlimiters[limiter].resetCounters()
        for torrent in self.parent.window.queue.proctab:
            if torrent.abcengine and not torrent.abcengine.onlycheck:
                torrent.updateLimiters(1)

    def resetLockedCompletedCounters(self):
        # Reset number of locked completed torrents prevented from seeding for all limiters
        for limiter in self.conlimiters:
            self.conlimiters[limiter].nblockedcompleted = 0
