##############################################################################
# Module : commandline.py
# Author : Old King Cole
# Date   : 08/20/2007
#
# Description : Handles command line and process creation with unicode
#
##############################################################################
from sys import getwindowsversion

import win32api
from win32con import VER_PLATFORM_WIN32_NT
from ctypes import windll, c_char_p, c_wchar_p, c_void_p, c_ulong, c_int, c_ushort, c_uint, POINTER, byref, Structure, sizeof


def getCommandLine():
    # Workaround to get Unicode from command line
    GetCommandLineW = windll.kernel32.GetCommandLineW
    GetCommandLineW.restype = c_wchar_p
    cl = GetCommandLineW()
    winver = getwindowsversion()[3]
    arg = []
    if winver == VER_PLATFORM_WIN32_NT:
        CommandLineToArgvW = windll.shell32.CommandLineToArgvW
        CommandLineToArgvW.argtypes = [c_wchar_p, c_void_p]
        CommandLineToArgvW.restype = POINTER(c_wchar_p * 20)
        argc = c_int()
        argcarg = CommandLineToArgvW(cl, byref(argc))
        for i in xrange(argc.value):
            arg.append(argcarg.contents[i])
    else:
        # Simple command line parser for Windows 9x
        cllen = len(cl)
        i = 0
        beg = 0
        while i < cllen:
            while i < cllen and cl[i] != '"':
                i += 1
            if i != beg:
                arg.extend(cl[beg:i].split())
            if i == cllen:
                break
            i += 1
            beg = i
            while i < cllen and cl[i] != '"':
                i += 1
            arg.append(cl[beg:i])
            i += 1
            beg = i

    # As the command line is not the same if you start ABC with your Python interpreter
    # or after compilation, we make arg start with the first parameter containing "abc" ;
    # if not found (maybe abc.exe was renamed) start from parameter 0
    abcfound = False
    for i in xrange(len(arg)):
        if 'abc' in arg[i]:
            abcfound = True
            break
    if abcfound and i != 0:
        arg = arg[i:]

    return arg


WORD   = c_ushort
DWORD  = c_ulong
LPSTR  = c_char_p
LPBYTE = c_char_p
HANDLE = c_ulong
INVALID_HANDLE_VALUE = -1


class PROCESS_INFORMATION(Structure):
   _pack_   = 1
   _fields_ = [
       ('hProcess',    HANDLE),
       ('hThread',     HANDLE),
       ('dwProcessId', DWORD),
       ('dwThreadId',  DWORD),
   ]


class STARTUPINFO(Structure):
   _pack_   = 1
   _fields_ = [
       ('cb',              DWORD),
       ('lpReserved',      DWORD),     # LPSTR
       ('lpDesktop',       LPSTR),
       ('lpTitle',         LPSTR),
       ('dwX',             DWORD),
       ('dwY',             DWORD),
       ('dwXSize',         DWORD),
       ('dwYSize',         DWORD),
       ('dwXCountChars',   DWORD),
       ('dwYCountChars',   DWORD),
       ('dwFillAttribute', DWORD),
       ('dwFlags',         DWORD),
       ('wShowWindow',     WORD),
       ('cbReserved2',     WORD),
       ('lpReserved2',     DWORD),     # LPBYTE
       ('hStdInput',       DWORD),
       ('hStdOutput',      DWORD),
       ('hStdError',       DWORD),
   ]


def createProcess(commandline):
    si = STARTUPINFO()
    si.cb = sizeof(STARTUPINFO)
    si.lpReserved = 0
    si.lpDesktop = 0
    si.lpTitle = 0
    si.dwFlags = 0
    si.cbReserved2 = 0
    si.lpReserved2 = 0
    si.hStdInput = win32api.GetStdHandle(win32api.STD_INPUT_HANDLE)
    si.hStdOutput = win32api.GetStdHandle(win32api.STD_OUTPUT_HANDLE)
    si.hStdError = win32api.GetStdHandle(win32api.STD_ERROR_HANDLE)
    pi = PROCESS_INFORMATION() 
    pi.hProcess = INVALID_HANDLE_VALUE
    pi.hThread = INVALID_HANDLE_VALUE
    pi.dwProcessId = 0
    pi.dwThreadId = 0
    windll.kernel32.CreateProcessW(None, commandline, None, None, 0, 0, None, None, byref(si), byref(pi))
    return pi.dwProcessId
