#!/usr/bin/env python

# Written by Bram Cohen
# modified for multitracker by John Hoffman
# see LICENSE.txt for license information
# Updated and modified for ABC_OKC : Old King Cole

import sys, wx, re

from os import makedirs, remove, rename
from os.path import join, isdir, exists, basename
from threading import Event, Thread
from string import whitespace

from BitTornado.bencode import bdecode
from BitTornado.utility import exceptionArgsToString

from btcompletedir import completedir
from btmakemetafile import make_meta_file

wxEVT_INVOKE = wx.NewEventType()


def EVT_INVOKE(win, func):
    win.Connect(-1, -1, wxEVT_INVOKE, func)


class InvokeEvent(wx.PyEvent):
    def __init__(self, func, args, kwargs):
        wx.PyEvent.__init__(self)
        self.SetEventType(wxEVT_INVOKE)
        self.func = func
        self.args = args
        self.kwargs = kwargs


class AnnounceFile:
    def __init__(self, announceconf):
        self.announcelst = []
        self.piece_size = 0
        self.privatetorrent = 1
        self.addclosestdhtnodes = 1
        self.announcedefault = ""
        self.announceconf = announceconf

    def readConfig(self):        
        f = open(self.announceconf, 'r+')
        firstline = True
        while True:
            configline = f.readline()        
            if configline == "" or configline == "\n":
                break
            if firstline:
                if configline[:3] == '\xef\xbb\xbf':
                    self.encoding = 'utf_8'
                    # Skip BOM
                    configline = configline[3:]
                    if configline == '' or configline == "\n":
                        break
                else:
                    self.encoding = wx.GetDefaultPyEncoding()
                firstline = False
            configmap = configline.decode(self.encoding).split("=", 1)
            if configmap[0] == "piece_size":
                self.piece_size = int(configmap[1][:-1])
            elif configmap[0] == "private":
                self.privatetorrent = int(configmap[1][:-1])
            elif configmap[0] == "addclosestdhtnodes":
                self.addclosestdhtnodes = int(configmap[1][:-1])
            elif configmap[0] == "announce":
                self.announcelst.append(configmap[1][:-1])
            elif configmap[0] == "announcedefault":
                self.announcelst.append(configmap[1][:-1])
                self.announcedefault = configmap[1][:-1]
        f.close()
        return self.announcedefault, self.announcelst, self.piece_size, self.privatetorrent, self.addclosestdhtnodes

    def saveDefault(self, piece, private, addclosestdhtnodes, url):
        numslot = -1
        self.piece_size = piece
        self.privatetorrent = private
        self.addclosestdhtnodes = addclosestdhtnodes

        for i in xrange(len(self.announcelst)):
           if self.announcelst[i] == url:
               numslot = i
               break
        if numslot == -1:   # Current URL is bad
            if len(self.announcelst) != 0:
                self.announcedefault = self.announcelst[0]
        else:
            self.announcedefault = self.announcelst[numslot]

        try:
            f = open(self.announceconf + '.part', 'w+')
            f.writelines('\xef\xbb\xbf')
            f.writelines(("piece_size=" + str(piece) + "\n").encode('utf_8'))
            f.writelines(("private=" + str(private) + "\n").encode('utf_8'))
            f.writelines(("addclosestdhtnodes=" + str(addclosestdhtnodes) + "\n").encode('utf_8'))
            for announce in self.announcelst:
                if announce == self.announcedefault:
                    f.writelines(("announcedefault=" + self.announcedefault + "\n").encode('utf_8'))
                else:
                    f.writelines(("announce=" + announce + "\n").encode('utf_8'))
        except:
            try:
                f.close()
            except:
                pass
        else:
            f.close()
            try:
                remove(self.announceconf)
            except:
                pass
            rename(self.announceconf + '.part', self.announceconf)


class DownloadInfo(wx.Frame):
    def __init__(self, parent, ID, title):
        wx.Frame.__init__(self, parent, ID, title, style = wx.DEFAULT_FRAME_STYLE & ~ (wx.RESIZE_BORDER | wx.RESIZE_BOX | wx.MAXIMIZE_BOX))
        self.parent = parent
        self.SetAcceleratorTable(self.parent.accelerators)
        self.utility = self.parent.utility
        self.localize = self.utility.lang.get
        self.abcparams = self.parent.abcparams
        self.dht = self.parent.window.queue.dht
        self.completedir = None

        if sys.platform == 'win32':
            self.icon = wx.Icon(join(self.utility.abcpath, 'icon_abc.ico'), wx.BITMAP_TYPE_ICO)
            self.SetIcon(self.icon)

        # Read config file
        self.announceconf = AnnounceFile(join(self.utility.datapath, "announce.lst"))
        self.announcedefault, self.announcelst, self.piece_size, self.privatetorrent, self.addclosestdhtnodes = self.announceconf.readConfig()

        panel = wx.Panel(self, -1)

        outerbox = wx.BoxSizer(wx.VERTICAL)

        topbox = wx.FlexGridSizer(cols = 2, hgap = 0, vgap = 3)
        topbox.AddGrowableCol(1, 1)

        staticbox = wx.StaticBoxSizer(wx.StaticBox(panel, -1, ''), wx.VERTICAL)

        # Source for torrent
        topbox.Add(wx.StaticText(panel, -1, self.localize('source')), 0, wx.ALIGN_CENTER_VERTICAL)

        source_box = wx.BoxSizer(wx.HORIZONTAL)
        self.dirCtl = wx.TextCtrl(panel, -1, '')
        source_box.Add(self.dirCtl, 1, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        dirbtn = wx.Button(panel, -1, self.localize('dir'), size = (45, self.utility.buttonheight))
        wx.EVT_BUTTON(self, dirbtn.GetId(), self.selectDir)
        source_box.Add(dirbtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)

        filebtn = wx.Button(panel, -1, self.localize('fil'), size = (45, self.utility.buttonheight))
        wx.EVT_BUTTON(self, filebtn.GetId(), self.selectFile)
        source_box.Add(filebtn, 0, wx.ALIGN_CENTER_VERTICAL)

        topbox.Add(source_box, 0, wx.EXPAND)

        # Piece size and "make torrent for each file" checkbox
        topbox.Add(wx.StaticText(panel, -1, self.localize('piecesize')), 0, wx.ALIGN_CENTER_VERTICAL)

        pieceforeach_box = wx.BoxSizer(wx.HORIZONTAL)
        self.piece_length = wx.Choice(panel, -1,
                                      choices = [self.localize('automatic'),
                                      '16 ' + self.utility.mb,
                                      '8 ' + self.utility.mb,
                                      '4 ' + self.utility.mb,
                                      '2 ' + self.utility.mb,
                                      '1 ' + self.utility.mb,
                                      '512 ' + self.utility.kb,
                                      '256 ' + self.utility.kb,
                                      '128 ' + self.utility.kb,
                                      '64 ' + self.utility.kb,
                                      '32 ' + self.utility.kb,
                                      '16 ' + self.utility.kb])
        self.piece_length_list = [0, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14]
        self.piece_length.SetSelection(self.piece_size)
        pieceforeach_box.Add(self.piece_length, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        pieceforeach_box.Add((0, 0), 1)

        self.maketorforeachcheck = wx.CheckBox(panel, -1, self.localize('maketorforeach'))
        self.maketorforeachcheck.SetValue(self.abcparams['maketorforeach'] == "1")
        pieceforeach_box.Add(self.maketorforeachcheck, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 3)

        topbox.Add(pieceforeach_box, 0, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND)

        # Comment
        topbox.Add(wx.StaticText(panel, -1, self.localize('comment')), 0, wx.ALIGN_CENTER_VERTICAL)

        self.commentCtl = wx.TextCtrl(panel, -1, '', style = wx.TE_MULTILINE)
        topbox.Add(self.commentCtl, 1, wx.EXPAND | wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        staticbox.Add(topbox, 0, wx.EXPAND | wx.TOP, 3)

        self.privatecheck = wx.CheckBox(panel, -1, self.localize('privatetorrent'))
        self.privatecheck.SetValue(self.privatetorrent == 1)
 
        staticbox.Add(self.privatecheck, 0, wx.TOP, 3)

        announceurlsbox = wx.StaticBoxSizer(wx.StaticBox(panel, -1, self.localize('announceurls')), wx.VERTICAL)
        abutton = wx.Button(panel, -1, self.localize('copyannouncefromtorrent'),
                            size = (-1, self.utility.buttonheight), style = wx.BU_EXACTFIT)
        wx.EVT_BUTTON(self, abutton.GetId(), self.announceCopy)
        announceurlsbox.Add(abutton, 0, wx.ALIGN_RIGHT | wx.TOP, -20)

        # Announce url
        announceurl_box = wx.BoxSizer(wx.HORIZONTAL)
        announceurl_box.Add(wx.StaticText(panel, -1, self.localize('announceurl')), 0, wx.ALIGN_CENTER_VERTICAL)

        self.annctl = wx.ComboBox(panel, -1, self.announcedefault, choices = self.announcelst,
                                  style = wx.CB_DROPDOWN | wx.TE_PROCESS_ENTER)
        self.annctl.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.annctl.Bind(wx.EVT_TEXT_ENTER, self.onAddAnnounce)
        announceurl_box.Add(self.annctl, 1, wx.LEFT | wx.RIGHT | wx.ALIGN_CENTER_VERTICAL, 5)

        addremovebtn = wx.Button(panel, -1, self.localize('announcesavedel'), size = (-1, self.utility.buttonheight))
        wx.EVT_BUTTON(self, addremovebtn.GetId(), self.onAddRemoveAnnounce)
        announceurl_box.Add(addremovebtn, 0, wx.ALIGN_CENTER_VERTICAL)        

        announceurlsbox.Add(announceurl_box, 0, wx.EXPAND | wx.TOP, 5)

        # Announce List
        announceurlsbox.Add(wx.StaticText(panel, -1, self.localize('announcelist')), 0, wx.TOP, 3)

        self.annlistctl = wx.TextCtrl(panel, -1, '\n\n\n', style = wx.TE_MULTILINE | wx.HSCROLL | wx.TE_DONTWRAP)
        self.annlistctl.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        announceurlsbox.Add(self.annlistctl, 0, wx.EXPAND | wx.TOP, 3)

        announceurlsbox.Add(wx.StaticText(panel, -1, self.localize('multiannouncehelp')), 0, wx.EXPAND | wx.TOP, 3)

        staticbox.Add(announceurlsbox, 0, wx.EXPAND | wx.TOP, 3)

        # DHT nodes
        dhtnodesbox = wx.StaticBoxSizer(wx.StaticBox(panel, -1, self.localize('dhtnodes')), wx.VERTICAL)

        self.dhtnodeslistctl = wx.TextCtrl(panel, -1, '\n\n\n', style = wx.TE_MULTILINE | wx.HSCROLL | wx.TE_DONTWRAP)
        self.dhtnodeslistctl.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        dhtnodesbox.Add(self.dhtnodeslistctl, 0, wx.EXPAND | wx.TOP, 0)

        dhtnodesbox.Add(wx.StaticText(panel, -1, self.localize('dhtnodeshelp')), 0, wx.EXPAND | wx.TOP, 3)

        self.addclosestdhtnodescheck = wx.CheckBox(panel, -1, self.localize('addclosestdhtnodes'))
        self.addclosestdhtnodescheck.SetValue(self.addclosestdhtnodes == 1)

        dhtnodesbox.Add(self.addclosestdhtnodescheck, 0, wx.TOP, 3)

        staticbox.Add(dhtnodesbox, 0, wx.EXPAND | wx.TOP, 3)

        # Save torrent
        savetorrentbox = wx.StaticBoxSizer(wx.StaticBox(panel, -1, self.localize('savetor')), wx.VERTICAL)

        self.savetorrb1 = wx.RadioButton(panel, -1, self.localize('savetordefault'), (-1, -1), (-1, -1), wx.RB_GROUP)
        savetorrb2 = wx.RadioButton(panel, -1, self.localize('savetorsource'), (-1, -1), (-1, -1))
        savetorrb3 = wx.RadioButton(panel, -1, self.localize('savetorask'), (-1, -1), (-1, -1))
        self.savetor = [self.savetorrb1, savetorrb2, savetorrb3]

        savetordefbox = wx.BoxSizer(wx.HORIZONTAL)
        savetordefbox.Add(self.savetorrb1, 0, wx.ALIGN_CENTER_VERTICAL)
        self.savetordeftext = wx.TextCtrl(panel, -1, self.abcparams['savetordeffolder'])
        buttonlabel = self.localize('browse')
        buttonwidth = self.GetTextExtent(buttonlabel)[0] + 12
        buttonlabel = buttonlabel.replace('&', '&&')
        browsebtn = wx.Button(panel, -1, buttonlabel, wx.Point(-1, -1), wx.Size(buttonwidth, self.utility.buttonheight))
        browsebtn.Bind(wx.EVT_BUTTON, self.onBrowseDir)
        self.savetordeftext.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        savetordefbox.Add(self.savetordeftext, 1, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)
        savetordefbox.Add(browsebtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        savetorrentbox.Add(savetordefbox, 0, wx.EXPAND | wx.TOP, 0)

        savetorrentbox.Add(savetorrb2, 0)

        savetorrentbox.Add(savetorrb3, 0, wx.TOP, 4)
 
        self.savetor[int(self.abcparams['savetorrent'])].SetValue(True)

        staticbox.Add(savetorrentbox, 0, wx.EXPAND | wx.TOP, 3)

        outerbox.Add(staticbox, 0, wx.EXPAND | wx.TOP, -4)

        btnbox = wx.BoxSizer(wx.HORIZONTAL)
        self.maketorrentbtn = wx.Button(panel, -1, self.localize('maketorrent'))
        btnbox.Add(self.maketorrentbtn, 0, wx.ALL, 5)
        self.closebtn = wx.Button(panel, -1, self.localize('close'), size = (60, -1))
        btnbox.Add(self.closebtn, 0, wx.ALL, 5)
        outerbox.Add(btnbox, 0, wx.ALIGN_CENTER)

        wx.EVT_BUTTON(self, self.maketorrentbtn.GetId(), self.makeTorrent)
        wx.EVT_BUTTON(self, self.closebtn.GetId(), self.closeWin)
        wx.EVT_CLOSE(self, self.closeWin)

        panel.SetSizer(outerbox)
        panel.SetAutoLayout(True)
        panel.Fit()
        self.SetClientSize(panel.GetSize())

        dirbtnpos = dirbtn.GetPositionTuple()
        dirbtnsize = dirbtn.GetSizeTuple()
        wx.StaticLine(panel, -1, (dirbtnpos[0] + dirbtnsize[0] / 2, dirbtnpos[1] + dirbtnsize[1]), (-1, 6), wx.LI_VERTICAL)
        self.utility.frameWindow(self.maketorforeachcheck, xl = 1, xb = 1)

        if self.abcparams['createtorrentdlgx'] != '-1':
            self.x = int(self.abcparams['createtorrentdlgx'])
            self.y = int(self.abcparams['createtorrentdlgy'])
            self.MoveXY(self.x, self.y)
        else:
            self.x, self.y = self.GetPositionTuple()

        self.Bind(wx.EVT_MOVE, self.onMove)

#        panel.DragAcceptFiles(True)
#        wx.EVT_DROP_FILES(panel, self.selectDrop)

    def onMove(self, event):
        if not self.IsIconized():
            self.x, self.y = self.GetPositionTuple()
        event.Skip()

    def closeWin(self, event = None):
        # Save saving options
        self.abcparams['savetordeffolder'] = self.savetordeftext.GetValue().rstrip(whitespace + '.')
        for i in xrange(3):
            if self.savetor[i].GetValue():
                self.abcparams['savetorrent'] = str(i)
                break
        # Save piece size + private + announces
        self.announceconf.saveDefault(self.piece_length.GetSelection(), int(self.privatecheck.GetValue()), int(self.addclosestdhtnodescheck.GetValue()), self.annctl.GetValue().rstrip())
        # Save "torrent for each" option
        self.abcparams['maketorforeach'] = str(int(self.maketorforeachcheck.GetValue()))

        self.abcparams['createtorrentdlgx'], self.abcparams['createtorrentdlgy'] = str(self.x), str(self.y)
        self.parent.maketorrent = None
        if self.completedir and self.completedir.frame:
            self.completedir.done()
        self.Destroy()

    def onAddAnnounce(self, event):
        item = self.annctl.GetValue().rstrip()
        if item and not item in self.announcelst:
            self.announcelst.append(item)
            self.annctl.Append(item)
            self.announcedefault = item
            self.annctl.SetFocus()

    def onAddRemoveAnnounce(self, event):
        item = self.annctl.GetValue().rstrip()
        if item in self.announcelst:
            self.announcelst.remove(item)
            self.annctl.Delete(self.annctl.FindString(item))
            if self.announcedefault == item:
                if self.announcelst:
                    self.announcedefault = self.announcelst[0]
                else:
                    self.announcedefault = ''
            if self.announcelst:
                self.annctl.SetValue(self.announcelst[0])
            else:
                self.annctl.SetValue("")
        else:
            self.announcelst.append(item)
            self.annctl.Append(item)
            self.announcedefault = item
        self.annctl.SetFocus()

    def selectDir(self, event):
        dl = wx.DirDialog(self, self.localize('choosedirtouse'), style = wx.DD_DEFAULT_STYLE | wx.DD_NEW_DIR_BUTTON)
        result = dl.ShowModal()
        if result != wx.ID_OK:
            dl.Destroy()
            return
        newpath = dl.GetPath()
        dl.Destroy()
        self.dirCtl.SetValue(newpath)

    def selectFile(self, event):
        dl = wx.FileDialog (self, self.localize('choosefiletouse'), '', '', '', wx.OPEN)
        result = dl.ShowModal()
        if result != wx.ID_OK:
            dl.Destroy()
            return
        newpath = dl.GetPath()
        dl.Destroy()
        self.dirCtl.SetValue(newpath)

    #def selectDrop(self, event):
    #    list = event.m_files
    #    self.dirCtl.SetValue(event[0])

    def announceCopy(self, event):
        dl = wx.FileDialog (self, self.localize('choosedottorrentfiletouse'), '', '',
                            'torrent files (*.torrent)|*.torrent|all files (*.*)|*.*', wx.OPEN)
        result = dl.ShowModal()
        if result != wx.ID_OK:
            dl.Destroy()
            return
        newpath = dl.GetPath()
        dl.Destroy()
        try:
            h = open(newpath, 'rb')
            metainfo = bdecode(h.read(), sloppy = 1)
            h.close()
            if metainfo.has_key('announce'):
                self.annctl.SetValue(metainfo['announce'])
            if metainfo.has_key('announce-list'):
                tierlist = []
                for tier in metainfo['announce-list']:
                    announcelist = []
                    for tracker in tier:
                        announcelist.append(self.utility.decodeString(tracker))
                    tierlist.append(', '.join(announcelist))
                self.annlistctl.SetValue('\n'.join(tierlist))
            else:
                self.annlistctl.SetValue('')
        except:
            return

    def getAnnounceList(self):
        list = []
        for t in self.annlistctl.GetValue().split('\n'):
            tier = []
            t = t.replace(',', ' ')
            for tr in t.split(' '):
                if tr != '':
                    tier += [tr.encode('utf_8')]
            if tier:
                list.append(tier)
        return list

    def makeTorrent(self, event):
        if self.completedir and self.completedir.frame:
            self.completedir.frame.Destroy()

        source = self.dirCtl.GetValue()
        if source == '':
            dlg = wx.MessageDialog(self, message = self.localize('youmustselectfileordir'), 
                                   caption = self.localize('abcokcerror'), style = wx.OK | wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return
        if not exists(source):
            dlg = wx.MessageDialog(self, message = self.localize('sourcedoesnotexist'), 
                                   caption = self.localize('abcokcerror'), style = wx.OK | wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return

        params = {}

        # Set destination
        for i in xrange(3):
            if self.savetor[i].GetValue():
                break
        if i == 0:
            # Check if default download folder is a valid Windows name
            defdestfolder = self.savetordeftext.GetValue()
            if sys.platform == 'win32' and self.savetorrb1.GetValue():
                # We erase the final '\' except for a path like 'X:\'
                if defdestfolder and defdestfolder[-1] == '\\' and (len(defdestfolder) < 2 or defdestfolder[-2] != ':'):
                    defdestfolder = defdestfolder[:-1]
                defdestfolder = defdestfolder.rstrip(whitespace + '.')
                if not self.utility.checkWinPath(self, defdestfolder):
                    return
            defdestfolder = self.utility.completePath(defdestfolder)
            # Check if default download folder is not a file and create it if necessary
            if exists(defdestfolder):
                if not isdir(defdestfolder):
                    dlg = wx.MessageDialog(self, message = defdestfolder + '\n' + self.localize('notadir1'), 
                                           caption = self.localize('abcokcerror'), style = wx.OK | wx.ICON_ERROR)
                    dlg.ShowModal()
                    dlg.Destroy()
                    return
            else:
                try:
                    makedirs(defdestfolder)
                except:
                    dlg = wx.MessageDialog(self, message = defdestfolder + '\n' + self.localize('cantmakefolder'), 
                                           caption = self.localize('abcokcerror'), style = wx.OK | wx.ICON_ERROR)
                    dlg.ShowModal()
                    dlg.Destroy()
                    return
            params['target'] = defdestfolder
        elif i == 2:
            dl = wx.DirDialog(self, style = wx.DD_DEFAULT_STYLE | wx.DD_NEW_DIR_BUTTON)
            result = dl.ShowModal()
            if result != wx.ID_OK:
                dl.Destroy()
                return
            newpath = dl.GetPath()
            dl.Destroy()
            params['target'] = newpath

        params['piece_size_pow2'] = self.piece_length_list[self.piece_length.GetSelection()]

        annlist = self.getAnnounceList()
        if len(annlist) > 0:
            params['real_announce_list'] = annlist

        rawnodelist = [s for s in re.split(r'[ \n]', self.dhtnodeslistctl.GetValue()) if s]
        if rawnodelist == ['']:
            rawnodelistlen = 0
        else:
            rawnodelistlen = len(rawnodelist)
        if rawnodelistlen % 2:
            dlg = wx.MessageDialog(self, message = self.localize('dhtnodelistformaterror'), 
                                   caption = self.localize('abcokcerror'), style = wx.OK | wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return
        usernodelist = []
        for i in xrange(0, rawnodelistlen, 2):
            ip = rawnodelist[i]
            if ip.find(':') >= 0:
                ipv6_exp = self.utility.expandIPv6(ip)
                if not ipv6_exp:
                    dlg = wx.MessageDialog(self, message = self.localize('dhtnodelistipv6error'),
                                           caption = self.localize('abcokcerror'), style = wx.OK | wx.ICON_ERROR)
                    dlg.ShowModal()
                    dlg.Destroy()
                    return
                rawnodelist[i] = ipv6_exp
            nodeporttypeerror = False
            try:
                nodeport = int(rawnodelist[i + 1])
            except:
                nodeporttypeerror = True
            if nodeporttypeerror or nodeport < 0 or nodeport > 65535:
                dlg = wx.MessageDialog(self, message = self.localize('dhtnodelistporterror'),
                                       caption = self.localize('abcokcerror'), style = wx.OK | wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return
            usernodelist.append([rawnodelist[i].encode('utf_8'), nodeport])
        params['dht_nodes_list'] = usernodelist

        comment = self.commentCtl.GetValue()
        if comment != '':
            params['comment'] = comment

        if self.privatecheck.GetValue():
            params['private'] = 1

        if self.addclosestdhtnodescheck.GetValue():
            params['addclosestdhtnodes'] = 1

        if isdir(source):
            maketorforeach = self.maketorforeachcheck.GetValue()
        else:
            maketorforeach = False

        self.maketorrentbtn.Disable()

        self.completedir = CompleteDir(self, source, self.annctl.GetValue(), self.dht, params, maketorforeach)

    def onBrowseDir(self, event):
        folderdialog = wx.DirDialog(self, self.localize('choosetordeffolder'), 
                                    style = wx.DD_DEFAULT_STYLE | wx.DD_NEW_DIR_BUTTON)
        if folderdialog.ShowModal() == wx.ID_OK:
            self.savetordeftext.SetValue(folderdialog.GetPath())
        folderdialog.Destroy()


class CompleteDir:
    def __init__(self, parent, d, a, dht, params, maketorforeach):
        self.d = d
        self.a = a
        self.dht = dht
        self.params = params
        self.parent = parent
        self.utility = self.parent.utility
        self.localize = self.utility.lang.get
        self.flag = Event()
        self.maketorforeach = maketorforeach
        self.frame = None

        self.begin()

    def begin(self):
        if self.maketorforeach:
            frametitle = self.localize('btmaketorrenttitle2')
            frametitle += basename(self.d)
        else:
            frametitle = self.localize('btmaketorrenttitle1')
            frametitle += basename(self.d) + '.torrent'
        self.frame = wx.Frame(None, -1, frametitle)

        panel = wx.Panel(self.frame, -1)
        gridSizer = wx.FlexGridSizer(cols = 1, vgap = 10, hgap = 8)

        if self.maketorforeach:
            self.currentLabel = wx.StaticText(panel, -1, self.localize('checkfilesize'))
        else:
            self.currentLabel = wx.StaticText(panel, -1, self.localize('building') + self.d + '.torrent')
        gridSizer.Add(self.currentLabel, 0, wx.EXPAND)
        self.gauge = wx.Gauge(panel, -1, range = 1000, style = wx.GA_SMOOTH, size = (400, -1))
        gridSizer.Add(self.gauge, 0, wx.EXPAND)
        self.button = wx.Button(panel, -1, self.localize('cancel'))
        gridSizer.Add(self.button, 0, wx.ALIGN_CENTER)

        g2 = wx.FlexGridSizer(cols = 1, vgap = 10, hgap = 8)
        g2.Add(gridSizer, 1, wx.EXPAND | wx.ALL, 5)
        panel.SetSizer(g2)
        panel.SetAutoLayout(True)
        wx.EVT_BUTTON(self.frame, self.button.GetId(), self.done)
        wx.EVT_CLOSE(self.frame, self.done)
        EVT_INVOKE(self.frame, self.onInvoke)
        panel.Fit()
        self.frame.SetClientSize(panel.GetSize())
        self.frame.Show(True)
        thread = Thread(target = self.complete)
        thread.daemon = False
        thread.start()

    def complete(self):
        try:
            if self.maketorforeach:
                nbclosestnodes = completedir(self.d, self.a, self.dht, self.params, self.flag, self.valCallback, self.fileCallback)
            else:
                nbclosestnodes = make_meta_file(self.d, self.a, self.dht, self.params, self.flag, self.valCallback, progress_percent = 1)
            if not self.flag.isSet():
                if self.maketorforeach:
                    status = self.localize('torrentsbuilt')
                else:
                    status = self.localize('torrentbuilt')
                if self.params.has_key('addclosestdhtnodes') and self.params['addclosestdhtnodes']:
                    status += str(nbclosestnodes) + self.localize('dhtnodesadded')
                self.currentLabel.SetLabel(status)
                self.gauge.SetValue(1000)
                self.button.SetLabel(self.localize('close'))
                self.frame.Refresh()
                self.parent.maketorrentbtn.Enable()
        except (OSError, IOError), e:
            self.currentLabel.SetLabel(self.localize('error'))
            self.button.SetLabel(self.localize('close'))
            self.parent.maketorrentbtn.Enable()
            dlg = wx.MessageDialog(self.frame, message = self.localize('error') + ' - ' + exceptionArgsToString(e), 
                                   caption = self.localize('abcokcerror'), style = wx.OK | wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()

    def valCallback(self, amount):
        self.invokeLater(self.onVal, [amount])

    def onVal(self, amount):
        self.gauge.SetValue(int(amount * 1000))

    def fileCallback(self, f):
        self.invokeLater(self.onFile, [f])

    def onFile(self, f):
        self.currentLabel.SetLabel(self.localize('building') + join(self.d, f) + '.torrent')

    def onInvoke(self, event):
        if not self.flag.isSet():
            apply(event.func, event.args, event.kwargs)

    def invokeLater(self, func, args = [], kwargs = {}):
        if not self.flag.isSet():
            wx.PostEvent(self.frame, InvokeEvent(func, args, kwargs))

    def done(self, event = None):
        self.flag.set()
        self.frame.Destroy()
        self.frame = None
        self.parent.maketorrentbtn.Enable()
