##############################################################################
# Module : abcdetailframe.py
# Author :
# Date   :
# Updated and modified for ABC_OKC : Old King Cole
#
# Description : Torrent advanced details window
#
##############################################################################
import sys, wx, re, binascii
from os.path import join
from time import clock

import abcmetainfoframe


class ABCDetailFrame(wx.Frame):
    def __init__(self, parent, ID, title, utility, index, position, size, centeratpointer = False):        
        if position is None or position < 0:
            pos = wx.DefaultPosition
        else:
            pos = position
        wx.Frame.__init__(self, parent, ID, title, pos, size)
        self.parent = parent
        self.const = False
        self.SetAcceleratorTable(self.parent.parent.accelerators)
        self.utility = utility
        self.abcparams = self.utility.abcparams
        self.localize = self.utility.lang.get
        self.guiman = self.parent.guiman
        self.popupmenu = None
        self.resettingframe = False
        self.index = index
        self.torrent = self.parent.queue.proctab[index]
        self.selectedrow = -1
        self.selectedconnection = False
        self.selectedbanned = None
        self.resizedcol = None
        self.width = size[0]
        self.widthfornext, self.heightfornext = size
        # To save pos and size for an opened window currently browsed in another one
        self.wintorestore = None

        if sys.platform == 'win32':
            self.icon = wx.Icon(join(self.utility.abcpath, 'icon_abc.ico'), wx.BITMAP_TYPE_ICO)
            self.SetIcon(self.icon)

        self.panel = wx.Panel(self, -1)
        colsizer = wx.FlexGridSizer(cols = 1, vgap = 3)
        colsizer.AddGrowableCol(0)
        colsizer.AddGrowableRow(1)

        toppanel = wx.Panel(self.panel, -1)
        toppanel.SetDoubleBuffered(True)

        topsizer = wx.BoxSizer(wx.VERTICAL)

        self.abouttitle = wx.StaticText(toppanel, -1, '')
        self.abouttitle.SetFont(wx.Font(14, wx.DEFAULT, wx.NORMAL, wx.NORMAL, False))
        topsizer.Add(self.abouttitle, 0, wx.EXPAND)

        detailsizer = wx.FlexGridSizer(cols = 4, vgap = 3, hgap = 5)
        detailsizer.AddGrowableCol(0, 1)
        detailsizer.AddGrowableCol(1, 1)
        detailsizer.AddGrowableCol(2, 1)
        detailsizer.AddGrowableCol(3, 1)
        detailsizer1 = wx.FlexGridSizer(cols = 2, vgap = 3, hgap = 2)
        detailsizer2 = wx.FlexGridSizer(cols = 2, vgap = 3, hgap = 2)
        detailsizer3 = wx.FlexGridSizer(cols = 2, vgap = 3, hgap = 2)
        detailsizer4 = wx.FlexGridSizer(cols = 2, vgap = 3, hgap = 2)

        # # Seeds
        self.seedtitle = wx.StaticText(toppanel, -1, self.localize('dnumconnectedseed'))
        self.numseed = wx.StaticText(toppanel, -1, '')        
        detailsizer1.Add(self.seedtitle)
        detailsizer1.Add(self.numseed)

        # # Peers
        peertitle = wx.StaticText(toppanel, -1, self.localize('dnumconnectedpeer'))
        self.numpeer = wx.StaticText(toppanel, -1, '')        
        detailsizer2.Add(peertitle)
        detailsizer2.Add(self.numpeer)

        # # Seeing Copies
        copytitle = wx.StaticText(toppanel, -1, self.localize('dseeingcopies'))
        self.numcopy = wx.StaticText(toppanel, -1, '')       
        detailsizer3.Add(copytitle)
        detailsizer3.Add(self.numcopy)

        # Avg peer
        avgprogresstitle = wx.StaticText(toppanel, -1, self.localize('davgpeerprogress'))
        self.avgprogress = wx.StaticText(toppanel, -1, '')        
        detailsizer4.Add(avgprogresstitle)
        detailsizer4.Add(self.avgprogress)

        # Download Size
        downsizetitle = wx.StaticText(toppanel, -1, self.localize('ddownloadedsize'))
        self.downsize = wx.StaticText(toppanel, -1, '')        
        detailsizer1.Add(downsizetitle)
        detailsizer1.Add(self.downsize)

        # Upload Size
        upsizetitle = wx.StaticText(toppanel, -1, self.localize('duploadedsize'))
        self.upsize = wx.StaticText(toppanel, -1, '')        
        detailsizer2.Add(upsizetitle)
        detailsizer2.Add(self.upsize)

        # Total Speed
        totalspeedtitle = wx.StaticText(toppanel, -1, self.localize('dtotalspeed'))
        self.totalspeed = wx.StaticText(toppanel, -1, '')        
        detailsizer3.Add(totalspeedtitle)
        detailsizer3.Add(self.totalspeed)

        # Total Progress
        totalprogresstitle = wx.StaticText(toppanel, -1, self.localize('totalprogressedetail'))
        self.totalprogress = wx.StaticText(toppanel, -1, '')        
        detailsizer4.Add(totalprogresstitle)
        detailsizer4.Add(self.totalprogress)

        detailsizer.Add(detailsizer1)
        detailsizer.Add(detailsizer2)
        detailsizer.Add(detailsizer3)
        detailsizer.Add(detailsizer4)

        topsizer.Add(detailsizer, 0, wx.EXPAND | wx.TOP, 2)

        toppanel.SetSizer(topsizer)
        toppanel.SetAutoLayout(True)
        colsizer.Add(toppanel, 0, wx.EXPAND | wx.TOP, -2)

        if self.utility.advdetdbuf:
            self.spewlist = wx.ListCtrl(self.panel, -1, style = wx.LC_REPORT | wx.LC_HRULES | wx.LC_VRULES | wx.LC_SINGLE_SEL | wx.LC_NO_HEADER)
            self.spewlist.SetDoubleBuffered(True)
        else:
            self.spewlist = wx.ListCtrl(self.panel, -1, style = wx.LC_REPORT | wx.LC_HRULES | wx.LC_VRULES | wx.LC_SINGLE_SEL)
        self.spewlist.SetMinSize((0, 0))

        colsizer.Add(self.spewlist, 0, wx.EXPAND)

        bottompanel = wx.Panel(self.panel, -1)
        bottompanel.SetDoubleBuffered(True)

        currentstatsizer = wx.BoxSizer(wx.VERTICAL)

        currentstatsizer1 = wx.BoxSizer(wx.HORIZONTAL)
        statusbox = wx.BoxSizer(wx.HORIZONTAL)
        statustitle = wx.StaticText(bottompanel, -1, self.localize('statusdetwin'))
        self.status = wx.StaticText(bottompanel, -1, '', size = (75, -1))
        statusbox.Add(statustitle)
        statusbox.Add(self.status, 0, wx.LEFT, 5)
        self.colour = wx.Window(bottompanel, -1, size = (13, 13), style = wx.SIMPLE_BORDER)
        statusbox.Add(self.colour, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        currentstatsizer1.Add(statusbox)
        self.storagestats1 = wx.StaticText(bottompanel, -1, '', style = wx.ALIGN_RIGHT | wx.ST_NO_AUTORESIZE)
        currentstatsizer1.Add(self.storagestats1, 1)

        currentstatsizer2 = wx.BoxSizer(wx.HORIZONTAL)
        ratesbox = wx.BoxSizer(wx.HORIZONTAL)
        downratetitle = wx.StaticText(bottompanel, -1, self.localize('downratedetwin'))
        self.downrate = wx.StaticText(bottompanel, -1, '', size = (68, -1))
        ratesbox.Add(downratetitle)
        ratesbox.Add(self.downrate, 0, wx.LEFT, 5)
        upratetitle = wx.StaticText(bottompanel, -1, self.localize('upratedetwin'))
        self.uprate = wx.StaticText(bottompanel, -1, '', size = (68, -1))
        ratesbox.Add(upratetitle, 0, wx.LEFT, 10)
        ratesbox.Add(self.uprate, 0, wx.LEFT, 5)
        currentstatsizer2.Add(ratesbox, 0)
        self.storagestats2 = wx.StaticText(bottompanel, -1, '', style = wx.ALIGN_RIGHT | wx.ST_NO_AUTORESIZE)
        currentstatsizer2.Add(self.storagestats2, 1)

        currentstatsizer.Add(currentstatsizer1, 0, wx.EXPAND)
        currentstatsizer.Add(currentstatsizer2, 0, wx.EXPAND | wx.TOP, 3)

        bottompanel.SetSizer(currentstatsizer)
        bottompanel.SetAutoLayout(True)
        colsizer.Add(bottompanel, 0, wx.EXPAND)

        buttonsizer = wx.BoxSizer(wx.HORIZONTAL)

        self.trackerbut = wx.ToggleButton(self.panel)
        buttonsizer.Add(self.trackerbut)

        self.trackercolour = wx.Window(self.panel, -1, size = (8, 13), style = wx.SIMPLE_BORDER)
        buttonsizer.Add(self.trackercolour, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        self.privatecolour = wx.Window(self.panel, -1, size = (8, 13), style = wx.SIMPLE_BORDER)
        buttonsizer.Add(self.privatecolour, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        scrapebut = wx.Button(self.panel, -1, self.localize('updateseedpeer'))
        buttonsizer.Add(scrapebut, 0, wx.LEFT, 5)

        locatebut = wx.Button(self.panel, -1, self.localize('locate'), size = (55, -1))
        buttonsizer.Add(locatebut, 0, wx.LEFT, 10)

        torrentparambut = wx.Button(self.panel, -1, self.localize('torrentparam'))
        buttonsizer.Add(torrentparambut, 0, wx.LEFT, 10)

        self.detailsbut = wx.Button(self.panel, -1, self.localize('details'))
        buttonsizer.Add(self.detailsbut, 0, wx.LEFT, 10)

        closebut = wx.Button(self.panel, -1, self.localize('close'), size = (55, -1))
        buttonsizer.Add(closebut, 0, wx.LEFT, 10)

        colsizer.Add(buttonsizer, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.TOP, 3)

        self.SetMinSize(self.ClientToWindowSize(colsizer.GetMinSize()))

        col = 0
        if self.utility.advdetdbuf:
            for colinfo in self.utility.advdetcolumns:
                self.spewlist.InsertColumn(col, '', format = colinfo[2], width = colinfo[1])
                col += 1
            self.spewlist.InsertStringItem(0, '')
            self.spewlist.SetItemBackgroundColour(0, (236, 233, 216))
            col = 0
            for colinfo in self.utility.advdetcolumns:
                self.spewlist.SetStringItem(0, col, colinfo[0])
                col += 1
        else:
            for colinfo in self.utility.advdetcolumns:
                self.spewlist.InsertColumn(col, colinfo[0], format = colinfo[2], width = colinfo[1])
                col += 1

        border = wx.BoxSizer(wx.HORIZONTAL)
        border.Add(colsizer, 1, wx.EXPAND | wx.ALL, 3)
        self.panel.SetSizer(border)
        self.panel.SetAutoLayout(True)

        self.panel.Bind(wx.EVT_LIST_ITEM_RIGHT_CLICK, self.onListRightClick, self.spewlist)
        self.spewlist.Bind(wx.EVT_RIGHT_DOWN, self.onListRightDown)
        self.spewlist.Bind(wx.EVT_LEFT_DOWN, self.onListLeftDown)
        self.spewlist.Bind(wx.EVT_LIST_COL_END_DRAG, self.onResizeColumn)
        self.spewlist.Bind(wx.EVT_LIST_COL_RIGHT_CLICK, self.onColRightClick)
        self.spewlist.Bind(wx.EVT_MOUSEWHEEL, self.onListMouseWheel)
        self.Bind(wx.EVT_MOVE, self.onMoveAdvDet)
        self.Bind(wx.EVT_SIZE, self.onSizeAdvDet)
        self.Bind(wx.EVT_BUTTON, self.onLocate, locatebut)
        self.Bind(wx.EVT_BUTTON, self.onLocalSetting, torrentparambut)
        self.Bind(wx.EVT_BUTTON, self.onDetails, self.detailsbut)
        self.Bind(wx.EVT_BUTTON, self.getScrape, scrapebut)
        self.Bind(wx.EVT_TOGGLEBUTTON, self.onTrackerBut, self.trackerbut)
        self.Bind(wx.EVT_CLOSE, self.killAdv)
        self.Bind(wx.EVT_BUTTON, self.killAdv, closebut)
        self.abouttitle.Bind(wx.EVT_LEFT_DOWN, self.toggleFocusOnTitle)
        self.abouttitle.Bind(wx.EVT_MOUSEWHEEL, self.onMouseWheelTitle)
        self.panel.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        toppanel.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        bottompanel.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        self.abouttitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        self.seedtitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        self.numseed.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        peertitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        self.numpeer.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        copytitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        self.numcopy.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        avgprogresstitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        self.avgprogress.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        downsizetitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        self.downsize.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        upsizetitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        self.upsize.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        totalspeedtitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        self.totalspeed.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        totalprogresstitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        self.totalprogress.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        statustitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        self.status.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        downratetitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        self.downrate.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        upratetitle.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        self.uprate.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        self.storagestats1.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        self.storagestats2.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)
        self.colour.Bind(wx.EVT_RIGHT_UP, self.onRightUpAdv)

        # Init sub-menu used when a connected peer is clicked
        self.peermenu = wx.Menu()
        self.peermenu.Append(941, ' ')
        self.peermenu.AppendSeparator()
        self.peermenu.Append(942, self.localize('copypeer'))
        self.Bind(wx.EVT_MENU, self.onCopyPeer, id = 942)
        self.peermenu.Append(943, self.localize('copypeerclientid'))
        self.Bind(wx.EVT_MENU, self.onCopyPeerClientId, id = 943)
        self.peermenu.Append(946, self.localize('copypeerremote'))
        self.Bind(wx.EVT_MENU, self.onCopyPeerRemote, id = 946)
        self.peermenu.Append(944, self.localize('kickpeer'))        
        self.Bind(wx.EVT_MENU, self.onKickPeer, id = 944)
        self.peermenu.Append(945, self.localize('banpeer'))
        self.Bind(wx.EVT_MENU, self.onBanPeer, id = 945)

        self.displayInfo()

        const = False
        if position == -1:
            self.Centre()
        elif position == -2:
            pos, const = self.utility.getPosCenteredOnWin(size, self.torrent.infowin)
            self.Move(pos)
        elif position == -3:
            pos, const = self.utility.getPosCenteredOnWin(size, self.torrent.infowin, aligntop = True)
            self.Move(pos)
        elif centeratpointer:
            self.Move(pos - wx.Point(self.GetSizeTuple()[0] / 2, 10))

        self.resettingframe = True
        self.Show()
        self.resettingframe = False
        # Placed here because first Show calls Move, resetting self.const
        self.const = const

    def displayInfo(self):
        self.panel.Freeze()
        self.SetTitle(self.localize('torrentadvdetail') + self.torrent.name)
        self.abouttitle.SetLabel(self.torrent.name.replace('&', '&&'))
        if self.torrent.private:
            self.privatecolour.SetBackgroundColour(self.utility.colprivate)
        else:
            self.privatecolour.SetBackgroundColour(self.utility.colnoeng)
        self.privatecolour.Refresh()
        if self.torrent.abcengine:
            if self.utility.advdetdbuf:
                for i in xrange(1, self.spewlist.GetItemCount()):
                    self.spewlist.DeleteItem(1)
            else:
                self.spewlist.DeleteAllItems()
            self.torrent.abcengine.updateDetailWindowNow(self)
            self.toggleTrackerBut(int(self.torrent.exttracker and not self.torrent.abcengine.checkinginttrack))
        else:
            self.init()
            self.updateSize()
            self.totalprogress.SetLabel(self.torrent.formatedProgress())
            if self.torrent.ismovingdata:
                self.status.SetLabel(self.localize('moving'))
            else:
                self.status.SetLabel(self.localize(self.torrent.status))
            self.colour.SetBackgroundColour(self.utility.colnoeng)
            self.colour.Refresh()
            self.trackercolour.SetBackgroundColour(self.torrent.coltrackernotrunning)
            self.trackercolour.Refresh()

        self.resetFrame()

    def resetFrame(self):
        self.resettingframe = True
        self.panel.SetSize(self.GetClientSize())
        self.panel.Layout()
        self.sizeTitle()
        self.panel.Thaw()
        self.resettingframe = False

    def toggleFocusOnTitle(self, event):
        focus = self.FindFocus()
        if focus is self.abouttitle:
            self.oldfocus.SetFocus()
        else:
            self.oldfocus = focus
            self.abouttitle.SetFocus()

    def onMoveAdvDet(self, event):
       self.const = False
       event.Skip()

    def onSizeAdvDet(self, event):
        if self.IsIconized():
            event.Skip()
            return
        if self.resettingframe:
            event.Skip()
            return
        windowsize = self.GetSizeTuple()
        if not self.IsMaximized():
            self.widthfornext, self.heightfornext = windowsize
        oldw = self.width
        self.width = windowsize[0]
        if self.width != oldw:
            self.panel.Freeze()
            self.resetFrame()
        else:
            event.Skip()

    def setSize(self, size):
        self.SetSize(size)

    def sizeTitle(self):
        if self.abouttitle.GetTextExtent(self.torrent.name)[0] > self.width - 14:
            self.abouttitle.SetSize((5000, -1))
            self.abouttitle.SetWindowStyle(wx.ALIGN_LEFT)
            self.abouttitle.SetToolTipString(self.torrent.name)
        else:
            self.abouttitle.SetSize((self.width - 14, -1))
            self.abouttitle.SetWindowStyle(wx.ALIGN_CENTER)
            self.abouttitle.SetToolTipString('')

    def onMouseWheelTitle(self, event):
        oldindex = index = self.index
        oldtorrent = torrent = self.torrent
        while True:
            if event.GetWheelRotation() > 0:
                if index > 0:
                    index -= 1
                else:
                    return
            elif index < self.parent.list.GetItemCount() - 1:
                index += 1
            else:
                return
            torrent = self.parent.queue.proctab[index]
            if not torrent.isbeingdeleted:
                self.index = index
                self.torrent = torrent
                break

        if self.wintorestore is not None:
            # Restore window for old torrent
            oldtorrent.detailwin = ABCDetailFrame(self.parent, -1, '', self.utility, oldindex,
                                                  self.wintorestore[0], self.wintorestore[1], centeratpointer = False)
            if oldtorrent.abcengine:
                oldtorrent.abcengine.detailwin = oldtorrent.detailwin
            self.abouttitle.SetFocus()
        else:
            oldtorrent.detailwin = None
            if oldtorrent.abcengine:
                oldtorrent.abcengine.detailwin = None

        if self.torrent.detailwin is not None:
            # Kill window for new torrent and save position and size if not hidden for later restoration
            if self.torrent.detailwin.IsShown():
                if self.torrent.detailwin.IsIconized() or self.torrent.detailwin.IsMaximized():
                    self.wintorestore = ((-1, -1), (self.guiman.getDetailWidth(), self.guiman.getDetailHeight()))
                else:
                    self.wintorestore = (self.torrent.detailwin.GetPosition(), self.torrent.detailwin.GetSize())
            else:
                self.wintorestore = None
            self.torrent.detailwin.killAdv()
        else:
            self.wintorestore = None

        self.torrent.detailwin = self
        if self.torrent.abcengine:
            self.torrent.abcengine.detailwin = self
        self.displayInfo()

        # If the old selection in list matched the displayed info, change the selection in list
        if self.parent.list.GetSelectedItemCount() == 1 and self.parent.getSelected()[0] == oldindex:
            self.parent.list.SetItemState(oldindex, 0, wx.LIST_STATE_SELECTED)
            self.parent.list.Select(self.index)
            if event.GetWheelRotation() > 0:
                if self.index > 0:
                    self.parent.list.EnsureVisible(self.index - 1)
            elif self.index < self.parent.list.GetItemCount() - 1:
                self.parent.list.EnsureVisible(self.index + 1)
            self.parent.list.EnsureVisible(self.index)

        if oldtorrent.infowin is not None and not oldtorrent.infowin.IsShown():
            oldtorrent.infowin.killInfo()

    def updateTorrentName(self):
        self.SetTitle(self.localize('torrentadvdetail') + self.torrent.name)
        self.abouttitle.SetLabel(self.torrent.name.replace('&', '&&'))
        self.sizeTitle()

    def updateSize(self):
        # Update downloaded and uploaded size display
        self.downsize.SetLabel(self.utility.sizeWithUnit(self.utility.formatedSize(self.torrent.downsize)))
        self.upsize.SetLabel(self.utility.sizeWithUnit(self.utility.formatedSize(self.torrent.upsize)))

    def onRightUpAdv(self, event):
        self.parent.makePopupMenu(self, False)
        self.PopupMenu(self.parent.popupmenu, self.panel.ScreenToClient(event.GetEventObject().ClientToScreen(event.GetPosition())))

    def onLocate(self, event):
        # Unselect all torrents in main ABC list
        for index in self.parent.getSelected():
            self.parent.list.SetItemState(index, 0, wx.LIST_STATE_SELECTED)
        self.parent.list.EnsureVisible(self.index)
        self.parent.list.Select(self.index)
        if not self.parent.list.IsShown():
            self.parent.parent.tb.ToggleTool(self.parent.parent.maintoolbarids[0], True)
            self.parent.displayTransfer()

    def onLocalSetting(self, event):
        self.parent.windowparent = self
        self.parent.commandfromlist = False
        self.parent.onLocalSetting()

    def onDetails(self, event):
        ctrl = wx.GetKeyState(wx.WXK_CONTROL)
        if self.torrent.infowin == None:
            centerdetoneachother = self.abcparams['centerdetoneachother']
            if centerdetoneachother == '0':
                infowinpos = self.GetPosition()
            elif centerdetoneachother == '1':
                infowinpos = -2
            else:
                infowinpos = -3
            self.torrent.infowin = abcmetainfoframe.ABCMetaInfoFrame(self.parent, -1, '', self.utility,
                                                                     self.index,
                                                                     infowinpos,
                                                                     self.guiman.getMetaSize())
            if self.torrent.abcengine:
                self.torrent.abcengine.infowin = self.torrent.infowin
        elif self.torrent.infowin.IsShown():
            if self.torrent.infowin.IsIconized():
                self.torrent.infowin.Iconize(False)
            self.torrent.infowin.Raise()
        else:
            centerdetoneachother = self.abcparams['centerdetoneachother']
            if centerdetoneachother == '0':
                infowinpos = self.GetPosition()
                const = False
            elif centerdetoneachother == '1':
                infowinpos, const = self.utility.getPosCenteredOnWin(self.torrent.infowin.GetSize(), self)
            else:
                infowinpos, const = self.utility.getPosCenteredOnWin(self.torrent.infowin.GetSize(), self, aligntop = True)
            if not self.const:
                self.torrent.infowin.Move(infowinpos)
            self.torrent.infowin.const = const
            self.torrent.infowin.Show()
        if not ctrl:
            self.torrent.detailwin.Hide()
        x, y, w, h = self.torrent.infowin.advdetailsbut.GetRect()
        self.torrent.infowin.WarpPointer(x + w / 2, y + h / 2)

    def getScrape(self, event):
        ctrl = wx.GetKeyState(wx.WXK_CONTROL)
        if self.torrent.scraping:
            return
        if self.torrent.lastgetscrapemanual and clock() - self.torrent.lastgetscrapemanual < 60:
            dlg = wx.MessageDialog(self, self.localize('warningscrape2') + self.localize('warningscrape3'),
                                   self.localize('abcokcwarning'), wx.ICON_WARNING)
            dlg.ShowModal()
            dlg.Destroy()
            return
        self.parent.queue.getScrapeData(self.torrent, ctrlscrape = ctrl)

    def onTrackerBut(self, event):
        if wx.GetKeyState(wx.WXK_CONTROL) and self.torrent.abcengine \
           and (not self.torrent.exttracker or self.torrent.abcengine.checkinginttrack):
            self.torrent.toggleCheckIntTrack()
        else:
            self.torrent.switchTracker(int(event.GetInt()), updatebut = False)

    def toggleTrackerBut(self, value, updatebut = True):
        if updatebut:
            self.trackerbut.SetValue(value)
        if value:
            self.trackerbut.SetLabel(self.utility.trackerbutextlabel)
        elif self.torrent.abcengine and self.torrent.abcengine.checkinginttrack:
            self.trackerbut.SetLabel(self.utility.trackerbutwaitlabel)
        else:
            self.trackerbut.SetLabel(self.utility.trackerbutintlabel)

    def killAdv(self, event = None):
        if self.torrent.infowin is not None and not self.torrent.infowin.IsShown():
            self.torrent.infowin.killInfo()
        self.parent.queue.deleteDetailWin(self.index)
        if self.popupmenu:
            self.popupmenu.Destroy()
        self.Destroy()

    def init(self):
        self.numseed.SetLabel('0 (' + self.torrent.seed + ')')
        self.numpeer.SetLabel('0 (' + self.torrent.peer + ')')
        self.numcopy.SetLabel(self.torrent.numcopy)
        self.avgprogress.SetLabel('0.0%')
        self.totalspeed.SetLabel(self.utility.rateWithUnit(''))
        if self.utility.advdetdbuf:
            for i in xrange(1, self.spewlist.GetItemCount()):
                self.spewlist.DeleteItem(1)
        else:
            self.spewlist.DeleteAllItems()
        self.downrate.SetLabel(self.utility.rateWithUnit('', self.torrent.prioritizedown))
        self.uprate.SetLabel(self.utility.rateWithUnit('', self.torrent.prioritizeup))
        self.storagestats1.SetLabel('')
        self.storagestats2.SetLabel('')
        self.toggleTrackerBut(self.torrent.exttracker)
        self.spew = None
        self.kicked = None
        self.banned = None

    def updateColumnWidth(self, col):
        # Save a column width from the spew list
        newcolwidth = self.spewlist.GetColumnWidth(col)
        self.utility.advdetcolumns[col][1] = newcolwidth
        self.abcparams[self.utility.advdetcolinfo[col][1]] = str(newcolwidth)

    def onResizeColumn(self, event):
        event.Skip()
        wx.CallAfter(self.updateColumnWidth, event.GetColumn())

    def onColRightClick(self, event):
        col = 0
        for colinfo in self.utility.advdetcolinfo:
            self.spewlist.SetColumnWidth(col, colinfo[3])
            self.utility.advdetcolumns[col][1] = colinfo[3]
            self.abcparams[colinfo[1]] = str(colinfo[3])
            col += 1

    def onListLeftDown(self, event):
        if self.utility.advdetdbuf:
            x, y = event.GetPosition()
            if self.spewlist.HitTest((x, y))[0] == 0:
                col = self.utility.getListClickedColumn(self.spewlist, x)
                if col >= 0:
                    if col == self.resizedcol:
                        self.resizedcol = None
                    else:
                        self.resizedcol = col
        # To prevent selection in list with left click
        self.spewlist.SetFocus()

    def onListMouseWheel(self, event):
        if self.utility.advdetdbuf and self.resizedcol is not None:
            rot = event.GetWheelRotation()
            self.spewlist.SetColumnWidth(self.resizedcol, self.spewlist.GetColumnWidth(self.resizedcol) + rot/abs(rot))
            wx.CallAfter(self.updateColumnWidth, self.resizedcol)
        else:
            event.Skip()

    def setAllColumnWidths(self):
        col = 0
        for colinfo in self.utility.advdetcolumns:
            self.spewlist.SetColumnWidth(col, colinfo[1])
            col += 1

    def onListRightDown(self, event):
        self.selectedrow = self.spewlist.HitTest(event.GetPosition())[0]
        if self.utility.advdetdbuf:
            realselectedrow = self.selectedrow - 1
        else:
            realselectedrow = self.selectedrow
        self.selectedconnection = False
        self.selectedbanned = None
        if realselectedrow >= 0:
            if 0 <= realselectedrow < len(self.spew):
                self.selectedconnection = True
                selectedpeer = self.spew[realselectedrow]
                self.selecteddns = selectedpeer['dns']
                self.selectedrp = selectedpeer['rp']
                self.selectedpid = selectedpeer['pid']
                self.selectedci = selectedpeer['ci']
            else:
                bannedrow = realselectedrow - len(self.spew) - len(self.kicked) - 3
                if 0 <= bannedrow < len(self.banned):
                    self.selectedbanned = self.banned[bannedrow]
        event.Skip()

    def onListRightClick(self, event):
        self.spewlist.SetItemState(self.selectedrow, 0, wx.LIST_STATE_SELECTED)
        if self.utility.advdetdbuf and self.selectedrow == 0:
            col = 0
            for colinfo in self.utility.advdetcolinfo:
                self.spewlist.SetColumnWidth(col, colinfo[3])
                self.utility.advdetcolumns[col][1] = colinfo[3]
                self.abcparams[colinfo[1]] = str(colinfo[3])
                col += 1
        else:
            if self.abcparams['showpeermenu'] == '0':
                return
            self.initPopupMenu()
            if self.selectedconnection:
                self.popupmenu.Enable(940, True)
                self.popupmenu.SetLabel(940, self.localize('popuppeer_b') 
                                             + self.selecteddns[0] + ' : ' + str(self.selecteddns[1])
                                             + self.localize('popuppeer_e'))
                if self.selectedci is None:
                    self.selectedci = self.localize('unknownclient')
                else:
                    self.selectedci = self.utility.decodeString(self.selectedci)[:50]
                    if not self.selectedci:
                        self.selectedci = self.localize('unknownclient')
                if not self.selectedci:
                    # must not be empty
                    self.selectedci = 'Unknown Client'
                self.peermenu.SetLabel(941, self.selectedci)
            elif self.selectedbanned:
                self.popupmenu.Enable(940, True)
                self.popupmenu.SetLabel(940, self.localize('unbanpeer') + ' ' + self.selectedbanned)
            else:
                self.popupmenu.Enable(940, False)
                self.popupmenu.SetLabel(940, self.localize('popuppeer_b') + self.localize('nopeerselected') + self.localize('popuppeer_e'))
            if self.spew:
                self.popupmenu.Enable(922, True)
                self.popupmenu.Enable(924, True)
            else:
                self.popupmenu.Enable(922, False)
                self.popupmenu.Enable(924, False)
            if not self.torrent.lastpeers or self.torrent.isCheckingOrAllocating() or self.torrent.isWaiting() \
               or self.torrent.status == 'pause' or self.torrent.status == 'onhold':
                self.popupmenu.Enable(923, False)
            else:
                self.popupmenu.Enable(923, True)
            if self.torrent.lastpeers:
                self.popupmenu.Enable(925, True)
                self.popupmenu.Enable(926, True)
            else:
                self.popupmenu.Enable(925, False)
                self.popupmenu.Enable(926, False)
            self.PopupMenu(self.popupmenu, self.panel.ScreenToClient(self.spewlist.ClientToScreen(event.GetPosition())))
            self.selectedconnection = False
            self.selectedbanned = None

    def initPopupMenu(self):
        self.popupmenu = wx.Menu()
        if self.selectedbanned:
            self.popupmenu.Append(940, ' ')
            self.Bind(wx.EVT_MENU, self.onUnbanPeer, id = 940)
        else:
            self.popupmenu.AppendMenu(940, ' ', self.peermenu)
        self.popupmenu.AppendSeparator()
        self.popupmenu.Append(922, self.localize('savepeers'))
        self.Bind(wx.EVT_MENU, self.onSavePeers, id = 922)
        self.popupmenu.Append(923, self.localize('loadpeers'))
        self.Bind(wx.EVT_MENU, self.onLoadPeers, id = 923)
        self.popupmenu.AppendSeparator()
        self.popupmenu.Append(924, self.localize('copyconnectedpeers'))
        self.Bind(wx.EVT_MENU, self.onCopyConnectedPeers, id = 924)
        self.popupmenu.Append(925, self.localize('copysavedpeers'))
        self.Bind(wx.EVT_MENU, self.onCopySavedPeers, id = 925)
        self.popupmenu.AppendSeparator()
        self.popupmenu.Append(926, self.localize('clearsavedpeers'))
        self.Bind(wx.EVT_MENU, self.onClearSavedPeers, id = 926)

    def onCopyPeer(self, event):
        if wx.TheClipboard.Open():
            wx.TheClipboard.SetData(wx.TextDataObject(self.selecteddns[0] + ' ' + str(self.selecteddns[1])))
            wx.TheClipboard.Close()

    def onCopyPeerClientId(self, event):
        if wx.TheClipboard.Open():
            wx.TheClipboard.SetData(wx.TextDataObject(self.selecteddns[0] + ' ' + str(self.selecteddns[1]) + '\n'
                                                      + self.selectedci + '\n'
                                                      + self.utility.binToString(self.selectedpid)))
            wx.TheClipboard.Close()

    def onCopyPeerRemote(self, event):
        if wx.TheClipboard.Open():
            rp = self.selectedrp
            if rp is None:
                rp = '-'
            else:
                rp = str(rp)
            wx.TheClipboard.SetData(wx.TextDataObject(self.selecteddns[0] + ' ' + rp))
            wx.TheClipboard.Close()

    def onKickPeer(self, event):
        if self.torrent.abcengine:
            # Check if selected peer is in spew list
            for peer in self.spew:
                if peer['dns'] == self.selecteddns:
                    self.torrent.abcengine.dow.sched(self.torrent.abcengine.dow.downloader.try_kick, 0,
                                                     [None, True, True, self.selecteddns, self.selectedpid])

    def onBanPeer(self, event):
        if self.torrent.abcengine:
            self.torrent.abcengine.dow.sched(self.torrent.abcengine.dow.downloader.close_ban, 0,
                                             [None, self.selecteddns, self.selectedpid])

    def onUnbanPeer(self, event):
        if self.torrent.abcengine:
            self.torrent.abcengine.dow.sched(self.torrent.abcengine.dow.downloader.unban, 0, [self.selectedbanned])

    def onSavePeers(self, event):
        if self.torrent.abcengine:
            self.torrent.abcengine.savePeers()

    def onLoadPeers(self, event):
        if self.torrent.abcengine:
            self.torrent.abcengine.loadPeers()

    def onCopyConnectedPeers(self, event):
        if self.torrent.abcengine and self.spew:
            peers = [peer['dns'] for peer in self.spew]
            if wx.TheClipboard.Open():
                wx.TheClipboard.SetData(wx.TextDataObject('\r\n'.join([' '.join([host, str(port)]) for host, port in peers])))
                wx.TheClipboard.Close()

    def onCopySavedPeers(self, event):
        if self.torrent.abcengine and wx.TheClipboard.Open():
            wx.TheClipboard.SetData(wx.TextDataObject('\r\n'.join([' '.join([host, str(port)]) for host, port in self.torrent.lastpeers])))
            wx.TheClipboard.Close()

    def onClearSavedPeers(self, event):
        if self.torrent.abcengine:
            self.torrent.abcengine.clearSavedPeers()
