##############################################################################
# Module : abc_okc_starter.py
# Author : Old King Cole
# Date   : 08/20/2007
#
# Description : ABC_OKC starter
#
##############################################################################

import sys
from utility import Stderr
sys.stderr = Stderr()
from os import execv
from os.path import dirname, join
from wx import GetUserId, SingleInstanceChecker

from interconn import clientPassParam
from commandline import getCommandLine


arg = getCommandLine()
params = arg[1:]
# Create single instance semaphore
singleinstancechecker = SingleInstanceChecker("pingpong-abc" + GetUserId())
if singleinstancechecker.IsAnotherRunning() or len(params) > 1 and ('-r' in params or '-ra' in params):
    # Send command line to locally running abc_okc instance or distant abc_okc instance
    clientPassParam(arg)
else:
    # Launch first abc_okc single instance
    exe = arg[0] = join(dirname(arg[0]), u'abc_okc.exe')
    execv(exe, [u'"' + a + u'"' for a in arg])
