#########################################################################
# Author : Choopan RATTANAPOKA
# Description : Main ABC [Yet Another Bittorrent Client] python script.
#               You can run from source code by using :
#               >python abc_okc.py
#               Needs Python, wxPython, Pythonwin, Python Cryptography Toolkit
#               in order to run from source code.
# Updated and modified for ABC_OKC : Old King Cole
#
#########################################################################
import sys, gc
from utility import Stderr
sys.stderr = Stderr()
import wx
from threading import Thread, Timer, Event
from os import path, chdir, getcwd, remove, rename, startfile
from shutil import copyfile, move, copy
from urlparse import urlsplit, urlunsplit
from time import clock, sleep, strftime, localtime
from base64 import b32decode
from binascii import hexlify, unhexlify
from string import whitespace
from urllib import quote, unquote, unquote_plus
from win32file import _setmaxstdio

from BitTornado.zurllib import urlopen
from BitTornado.natpunch import setPeerID
from BitTornado.utility import setABCUtility
from BitTornado.__init__ import USERAGENT, setUserAgent, initPeerID

from utility import Utility
from interconn import ServerListener, clientPassParam
from filemanager import TorrentConfigFileManager
from scheduler import ABCScheduler
from abcengine import FILESEM
from abcdetailframe import ABCDetailFrame
from abcmetainfoframe import ABCMetaInfoFrame
from guimanager import GUIManager
from abc_find import ABCFindFrame
from abc_tweak import ABCTweakFrame
from btmaketorrentgui import DownloadInfo
from commandscheduler import CommandScheduler
from scanner import DirectoryScanner
from webservice import WebClient, WebListener
from Rss.html2text import html2text

from Dialogs.version import AboutMeDialog, CheckLatestVersionDialog
from Dialogs.abcoption import ABCOptionDialog
from Dialogs.templatedlg import TemplateDialog
from Dialogs.conlimiterdlg import ConLimiterDialog
from Dialogs.dhtaddnodedlg import DHTAddNodeDialog
from Dialogs.addpeerdlg import AddPeerDialog
from Dialogs.torrentparamsdlg import TorrentParametersDialog
from Dialogs.torrentrenamedlg import TorrentRenDialog
from Dialogs.setdestdlg import SetDestDialog
from Dialogs.webservicedlg import WebDialog
from Dialogs.scannerdlg import ScannerDialog
from Dialogs.commandschedulerdlg import CommandSchedulerDialog
from Dialogs.exitdlg import ExitDialog
from template import TemplateManager
from conlimiter import ConLimiterManager
from Rss.rss import RSSPanel
from commandline import getCommandLine, createProcess
from btmakemetafile import make_meta_data 

SHIFTNUMPAD = (wx.WXK_NUMPAD_INSERT, wx.WXK_NUMPAD_END, wx.WXK_NUMPAD_DOWN,
               wx.WXK_NUMPAD_PAGEDOWN, wx.WXK_NUMPAD_LEFT, wx.WXK_CLEAR,
               wx.WXK_NUMPAD_RIGHT, wx.WXK_NUMPAD_HOME, wx.WXK_NUMPAD_UP,
               wx.WXK_NUMPAD_PAGEUP)


################################################################
# Class : FileDropTarget
#
# To enable drag and drop for ABC list in main menu
#
################################################################
class FileDropTarget(wx.FileDropTarget):
    def __init__(self, obj): 
        # Initialize the wsFileDropTarget Object 
        wx.FileDropTarget.__init__(self) 
        # Store the Object Reference for dropped files 
        self.obj = obj
        self.utility = self.obj.utility

    def addNewProc(self, filesname):
        if len(filesname) > 1:
            multifile = True
            self.obj.queue.duptoroverwriteall = False
            self.obj.queue.duptorskipall = False
            self.obj.queue.dupdestkeepall = False
            self.obj.queue.dupdestskipall = False
        else:
            multifile = False
        for src in filesname:
            origfilename = path.split(src)[1]
            dest = self.utility.findUniqueFileName(path.join(self.utility.datapath, 'torrent', origfilename))
            if dest is None:
                continue
            try:
                copyfile(src, dest)
            except:
                continue
            self.obj.queue.addNewProc(dest, origfilename, False, multifile = multifile)

    def OnDropFiles(self, x, y, filesname):
        if self.obj.torrentlistloading:
            return
        self.obj.queue.invokeLater(self.addNewProc, [filesname])


##############################################################
# Class : ABCPanel
#
# Main ABC_OKC panel class
#
############################################################## 
class ABCPanel(wx.Panel):
    def __init__(self, parent, params, utility, guiman, tempmanager, conlimitermanager):
        wx.Panel.__init__(self, parent, -1, style = 0)
        self.parent = parent
        self.params = params
        self.dldlgsem = 0
        self.utility = utility
        self.localize = self.utility.lang.get
        self.guiman = guiman
        self.abcparams = utility.abcparams
        self.webparams = utility.webparams
        self.tempmanager = tempmanager
        self.conlimitermanager = conlimitermanager
        self.sbtimer = None
        # To disable the refresh of the selected torrent counter by select/unselect events when a torrent
        # is being moved or removed. In this case the refresh is manual at the end of operation.
        self.moveremove = False
        self.scannererror = False

        # Torrent list dragging mode :
        # 0 : no dragging
        # 1 : select torrent
        # 2 : move torrent
        # 3 : clear message
        self.listdraggingmode = 0

        # To store block of torrents marked with Ctrl + B
        self.markedTorrent = []

        # List row selected by a left or a right click
        self.selectedrow = -1

        # Bookmarks
        self.bookmarks = [int(self.abcparams['scrollpos' + str(i)]) for i in xrange(10)]

        # Flag for PauseAll toggle button
        self.pauseall = False

        # Flag true till ABC_OKC initialization is over
        self.initializing = True

        # Flag true till torrent list finishes loading
        self.torrentlistloading = True

        self.exiting = False

        self.torrentparamsdlg = None
        self.torrentrendlg = None
        self.setdestdlg = None
        self.abcaddpeerdlg = None

        self.firstdisplayRSS = True

        colSizer = wx.BoxSizer(wx.VERTICAL)
        panelsSizer = wx.BoxSizer(wx.VERTICAL)

        # List Control Display UI
        self.list = wx.ListCtrl(self, -1, style = wx.LC_REPORT | wx.LC_VRULES)
        if self.abcparams['listfontsize'] == '' or self.abcparams['listfontstyle'] == '' \
           or self.abcparams['listfontweight'] == '':
            listfont = self.list.GetFont()
            self.abcparams['listfont'] = listfont.GetFaceName()
            self.abcparams['listfontsize'] = str(listfont.GetPointSize())
            self.abcparams['listfontstyle'] = str(listfont.GetStyle())
            self.abcparams['listfontweight'] = str(listfont.GetWeight())
        else:
            self.list.SetFont(wx.Font(int(self.abcparams['listfontsize']), wx.DEFAULT, int(self.abcparams['listfontstyle']),
                                      int(self.abcparams['listfontweight']), faceName = self.abcparams['listfont']))
        self.dragdroplist = FileDropTarget(self)
        self.list.SetDropTarget(self.dragdroplist)
        self.scrolltimer = None

        # Read abc.ini for status display
        for rank in xrange(self.guiman.getNumCol()):
            self.list.InsertColumn(rank, self.guiman.getTextfromRank(rank))
            self.list.SetColumnWidth(rank, self.guiman.getValuefromRank(rank))

        panelsSizer.Add(self.list, 1, wx.EXPAND)

        # RSS panels
        self.rsspanel = RSSPanel(self, self.addTorrentURL)
        panelsSizer.Add(self.rsspanel, 1, wx.EXPAND)

        colSizer.Add(panelsSizer, 1, wx.EXPAND | wx.BOTTOM, 2)

        # Right click popup torrent menu
        self.initPopupMenu()

        # Right click popup sorting options menu
        self.initPopupSortingOpt()

        # Bottom buttons
        # A wx.ToolBar was not used for these buttons because buttons put inside a toolbar cannot be changed the way I wanted
        # (impossible to set the bitmap for selected state for example)
        self.bottompanel = wx.Panel(self, -1)
        self.bottomline = wx.FlexGridSizer(cols = 19, vgap = 3, hgap = 4)
        flat = (self.abcparams['flatbotbtn'] == '1')

        self.buttonup = self.utility.makeBitmapButton(self.bottompanel, 'moveup.bmp', self.localize('moveup'), self.onItemMoveUp, flat = flat)
        # Right and middle clicks are detected on up action because down seems to interfere with double click
        self.buttonup.Bind(wx.EVT_RIGHT_UP, self.onScrollUp)
        self.bottomline.Add(self.buttonup, 0, wx.ALIGN_CENTER)
        self.buttondown = self.utility.makeBitmapButton(self.bottompanel, 'movedown.bmp', self.localize('movedown'), self.onItemMoveDown, flat = flat)
        self.buttondown.Bind(wx.EVT_RIGHT_UP, self.onScrollDown)
        self.bottomline.Add(self.buttondown, 0, wx.ALIGN_CENTER)
        self.buttontop = self.utility.makeBitmapButton(self.bottompanel, 'movetop.bmp', self.localize('movetop'), self.onItemMoveTop, flat = flat)
        self.buttontop.Bind(wx.EVT_RIGHT_UP, self.onScrollTop)
        self.buttontop.Bind(wx.EVT_MIDDLE_UP, self.onRecallBookmark0)
        self.bottomline.Add(self.buttontop, 0, wx.ALIGN_CENTER)
        self.buttonmid = self.utility.makeBitmapButton(self.bottompanel, 'movemid.bmp', self.localize('movemid'), self.onItemMoveMiddle, flat = flat)
        self.buttonmid.Bind(wx.EVT_RIGHT_UP, self.onScrollMiddle)
        self.buttonmid.Bind(wx.EVT_MIDDLE_UP, self.onRecallBookmark0)
        self.bottomline.Add(self.buttonmid, 0, wx.ALIGN_CENTER)
        self.buttonbottom = self.utility.makeBitmapButton(self.bottompanel, 'movebottom.bmp', self.localize('movebottom'), self.onItemMoveBottom, flat = flat)
        self.buttonbottom.Bind(wx.EVT_RIGHT_UP, self.onScrollBottom)
        self.buttonbottom.Bind(wx.EVT_MIDDLE_UP, self.onRecallBookmark0)
        self.bottomline.Add(self.buttonbottom, 0, wx.ALIGN_CENTER)
        self.bottomline.Add(wx.StaticText(self.bottompanel, -1, '', size = (5, 0)))
        self.modebutton = self.utility.makeBitmapButton(self.bottompanel, 'modemanual.bmp', self.localize('mode'), self.onModeToggle,
                                                        toggle = True, bitmapselected = 'modeauto.bmp', bitmapselectedflat = 'modeauto_f.bmp', flat = flat)
        self.bottomline.Add(self.modebutton, 0, wx.ALIGN_CENTER)
        self.stoptrafficbutton = self.utility.makeBitmapButton(self.bottompanel, 'stoptraffic.bmp', self.localize('stoptraffic'), self.onStopTraffic, flat = flat)
        self.bottomline.Add(self.stoptrafficbutton, 0, wx.ALIGN_CENTER)
        self.stopallbutton = self.utility.makeBitmapButton(self.bottompanel, 'stopall.bmp', self.localize('stopall'), self.onStopAll, flat = flat)
        self.bottomline.Add(self.stopallbutton, 0, wx.ALIGN_CENTER)
        self.resumeallbutton = self.utility.makeBitmapButton(self.bottompanel, 'resumeall.bmp', self.localize('resumeall'), self.onResumeAll, flat = flat)
        self.bottomline.Add(self.resumeallbutton, 0, wx.ALIGN_CENTER)
        self.pauseallbutton = self.utility.makeBitmapButton(self.bottompanel, 'pauseall.bmp', self.localize('pauseall'), self.onPauseAll,
                                                            toggle = True, bitmapselected = 'pauseall_s.bmp', bitmapselectedflat = 'pauseall_s_f.bmp', flat = flat)
        self.bottomline.Add(self.pauseallbutton, 0, wx.ALIGN_CENTER)
        self.bottomline.Add(wx.StaticText(self.bottompanel, -1, '', size = (5, 0)))
        self.clearcompletedbutton = self.utility.makeBitmapButton(self.bottompanel, 'clearcompleted.bmp', self.localize('clearallover'), self.onClearAllOver, flat = flat)
        self.bottomline.Add(self.clearcompletedbutton, 0, wx.ALIGN_CENTER)
        self.bottomlinespace = wx.StaticText(self.bottompanel, -1, '', size = (5, 0))
        self.bottomline.Add(self.bottomlinespace)
        self.schedulerbutton = self.utility.makeBitmapButton(self.bottompanel, 'scheduleroff.bmp', self.localize('commandsched'),
                                                             self.onCommandSchedulerToggle, toggle = True, bitmapselected = 'scheduleron.bmp',
                                                             bitmapselectedflat = 'scheduleron_f.bmp', flat = flat)
        self.bottomline.Add(self.schedulerbutton, 0, wx.ALIGN_CENTER) 
        self.scannerbutton = self.utility.makeBitmapButton(self.bottompanel, 'scanneroff.bmp', self.localize('dirscanner'),
                                                           self.onScannerToggle, toggle = True, bitmapselected = 'scanneron.bmp',
                                                           bitmapselectedflat = 'scanneron_f.bmp', bitmapdetected = 'scannerdet.bmp',
                                                           bitmapdetectedflat = 'scannerdet_f.bmp', flat = flat)
        self.scannerbutton.Bind(wx.EVT_RIGHT_UP, self.onResetScanner)
        self.bottomline.Add(self.scannerbutton, 0, wx.ALIGN_CENTER) 
        self.webservicebutton = self.utility.makeBitmapButton(self.bottompanel, 'webservoff.bmp', self.localize('webservice'),
                                                              self.onWebServiceToggle, toggle = True, bitmapselected = 'webservon.bmp',
                                                              bitmapselectedflat = 'webservon_f.bmp', flat = flat)
        self.bottomline.Add(self.webservicebutton, 0, wx.ALIGN_CENTER) 
        self.bottomline.Add(wx.StaticText(self.bottompanel, -1, '', size = (5, 0)))

        self.nbselectedtorrentbox = wx.Panel(self.bottompanel, -1, style = wx.BORDER_STATIC)
        nbselectedtorrenthsizer = wx.BoxSizer(wx.HORIZONTAL)
        self.nbselected = wx.StaticText(self.nbselectedtorrentbox, -1, '0', size = (self.utility.selectedwidth, -1), style = wx.ALIGN_RIGHT | wx.ST_NO_AUTORESIZE)
        nbselectedtorrenthsizer.Add(self.nbselected, 0, wx.LEFT, 1)
        self.nbselectedtext = wx.StaticText(self.nbselectedtorrentbox, -1, self.localize('nbselectedtorrent'))
        nbselectedtorrenthsizer.Add(self.nbselectedtext, 0, wx.RIGHT, 1)
        nbselectedtorrentvsizer = wx.BoxSizer(wx.VERTICAL)
        nbselectedtorrentvsizer.Add(nbselectedtorrenthsizer, 0, wx.ALL, 1)
        self.nbselectedtorrentbox.SetSizerAndFit(nbselectedtorrentvsizer)

        self.bottomline.Add(self.nbselectedtorrentbox, 0, wx.ALIGN_CENTER_VERTICAL)

        # Apply bottom bar buttons configuration
        needslayout = False
        movetopbtnconf = self.abcparams['movemidbtn']
        if movetopbtnconf == "0":
            self.buttonmid.Hide()
            needslayout = True
        elif movetopbtnconf == "1":
            self.buttontop.Hide()
            needslayout = True
        if self.abcparams['stopresallbtn'] == '0':
            self.stopallbutton.Hide()
            self.resumeallbutton.Hide()
            needslayout = True
        if self.abcparams['stoptrafficbtn'] == '0':
            self.stoptrafficbutton.Hide()
            needslayout = True
        if self.abcparams['schedulerbtn'] == '0':
            self.schedulerbutton.Hide()
            needslayout = True
        if self.abcparams['scannerbtn'] == '0':
            self.scannerbutton.Hide()
            needslayout = True
        if self.abcparams['webservbtn'] == '0':
            self.webservicebutton.Hide()
            needslayout = True
        if needslayout:
            if self.abcparams['schedulerbtn'] == '0' and self.abcparams['scannerbtn'] == "0" \
               and self.abcparams['webservbtn'] == "0":
                self.bottomlinespace.Hide()
            else:
                self.bottomlinespace.Show()
            self.bottomline.Layout()

        self.bottompanel.SetAutoLayout(True)
        self.bottompanel.SetSizer(self.bottomline)
        self.bottompanel.Fit()

        colSizer.Add(self.bottompanel, 0, wx.ALL, 2)

        self.SetSizer(colSizer)
        self.SetAutoLayout(True)

        # Bitmap for mode button for pause mode under transfer volume supervisor control
        self.modebtnmanual2 = wx.Bitmap(path.join(self.utility.abcpath, 'icons', 'modemanual2.bmp'), wx.BITMAP_TYPE_BMP)
        self.modebtnmanual2.SetMask(wx.Mask(self.modebtnmanual2, wx.Colour(200, 200, 200)))

        # Scheduler
        self.queue = ABCScheduler(self, self.abcparams, self.guiman, tempmanager, conlimitermanager)

        # Command scheduler
        self.commandscheduler = CommandScheduler(self)

        # Directory scanner
        self.scanner = DirectoryScanner(self)

        # Set mode button in default correct state
        if self.abcparams['mode'] == '0':
            self.modebutton.SetValue(False)
        elif self.abcparams['mode'] == '1':
            self.modebutton.SetValue(True)
        else:
            self.modebutton.SetBitmapLabel(self.modebtnmanual2)
            self.modebutton.SetValue(False)
        self.list.SetFocus()

        # Set mode according to command line option
        try:
            a = self.params.index('-a')
        except:
            a = -1
        try:
            m = self.params.index('-m')
        except:
            pass
        else:
            if a == -1 or m < a:
                self.commandLineMode(self.params, m)

        # Start single instance server listener
        try:
            p = self.params.index('-p')
        except:
            pass
        else:
            if a == -1 or p < a:
                self.commandLinePort(self.params, p)
        thread = Thread(target = ServerListener().start, args = [self])
        thread.daemon = False
        thread.start()

        # Start remote server listener if ip is in parameters
        try:
            i = self.params.index('-i')
        except:
            pass
        else:
            if a == -1 or i < a:
                self.commandLineIP(self.params, i)
        if self.utility.remoteip is not None:
            thread = Thread(target = ServerListener(self.utility.remoteip).start, args = [self])
            thread.daemon = False
            thread.start()

        # Event
        self.list.Bind(wx.EVT_LIST_ITEM_RIGHT_CLICK, self.onItemSelected)
        self.list.Bind(wx.EVT_RIGHT_DOWN, self.onRightDown)
        self.list.Bind(wx.EVT_LEFT_DCLICK, self.onLeftDClick)
        self.list.Bind(wx.EVT_LIST_ITEM_SELECTED, self.onChangeSelected)
        self.list.Bind(wx.EVT_LIST_ITEM_DESELECTED, self.onChangeSelected)
        self.list.Bind(wx.EVT_MOUSEWHEEL, self.onMouseWheel)
        if self.abcparams['quickmetainfo'] == '1':
            self.list.Bind(wx.EVT_MIDDLE_DOWN, self.onQuickShowTorrentDetail)
        elif self.abcparams['quickmetainfo'] == '2':
            self.list.Bind(wx.EVT_MIDDLE_DCLICK, self.onQuickShowTorrentDetail)
        self.list.Bind(wx.EVT_LIST_COL_CLICK, self.onColLeftClick)
        self.list.Bind(wx.EVT_LIST_COL_RIGHT_CLICK, self.onColRightClick)
        self.list.Bind(wx.EVT_RIGHT_UP, self.onRightUp)
        self.list.Bind(wx.EVT_KEY_DOWN, self.onKeyInList)
        self.list.Bind(wx.EVT_LEFT_UP, self.onLeftUp)
        self.list.Bind(wx.EVT_LEFT_DOWN, self.onLeftDown)
        self.list.Bind(wx.EVT_LEAVE_WINDOW, self.onLeaveList)
        self.list.Bind(wx.EVT_ENTER_WINDOW, self.onEnterList)
        self.list.Bind(wx.EVT_LIST_BEGIN_DRAG, self.onLeftDragList)
        self.list.Bind(wx.EVT_LIST_BEGIN_RDRAG, self.onRightDragList)
        self.list.Bind(wx.EVT_MOTION, self.onMotionInList)
        self.nbselectedtorrentbox.Bind(wx.EVT_LEFT_DOWN, self.onLeftSelectedbox)
        self.nbselected.Bind(wx.EVT_LEFT_DOWN, self.onLeftSelectedbox)
        self.nbselectedtext.Bind(wx.EVT_LEFT_DOWN, self.onLeftSelectedbox)
        self.nbselectedtorrentbox.Bind(wx.EVT_MOUSEWHEEL, self.onMouseWheelSelectedBox)
        self.nbselectedtorrentbox.Bind(wx.EVT_RIGHT_DOWN, self.onRightSelectedbox)
        self.nbselected.Bind(wx.EVT_RIGHT_DOWN, self.onRightSelectedbox)
        self.nbselectedtext.Bind(wx.EVT_RIGHT_DOWN, self.onRightSelectedbox)
        self.modebutton.Bind(wx.EVT_RIGHT_UP, self.onRightModeButton)

        self.x = 0
        self.y = 0

        self.rsspanel.Hide()
        self.Layout()

    def commandLinePort(self, params, p):
        try:
            port = int(params[p + 1])
        except:
            return
        if port < 0 or port > 65535:
            return
        self.utility.mainport = port

    def commandLineIP(self, params, i):
        try:
            ip = params[i + 1]
        except:
            return None
        self.utility.remoteip = ip

    def commandLineMode(self, params, m):
        try:
            mode = params[m + 1]
        except:
            return
        if mode == 'auto':
            self.onModeToggle(mode = 1)
        elif mode == 'manual':
            self.onModeToggle(mode = 0)

    def commandLineAddTorrent(self, params, a):
        if self.torrentlistloading:
            return
        if len(params) < a + 2:
            if caller != 'qcl':
                dlg = wx.MessageDialog(self, self.localize('failedcantfindtorrent'),
                                       self.localize('invalidtorrent'),
                                       wx.ICON_ERROR)
                self.parent.restore()
                dlg.ShowModal()
                dlg.Destroy()
            return

        options = ''
        try:
            o = params.index('-o')
        except:
            options = ''
        else:
            if o < a:
                try:
                    options = params[o + 1]
                except:
                    options = ''
                else:
                    if options[0] == '-':
                        options = ''
            else:
                options = ''
        movetop = startnow = False
        status = 'queue'
        caller = ''
        prio = int(self.abcparams['defaultpriority'])
        if options:
            if 't' in options:
                movetop = True
            if 'q' in options:
                caller = 'qcl'
            if 'r' in options and 's' not in options:
                startnow = True
            elif 's' in options and 'r' not in options:
                status = 'stop'
            for c in options:
                if c.isdigit():
                    cint = int(c)
                    if 0 <= cint < 5:
                        prio = cint
                        break

        for src in params[a + 1:]:
            src_lower = src.lower()
            if src_lower.startswith(('magnet:', 'http:', 'https:')):
                # Magnet or HTTP URL
                self.getTorrentFromURL(src, prio = prio, status = status, movetop = movetop, startnow = startnow,
                                       showdownload = True, caller = caller)
            else:
                # File
                origfilename = path.split(src)[1]
                dest = self.utility.findUniqueFileName(path.join(self.utility.datapath, 'torrent', origfilename), src = caller)
                if dest is None:
                    continue
                try:
                    copyfile(src, dest)
                except:
                    if caller != 'qcl':
                        dlg = wx.MessageDialog(self, origfilename + '\n' + self.localize('failedcantloadtorrent'),
                                               self.localize('invalidtorrent'),
                                               wx.ICON_ERROR)
                        self.parent.restore()
                        dlg.ShowModal()
                        dlg.Destroy()
                    continue
                self.queue.addNewProc(dest, origfilename, False, caller = caller, prio = prio, status = status,
                                      movetop = movetop, startnow = startnow)

    def commandLineCommand(self, params, c):
        if self.torrentlistloading:
            return
        try:
            command = params[c + 1]
        except:
            return
        if command == 'stoptraffic':
            self.onModeToggle(mode = 0, queue = 1)
        elif command == 'pauseall':
            self.onPauseAll(pause = 1)
        elif command == 'unpauseall':
            self.onPauseAll(pause = 0)
        elif command == 'stopall':
            self.onStopAll()
        elif command == 'resumeall':
            self.onResumeAll()
        elif command == 'quit':
            self.parent.onMenuExit(silent = True)

    def onChangeSelected(self, event):
        if not self.moveremove:
            self.nbselected.SetLabel(str(self.list.GetSelectedItemCount()))

    def onLeftSelectedbox(self, event):
        if wx.Window.FindFocus() == self.nbselectedtorrentbox:
            self.list.SetFocus()
        else:
            self.nbselectedtorrentbox.SetFocus()

    def onMouseWheelSelectedBox(self, event):
        if self.list.GetItemCount():
            if event.GetWheelRotation() > 0:
                tobeshown = self.list.GetNextItem(self.list.GetTopItem(), wx.LIST_NEXT_ABOVE, wx.LIST_STATE_SELECTED)
                if tobeshown == -1:
                    lasttor = self.list.GetItemCount() - 1
                    if self.list.IsSelected(lasttor):
                        tobeshown = lasttor
                    else:
                        tobeshown = self.list.GetNextItem(lasttor, wx.LIST_NEXT_ABOVE, wx.LIST_STATE_SELECTED)
            else:
                tobeshown = self.list.GetNextItem(self.list.GetTopItem() + self.list.GetCountPerPage() - 1, wx.LIST_NEXT_ALL, wx.LIST_STATE_SELECTED)
                if tobeshown == -1:
                    tobeshown = self.list.GetNextItem(-1, wx.LIST_NEXT_ALL, wx.LIST_STATE_SELECTED)
            if tobeshown != -1:
                self.list.EnsureVisible(tobeshown)

    def onRightSelectedbox(self, event):
        for index in self.getSelected():
            self.list.SetItemState(index, 0, wx.LIST_STATE_SELECTED)

    def onLeftDClick(self, event):
        event.Skip()
        clickpoint = event.GetPosition()
        if self.abcparams['centerquickdetails'] == '0':
            position = clickpoint + self.parent.GetPosition()
            center = False
        elif self.abcparams['centerquickdetails'] == '1':
            position = self.list.ClientToScreen(clickpoint)
            center = True
        else:
            position = -1
            center = False
        self.commandfromlist = True
        self.onDetails(event, position = position, centeratpointer = center)
    
    def onMouseWheel(self, event):
        if not event.LeftIsDown() and not event.ControlDown() and not event.ShiftDown():
            event.Skip()
            return
        if event.GetWheelRotation() > 0:
            direction = 1
        else:
            direction = -1
        if event.ShiftDown():
            pointedindex = self.list.HitTest(wx.Point(event.GetX(), event.GetY()))[0]
            if pointedindex >= 0:
                selected = [pointedindex]
            else:
                selected = []
        else:
            selected = self.getSelected()
        if selected:
            self.onIncDecPriority(selected, direction)

    def onLeftDragList(self, event):
        if self.abcparams['rubmessages'] == '1' and self.abcparams['rubmsgbutton'] == '0'\
           and self.utility.getListClickedColumn(self.list, self.x) == self.guiman.getRankfromID(13):
            return
        if self.abcparams['mousemode'] == '0':
            self.listdraggingmode = 2
        else:
            self.listdraggingmode = 1

    def onRightDragList(self, event):
        if self.abcparams['rubmessages'] == '1' and self.abcparams['rubmsgbutton'] == '1'\
           and self.utility.getListClickedColumn(self.list, self.x) == self.guiman.getRankfromID(13):
            return
        if self.abcparams['mousemode'] == '0':
            self.listdraggingmode = 1
        else:
            self.listdraggingmode = 2

    def onMotionInList(self, event):
        pos = event.GetPosition()
        self.pointedrow = self.list.HitTest(pos)[0]

        # List scrolling
        if self.utility.scrolldelay and self.listdraggingmode:
            topitem = self.list.GetTopItem()
            botitem = max(topitem + self.list.GetCountPerPage() - 1, 0)
            if self.pointedrow == topitem:
                if not self.scrolltimer:
                    self.scrolltimer = Timer(self.utility.scrolldelay, self.queue.invokeLater, [self.scrollList, [1, self.pointedrow]])
                    self.scrolltimer.start()
            elif self.pointedrow >= botitem:
                # Scroll if over last whole whole cell displayed or last cell partially displayed
                if not self.scrolltimer:
                    self.scrolltimer = Timer(self.utility.scrolldelay, self.queue.invokeLater, [self.scrollList, [-1, self.pointedrow - (self.pointedrow > botitem)]])
                    self.scrolltimer.start()
            elif self.scrolltimer:
                self.scrolltimer.cancel()
                self.scrolltimer = None

        # Row number in activity cell
        if self.utility.getListClickedColumn(self.list, pos[0]) == self.guiman.getRankfromID(25):
            if self.pointedrow >= 0:
                self.list.SetToolTipString(str(self.pointedrow + 1))
            else:
                self.list.SetToolTipString('')
        else:
            self.list.SetToolTipString('')
            # pointedrow is set to -1 if mouse not in activity cell
            self.pointedrow = -1
        event.Skip()

    def scrollList(self, dir, row):
        if self.scrolltimer:
            row -= dir
            if 0 <= row < self.list.GetItemCount():
                # List scrolling
                self.list.EnsureVisible(row)
                # Row number in activity cell (must be updated because of list scrolling behind the mouse)
                if self.pointedrow >= 0:
                    self.pointedrow -= dir
                    self.list.SetToolTipString(str(self.pointedrow + 1))
                self.scrolltimer = Timer(self.utility.scrolldelay, self.queue.invokeLater, [self.scrollList, [dir, row]])
                self.scrolltimer.start()

    def initDraggingForClearing(self, index):
        # Init mouse operation for clearing messages in list (first click)
        if index >= 0:
            self.listdraggingmode = 3
            self.firstmessage = self.queue.proctab[index]

    def endDraggingForSelecting(self, index):
        self.listdraggingmode = 0
        if self.scrolltimer:
            self.scrolltimer.cancel()
            self.scrolltimer = None
        if index >= 0 and self.selectedrow >= 0:
            if index > self.selectedrow:
                dir = 1
            else:
                dir = -1
            for i in xrange(self.selectedrow + dir, index + dir, dir):
                self.list.Select(i)

    def endDraggingForMoving(self, index):
        self.listdraggingmode = 0
        if self.scrolltimer:
            self.scrolltimer.cancel()
            self.scrolltimer = None
        if self.torrentlistloading:
            return
        selected = self.getSelected(True)
        if index >= 0:
            if selected and index > self.selectedrow:
                index += 1
            self.itemMoveRow(None, index)

    def endDraggingForClearing(self, index):
        self.listdraggingmode = 0
        if self.scrolltimer:
            self.scrolltimer.cancel()
            self.scrolltimer = None
        if index >= 0:
            try:
                indexfirstmessage = self.queue.proctab.index(self.firstmessage)
            except:
                return
            if index > indexfirstmessage:
                dir = 1
            else:
                dir = -1
            self.onClearMessages(indexlist = xrange(indexfirstmessage, index + dir, dir))

    def onRightDown(self, event):
        self.x, self.y = event.GetPosition()
        self.selectedrow = self.list.HitTest((self.x, self.y))[0]
        if self.selectedrow >= 0:
            if self.abcparams['rubmessages'] == '1' and self.abcparams['rubmsgbutton'] == '1'\
               and self.utility.getListClickedColumn(self.list, self.x) == self.guiman.getRankfromID(13):
                self.initDraggingForClearing(self.selectedrow)
            else:
                event.Skip()

    def onRightUp(self, event):
        if event.LeftIsDown():
            # Show torrent parameters dialog
            self.windowparent = self
            self.commandfromlist = True
            self.onLocalSetting()
        else:
            index = self.list.HitTest((event.GetX(), event.GetY()))[0]
            if self.abcparams['rubmessages'] == '1' and self.abcparams['rubmsgbutton'] == '1'\
               and self.utility.getListClickedColumn(self.list, event.GetX()) == self.guiman.getRankfromID(13):
                if self.listdraggingmode == 3:
                    self.endDraggingForClearing(index)
            elif self.abcparams['mousemode'] == '0':
                if self.listdraggingmode == 1:
                    self.endDraggingForSelecting(index)
            else:
                if self.listdraggingmode == 2:
                    self.endDraggingForMoving(index)

    def onLeftDown(self, event):
        self.x, self.y = event.GetPosition()
        self.selectedrow = self.list.HitTest((self.x, self.y))[0]
        if self.selectedrow >= 0:
            if self.abcparams['rubmessages'] == '1' and self.abcparams['rubmsgbutton'] == '0'\
               and self.utility.getListClickedColumn(self.list, self.x) == self.guiman.getRankfromID(13):
                self.initDraggingForClearing(self.selectedrow)
            else:
                event.Skip()
        else:
            for index in self.getSelected():
                self.list.SetItemState(index, 0, wx.LIST_STATE_SELECTED)

    def onLeftUp(self, event):
        index = self.list.HitTest((event.GetX(), event.GetY()))[0]
        if self.abcparams['rubmessages'] == '1' and self.abcparams['rubmsgbutton'] == '0'\
           and self.utility.getListClickedColumn(self.list, event.GetX()) == self.guiman.getRankfromID(13):
            if self.listdraggingmode == 3:
                self.endDraggingForClearing(index)
        elif self.abcparams['mousemode'] == '0':
            if self.listdraggingmode == 2:
                self.endDraggingForMoving(index)
        elif self.listdraggingmode == 1:
            self.endDraggingForSelecting(index)

    def onLeaveList(self, event):
        # To handle dragging the mouse out of the list with the left or right button pressed
        if self.scrolltimer:
            self.scrolltimer.cancel()
            self.scrolltimer = None
        event.Skip()

    def onEnterList(self, event):
        # To handle dragging the mouse back into the list without the left or right button pressed
        if self.listdraggingmode and not (event.LeftIsDown() or event.RightIsDown()) :
            self.listdraggingmode = 0
            if self.scrolltimer:
                self.scrolltimer.cancel()
                self.scrolltimer = None
        event.Skip()

    def onQuickShowTorrentDetail(self, event):
        if event.LeftIsDown():
            return
        clickpoint = event.GetPosition()
        clickedindex = self.list.HitTest(clickpoint)[0]
        if clickedindex >= 0:
            if self.abcparams['centerquickdetails'] == '0':
                position = clickpoint + self.parent.GetPosition()
                center = False
            elif self.abcparams['centerquickdetails'] == '1':
                position = self.list.ClientToScreen(clickpoint)
                center = True
            else:
                position = -1
                center = False
            self.commandfromlist = True
            self.onTorrentInfo(indexlist = [clickedindex], position = position, centeratpointer = center)

    def onItemSelected(self, event):
        if wx.GetKeyState(wx.WXK_CONTROL) or wx.GetKeyState(wx.WXK_SHIFT) or wx.GetKeyState(wx.WXK_ALT):
            return
        if self.abcparams['rubmessages'] == '0' or self.abcparams['rubmsgbutton'] == '0' \
           or self.utility.getListClickedColumn(self.list, self.x) != self.guiman.getRankfromID(13):
            self.listdraggingmode = 0
            if self.makePopupMenu(self, True):
                # Popup the menu. If an item is selected then its handler
                # will be called before PopupMenu returns.
                self.PopupMenu(self.popupmenu, self.ScreenToClient(self.list.ClientToScreen((self.x, self.y))))

    def onChangeSortingLockOpt(self, event):
        self.abcparams['sortinglock'] = str(event.GetId() - 950)

    def initPopupSortingOpt(self):
        self.popupsortingopt = wx.Menu(self.localize('sortinglockopt'))
        self.popupsortingopt.AppendRadioItem(950, self.localize('sortinglocknone'), "")
        self.popupsortingopt.AppendRadioItem(951, self.localize('sortinglockfin'), "")
        self.popupsortingopt.AppendRadioItem(952, self.localize('sortinglockcom'), "")
        self.popupsortingopt.AppendRadioItem(953, self.localize('sortinglockfincom'), "")
        self.Bind(wx.EVT_MENU, self.onChangeSortingLockOpt, id = 950, id2 = 953)

    def onColRightClick(self, event):
        if wx.GetKeyState(wx.WXK_CONTROL):
            # Popup menu to choose  finished and completed torrents behaviour when sorting
            self.popupsortingopt.Check(int(self.abcparams['sortinglock']) + 950, True)
            self.PopupMenu(self.popupsortingopt, self.ScreenToClient(self.list.ClientToScreen(event.GetPosition())))
        elif self.utility.getListClickedColumn(self.list, event.GetPosition()[0]) == self.guiman.getRankfromID(13):
            # Clear message column
            # Call to utility.getListClickedColumn because of the EVT_LIST_COL_RIGHT_CLICK bug that does not take into account the
            # horizontal scroll of the list
            self.onClearMessages(clearall = True)

    def onColLeftClick(self, event):
        col = event.m_col
        shift = wx.GetKeyState(wx.WXK_SHIFT)
        if wx.GetKeyState(wx.WXK_CONTROL):
            # Sort by column content
            self.queue.sortColumn(col, shift)
        elif col == self.guiman.getRankfromID(4):
            # Rename torrent
            self.windowparent = self
            self.commandfromlist = True
            wx.CallAfter(self.onRenameTorrent, hittest = False)
        elif col == self.guiman.getRankfromID(5):
            # Open in Windows
            self.windowparent = self
            self.commandfromlist = True
            wx.CallAfter(self.onOpenDest, shift = shift)
        #elif col == self.guiman.getRankfromID(7):
        #    # Sort by priority
        #    self.queue.sortColumn(col)
        elif col == self.guiman.getRankfromID(13):
            # Clear message
            self.windowparent = self
            self.commandfromlist = True
            self.onClearMessages()

    def initPopupMenu(self):
        # Init torrent right-click popup menu
        self.popupmenu = wx.Menu()
        self.popupmenu.AppendMenu(1000, ' ', wx.Menu(self.localize('popupheader')))

        self.popupmenu.AppendSeparator()

        self.Bind(wx.EVT_MENU, self.onFastResume, id = 1001)
        self.popupmenu.Append(1001, self.localize('rfastresume'))
        self.Bind(wx.EVT_MENU, self.onResume, id = 1002)
        self.popupmenu.Append(1002, self.localize('rresume'))
        self.Bind(wx.EVT_MENU, self.onOnlyGetMetadata, id = 1046)
        self.popupmenu.Append(1046, self.localize('rgetmetadata'))
        self.Bind(wx.EVT_MENU, self.onStop, id = 1003)
        self.popupmenu.Append(1003, self.localize('rstop'))
        self.Bind(wx.EVT_MENU, self.onPause, id = 1004)
        self.popupmenu.Append(1004, self.localize('rpause'))
        self.Bind(wx.EVT_MENU, self.onQueue, id = 1005)
        self.popupmenu.Append(1005, self.localize('rqueue'))
        self.Bind(wx.EVT_MENU, self.onStandby, id = 1006)
        self.popupmenu.Append(1006, self.localize('rstandby'))
        self.Bind(wx.EVT_MENU, self.onSuperSeed, id = 1007)
        self.popupmenu.Append(1007, self.localize('rsuperseedmode'))

        compshutsubmenu = wx.Menu()
        self.Bind(wx.EVT_MENU, self.onCompleteShutDownAdd, id = 1009)
        compshutsubmenu.Append(1009, self.localize('rcompshutadd'))
        self.Bind(wx.EVT_MENU, self.onCompleteShutDownShow, id = 1010)
        compshutsubmenu.Append(1010, ' ')
        compshutseedingtimesubmenu = wx.Menu()
        self.Bind(wx.EVT_MENU, self.onCompleteShutDownSeedingTime, id = 909, id2 = 914)
        compshutseedingtimesubmenu.Append(909, self.localize('compshutseedingtime0'), '', wx.ITEM_RADIO)
        compshutseedingtimesubmenu.Append(910, self.localize('compshutseedingtime1'), '', wx.ITEM_RADIO)
        compshutseedingtimesubmenu.Append(911, self.localize('compshutseedingtime2'), '', wx.ITEM_RADIO)
        compshutseedingtimesubmenu.Append(912, self.localize('compshutseedingtime3'), '', wx.ITEM_RADIO)
        compshutseedingtimesubmenu.Append(913, self.localize('compshutseedingtime4'), '', wx.ITEM_RADIO)
        compshutseedingtimesubmenu.Append(914, self.localize('compshutseedingtime5'), '', wx.ITEM_RADIO)
        compshutsubmenu.AppendMenu(1011, self.localize('rcompshutseedingtime'), compshutseedingtimesubmenu)
        self.Bind(wx.EVT_MENU, self.onCompleteShutDownReset, id = 1012)
        compshutsubmenu.Append(1012, self.localize('rcompshutreset'))
        self.popupmenu.AppendMenu(1008, self.localize('rcompshut'), compshutsubmenu)

        prioritysubmenu = wx.Menu()
        self.Bind(wx.EVT_MENU, self.onChangePrio, id = 904, id2 = 908)
        prioritysubmenu.Append(904, self.localize('highest'), '', wx.ITEM_RADIO)
        prioritysubmenu.Append(905, self.localize('high'), '', wx.ITEM_RADIO)
        prioritysubmenu.Append(906, self.localize('normal'), '', wx.ITEM_RADIO)
        prioritysubmenu.Append(907, self.localize('low'), '', wx.ITEM_RADIO)
        prioritysubmenu.Append(908, self.localize('lowest'), '', wx.ITEM_RADIO)
        self.popupmenu.AppendMenu(1013, self.localize('rpriosetting'), prioritysubmenu)

        self.Bind(wx.EVT_MENU, self.onCheck, id = 1014)
        self.popupmenu.Append(1014, self.localize('rcheck'))
        self.Bind(wx.EVT_MENU, self.onClearMessages, id = 1015)
        self.popupmenu.Append(1015, self.localize('rclearmessage'))

        self.popupmenu.AppendSeparator()

        self.Bind(wx.EVT_MENU, self.onRemove, id = 1016)
        self.popupmenu.Append(1016, self.localize('rremovetorrent'))
        self.Bind(wx.EVT_MENU, self.onRemoveFile, id = 1017)
        self.popupmenu.Append(1017, self.localize('rremovetorrentandfile'))
        self.exportsubmenu = wx.Menu()
        self.Bind(wx.EVT_MENU, self.onCopyFromList, id = 1019)
        self.exportsubmenu.Append(1019, self.localize('rcopyfromlist'))
        self.Bind(wx.EVT_MENU, self.onExtractFromList, id = 1020)
        self.exportsubmenu.Append(1020, self.localize('rextractfromlist'))
        self.Bind(wx.EVT_MENU, self.onExtractFromListRemove, id = 1021)
        self.exportsubmenu.Append(1021, self.localize('rextractfromlistremove'))
        self.popupmenu.AppendMenu(1018, self.localize('rexportfromlist'), self.exportsubmenu)

        self.popupmenu.AppendSeparator()

        self.Bind(wx.EVT_MENU, self.onLocalSetting, id = 1022)
        self.popupmenu.Append(1022, self.localize('rlocalparamsetting'))
        self.Bind(wx.EVT_MENU, self.onRenameTorrent, id = 1023)
        self.popupmenu.Append(1023, self.localize('rrenametorrent'))
        self.Bind(wx.EVT_MENU, self.onFixLongNames, id = 1038)
        self.popupmenu.Append(1038, self.localize('rfixlongnames'))
        self.Bind(wx.EVT_MENU, self.onChangeDownloadDest, id = 1024)
        self.popupmenu.Append(1024, self.localize('rchangedownloaddest'))
        self.Bind(wx.EVT_MENU, self.onOpenDest, id = 1025)
        self.popupmenu.Append(1025, self.localize('ropendest'))

        self.popupmenu.AppendSeparator()

        self.Bind(wx.EVT_MENU, self.onDisplayScrape, id = 1026)
        self.popupmenu.Append(1026, self.localize('rcurrentseedpeer'))
        self.Bind(wx.EVT_MENU, self.onTorrentInfo, id = 1027)
        self.popupmenu.Append(1027, self.localize('rtorrentdetail'))
        self.Bind(wx.EVT_MENU, self.onDetails, id = 1028)
        self.popupmenu.Append(1028, self.localize('radvdetail'))

        self.advancedsubmenu = wx.Menu()
        self.Bind(wx.EVT_MENU, self.onManAnnounce, id = 1030)
        self.advancedsubmenu.Append(1030, self.localize('rmanannounce'))
        self.Bind(wx.EVT_MENU, self.onFinishAlloc, id = 1031)
        self.advancedsubmenu.Append(1031, self.localize('rfinishalloc'))
        self.Bind(wx.EVT_MENU, self.onResetSeedingRules, id = 1032)
        self.advancedsubmenu.Append(1032, self.localize('rresetseedtime'))
        self.Bind(wx.EVT_MENU, self.onAddPeer, id = 1033)
        self.advancedsubmenu.Append(1033, self.localize('raddpeer'))
        self.popupmenu.AppendMenu(1029, self.localize('radvanced'), self.advancedsubmenu)

        self.popupmenu.AppendSeparator()

        self.Bind(wx.EVT_MENU, self.onSortFinishedCompletedAtTop, id = 1034)
        self.popupmenu.Append(1034, self.localize('rsortfinishedcompletedattop'))
        self.Bind(wx.EVT_MENU, self.onSortFinishedAtTop, id = 1035)
        self.popupmenu.Append(1035, self.localize('rsortfinishedattop'))
        self.Bind(wx.EVT_MENU, self.onSortSelectedBlock, id = 1036)
        self.popupmenu.Append(1036, self.localize('rsortselectedblock'))

        self.popupmenu.AppendSeparator()

        self.Bind(wx.EVT_MENU, self.onResetListSortingCycle, id = 1037)
        self.popupmenu.Append(1037, self.localize('rresetlistsortingcycle'))

    def makePopupMenu(self, windowparent, commandfromlist):
        # Make torrent right-click menu
        self.windowparent = windowparent
        self.commandfromlist = commandfromlist
        torrent = self.queue.proctab[self.getTargetTorrents(hittest = True)[0]]
        if torrent.isbeingdeleted:
            return False

        self.templatesnothidden = [key for key in self.tempmanager.tempbyindex if not self.tempmanager.templates[key].hidden]
        tempsubmenu = wx.Menu(self.localize('popupheader'))
        i = 799
        for key in self.templatesnothidden[:100]:
            i += 1
            tempsubmenu.Append(i, key, self.tempmanager.templates[key].shortlabel, wx.ITEM_CHECK)
        self.Bind(wx.EVT_MENU, self.onSetTemplate, id = 800, id2 = i)
        self.popupmenu.DestroyId(1000)
        self.popupmenu.PrependMenu(1000, self.localize('popuptemp_b') + torrent.label + self.localize('popuptemp_e'),
                                   tempsubmenu)
        if torrent.label in self.templatesnothidden:
            tempsubmenu.Check(self.templatesnothidden.index(torrent.label) + 800, True)
        self.popupmenu.SetLabel(1010, self.localize('rcompshutshow')
                                + ' (' + str(len(self.queue.compshut)) + self.localize('rtorrents') + ')')
        self.popupmenu.Check(int(self.abcparams['compshutseedingtime']) + 909, True)
        self.popupmenu.Check(torrent.priority + 904, True)

        menuitemstobetoggled = [1000, 1001, 1002, 1006, 1008, 1014, 1016, 1017, 1020, 1021, 1022, 1023, 1024, 1033, 1034,
                                1035, 1036, 1037, 1038, 1046]
        for id in menuitemstobetoggled:
            self.popupmenu.Enable(id, not self.torrentlistloading)

        return True

    def onSetTemplate(self, event, indexlist = None, seltemplabel = None):
        if indexlist is None:
            seltemplabel = [self.templatesnothidden[event.GetId() - 800]]
            selected = self.getTargetTorrents()
        else:
            selected = indexlist
        rank = self.guiman.getRankfromID(24)
        for index in selected:
            torrent = self.queue.proctab[index]
            if torrent.abcengine and not torrent.abcengine.onlycheck:
                torrent.updateLimiters(-1)
            torrent.label = seltemplabel[-1]
            if torrent.abcengine and not torrent.abcengine.onlycheck:
                torrent.updateLimiters(1)
            if rank != -1:
                self.list.SetStringItem(index, rank, torrent.label)

        # Set parameters to torrent
        for templabel in seltemplabel:
            info = []
            seltemp = self.tempmanager.templates[templabel]
            if seltemp.templabelswitch:
                info.append(seltemp.shortlabel)
            else:
                info.append(None)
            if seltemp.tempdownloadswitch:
                info.append(seltemp.maxdownrate)
                info.append(seltemp.prioritizedown)
            else:
                info.extend(2 * [None])
            if seltemp.tempuploadswitch:
                info.append(seltemp.maxupload)
                info.append(seltemp.maxuprate)
                info.append(seltemp.prioritizeup)
            else:
                info.extend(3 * [None])
            if seltemp.tempseedingswitch:
                info.append(seltemp.uploadoption + 10 * int(seltemp.uploadtillcopycomplete))
                info.append(seltemp.uploadtimeh)
                info.append(seltemp.uploadtimem)
                info.append(seltemp.uploadratio)
            else:
                info.extend(4 * [None])
            if seltemp.temptimeoutswitch:
                info.append(seltemp.timeoutswitch)
                info.append(seltemp.timeoutaction)
                info.append(seltemp.timeoutwork)
                info.append(seltemp.timeoutworkdown)
                info.append(seltemp.timeoutworktrack)
                info.append(seltemp.timeoutseed)
                info.append(seltemp.timeoutseedup)
                info.append(seltemp.timeoutseedtrack)
                info.append(seltemp.timeouttracker)
                info.append(seltemp.timeoutdownload)
                info.append(seltemp.timeoutupload)
            else:
                info.extend(11 * [None])
            if seltemp.tempmoveswitch:
                info.append(seltemp.movefolder)
            else:
                info.append(None)
            if seltemp.temptrackerswitch:
                info.append(seltemp.exttracker)
                info.append(seltemp.exttrackerurl)
                info.append(seltemp.checkinttrackwait)
                info.append(seltemp.extrainttracker)
                info.append(seltemp.inttrackerurl)
            else:
                info.extend(5 * [None])

            self.queue.changeLocalInfo(selected, info)

        if indexlist is None:
            self.queue.invokeLater(self.queue.scheduler)

    def onSortFinishedCompletedAtTop(self, event):
        self.queue.sortColumn(restore = 11)

    def onSortFinishedAtTop(self, event):
        self.queue.sortColumn(restore = 12)

    def onSortSelectedBlock(self, event):
        shift = wx.GetKeyState(wx.WXK_SHIFT)
        col = self.utility.getListClickedColumn(self.list, self.x)
        clickedindex = self.selectedrow
        bb = clickedindex - 1
        while bb >= 0 and self.list.IsSelected(bb):
            bb -= 1
        bb += 1
        nbitem = self.list.GetItemCount()
        be = clickedindex + 1
        while be < nbitem and self.list.IsSelected(be):
            be += 1
        if be - bb > 1:
            self.queue.sortColumn(col = col, shift = shift, block = (bb, be))

    def onResetListSortingCycle(self, event = None):
        self.queue.sortdir = 2
        self.displayStatusTextTemp(self.localize('listsortingstatusunsorted'))

    def onDisplayScrape(self, event):
        ctrl = wx.GetKeyState(wx.WXK_CONTROL)
        selected = self.getTargetTorrents()
        if not selected:
            return
        if self.guiman.getRankfromID(14) == -1 or self.guiman.getRankfromID(15) == -1:
            # If #seeds or #peers are not displayed, only scrape first selected
            selected = selected[:1]
        warning = False
        for index in selected:
            torrent = self.queue.proctab[index]
            if torrent.scraping:
                continue
            if torrent.lastgetscrapemanual and clock() - torrent.lastgetscrapemanual < 60 and torrent.defaulttracker is not None:
                warning = True
                continue
            self.queue.getScrapeData(torrent, ctrlscrape = ctrl)
        if warning:
            if len(selected) == 1:
                dlg = wx.MessageDialog(self.windowparent, self.localize('warningscrape2')
                                       + self.localize('warningscrape3'), self.localize('abcokcwarning'), wx.ICON_WARNING)
            else:
                dlg = wx.MessageDialog(self.windowparent, self.localize('warningscrape1')
                                       + self.localize('warningscrape3'), self.localize('abcokcwarning'), wx.ICON_WARNING)
            dlg.ShowModal()
            dlg.Destroy()

    def onTorrentInfo(self, event = None, indexlist = None, position = None, centeratpointer = False):
        if indexlist == None:
            indexlist = self.getTargetTorrents()
        if len(indexlist) > 100:
            dlg = wx.MessageDialog(self.windowparent, self.localize('warningopenwindow'),
                                   self.localize('abcokcwarning'), wx.YES_NO | wx.ICON_EXCLAMATION)
            result = dlg.ShowModal()
            dlg.Destroy()
            if result == wx.ID_NO:
                return
        for index in indexlist:
            torrent = self.queue.proctab[index]
            if torrent.isbeingdeleted:
                continue
            if torrent.infowin is not None:
                if torrent.infowin.IsShown():
                    if torrent.infowin.IsIconized():
                        torrent.infowin.Iconize(False)
                    torrent.infowin.Raise()
                else:
                    if position == -1:
                        torrent.infowin.Centre()
                    else:
                        if position is None:
                            position = wx.DefaultPosition
                        if centeratpointer:
                            position = position - wx.Point(self.GetSizeTuple()[0] / 2, 10)
                        torrent.infowin.Move(position)
                    torrent.infowin.Show()
            else:
                torrent.infowin = ABCMetaInfoFrame(self, -1, '', self.utility,
                                                   index, position, (self.guiman.getMetaWidth(), self.guiman.getMetaHeight()),
                                                   centeratpointer = centeratpointer)
                if torrent.abcengine:
                    torrent.abcengine.infowin = torrent.infowin

    def onOpenDest(self, event = None, shift = None):
        if shift is None:
            shift = wx.GetKeyState(wx.WXK_SHIFT)
        for index in self.getTargetTorrents():
            torrent = self.queue.proctab[index]
            if not torrent.complete:
                # Display Warning file is not complete yet
                dlg = wx.MessageDialog(self.windowparent, torrent.name + '\n' + self.localize('warningopenfile'),
                                       self.localize('abcokcwarning'), wx.YES_NO | wx.ICON_EXCLAMATION)
                result = dlg.ShowModal()
                dlg.Destroy()
                if result == wx.ID_NO:
                    continue
            dest = self.utility.completePath(torrent.dest)
            error = False
            if not path.exists(dest):
                if torrent.status != 'finished':
                    error = True
                else:
                    dest = torrent.getFinalDest()
                    if not path.exists(dest):
                        error = True
            if error:
                dlg = wx.MessageDialog(self.windowparent, torrent.name + '\n' + self.localize('filenotfound'),
                                       self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
            else:
                if not shift and self.abcparams['altfilemanager']:
                    try:
                        dest = self.abcparams['altfilemanager'] % dest
                    except:
                        return
                    createProcess(dest)
                else:
                    startfile(dest)

    def onFixLongNames(self, event):
        if self.torrentlistloading:
            return
        indexlist = self.getTargetTorrents()
        if not indexlist:
            return
        selectedtorrents = []
        for index in indexlist:
            torrent = self.queue.proctab[index]
            if torrent.abcengine or torrent.ismovingdata or torrent.singlefile or torrent.ongoing is not None:
                dlg = wx.MessageDialog(self.windowparent, self.localize('errorfixlongnames'),
                                       self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return
            selectedtorrents.append(torrent)
        checkstatus = 0
        for torrent in selectedtorrents:
            # Call to checkFileNames and not only to longPathAutoFix because file name
            # constraints may have changed if Preferences/Misc./"Long path names" was
            # modified
            if not checkstatus or torrent in self.queue.proctab:
                if torrent.abcengine or torrent.ismovingdata:
                    continue
                checkstatus, showdetails = torrent.checkFileNames(self, lengthautofix = True)
                if not checkstatus or torrent in self.queue.proctab:
                    if torrent.infowin is not None:
                        torrent.infowin.filesname = torrent.getFileNames()
                        torrent.infowin.updateNames()
                        torrent.infowin.displayFileNameStatus()
                    elif showdetails:
                        torrent.infowin = ABCMetaInfoFrame(self, -1, '', self.utility,
                                                           torrent.index, -1,
                                                           (self.guiman.getMetaWidth(),
                                                           self.guiman.getMetaHeight()),
                                                           centeratpointer = False)

    def onChangeDownloadDest(self, event):
        if self.torrentlistloading:
            return
        indexlist = self.getTargetTorrents()
        if not indexlist:
            return
        for index in indexlist:
            torrent = self.queue.proctab[index]
            if torrent.abcengine  or torrent.ongoing is not None \
               or ((torrent.status == 'queue' or torrent.status == 'standby') and self.abcparams['mode'] == '1') \
               or torrent.ismovingdata:
                dlg = wx.MessageDialog(self.windowparent, self.localize('errorchangedestination'),
                                       self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return
        torrent = self.queue.proctab[self.getTargetTorrents(firstitemonly = True, hittest = True)[0]]
        # Pop-up file dialog or dir dialog for new destination
        self.setdestdlg = SetDestDialog(self.windowparent, -1, torrent, self.queue,
                                        self, self.commandfromlist and len(indexlist) > 1, torrent.name,
                                        desttype = torrent.isSingleFile())
        self.setdestdlg.ShowModal()
        x, y = self.setdestdlg.GetPositionTuple()
        w = self.setdestdlg.GetSizeTuple()[0]
        self.abcparams['abcsetdestdlgx'], self.abcparams['abcsetdestdlgy'] = str(x), str(y)
        self.abcparams['abcsetdestdlgw'] = str(w)
        self.setdestdlg.Destroy()
        self.setdestdlg = None

    def onRenameTorrent(self, event = None, hittest = True):
        if self.torrentlistloading:
            return
        indexlist = self.getTargetTorrents()
        if not indexlist:
            return
        multitorrent = self.commandfromlist and len(indexlist) > 1
        torrent = self.queue.proctab[self.getTargetTorrents(firstitemonly = True, hittest = hittest)[0]]
        self.torrentrendlg = TorrentRenDialog(self.windowparent, -1, torrent, self.queue,
                                              self, multitorrent)
        self.torrentrendlg.ShowModal()
        x, y = self.torrentrendlg.GetPositionTuple()
        w = self.torrentrendlg.GetSizeTuple()[0]
        self.abcparams['abcrentordlgx'], self.abcparams['abcrentordlgy'] = str(x), str(y)
        self.abcparams['abcrentordlgw'] = str(w)
        if multitorrent:
            self.abcparams['abcrentorappendnb'] = str(int(self.torrentrendlg.appendnumber.GetValue()))
        self.torrentrendlg.Destroy()
        self.torrentrendlg = None

    def onResetSeedingRules(self, event):
        # Reset to 0 the time the torrent has been seeding or to 0 the number of bytes it has been uploading,
        # according to seeding conditions setting
        ranketa = self.guiman.getRankfromID(8)
        rankulsize = self.guiman.getRankfromID(19)
        rankud = self.guiman.getRankfromID(12)
        rankst = self.guiman.getRankfromID(27)
        for index in self.getTargetTorrents():
            torrent = self.queue.proctab[index]
            if torrent.abcengine:
                torrent.abcengine.stopSeedingTimers(resettotalseeding = False)
                if torrent.uploadoption == 1 or torrent.uploadoption == 3:
                    torrent.seedingtime = 0.
                    # Update seeding time column
                    if rankst != -1:
                        self.list.SetStringItem(index, rankst, self.utility.time_value(0, seconds = False, maxvalue = False))
                if torrent.uploadoption == 2 or torrent.uploadoption == 3:
                    torrent.abcengine.oldupsize = -torrent.abcengine.newupsize
                    # Update UL size column
                    if rankulsize != -1:
                        if self.abcparams['displayunitsize'] == '1':
                            sizeunit = ' ' + self.utility.mb
                        else:
                            sizeunit = ''
                        self.list.SetStringItem(index, rankulsize, '0.00' + sizeunit)
                    # Update %U/D column
                    if rankud != -1:
                        if torrent.requestedsize <= 0:
                            self.list.SetStringItem(index, rankud, '999.9%')
                        else:
                            self.list.SetStringItem(index, rankud, '0.0%')
                    if torrent.detailwin is not None:
                        torrent.detailwin.updateSize()
                torrent.abcengine.countSeedingTimeLeft(clock())
                if torrent.complete:
                    # Update ETA column
                    if ranketa != -1:
                        self.list.SetStringItem(index, ranketa, self.localize('etaS') + " " +
                                                self.utility.eta_value(torrent.seedingtimeleft))
                torrent.abcengine.startSeedingTimers(resettotalseeding = False)
            else:
                if torrent.uploadoption == 1 or torrent.uploadoption == 3:
                    torrent.seedingtime = 0.
                    torrent.seedingtimeleft = torrent.uploadtimemax
                    # Update seeding time column
                    if rankst != -1:
                        self.list.SetStringItem(index, rankst, self.utility.time_value(0, maxvalue = False))
                if torrent.uploadoption == 2 or torrent.uploadoption == 3:
                    torrent.upsize = 0
                    # Update UL size column
                    if rankulsize != -1:
                        if self.abcparams['displayunitsize'] == '1':
                            sizeunit = ' ' + self.utility.mb
                        else:
                            sizeunit = ''
                        self.list.SetStringItem(index, rankulsize, '0.00' + sizeunit)
                    # Update %U/D column
                    if rankud != -1:
                        if torrent.requestedsize <= 0:
                            self.list.SetStringItem(index, rankud, '999.9%')
                        else:
                            self.list.SetStringItem(index, rankud, '0.0%')
                    if torrent.detailwin is not None:
                        torrent.detailwin.updateSize()

                # Init standby torrents to count seeding time if necessary
                if torrent.complete and torrent.status == 'standby' \
                   and self.abcparams['mode'] == '1' and self.utility.countsbasseed \
                   and (torrent.uploadoption == 1 or torrent.uploadoption == 3):
                    torrent.initStandbySeedingTime(clock())
                    
                if torrent.status == 'finished' and (torrent.uploadoption == 2 or
                                                     (torrent.uploadoption == 1 or torrent.uploadoption == 3) and
                                                     torrent.uploadtimemax):
                    torrent.status = 'completed'
                    torrent.displayStatus()
                    torrent.termevt = torrent.prevtermevt = ''
                    self.queue.torrentfinished -= 1
                    self.queue.updateRunningTorrentCounters()
                # Update ETA column
                if ranketa != -1 and torrent.complete and torrent.status != 'finished':
                    if torrent.uploadoption == 2:
                        self.list.SetStringItem(index, ranketa, self.localize('etaS') + "      ?")
                    elif torrent.uploadoption == 1 or torrent.uploadoption == 3:
                        self.list.SetStringItem(index, ranketa, self.localize('etaS') + " " +
                                                self.utility.eta_value(torrent.seedingtimeleft))

    def onManAnnounce(self, event):
        for index in self.getTargetTorrents():
            torrent = self.queue.proctab[index]
            if torrent.abcengine:
                torrent.abcengine.loadPeers()
                torrent.reannounce(force = True)

    def onFinishAlloc(self, event):
        for index in self.getTargetTorrents():
            self.queue.bgalloc(index)

    def getTargetTorrents(self, firstitemonly = False, hittest = False):
        if self.commandfromlist:
            if hittest and self.selectedrow >= 0:
                return [self.selectedrow]
            return self.getSelected(firstitemonly)
        else:
            return [self.windowparent.index]

    def getSelected(self, firstitemonly = False):
        selected = []
        index = self.list.GetNextItem(-1, wx.LIST_NEXT_ALL, wx.LIST_STATE_SELECTED)
        while index != -1:
            selected.append(index)
            if firstitemonly:
                return selected
            index = self.list.GetNextItem(index, wx.LIST_NEXT_ALL, wx.LIST_STATE_SELECTED)
        return selected

    def copyColToClip(self, colid = None):
        if colid == None:
            ranklist = xrange(self.guiman.getNumCol())
        else:
            rank = self.guiman.getRankfromID(colid)
            if rank == -1:
                return
            ranklist = [rank]
        selected = self.getSelected()
        if selected:
            texts = []
            for index in selected:
                texts.append('\t'.join([self.list.GetItem(index, rank).GetText() for rank in ranklist])) 
            if wx.TheClipboard.Open():
                wx.TheClipboard.SetData(wx.TextDataObject('\r\n'.join(texts)))
                wx.TheClipboard.Close()

    def onKeyInList(self, event):
        numlock = wx.GetKeyState(wx.WXK_NUMLOCK)
        keycode = event.GetKeyCode()
        shift = event.ShiftDown()
        alt = event.AltDown()
        if keycode == wx.WXK_RETURN:
            # Open completed torrent
            self.windowparent = self
            self.commandfromlist = True
            self.onOpenDest(shift = shift)
        elif event.ControlDown():
            if not alt:
                if numlock and keycode == wx.WXK_NUMPAD_DECIMAL or keycode == ord('.'):
                    self.onResetListSortingCycle()
                elif keycode == ord('a') or keycode == ord('A'):
                    # Select all torrents
                    for index in xrange(self.list.GetItemCount()):
                        self.list.Select(index)
                elif keycode == self.utility.selinvert1 or keycode == self.utility.selinvert2:
                    # Invert torrent selection
                    for index in xrange(self.list.GetItemCount()):
                        self.list.SetItemState(index, 4 - self.list.GetItemState(index, wx.LIST_STATE_SELECTED), wx.LIST_STATE_SELECTED)
                elif keycode == ord('z') or keycode == ord('Z'):
                    # Unselect all torrents
                    for index in xrange(self.list.GetItemCount()):
                        self.list.Select(index, 0)
                elif keycode == ord('c') or keycode == ord('C'):
                    # Select completed torrents
                    for index in self.getSelected():
                        self.list.SetItemState(index, 0, wx.LIST_STATE_SELECTED)
                    for index in xrange(len(self.queue.proctab)):
                        torrent = self.queue.proctab[index]
                        if torrent.status == 'completed' and not torrent.abcengine:
                            self.list.Select(index)
                elif keycode == ord('d') or keycode == ord('D'):
                    # Select seeding torrents
                    for index in self.getSelected():
                        self.list.SetItemState(index, 0, wx.LIST_STATE_SELECTED)
                    for index in xrange(len(self.queue.proctab)):
                        torrent = self.queue.proctab[index]
                        if torrent.status == 'completed' and torrent.abcengine:
                            self.list.Select(index)
                elif keycode == ord('f') or keycode == ord('F'):
                    # Select finished torrents
                    for index in self.getSelected():
                        self.list.SetItemState(index, 0, wx.LIST_STATE_SELECTED)
                    for index in xrange(len(self.queue.proctab)):
                        if self.queue.proctab[index].status == 'finished':
                            self.list.Select(index)
                elif keycode == ord('i') or keycode == ord('I'):
                    # Select torrents with message identical to the first selected one
                    selected = self.getSelected()
                    if not selected:
                        return
                    messagefirstchar = self.utility.timestamplen + self.utility.messageheaderlen
                    firstmessage = self.queue.proctab[selected[0]].message[messagefirstchar:]
                    for index in selected:
                        self.list.SetItemState(index, 0, wx.LIST_STATE_SELECTED)
                    index = 0
                    for torrent in self.queue.proctab:
                        if torrent.message[messagefirstchar:] == firstmessage:
                            self.list.Select(index)
                        index += 1
                elif keycode == ord('o') or keycode == ord('O'):
                    # Select on-hold torrents
                    for index in self.getSelected():
                        self.list.SetItemState(index, 0, wx.LIST_STATE_SELECTED)
                    for index in xrange(len(self.queue.proctab)):
                        if self.queue.proctab[index].status == 'onhold':
                            self.list.Select(index)
                elif keycode == ord('p') or keycode == ord('P'):
                    # Select paused torrents
                    for index in self.getSelected():
                        self.list.SetItemState(index, 0, wx.LIST_STATE_SELECTED)
                    for index in xrange(len(self.queue.proctab)):
                        if self.queue.proctab[index].status == 'pause':
                            self.list.Select(index)
                elif keycode == ord('q') or keycode == ord('Q'):
                    # Select queued torrents
                    for index in self.getSelected():
                        self.list.SetItemState(index, 0, wx.LIST_STATE_SELECTED)
                    for index in xrange(len(self.queue.proctab)):
                        if self.queue.proctab[index].status == 'queue':
                            self.list.Select(index)
                elif keycode == ord('r') or keycode == ord('R'):
                    # Select running torrents
                    for index in self.getSelected():
                        self.list.SetItemState(index, 0, wx.LIST_STATE_SELECTED)
                    for index in xrange(len(self.queue.proctab)):
                        torrent = self.queue.proctab[index]
                        stat = torrent.status
                        if stat == 'working' or (stat == 'completed' and torrent.abcengine) or stat == 'pause' or stat == 'onhold':
                            self.list.Select(index)
                elif keycode == ord('s') or keycode == ord('S'):
                    # Select stopped torrents
                    for index in self.getSelected():
                        self.list.SetItemState(index, 0, wx.LIST_STATE_SELECTED)
                    for index in xrange(len(self.queue.proctab)):
                        if self.queue.proctab[index].status == 'stop':
                            self.list.Select(index)
                elif keycode == ord('u') or keycode == ord('U'):
                    # Select unfinished torrents (Torrents with 100% but not finished)
                    for index in self.getSelected():
                        self.list.SetItemState(index, 0, wx.LIST_STATE_SELECTED)
                    for index in xrange(len(self.queue.proctab)):
                        torrent = self.queue.proctab[index]
                        if torrent.complete and torrent.status != 'finished':
                            self.list.Select(index)
                elif keycode == ord('w') or keycode == ord('W'):
                    # Select working torrents
                    for index in self.getSelected():
                        self.list.SetItemState(index, 0, wx.LIST_STATE_SELECTED)
                    for index in xrange(len(self.queue.proctab)):
                        if self.queue.proctab[index].status == 'working':
                            self.list.Select(index)
                elif keycode == self.utility.selblock1 or keycode == self.utility.selblock2:
                    # Mark block of selected torrents
                    self.markedTorrent = [self.queue.proctab[index] for index in self.getSelected()]
                    # Copy all columns
                    self.copyColToClip()
                    self.displayStatusTextTemp(self.localize('selectedrowssavedandcopied'))
                elif keycode == ord('m') or keycode == ord('M'):
                    # Copy message
                    self.copyColToClip(13)
                    self.displayStatusTextTemp(self.localize('selectedmessagescopied'))
                elif keycode == ord('n') or keycode == ord('N'):
                    # Copy torrent name
                    self.copyColToClip(4)
                    self.displayStatusTextTemp(self.localize('selectednamescopied'))
                elif keycode == ord('t') or keycode == ord('T'):
                    # Copy torrent file name
                    self.copyColToClip(21)
                    self.displayStatusTextTemp(self.localize('selectedfilenamescopied'))
                elif keycode == ord('v') or keycode == ord('V'):
                    # Move block of torrents marked with Ctrl + B
                    if self.torrentlistloading or not self.markedTorrent:
                        return
                    selected = self.getSelected(True)
                    if not selected:
                        return
                    here = selected[0]
                    indexlist = []
                    for torrent in self.markedTorrent:
                        if torrent not in self.queue.proctab:
                            continue
                        indexlist.append(torrent.index)
                    if not indexlist:
                        return
                    if here > indexlist[0]:
                        here += 1
                    self.itemMoveRow(indexlist, here)
                    self.markedTorrent = []
                    self.displayStatusTextTemp(self.localize('savedrowsmoved'))
                elif numlock and wx.WXK_NUMPAD0 <= keycode <= wx.WXK_NUMPAD9 \
                     or not shift and (keycode == wx.WXK_UP or keycode == wx.WXK_DOWN):
                    # Scroll to bookmark
                    if keycode == wx.WXK_UP:
                        mem = 0
                    elif keycode == wx.WXK_DOWN:
                        mem = 1
                    else:
                        mem = keycode - wx.WXK_NUMPAD0
                    self.recallBookmark(mem)
                elif numlock and keycode == wx.WXK_NUMPAD_DELETE \
                     or not shift and keycode == wx.WXK_BACK:
                    # Undo restoring list order 0-9
                    if self.queue.sortColumn(restore = 10):
                        self.displayStatusTextTemp(self.localize('orderrestoredundo'))
                    else:
                        self.displayStatusTextTemp(self.localize('nothingtorestore'))
                elif numlock and keycode in SHIFTNUMPAD \
                     or not shift and (keycode == wx.WXK_LEFT or keycode == wx.WXK_RIGHT):
                    # Restore list order
                    if keycode == wx.WXK_LEFT:
                        mem = 0
                    elif keycode == wx.WXK_RIGHT:
                        mem = 1
                    else:
                        mem = SHIFTNUMPAD.index(keycode)
                    # Save current order for undo
                    for torrent in self.queue.proctab:
                        torrent.restoreindexundo = torrent.index
                    if self.queue.sortColumn(restore = mem):
                        self.displayStatusTextTemp(self.localize('orderrestored') % mem)
                    else:
                        self.displayStatusTextTemp(self.localize('noorder') % mem)
                else:
                    event.Skip()
            else:
                event.Skip()
        elif alt and numlock and wx.WXK_NUMPAD0 <= keycode <= wx.WXK_NUMPAD9 \
             or not alt and shift and (keycode == wx.WXK_UP or keycode == wx.WXK_DOWN):
            # Save bookmark
            if self.list.GetItemCount() > 0:
                if keycode == wx.WXK_UP:
                    mem = 0
                elif keycode == wx.WXK_DOWN:
                    mem = 1
                else:
                    mem = keycode - wx.WXK_NUMPAD0
                self.bookmarks[mem] = self.list.GetTopItem()
                self.displayStatusTextTemp(self.localize('bookmarksaved') % mem)
        elif alt and numlock and keycode in SHIFTNUMPAD \
             or not alt and shift and (keycode == wx.WXK_LEFT or keycode == wx.WXK_RIGHT):
            # Save list order
            if keycode == wx.WXK_LEFT:
                mem = 0
            elif keycode == wx.WXK_RIGHT:
                mem = 1
            else:
                mem = SHIFTNUMPAD.index(keycode)
            for torrent in self.queue.proctab:
                torrent.restoreindex[mem] = torrent.index
            self.displayStatusTextTemp(self.localize('ordersaved') % mem)
        else:
            event.Skip()

    def displayStatusTextTemp(self, statustext):
        try:
            self.sbtimer.cancel()
        except:
            pass
        self.parent.SetStatusBarPane(-1)
        self.parent.abc_sb.SetStatusText(statustext)
        self.sbtimer = Timer(2, self.clearStatusText, [statustext])
        self.sbtimer.start()

    def clearStatusText(self, statustext):
        if self.parent.abc_sb.GetStatusText() == statustext:
            self.parent.abc_sb.SetStatusText('')
        self.parent.SetStatusBarPane(0)

    def recallBookmark(self, bookmarknb):
        nbitems = self.list.GetItemCount()
        if nbitems > 0:
            bookmark = self.bookmarks[bookmarknb]
            if bookmark >= 0:
                topitem = self.list.GetTopItem()
                if topitem != bookmark:
                    if topitem < bookmark:
                        newtopitem = min(bookmark + self.list.GetCountPerPage() - 1, nbitems - 1)
                    else:
                        newtopitem = bookmark
                    self.list.EnsureVisible(newtopitem)
                if bookmark < nbitems:
                    self.displayStatusTextTemp(self.localize('scrolledtobookmark') % bookmarknb)
                else:
                    self.displayStatusTextTemp(self.localize('bookmarkoutoflist') % bookmarknb)
            else:
                self.displayStatusTextTemp(self.localize('nobookmark') % bookmarknb)                      

    def itemMoveRow(self, indexlist, row, scroll = True, forcebottom = False):
        # Moves indexlist to row row
        # scroll can be set to False to prevent any scroll of the list while torrents are moved
        ctrl = wx.GetKeyState(wx.WXK_CONTROL)
        self.moveremove = True
        nbtor = self.list.GetItemCount()
        toselect = []
        if indexlist is None:
            tobemoved = self.getSelected()
            nbtobemoved = len(tobemoved)
            toselect = xrange(row, nbtobemoved + row)
        else:
            if indexlist == []:
                # If an empty list of indexes is passed, one defaults to the last index of the list
                indexlist = [nbtor - 1]
            tobemoved = indexlist
            nbtobemoved = len(tobemoved)
            i = row
            for index in indexlist:
                if self.list.GetItemState(index, wx.LIST_STATE_SELECTED):
                    toselect.append(i)
                i += 1

        if nbtobemoved:
            # Search for the ones that don't need to be moved below and above row
            if row in tobemoved:
                rowindex = tobemoved.index(row)
                i = 1
                while i <= rowindex and tobemoved[rowindex - i] == row - i:
                    i += 1
                rowindex1 = rowindex - i + 1
                row1 = row - i + 1
                i = 1
                while i < nbtobemoved - rowindex and tobemoved[rowindex + i] == row + i:
                    i += 1
                rowindex2 = rowindex + i - 1
                row2 = row + i - 1
            else:
                i = 0
                while i < nbtobemoved and tobemoved[i] <= row:
                    i += 1
                rowindex = rowindex1 = rowindex2 = i
                row1 = row2 = row
                if row == nbtor - 1 and forcebottom:
                    rowindex -= 1
            movelist1 = []
            for i in xrange(rowindex1):
                movelist1.append(tobemoved[i] - i)
            if movelist1:
                # Special case to move to top or bottom
                if row1 == 0 or (row1 == nbtor - 1 and (rowindex1 == nbtobemoved and forcebottom)):
                    pass
                else:
                    row1 -= 1
                self.queue.moveItemsRow(movelist1, row1)
            movelist2 = []
            for i in xrange(nbtobemoved - 1, rowindex2 - 1, -1):
                movelist2.append(tobemoved[i] + nbtobemoved - 1 - i)
            if movelist2:
                self.queue.moveItemsRow(movelist2, row2)

            # Apply selection in list
            for index in toselect:
                self.list.Select(index - rowindex)

            # Scroll if needed
            scrollswitch = (self.abcparams['scrolllisttb'] == "1")
            if scroll and (not scrollswitch and not ctrl or scrollswitch and ctrl):
                if row != nbtor - 1 and row >= self.list.GetTopItem() + self.list.GetCountPerPage():
                    row = max(min(row - 1 + len(movelist2), nbtor - 1), 0)
                self.list.EnsureVisible(row)

        self.moveremove = False

    def onItemMoveTop(self, event, scroll = True):
        if not self.torrentlistloading:
            if wx.GetKeyState(wx.WXK_SHIFT):
                self.onItemMoveMiddle(event, frommovetop = True)
            else:
                self.itemMoveRow(None, 0, scroll)
        self.list.SetFocus()

    def onScrollTop(self, event):
        if event.ShiftDown():
            self.onScrollMiddle(event, fromscrolltop = True)
        elif self.list.GetItemCount() > 0:
            self.list.EnsureVisible(0)

    def onItemMoveBottom(self, event, scroll = True):
        if not self.torrentlistloading:
            self.itemMoveRow(None, self.list.GetItemCount() - 1, scroll, forcebottom = True)
        self.list.SetFocus()

    def onScrollBottom(self, event):
        if self.list.GetItemCount() > 0:
            self.list.EnsureVisible(self.list.GetItemCount() - 1)

    def onRecallBookmark0(self, event):
        self.recallBookmark(0)

    def onItemMoveMiddle(self, event, indexlist = None, scroll = True, forcebelowcompleted = False, frommovetop = False):
        row = -1
        if not self.torrentlistloading:
            nbitems = self.list.GetItemCount()
            if indexlist == None:
                indexlist = self.getSelected()
            elif indexlist == []:
                # Defaults to last in list to handle move to middle from command line
                indexlist = [nbitems - 1]
            if indexlist:
                forcefinished = (wx.GetKeyState(wx.WXK_SHIFT) and not forcebelowcompleted and not frommovetop)
                row = self.findMiddleRow(indexlist, forcefinished = forcefinished)
                allinplace = True
                for i in xrange(1, len(indexlist) + 1):
                    if indexlist[-i] != row - i:
                        allinplace = False
                        break
                if allinplace and not forcebelowcompleted:
                    row = self.findMiddleRow(indexlist, forcefinished = not forcefinished)
                self.itemMoveRow(indexlist, row, scroll)
        self.list.SetFocus()
        return row

    def onScrollMiddle(self, event, fromscrolltop = False):
        nbitems = self.list.GetItemCount()
        if nbitems > 0:
            if fromscrolltop or not event.ShiftDown():
                forcefinished = (self.abcparams['scrollbelowfinished'] == '1')
            else:
                forcefinished = (self.abcparams['scrollbelowfinished'] == '0')
            itemsperpage = self.list.GetCountPerPage()
            topitem = self.list.GetTopItem()
            bottomitem = topitem + max(itemsperpage - 1, 0)
            middlerow = self.findMiddleRow(alwaysbelow = True, forcefinished = forcefinished)
            if topitem <= middlerow <= bottomitem:
                # If already visible
                middlerow = self.findMiddleRow(alwaysbelow = True, forcefinished = not forcefinished)
            if middlerow > bottomitem:
                # Scrolling towards bottom
                middlerow = min(middlerow + int(max(itemsperpage - 1, 0) * (1 - self.utility.scrollmiddlecentering)), nbitems - 1)
                self.list.EnsureVisible(middlerow)
            elif middlerow < topitem:
                # Scrolling towards top
                middlerow = max(middlerow - int(max(itemsperpage - 1, 0) * self.utility.scrollmiddlecentering), 0)
                self.list.EnsureVisible(middlerow)

    def findMiddleRow(self, selected = None, alwaysbelow = False, forcefinished = False):
        # Returns the row of the torrent below the last consecutive finished and/or completed torrent counted from the top
        # of the torrent list.
        # selected must be filled when moving torrents because selected torrents must be counted in this case,
        # but selected torrents are of no use when searching for the middle row just to show it.
        # Whether below finished or below completed row is returned is taken from the move torrent in list preferences ;
        # If alwaysbelow is True, the returned row is always the one below completed/finished whatever sorting option is set.
        # forcefinished is used to force return of the row of the last consecutive finished torrent.
        row = 0
        if self.abcparams['torrentwhencompleted'] == "1" or self.abcparams['torrentwhencompleted'] == "2":
            nbtor = self.list.GetItemCount()
            if self.abcparams['torrentwhenfinished'] == "1":
                # Finished are also moved to top, so count finished that are already at top
                while row < nbtor:
                    if self.queue.proctab[row].status != 'finished' and (selected is None or row not in selected):
                        break
                    row += 1
            if not forcefinished and (alwaysbelow or self.abcparams['sortbytime'] == '1'):
                while row < nbtor:
                    torrent = self.queue.proctab[row]
                    if (selected is None or row not in selected) and not torrent.complete:
                        break
                    row += 1
        elif self.abcparams['torrentwhenfinished'] == "1":
            if alwaysbelow or self.abcparams['sortbytime'] == '1':
                nbtor = self.list.GetItemCount()
                while row < nbtor:
                    tor = self.queue.proctab[row]
                    if tor.status != 'finished' and (selected is None or row not in selected):
                        break
                    row += 1
        return row

    def onItemMoveUp(self, event):
        ctrl = wx.GetKeyState(wx.WXK_CONTROL)
        if not self.torrentlistloading:
            scroll = (self.abcparams['scrolllistud'] == "1")
            self.moveremove = True
            selected = self.getSelected()
            if selected:
                self.queue.moveItemsUp(selected)
                if not scroll and not ctrl or scroll and ctrl:
                    if selected[0] > 1:
                        if selected[0] >= self.list.GetTopItem() + self.list.GetCountPerPage():
                            self.list.EnsureVisible(selected[0])
                        else:
                            self.list.EnsureVisible(selected[0] - 2)
                    else:
                        self.list.EnsureVisible(0)
            self.moveremove = False
        self.list.SetFocus()

    def onScrollUp(self, event):
        if self.list.GetItemCount() > 0:
            toshow = self.list.GetTopItem() - 1
            if toshow >= 0:
                self.list.EnsureVisible(toshow)

    def onItemMoveDown(self, event):
        ctrl = wx.GetKeyState(wx.WXK_CONTROL)
        if not self.torrentlistloading:
            scroll = (self.abcparams['scrolllistud'] == "1")
            self.moveremove = True
            selected = self.getSelected()
            if selected:
                self.queue.moveItemsDown(selected)
                if not scroll and not ctrl or scroll and ctrl:
                    if selected[0] < self.list.GetItemCount() - 2:
                        if selected[0] < self.list.GetTopItem():
                            self.list.EnsureVisible(selected[0])
                        else:
                            self.list.EnsureVisible(selected[0] + 2)
                    else:
                        self.list.EnsureVisible(self.list.GetItemCount() - 1)
            self.moveremove = False
        self.list.SetFocus()

    def onScrollDown(self, event):
        if self.list.GetItemCount() > 0:
            toshow = self.list.GetTopItem() + self.list.GetCountPerPage()
            if toshow < self.list.GetItemCount():
                self.list.EnsureVisible(toshow)

    def updateBookmarks(self, src, dest = 2147483647):
        if src < dest:
            for i in xrange(10):
                if src < self.bookmarks[i] < dest:
                    self.bookmarks[i] -= 1
            if src < self.selectedrow < dest:
                self.selectedrow -= 1
        elif src > dest:
            for i in xrange(10):
                if dest < self.bookmarks[i] < src:
                    self.bookmarks[i] += 1
            if dest < self.selectedrow < src:
                self.selectedrow += 1

    def onResetScanner(self, event):
        if self.scanner.scannedfiles:
            self.scannerbutton.SetBitmapSelected(self.scannerbutton.bitmapselected)
            self.scannerbutton.Refresh()
            self.scanner.scannedfiles = self.scanner.loadedfiles = 0
            self.scanner.buttontooltip.SetTip('0' + self.localize('loaded') +
                                              '0' + self.localize('scanned'))

    def onRightModeButton(self, event):
        self.queue.toggleSchedulerMode()

    def onClearAllOver(self, event = None, caller = ''):
        if self.torrentlistloading:
            return
        listtoremove = []
        for index in xrange(len(self.queue.proctab)):
            torrent = self.queue.proctab[index]
            if torrent.status == 'finished' and not (torrent.ismovingdata or torrent.isbeingdeleted):
                listtoremove.append(index)
                if torrent.detailwin is not None:
                    torrent.detailwin.killAdv()
                if torrent.infowin is not None:
                    torrent.infowin.killInfo()
        if listtoremove:
            self.moveremove = True
            self.windowparent = self
            self.queue.procREMOVE(listtoremove)
            if caller == '':
                self.list.SetFocus()
            self.moveremove = False
            self.nbselected.SetLabel(str(self.list.GetSelectedItemCount()))

    def onModeToggle(self, event = None, mode = None, queue = 0):
        ctrl = wx.GetKeyState(wx.WXK_CONTROL)
        if event is not None and event.GetIsDown() or mode == 1:
            if self.abcparams['mode'] == '2' and mode != 1:
                # Switch to manual mode
                self.abcparams['mode'] = '0'
                self.modebutton.SetBitmapLabel(self.utility.modebtnmanual)
                self.modebutton.SetValue(False)
            elif ctrl and mode != 1 or queue:
                # Automatic mode must not be engaged
                self.modebutton.SetValue(False)
                self.queue.procQUEUERUNNING()
            else:
                # Automatic mode
                if mode == 1:
                    self.modebutton.SetValue(True)
                self.abcparams['mode'] = '1'
                # The DRM and URM threshold exceeeding timers are reset if there is no on-hold torrent
                # in the list
                # This is because when in manual mode, the DRM and URM scheduler keep on running just to manage
                # the on-hold torrents
                if self.queue.torrentonhold == 0:
                    self.queue.drm_time1 = self.queue.urm_time1 = 0.
                    self.queue.drm_time2 = self.queue.urm_time2 = 0.
                if not self.torrentlistloading:
                    # Reset URM triggering delay
                    self.queue.drminitialstartingtime = self.queue.urminitialstartingtime = clock()
                    self.queue.invokeLater(self.queue.scheduler)
                    # Init standby torrents to count seeding time if necessary
                    if self.utility.countsbasseed:
                        self.queue.initStandbySeedingTime(clock())
        else:
            # Manual mode
            if mode == 2:
                self.abcparams['mode'] = '2'
                self.modebutton.SetBitmapLabel(self.modebtnmanual2)
                self.modebutton.SetValue(False)
            else:
                self.modebutton.SetBitmapLabel(self.utility.modebtnmanual)
                if mode == 0:
                    self.modebutton.SetValue(False)
                self.abcparams['mode'] = '0'
                if ctrl and mode != 0 or queue:
                    self.queue.procQUEUERUNNING()
        if event is not None:
            self.list.SetFocus()
        tcfm = TorrentConfigFileManager(path.join(self.utility.datapath, "abc.conf"), self.abcparams)
        tcfm.writeAllConfig()

    def onCommandSchedulerToggle(self, event = None, status = None):
        if event is not None and event.GetIsDown() or status == 1:
            # Command scheduler on
            if not self.commandscheduler.status:
                if self.torrentlistloading:
                    self.schedulerbutton.SetValue(False)
                else:
                    if status == 1:
                        self.schedulerbutton.SetValue(True)
                        if self.parent.abcschedulerdlg is not None:
                            self.parent.abcschedulerdlg.forceStatus(1)
                    self.commandscheduler.start()
        elif self.commandscheduler.status:
            # Command scheduler off
            if status == 0:
                self.schedulerbutton.SetValue(False)
                if self.parent.abcschedulerdlg is not None:
                    self.parent.abcschedulerdlg.forceStatus(0)
            self.commandscheduler.stop()
        if event is not None:
            self.list.SetFocus()

    def onScannerToggle(self, event = None, status = None):
        if event is not None and event.GetIsDown() or status == 1:
            # Directory scanner on
            if not self.scanner.status:
                if self.torrentlistloading:
                    self.scannerbutton.SetValue(False)
                elif not self.scanner.canScan():
                    self.scannerbutton.SetValue(False)
                    # Next one to fix a bug (wxPython can't release the mouse after the MessageDialog)
                    # No more necessary with wxPython 2.6.3.3 where the bug has been solved.
                    #self.scannerbutton.CaptureMouse()
                else:
                    if status == 1:
                        self.scannerbutton.SetValue(True)
                        if self.parent.abcscannerdlg is not None:
                            self.parent.abcscannerdlg.forceStatus(1)
                    self.scanner.start()
        elif self.scanner.status:
            # Directory scanner off
            if self.scanner.scannedfiles:
                buttonbmp = wx.Bitmap(path.join(self.utility.abcpath, 'icons', 'scanneron.bmp'), wx.BITMAP_TYPE_BMP)
                buttonbmp.SetMask(wx.Mask(buttonbmp, wx.Colour(200, 200, 200)))
                self.scannerbutton.SetBitmapSelected(buttonbmp)
            if status == 0:
                self.scannerbutton.SetValue(False)
                if self.parent.abcscannerdlg is not None:
                    self.parent.abcscannerdlg.forceStatus(0)
            self.scanner.stop()
        if event is not None:
            self.list.SetFocus()

    def onWebServiceToggle(self, event = None, status = None):
        if event is not None and event.GetIsDown() or status == 1:
            # Web service on
            if not self.parent.webserver:
                if self.torrentlistloading:
                    self.webservicebutton.SetValue(False)
                else:
                    if status == 1:
                        self.webservicebutton.SetValue(True)
                        if self.parent.abcwebdlg is not None:
                            self.parent.abcwebdlg.forceStatus(1)
                    self.startWebService()
        elif self.parent.webserver:
            # Web service off
            if status == 0:
                self.webservicebutton.SetValue(False)
                if self.parent.abcwebdlg is not None:
                    self.parent.abcwebdlg.forceStatus(0)
            self.stopWebService()
        self.list.SetFocus()

    def mapResumeShortcut(self, ctrl, shift, delete, insert):
        # tracker :
        # 0 : Tracker set for torrent with mode set in Preferences, 1 : INT, 2 : EXT mode 2, 3 : EXT mode 0,
        # 4 : EXT mode 1, 5 : EXT with mode set in Preferences, 6 : EXT mode 1 with wait in INT,
        # 7 : EXT mode 2 with wait in INT, 8 : EXT mode 1 without wait in INT, 9 : EXT mode 2 without wait in INT
        if delete:
            if ctrl or shift or insert:
                tracker = 0
            else:
                tracker = self.utility.restrackdel
        elif insert:
            if ctrl or shift:
                tracker = 0
            else:
                tracker = self.utility.restrackins
        elif ctrl:
            if shift:
                tracker = self.utility.restrackctrlshift
            else:
                tracker = self.utility.restrackctrl
        elif shift:
            tracker = self.utility.restrackshift
        else:
            tracker = 0
        if tracker == 5:
            tracker = (3, 4, 2)[self.utility.checkinttrack]
        return tracker

    def onFastResume(self, event, getmetadata = 0):
        mousestate = wx.GetMouseState()
        delete = wx.GetKeyState(wx.WXK_DELETE)
        insert = wx.GetKeyState(wx.WXK_INSERT)
        if self.torrentlistloading:
            return
        if not getmetadata:
            getmetadata = mousestate.MiddleDown()
        if self.queue.procRESUME(self.getTargetTorrents(), True, auto = False, reseed = mousestate.RightDown(),
                                 tracker = self.mapResumeShortcut(mousestate.ControlDown(), mousestate.ShiftDown(), delete, insert),
                                 getmetadata = getmetadata):
            rank = self.parent.guiman.getRankfromID(13)
            if rank == -1:
                # Display error message
                dlg = wx.MessageDialog(self.windowparent, self.localize('errorresume'),
                                       self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()

    def onOnlyGetMetadata(self, event):
        self.onFastResume(event, getmetadata = 2)

    def onResume(self, event):
        mousestate = wx.GetMouseState()
        delete = wx.GetKeyState(wx.WXK_DELETE)
        insert = wx.GetKeyState(wx.WXK_INSERT)
        if self.torrentlistloading:
            return
        if self.queue.procRESUME(self.getTargetTorrents(), False, auto = False,
                                 tracker = self.mapResumeShortcut(mousestate.ControlDown(), mousestate.ShiftDown(), delete, insert),
                                 getmetadata = mousestate.MiddleDown()):
            rank = self.parent.guiman.getRankfromID(13)
            if rank == -1:
                # Display error message
                dlg = wx.MessageDialog(self.windowparent, self.localize('errorresume'),
                                       self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()

    def onResumeAll(self, event = None):
        if self.torrentlistloading:
            return
        self.queue.procRESUMEALL()
        self.list.SetFocus()

    def onStop(self, event):
        self.queue.procSTOP(self.getTargetTorrents())

    def onStopAll(self, event = None):
        self.queue.procSTOPALL()
        if self.pauseallbutton.GetValue():
            self.pauseallbutton.SetValue(False)
        self.list.SetFocus()

    def onStopTraffic(self, event):
        self.onModeToggle(mode = 0, queue = 1)
        if self.pauseallbutton.GetValue():
            self.pauseallbutton.SetValue(False)

    def onPause(self, event):
        self.queue.procPAUSE(self.getTargetTorrents())

    def onPauseAll(self, event = None, pause = None):
        if self.torrentlistloading:
            return
        if event is not None and event.GetIsDown() or pause == 1:
            if pause == 1:
                self.pauseallbutton.SetValue(True)
            self.pauseall = True
            self.queue.procPAUSEALL()
        elif event is not None and not event.GetIsDown() or pause == 0:
            if pause == 0:
                self.pauseallbutton.SetValue(False)
            self.queue.procRELEASEPAUSEALL()
            # Reset URM triggering delay
            self.queue.drminitialstartingtime = self.queue.urminitialstartingtime = clock()
            self.pauseall = False
        if pause is None:
            self.list.SetFocus()

    def onQueue(self, event):
        self.queue.procQUEUE(self.getTargetTorrents())

    def onQueueAll(self, event = None):
        self.queue.procQUEUEALL()

    def onStandby(self, event):
        self.queue.procSTANDBY(self.getTargetTorrents())

    def onSuperSeed(self, event):
        if self.queue.procSUPERSEED(self.getTargetTorrents()):
            rank = self.parent.guiman.getRankfromID(13)
            if rank == -1:
                # Display error message
                dlg = wx.MessageDialog(self.windowparent, self.localize('errorsuperseed'),
                                       self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()

    def onCompleteShutDownAdd(self, event):
        for index in self.getTargetTorrents():
            torrent = self.queue.proctab[index]
            if torrent not in self.queue.compshut:
                self.queue.compshut.append(torrent)

    def onCompleteShutDownShow(self, event):
        for index in self.getSelected():
            self.list.SetItemState(index, 0, wx.LIST_STATE_SELECTED)
        for torrent in self.queue.compshut:
            self.list.Select(torrent.index)

    def onCompleteShutDownSeedingTime(self, event):
        self.abcparams['compshutseedingtime'] = str(event.GetId() - 909)

    def onCompleteShutDownReset(self, event):
        self.queue.compshut[:] = []

    def onChangePrio(self, event = None, index = None, prio = None):
        if index == None:
            selected = self.getTargetTorrents()
        else:
            selected = [index]
        rank = self.guiman.getRankfromID(7)
        if prio is None:
            prio = event.GetId() - 904
        for index in selected:
            self.queue.proctab[index].priority = prio
            if rank != -1:
                self.list.SetStringItem(index, rank, self.utility.priorities_s[prio])            

    def onIncDecPriority(self, indexlist, direction):
        rank = self.guiman.getRankfromID(7)
        for index in indexlist:
            self.queue.proctab[index].incDecPriority(direction, rank)

    def onCheck(self, event):
        self.queue.procCHECK(self.getTargetTorrents())

    def onClearMessages(self, event = None, indexlist = None, clearall = False):
        if clearall:
            indextoclear = xrange(len(self.queue.proctab))
        else:
            if indexlist == None:
                indexlist = self.getTargetTorrents()
            indextoclear = indexlist
        self.queue.clearMessage(indextoclear)

    def onRemove(self, event = None, indexlist = None, caller = '', movedata = True):
        if self.torrentlistloading:
            return
        if indexlist == None:
            selected = self.getTargetTorrents()
        else:
            selected = indexlist
        if selected:
            for index in selected[:]:
                # Delete details windows
                torrent = self.queue.proctab[index]
                if torrent.ismovingdata or torrent.isbeingdeleted:
                    selected.remove(index)
                else:
                    if torrent.detailwin is not None:
                        torrent.detailwin.killAdv()
                    if torrent.infowin is not None:
                        torrent.infowin.killInfo()
            if selected:
                self.moveremove = True
                self.queue.procREMOVE(selected, caller = caller, movedata = movedata)
                self.moveremove = False
                self.nbselected.SetLabel(str(self.list.GetSelectedItemCount()))

    def onRemoveFile(self, event = None, indexlist = None, warn = True):
        if self.torrentlistloading:
            return
        if warn:
            # Display dialog warning
            dlg = wx.MessageDialog(self.windowparent, self.localize('confirmdeletefile'),
                                   self.localize('abcokcwarning'), wx.ICON_WARNING | wx.YES_NO)
            result = dlg.ShowModal()
            dlg.Destroy()
            if result == wx.ID_NO:
                return
        if indexlist == None:
            selected = self.getTargetTorrents()
        else:
            selected = indexlist
        if selected:
            for index in selected[:]:
                # Delete details windows
                torrent = self.queue.proctab[index]
                if torrent.ismovingdata or torrent.isbeingdeleted:
                    selected.remove(index)
                else:
                    if torrent.detailwin is not None:
                        torrent.detailwin.killAdv()
                    if torrent.infowin is not None:
                        torrent.infowin.killInfo()
            if selected:
                self.moveremove = True
                self.queue.procREMOVEFILE(selected)
                self.moveremove = False
                self.nbselected.SetLabel(str(self.list.GetSelectedItemCount()))

    def onCopyFromList(self, event):
        # Choose the destination folder
        dl = wx.DirDialog(self.windowparent, self.localize('choosenewfolder'), self.abcparams['defaultfolder'],
                          style = wx.DD_DEFAULT_STYLE | wx.DD_NEW_DIR_BUTTON)
        result = dl.ShowModal()
        if result != wx.ID_OK:
            dl.Destroy()
            return
        destfolder = dl.GetPath()
        dl.Destroy()
        torrentselected = []
        for i in self.getTargetTorrents():
            torrentselected.append(self.queue.proctab[i])
        for torrent in torrentselected:
            filename = path.split(torrent.src)[1]
            destname = path.join(destfolder, filename)
            # Check if the file to be copied already exists in destination folder
            if path.exists(destname):
                dlg = wx.MessageDialog(self, self.localize('torrent') + torrent.name + "\n" + self.localize('file') +
                                       filename + "\n" + self.localize('exporterrorduplicatemsg'),
                                       self.localize('exporterrorduplicate'), wx.YES_NO | wx.ICON_EXCLAMATION)
                result = dlg.ShowModal()
                dlg.Destroy()
                if result == wx.ID_NO:
                    continue
            # Copy the torrent file                        
            try:
                copy(torrent.src, destname)
            except:
                dlg = wx.MessageDialog(self.windowparent, self.localize('torrent') + torrent.name + "\n" + self.localize('file') +
                                       filename + "\n" + self.localize('exporterrorcopying'),
                                       self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()

    def onExtractFromList(self, event):
        if self.torrentlistloading:
            return
        selected = self.getTargetTorrents()
        self.moveremove = True
        firstselected = selected[0]
        torrentselected = []
        for i in selected:
            torrentselected.append(self.queue.proctab[i])
        # Choose the destination folder
        dl = wx.DirDialog(self.windowparent, self.localize('choosenewfolder'), self.abcparams['defaultfolder'],
                          style = wx.DD_DEFAULT_STYLE | wx.DD_NEW_DIR_BUTTON)
        result = dl.ShowModal()
        if result != wx.ID_OK:
            dl.Destroy()
        else:
            destfolder = dl.GetPath()
            dl.Destroy()
            lastindex = 0
            while lastindex != -1:
                lastindex = -1
                for t in torrentselected:
                    try:
                        i = self.queue.proctab.index(t)
                    except:
                        continue
                    if i > lastindex:
                        lastindex = i
                if lastindex != -1:
                    torrent = self.queue.proctab[lastindex]
                    torrentselected.remove(torrent)
                    filename = path.split(torrent.src)[1]
                    destname = path.join(destfolder, filename)
                    # Check if the file to be moved already exists in destination folder
                    if path.exists(destname):
                        dlg = wx.MessageDialog(self.windowparent, self.localize('torrent') + torrent.name + "\n" + self.localize('file') +
                                               filename + "\n" + self.localize('exporterrorduplicatemsg'),
                                               self.localize('exporterrorduplicate'), wx.YES_NO | wx.ICON_EXCLAMATION)
                        result = dlg.ShowModal()
                        dlg.Destroy()
                        if result == wx.ID_NO:
                            continue
                    # Move the torrent file                        
                    try:
                        copy(torrent.src, destname)
                    except:
                        dlg = wx.MessageDialog(self.windowparent, self.localize('torrent') + torrent.name + "\n" + self.localize('file') +
                                               filename + "\n" + self.localize('exporterrormoving'),
                                               self.localize('abcokcerror'), wx.ICON_ERROR)
                        dlg.ShowModal()
                        dlg.Destroy()
                    else:
                        self.commandfromlist = False
                        try:
                            newindex = self.queue.proctab.index(torrent)
                        except:
                            continue
                        self.onRemove(indexlist = [newindex])
            listsize = self.list.GetItemCount() - 1
            if listsize >= 0:
                if firstselected >= listsize:
                    self.list.Select(listsize)
                else:
                    self.list.Select(firstselected)
        self.moveremove = False
        self.nbselected.SetLabel(str(self.list.GetSelectedItemCount()))

    def onExtractFromListRemove(self, event):
        if self.torrentlistloading:
            return
        selected = self.getTargetTorrents()
        self.moveremove = True
        firstselected = selected[0]
        torrentselected = []
        for i in selected:
            torrentselected.append(self.queue.proctab[i])
        # Display Dialog Warning
        dlg = wx.MessageDialog(self.windowparent, self.localize('confirmdeletefile'),
                               self.localize('abcokcwarning'), wx.ICON_WARNING | wx.YES_NO)
        result = dlg.ShowModal()
        dlg.Destroy()
        if result == wx.ID_NO:            
            return
        # Choose the destination folder
        dl = wx.DirDialog(self.windowparent, self.localize('choosenewfolder'), self.abcparams['defaultfolder'],
                          style = wx.DD_DEFAULT_STYLE | wx.DD_NEW_DIR_BUTTON)
        result = dl.ShowModal()
        if result != wx.ID_OK:
            dl.Destroy()
        else:
            destfolder = dl.GetPath()
            dl.Destroy()
            lastindex = 0
            while lastindex != -1:
                lastindex = -1
                for t in torrentselected:
                    try:
                        i = self.queue.proctab.index(t)
                    except:
                        continue
                    if i > lastindex:
                        lastindex = i
                if lastindex != -1:
                    torrent = self.queue.proctab[lastindex]
                    torrentselected.remove(torrent)
                    filename = path.split(torrent.src)[1]
                    destname = path.join(destfolder, filename)
                    # Check if the file to be moved already exists in destination folder
                    if path.exists(destname):
                        dlg = wx.MessageDialog(self.windowparent, self.localize('torrent') + torrent.name + "\n" + self.localize('file') +
                                               filename + "\n" + self.localize('exporterrorduplicatemsg'),
                                               self.localize('exporterrorduplicate'), wx.YES_NO | wx.ICON_EXCLAMATION)
                        result = dlg.ShowModal()
                        dlg.Destroy()
                        if result == wx.ID_NO:
                            continue
                    # Move the torrent file                        
                    try:
                        copy(torrent.src, destname)
                    except:
                        dlg = wx.MessageDialog(self.windowparent, self.localize('torrent') + torrent.name + "\n" + self.localize('file') +
                                               filename + "\n" + self.localize('exporterrormoving'),
                                               self.localize('abcokcerror'), wx.ICON_ERROR)
                        dlg.ShowModal()
                        dlg.Destroy()
                    else:
                        self.commandfromlist = False
                        try:
                            newindex = self.queue.proctab.index(torrent)
                        except:
                            continue
                        self.onRemoveFile(indexlist = [newindex], warn = False)
            listsize = self.list.GetItemCount() - 1
            if listsize >= 0:
                if firstselected >= listsize:
                    self.list.Select(listsize)
                else:
                    self.list.Select(firstselected)
        self.moveremove = False
        self.nbselected.SetLabel(str(self.list.GetSelectedItemCount()))

    def startWebService(self):
        # Start web service
        if self.webparams['webIP'] == '0':
            ip = ""
        else:
            ip = "127.0.0.1"
        self.parent.webserver = WebListener(ip, int(self.webparams['webport']), self.utility)
        thread = Thread(target = self.parent.webserver.start, args = [self])
        thread.daemon = False
        thread.start()

    def stopWebService(self):
        # Stop web service
        if self.webparams['webIP'] == '0':
            ip = ""
        else:
            ip = "127.0.0.1"
        closemsg = WebClient(ip, int(self.webparams['webport']), self.utility)
        if closemsg.sendMesg(self.parent, "ID|" + self.webparams['webID'] + "\nCLOSE|"):
            self.parent.webserver = None
            sleep(0.2)

    def onLocalSetting(self, event = None):
        if self.torrentlistloading:
            return
        indexlist = self.getTargetTorrents()
        if not indexlist:
            return
        torrent = self.queue.proctab[self.getTargetTorrents(firstitemonly = True, hittest = True)[0]]
        if torrent.isbeingdeleted:
            return
        self.torrentparamsdlg = TorrentParametersDialog(self.windowparent, -1, torrent, self.queue,
                                                        self, self.commandfromlist and (len(indexlist) > 1),
                                                        self.queue.dht)
        self.torrentparamsdlg.ShowModal()
        self.abcparams['lastopentortab'] = str(self.torrentparamsdlg.notebook.GetSelection())
        x, y = self.torrentparamsdlg.GetPositionTuple()
        self.abcparams['torrentparamsdlgx'], self.abcparams['torrentparamsdlgy'] = str(x), str(y)
        self.torrentparamsdlg.Destroy()
        self.torrentparamsdlg = None

    def onAddPeer(self, event = None):
        if self.torrentlistloading:
            return
        indexlist = self.getTargetTorrents()
        if not indexlist:
            return
        torrents = [self.queue.proctab[index] for index in self.getTargetTorrents()]
        for t in torrents[:]:
            if t.isbeingdeleted:
                torrents.remove(t)
                continue
            if not t.abcengine:
                dlg = wx.MessageDialog(self, message = self.localize('torrentnotrunning'), 
                                       caption = self.localize('abcokcerror'), style = wx.OK | wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return
            if t.private and self.abcparams['strictprivate'] == '1':
                dlg = wx.MessageDialog(self, message = self.localize('torrentprivate'), 
                                       caption = self.localize('abcokcerror'), style = wx.OK | wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return
        if torrents:
            self.abcaddpeerdlg = AddPeerDialog(self.windowparent, -1, torrents[0], self.queue,
                                               self, self.localize('addpeersetting'))
            self.abcaddpeerdlg.ShowModal()
            x, y = self.abcaddpeerdlg.GetPositionTuple()
            self.abcparams['addpeerdlgx'], self.abcparams['addpeerdlgy'] = str(x), str(y)
            self.abcaddpeerdlg.Destroy()
            self.abcaddpeerdlg = None

    def onDetails(self, event = None, indexlist = None, position = None, centeratpointer = None):
        if indexlist == None:
            indexlist = self.getTargetTorrents()
        if len(indexlist) > 100:
            dlg = wx.MessageDialog(self.windowparent, self.localize('warningopenwindow'),
                                   self.localize('abcokcwarning'), wx.YES_NO | wx.ICON_EXCLAMATION)
            result = dlg.ShowModal()
            dlg.Destroy()
            if result == wx.ID_NO:
                return
        for index in indexlist:
            torrent = self.queue.proctab[index]
            if torrent.isbeingdeleted:
                continue
            if torrent.detailwin is not None:
                if torrent.detailwin.IsShown():
                    if torrent.detailwin.IsIconized():
                        torrent.detailwin.Iconize(False)
                    torrent.detailwin.Raise()
                else:
                    if position == -1:
                        torrent.detailwin.Centre()
                    else:
                        if position is None:
                            position = wx.DefaultPosition
                        if centeratpointer:
                            position = position - wx.Point(self.GetSizeTuple()[0] / 2, 10)
                        torrent.detailwin.Move(position)
                    torrent.detailwin.Show()
            else:
                torrent.detailwin = ABCDetailFrame(self, -1, '', self.utility, index, position,
                                                   (self.guiman.getDetailWidth(), self.guiman.getDetailHeight()),
                                                   centeratpointer = centeratpointer)
                if torrent.abcengine:
                    torrent.abcengine.detailwin = torrent.detailwin

    def displayTransfer(self, event = None):
        if self.initializing:
            return
        self.parent.abc_sb.SetStatusText('')
        self.Freeze()
        self.list.Show()
        self.list.SetFocus()
        self.rsspanel.Hide()
        self.Layout()
        self.Thaw()

    def displayRSS(self, event = None):
        if self.initializing:
            self.parent.tb.ToggleTool(self.parent.maintoolbarids[0], True)
            return
        self.parent.abc_sb.SetStatusText('')
        self.Freeze()
        self.rsspanel.Show()
        self.rsspanel.SetFocus()
        self.list.Hide()
        self.Layout()
        if self.firstdisplayRSS:
            # Set RSS sash
            sash = int(self.abcparams['rsssash'])
            if not sash:
                sash = min(400, self.rsspanel.splitter.GetSizeTuple()[0] / 2)
            self.rsspanel.splitter.SetSashPosition(sash)
            self.firstdisplayRSS = False
        self.Thaw()

    def getTorrentFromURL(self, url, prio = 2, status = 'queue', movetop = False, startnow = False,
                          showdownload = False, caller = ''):
        thread = Thread(target = self.addTorrentURL,
                        args = [None, url, prio, status, movetop, startnow, showdownload, caller])
        thread.daemon = False
        thread.start()

    def getTorrentFromURLs(self, urls):
        for url in urls:
            self.addTorrentURL(None, url, showdownload = True)

    def addTorrentURL(self, callback, url, prio = 2, status = 'queue', movetop = False, startnow = False,
                      showdownload = False, caller = '', rssrule = None, headers = {}, callbackinfo = None, req_url = None):
        # Copy torrent from web and call addnewproc
        if rssrule is None:
            downloc = None
        else:
            prio = rssrule[6]
            if rssrule[8] == 1:
                downloc = rssrule[9]
            else:
                downloc = None
            if rssrule[7] == 0:
                status = 'stop'
                startnow = False
            elif rssrule[7] == 1:
                status = 'queue'
                startnow = False
            elif rssrule[7] == 2:
                status = 'stop'
                startnow = True
            else:
                status = 'queue'
                startnow = False

        url = url.strip()
        if not url.lower().startswith('magnet:') and '/' not in url:
            url = 'magnet:?xt=urn:btih:' + url

        if not req_url and url.lower().startswith('magnet:'):
            # Handle magnet URL
            # Check magnet validity
            invalidmagnet = False
            validmagnetname = 0
            if url[7:20] != '?xt=urn:btih:':
                invalidmagnet = True
            else:
                # Infohash (in binary) ;
                # Name defaults to hexlified infohash
                magnetoptionsindex = url.find('&')
                if magnetoptionsindex == 60 or magnetoptionsindex == -1 and len(url) == 60:
                    # 40 character hex encoded info-hash
                    magnetname = url[20:60]
                    try:
                        infohash = unhexlify(magnetname)
                    except:
                        invalidmagnet = True
                elif magnetoptionsindex == 52 or magnetoptionsindex == -1 and len(url) == 52:
                    # 32 character base32 encoded info-hash
                    try:
                        infohash = b32decode(url[20:52])
                    except:
                        invalidmagnet = True
                    else:
                        magnetname = hexlify(infohash)
                else:
                    invalidmagnet = True

            if invalidmagnet:
                if caller != "web" and caller != "rss" and caller != "qcl":
                    dlg = wx.MessageDialog(self, self.localize('invalidmagnet') + ":\n" + url,
                                           self.localize('abcokcerror'), wx.ICON_ERROR)
                    dlg.ShowModal()
                    dlg.Destroy()
                if callback:
                    callback(callbackinfo, "Error=Invalid magnet")
                return

            # Magnet options (name + trackers)
            magnettrackers = []
            if magnetoptionsindex != -1:
                for option in url[magnetoptionsindex:].split('&'):
                    if option:
                        try:
                            p, v = option.split('=')
                        except:
                            continue
                        if p == 'dn':
                            magnetname = html2text(unquote_plus(v.encode('utf-8')).decode('utf-8'))[:-1]
                            validmagnetname = 1 
                        elif p == 'tr':
                            try:
                                magnettrackers.append(quote(unquote(v.encode('utf-8')), safe = ':/?=+#@'))
                            except:
                                continue

            # Create torrent metadata
            # Metadata for a torrent with info taken from magnet and not yet completed with download from
            # another peer, have a temporary extra key infohash to store the torrent info_hash
            params = {}
            url = ''
            if len(magnettrackers) > 1:
                params['announce_list'] = '|'.join(magnettrackers)
            elif len(magnettrackers) == 1:
                url = magnettrackers[0]
            params['infohash'] = infohash
            params['validmagnetname'] = validmagnetname
            btmetafile = make_meta_data(magnetname, url, self.queue.dht, params, nofile = True)[0]
            fixedmagnetname = self.utility.fixWindowsName(magnetname)
            if fixedmagnetname:
                filename = fixedmagnetname + '.magnet.torrent'
            else:
                filename = magnetname + '.magnet.torrent'

        else:
            # Handle HTTP, HTTPS URL
            url_splitted = urlsplit(url)
            if not url_splitted[0]:
                # To deal with URL without scheme and initial '//' from network location
                url = '//' + url
            url_splitted = urlsplit(url, "http")

            if url_splitted[0].lower() not in ('http', 'https'):
                if caller != "web" and caller != "rss" and caller != "qcl":
                    dialog = wx.MessageDialog(self, self.localize('badprotocol'),
                                              self.localize('abcokcerror'), wx.ICON_ERROR)
                    dialog.ShowModal()
                    dialog.Destroy()
                if callback:
                    callback(callbackinfo, "Error=Only http, https or magnet URLs are allowed")
                return

            filename = url_splitted[2].rstrip('/').split('/')[-1]
            if url_splitted[3]:
                filename += '_' + url_splitted[3]
            filename = html2text(unquote_plus(filename.encode('utf-8')).decode('utf-8'))[:-1]
            fixedfilename = self.utility.fixWindowsName(filename)
            if fixedfilename:
                filename = fixedfilename
            if not filename.endswith('.torrent'):
                filename += '.torrent'

            if showdownload:
                self.parent.SetStatusText(self.localize('downloadingtorrent'))
            try:
                if not req_url:
                    req_url = urlopen(urlunsplit([url_splitted[0], url_splitted[1], url_splitted[2], url_splitted[3], url_splitted[4]]), headers)
                btmetafile = req_url.read()
                req_url.close()
            except:
                if showdownload:
                    self.parent.SetStatusText('')
                if caller != "web" and caller != "rss" and caller != "qcl":
                    dlg = wx.MessageDialog(self, self.localize('cantgettorrentfromurl') + ":\n" + url,
                                           self.localize('abcokcerror'), wx.ICON_ERROR)
                    dlg.ShowModal()
                    dlg.Destroy()
                if callback:
                    callback(callbackinfo, "Error=Can't get torrent from URL")
                return

        if showdownload:
            self.parent.SetStatusText('')
        self.queue.invokeLater(self.addNewProc, [filename, btmetafile, caller, prio, status, movetop, startnow, downloc, callbackinfo, callback])

    def addNewProc(self, origfilename, btmetafile, caller, prio, status, movetop, startnow, downloc, callbackinfo, callback):
        dest = self.utility.findUniqueFileName(path.join(self.utility.datapath, 'torrent', origfilename), src = caller)
        if dest is None:
            if callback:
                callback(callbackinfo, "Error=Can't find a unique name for torrent file")
            return

        try:
            f = open(dest, "wb")
            f.write(btmetafile)
        except:
            try:
                f.close()
            except:
                pass
            if callback:
                callback(callbackinfo, "Error=Can't write torrent file")
            return
        f.close()

        success, mesg = self.queue.addNewProc(dest, origfilename, False, caller = caller, prio = prio, status = status, movetop = movetop,
                                              startnow = startnow, downloc = downloc)
        if callback:
            if success:
                callbackmsg = "OK"
            else:
                callbackmsg = "Error=" + mesg
            callback(callbackinfo, callbackmsg)

    def addTorrentLink(self, event):
        if self.torrentlistloading:
            return
        if wx.GetMouseState().RightDown():
            if not wx.TheClipboard.IsOpened():
                wx.TheClipboard.Open()
                urls = wx.TextDataObject()
                success = wx.TheClipboard.GetData(urls)
                wx.TheClipboard.Close()
                if not success:
                    return
                urls = urls.GetText().splitlines()
                if urls:
                    thread = Thread(target = self.getTorrentFromURLs, args = [urls])
                    thread.daemon = False
                    thread.start()
        else:
            dialog = wx.TextEntryDialog(self,
                                        self.localize('enterurl'),
                                        self.localize('addtorrenturl_short'))
            wx.Dialog.SetWindowStyle(dialog, wx.CAPTION | wx.CLOSE_BOX | wx.TAB_TRAVERSAL | wx.RESIZE_BORDER)
            dialog.SetSize((int(self.abcparams['addtorrentlinkw']), -1))
            height = dialog.GetSize()[1]
            dialog.SetMinSize((300, height))
            dialog.SetMaxSize((-1, height))
            dialog.Centre()
            result = dialog.ShowModal()
            btlink = dialog.GetValue()
            self.abcparams['addtorrentlinkw'] = str(dialog.GetSizeTuple()[0])
            dialog.Destroy()
            if result != wx.ID_OK:
                return

            if btlink:
                self.getTorrentFromURL(btlink, showdownload = True)

    def addTorrentNoneDefault(self, event):
        self.addTorrentFile(event, True)

    def addTorrentFile(self, event, forceasklocation = False):
        if self.torrentlistloading:
            return
        dl = wx.FileDialog(self, self.localize('choosetorrentfile'), '', '',
                           'torrent files (*.torrent)|*.torrent|all files (*.*)|*.*', wx.OPEN | wx.MULTIPLE)
        result = dl.ShowModal()
        if result != wx.ID_OK:
            dl.Destroy()
            return
        filelocation = dl.GetPaths()
        dl.Destroy()

        if len(filelocation) > 1:
            multifile = True
            self.queue.duptoroverwriteall = False
            self.queue.duptorskipall = False
            self.queue.dupdestkeepall = False
            self.queue.dupdestskipall = False
        else:
            multifile = False
        for f in filelocation:
            origfilename = path.split(f)[1]
            dest = self.utility.findUniqueFileName(path.join(self.utility.datapath, 'torrent', origfilename))
            if dest is None:
                continue
            try:
                copyfile(f, dest)
            except:
                continue
            self.queue.addNewProc(dest, origfilename, forceasklocation, multifile = multifile)

    def addTorrentURLFromWeb(self, url, connection):
        thread = Thread(target = self.addTorrentURL, args = [self.addTorrentURLFromWebCallback, url],
                        kwargs = {'caller': 'web', 'callbackinfo': connection})
        thread.daemon = False
        thread.start()

    def addTorrentURLFromWebCallback(self, connection, status):
        connection.send("Feedback\n" + status)
        connection.close()

    def onClearAllOverFromWeb(self, connection):
        self.onClearAllOver(caller = 'web')
        connection.send("Feedback\nOK")
        connection.close()

    def onRemoveFromWeb(self, info_hash, connection):
        indexlist = []
        status = ''
        i = 0
        for hash in info_hash.split(','):
            index = self.queue.getIDFromInfoHash(hash)
            if index == -1:
                status += str(i) + ':Hash not found,'
            else:
                indexlist.append(index)
            i += 1
        self.commandfromlist = False
        self.onRemove(indexlist = indexlist, caller = 'web')
        if status:
            connection.send("Feedback\nError=" + status[:-1])
        else:
            connection.send("Feedback\nOK")
        connection.close()

    def onResumeAllFromWeb(self, connection):
        self.queue.procRESUMEALL()
        connection.send("Feedback\nOK")
        connection.close()

    def onResumeFromWeb(self, info_hash, connection):
        indexlist = []
        status = ''
        i = 0
        for hash in info_hash.split(','):
            index = self.queue.getIDFromInfoHash(hash)
            if index == -1:
                status += str(i) + ':Hash not found,'
            indexlist.append(index)
            i += 1
        status += self.queue.procRESUME(indexlist, True, auto = False)
        if status:
            connection.send("Feedback\nError=" + status[:-1])
        else:
            connection.send("Feedback\nOK")
        connection.close()

    def onReseedResumeFromWeb(self, info_hash, connection):
        indexlist = []
        status = ''
        i = 0
        for hash in info_hash.split(','):
            index = self.queue.getIDFromInfoHash(hash)
            if index == -1:
                status += str(i) + ':Hash not found,'
            indexlist.append(index)
            i += 1
        status += self.queue.procRESUME(indexlist, True, auto = False, reseed = True)
        if status:
            connection.send("Feedback\nError=" + status[:-1])
        else:
            connection.send("Feedback\nOK")
        connection.close()

    def onStopAllFromWeb(self, connection):
        self.queue.procSTOPALL()
        connection.send("Feedback\nOK")
        connection.close()

    def onStopFromWeb(self, info_hash, connection):
        indexlist = []
        status = ''
        i = 0
        for hash in info_hash.split(','):
            index = self.queue.getIDFromInfoHash(hash)
            if index == -1:
                status += str(i) + ':Hash not found,'
            else:
                indexlist.append(index)
            i += 1
        self.queue.procSTOP(indexlist)
        if status:
            connection.send("Feedback\nError=" + status[:-1])
        else:
            connection.send("Feedback\nOK")
        connection.close()

    def onQueueAllFromWeb(self, connection):
        self.onQueueAll()
        connection.send("Feedback\nOK")
        connection.close()

    def onQueueFromWeb(self, info_hash, connection):
        indexlist = []
        status = ''
        i = 0
        for hash in info_hash.split(','):
            index = self.queue.getIDFromInfoHash(hash)
            if index == -1:
                status += str(i) + ':Hash not found,'
            else:
                indexlist.append(index)
            i += 1
        self.queue.procQUEUE(indexlist)
        if status:
            connection.send("Feedback\nError=" + status[:-1])
        else:
            connection.send("Feedback\nOK")
        connection.close()

    def onPauseAllFromWeb(self, pause, connection):
        self.onPauseAll(pause = pause)
        connection.send("Feedback\nOK")
        connection.close()

    def onPauseFromWeb(self, info_hash, connection):
        indexlist = []
        status = ''
        i = 0
        for hash in info_hash.split(','):
            index = self.queue.getIDFromInfoHash(hash)
            if index == -1:
                status += str(i) + ':Hash not found,'
            else:
                indexlist.append(index)
            i += 1
        self.queue.procPAUSE(indexlist)
        if status:
            connection.send("Feedback\nError=" + status[:-1])
        else:
            connection.send("Feedback\nOK")
        connection.close()

    def onPrioFromWeb(self, priorities, connection):
        rank = self.guiman.getRankfromID(7)
        status = ''
        i = 0
        for prio in priorities:
            index = self.queue.getIDFromInfoHash(prio[0])
            if index == -1:
                status += str(i) + ':Hash not found,'
            else:
                self.queue.proctab[index].priority = prio[1]
                if rank != -1:
                    self.list.SetStringItem(index, rank, self.utility.priorities_s[prio[1]])
            i += 1
        if status:
            connection.send("Feedback\nError=" + status[:-1])
        else:
            connection.send("Feedback\nOK")
        connection.close()

    def onMoveUpFromWeb(self, info_hash, connection):
        indexlist = []
        status = ''
        i = 0
        for hash in info_hash.split(','):
            index = self.queue.getIDFromInfoHash(hash)
            if index == -1:
                status += str(i) + ':Hash not found,'
            else:
                indexlist.append(index)
            i += 1
        if self.torrentlistloading:
            connection.send("Feedback\nError=Torrent list is still loading")
        else:
            self.moveremove = True
            if indexlist:
                indexlist.sort()
                self.queue.moveItemsUp(indexlist)
            self.moveremove = False
            if status:
                connection.send("Feedback\nError=" + status[:-1])
            else:
                connection.send("Feedback\nOK")
        connection.close()

    def onMoveDownFromWeb(self, info_hash, connection):
        indexlist = []
        status = ''
        i = 0
        for hash in info_hash.split(','):
            index = self.queue.getIDFromInfoHash(hash)
            if index == -1:
                status += str(i) + ':Hash not found,'
            else:
                indexlist.append(index)
            i += 1
        if self.torrentlistloading:
            connection.send("Feedback\nError=Torrent list is still loading")
        else:
            self.moveremove = True
            if indexlist:
                indexlist.sort()
                self.queue.moveItemsDown(indexlist)
            self.moveremove = False
            if status:
                connection.send("Feedback\nError=" + status[:-1])
            else:
                connection.send("Feedback\nOK")
        connection.close()

    def onMoveTopFromWeb(self, info_hash, connection):
        indexlist = []
        status = ''
        i = 0
        for hash in info_hash.split(','):
            index = self.queue.getIDFromInfoHash(hash)
            if index == -1:
                status += str(i) + ':Hash not found,'
            else:
                indexlist.append(index)
            i += 1
        if self.torrentlistloading:
            connection.send("Feedback\nError=Torrent list is still loading")
        else:
            indexlist.sort()
            self.itemMoveRow(indexlist, 0, scroll = False)
            if status:
                connection.send("Feedback\nError=" + status[:-1])
            else:
                connection.send("Feedback\nOK")
        connection.close()

    def onMoveBottomFromWeb(self, info_hash, connection):
        indexlist = []
        status = ''
        i = 0
        for hash in info_hash.split(','):
            index = self.queue.getIDFromInfoHash(hash)
            if index == -1:
                status += str(i) + ':Hash not found,'
            else:
                indexlist.append(index)
            i += 1
        if self.torrentlistloading:
            connection.send("Feedback\nError=Torrent list is still loading")
        else:
            indexlist.sort()
            self.itemMoveRow(indexlist, self.list.GetItemCount() - 1, scroll = False, forcebottom = True)
            if status:
                connection.send("Feedback\nError=" + status[:-1])
            else:
                connection.send("Feedback\nOK")
        connection.close()

    def onMoveBelowCompletedFromWeb(self, info_hash, connection):
        indexlist = []
        status = ''
        i = 0
        for hash in info_hash.split(','):
            index = self.queue.getIDFromInfoHash(hash)
            if index == -1:
                status += str(i) + ':Hash not found,'
            else:
                indexlist.append(index)
            i += 1
        if self.torrentlistloading:
            connection.send("Feedback\nError=Torrent list is still loading")
        else:
            if indexlist:
                indexlist.sort()
                nbitems = self.list.GetItemCount()
                row = self.findMiddleRow(indexlist)
                if indexlist[-1] + 1 == row:
                    for i in indexlist:
                        if i + 1 == nbitems or not self.queue.proctab[i + 1].complete:
                            row = self.findMiddleRow(indexlist, forcefinished = True)
                            break
                self.itemMoveRow(indexlist, row, scroll = False)
            if status:
                connection.send("Feedback\nError=" + status[:-1])
            else:
                connection.send("Feedback\nOK")
        connection.close()

    def onSuperseedFromWeb(self, info_hash, connection):
        indexlist = []
        status = ''
        i = 0
        for hash in info_hash.split(','):
            index = self.queue.getIDFromInfoHash(hash)
            if index == -1:
                status += str(i) + ':Hash not found,'
            indexlist.append(index)
            i += 1
        status += self.queue.procSUPERSEED(indexlist, caller = 'web')
        if status:
            connection.send("Feedback\nError=" + status[:-1])
        else:
            connection.send("Feedback\nOK")
        connection.close()

    def onCheckFromWeb(self, info_hash, connection):
        indexlist = []
        status = ''
        i = 0
        for hash in info_hash.split(','):
            index = self.queue.getIDFromInfoHash(hash)
            if index == -1:
                status += str(i) + ':Hash not found,'
            else:
                indexlist.append(index)
            i += 1
        self.queue.procCHECK(indexlist)
        if status:
            connection.send("Feedback\nError=" + status[:-1])
        else:
            connection.send("Feedback\nOK")
        connection.close()

    def onGetTorrentParamFromWeb(self, info_hash, connection):
        torrent = self.queue.getTorrentFromInfoHash(info_hash)
        if torrent is None:
            connection.send("Feedback\nError=Hash not found")
        else:
            retmsg = torrent.shortlabel + '|' + str(torrent.maxlocaldownloadrate) + '|' +\
                     str(torrent.prioritizedown) + '|' +\
                     str(torrent.maxupload) + '|' + str(torrent.maxlocaluploadrate) + '|' +\
                     str(torrent.prioritizeup) + '|' +\
                     str(10 * int(torrent.uploadtillcopycomplete) + torrent.uploadoption) + '|' +\
                     str(torrent.uploadtimeh) + '|' + str(torrent.uploadtimem) + '|' + str(torrent.uploadratio) + '|' +\
                     str(torrent.timeoutswitch) + '|' + str(torrent.timeoutaction) + '|' +\
                     str(torrent.timeoutwork) + '|' + str(torrent.timeoutworkdown) + '|' +\
                     str(torrent.timeoutworktrack) + '|' + str(torrent.timeoutseed) + '|' +\
                     str(torrent.timeoutseedup) + '|' + str(torrent.timeoutseedtrack) + '|' +\
                     str(torrent.timeouttracker) + '|' + str(torrent.timeoutdownload) + '|' +\
                     str(torrent.timeoutupload) + '|' + torrent.movefolder + '|' +\
                     str(torrent.extrainttracker) + '|' + torrent.inttrackerurl + '|' +\
                     str(torrent.exttracker) + '|' + torrent.exttrackerurl + '|' +\
                     str(torrent.checkinttrackwait)
            connection.send("Feedback\n" + self.utility.encodeWebServiceData(retmsg))
        connection.close()

    def onSetTorrentParamFromWeb(self, values, connection):
        index = self.queue.getIDFromInfoHash(values[0])
        if index == -1:
            connection.send("Feedback\nError=Hash not found")
        else:
            del values[0]
            tor_info = 27 * [None]
            for i in [0, 21, 23, 25]:
                tor_info[i] = values[i]
            for i in range(1, 21) + [22, 24, 26]:
                tor_info[i] = int(values[i])
            self.queue.changeLocalInfo([index], tor_info)
            connection.send("Feedback\nOK")
        connection.close()

    def onSetTorrentFilePrioFromWeb(self, values, connection):
        index = self.queue.getIDFromInfoHash(values[0])
        if index == -1:
            connection.send("Feedback\nError=Hash not found")
        else:
            torrent = self.queue.proctab[index]
            filenumber = int(values[1])
            prio = int(values[2])
            if torrent.singlefile or filenumber < 0 or filenumber >= torrent.filesnumber:
                connection.send("Feedback\nError=Invalid file number")
            else:
                if torrent.filespriority is None and prio != 1 or torrent.filespriority[filenumber] != prio:
                    torrent.changeFilePriorities([(filenumber, prio)], index)
                connection.send("Feedback\nOK")
        connection.close()

    def onRenameFromWeb(self, values, connection):
        index = self.queue.getIDFromInfoHash(values[0])
        if index == -1:
            connection.send("Feedback\nError=Hash not found")
        else:
            torrent = self.queue.proctab[index]
            newname = values[1]
            if values[2] == '1' and torrent.magnet != 1 and not torrent.abcengine:
                if sys.platform == 'win32':
                    newdest = newname.rstrip(whitespace + '.')
                    # Check if the torrent name is a valid Windows file name
                    fixeddest = self.utility.fixWindowsName(newdest)
                    if fixeddest:
                        connection.send("Feedback\nError=Invalid destination name")
                        connection.close()
                        return
                    newdest = path.join(path.split(torrent.dest)[0], newdest)
                    if not torrent.singlefile:
                        # Check path length for each file of the torrent
                        destlen = len(self.utility.completePath(newdest))
                        for f in torrent.getFileNames():
                            if len(f) + destlen > 258 or len(path.split(f)[0]) + destlen > 246 :
                                connection.send("Feedback\nError=Invalid destination name")
                                connection.close()
                                return
                        # Reset bit 4 in file name status
                        torrent.resetFileNameStatus(mask = 8)
                else:
                    newdest = path.join(path.split(torrent.dest)[0], newname)

                # Search for duplicate
                destlowercase = self.utility.completePath(newdest).lower()
                for t in self.queue.proctab:
                    if t != torrent and self.utility.completePath(t.dest).lower() == destlowercase:
                        connection.send("Feedback\nError=Duplicate destination")
                        connection.close()
                        return

                try:
                    rename(self.utility.completePath(torrent.dest), self.utility.completePath(newdest))
                except:
                    pass
                torrent.updateDestination(newdest)

            torrent.updateName(newname)
            connection.send("Feedback\nOK")
        connection.close()

    def onSetDownDestFromWeb(self, values, connection):
        index = self.queue.getIDFromInfoHash(values[0])
        if index == -1:
            connection.send("Feedback\nError=Hash not found")
        else:
            torrent = self.queue.proctab[index]
            if torrent.abcengine or torrent.status == 'queue' or torrent.status == 'standby' or torrent.ismovingdata:
                connection.send("Feedback\nError=Torrent is not stopped")
            else:
                newdowndestloc = values[1]
                if sys.platform == 'win32':
                    # Erase the final '\' except for a path like 'X:\'
                    if newdowndestloc and newdowndestloc[-1] == '\\' and (len(newdowndestloc) < 2 or newdowndestloc[-2] != ':'):
                        newdowndestloc = newdowndestloc[:-1]
                    newdowndestloc = newdowndestloc.rstrip(whitespace + '.')
                    if not self.utility.checkWinPath(None, newdowndestloc):
                        connection.send("Feedback\nError=Invalid download directory location")
                        connection.close()
                        return

                toolongdestpath = False
                if torrent.magnet == 1:
                    # Just update the location
                    newdest = path.join(newdowndestloc, path.split(torrent.dest)[1])
                    completedest = self.utility.completePath(newdest)
                    destlen = len(completedest)
                    if torrent.singlefile:
                        if destlen > self.utility.filepathmaxlength or len(path.split(completedest)[0]) > self.utility.pathmaxlength:
                            toolongdestpath = True
                    else:
                        # Check path length for each file of the torrent
                        for f in torrent.getFileNames():
                            if len(f) + destlen >= self.utility.filepathmaxlength or len(path.split(f)[0]) + destlen >= self.utility.pathmaxlength:
                                toolongdestpath = True
                                break
                    if toolongdestpath:
                        connection.send("Feedback\nError=Too long destination path")
                        connection.close()
                        return
                    if not torrent.singlefile:
                        # Reset bit 4 in file name status
                        torrent.resetFileNameStatus(mask = 8)

                else:
                    newdowndestname = values[2]
                    if sys.platform == 'win32':
                        newdowndestname = newdowndestname.rstrip(whitespace + '.')
                        # Check if the torrent name is a valid Windows file name
                        fixedname = self.utility.fixWindowsName(newdowndestname)
                        if fixedname:
                            connection.send("Feedback\nError=Invalid download directory or file name")
                            connection.close()
                            return
                    newdest = path.join(newdowndestloc, newdowndestname)
                    completedest = self.utility.completePath(newdest)
                    destlen = len(completedest)
                    if torrent.singlefile:
                        if destlen > self.utility.filepathmaxlength or len(path.split(completedest)[0]) > self.utility.pathmaxlength:
                            toolongdestpath = True
                    else:
                        # Check path length for each file of the torrent
                        for f in torrent.getFileNames():
                            if len(f) + destlen >= self.utility.filepathmaxlength or len(path.split(f)[0]) + destlen >= self.utility.pathmaxlength:
                                toolongdestpath = True
                                break
                    if toolongdestpath:
                        connection.send("Feedback\nError=Too long destination path")
                        connection.close()
                        return
                    if not self.torrent.singlefile:
                        # Reset bit 4 in file name status
                        torrent.resetFileNameStatus(mask = 8)

                # Search for duplicate
                destlowercase = self.utility.completePath(newdest).lower()
                for t in self.queue.proctab:
                    if t != torrent and self.utility.completePath(t.dest).lower() == destlowercase:
                        connection.send("Feedback\nError=Duplicate destination")
                        connection.close()
                        return

                olddest = self.utility.completePath(torrent.dest)
                self.queue.changeProcDest(torrent, newdest, int(values[3]) and torrent.magnet != 1)
                if values[4] == '1' and self.utility.completePath(torrent.dest).lower() != olddest.lower():
                    self.queue.dataMovingToNewDestThread(torrent, olddest)
                connection.send("Feedback\nOK")
        connection.close()

    def onGetTorrentDataFromWeb(self, values, connection):
        torrent = self.queue.getTorrentFromInfoHash(values[0])
        if torrent is None:
            connection.send("Feedback\nError=Hash not found")
        else:
            retmsg = u''
            if values[1] == "MAIN" or values[1] == "ALL":
                metainfo = torrent.getResponse()
                info = metainfo['info']
                # Original torrent name
                if info.has_key('name.utf-8'):
                    namekey = 'name.utf-8'
                else:
                    namekey = 'name'
                origtorname = self.utility.decodeString(info[namekey])
                # Date
                if metainfo.has_key('creation date'):
                    try:
                        date = strftime('%x %X',localtime(metainfo['creation date']))
                    except:
                        date = '<cannot read date>'
                else:
                    date = '<no date>'
                # Comment
                if metainfo.has_key('comment.utf-8'):
                    commentkey = 'comment.utf-8'
                elif metainfo.has_key('comment'):
                    commentkey = 'comment'
                else:
                    commentkey = ''
                if commentkey:
                    comment = self.utility.decodeString(metainfo[commentkey])
                else:
                    comment = u''
                # Announce URLs
                announce = ''
                if metainfo.has_key('announce'):
                    singleannounce = self.utility.decodeString(metainfo['announce'])
                    announce = '(' + singleannounce + ')'
                if metainfo.has_key('announce-list'):
                    for tier in metainfo['announce-list']:
                        announce += ',('
                        for t in tier:
                            multiannounce = self.utility.decodeString(t)
                            announce += multiannounce + ','
                        announce = announce[:-1] + ')'
                # Progress
                if torrent.abcengine:
                    progress = torrent.abcengine.formatedProgress()
                else:
                    progress = torrent.formatedProgress()
                retmsg = origtorname + '|' + torrent.name + '|' + str(int(torrent.singlefile)) + '|' +\
                         torrent.src + '|' + str(torrent.totalsize) + '|' + str(info['piece length']) +\
                         '|' + date + '|' + str(len(comment)) + ':' + comment + '|' + announce + '|' +\
                         torrent.dest + '|' + self.localize(torrent.status) + '|' + progress + '|'
            if (values[1] == "FILES" or values[1] == "ALL") and not torrent.singlefile:
                filesizes = []
                filesinfo = torrent.getResponse()['info']['files']
                for f in filesinfo:
                    filesizes.append(f['length'])
                filesname = torrent.getFileNames(filesinfo)
                if torrent.abcengine:
                    torrent.abcengine.reportProgress()
                for i in xrange(torrent.filesnumber):
                    retmsg += filesname[i] + '|' + str(filesizes[i]) + '|'
                    if torrent.filespriority is None:
                        retmsg += '1|'
                    else:
                        retmsg += str(torrent.filespriority[i]) + '|'
                    if torrent.filesprogress is None:
                        retmsg += '0|'
                    else:
                        retmsg += torrent.filesprogress[i] + '|'
            connection.send("Feedback\n" + self.utility.encodeWebServiceData(retmsg[:-1]))
        connection.close()

    def onRenameTorrentFileFromWeb(self, values, connection):
        torrent = self.queue.getTorrentFromInfoHash(values[0])
        if torrent is None:
            connection.send("Feedback\nError=Hash not found")
        else:
            if torrent.singlefile:
                connection.send("Feedback\nError=Torrent is not multi-file")
            else:
                filenumbers = map(int, values[1].split(","))
                for n in filenumbers:
                    if n >= torrent.filesnumber:
                        connection.send("Feedback\nError=Invalid file number")
                        connection.close()
                        return
                if torrent.abcengine:
                    connection.send("Feedback\nError=Torrent is running")
                else:
                    filesname = torrent.getFileNames()
                    status = torrent.renameFiles(filenumbers, filesname, newname = values[2], caller = 'web')
                    if status:
                        connection.send("Feedback\nError=" + status)
                    else:
                        # Update metainfoframe if open
                        if torrent.infowin is not None:
                            torrent.infowin.filesname = filesname
                            torrent.infowin.updateNames(filenumbers)
                        connection.send("Feedback\nOK")
        connection.close()


##############################################################
# Class : ABCStatusBar
#
# ABC_OKC statusbar
#
############################################################## 
class ABCStatusBar(wx.StatusBar):
    def __init__(self, parent):
        self.parent = parent
        self.utility = self.parent.utility
        self.abcparams = self.utility.abcparams
        self.statusbarshift = int(self.abcparams['statusbarshift'])
        wx.StatusBar.__init__(self, self.parent, -1, style = 0)
        self.SetFieldsCount(11)
        self.statusbarwidths = [-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        self.setText(self.parent.localize('sb_L') + '0 ', 1)
        self.setText(self.parent.localize('sb_CX') + '0 ', 8)
        if self.utility.maxdown:
            sbstring = self.parent.localize('sb_DL') + '0/%u ' % self.utility.maxdown + self.utility.kbps + ' '
        else:
            sbstring = self.parent.localize('sb_DL') + '0 ' + self.utility.kbps + ' '
        if self.abcparams['displaydownvol'] == '1':
            sbstring += '0% '
        self.setText(sbstring, 9)
        if self.abcparams['urmdynmaxuprate'] == "0":
            maxuploadrate = self.utility.maxseedup
        else:
            maxuploadrate = self.utility.maxsysup
        if maxuploadrate:
            sbstring = self.parent.localize('sb_UL') + '0/%u ' % maxuploadrate + self.utility.kbps + ' '
        else:
            sbstring = self.parent.localize('sb_UL') + '0 ' + self.utility.kbps + ' '
        if self.abcparams['displayupvol'] == '1':
            sbstring += '0% '
        self.setText(sbstring, 10, True)
        self.setWidths()
        self.Bind(wx.EVT_LEFT_DOWN, self.onLeftDown)
        self.Bind(wx.EVT_RIGHT_DOWN, self.onRightDown)
        self.Bind(wx.EVT_ENTER_WINDOW, self.setToolTip)

    def setText(self, text, cell, extrawidth = False, win10fix = 0):
        # Returns True if width has changed
        self.SetStatusText(text, cell)
        newwidth = self.GetTextExtent(text)[0] + self.statusbarshift + win10fix
        if extrawidth:
            newwidth += 2
        if newwidth == self.statusbarwidths[cell]:
            return False
        self.statusbarwidths[cell] = newwidth
        return True

    def setToolTip(self, event):
        tooltipstring = self.GetStatusText(0)
        if tooltipstring and self.GetTextExtent(tooltipstring)[0] > self.GetFieldRect(0)[2]:
            self.SetToolTipString(tooltipstring)
        else:
            self.SetToolTipString('')

    def setWidths(self):
        self.SetStatusWidths(self.statusbarwidths)

    def showCell(self, cell):
        self.setText(self.GetStatusText(cell), cell)
        self.setWidths()

    def hideCell(self, cell):
        self.statusbarwidths[cell] = 0
        self.setWidths()

    def isCellClicked(self, event, cell):
        x, y = event.GetPosition()
        fieldx, fieldy, fieldw, fieldh = self.GetFieldRect(cell)
        if fieldx < x < fieldx + fieldw and fieldy < y < fieldy + fieldh:
            return True
        return False

    def onLeftDown(self, event):
        if not self.parent.window.torrentlistloading:
            if self.isCellClicked(event, 0):
                if self.abcparams['clearstatusbutton'] == '1':
                    self.SetStatusText("", 0)
            elif self.isCellClicked(event, 9):
                self.parent.onMenuABCOption(tab = 0)
            elif self.isCellClicked(event, 10):
                self.parent.onMenuABCOption(tab = 1)

    def onRightDown(self, event):
        if not self.parent.window.torrentlistloading:
            if self.isCellClicked(event, 0):
                if self.abcparams['clearstatusbutton'] == '2':
                    self.SetStatusText("", 0)
            elif self.isCellClicked(event, 9) or self.isCellClicked(event, 10):
                self.parent.onMenuABCOption()


##############################################################
# Class : ABCFrame
#
# Main ABC_OKC frame class that contains menu, menu bar management
# and ABCPanel
#
############################################################## 
class ABCFrame(wx.Frame):
    def __init__(self, parent, ID, params, utility):
        self.utility = utility
        self.localize = self.utility.lang.get
        self.abcparams = self.utility.abcparams

        self.language = self.abcparams['language_file']

        # Save default HTTP user agent identifier
        self.defuseragent = USERAGENT[0]
        self.defuserextended = USERAGENT[1]
        # Set HTTP useragent if it has been customized
        useragentnb = self.abcparams['useragentid']
        if useragentnb != '0':
            setUserAgent(self.abcparams['useragent' + useragentnb], self.abcparams['userextended' + useragentnb])
        # Set peer ID
        setPeerID()

        title = self.localize('mainwindowtitle')
        if self.abcparams['trigwhenfinishseed'] == "2":
            title += self.localize('schedmodeseedcap')

        self.guiman = GUIManager(self.utility.datapath)
        if self.abcparams['initlang'] == '1':
            # Reset the strings of the torrent list headers to their default value
            for col in xrange(4, self.guiman.maxid):
                self.guiman.configdata[col][2] = self.localize('colname' + str(col))
                self.guiman.configdata[col][4] = self.localize('colinfo' + str(col))
            self.guiman.writeIni()
            self.abcparams['initlang'] = '0'

        self.x = max(0, int(self.abcparams['mainwindowx']))
        self.y = max(0, int(self.abcparams['mainwindowy']))
        self.w = self.guiman.getMainWidth()
        self.h = self.guiman.getMainHeight()

        wx.Frame.__init__(self, parent, ID, title, (self.x, self.y), (self.w, self.h),
                          style = wx.DEFAULT_FRAME_STYLE & ~ wx.CLOSE_BOX)

        # Template manager
        self.tempmanager = TemplateManager(self)

        # Connection limiter manager
        self.conlimitermanager = ConLimiterManager(self)

        self.params = params
        self.configchange = 0
        self.abcoptiondlg = None
        self.abcparamtemplatedlg = None
        self.abcconlimiterdlg = None
        self.abcdhtaddnodedlg = None
        self.abcfind = None
        self.abctweak = None
        self.abcschedulerdlg = None
        self.abcscannerdlg = None
        self.abcwebdlg = None
        self.maketorrent = None
        self.checkdlg = None
        self.aboutmedlg = None
        self.exitdialog = None
        self.webserver = None
        self.taskbariconized = False

        self.abc_sb = ABCStatusBar(self)
        self.SetStatusBar(self.abc_sb)
        # Workaround to prevent the toolbar from remembering the status bar text on the first
        # time the mouse is hovering over it and then displaying this text back in the status bar when
        # the mouse leaves the toolbar whereas this text is no longer appropriate.
        # The automatic display of help text in the status bar is disabled while the torrent list is loading.
        self.SetStatusBarPane(-1)

        # Main toolbar Ids
        self.maintoolbarids = []

        if sys.platform == 'win32':
            self.icon = wx.Icon(path.join(self.utility.abcpath, 'icon_abc.ico'), wx.BITMAP_TYPE_ICO)
            self.SetIcon(self.icon)

        # Id for popup menus
        # 800-899 : templates
        # 900-903 : priority for files inside torrent
        # 904-908 : torrent priority
        # 909-914 : seeding time for complete and shut down
        # 915 : show original file names toggle
        # 916 : download selected
        # 917 : rename file inside torrent
        # 918 : copy name of file inside torrent
        # 919 : copy URL
        # 920 : use as external tracker
        # 921 : re-scan all
        # 922 : save peers
        # 923 : load peers
        # 924 : copy connected peers
        # 925 : copy saved peers
        # 926 : clear peers
        # 927 : rename file inside torrent from clipboard
        # 928 : RSS copy article
        # 929 : RSS copy selected text in article
        # 930 : RSS download
        # 931 : RSS copy URL
        # 932 : RSS copy title
        # 933 : RSS browser
        # 934 : RSS stop scanning submenu
        # 935 : RSS stop URL scan
        # 936 : RSS stop all URL scan
        # 937 : RSS view source
        # 938 : RSS view content
        # 939 : RSS copy title link
        # 940 : peer action submenu
        # 941 : peer client info
        # 942 : copy peer
        # 943 : copy peer + client/ID
        # 944 : kick peer
        # 945 : ban peer
        # 946 : copy peer with remote port
        # 950-953 : sorting lock option
        # 954-956 : on idle option
        # 957-959 : command scheduler actions
        # 960-979 : command scheduler commands
        # 980-999 : command scheduler values
        # Main popup menu
        # 1000 : template submenu
        # 1001 : fast resume
        # 1002 : resume
        # 1003 : stop
        # 1004 : pause
        # 1005 : queue
        # 1006 : standby
        # 1007 : superseed
        # 1008 : complete shutdown submenu
        # 1009 : complete shutdown add
        # 1010 : complete shutdown show
        # 1011 : complete shutdown seeding time submenu
        # 1012 : complete shutdown reset
        # 1013 : priority submenu
        # 1014 : check
        # 1015 : clear message
        # 1016 : remove torrent
        # 1017 : remove torrent and data
        # 1018 : export submenu
        # 1019 : export copy
        # 1020 : export extract
        # 1021 : export extract and remove data
        # 1022 : parameters
        # 1023 : rename
        # 1024 : change destination
        # 1025 : open destination
        # 1026 : current seeds/peers
        # 1027 : details
        # 1028 : advanced details
        # 1029 : advanced features submenu
        # 1030 : manual announce
        # 1031 : finish allocation
        # 1032 : reset seeding rules
        # 1033 : add peers
        # 1034 : sort finished and completed at top
        # 1035 : sort finished at top
        # 1036 : sort selected block
        # 1037 : reset list sorting cycle
        # 1038 : Fix long names inside torrent
        # 1039 : RSS search for title in list
        # 1040 : copy original name of files inside torrent
        # 1041 : reset file names inside torrent to original names
        # 1042 : find string in details window file list
        # 1043 : select invalid file names in details window file list
        # 1044 : RSS search for stripped title in list
        # 1045 : RSS copy stripped title
        # 1046 : main popup menu retrieve metadata

        for i in xrange(800, 1047):
            wx.RegisterId(i)

        self.TBMENU_RESTORE = wx.NewId()
        self.TBMENU_CLOSE = wx.NewId()

        # Create Tools Menu
        self.menutools = wx.Menu()

        findId = self.registerMenuEvent(self.onMenuFind)
        self.menutools.Append(findId, self.localize('menuabcfind'),
                              self.localize('menuabcfindmsg'))
        schedulerId = self.registerMenuEvent(self.onMenuScheduler)
        self.menutools.Append(schedulerId, self.localize('menuscheduler'),
                              self.localize('menuschedulermsg'))
        scannerId = self.registerMenuEvent(self.onMenuScanner)
        self.menutools.Append(scannerId, self.localize('menuscanner'),
                              self.localize('menuscannermsg'))
        webId = self.registerMenuEvent(self.onMenuWebService)
        self.menutools.Append(webId, self.localize('menuwebinterfaceservice'),
                              self.localize('menuwebinterfaceservicemsg'))
        createId = self.registerMenuEvent(self.onMenuMakeTorrent)
        self.menutools.Append(createId, self.localize('menucreatetorrent'),
                              self.localize('menucreatetorrentmsg'))
        self.menutools.AppendSeparator()
        self.menurestartid = self.registerMenuEvent(self.onMenuRestart)
        self.menutools.Append(self.menurestartid, self.localize('menurestart'), self.localize('menurestartmsg'))
        self.menutools.AppendSeparator()
        self.menuexitid = self.registerMenuEvent(self.onMenuExit)
        self.menutools.Append(self.menuexitid, self.localize('menuexit'), self.localize('menuexitmsg'))

        # Create Settings Menu
        self.menusettings = wx.Menu()

        self.menutweakid = self.registerMenuEvent(self.onMenuTweak)
        self.menusettings.Append(self.menutweakid, self.localize('menuabctweak'), self.localize('menuabctweakmsg'))
        self.menuparamtemplateid = self.registerMenuEvent(self.onMenuTemplate)
        self.menusettings.Append(self.menuparamtemplateid, self.localize('menuparamtemplate'),
                                 self.localize('menuparamtemplatemsg'))
        self.menuconlimiterid = self.registerMenuEvent(self.onMenuConLimiter)
        self.menusettings.Append(self.menuconlimiterid, self.localize('menuconlimiter'),
                                 self.localize('menuconlimitermsg'))
        self.menuabcoptionid = self.registerMenuEvent(self.onMenuABCOption)
        self.menusettings.Append(self.menuabcoptionid, self.localize('menuabcpreference'),
                                 self.localize('menuabcpreferencemsg'))
        self.menusettings.AppendSeparator()
        self.menudhtaddnodeid = self.registerMenuEvent(self.onMenuDHTAddNode)
        self.menusettings.Append(self.menudhtaddnodeid, self.localize('menudhtaddnode'),
                                 self.localize('menudhtaddnodemsg'))
        self.menusettings.AppendSeparator()
        self.Bind(wx.EVT_MENU, self.onTransOver, id = 954, id2 = 956)
        self.idlesubmenu = wx.Menu()
        self.idlesubmenu.Append(954, self.localize('menudonothing'), self.localize('menudonothing'), wx.ITEM_RADIO)
        self.idlesubmenu.Append(955, self.localize('menuclose'), self.localize('menuclose'), wx.ITEM_RADIO)
        self.idlesubmenu.Append(956, self.localize('menushutdown'), self.localize('menushutdown'), wx.ITEM_RADIO)
        self.idlesubmenuid = wx.NewId()
        self.menusettings.AppendMenu(self.idlesubmenuid, self.localize('menutransover'), self.idlesubmenu)

        # Create Version Menu
        self.menuversion = wx.Menu()

        if self.abcparams['showcheckversion'] == '1':
            self.menuchecklatestversionid = self.registerMenuEvent(self.onCheckLatestVersion)
            self.menuversion.Append(self.menuchecklatestversionid, self.localize('menuchecklatestversion'),
                                    self.localize('menuchecklatestversionmsg'))       
        self.menuversion.Append(self.registerMenuEvent(self.onMenuAbout), self.localize('menuaboutabc'),
                                self.localize('menuaboutabcmsg'))

        self.menubar = wx.MenuBar()
        self.menubar.Append(self.menutools, self.localize('menutools'))
        self.menubar.Append(self.menusettings, self.localize('menusettings'))
        self.menubar.Append(self.menuversion, self.localize('menuversion'))
        self.SetMenuBar(self.menubar)

        self.menutools.Enable(self.menurestartid, False)
        self.menutools.Enable(self.menuexitid, False)
        self.menusettings.Enable(self.menutweakid, False)
        self.menusettings.Enable(self.menuparamtemplateid, False)
        self.menusettings.Enable(self.menuconlimiterid, False)
        self.menusettings.Enable(self.menuabcoptionid, False)
        self.menusettings.Enable(self.menudhtaddnodeid, False)
        self.menusettings.Enable(self.idlesubmenuid, False)

        # Accelerator table
        self.accelerators = wx.AcceleratorTable([(wx.ACCEL_NORMAL, wx.WXK_F1, findId),
                                                 (wx.ACCEL_NORMAL, wx.WXK_F2, schedulerId),
                                                 (wx.ACCEL_NORMAL, wx.WXK_F3, scannerId),
                                                 (wx.ACCEL_NORMAL, wx.WXK_F4, webId),
                                                 (wx.ACCEL_NORMAL, wx.WXK_F5, createId)])
        self.SetAcceleratorTable(self.accelerators)

        self.window = ABCPanel(self, self.params, self.utility, self.guiman, self.tempmanager, self.conlimitermanager)

        ###############################################
        # Add Tool Bar
        ###############################################
        tbstyle = wx.TB_HORIZONTAL | wx.NO_BORDER | wx.TB_TEXT
        if self.abcparams['flattopbtn'] == "1":
            tbstyle |= wx.TB_FLAT
        self.tb = self.CreateToolBar(tbstyle)
        if self.abcparams['flattopbtn'] == "1":
            self.tb.SetMargins((0, 2))
        self.maintoolbarids.append(self.utility.addToolbarIcon(self, self.tb, self.window.displayTransfer, self.localize('displaytrans_short'),
                                   self.localize('displaytrans_long'), 'transfer.bmp', type = 'radio', firsttime = True))
        self.maintoolbarids.append(self.utility.addToolbarIcon(self, self.tb, self.window.displayRSS, self.localize('displayrss_short'),
                                   self.localize('displayrss_long'), 'rss.bmp', type = 'radio'))
        self.tb.AddSeparator()
        self.maintoolbarids.append(self.utility.addToolbarIcon(self, self.tb, self.window.addTorrentFile, self.localize('addtorrentfile_short'),
                                   self.localize('addtorrentfile_long'), 'addtorrent.bmp'))
        self.maintoolbarids.append(self.utility.addToolbarIcon(self, self.tb, self.window.addTorrentNoneDefault, self.localize('addtorrentfiletonondefault_short'),
                                   self.localize('addtorrentfiletonondefault_long'), 'addtorrentnondefault.bmp'))
        self.maintoolbarids.append(self.utility.addToolbarIcon(self, self.tb, self.window.addTorrentLink, self.localize('addtorrenturl_short'),
                                   self.localize('addtorrenturl_long'), 'addtorrenturl.bmp'))
        self.tb.AddSeparator()
        self.maintoolbarids.append(self.utility.addToolbarIcon(self, self.tb, self.onResumeBtn, self.localize('tb_resume_short'),
                                   self.localize('tb_resume_long'), 'resume.bmp'))
        self.maintoolbarids.append(self.utility.addToolbarIcon(self, self.tb, self.onFastResumeBtn, self.localize('tb_fastresume_short'),
                                   self.localize('tb_fastresume_long'), 'fastresume.bmp'))
        self.maintoolbarids.append(self.utility.addToolbarIcon(self, self.tb, self.onPauseBtn, self.localize('tb_pause_short'),
                                   self.localize('tb_pause_long'), 'pause.bmp'))
        self.maintoolbarids.append(self.utility.addToolbarIcon(self, self.tb, self.onStopBtn, self.localize('tb_stop_short'),
                                   self.localize('tb_stop_long'), 'stop.bmp'))
        self.maintoolbarids.append(self.utility.addToolbarIcon(self, self.tb, self.onQueueBtn, self.localize('tb_queue_short'),
                                   self.localize('tb_queue_long'), 'queue.bmp'))
        self.tb.AddSeparator()
        self.maintoolbarids.append(self.utility.addToolbarIcon(self, self.tb, self.onRemoveBtn, self.localize('tb_delete_short'),
                                   self.localize('tb_delete_long'), 'delete.bmp'))
        self.tb.AddSeparator()
        self.maintoolbarids.append(self.utility.addToolbarIcon(self, self.tb, self.onTorrentInfoBtn, self.localize('tb_torrentdetail_short'),
                                   self.localize('tb_torrentdetail_long'), 'torrentdetail.bmp'))
        self.maintoolbarids.append(self.utility.addToolbarIcon(self, self.tb, self.onDetailsBtn, self.localize('tb_advdetail_short'),
                                   self.localize('tb_advdetail_long'), 'advdetail.bmp'))
        self.maintoolbarids.append(self.utility.addToolbarIcon(self, self.tb, self.onDisplayScrapeBtn, self.localize('tb_spy_short'),
                                   self.localize('tb_spy_long'), 'currentseedpeer.bmp'))

        self.tb.Realize()

        # Menu Events 
        ############################

        self.Bind(wx.EVT_CLOSE, self.onMenuExit)

        if sys.platform == 'win32':
            self.tbicon = wx.TaskBarIcon()
            self.Bind(wx.EVT_ICONIZE, self.onIconify)

            self.menutray = wx.Menu(self.localize('trayheader'))
            self.menutray.Append(self.TBMENU_RESTORE, self.localize('trayshowabc'))
            self.menutray.Append(self.TBMENU_CLOSE, self.localize('trayexitabc'))
            if self.window.initializing:
                self.menutray.Enable(self.TBMENU_CLOSE, False)

            # Setup a taskbar icon, and catch some events from it
            self.tbicon.Bind(wx.EVT_TASKBAR_LEFT_UP, self.onTaskBarActivate)
            self.tbicon.Bind(wx.EVT_TASKBAR_RIGHT_UP, self.onTaskBarMenu)
            self.tbicon.Bind(wx.EVT_MENU, self.onTaskBarActivate, id = self.TBMENU_RESTORE)
            self.tbicon.Bind(wx.EVT_MENU, self.onMenuExit, id = self.TBMENU_CLOSE)

        self.Bind(wx.EVT_SIZE, self.onSize)
        self.Bind(wx.EVT_MOVE, self.onMove)

    def onSize(self, event):
        if not self.IsIconized() and not self.IsMaximized():
            self.w, self.h = self.GetSizeTuple()
        event.Skip()

    def onMove(self, event):
        if not self.IsIconized() and not self.IsMaximized():
            self.x, self.y = self.GetPositionTuple()
        event.Skip()

    def setToolbarStyle(self, style):
        self.tb.SetWindowStyle(style)
        self.tb.Refresh()
        self.Layout()

    def onResumeBtn(self, event):
        self.window.commandfromlist = True
        self.window.windowparent = self.window
        self.window.onResume(event)

    def onFastResumeBtn(self, event):
        self.window.commandfromlist = True
        self.window.windowparent = self.window
        self.window.onFastResume(event)

    def onPauseBtn(self, event):
        self.window.commandfromlist = True
        self.window.onPause(event)

    def onStopBtn(self, event):
        self.window.commandfromlist = True
        self.window.onStop(event)

    def onQueueBtn(self, event):
        self.window.commandfromlist = True
        self.window.onQueue(event)

    def onRemoveBtn(self, event):
        self.window.commandfromlist = True
        self.window.windowparent = self.window
        self.window.onRemove(event)

    def onDisplayScrapeBtn(self, event):
        self.window.commandfromlist = True
        self.window.windowparent = self.window
        self.window.onDisplayScrape(event)

    def onTorrentInfoBtn(self, event):
        self.window.commandfromlist = True
        self.window.windowparent = self.window
        self.window.onTorrentInfo(event)

    def onDetailsBtn(self, event):
        self.window.commandfromlist = True
        self.window.windowparent = self.window
        self.window.onDetails(event)

    def registerMenuEvent(self, event):
        newid = wx.NewId()
        self.Bind(wx.EVT_MENU, event, id = newid)
        return newid

    #######################################
    # Minimize to tray
    #######################################
    def onIconify(self, evt):
        if evt.Iconized():
            if self.abctweak is not None:
                self.abctweak.OnExit()
            if self.abcparams['mintray'] == "1":
                self.tbicon.SetIcon(self.icon, "ABC_OKC")
                self.Hide()
                self.taskbariconized = True
            self.utility.GUIupdaterate = self.utility.GUIupdaterate_slow
        else:
            self.utility.GUIupdaterate = self.utility.GUIupdaterate_fast
            wx.CallAfter(self.setFocus)

    def onTaskBarActivate(self, evt = None):
        try:
            if self.window.exiting:
                return
        except:
            return
        self.utility.GUIupdaterate = self.utility.GUIupdaterate_fast
        self.taskbariconized = False
        self.Raise()
        self.Iconize(False)
        self.setFocus()
        # If next missing then Python fails when OK over ABCOptions ??
        self.Show()
        self.tbicon.RemoveIcon()

    def onTaskBarMenu(self, evt):
        try:
            if self.window.exiting:
                return
        except:
            return
        self.tbicon.PopupMenu(self.menutray)

    def restore(self):
        if self.taskbariconized:
            self.onTaskBarActivate()
        else:
            if self.IsIconized():
                self.utility.GUIupdaterate = self.utility.GUIupdaterate_fast
                self.Iconize(False)
            else:
                self.Raise()
        # Next sleep to avoid a problem in windows Z-ordering with Firefox
        sleep(0.2)

    def setFocus(self):
        if self.window.list.IsShown():
            self.window.list.SetFocus()
        elif self.window.rsspanel.IsShown():
            self.window.rsspanel.SetFocus()

    ################################
    # Display ABC_OKC option dialog
    ################################
    def onMenuABCOption(self, event = None, tab = None):
        self.abcoptiondlg = ABCOptionDialog(self, -1, self.localize('abcpreference'), tab = tab)
        self.abcoptiondlg.ShowModal()
        if self.abcoptiondlg.tabhaschanged :
            self.abcparams['lastopenabcoptab'] = str(self.abcoptiondlg.notebook.GetSelection())
        x, y = self.abcoptiondlg.GetPositionTuple()
        self.abcparams['abcoptiondlgx'], self.abcparams['abcoptiondlgy'] = str(x), str(y)
        self.abcoptiondlg.Destroy()
        self.abcoptiondlg = None

    ################################
    # Display templates dialog
    ################################
    def onMenuTemplate(self, event):
        self.abcparamtemplatedlg = TemplateDialog(self, -1, self.localize('paramtemplatesetting'), self.tempmanager)
        self.abcparamtemplatedlg.ShowModal()
        self.abcparams['lastopentemptab'] = str(self.abcparamtemplatedlg.notebook.GetSelection())
        x, y = self.abcparamtemplatedlg.GetPositionTuple()
        self.abcparams['templatedlgx'], self.abcparams['templatedlgy'] = str(x), str(y)
        self.abcparamtemplatedlg.Destroy()
        self.abcparamtemplatedlg = None

    ################################
    # Display connection limiters dialog
    ################################
    def onMenuConLimiter(self, event):
        self.abcconlimiterdlg = ConLimiterDialog(self, -1, self.localize('conlimitersetting'), self.conlimitermanager)
        self.abcconlimiterdlg.ShowModal()
        x, y = self.abcconlimiterdlg.GetPositionTuple()
        self.abcparams['conlimiterdlgx'], self.abcparams['conlimiterdlgy'] = str(x), str(y)
        self.abcconlimiterdlg.Destroy()
        self.abcconlimiterdlg = None

    ################################
    # Display dialog for adding DHT nodes
    ################################
    def onMenuDHTAddNode(self, event):
        if not self.window.queue.dht:
            dlg = wx.MessageDialog(self, message = self.localize('dhtnotstarted'), 
                                   caption = self.localize('abcokcerror'), style = wx.OK | wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return
        self.abcdhtaddnodedlg = DHTAddNodeDialog(self, -1, self.localize('dhtaddnodesetting'), self.window.queue.dht)
        self.abcdhtaddnodedlg.ShowModal()
        x, y = self.abcdhtaddnodedlg.GetPositionTuple()
        self.abcparams['dhtaddnodedlgx'], self.abcparams['dhtaddnodedlgy'] = str(x), str(y)
        self.abcdhtaddnodedlg.Destroy()
        self.abcdhtaddnodedlg = None

    ################################
    # Sets options when transfers are over
    ################################
    def onTransOver(self, event):
        self.window.queue.whenidle = event.GetId() - 954
        self.window.queue.checkIdleForClosing()

    ################################
    # Running ABC_OKC find
    ################################
    def onMenuFind(self, event = None):
        if self.abcfind is not None:
            if self.abcfind.IsIconized():
                self.abcfind.Iconize(False)
            self.abcfind.Raise()
        else:
            self.abcfind = ABCFindFrame(self, -1, self.localize('abcfind'), self.abcparams)
            self.abcfind.Show()

    ################################
    # Running ABC_OKC tweak
    ################################
    def onMenuTweak(self, event):
        if self.window.torrentlistloading:
            return
        if self.abctweak is not None:
            if self.abctweak.IsIconized():
                self.abctweak.Iconize(False)
            self.abctweak.Raise()
        else:
            self.abctweak = ABCTweakFrame(self, -1, self.localize('abctweak'))
            self.abctweak.Show()

    ################################
    # Display command scheduler dialog
    ################################
    def onMenuScheduler(self, event):
        self.abcschedulerdlg = CommandSchedulerDialog(self, -1, self.localize('scheduler'), self.window.commandscheduler)
        self.abcschedulerdlg.ShowModal()
        x, y = self.abcschedulerdlg.GetPositionTuple()
        self.abcparams['schedulerdlgx'], self.abcparams['schedulerdlgy'] = str(x), str(y)
        self.abcschedulerdlg.Destroy()
        self.abcschedulerdlg = None

    ################################
    # Display scanner dialog
    ################################
    def onMenuScanner(self, event):
        self.abcscannerdlg = ScannerDialog(self, -1, self.localize('scanner'))
        self.abcscannerdlg.ShowModal()
        x, y = self.abcscannerdlg.GetPositionTuple()
        self.abcparams['scannerdlgx'], self.abcparams['scannerdlgy'] = str(x), str(y)
        self.abcscannerdlg.Destroy()
        self.abcscannerdlg = None

    ################################
    # Display web service Dialog
    ################################
    def onMenuWebService(self, event):
        self.abcwebdlg = WebDialog(self, -1, self.localize('webinterfaceservice'))
        self.abcwebdlg.ShowModal()
        x, y = self.abcwebdlg.GetPositionTuple()
        self.abcparams['webservicedlgx'], self.abcparams['webservicedlgy'] = str(x), str(y)
        self.abcwebdlg.Destroy()
        self.abcwebdlg = None

    ################################
    # Display torrent maker dialog
    ################################
    def onMenuMakeTorrent(self, event = None):
        if self.maketorrent is not None:
            if self.maketorrent.IsIconized():
                self.maketorrent.Iconize(False)
            self.maketorrent.Raise()
        else:
            self.maketorrent = DownloadInfo(self, -1, self.localize('btfilemakertitle'))
            self.maketorrent.Show()

    ################################
    # Display about me dialog
    ################################
    def onMenuAbout(self, event):
        self.aboutmedlg = AboutMeDialog(self, -1, self.localize('aboutabc'))
        self.aboutmedlg.ShowModal()
        x, y = self.aboutmedlg.GetPositionTuple()
        self.abcparams['aboutmedlgx'], self.abcparams['aboutmedlgy'] = str(x), str(y)
        self.aboutmedlg.Destroy()
        self.aboutmedlg = None

    ################################
    # Display check latest version dialog
    ################################
    def onCheckLatestVersion(self, event):
        def displayCheckLatestVersionResult(result, htmlcontent):
            if result:
                self.checkdlg = CheckLatestVersionDialog(self, -1, self.localize('abclatestversion'), htmlcontent)
                self.checkdlg.ShowModal()
                x, y = self.checkdlg.GetPositionTuple()
                self.abcparams['checklatestdlgx'], self.abcparams['checklatestdlgy'] = str(x), str(y)
                self.checkdlg.Destroy()
                self.checkdlg = None
            else:
                dlg = wx.MessageDialog(self, self.localize('cantcheckversion'), self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
            self.menuversion.Enable(self.menuchecklatestversionid, True)

        def getLatestVersion():
            try:
                try :
                    h = urlopen(self.abcparams['home'] + self.localize('latestversionfile'))
                    htmlcontent = h.read().decode('utf_8')
                except:
                    htmlcontent = None
                    result = False
                    try:
                        h.close()
                    except:
                        pass
                else:
                    result = True
                    h.close()
                self.window.queue.invokeLater(displayCheckLatestVersionResult, [result, htmlcontent])
            except:
                pass

        self.menuversion.Enable(self.menuchecklatestversionid, False)
        thread = Thread(target = getLatestVersion)
        thread.daemon = False
        thread.start()

    ##################################
    # Restart program
    ##################################
    def onMenuRestart(self, event = None):
        self.onMenuExit(restart = True)
    
    ##################################
    # Close program
    ##################################
    def onMenuExit(self, event = None, silent = False, shutdown = False, restart = False):
        if self.window.torrentlistloading:
            return
        if not silent and self.abcparams['confirmonclose'] == "1" and not restart:        
            dlg = wx.MessageDialog(self, self.localize('confirmmsg'), self.localize('confirm'), wx.OK | wx.CANCEL)
            result = dlg.ShowModal()
            dlg.Destroy()
            if result != wx.ID_OK:
                return

        self.window.exiting = True

        # Stop list crolling timer if needed
        if self.window.scrolltimer:
            self.window.scrolltimer.cancel()
            self.window.scrolltimer = None

        # Close all dialogs/frames
        if self.window.torrentparamsdlg is not None:
            self.window.torrentparamsdlg.onCancel()
        if self.window.torrentrendlg is not None:
            self.window.torrentrendlg.onCancel()
        if self.window.setdestdlg is not None:
            self.window.setdestdlg.onCancel()
        if self.window.abcaddpeerdlg is not None:
            self.window.abcaddpeerdlg.onCancel()
        if self.abcoptiondlg is not None:
            self.abcoptiondlg.onCancel()
        if self.abcparamtemplatedlg is not None:
            self.abcparamtemplatedlg.onCancel()
        if self.abcconlimiterdlg is not None:
            self.abcconlimiterdlg.onCancel()
        if self.abcdhtaddnodedlg is not None:
            self.abcdhtaddnodedlg.onCancel()
        if self.abcschedulerdlg is not None:
            self.abcschedulerdlg.onCancel()
        if self.abcscannerdlg is not None:
            self.abcscannerdlg.onCancel()
        if self.abcwebdlg is not None:
            self.abcwebdlg.onCancel()
        if self.window.rsspanel.feederspanel.rssscanfreqdlg is not None:
            self.window.rsspanel.feederspanel.rssscanfreqdlg.onCancel()
        if self.checkdlg is not None:
            self.checkdlg.onOK()
        if self.aboutmedlg is not None:
            self.aboutmedlg.onOK()
        if self.abcfind is not None:
            self.abcfind.OnExit()
        if self.abctweak is not None:
            self.abctweak.OnExit()
        if self.maketorrent is not None:
            self.maketorrent.closeWin()

        # Close all detail windows
        self.window.queue.closeAllDetailWindows()

        if self.utility.exitwindow == 1 \
           or self.utility.exitwindow == 2 and not self.window.queue.enddatamovingflag.isSet():
            self.exitdialog = ExitDialog(self.localize('closing'))

        self.Hide()

        if self.exitdialog:
            self.exitdialog.Show()

        # Stop web service
        if self.webserver:
            self.window.stopWebService()

        # Stop server listener
        clientPassParam(['', "Please close connection!!"], port = self.utility.mainport)

        # Stop server listener for remote access
        if self.utility.remoteip is not None:
            clientPassParam(['', "Please close connection!!"], ip = self.utility.remoteip, port = self.utility.mainport)

        # Stop command scheduler
        self.window.commandscheduler.stop()

        # Stop directory scanner
        self.window.scanner.stop()

        # Stop RSS timers
        self.window.rsspanel.stopAllTimers()

        # Stop statusbar timer
        try:
            self.window.sbtimer.cancel()
        except:
            pass

        thread = Thread(target = self.closeABCOKC, args = [shutdown, restart])
        thread.daemon = False
        thread.start()

    def closeABCOKC(self, shutdown, restart):
        exitflag = Event()
        
        # Tell scheduler to stop DHT, timers and terminate all torrents
        if self.exitdialog:
            self.exitdialog.SetTitle(self.localize('stoppingrunningtorrents'))
        self.window.queue.invokeLater(self.window.queue.clearScheduler, [exitflag])
        exitflag.wait()
        if self.exitdialog:
            self.exitdialog.SetTitle(self.localize('closing'))

        # Wait for the end of sparse1 allocation and data moves
        if self.window.queue.startqueue[0] != 'END' or not FILESEM.acquire(False):
            if self.exitdialog:
                self.exitdialog.SetTitle(self.localize('completingallocmoves'))
            while self.window.queue.startqueue[0] != 'END' or not FILESEM.acquire(False):
                sleep(.5)
            # Be sure that all torrent parameters updates are complete after moving data
            self.window.queue.enddatamovingflag.wait()
            if self.exitdialog:
                self.exitdialog.SetTitle(self.localize('closing'))

        # Save torrent list
        exitflag.clear()
        if self.exitdialog:
            self.exitdialog.SetTitle(self.localize('savingtorlist'))
        self.window.queue.invokeLater(self.saveTorrentList, [exitflag])
        exitflag.wait()
        if self.exitdialog:
            self.exitdialog.SetTitle(self.localize('closing'))

        self.window.queue.invokeLater(self._closeABCOKC, [shutdown, restart])

    def saveTorrentList(self, exitflag):
        if self.abcparams['sorttoronclose'] == '1':
            self.window.queue.sortColumn(restore = 12)
        self.window.queue.updateTorrentList(finalupdate = True)
        exitflag.set()

    def _closeABCOKC(self, shutdown, restart):
        for i in xrange(10):
            self.abcparams['scrollpos' + str(i)] = str(self.window.bookmarks[i])

        if not self.window.firstdisplayRSS:
            self.abcparams['rsssash'] = str(self.window.rsspanel.splitter.GetSashPosition())

        if self.language != self.abcparams['language_file']:
            # Set param to reset the strings of the torrent list headers to their default value at next restart
            self.abcparams['initlang'] = '1'

        # Save main window position
        self.abcparams['mainwindowx'] = str(self.x)
        self.abcparams['mainwindowy'] = str(self.y)

        # Save all parameters
        tcfm = TorrentConfigFileManager(path.join(self.utility.datapath, "abc.conf"), self.abcparams)
        tcfm.writeAllConfig()

        # Save main window and columns size
        if self.abcparams['savesizesonexit'] == '1':
            self.guiman.setMainWidth(self.w)
            self.guiman.setMainHeight(self.h)
            for colid in xrange(4, self.guiman.maxid):
                col = self.guiman.getRankfromID(colid)
                if col != -1:
                    self.guiman.setValue(colid, self.window.list.GetColumnWidth(col))
            self.guiman.writeIni()

        self.tbicon.Destroy()
        edx = edy = -1
        if self.exitdialog:
            edx, edy = self.exitdialog.GetPositionTuple()
            self.exitdialog.Destroy()

        if shutdown:
            self.shutDownComputer()
        elif self.abcparams['abcproc'] == '1' or restart:
            restartparams = ""
            if restart:
                if self.utility.mainport != 56666:
                    restartparams += "-p " + str(self.utility.mainport)
                if self.utility.remoteip is not None:
                    if restartparams:
                        restartparams += " "
                    restartparams += "-i " + self.utility.remoteip
            createProcess(path.join(self.utility.abcpath, 'abcproc.exe' + ' ' + str(edx) + ' ' + str(edy)
                                                          + ' ' + str(int(restart))
                                                          + ' "' + restartparams + '"'
                                                          + ' "' + self.localize('waitingforendofproc') + '"'))
        self.Destroy()

    def shutDownComputer(self):
        # Wait 3 minutes before shutting down
        self.Hide()
        delacdlg = wx.ProgressDialog(self.localize('delshutdowntitle'), self.localize('delshutdown'),
                                     maximum = 720, style = wx.PD_CAN_ABORT | wx.PD_AUTO_HIDE | wx.PD_SMOOTH)
        delacdlg.SetFocus()
        keepgoing = True
        count = 0
        while keepgoing and count < 720:
            count += 1
            wx.MilliSleep(250)
            keepgoing = delacdlg.Update(count)[0]
        delacdlg.Destroy()
        if keepgoing:
            self.utility.shutDown()

    ######################################
    # Update list columns on-the-fly
    ######################################
    def updateABCDisplay(self):
        # Old values
        old_colid = self.guiman.colid
        # Reload ini
        self.guiman.reloadIni()

        # Update app width, height
        self.SetSize(wx.Size(self.guiman.getMainWidth(), self.guiman.getMainHeight()))
        # Update Metainfo and Detail width, height
        self.window.queue.updateMetaDetailWinSize()

        # Update column name and width
        new_colid = self.guiman.colid
        if new_colid != old_colid:
            tobeupdated = []

            # Deleted columns
            col = 0
            for id in old_colid[:]:
                if id not in new_colid:
                    #print 'DELETE'
                    #print 'before :', old_colid
                    if col == 0 and len(old_colid) > 1:
                        # It's impossible to delete the content of column 0 with a call to DeleteColumn
                        # So I delete the column 1 to avoid calling refreshing for all columns
                        # Can't get the text from original list item to be modified (?) so create new ListItem
                        item = wx.ListItem()
                        item.SetText(self.guiman.getText(old_colid[1]))
                        self.window.list.SetColumn(0, item)
                        self.window.list.DeleteColumn(1)
                        tobeupdated.append(0)
                    else:
                        self.window.list.DeleteColumn(col)
                    old_colid.remove(id)
                    #print 'after :', old_colid
                else:
                    col += 1

            # New columns
            col = 0
            for id in new_colid:
                if id not in old_colid:
                    #print 'INSERT'
                    #print 'before :', old_colid
                    self.window.list.InsertColumn(col, '')
                    old_colid.insert(col, id)
                    # Add for content update
                    tobeupdated.append(col)
                    #print 'after :', old_colid
                col += 1

            # Deals with special case for inserts or deletes at the head
            if 0 in tobeupdated:
                c = 1
                while True:
                    if c not in tobeupdated:
                        tobeupdated.append(c)
                        break
                    c += 1

            # Update display for new columns
            #print 'tobeupdated :', tobeupdated
            if tobeupdated:
                self.window.queue.updateColumns(old_colid, tobeupdated)

            # Columns that changed place
            for c in xrange(len(old_colid)):
                if new_colid[c] != old_colid[c]:
                    col = old_colid.index(new_colid[c])
                    if new_colid[col] == old_colid[c]:
                        # Swap column
                        #print 'SWAP'
                        #print 'before :', old_colid, new_colid
                        for index in xrange(self.window.list.GetItemCount()):
                            text = self.window.list.GetItem(index, col).GetText()
                            self.window.list.SetStringItem(index, col, self.window.list.GetItem(index, c).GetText())
                            self.window.list.SetStringItem(index, c, text)
                        # Update old_colid
                        old_colid[c] = new_colid[c]
                        old_colid[col] = new_colid[col]
                        #print 'after :', old_colid
                    else:
                        # Move column
                        #print 'MOVE'
                        #print 'before :', old_colid
                        for index in xrange(self.window.list.GetItemCount()):
                            text = self.window.list.GetItem(index, col).GetText()
                            for c2 in xrange(col, c, -1):
                                self.window.list.SetStringItem(index, c2, self.window.list.GetItem(index, c2 - 1).GetText())
                            self.window.list.SetStringItem(index, c, text)
                        # Update old_colid
                        for c2 in xrange(col, c, -1):
                            old_colid[c2] = old_colid[c2 - 1]
                        old_colid[c] = new_colid[c]
                        #print 'after :', old_colid

        # Set widths and headers
        item = wx.ListItem()
        for id in new_colid:
            c = self.guiman.getRankfromID(id)
            self.window.list.SetColumnWidth(c, self.guiman.getValue(id))
            item.SetText(self.guiman.getText(id))
            self.window.list.SetColumn(c, item)


##############################################################
# Class : ABCApp
#
# Main ABC_OKC application class that contains ABCFrame object
#
##############################################################
class ABCApp(wx.App):
    def __init__(self, x, params, singleinstancechecker, abcpath):
        self.params = params
        self.singleinstancechecker = singleinstancechecker
        self.abcpath = abcpath
        wx.App.__init__(self, x)

    def OnInit(self):
        clock()
        gc.disable()
        self.utility = Utility(self, self.abcpath)
        if self.utility.maxstdio != -1:
            _setmaxstdio(self.utility.maxstdio)
        if not self.utility.lang.translation:
            sys.stderr.write('\nThe language file pointed by the key "language_file" in abc.conf could not be found.\nCheck the files inside the lang folder or modify abc.conf.\n')
            return False
        self.localize = self.utility.lang.get
        self.wxlocale = wx.Locale()
        self.wxlocale.AddCatalogLookupPathPrefix("locale")
        self.wxlocale.Init(int(self.localize('languageid')))
        setABCUtility(self.utility)

        # Compute peer ids
        initPeerID()

        self.frame = ABCFrame(None, -1, self.params, self.utility)
        self.utility.frame = self.frame
        self.utility.window = self.frame.window

        self.frame.Show()

        # Create torrent.lst if it doesn't exist
        if not path.exists(path.join(self.utility.datapath, 'torrent.lst')):
            dlg = wx.MessageDialog(self.frame, self.localize('notorrentlist'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            open(path.join(self.utility.datapath, 'torrent.lst'), "w").close()

        # Backup torrent.lst
        try:
            remove(path.join(self.utility.datapath, 'torrent.lst.sav3'))
        except:
            pass
        try:
            rename(path.join(self.utility.datapath, 'torrent.lst.sav2'), path.join(self.utility.datapath, 'torrent.lst.sav3'))
        except:
            pass
        try:
            rename(path.join(self.utility.datapath, 'torrent.lst.sav1'), path.join(self.utility.datapath, 'torrent.lst.sav2'))
        except:
            pass
        try:
            copyfile(path.join(self.utility.datapath, 'torrent.lst'), path.join(self.utility.datapath, 'torrent.lst.sav1'))
        except:
            dlg = wx.MessageDialog(self.frame, self.localize('warningbacktorlst'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()

        # Create dhtrouter.txt if it doesn't exist
        if not path.exists(path.join(self.utility.datapath, 'dhtrouter.txt')):
            try:
                copyfile(path.join(self.abcpath, 'defdhtrouter.txt'), path.join(self.utility.datapath, 'dhtrouter.txt'))
            except:
                pass

        Timer(0.1, self.frame.window.queue.initScheduler).start()

        return True

    def OnExit(self):
        return 0


##############################################################
#
# Main program starts here
#
##############################################################
arg = getCommandLine()
abcpath = path.dirname(arg[0])
chdir(abcpath)
# Create single instance semaphore
singleinstancechecker = wx.SingleInstanceChecker("pingpong-abc" + wx.GetUserId())
# Launch first abc single instance
app = ABCApp(0, arg[1:], singleinstancechecker, abcpath)
app.MainLoop()
