##############################################################################
# Module : torrentrenamedlg.py
# Author : Old King Cole
# Date   : 10/15/2005
#
# Description : Dialog for renaming torrents
#
##############################################################################
import sys, wx
from os import path, rename
from string import whitespace

from Dialogs.addsamedestdlg import AddSameDestDialog


class TorrentRenDialog(wx.Dialog):
    def __init__(self, parent, ID, torrent, queue, panel, multitorrent, pos = wx.DefaultPosition,
                 size = wx.DefaultSize, style = wx.DEFAULT_DIALOG_STYLE | wx.RESIZE_BORDER):
        self.queue = queue
        self.panel = panel
        self.multitorrent = multitorrent
        self.utility = parent.utility
        self.localize = self.utility.lang.get
        self.torrent = torrent
        if self.multitorrent:
            title = self.localize('renametorrentmulti') + torrent.name
        else:
            title = self.localize('renametorrent') + torrent.name
        pre = wx.PreDialog()
        pre.Create(parent, ID, title, pos, size, style)
        self.this = pre.this

        outerbox = wx.BoxSizer(wx.VERTICAL)

        globalbox = wx.StaticBoxSizer(wx.StaticBox(self, -1, ''), wx.VERTICAL)

        globalbox.Add(wx.StaticText(self, -1, self.localize('edittorname')), 0, wx.TOP, 3)
        self.edittorname = wx.TextCtrl(self, -1, self.torrent.name, (-1, -1), (-1, -1))        
        globalbox.Add(self.edittorname, 0, wx.EXPAND | wx.TOP, 3)

        if multitorrent:
            numberbox = wx.BoxSizer(wx.HORIZONTAL)
            self.appendnumber = wx.CheckBox(self, -1, self.localize('appendnumber'))
            numberbox.Add(self.appendnumber, 0, wx.ALIGN_CENTER_VERTICAL)
            self.appendnumberstart = wx.TextCtrl(self, -1, "1", wx.Point(-1, -1),
                                                 wx.Size(43, self.utility.digitheight), style = wx.TE_RIGHT)
            numberbox.Add(self.appendnumberstart, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)
            if self.utility.abcparams['abcrentorappendnb'] == "1":
                self.appendnumber.SetValue(True)
            globalbox.Add(numberbox, 0, wx.TOP, 3)
        else:
            usenamefrombox = wx.StaticBoxSizer(wx.StaticBox(self, -1, self.localize('usenamefrom')), wx.VERTICAL)

            usenamefrombox.Add(wx.StaticText(self, -1, self.localize('origtorname')), 0, wx.TOP, -1)
            origtornamebox = wx.BoxSizer(wx.HORIZONTAL)
            if self.torrent.magnet:
                origtorname = self.localize('notorrentinfo')
            else:
                metainfo = self.torrent.getResponse()
                self.info = metainfo['info']
                if self.info.has_key('name.utf-8'):
                    namekey = 'name.utf-8'
                else:
                    namekey = 'name'
                origtorname = self.utility.decodeString(self.info[namekey])
            self.origtornametext = wx.TextCtrl(self, -1, origtorname, (-1, -1), (-1, -1), wx.TE_READONLY)
            origtornamebox.Add(self.origtornametext, 1, wx.EXPAND)
            origtornamebtn = wx.Button(self, -1, self.localize('copybtn'), size = (-1, self.utility.buttonheight), style = wx.BU_EXACTFIT)
            origtornamebox.Add(origtornamebtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            usenamefrombox.Add(origtornamebox, 1, wx.EXPAND | wx.TOP, 3)

            if self.torrent.magnetname:
                usenamefrombox.Add(wx.StaticText(self, -1, self.localize('magnetname')), 0, wx.TOP, 5)
                magnetnamebox = wx.BoxSizer(wx.HORIZONTAL)
                self.magnetnametext = wx.TextCtrl(self, -1, self.torrent.magnetname, (-1, -1), (-1, -1), wx.TE_READONLY)
                magnetnamebox.Add(self.magnetnametext, 1, wx.EXPAND)
                magnetnamebtn = wx.Button(self, -1, self.localize('copybtn'), size = (-1, self.utility.buttonheight), style = wx.BU_EXACTFIT)
                magnetnamebox.Add(magnetnamebtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
                usenamefrombox.Add(magnetnamebox, 1, wx.EXPAND | wx.TOP, 3)

            usenamefrombox.Add(wx.StaticText(self, -1, self.localize('destname')), 0, wx.TOP, 5)
            destnamebox = wx.BoxSizer(wx.HORIZONTAL)
            if self.torrent.magnet == 1:
                destname = self.localize('notorrentinfo')
            else:
                destname = path.split(self.torrent.dest)[1]
            self.destnametext = wx.TextCtrl(self, -1, destname, (-1, -1), (-1, -1), wx.TE_READONLY)
            destnamebox.Add(self.destnametext, 1, wx.EXPAND)
            destnamebtn = wx.Button(self, -1, self.localize('copybtn'), size = (-1, self.utility.buttonheight), style = wx.BU_EXACTFIT)
            destnamebox.Add(destnamebtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            usenamefrombox.Add(destnamebox, 1, wx.EXPAND | wx.TOP, 3)

            usenamefrombox.Add(wx.StaticText(self, -1, self.localize('torfilename')), 0, wx.TOP, 5)
            torfilenamebox = wx.BoxSizer(wx.HORIZONTAL)
            torfilename = path.split(self.torrent.src)[1]
            extindex = torfilename.rfind('.torrent')
            if extindex >= 0:
                tfn = torfilename[:extindex]
            else:
                tfn = torfilename
            self.torfilenametext = wx.TextCtrl(self, -1, tfn, (-1, -1), (-1, -1), wx.TE_READONLY)
            torfilenamebox.Add(self.torfilenametext, 1, wx.EXPAND)
            torfilenamebtn = wx.Button(self, -1, self.localize('copybtn'), size = (-1, self.utility.buttonheight), style = wx.BU_EXACTFIT)
            torfilenamebox.Add(torfilenamebtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            usenamefrombox.Add(torfilenamebox, 1, wx.EXPAND | wx.TOP, 3)

            globalbox.Add(usenamefrombox, 1, wx.EXPAND | wx.TOP, 5)

            self.rendestwithtor = wx.CheckBox(self, -1, self.localize('rendestwithtor'))
            if self.torrent.abcengine or self.torrent.magnet == 1:
                # Can't change destination for a running torrent or a magnet
                self.rendestwithtor.Disable()
            elif self.utility.abcparams['defrentorwithdest'] == "1":
                self.rendestwithtor.SetValue(True)
            globalbox.Add(self.rendestwithtor, 0, wx.TOP, 3)

        outerbox.Add(globalbox, 0, wx.EXPAND | wx.TOP, -4)

        buttonbox = wx.BoxSizer(wx.HORIZONTAL)
        applybtn = wx.Button(self, -1, self.localize('apply'), size = (60, -1))
        okbtn = wx.Button(self, -1, self.localize('ok'), size = (60, -1))
        cancelbtn = wx.Button(self, -1, self.localize('cancel'), size = (60, -1))
        buttonbox.Add(applybtn, 0, wx.ALL, 5)
        buttonbox.Add(okbtn, 0, wx.ALL, 5)
        buttonbox.Add(cancelbtn, 0, wx.ALL, 5)

        outerbox.Add(buttonbox, 0, wx.ALIGN_CENTER)

        self.SetAutoLayout(True)
        self.SetSizer(outerbox)
        self.Fit()
        self.SetSize((int(self.utility.abcparams['abcrentordlgw']), -1))
        height = self.GetSize()[1]
        self.SetMinSize((self.GetBestSize()[0], height))
        self.SetMaxSize((-1, height))

        # Add events
        if multitorrent:
            self.appendnumberstart.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
            self.appendnumberstart.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        else:
            self.Bind(wx.EVT_BUTTON, self.onCopyOrigName, origtornamebtn)
            if self.torrent.magnetname:
                self.Bind(wx.EVT_BUTTON, self.onCopyMagnetName, magnetnamebtn)
            self.Bind(wx.EVT_BUTTON, self.onCopyDestName, destnamebtn)
            self.Bind(wx.EVT_BUTTON, self.onCopyTorFileName, torfilenamebtn)
        self.Bind(wx.EVT_BUTTON, self.onOK, okbtn)
        self.Bind(wx.EVT_BUTTON, self.onApply, applybtn)
        self.Bind(wx.EVT_BUTTON, self.onCancel, cancelbtn)
        self.Bind(wx.EVT_CLOSE, self.onCancel)
        self.edittorname.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)

        if self.utility.abcparams['abcrentordlgx'] != '-1':
            self.MoveXY(int(self.utility.abcparams['abcrentordlgx']), int(self.utility.abcparams['abcrentordlgy']))

        if not multitorrent and self.torrent.magnet:
            origtornamebtn.Disable()
            if self.torrent.magnet == 1:
                destnamebtn.Disable()

    def onTorrentReplace(self):
        self.origtornametext.SetValue(self.torrent.name)
        self.destnametext.SetValue(path.split(self.torrent.dest)[1])
        torfilename = path.split(self.torrent.src)[1]
        self.torfilenametext.SetValue(torfilename[:torfilename.rfind('.torrent')])

    def onCopyOrigName(self, event):
        self.edittorname.SetValue(self.origtornametext.GetValue())

    def onCopyMagnetName(self, event):
        self.edittorname.SetValue(self.magnetnametext.GetValue())

    def onCopyDestName(self, event):
        self.edittorname.SetValue(self.destnametext.GetValue())

    def onCopyTorFileName(self, event):
        self.edittorname.SetValue(self.torfilenametext.GetValue())

    def onRightButtonText(self, event):
        pass

    def onCancel(self, event = None):
        self.EndModal(wx.ID_CANCEL)

    def onApply(self, event, ok = False):
        if self.multitorrent:
            return self.onApplyMulti()
        return self.onApplySingle(ok)

    def onApplyMulti(self):
        c_switch = self.appendnumber.GetValue()
        c_str = self.appendnumberstart.GetValue()
        c_format = "%0" + str(len(c_str)) + "d"
        try:
            c = int(c_str)
        except:
            c = 1
        fixednewname = self.edittorname.GetValue()
        for index in self.panel.getSelected():
            torrent = self.queue.proctab[index]
            if torrent.isbeingdeleted:
                continue
            newname = fixednewname
            if c_switch:
                newname += c_format % c
                c += 1
            # Update name
            torrent.updateName(newname)

        return True

    def onApplySingle(self, ok):
        if self.torrent not in self.queue.proctab or self.torrent.isbeingdeleted:
            # Torrent has been deleted from list
            dlg = wx.MessageDialog(self, self.localize('errortorrentnolongerinlist'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            self.EndModal(wx.ID_CANCEL)
            return False

        newname = self.edittorname.GetValue()

        # Update destination if needed
        if self.rendestwithtor.IsEnabled() and self.rendestwithtor.GetValue():
            if sys.platform == 'win32':
                # In windows you can't create a file or folder ending with one or several spaces or dots
                # If you try it Windows silently creates the file or folder with these spaces and dots stripped
                newdest = newname.rstrip(whitespace + '.')
                # Check if the torrent name is a valid Windows file name
                fixeddest = self.utility.fixWindowsName(newdest)
                if fixeddest:
                    dlg = wx.MessageDialog(self, newname + '\n' + self.localize('errorinvalidwinname') + fixeddest,
                                           self.localize('abcokcerror'), wx.ICON_ERROR)
                    dlg.ShowModal()
                    dlg.Destroy()
                    return False
                newdest = path.join(path.split(self.torrent.dest)[0], newdest)
                completedest = self.utility.completePath(newdest)
                destlen = len(completedest)
                toolongdestpath = False
                if self.torrent.singlefile:
                    if destlen > self.utility.filepathmaxlength or len(path.split(completedest)[0]) > self.utility.pathmaxlength:
                        toolongdestpath = True
                else:
                    # Check path length for each file of the torrent
                    for f in self.torrent.getFileNames(filesinfo = self.info['files']):
                        if len(f) + destlen >= self.utility.filepathmaxlength or len(path.split(f)[0]) + destlen >= self.utility.pathmaxlength:
                            toolongdestpath = True
                            break
                if toolongdestpath:
                    dlg = wx.MessageDialog(self, self.localize('errortoolongdestpath'),
                                           self.localize('abcokcerror'), wx.ICON_ERROR)
                    dlg.ShowModal()
                    dlg.Destroy()
                    return False
                if not self.torrent.singlefile:
                    # Reset bit 4 in file name status
                    self.torrent.resetFileNameStatus(mask = 8)
            else:
                newdest = path.join(path.split(self.torrent.dest)[0], newname)

            destlowercase = self.utility.completePath(newdest).lower()
            for t in self.queue.proctab:
                if t != self.torrent and self.utility.completePath(t.dest).lower() == destlowercase:
                    dlg = AddSameDestDialog(self, -1, self.localize('duplicatedestination'),
                                            self.torrent.name, self.torrent.src, False, loading = False,
                                            multibutton = ok, pos = self.queue.addtorrentwarningpos)
                    result = dlg.ShowModal()
                    self.queue.addtorrentwarningpos = dlg.GetPosition()
                    dlg.Destroy()
                    if result == 0:
                        return False
                    break

            try:
                rename(self.utility.completePath(self.torrent.dest), self.utility.completePath(newdest))
            except:
                pass
            self.torrent.updateDestination(newdest)
            self.destnametext.SetValue(newname)

        # Update name
        self.torrent.updateName(newname)

        return True

    def onOK(self, event):
        if self.onApply(event, ok = True):
            self.EndModal(wx.ID_OK)
