##############################################################################
# Module : torrentparamsdlg.py
# Author :
# Date   :
# Updated and modified for ABC_OKC : Old King Cole
#
# Description : Dialog for editing torrent parameters
#
##############################################################################
import sys, wx
from string import whitespace

from utility import SpinBox


class TorrentParametersDialog(wx.Dialog):
    def __init__(self, parent, ID, torrent, queue, panel, multitorrent, dht,
                 pos = wx.DefaultPosition, size = wx.DefaultSize,
                 style = wx.DEFAULT_DIALOG_STYLE):
        self.utility = parent.utility
        self.localize = self.utility.lang.get
        self.multitorrent = multitorrent
        if multitorrent:
            title = self.localize('torrentsettingmulti')
            self.firstvertgap = 4
        else:
            title = self.localize('torrentsetting')
            self.firstvertgap = 0
        self.parent = parent
        self.panel = panel
        self.torrent = torrent
        pre = wx.PreDialog()
        pre.Create(parent, ID, title + self.torrent.name, pos, size, style)
        self.this = pre.this
        self.queue = queue

        outerbox = wx.BoxSizer(wx.VERTICAL)

        self.notebook = wx.Notebook(self, -1)
        self.notebook.SetPadding((4, 4))
        self.notebook.AddPage(self.makeLimitsPanel(self.notebook), self.localize('torlimits'))
        self.downloadrate.SetValue(str(torrent.maxlocaldownloadrate))
        self.prioritizedown.SetValue(torrent.prioritizedown)
        self.maxupload.setValue(str(torrent.maxupload))
        self.uploadrate.SetValue(str(torrent.maxlocaluploadrate))
        self.prioritizeup.SetValue(torrent.prioritizeup)
        self.rb[torrent.uploadoption].SetValue(True)
        dtime, mtime = divmod(60 * torrent.uploadtimeh + torrent.uploadtimem, 1440)
        htime, mtime = divmod(mtime, 60)
        self.cbdtime.SetValue(str(dtime))
        self.cbhtime.SetValue(str(htime))
        self.cbmtime.SetValue(str(mtime))
        self.cbratio.SetValue(str(torrent.uploadratio))
        self.uploadtillcopycomplete.SetValue(torrent.uploadtillcopycomplete)
        self.notebook.AddPage(self.makeTimeOutPanel(self.notebook), self.localize('tortimeout'))
        self.timeoutswitch.SetValue(torrent.timeoutswitch)
        self.timeoutaction.SetSelection(torrent.timeoutaction)
        self.timeoutwork.SetValue(torrent.timeoutwork)
        self.timeoutworkdown.SetValue(torrent.timeoutworkdown)
        self.timeoutseed.SetValue(torrent.timeoutseed)
        self.timeoutseedup.SetValue(torrent.timeoutseedup)
        if multitorrent or not dht or torrent.private:
            self.timeoutworktrack.SetValue(torrent.timeoutworktrack)
            self.timeoutseedtrack.SetValue(torrent.timeoutseedtrack)
        else:
            self.timeoutworktrack.Disable()
            self.timeoutseedtrack.Disable()
        dtime, mtime = divmod(int(torrent.timeouttracker), 1440)
        htime, mtime = divmod(mtime, 60)
        self.cb_dtracker.SetValue(str(dtime))
        self.cb_htracker.SetValue(str(htime))
        self.cb_mtracker.SetValue(str(mtime))
        dtime, mtime = divmod(int(torrent.timeoutdownload), 1440)
        htime, mtime = divmod(mtime, 60)
        self.cb_ddownload.SetValue(str(dtime))
        self.cb_hdownload.SetValue(str(htime))
        self.cb_mdownload.SetValue(str(mtime))
        dtime, mtime = divmod(int(torrent.timeoutupload), 1440)
        htime, mtime = divmod(mtime, 60)
        self.cb_dupload.SetValue(str(dtime))
        self.cb_hupload.SetValue(str(htime))
        self.cb_mupload.SetValue(str(mtime))
        self.notebook.AddPage(self.makeLabMovTraPanel(self.notebook), self.localize('torlabmovtra'))
        self.shortlabel.SetValue(torrent.shortlabel)
        self.movefolder.SetValue(torrent.movefolder)
        self.exttracker.SetValue(torrent.exttracker)
        self.exttrackerurl.SetValue(torrent.exttrackerurl)
        self.checkinttrackwait.SetValue(torrent.checkinttrackwait)
        self.extrainttracker.SetValue(torrent.extrainttracker)
        self.inttrackerurl.SetValue(torrent.inttrackerurl)

        if multitorrent:
            self.downloadrateswitch.SetValue(True)
            self.prioritizedownswitch.SetValue(True)
            self.maxuploadswitch.SetValue(True)
            self.uploadrateswitch.SetValue(True)
            self.prioritizeupswitch.SetValue(True)
            if self.utility.abcparams['multiparamdefault'] == '1':
                self.downloadswitch.SetValue(True)
                self.uploadswitch.SetValue(True)
                self.continueswitch.SetValue(True)
                self.timeoutsettingswitch.SetValue(True)
                self.timeoutvaluesswitch.SetValue(True)
                self.labelswitch.SetValue(True)
                self.movefolderswitch.SetValue(True)
                self.exttrackerswitch.SetValue(True)

        self.notebook.SetAutoLayout(True)

        self.maxpage = self.notebook.GetPageCount() - 1
        self.notebook.SetSelection(min(int(self.utility.abcparams['lastopentortab']), self.maxpage))

        outerbox.Add(self.notebook, 0, wx.EXPAND | wx.LEFT | wx.TOP | wx.RIGHT, 5)

        buttonbox = wx.BoxSizer(wx.HORIZONTAL)
        if self.multitorrent:
            selectallbtn = wx.ToggleButton(self, -1, self.localize('selectall_s'), size = (60, -1))
            selectallbtn.SetValue(self.utility.abcparams['multiparamdefault'] == '1')
            buttonbox.Add(selectallbtn, 0, wx.LEFT, 0)
            spaceadjust = 5
        else:
            spaceadjust = 0
        applybtn = wx.Button(self, -1, self.localize('apply'), size = (60, -1))
        okbtn = wx.Button(self, -1, self.localize('ok'), size = (60, -1))
        cancelbtn = wx.Button(self, -1, self.localize('cancel'), size = (60, -1))
        buttonbox.Add(applybtn, 0, wx.LEFT, spaceadjust)
        buttonbox.Add(okbtn, 0, wx.LEFT, 20 - 3 *spaceadjust)
        buttonbox.Add(cancelbtn, 0, wx.LEFT, 20 - 3 * spaceadjust)

        outerbox.Add(buttonbox, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.BOTTOM | wx.TOP, 6)

        self.SetAutoLayout(True)
        self.SetSizer(outerbox)
        self.Fit()

        self.utility.frameWindow(self.rb4, xl = 11, xt = -1, border = 1, midline = 1)

        # Add events
        if self.multitorrent:
            self.Bind(wx.EVT_TOGGLEBUTTON, self.onSelectAll, selectallbtn)
        self.Bind(wx.EVT_BUTTON, self.onOK, okbtn)
        self.Bind(wx.EVT_BUTTON, self.onApply, applybtn)
        self.Bind(wx.EVT_BUTTON, self.onCancel, cancelbtn)
        self.Bind(wx.EVT_CLOSE, self.onCancel)
        self.Bind(wx.EVT_MOUSEWHEEL, self.onMouseWheel)
        self.shortlabel.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.shortlabel.Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
        self.movefolder.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.exttrackerurl.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.exttrackerurl.Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
        self.inttrackerurl.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.inttrackerurl.Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
        self.notebook.Bind(wx.EVT_LEFT_DOWN, self.onLeftNoteBook)

        if self.utility.abcparams['torrentparamsdlgx'] != '-1':
            self.MoveXY(int(self.utility.abcparams['torrentparamsdlgx']), int(self.utility.abcparams['torrentparamsdlgy']))

    # Group Upload rate setting
    ###########################
    def makeLimitsPanel(self, parent):
        p = wx.Panel(parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)

        downloadsection = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('downloadsetting')), wx.VERTICAL)
        if self.multitorrent:
            self.downloadswitch = wx.CheckBox(p, -1, '')
            downloadsection.Add(self.downloadswitch, 0, wx.ALIGN_RIGHT | wx.TOP, -17)

        maxdownloadratebox = wx.BoxSizer(wx.HORIZONTAL)
        maxdownloadratebox.Add(wx.StaticText(p, -1, self.localize('maxdownloadrate')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.downloadrate = wx.TextCtrl(p, -1, '', wx.Point(-1, -1),
                                        wx.Size(49, self.utility.digitheight), style = wx.TE_RIGHT)
        self.downloadrate.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.downloadrate.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        self.downloadrate.SetToolTipString(self.localize('0isnolimittt'))
        maxdownloadratebox.Add(self.downloadrate, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        maxdownloadratebox.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL)
        if self.multitorrent:
            maxdownloadratebox.Add((0, 0), 1)
            self.downloadrateswitch = wx.CheckBox(p, -1, '', size = (10, -1))
            maxdownloadratebox.Add(self.downloadrateswitch, 0, wx.ALIGN_CENTER_VERTICAL)

        downloadsection.Add(maxdownloadratebox, 0, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND | wx.TOP, self.firstvertgap)

        prioritizedownbox = wx.BoxSizer(wx.HORIZONTAL)
        self.prioritizedown = wx.CheckBox(p, -1, self.localize('prioritizedown'))
        prioritizedownbox.Add(self.prioritizedown, 0, wx.ALIGN_CENTER_VERTICAL)
        if self.multitorrent:
            prioritizedownbox.Add((0, 0), 1)
            self.prioritizedownswitch = wx.CheckBox(p, -1, '', size = (10, -1))
            prioritizedownbox.Add(self.prioritizedownswitch, 0, wx.ALIGN_CENTER_VERTICAL)

        downloadsection.Add(prioritizedownbox, 0, wx.EXPAND | wx.TOP, 3)

        uploadsection = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('uploadsetting')), wx.VERTICAL)
        if self.multitorrent:
            self.uploadswitch = wx.CheckBox(p, -1, '')
            uploadsection.Add(self.uploadswitch, 0, wx.ALIGN_RIGHT | wx.TOP, -17)

        maxuploadbox = wx.BoxSizer(wx.HORIZONTAL)
        self.maxupload = SpinBox(p, header = self.localize('maxuploads'),
                                 width = 31, height = self.utility.digitheight,
                                 min = self.utility.minuploads, max = 100)
        maxuploadbox.Add(self.maxupload.getSizer(), 0, wx.ALIGN_CENTER_VERTICAL)
        if self.multitorrent:
            maxuploadbox.Add((0, 0), 1)
            self.maxuploadswitch = wx.CheckBox(p, -1, '', size = (10, -1))
            maxuploadbox.Add(self.maxuploadswitch, 0, wx.ALIGN_CENTER_VERTICAL | wx.ALIGN_RIGHT)

        uploadsection.Add(maxuploadbox, 0, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND | wx.TOP, self.firstvertgap)

        maxuploadratebox = wx.BoxSizer(wx.HORIZONTAL)
        maxuploadratebox.Add(wx.StaticText(p, -1, self.localize('maxuploadrate')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.uploadrate = wx.TextCtrl(p, -1, '', wx.Point(-1, -1),
                                      wx.Size(49, self.utility.digitheight), style = wx.TE_RIGHT)
        self.uploadrate.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.uploadrate.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        self.uploadrate.SetToolTipString(self.localize('0isnolimittt'))
        maxuploadratebox.Add(self.uploadrate, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        maxuploadratebox.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL)
        if self.multitorrent:
            maxuploadratebox.Add((0, 0), 1)
            self.uploadrateswitch = wx.CheckBox(p, -1, '', size = (10, -1))
            maxuploadratebox.Add(self.uploadrateswitch, 0, wx.ALIGN_CENTER_VERTICAL | wx.ALIGN_RIGHT)

        uploadsection.Add(maxuploadratebox, 0, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND | wx.TOP, 3)

        prioritizeupbox = wx.BoxSizer(wx.HORIZONTAL)
        self.prioritizeup = wx.CheckBox(p, -1, self.localize('prioritizeup'))
        prioritizeupbox.Add(self.prioritizeup, 0, wx.ALIGN_CENTER_VERTICAL)
        if self.multitorrent:
            prioritizeupbox.Add((0, 0), 1)
            self.prioritizeupswitch = wx.CheckBox(p, -1, '', size = (10, -1))
            prioritizeupbox.Add(self.prioritizeupswitch, 0, wx.ALIGN_CENTER_VERTICAL | wx.ALIGN_RIGHT)

        uploadsection.Add(prioritizeupbox, 0, wx.EXPAND | wx.TOP, 3)

        # Upload setting for completed file
        continuesection = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('uploadoptforcompletedfile')), wx.VERTICAL)
        if self.multitorrent:
            self.continueswitch = wx.CheckBox(p, -1, '')
            continuesection.Add(self.continueswitch, 0, wx.ALIGN_RIGHT | wx.TOP, -17)

        uploadlist = [self.localize('unlimitedupload'), self.localize('continueuploadfor'), self.localize('untilratio'), self.localize('onfirstreached')]

        rb1 = wx.RadioButton(p, -1, uploadlist[0], wx.Point(-1, -1), wx.Size(-1, -1), wx.RB_GROUP)
        rb2 = wx.RadioButton(p, -1, uploadlist[1], wx.Point(-1, -1), wx.Size(-1, -1))
        rb3 = wx.RadioButton(p, -1, uploadlist[2], wx.Point(-1, -1), wx.Size(-1, -1))
        self.rb4 = wx.RadioButton(p, -1, uploadlist[3], wx.Point(-1, -1), wx.Size(-1, -1))
        self.rb = [rb1, rb2, rb3, self.rb4]

        continuesection.Add(rb1, 0, wx.ALIGN_CENTER_VERTICAL | wx.TOP, self.firstvertgap)

        time_sizer = wx.BoxSizer(wx.HORIZONTAL)
        time_sizer.Add(rb2, 0, wx.ALIGN_CENTER_VERTICAL)
        self.cbdtime = wx.TextCtrl(p, -1, '', (-1, -1), (31, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cbdtime.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cbdtime.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        time_sizer.Add(self.cbdtime, 0, wx.LEFT, 5)
        time_sizer.Add(wx.StaticText(p, -1, self.localize('l_day')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.cbhtime = wx.TextCtrl(p, -1, '', (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cbhtime.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cbhtime.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        time_sizer.Add(self.cbhtime, 0, wx.LEFT, 3)
        time_sizer.Add(wx.StaticText(p, -1, self.localize('l_hour')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.cbmtime = wx.TextCtrl(p, -1, '', (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cbmtime.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cbmtime.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        time_sizer.Add(self.cbmtime, 0, wx.LEFT, 3)
        time_sizer.Add(wx.StaticText(p, -1, self.localize('l_minute')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)

        continuesection.Add(time_sizer, 0, wx.ALIGN_CENTER_VERTICAL)

        continuesection.Add(self.rb4, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 19)

        self.cbratio = wx.TextCtrl(p, -1, '', (-1, -1), (37, self.utility.digitheight), style = wx.TE_RIGHT)
        self.cbratio.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cbratio.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)

        percent_sizer = wx.BoxSizer(wx.HORIZONTAL)
        percent_sizer.Add(rb3, 0, wx.ALIGN_CENTER_VERTICAL)
        percent_sizer.Add(self.cbratio, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        percent_sizer.Add(wx.StaticText(p, -1, "%"), 0, wx.ALIGN_CENTER_VERTICAL)

        continuesection.Add(percent_sizer, 0, wx.ALIGN_CENTER_VERTICAL)

        self.uploadtillcopycomplete = wx.CheckBox(p, -1, self.localize('uploadtillcopycomplete'))

        continuesection.Add(self.uploadtillcopycomplete, 0, wx.TOP, 3)

        sizer.Add(downloadsection, 0, wx.EXPAND | wx.TOP, 3)
        sizer.Add(uploadsection, 0, wx.EXPAND | wx.TOP, 3)
        sizer.Add(continuesection, 0, wx.EXPAND | wx.TOP, 3)

        p.SetSizer(sizer)
        p.SetAutoLayout(True)
        return p

    # Group Timeout setting
    ##########################
    def makeTimeOutPanel(self, parent):
        p = wx.Panel(parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)

        timeoutsettingbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('timeoutsetting')), wx.VERTICAL)
        if self.multitorrent:
            self.timeoutsettingswitch = wx.CheckBox(p, -1, '')
            timeoutsettingbox.Add(self.timeoutsettingswitch, 0, wx.ALIGN_RIGHT | wx.TOP, -17)

        # Global switch for timeouts
        self.timeoutswitch = wx.CheckBox(p, -1, self.localize('timeoutglobal'))
        timeoutsettingbox.Add(self.timeoutswitch, 0, wx.TOP, self.firstvertgap)

        timeoutactionbox = wx.BoxSizer(wx.HORIZONTAL)
        self.timeoutaction = wx.ComboBox(p, -1, '', (-1, -1), (-1, -1),
                                         [self.localize('timeoutactionstandby'), self.localize('timeoutactionqueue'),
                                          self.localize('timeoutactionstop'), self.localize('timeoutactionstandbyfinish'),
                                          self.localize('timeoutactionqueuefinish'), self.localize('timeoutactionstopfinish')],
                                         wx.CB_DROPDOWN | wx.CB_READONLY)
        timeoutactionbox.Add(self.timeoutaction, 0, wx.ALIGN_CENTER_VERTICAL)
        timeoutactionbox.Add(wx.StaticText(p, -1, self.localize('timeoutaction')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        timeoutsettingbox.Add(timeoutactionbox, 0, wx.TOP, 3)

        workseedbox = wx.BoxSizer(wx.HORIZONTAL)

        workbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, ''), wx.VERTICAL)

        timeoutworkbox = wx.BoxSizer(wx.HORIZONTAL)
        timeoutworkbox.Add(wx.StaticText(p, -1, ' '))
        self.timeoutwork = wx.CheckBox(p, -1, self.localize('timeoutwork'))
        timeoutworkbox.Add(self.timeoutwork)
        workbox.Add(timeoutworkbox, 0, wx.TOP, -9)
        workbox.Add(wx.StaticText(p, -1, self.localize('watch')), 0, wx.TOP | wx.BOTTOM, 3)
        timeoutworkwatch = wx.BoxSizer(wx.VERTICAL)
        self.timeoutworkdown = wx.CheckBox(p, -1, self.localize('timeoutdown'))
        timeoutworkwatch.Add(self.timeoutworkdown)
        self.timeoutworktrack = wx.CheckBox(p, -1, self.localize('timeouttrack'))
        timeoutworkwatch.Add(self.timeoutworktrack, 0, wx.TOP, 1)
        workbox.Add(timeoutworkwatch, 0, wx.LEFT, 15)
        workseedbox.Add(workbox, 1, wx.EXPAND)

        seedbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, ''), wx.VERTICAL)

        timeoutseedbox = wx.BoxSizer(wx.HORIZONTAL)
        timeoutseedbox.Add(wx.StaticText(p, -1, ' '))
        self.timeoutseed = wx.CheckBox(p, -1, self.localize('timeoutseed'))
        timeoutseedbox.Add(self.timeoutseed)
        seedbox.Add(timeoutseedbox, 0, wx.TOP, -9)
        seedbox.Add(wx.StaticText(p, -1, self.localize('watch')), 0, wx.TOP | wx.BOTTOM, 3)
        timeoutseedwatch = wx.BoxSizer(wx.VERTICAL)
        self.timeoutseedup = wx.CheckBox(p, -1, self.localize('timeoutup'))
        timeoutseedwatch.Add(self.timeoutseedup)
        self.timeoutseedtrack = wx.CheckBox(p, -1, self.localize('timeouttrack'))
        timeoutseedwatch.Add(self.timeoutseedtrack, 0, wx.TOP, 1)
        seedbox.Add(timeoutseedwatch, 0, wx.LEFT, 15)
        workseedbox.Add(seedbox, 1, wx.EXPAND | wx.LEFT, 3)

        timeoutsettingbox.Add(workseedbox, 0, wx.EXPAND | wx.TOP, 3)

        sizer.Add(timeoutsettingbox, 0, wx.EXPAND | wx.TOP, 3)

        timeoutvaluesbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('timeoutvalues')), wx.VERTICAL)
        if self.multitorrent:
            self.timeoutvaluesswitch = wx.CheckBox(p, -1, '')
            timeoutvaluesbox.Add(self.timeoutvaluesswitch, 0, wx.ALIGN_RIGHT | wx.TOP, -17)

        # Timeout for down stream (minutes)
        download_box = wx.BoxSizer(wx.HORIZONTAL)
        download_box.Add(wx.StaticText(p, -1, self.localize('timeout_download')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.cb_ddownload = wx.TextCtrl(p, -1, '', (-1, -1), (31, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cb_ddownload.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cb_ddownload.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        download_box.Add(self.cb_ddownload, 0, wx.LEFT, 5)
        download_box.Add(wx.StaticText(p, -1, self.localize('l_day')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.cb_hdownload = wx.TextCtrl(p, -1, '', (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cb_hdownload.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cb_hdownload.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        download_box.Add(self.cb_hdownload, 0, wx.LEFT, 3)
        download_box.Add(wx.StaticText(p, -1, self.localize('l_hour')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.cb_mdownload = wx.TextCtrl(p, -1, '', (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cb_mdownload.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cb_mdownload.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        download_box.Add(self.cb_mdownload, 0, wx.LEFT, 3)
        download_box.Add(wx.StaticText(p, -1, self.localize('l_minute')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)

        timeoutvaluesbox.Add(download_box, 0, wx.TOP, self.firstvertgap)

        # Timeout for up stream (minutes)
        upload_box = wx.BoxSizer(wx.HORIZONTAL)
        upload_box.Add(wx.StaticText(p, -1, self.localize('timeout_upload')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.cb_dupload = wx.TextCtrl(p, -1, '', (-1, -1), (31, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cb_dupload.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cb_dupload.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        upload_box.Add(self.cb_dupload, 0, wx.LEFT, 5)
        upload_box.Add(wx.StaticText(p, -1, self.localize('l_day')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.cb_hupload = wx.TextCtrl(p, -1, '', (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cb_hupload.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cb_hupload.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        upload_box.Add(self.cb_hupload, 0, wx.LEFT, 3)
        upload_box.Add(wx.StaticText(p, -1, self.localize('l_hour')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.cb_mupload = wx.TextCtrl(p, -1, '', (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cb_mupload.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cb_mupload.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        upload_box.Add(self.cb_mupload, 0, wx.LEFT, 3)
        upload_box.Add(wx.StaticText(p, -1, self.localize('l_minute')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)

        timeoutvaluesbox.Add(upload_box, 0, wx.TOP, 3)

        # Timeout for contacting tracker (minutes)
        tracker_box = wx.BoxSizer(wx.HORIZONTAL)
        tracker_box.Add(wx.StaticText(p, -1, self.localize('timeout_tracker')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.cb_dtracker = wx.TextCtrl(p, -1, '', (-1, -1), (31, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cb_dtracker.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cb_dtracker.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        tracker_box.Add(self.cb_dtracker, 0, wx.LEFT, 5)
        tracker_box.Add(wx.StaticText(p, -1, self.localize('l_day')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.cb_htracker = wx.TextCtrl(p, -1, '', (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cb_htracker.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cb_htracker.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        tracker_box.Add(self.cb_htracker, 0, wx.LEFT, 3)
        tracker_box.Add(wx.StaticText(p, -1, self.localize('l_hour')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.cb_mtracker = wx.TextCtrl(p, -1, '', (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cb_mtracker.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cb_mtracker.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        tracker_box.Add(self.cb_mtracker, 0, wx.LEFT, 3)
        tracker_box.Add(wx.StaticText(p, -1, self.localize('l_minute')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)

        timeoutvaluesbox.Add(tracker_box, 0, wx.TOP, 3)

        sizer.Add(timeoutvaluesbox, 0, wx.EXPAND | wx.TOP, 3)

        p.SetSizer(sizer)
        p.SetAutoLayout(True)
        return p

    # Group Label/Move/Tracker
    ###########################
    def makeLabMovTraPanel(self, parent):
        p = wx.Panel(parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)

        labelbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('labelsetting')), wx.VERTICAL)
        if self.multitorrent:
            self.labelswitch = wx.CheckBox(p, -1, '')
            labelbox.Add(self.labelswitch, 0, wx.ALIGN_RIGHT | wx.TOP, -17)

        shortlabelbox = wx.BoxSizer(wx.HORIZONTAL)
        shortlabelbox.Add(wx.StaticText(p, -1, self.localize('shortlabel')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.shortlabel = wx.TextCtrl(p, -1, '', wx.Point(-1, -1), wx.Size(-1, -1))        
        shortlabelbox.Add(self.shortlabel, 1, wx.EXPAND | wx.LEFT, 5)

        labelbox.Add(shortlabelbox, 0, wx.EXPAND | wx.TOP, self.firstvertgap)

        movefolderbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('movingsetting')), wx.VERTICAL)
        if self.multitorrent:
            self.movefolderswitch = wx.CheckBox(p, -1, '')
            movefolderbox.Add(self.movefolderswitch, 0, wx.ALIGN_RIGHT | wx.TOP, -17)

        self.movefolder = wx.TextCtrl(p, -1, "", size = (-1, -1))
        buttonlabel = self.localize('browse')
        buttonwidth = self.GetTextExtent(buttonlabel)[0] + 12
        buttonlabel = buttonlabel.replace('&', '&&')
        movedirbrowsebtn = wx.Button(p, -1, buttonlabel, wx.Point(-1, -1), wx.Size(buttonwidth, self.utility.buttonheight))
        self.Bind(wx.EVT_BUTTON, self.onMoveDirBrowseDir, movedirbrowsebtn)
        movedirbox = wx.BoxSizer(wx.HORIZONTAL)
        movedirbox.Add(wx.StaticText(p, -1, self.localize('setmovefolder')), 0, wx.ALIGN_CENTER_VERTICAL)
        movedirbox.Add(self.movefolder, 1, wx.EXPAND | wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        movedirbox.Add(movedirbrowsebtn, 0, wx.ALIGN_CENTER_VERTICAL)

        movefolderbox.Add(movedirbox, 0, wx.EXPAND | wx.TOP, self.firstvertgap)

        trackerbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('tracker')), wx.VERTICAL)
        if self.multitorrent:
            self.exttrackerswitch = wx.CheckBox(p, -1, '')
            trackerbox.Add(self.exttrackerswitch, 0, wx.ALIGN_RIGHT | wx.TOP, -17)

        inttrackerbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('internaltracker')), wx.VERTICAL)

        self.extrainttracker = wx.CheckBox(p, -1, self.localize('extrainttracker'))        
        inttrackerbox.Add(self.extrainttracker, 0, wx.TOP, 3)

        inttrackerurlbox = wx.BoxSizer(wx.HORIZONTAL)
        inttrackerurlbox.Add(wx.StaticText(p, -1, self.localize('inttrackerurl')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.inttrackerurl = wx.TextCtrl(p, -1, '', wx.Point(-1, -1), wx.Size(-1, -1))        
        inttrackerurlbox.Add(self.inttrackerurl, 1, wx.EXPAND | wx.LEFT, 5)
        inttrackerbox.Add(inttrackerurlbox, 0, wx.EXPAND | wx.TOP, 3)

        trackerbox.Add(inttrackerbox, 0, wx.EXPAND | wx.TOP, self.firstvertgap)

        exttrackerbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('externaltracker')), wx.VERTICAL)

        self.exttracker = wx.CheckBox(p, -1, self.localize('exttrackersw'))        
        exttrackerbox.Add(self.exttracker, 0, wx.TOP, 3)

        exttrackerurlbox = wx.BoxSizer(wx.HORIZONTAL)
        exttrackerurlbox.Add(wx.StaticText(p, -1, self.localize('exttrackerurl')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.exttrackerurl = wx.TextCtrl(p, -1, '', wx.Point(-1, -1), wx.Size(-1, -1))        
        exttrackerurlbox.Add(self.exttrackerurl, 1, wx.EXPAND | wx.LEFT, 5)
        exttrackerbox.Add(exttrackerurlbox, 0, wx.EXPAND | wx.TOP, 3)

        self.checkinttrackwait = wx.CheckBox(p, -1, self.localize('checkinttrackwait'))        
        exttrackerbox.Add(self.checkinttrackwait, 0, wx.TOP, 3)

        trackerbox.Add(exttrackerbox, 0, wx.EXPAND | wx.TOP, 3)

        sizer.Add(labelbox, 0, wx.EXPAND | wx.TOP, 3)
        sizer.Add(movefolderbox, 0, wx.EXPAND | wx.TOP, 3)
        sizer.Add(trackerbox, 0, wx.EXPAND | wx.TOP, 3)

        p.SetSizer(sizer)
        p.SetAutoLayout(True)
        return p

    def onRightButtonText(self, event):
        pass

    def onLeftNoteBook(self, event):
        event.Skip()
        if not self.multitorrent:
            return
        clicked, where = self.notebook.HitTest((event.GetX(), event.GetY()))
        if where == wx.NB_HITTEST_ONLABEL:
            if clicked == self.notebook.GetSelection():
                if clicked == 0:
                    if self.downloadswitch.GetValue() and self.uploadswitch.GetValue() and self.continueswitch.GetValue():
                        self.downloadswitch.SetValue(False)
                        self.uploadswitch.SetValue(False)
                        self.continueswitch.SetValue(False)
                    else:
                        self.downloadswitch.SetValue(True)
                        self.uploadswitch.SetValue(True)
                        self.continueswitch.SetValue(True)
                elif clicked == 1:
                    if self.timeoutsettingswitch.GetValue() and self.timeoutvaluesswitch.GetValue():
                        self.timeoutsettingswitch.SetValue(False)
                        self.timeoutvaluesswitch.SetValue(False)
                    else:
                        self.timeoutsettingswitch.SetValue(True)
                        self.timeoutvaluesswitch.SetValue(True)
                elif clicked == 2:
                    if self.labelswitch.GetValue() and self.movefolderswitch.GetValue() and self.exttrackerswitch.GetValue():
                        self.labelswitch.SetValue(False)
                        self.movefolderswitch.SetValue(False)
                        self.exttrackerswitch.SetValue(False)
                    else:
                        self.labelswitch.SetValue(True)
                        self.movefolderswitch.SetValue(True)
                        self.exttrackerswitch.SetValue(True)

    def onMouseWheel(self, event):
        nextpage = self.notebook.GetSelection()
        if event.GetWheelRotation() * self.utility.mousewheelontab > 0:
            if nextpage < self.maxpage:
                nextpage += 1
            else:
                nextpage = 0
        else:
            if nextpage > 0:
                nextpage -= 1
            else:
                nextpage = self.maxpage
        self.notebook.SetSelection(nextpage)

    def onMoveDirBrowseDir(self, event):
        foldername = wx.DirDialog(self, self.localize('choosemovefolder'), 
                                 style = wx.DD_DEFAULT_STYLE | wx.DD_NEW_DIR_BUTTON)
        if foldername.ShowModal() == wx.ID_OK:
            self.movefolder.SetValue(foldername.GetPath())
        foldername.Destroy()

    def onSelectAll(self, event):
        newvalue = event.GetInt()
        self.utility.abcparams['multiparamdefault'] = str(int(newvalue))
        self.downloadswitch.SetValue(newvalue)
        self.uploadswitch.SetValue(newvalue)
        self.continueswitch.SetValue(newvalue)
        self.timeoutsettingswitch.SetValue(newvalue)
        self.timeoutvaluesswitch.SetValue(newvalue)
        self.labelswitch.SetValue(newvalue)
        self.movefolderswitch.SetValue(newvalue)
        self.exttrackerswitch.SetValue(newvalue)

    def onCancel(self, event = None):
        self.EndModal(wx.ID_CANCEL)

    def onApply(self, event):
        tor_info = []
        errortype = False
        if not self.multitorrent or self.labelswitch.GetValue():
            tor_info.append(self.shortlabel.GetValue())
        else:
            tor_info.append(None)
        if not self.multitorrent or self.downloadswitch.GetValue() and self.downloadrateswitch.GetValue():
            # Check download rate is integer
            try:
                download_rate = int(self.downloadrate.GetValue())
            except:
                errortype = True
            # Check if >= 0
            if errortype or download_rate < self.utility.mindownrate and download_rate != 0:
                dlg = wx.MessageDialog(self, self.localize('downloadrateminwarning') % self.utility.mindownrate,
                                       self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return
            tor_info.append(download_rate)
        else:
            tor_info.append(None)
        if not self.multitorrent or self.downloadswitch.GetValue() and self.prioritizedownswitch.GetValue():
            tor_info.append(int(self.prioritizedown.GetValue()))
        else:
            tor_info.append(None)
        if not self.multitorrent or self.uploadswitch.GetValue() and self.maxuploadswitch.GetValue():
            tor_info.append(int(self.maxupload.getValue()))
        else:
            tor_info.append(None)
        if not self.multitorrent or self.uploadswitch.GetValue() and self.uploadrateswitch.GetValue():
            # Check upload rate is integer
            try:
                upload_rate = int(self.uploadrate.GetValue())
            except:
                errortype = True
            # Check if < minuprate and != 0
            if errortype or upload_rate < self.utility.minuprate and upload_rate != 0:
                dlg = wx.MessageDialog(self, self.localize('uploadrateminwarningauto') % self.utility.minuprate,
                                       self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return
            tor_info.append(upload_rate)
        else:
            tor_info.append(None)
        if not self.multitorrent or self.uploadswitch.GetValue() and self.prioritizeupswitch.GetValue():
            tor_info.append(int(self.prioritizeup.GetValue()))
        else:
            tor_info.append(None)
        if not self.multitorrent or self.continueswitch.GetValue():
            for i in xrange(4):
                if self.rb[i].GetValue():
                    tor_info.append(i + 10 * int(self.uploadtillcopycomplete.GetValue()))
                    break
            dtime = self.cbdtime.GetValue()
            htime = self.cbhtime.GetValue()
            mtime = self.cbmtime.GetValue()
            if not dtime:
                dtime = '0'
            if not htime:
                htime = '0'
            if not mtime:
                mtime = '0'
            dtime_int, mtime_int = divmod(1440 * int(dtime) + 60 * int(htime) + int(mtime), 1440)
            htime_int, mtime_int = divmod(mtime_int, 60)
            self.cbdtime.SetValue(str(dtime_int))
            self.cbhtime.SetValue(str(htime_int))
            self.cbmtime.SetValue(str(mtime_int))
            tor_info.append(24 * dtime_int + htime_int)
            tor_info.append(mtime_int)
            ratio = self.cbratio.GetValue()
            if not ratio:
                ratio = '0'
            tor_info.append(int(ratio))
        else:
            tor_info.extend(4 * [None])
        if not self.multitorrent or self.timeoutsettingswitch.GetValue():
            tor_info.append(int(self.timeoutswitch.GetValue()))
            tor_info.append(self.timeoutaction.GetSelection())
            tor_info.append(int(self.timeoutwork.GetValue()))
            tor_info.append(int(self.timeoutworkdown.GetValue()))
            if self.timeoutworktrack.IsEnabled():
                tor_info.append(int(self.timeoutworktrack.GetValue()))
            else:
                tor_info.append(None)
            tor_info.append(int(self.timeoutseed.GetValue()))
            tor_info.append(int(self.timeoutseedup.GetValue()))
            if self.timeoutseedtrack.IsEnabled():
                tor_info.append(int(self.timeoutseedtrack.GetValue()))
            else:
                tor_info.append(None)
        else:
            tor_info.extend(8 * [None])
        if not self.multitorrent or self.timeoutvaluesswitch.GetValue():
            dtime = self.cb_dtracker.GetValue()
            htime = self.cb_htracker.GetValue()
            mtime = self.cb_mtracker.GetValue()
            if not dtime:
                dtime = '0'
            if not htime:
                htime = '0'
            if not mtime:
                mtime = '0'
            mtimetotal_int = 1440 * int(dtime) + 60 * int(htime) + int(mtime)
            dtime_int, mtime_int = divmod(mtimetotal_int, 1440)
            htime_int, mtime_int = divmod(mtime_int, 60)
            self.cb_dtracker.SetValue(str(dtime_int))
            self.cb_htracker.SetValue(str(htime_int))
            self.cb_mtracker.SetValue(str(mtime_int))
            tor_info.append(mtimetotal_int)
            dtime = self.cb_ddownload.GetValue()
            htime = self.cb_hdownload.GetValue()
            mtime = self.cb_mdownload.GetValue()
            if not dtime:
                dtime = '0'
            if not htime:
                htime = '0'
            if not mtime:
                mtime = '0'
            mtimetotal_int = 1440 * int(dtime) + 60 * int(htime) + int(mtime)
            dtime_int, mtime_int = divmod(mtimetotal_int, 1440)
            htime_int, mtime_int = divmod(mtime_int, 60)
            self.cb_ddownload.SetValue(str(dtime_int))
            self.cb_hdownload.SetValue(str(htime_int))
            self.cb_mdownload.SetValue(str(mtime_int))
            tor_info.append(mtimetotal_int)
            dtime = self.cb_dupload.GetValue()
            htime = self.cb_hupload.GetValue()
            mtime = self.cb_mupload.GetValue()
            if not dtime:
                dtime = '0'
            if not htime:
                htime = '0'
            if not mtime:
                mtime = '0'
            mtimetotal_int = 1440 * int(dtime) + 60 * int(htime) + int(mtime)
            dtime_int, mtime_int = divmod(mtimetotal_int, 1440)
            htime_int, mtime_int = divmod(mtime_int, 60)
            self.cb_dupload.SetValue(str(dtime_int))
            self.cb_hupload.SetValue(str(htime_int))
            self.cb_mupload.SetValue(str(mtime_int))
            tor_info.append(mtimetotal_int)
        else:
            tor_info.extend(3 * [None])
        if not self.multitorrent or self.movefolderswitch.GetValue():
            # Check if move folder is a valid Windows name
            tormovefolder = self.movefolder.GetValue()
            if sys.platform == 'win32' and tormovefolder and tormovefolder != self.torrent.movefolder:
                # We erase the final '\' except for a path like 'X:\'
                if tormovefolder and tormovefolder[-1] == '\\' and (len(tormovefolder) < 2 or tormovefolder[-2] != ':'):
                    tormovefolder = tormovefolder[:-1]
                tormovefolder = tormovefolder.rstrip(whitespace + '.')
                if not self.utility.checkWinPath(self, tormovefolder):
                    return
            tor_info.append(tormovefolder)
        else:
            tor_info.append(None)
        if not self.multitorrent or self.exttrackerswitch.GetValue():
            tor_info.append(int(self.exttracker.GetValue()))
            tor_info.append(self.exttrackerurl.GetValue())
            tor_info.append(int(self.checkinttrackwait.GetValue()))
            tor_info.append(int(self.extrainttracker.GetValue()))
            tor_info.append(self.inttrackerurl.GetValue())
        else:
            tor_info.extend(5 * [None])

        if self.panel.commandfromlist:
            self.queue.changeLocalInfo(self.panel.getSelected(), tor_info)
        else:
            try:
                index = self.queue.proctab.index(self.torrent)
            except:
                return True
            self.queue.changeLocalInfo([index], tor_info)

        return True

    def onOK(self, event):
        if self.onApply(event):
            self.EndModal(wx.ID_OK)
