
##############################################################################
# Module : templatedlg.py
# Author : Old King Cole
# Date   : 01/29/2005
#
# Description : Dialog for editing templates
#
##############################################################################
import sys, wx
from os import path, remove, rename
from copy import deepcopy
from string import whitespace

from filemanager import TorrentConfigFileManager, TemplateListFileManager, ConLimiterListFileManager
from utility import SpinBox


class TemplateDialog(wx.Dialog):
    def __init__(self, parent, ID, title, templatemanager,
                 pos = wx.DefaultPosition, size = wx.DefaultSize,
                 style = wx.DEFAULT_DIALOG_STYLE):
        pre = wx.PreDialog()
        pre.Create(parent, ID, title, pos, size, style)
        self.this = pre.this
        self.parent = parent
        self.utility = self.parent.utility
        self.abcparams = self.utility.abcparams
        self.localize = self.utility.lang.get
        self.tempmanager = templatemanager
        self.templates = templatemanager.templates
        self.tempbyindex = templatemanager.tempbyindex
        self.tempbytrigrank = templatemanager.tempbytrigrank
        self.conlimiters = templatemanager.conlimiters
        self.sortdir = 2
        self.lastsortingcol = -1
        self.sortdirtrig = 2
        self.lastsortingcoltrig = -1

        # To remember template renamings and deletings before final apply
        self.bufferedmodif = {}

        outerbox = wx.BoxSizer(wx.VERTICAL)

        self.templistbx = wx.StaticBox(self, -1, self.localize('templist'))
        templistbox = wx.StaticBoxSizer(self.templistbx, wx.HORIZONTAL)

        self.templist = wx.ListCtrl(self, -1,
                                    style = wx.LC_REPORT | wx.LC_SINGLE_SEL | wx.LC_HRULES | wx.LC_VRULES)
        self.templist.SetMinSize((-1, 136))
        self.templist.InsertColumn(0, self.localize('templistname'))
        self.templist.SetColumnWidth(0, 148)
        self.templist.InsertColumn(1, self.localize('templistlabel'))
        self.templist.SetColumnWidth(1, 147)

        templistbox.Add(self.templist, 1, wx.EXPAND | wx.ALIGN_CENTER | wx.RIGHT, 4)

        upbtn = wx.Button(self, -1, self.localize('tempup'), size = (15, 32))
        downbtn = wx.Button(self, -1, self.localize('tempdown'), size = (15, 32))

        updownbuttonbox = wx.BoxSizer(wx.VERTICAL)
        updownbuttonbox.Add(upbtn, 0, wx.ALL, 0)
        updownbuttonbox.Add(downbtn, 0, wx.TOP, 5)

        templistbox.Add(updownbuttonbox, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 11)

        addbtn = wx.Button(self, -1, self.localize('tempadd'), size = (48, -1))
        copybtn = wx.Button(self, -1, self.localize('tempcopy'), size = (48, -1))
        renamebtn = wx.Button(self, -1, self.localize('temprename'), size = (48, -1))
        deletebtn = wx.Button(self, -1, self.localize('tempdelete'), size = (48, -1))
        self.triggerbtn = wx.ToggleButton(self, -1, self.localize('temptrigger'), size = (48, -1))

        buttonbox1 = wx.BoxSizer(wx.VERTICAL)
        buttonbox1.Add(addbtn, 0, wx.TOP, 0)
        buttonbox1.Add(copybtn, 0, wx.TOP, 5)
        buttonbox1.Add(renamebtn, 0, wx.TOP, 5)
        buttonbox1.Add(deletebtn, 0, wx.TOP, 5)
        buttonbox1.Add(self.triggerbtn, 0, wx.TOP, 10)

        templistbox.Add(buttonbox1, 0, wx.ALIGN_CENTER_VERTICAL | wx.TOP, -5)

        outerbox.Add(templistbox, 0, wx.EXPAND | wx.ALL, 5)

        self.selectedtempparambox = wx.StaticBoxSizer(wx.StaticBox(self, -1, self.localize('selectedtempparam')), wx.VERTICAL)

        tempdeschiddenbox = wx.BoxSizer(wx.HORIZONTAL)

        tempdescbox = wx.StaticBoxSizer(wx.StaticBox(self, -1, self.localize('tempdesc')), wx.HORIZONTAL)
        self.tempdesc = wx.TextCtrl(self, -1)
        tempdescbox.Add(self.tempdesc, 1, wx.TOP, 0)
        tempdeschiddenbox.Add(tempdescbox, 1, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 0)
        hiddenlinkablestickybox = wx.BoxSizer(wx.VERTICAL)
        self.temphidden = wx.CheckBox(self, -1, self.localize('temphidden'))
        self.templinkable = wx.CheckBox(self, -1, self.localize('templinkable'))
        self.tempsticky = wx.CheckBox(self, -1, self.localize('tempsticky'))
        hiddenlinkablestickybox.Add(self.temphidden, 0, wx.TOP, 5)
        hiddenlinkablestickybox.Add(self.templinkable, 0, wx.TOP, 3)
        hiddenlinkablestickybox.Add(self.tempsticky, 0, wx.TOP, 3)
        tempdeschiddenbox.Add(hiddenlinkablestickybox, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        self.selectedtempparambox.Add(tempdeschiddenbox, 0, wx.EXPAND | wx.ALL, 0)

        botpanelbox = wx.BoxSizer(wx.VERTICAL)
        self.bottompanel = wx.Panel(self, -1)

        self.parampanel = wx.Panel(self.bottompanel, -1)
        parambox = wx.BoxSizer(wx.VERTICAL)

        self.notebook = wx.Notebook(self.parampanel, -1)
        self.notebook.SetPadding((4, 3))
        self.notebook.AddPage(self.makeLabelPanel(self.notebook), self.localize('chtemplabel'))
        self.notebook.AddPage(self.makeDownloadSettingPanel(self.notebook), self.localize('chtempdownloadsetting'))
        self.notebook.AddPage(self.makeUploadSettingPanel(self.notebook), self.localize('chtempuploadsetting'))
        self.notebook.AddPage(self.makeSeedingSettingPanel(self.notebook), self.localize('chtempseedingsetting'))
        self.notebook.AddPage(self.makeTimeOutPanel(self.notebook), self.localize('chtemptimeout'))
        self.notebook.AddPage(self.makeMovePanel(self.notebook), self.localize('chtempmove'))
        self.notebook.AddPage(self.makeTrackerPanel(self.notebook), self.localize('chtemptracker'))
        self.notebook.SetAutoLayout(True)

        self.maxpage = self.notebook.GetPageCount() - 1
        self.notebook.SetSelection(min(int(self.abcparams['lastopentemptab']), self.maxpage))

        parambox.Add(self.notebook, 0, wx.EXPAND | wx.ALL, 0)

        self.dirboxpanel = wx.Panel(self.parampanel, -1)
        self.dirbox = wx.BoxSizer(wx.HORIZONTAL)

        self.defaultdownlocswitch = wx.CheckBox(self.dirboxpanel, -1, self.localize('defaultfolder'))
        self.defaultdownloc = wx.TextCtrl(self.dirboxpanel, -1, '')
        buttonlabel = self.localize('browse')
        buttonwidth = self.GetTextExtent(buttonlabel)[0] + 12
        buttonlabel = buttonlabel.replace('&', '&&')
        self.browsebtn = wx.Button(self.dirboxpanel, -1, buttonlabel, (-1, -1), (buttonwidth, self.utility.buttonheight))
        self.Bind(wx.EVT_BUTTON, self.onBrowseDownDir, self.browsebtn)
        self.dirbox.Add(self.defaultdownlocswitch, 0, wx.ALIGN_CENTER_VERTICAL)
        self.dirbox.Add(self.defaultdownloc, 1, wx.EXPAND | wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        self.dirbox.Add(self.browsebtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        self.dirboxpanel.SetSizer(self.dirbox)
        self.dirboxpanel.SetAutoLayout(True)

        parambox.Add(self.dirboxpanel, 0, wx.EXPAND | wx.TOP, 3)

        self.parampanel.SetSizer(parambox)
        self.parampanel.SetAutoLayout(True)

        botpanelbox.Add(self.parampanel, 0, wx.EXPAND | wx.ALL, 0)

        self.triggerpanel = wx.Panel(self.bottompanel, -1)
        triggerbox = wx.StaticBoxSizer(wx.StaticBox(self.triggerpanel, -1, self.localize('temptriggerheader')), wx.VERTICAL)

        self.ruleactive = wx.CheckBox(self.triggerpanel, -1, self.localize('ruleactive'))
        triggerbox.Add(self.ruleactive, 0, wx.TOP, 5)

        triggerbox.Add(wx.StaticText(self.triggerpanel, -1, self.localize('temptriggertext')), 0, wx.EXPAND | wx.TOP, 10)

        ruletrackerbox = wx.BoxSizer(wx.HORIZONTAL)
        self.ruletracker = wx.TextCtrl(self.triggerpanel, -1, '', wx.Point(-1, -1), wx.Size(-1, -1))
        buttonlabel = self.localize('findand')
        buttonwidth = self.GetTextExtent(buttonlabel)[0] + 12
        buttonlabel = buttonlabel.replace('&', '&&')
        self.ruletrackerbtn = wx.ToggleButton(self.triggerpanel, -1, buttonlabel, size = (buttonwidth, self.utility.buttonheight))
        ruletrackerbox.Add(wx.StaticText(self.triggerpanel, -1, self.localize('findtrackername')), 0, wx.ALIGN_CENTER_VERTICAL)
        ruletrackerbox.Add(self.ruletracker, 1, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 3)
        ruletrackerbox.Add(self.ruletrackerbtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 1)
        triggerbox.Add(ruletrackerbox, 0, wx.EXPAND | wx.TOP, 8)

        ruletorrentbox = wx.BoxSizer(wx.HORIZONTAL)
        self.ruletorrent = wx.TextCtrl(self.triggerpanel, -1, '', wx.Point(-1, -1), wx.Size(-1, -1))
        self.ruletorrentbtn = wx.ToggleButton(self.triggerpanel, -1, buttonlabel, size = (buttonwidth, self.utility.buttonheight))
        ruletorrentbox.Add(wx.StaticText(self.triggerpanel, -1, self.localize('findtorrentname')), 0, wx.ALIGN_CENTER_VERTICAL)
        ruletorrentbox.Add(self.ruletorrent, 1, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 3)
        ruletorrentbox.Add(self.ruletorrentbtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 1)
        triggerbox.Add(ruletorrentbox, 0, wx.EXPAND | wx.TOP, 3)

        ruletorrentfilebox = wx.BoxSizer(wx.HORIZONTAL)
        self.ruletorrentfile = wx.TextCtrl(self.triggerpanel, -1, '', wx.Point(-1, -1), wx.Size(-1, -1))
        self.ruletorrentfilebtn = wx.ToggleButton(self.triggerpanel, -1, buttonlabel, size = (buttonwidth, self.utility.buttonheight))
        ruletorrentfilebox.Add(wx.StaticText(self.triggerpanel, -1, self.localize('findtorrentfilename')), 0, wx.ALIGN_CENTER_VERTICAL)
        ruletorrentfilebox.Add(self.ruletorrentfile, 1, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 3)
        ruletorrentfilebox.Add(self.ruletorrentfilebtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 1)
        triggerbox.Add(ruletorrentfilebox, 0, wx.EXPAND | wx.TOP, 3)

        rulereceivedbox = wx.BoxSizer(wx.HORIZONTAL)
        self.rulereceived = wx.TextCtrl(self.triggerpanel, -1, '', wx.Point(-1, -1), wx.Size(-1, -1))
        self.rulereceivedbtn = wx.ToggleButton(self.triggerpanel, -1, buttonlabel, size = (buttonwidth, self.utility.buttonheight))
        rulereceivedbox.Add(wx.StaticText(self.triggerpanel, -1, self.localize('rulereceived')), 0, wx.ALIGN_CENTER_VERTICAL)
        rulereceivedbox.Add(self.rulereceived, 1, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 3)
        rulereceivedbox.Add(self.rulereceivedbtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 1)
        triggerbox.Add(rulereceivedbox, 0, wx.EXPAND | wx.TOP, 3)

        rulesizegbox = wx.BoxSizer(wx.HORIZONTAL)
        self.rulesizeg = wx.TextCtrl(self.triggerpanel, -1, '', wx.Point(-1, -1), wx.Size(-1, -1), style = wx.TE_RIGHT)
        self.rulesizegunit = wx.ComboBox(self.triggerpanel, -1, '', (-1,-1), (-1, -1),
                                         [self.localize('GB'), self.localize('MB'), self.localize('kB'), self.localize('Byte')],
                                         wx.CB_DROPDOWN | wx.CB_READONLY)
        rulesizegbox.Add(wx.StaticText(self.triggerpanel, -1, self.localize('rulesizeg')), 0, wx.ALIGN_CENTER_VERTICAL)
        rulesizegbox.Add(self.rulesizeg, 1, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 3)
        rulesizegbox.Add(self.rulesizegunit, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 3)
        triggerbox.Add(rulesizegbox, 0, wx.EXPAND | wx.TOP, 3)

        rulesizelbox = wx.BoxSizer(wx.HORIZONTAL)
        self.rulesizel = wx.TextCtrl(self.triggerpanel, -1, '', wx.Point(-1, -1), wx.Size(-1, -1), style = wx.TE_RIGHT)
        self.rulesizelunit = wx.ComboBox(self.triggerpanel, -1, '', (-1,-1), (-1, -1),
                                         [self.localize('GB'), self.localize('MB'), self.localize('kB'), self.localize('Byte')],
                                         wx.CB_DROPDOWN | wx.CB_READONLY)
        rulesizelbox.Add(wx.StaticText(self.triggerpanel, -1, self.localize('rulesizel')), 0, wx.ALIGN_CENTER_VERTICAL)
        rulesizelbox.Add(self.rulesizel, 1, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 3)
        rulesizelbox.Add(self.rulesizelunit, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 3)
        triggerbox.Add(rulesizelbox, 0, wx.EXPAND | wx.TOP, 3)

        self.triggerpanel.SetSizer(triggerbox)
        self.triggerpanel.SetAutoLayout(True)

        botpanelbox.Add(self.triggerpanel, 0, wx.EXPAND | wx.ALL, 0)

        self.bottompanel.SetSizer(botpanelbox)
        self.bottompanel.SetAutoLayout(True)

        self.selectedtempparambox.Add(self.bottompanel, 0, wx.EXPAND | wx.ALL, 3)

        outerbox.Add(self.selectedtempparambox, 0, wx.EXPAND | wx.LEFT | wx.RIGHT, 5)

        applybtn = wx.Button(self, -1, self.localize('apply'), size = (60, -1))
        okbtn = wx.Button(self, -1, self.localize('ok'), size = (60, -1))
        cancelbtn = wx.Button(self, -1, self.localize('cancel'), size = (60, -1))

        buttonbox2 = wx.BoxSizer(wx.HORIZONTAL)
        buttonbox2.Add(applybtn, 0, wx.LEFT, 0)
        buttonbox2.Add(okbtn, 0, wx.LEFT, 20)
        buttonbox2.Add(cancelbtn, 0, wx.LEFT, 20)

        outerbox.Add(buttonbox2, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.BOTTOM | wx.TOP, 6)

        self.triggerpanel.Hide()

        self.SetAutoLayout(True)
        self.SetSizer(outerbox)
        self.Fit()

        self.utility.frameWindow(self.rb4, xl = 11, xt = -1, border = 1, midline = 1)

        self.triggerpanel.SetSize(self.parampanel.GetSize())

        # Add events
        ###########################
        self.Bind(wx.EVT_BUTTON, self.onUpInList, upbtn)
        self.Bind(wx.EVT_BUTTON, self.onDownInList, downbtn)
        self.Bind(wx.EVT_BUTTON, self.onAddTemplate, addbtn)
        self.Bind(wx.EVT_BUTTON, self.onCopyTemplate, copybtn)
        self.Bind(wx.EVT_BUTTON, self.onRenameTemplate, renamebtn)
        self.Bind(wx.EVT_BUTTON, self.onDeleteTemplate, deletebtn)
        self.Bind(wx.EVT_TOGGLEBUTTON, self.onTrigger, self.triggerbtn)
        self.Bind(wx.EVT_BUTTON, self.onOK, okbtn)
        self.Bind(wx.EVT_BUTTON, self.onApply, applybtn)
        self.Bind(wx.EVT_BUTTON, self.onCancel, cancelbtn)
        self.Bind(wx.EVT_CLOSE, self.onCancel)
        self.templist.Bind(wx.EVT_LEFT_DOWN, self.onListLeftClick)
        self.templist.Bind(wx.EVT_LIST_COL_CLICK, self.onColLeftClick)
        self.templist.Bind(wx.EVT_KEY_DOWN, self.onKeyInList)
        self.Bind(wx.EVT_CHECKBOX, self.onTempLabelSwitch, self.templabelswitch)
        self.Bind(wx.EVT_CHECKBOX, self.onTempDownloadSwitch, self.tempdownloadswitch)
        self.Bind(wx.EVT_CHECKBOX, self.onTempUploadSwitch, self.tempuploadswitch)
        self.Bind(wx.EVT_CHECKBOX, self.onTempSeedingSwitch, self.tempseedingswitch)
        self.Bind(wx.EVT_CHECKBOX, self.onTempTimeoutSwitch, self.temptimeoutswitch)
        self.Bind(wx.EVT_CHECKBOX, self.onTempMoveSwitch, self.tempmoveswitch)
        self.Bind(wx.EVT_CHECKBOX, self.onTempTrackerSwitch, self.temptrackerswitch)
        self.shortlabel.Bind(wx.EVT_TEXT, self.onUpdateLabel)
        self.shortlabel.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.shortlabel.Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
        self.tempdesc.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.tempdesc.Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
        self.movefolder.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.exttrackerurl.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.exttrackerurl.Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
        self.inttrackerurl.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.inttrackerurl.Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
        self.ruletracker.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.ruletracker.Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
        self.ruletorrent.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.ruletorrent.Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
        self.ruletorrentfile.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.ruletorrentfile.Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
        self.rulereceived.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.rulereceived.Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
        self.rulesizeg.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDot)
        self.rulesizel.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDot)
        self.bottompanel.Bind(wx.EVT_MOUSEWHEEL, self.onMouseWheelNotebook)

        self.editedtemplates = deepcopy(self.templates)
        self.editedtempbyindex = self.tempbyindex[:]
        self.editedtempbytrigrank = self.tempbytrigrank[:]

        self.templatedefault = self.abcparams['templatedefault']
        index = 0
        for key in self.editedtempbyindex:
            self.templist.InsertStringItem(index, key)
            self.templist.SetStringItem(index, 1, self.editedtemplates[key].shortlabel)
            if key == self.templatedefault:
                self.templist.SetItemTextColour(index, wx.Colour(255, 0, 0))
            self.editedtemplates[key].previndex = self.editedtemplates[key].previndextrig = index
            index += 1

        # Select the default template at startup
        self.selectedindex = self.templist.FindItem(-1, self.templatedefault)
        self.currentlyedited = self.templist.GetItem(self.selectedindex, 0).GetText()
        self.templist.Select(self.selectedindex)
        self.templist.Focus(self.selectedindex)
        self.fillTemplateMask(self.editedtemplates[self.currentlyedited])

        if self.abcparams['templatedlgx'] != '-1':
            self.MoveXY(int(self.abcparams['templatedlgx']), int(self.abcparams['templatedlgy']))

        self.templist.SetFocus()

    # Group Label
    ##########################
    def makeLabelPanel(self, parent):
        p = wx.Panel(parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)

        self.templabelswitch = wx.CheckBox(p, -1, self.localize('templabelswitch'))

        sizer.Add(self.templabelswitch, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.TOP, 6)

        labelbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, ''), wx.VERTICAL)
        shortlabelbox = wx.BoxSizer(wx.HORIZONTAL)
        shortlabelbox.Add(wx.StaticText(p, -1, self.localize('shortlabel')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.shortlabel = wx.TextCtrl(p, -1, '', wx.Point(-1, -1), wx.Size(200, -1))        
        shortlabelbox.Add(self.shortlabel, 1, wx.EXPAND | wx.LEFT, 5)

        labelbox.Add(shortlabelbox, 0, wx.EXPAND | wx.TOP, 3)

        sizer.Add(labelbox, 0, wx.EXPAND | wx.TOP, 0)

        p.SetSizer(sizer)
        p.SetAutoLayout(True)
        return p

    # Group Download rate setting
    ###########################
    def makeDownloadSettingPanel(self, parent):
        p = wx.Panel(parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)

        self.tempdownloadswitch = wx.CheckBox(p, -1, self.localize('tempdownloadswitch'))

        sizer.Add(self.tempdownloadswitch, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.TOP, 6)

        downloadsettingbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, ''), wx.VERTICAL)

        maxdownloadratebox = wx.BoxSizer(wx.HORIZONTAL)
        maxdownloadratebox.Add(wx.StaticText(p, -1,  self.localize('maxdownloadrate')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.downloadrate = wx.TextCtrl(p, -1, '', wx.Point(-1, -1),
                                        wx.Size(40, self.utility.digitheight), style = wx.TE_RIGHT)
        self.downloadrate.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.downloadrate.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        maxdownloadratebox.Add(self.downloadrate, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        maxdownloadratebox.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL)

        downloadsettingbox.Add(maxdownloadratebox, 0, wx.TOP, 3)

        self.prioritizedown = wx.CheckBox(p, -1, self.localize('prioritizedown'))

        downloadsettingbox.Add(self.prioritizedown, 0, wx.TOP, 3)

        sizer.Add(downloadsettingbox, 0, wx.EXPAND | wx.TOP, 0)

        p.SetSizer(sizer)
        p.SetAutoLayout(True)
        return p

    # Group Upload rate setting
    ###########################
    def makeUploadSettingPanel(self, parent):
        p = wx.Panel(parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)

        self.tempuploadswitch = wx.CheckBox(p, -1, self.localize('tempuploadswitch'))

        sizer.Add(self.tempuploadswitch, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.TOP, 6)

        uploadsettingbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, ''), wx.VERTICAL)

        self.maxupload = SpinBox(p, header = self.localize('maxuploads'),
                                 width = 31, height = self.utility.digitheight,
                                 min = self.utility.minuploads, max = 100)

        uploadsettingbox.Add(self.maxupload.getSizer(), 0, wx.ALIGN_CENTER_VERTICAL | wx.TOP, 3)

        maxuploadratebox = wx.BoxSizer(wx.HORIZONTAL)
        maxuploadratebox.Add(wx.StaticText(p, -1,  self.localize('maxuploadrate')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.uploadrate = wx.TextCtrl(p, -1, '', wx.Point(-1, -1),
                                      wx.Size(40, self.utility.digitheight), style = wx.TE_RIGHT)
        self.uploadrate.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.uploadrate.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        maxuploadratebox.Add(self.uploadrate, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        maxuploadratebox.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL)

        uploadsettingbox.Add(maxuploadratebox, 0, wx.ALIGN_CENTER_VERTICAL | wx.TOP, 3)

        self.prioritizeup = wx.CheckBox(p, -1, self.localize('prioritizeup'))

        uploadsettingbox.Add(self.prioritizeup, 0, wx.TOP, 3)

        sizer.Add(uploadsettingbox, 0, wx.EXPAND | wx.TOP, 0)

        p.SetSizer(sizer)
        p.SetAutoLayout(True)
        return p

    # Group Seeding setting
    ###########################
    def makeSeedingSettingPanel(self, parent):
        p = wx.Panel(parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)

        self.tempseedingswitch = wx.CheckBox(p, -1, self.localize('tempseedingswitch'))

        sizer.Add(self.tempseedingswitch, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.TOP, 6)

        seedingsettingbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, ''), wx.VERTICAL)

        uploadlist = [self.localize('unlimitedupload'), self.localize('continueuploadfor'), self.localize('untilratio'), self.localize('onfirstreached')]

        rb1 = wx.RadioButton(p, -1, uploadlist[0], wx.Point(-1, -1), wx.Size(-1, -1), wx.RB_GROUP)
        rb2 = wx.RadioButton(p, -1, uploadlist[1], wx.Point(-1, -1), wx.Size(-1, -1))
        rb3 = wx.RadioButton(p, -1, uploadlist[2], wx.Point(-1, -1), wx.Size(-1, -1))
        self.rb4 = wx.RadioButton(p, -1, uploadlist[3], wx.Point(-1, -1), wx.Size(-1, -1))
        self.rb = [rb1, rb2, rb3, self.rb4]

        seedingsettingbox.Add(rb1, 0, wx.ALIGN_CENTER_VERTICAL | wx.TOP, 3)

        time_sizer = wx.BoxSizer(wx.HORIZONTAL)
        time_sizer.Add(rb2, 0, wx.ALIGN_CENTER_VERTICAL)

        self.cbdtime = wx.TextCtrl(p, -1, '', (-1, -1), (31, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cbdtime.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cbdtime.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        time_sizer.Add(self.cbdtime, 0, wx.LEFT, 5)
        time_sizer.Add(wx.StaticText(p, -1, self.localize('l_day')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.cbhtime = wx.TextCtrl(p, -1, '', (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cbhtime.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cbhtime.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        time_sizer.Add(self.cbhtime, 0, wx.LEFT, 3)
        time_sizer.Add(wx.StaticText(p, -1, self.localize('l_hour')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.cbmtime = wx.TextCtrl(p, -1, '', (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cbmtime.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cbmtime.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        time_sizer.Add(self.cbmtime, 0, wx.LEFT, 3)
        time_sizer.Add(wx.StaticText(p, -1, self.localize('l_minute')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)

        seedingsettingbox.Add(time_sizer, 0, wx.ALIGN_CENTER_VERTICAL)

        seedingsettingbox.Add(self.rb4, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 19)

        self.cbratio = wx.TextCtrl(p, -1, '', (-1, -1), (37, self.utility.digitheight), style = wx.TE_RIGHT)
        self.cbratio.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cbratio.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)

        percent_sizer = wx.BoxSizer(wx.HORIZONTAL)
        percent_sizer.Add(rb3, 0, wx.ALIGN_CENTER_VERTICAL)
        percent_sizer.Add(self.cbratio, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        percent_sizer.Add(wx.StaticText(p, -1, "%"), 0, wx.ALIGN_CENTER_VERTICAL)

        seedingsettingbox.Add(percent_sizer, 0, wx.ALIGN_CENTER_VERTICAL)

        self.uploadtillcopycomplete = wx.CheckBox(p, -1, self.localize('uploadtillcopycomplete'))

        seedingsettingbox.Add(self.uploadtillcopycomplete, 0, wx.TOP, 3)

        sizer.Add(seedingsettingbox, 0, wx.EXPAND | wx.TOP, 0)

        p.SetSizer(sizer)
        p.SetAutoLayout(True)
        return p

    # Group Timeout setting
    ##########################
    def makeTimeOutPanel(self, parent):
        p = wx.Panel(parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)

        self.temptimeoutswitch = wx.CheckBox(p, -1, self.localize('temptimeoutswitch'))

        sizer.Add(self.temptimeoutswitch, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.TOP, 6)

        timeoutsbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, ''), wx.VERTICAL)

        # Global switch for timeouts
        self.timeoutswitch = wx.CheckBox(p, -1, self.localize('temptimeoutglobal'))
        timeoutsbox.Add(self.timeoutswitch, 0, wx.TOP, 0)

        timeoutactionbox = wx.BoxSizer(wx.HORIZONTAL)
        self.timeoutaction = wx.ComboBox(p, -1, '', (-1, -1), (-1, -1),
                                         [self.localize('timeoutactionstandby'), self.localize('timeoutactionqueue'),
                                         self.localize('timeoutactionstop'), self.localize('timeoutactionstandbyfinish'),
                                         self.localize('timeoutactionqueuefinish'), self.localize('timeoutactionstopfinish')],
                                         wx.CB_DROPDOWN | wx.CB_READONLY)
        timeoutactionbox.Add(self.timeoutaction, 0, wx.ALIGN_CENTER_VERTICAL)
        timeoutactionbox.Add(wx.StaticText(p, -1, self.localize('timeoutaction')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        timeoutsbox.Add(timeoutactionbox, 0, wx.TOP, 3)

        workseedvalbox = wx.FlexGridSizer(cols = 3, hgap = 3)
        workseedvalbox.AddGrowableCol(0)
        workseedvalbox.AddGrowableCol(1)
        workseedvalbox.AddGrowableCol(2)

        workbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, ''), wx.VERTICAL)

        timeoutworkbox = wx.BoxSizer(wx.HORIZONTAL)
        timeoutworkbox.Add(wx.StaticText(p, -1, ' '))
        self.timeoutwork = wx.CheckBox(p, -1, self.localize('timeoutwork'))
        timeoutworkbox.Add(self.timeoutwork)
        workbox.Add(timeoutworkbox, 0, wx.TOP, -9)
        workbox.Add(wx.StaticText(p, -1, self.localize('watch')), 0, wx.TOP | wx.BOTTOM, 3)
        timeoutworkwatch = wx.BoxSizer(wx.VERTICAL)
        self.timeoutworkdown = wx.CheckBox(p, -1, self.localize('timeoutdown'))
        timeoutworkwatch.Add(self.timeoutworkdown)
        self.timeoutworktrack = wx.CheckBox(p, -1, self.localize('timeouttrack'))
        timeoutworkwatch.Add(self.timeoutworktrack, 0, wx.TOP, 1)
        workbox.Add(timeoutworkwatch, 0, wx.LEFT, 10)
        workseedvalbox.Add(workbox, 1, wx.EXPAND)

        seedbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, ''), wx.VERTICAL)

        timeoutseedbox = wx.BoxSizer(wx.HORIZONTAL)
        timeoutseedbox.Add(wx.StaticText(p, -1, ' '))
        self.timeoutseed = wx.CheckBox(p, -1, self.localize('timeoutseed'))
        timeoutseedbox.Add(self.timeoutseed)
        seedbox.Add(timeoutseedbox, 0, wx.TOP, -9)
        seedbox.Add(wx.StaticText(p, -1, self.localize('watch')), 0, wx.TOP | wx.BOTTOM, 3)
        timeoutseedwatch = wx.BoxSizer(wx.VERTICAL)
        self.timeoutseedup = wx.CheckBox(p, -1, self.localize('timeoutup'))
        timeoutseedwatch.Add(self.timeoutseedup)
        self.timeoutseedtrack = wx.CheckBox(p, -1, self.localize('timeouttrack'))
        timeoutseedwatch.Add(self.timeoutseedtrack, 0, wx.TOP, 1)
        seedbox.Add(timeoutseedwatch, 0, wx.LEFT, 10)
        workseedvalbox.Add(seedbox, 1, wx.EXPAND)

        timeoutvaluesbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('timeoutvalues')), wx.VERTICAL)

        # Timeout for down stream (minutes)
        download_box = wx.BoxSizer(wx.HORIZONTAL)
        download_box.Add(wx.StaticText(p, -1, self.localize('timeout_download')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.cb_ddownload = wx.TextCtrl(p, -1, '', (-1, -1), (31, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cb_ddownload.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cb_ddownload.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        download_box.Add(self.cb_ddownload, 0, wx.LEFT, 5)
        download_box.Add(wx.StaticText(p, -1, self.localize('l_day')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.cb_hdownload = wx.TextCtrl(p, -1, '', (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cb_hdownload.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cb_hdownload.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        download_box.Add(self.cb_hdownload, 0, wx.LEFT, 3)
        download_box.Add(wx.StaticText(p, -1, self.localize('l_hour')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.cb_mdownload = wx.TextCtrl(p, -1, '', (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cb_mdownload.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cb_mdownload.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        download_box.Add(self.cb_mdownload, 0, wx.LEFT, 3)
        download_box.Add(wx.StaticText(p, -1, self.localize('l_minute')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)

        timeoutvaluesbox.Add(download_box, 0, wx.TOP, 0)

        # Timeout for up stream (minutes)
        upload_box = wx.BoxSizer(wx.HORIZONTAL)
        upload_box.Add(wx.StaticText(p, -1, self.localize('timeout_upload')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.cb_dupload = wx.TextCtrl(p, -1, '', (-1, -1), (31, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cb_dupload.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cb_dupload.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        upload_box.Add(self.cb_dupload, 0, wx.LEFT, 5)
        upload_box.Add(wx.StaticText(p, -1, self.localize('l_day')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.cb_hupload = wx.TextCtrl(p, -1, '', (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cb_hupload.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cb_hupload.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        upload_box.Add(self.cb_hupload, 0, wx.LEFT, 3)
        upload_box.Add(wx.StaticText(p, -1, self.localize('l_hour')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.cb_mupload = wx.TextCtrl(p, -1, '', (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cb_mupload.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cb_mupload.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        upload_box.Add(self.cb_mupload, 0, wx.LEFT, 3)
        upload_box.Add(wx.StaticText(p, -1, self.localize('l_minute')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)

        timeoutvaluesbox.Add(upload_box, 0, wx.TOP, 3)

        # Timeout for contacting tracker (minutes)
        tracker_box = wx.BoxSizer(wx.HORIZONTAL)
        tracker_box.Add(wx.StaticText(p, -1, self.localize('timeout_tracker')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.cb_dtracker = wx.TextCtrl(p, -1, '', (-1, -1), (31, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cb_dtracker.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cb_dtracker.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        tracker_box.Add(self.cb_dtracker, 0, wx.LEFT, 5)
        tracker_box.Add(wx.StaticText(p, -1, self.localize('l_day')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.cb_htracker = wx.TextCtrl(p, -1, '', (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cb_htracker.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cb_htracker.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        tracker_box.Add(self.cb_htracker, 0, wx.LEFT, 3)
        tracker_box.Add(wx.StaticText(p, -1, self.localize('l_hour')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.cb_mtracker = wx.TextCtrl(p, -1, '', (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.cb_mtracker.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.cb_mtracker.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        tracker_box.Add(self.cb_mtracker, 0, wx.LEFT, 3)
        tracker_box.Add(wx.StaticText(p, -1, self.localize('l_minute')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)

        timeoutvaluesbox.Add(tracker_box, 0, wx.TOP, 3)

        workseedvalbox.Add(timeoutvaluesbox, 1, wx.EXPAND)

        timeoutsbox.Add(workseedvalbox, 0, wx.EXPAND | wx.TOP, 3)

        sizer.Add(timeoutsbox, 0, wx.EXPAND | wx.TOP, 0)

        p.SetSizer(sizer)
        p.SetAutoLayout(True)
        return p

    # Group Move
    ####################
    def makeMovePanel(self, parent):
        p = wx.Panel(parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)

        self.tempmoveswitch = wx.CheckBox(p, -1, self.localize('tempmoveswitch'))

        sizer.Add(self.tempmoveswitch, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.TOP, 6)

        movefolderbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, ''), wx.VERTICAL)

        self.movefolder = wx.TextCtrl(p, -1, '', size = (180, -1))
        buttonlabel = self.localize('browse')
        buttonwidth = self.GetTextExtent(buttonlabel)[0] + 12
        buttonlabel = buttonlabel.replace('&', '&&')
        movedirbrowsebtn = wx.Button(p, -1, buttonlabel, wx.Point(-1, -1), wx.Size(buttonwidth, self.utility.buttonheight))
        self.Bind(wx.EVT_BUTTON, self.onMoveDirBrowseDir, movedirbrowsebtn)
        movedirbox = wx.BoxSizer(wx.HORIZONTAL)
        movedirbox.Add(wx.StaticText(p, -1, self.localize('setmovefolder')), 0, wx.ALIGN_CENTER_VERTICAL)
        movedirbox.Add(self.movefolder, 1, wx.EXPAND | wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        movedirbox.Add(movedirbrowsebtn, 0, wx.ALIGN_CENTER_VERTICAL)

        movefolderbox.Add(movedirbox, 0, wx.EXPAND | wx.TOP, 3)

        sizer.Add(movefolderbox, 0, wx.EXPAND | wx.TOP, 0)

        p.SetSizer(sizer)
        p.SetAutoLayout(True)
        return p

    # Group Tracker
    ####################
    def makeTrackerPanel(self, parent):
        p = wx.Panel(parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)

        self.temptrackerswitch = wx.CheckBox(p, -1, self.localize('temptrackerswitch'))

        sizer.Add(self.temptrackerswitch, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.TOP, 6)

        trackerbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, ''), wx.VERTICAL)

        inttrackerbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('internaltracker')), wx.VERTICAL)

        self.extrainttracker = wx.CheckBox(p, -1, self.localize('extrainttracker'))        
        inttrackerbox.Add(self.extrainttracker, 0, wx.TOP, 3)

        inttrackerurlbox = wx.BoxSizer(wx.HORIZONTAL)
        inttrackerurlbox.Add(wx.StaticText(p, -1, self.localize('inttrackerurl')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.inttrackerurl = wx.TextCtrl(p, -1, '', wx.Point(-1, -1), wx.Size(-1, -1))        
        inttrackerurlbox.Add(self.inttrackerurl, 1, wx.EXPAND | wx.LEFT, 5)
        inttrackerbox.Add(inttrackerurlbox, 0, wx.EXPAND | wx.TOP, 3)

        trackerbox.Add(inttrackerbox, 0, wx.EXPAND | wx.TOP, 3)

        exttrackerbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('externaltracker')), wx.VERTICAL)

        self.exttracker = wx.CheckBox(p, -1, self.localize('exttrackersw'))        
        exttrackerbox.Add(self.exttracker, 0, wx.TOP, 3)

        exttrackerurlbox = wx.BoxSizer(wx.HORIZONTAL)
        exttrackerurlbox.Add(wx.StaticText(p, -1, self.localize('exttrackerurl')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.exttrackerurl = wx.TextCtrl(p, -1, '', wx.Point(-1, -1), wx.Size(-1, -1))        
        exttrackerurlbox.Add(self.exttrackerurl, 1, wx.EXPAND | wx.LEFT, 5)
        exttrackerbox.Add(exttrackerurlbox, 0, wx.EXPAND | wx.TOP, 3)

        self.checkinttrackwait = wx.CheckBox(p, -1, self.localize('checkinttrackwait'))        
        exttrackerbox.Add(self.checkinttrackwait, 0, wx.TOP, 3)

        trackerbox.Add(exttrackerbox, 0, wx.EXPAND | wx.TOP, 3)

        sizer.Add(trackerbox, 0, wx.EXPAND | wx.TOP, 0)

        p.SetSizer(sizer)
        p.SetAutoLayout(True)
        return p

    def onRightButtonText(self, event):
        pass

    def onBrowseDownDir(self, event):
        folderdialog = wx.DirDialog(self, self.localize('choosedefaultdownloc'), 
                                    style = wx.DD_DEFAULT_STYLE | wx.DD_NEW_DIR_BUTTON)
        if folderdialog.ShowModal() == wx.ID_OK:
            self.defaultdownloc.SetValue(folderdialog.GetPath())
        folderdialog.Destroy()

    # Sort list columns
    def onColLeftClick(self, event):
        col = event.m_col
        self.utility.sortcol = []
        if self.triggerbtn.GetValue():
            if col == self.lastsortingcoltrig:
                if self.sortdirtrig == 2:
                    index = 0
                    for key in self.editedtempbytrigrank:
                        self.editedtemplates[key].previndextrig = index
                        index += 1
                    self.sortdirtrig = 0
                else:
                    self.sortdirtrig += 1
            else:
                if self.lastsortingcoltrig == -1:
                    index = 0
                    for key in self.editedtempbytrigrank:
                        self.editedtemplates[key].previndextrig = index
                        index += 1
                self.sortdirtrig = 0
            self.lastsortingcoltrig = col

            if self.sortdirtrig == 2:
                index = 0
                for key in self.editedtempbytrigrank:
                    self.utility.sortcol.append(self.editedtemplates[key].previndextrig)
                    self.templist.SetItemData(index, index)
                    index += 1
            else:
                for index in xrange(self.templist.GetItemCount()):
                    self.utility.sortcol.append(self.templist.GetItem(index, col).GetText().lower())
                    self.templist.SetItemData(index, index)
            if self.sortdirtrig == 0 or self.sortdirtrig == 2:
                self.templist.SortItems(self.utility.sortList)
            else:
                self.templist.SortItems(self.utility.sortListReverse)
        else:
            if col == self.lastsortingcol:
                if self.sortdir == 2:
                    index = 0
                    for key in self.editedtempbyindex:
                        self.editedtemplates[key].previndex = index
                        index += 1
                    self.sortdir = 0
                else:
                    self.sortdir += 1
            else:
                if self.lastsortingcol == -1:
                    index = 0
                    for key in self.editedtempbyindex:
                        self.editedtemplates[key].previndex = index
                        index += 1
                self.sortdir = 0
            self.lastsortingcol = col

            if self.sortdir == 2:
                index = 0
                for key in self.editedtempbyindex:
                    self.utility.sortcol.append(self.editedtemplates[key].previndex)
                    self.templist.SetItemData(index, index)
                    index += 1
            else:
                for index in xrange(self.templist.GetItemCount()):
                    self.utility.sortcol.append(self.templist.GetItem(index, col).GetText().lower())
                    self.templist.SetItemData(index, index)
            if self.sortdir == 0 or self.sortdir == 2:
                self.templist.SortItems(self.utility.sortList)
            else:
                self.templist.SortItems(self.utility.sortListReverse)

        if self.selectedindex != -1:
            self.selectedindex = self.templist.GetNextItem(-1, wx.LIST_NEXT_ALL, wx.LIST_STATE_SELECTED)
        if self.triggerbtn.GetValue():
            self.editedtempbytrigrank = [self.templist.GetItemText(index) for index in xrange(self.templist.GetItemCount())]
        else:
            self.editedtempbyindex = [self.templist.GetItemText(index) for index in xrange(self.templist.GetItemCount())]

    def onMouseWheelNotebook(self, event):
        if self.triggerbtn.GetValue():
            return
        nextpage = self.notebook.GetSelection()
        if event.GetWheelRotation() * self.utility.mousewheelontab > 0:
            if nextpage < self.maxpage:
                nextpage += 1
            else:
                nextpage = 0
        else:
            if nextpage > 0:
                nextpage -= 1
            else:
                nextpage = self.maxpage
        self.notebook.SetSelection(nextpage)

    def onKeyInList(self, event):
        if not self.templist.GetItemCount():
            return
        keycode = event.GetKeyCode()
        if keycode == wx.WXK_UP:
            self.onListLeftClick(index = max(0, self.selectedindex - 1))
        elif keycode == wx.WXK_DOWN:
            self.onListLeftClick(index = min(self.templist.GetItemCount() - 1, self.selectedindex + 1))
        elif keycode == wx.WXK_PRIOR:
            self.onListLeftClick(index = max(0, self.selectedindex - self.templist.GetCountPerPage()))
        elif keycode == wx.WXK_NEXT:
            self.onListLeftClick(index = min(self.templist.GetItemCount() - 1, self.selectedindex + self.templist.GetCountPerPage()))
        elif keycode == wx.WXK_HOME:
            self.onListLeftClick(index = 0)
        elif keycode == wx.WXK_END:
            self.onListLeftClick(index = self.templist.GetItemCount() - 1)
        elif event.ControlDown() and keycode == wx.WXK_NUMPAD_DECIMAL:
            if self.triggerbtn.GetValue():
                self.sortdirtrig = 2
            else:
                self.sortdir = 2
            self.parent.window.displayStatusTextTemp(self.localize('listsortingstatusunsorted'))
        else:
            event.Skip()

    def onListLeftClick(self, event = None, index = None):
        if index is None:
            index = self.templist.HitTest(wx.Point(event.GetX(), event.GetY()))[0]
        if index == self.selectedindex:
            if event is not None:
                event.Skip()
            return
        if self.currentlyedited is not None:
            if not self.readTemplateMask():
                return
            if self.triggerbtn.GetValue():
                if self.editedtemplates[self.currentlyedited].isTriggerRuleActive():
                    self.templist.SetItemTextColour(self.selectedindex, wx.Colour(0, 0, 0))
                else:
                    self.templist.SetItemTextColour(self.selectedindex, wx.Colour(255, 0, 0))
        if index < 0:
            if event is not None:
                event.Skip()
            self.tempdesc.Disable()
            self.temphidden.Disable()
            self.templinkable.Disable()
            self.tempsticky.Disable()
            self.parampanel.Disable()
            self.triggerpanel.Disable()
            self.currentlyedited = None
            self.selectedindex = -1
            self.clearTemplateMask()
        else:
            self.selectedindex = index
            self.templist.SetFocus()
            self.templist.Select(self.selectedindex)
            self.templist.Focus(self.selectedindex)
            self.currentlyedited = self.templist.GetItem(self.selectedindex, 0).GetText()
            self.tempdesc.Enable()
            self.temphidden.Enable()
            self.templinkable.Enable()
            self.tempsticky.Enable()
            self.parampanel.Enable()
            self.fillTemplateMask(self.editedtemplates[self.currentlyedited])

    def clearTemplateMask(self):
        self.tempdesc.SetValue('')
        self.temphidden.SetValue(False)
        self.templinkable.SetValue(False)
        self.tempsticky.SetValue(False)
        self.notebook.SetPageText(0, self.localize('templabel'))
        self.templabelswitch.SetValue(False)
        self.shortlabel.SetValue('')
        self.notebook.SetPageText(1, self.localize('tempdownloadsetting'))
        self.tempdownloadswitch.SetValue(False)
        self.downloadrate.SetValue('0')
        self.prioritizedown.SetValue(False)
        self.notebook.SetPageText(2, self.localize('tempuploadsetting'))
        self.tempuploadswitch.SetValue(False)
        self.maxupload.setValue(str(self.utility.minuploads))
        self.uploadrate.SetValue('0')
        self.prioritizeup.SetValue(False)
        self.notebook.SetPageText(3, self.localize('tempseedingsetting'))
        self.tempseedingswitch.SetValue(False)
        self.rb[0].SetValue(True)
        self.cbdtime.SetValue('0')
        self.cbhtime.SetValue('0')
        self.cbmtime.SetValue('0')
        self.cbratio.SetValue('0')
        self.uploadtillcopycomplete.SetValue(False)
        self.notebook.SetPageText(4, self.localize('temptimeout'))
        self.temptimeoutswitch.SetValue(False)
        self.timeoutswitch.SetValue(False)
        self.timeoutaction.SetSelection(0)
        self.timeoutwork.SetValue(False)
        self.timeoutworkdown.SetValue(False)
        self.timeoutworktrack.SetValue(False)
        self.timeoutseed.SetValue(False)
        self.timeoutseedup.SetValue(False)
        self.timeoutseedtrack.SetValue(False)
        self.cb_dtracker.SetValue('0')
        self.cb_htracker.SetValue('0')
        self.cb_mtracker.SetValue('0')
        self.cb_ddownload.SetValue('0')
        self.cb_hdownload.SetValue('0')
        self.cb_mdownload.SetValue('0')
        self.cb_dupload.SetValue('0')
        self.cb_hupload.SetValue('0')
        self.cb_mupload.SetValue('0')
        self.notebook.SetPageText(5, self.localize('tempmove'))
        self.tempmoveswitch.SetValue(False)
        self.movefolder.SetValue('')
        self.notebook.SetPageText(6, self.localize('temptracker'))
        self.temptrackerswitch.SetValue(False)
        self.exttracker.SetValue(False)
        self.exttrackerurl.SetValue('')
        self.checkinttrackwait.SetValue(False)
        self.extrainttracker.SetValue(False)
        self.inttrackerurl.SetValue('')
        self.defaultdownlocswitch.SetValue(False)
        self.defaultdownloc.SetValue('')
        self.ruleactive.SetValue(False)
        self.ruletracker.SetValue('')
        self.ruletrackerbtn.SetValue(False)
        self.ruletorrent.SetValue('')
        self.ruletorrentbtn.SetValue(False)
        self.ruletorrentfile.SetValue('')
        self.ruletorrentfilebtn.SetValue(False)
        self.rulereceived.SetValue('')
        self.rulereceivedbtn.SetValue(False)
        self.rulesizeg.SetValue('')
        self.rulesizegunit.SetSelection(0)
        self.rulesizel.SetValue('')
        self.rulesizelunit.SetSelection(0)

    def fillTemplateMask(self, editedtemplate):
        if self.currentlyedited == self.templatedefault:
            self.templinkable.Disable()
            self.templabelswitch.Disable()
            self.tempdownloadswitch.Disable()
            self.tempuploadswitch.Disable()
            self.tempseedingswitch.Disable()
            self.temptimeoutswitch.Disable()
            self.tempmoveswitch.Disable()
            self.temptrackerswitch.Disable()
            self.dirboxpanel.Disable()
            self.browsebtn.Hide()
            self.dirbox.Layout()
            self.triggerpanel.Disable()
        elif not self.triggerpanel.IsEnabled():
            self.templinkable.Enable()
            self.templabelswitch.Enable()
            self.tempdownloadswitch.Enable()
            self.tempuploadswitch.Enable()
            self.tempseedingswitch.Enable()
            self.temptimeoutswitch.Enable()
            self.tempmoveswitch.Enable()
            self.temptrackerswitch.Enable()
            self.dirboxpanel.Enable()
            self.browsebtn.Show()
            self.dirbox.Layout()
            self.triggerpanel.Enable()

        self.tempdesc.SetValue(editedtemplate.description)
        self.temphidden.SetValue(editedtemplate.hidden)
        self.templinkable.SetValue(editedtemplate.linkable)
        self.tempsticky.SetValue(editedtemplate.sticky)
        if editedtemplate.templabelswitch:
            self.notebook.SetPageText(0, self.localize('chtemplabel'))
        else:
            self.notebook.SetPageText(0, self.localize('templabel'))
        self.templabelswitch.SetValue(editedtemplate.templabelswitch)
        self.shortlabel.SetValue(editedtemplate.shortlabel)
        if editedtemplate.tempdownloadswitch:
            self.notebook.SetPageText(1, self.localize('chtempdownloadsetting'))
        else:
            self.notebook.SetPageText(1, self.localize('tempdownloadsetting'))
        self.tempdownloadswitch.SetValue(editedtemplate.tempdownloadswitch)
        self.downloadrate.SetValue(str(editedtemplate.maxdownrate))
        self.prioritizedown.SetValue(editedtemplate.prioritizedown)
        if editedtemplate.tempuploadswitch:
            self.notebook.SetPageText(2, self.localize('chtempuploadsetting'))
        else:
            self.notebook.SetPageText(2, self.localize('tempuploadsetting'))
        self.tempuploadswitch.SetValue(editedtemplate.tempuploadswitch)
        self.maxupload.setValue(str(editedtemplate.maxupload))
        self.uploadrate.SetValue(str(editedtemplate.maxuprate))
        self.prioritizeup.SetValue(editedtemplate.prioritizeup)
        if editedtemplate.tempseedingswitch:
            self.notebook.SetPageText(3, self.localize('chtempseedingsetting'))
        else:
            self.notebook.SetPageText(3, self.localize('tempseedingsetting'))
        self.tempseedingswitch.SetValue(editedtemplate.tempseedingswitch)
        self.rb[editedtemplate.uploadoption].SetValue(True)
        dtime, mtime = divmod(60 * editedtemplate.uploadtimeh + editedtemplate.uploadtimem, 1440)
        htime, mtime = divmod(mtime, 60)
        self.cbdtime.SetValue(str(dtime))
        self.cbhtime.SetValue(str(htime))
        self.cbmtime.SetValue(str(mtime))
        self.cbratio.SetValue(str(editedtemplate.uploadratio))
        self.uploadtillcopycomplete.SetValue(editedtemplate.uploadtillcopycomplete)
        if editedtemplate.temptimeoutswitch:
            self.notebook.SetPageText(4, self.localize('chtemptimeout'))
        else:
            self.notebook.SetPageText(4, self.localize('temptimeout'))
        self.temptimeoutswitch.SetValue(editedtemplate.temptimeoutswitch)
        self.timeoutswitch.SetValue(editedtemplate.timeoutswitch)
        self.timeoutaction.SetSelection(editedtemplate.timeoutaction)
        self.timeoutwork.SetValue(editedtemplate.timeoutwork)
        self.timeoutworkdown.SetValue(editedtemplate.timeoutworkdown)
        self.timeoutworktrack.SetValue(editedtemplate.timeoutworktrack)
        self.timeoutseed.SetValue(editedtemplate.timeoutseed)
        self.timeoutseedup.SetValue(editedtemplate.timeoutseedup)
        self.timeoutseedtrack.SetValue(editedtemplate.timeoutseedtrack)
        dtime, mtime = divmod(editedtemplate.timeouttracker, 1440)
        htime, mtime = divmod(mtime, 60)
        self.cb_dtracker.SetValue(str(dtime))
        self.cb_htracker.SetValue(str(htime))
        self.cb_mtracker.SetValue(str(mtime))
        dtime, mtime = divmod(editedtemplate.timeoutdownload, 1440)
        htime, mtime = divmod(mtime, 60)
        self.cb_ddownload.SetValue(str(dtime))
        self.cb_hdownload.SetValue(str(htime))
        self.cb_mdownload.SetValue(str(mtime))
        dtime, mtime = divmod(editedtemplate.timeoutupload, 1440)
        htime, mtime = divmod(mtime, 60)
        self.cb_dupload.SetValue(str(dtime))
        self.cb_hupload.SetValue(str(htime))
        self.cb_mupload.SetValue(str(mtime))
        if editedtemplate.tempmoveswitch:
            self.notebook.SetPageText(5, self.localize('chtempmove'))
        else:
            self.notebook.SetPageText(5, self.localize('tempmove'))
        self.tempmoveswitch.SetValue(editedtemplate.tempmoveswitch)
        self.movefolder.SetValue(editedtemplate.movefolder)
        if editedtemplate.temptrackerswitch:
            self.notebook.SetPageText(6, self.localize('chtemptracker'))
        else:
            self.notebook.SetPageText(6, self.localize('temptracker'))
        self.temptrackerswitch.SetValue(editedtemplate.temptrackerswitch)
        self.exttracker.SetValue(editedtemplate.exttracker)
        self.exttrackerurl.SetValue(editedtemplate.exttrackerurl)
        self.checkinttrackwait.SetValue(editedtemplate.checkinttrackwait)
        self.extrainttracker.SetValue(editedtemplate.extrainttracker)
        self.inttrackerurl.SetValue(editedtemplate.inttrackerurl)
        if self.currentlyedited == self.templatedefault:
            self.defaultdownlocswitch.SetValue(True)
            self.defaultdownloc.SetValue(self.abcparams['defaultfolder'])
        else:
            self.defaultdownlocswitch.SetValue(editedtemplate.defaultdownlocswitch)
            self.defaultdownloc.SetValue(editedtemplate.defaultdownloc)
        self.ruleactive.SetValue(editedtemplate.ruleactive)
        self.ruletracker.SetValue(editedtemplate.ruletracker)
        self.ruletrackerbtn.SetValue(editedtemplate.ruletrackersw)
        self.ruletorrent.SetValue(editedtemplate.ruletorrent)
        self.ruletorrentbtn.SetValue(editedtemplate.ruletorrentsw)
        self.ruletorrentfile.SetValue(editedtemplate.ruletorrentfile)
        self.ruletorrentfilebtn.SetValue(editedtemplate.ruletorrentfilesw)
        self.rulereceived.SetValue(editedtemplate.rulereceived)
        self.rulereceivedbtn.SetValue(editedtemplate.rulereceivedsw)
        self.displayRuleSize(editedtemplate.rulesizeg, self.rulesizeg, self.rulesizegunit)
        self.displayRuleSize(editedtemplate.rulesizel, self.rulesizel, self.rulesizelunit)

    def displayRuleSize(self, rs, ws, wu):
        if rs:
            rs = int(rs)
            unit = 3
            while rs and unit > 0:
                d = rs >> 10
                m = rs - (d << 10)
                if m:
                    if m in [256, 512, 768]:
                        rs = d + m / 1024.
                        unit -= 1
                    break
                rs = d
                unit -= 1
            ws.SetValue(str(rs))
            wu.SetSelection(unit)
        else:
            ws.SetValue('')
            wu.SetSelection(0)

    def readTemplateMask(self):
        errortype = False
        # Check upload rate is integer
        try:
            upload_rate = int(self.uploadrate.GetValue())
        except:
            errortype = True
        # Check if < minuprate and != 0
        if errortype or upload_rate < self.utility.minuprate and upload_rate != 0:
            dlg = wx.MessageDialog(self, self.localize('uploadrateminwarningauto') % self.utility.minuprate,
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        # Check download rate is integer
        try:
            download_rate = int(self.downloadrate.GetValue())
        except:
            errortype = True
        # Check if < mindownrate and != 0
        if errortype or download_rate < self.utility.mindownrate and download_rate != 0:
            dlg = wx.MessageDialog(self, self.localize('downloadrateminwarning') % self.utility.mindownrate, self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        curedited = self.editedtemplates[self.currentlyedited]

        # Check if move folder is a valid Windows name
        tormovefolder = self.movefolder.GetValue()
        if self.tempmoveswitch.GetValue():
            if sys.platform == 'win32' and tormovefolder and tormovefolder != curedited.movefolder:
                # We erase the final '\' except for a path like 'X:\'
                if tormovefolder and tormovefolder[-1] == '\\' and (len(tormovefolder) < 2 or tormovefolder[-2] != ':'):
                    tormovefolder = tormovefolder[:-1]
                tormovefolder = tormovefolder.rstrip(whitespace + '.')
                if not self.utility.checkWinPath(self, tormovefolder):
                    return False

        if self.currentlyedited != self.templatedefault:
            # Check if default download folder is non empty
            if self.defaultdownlocswitch.GetValue() and self.defaultdownloc.GetValue() == '':
                dlg = wx.MessageDialog(self, self.localize('nodefaultdowndirwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return False
            # Check if default download folder is a valid Windows name
            defdestfolder = self.defaultdownloc.GetValue()
            if sys.platform == 'win32' and (self.defaultdownlocswitch.GetValue() and not curedited.defaultdownlocswitch 
                                            or defdestfolder != curedited.defaultdownloc):
                # We erase the final '\' except for a path like 'X:\'
                if defdestfolder and defdestfolder[-1] == '\\' and (len(defdestfolder) < 2 or defdestfolder[-2] != ':'):
                    defdestfolder = defdestfolder[:-1]
                defdestfolder = defdestfolder.rstrip(whitespace + '.')
                if not self.utility.checkWinPath(self, defdestfolder):
                    return False

        # Check size trigger
        rsg = self.rulesizeg.GetValue()
        if rsg:
            try:
                rsgval = float(rsg)
            except:
                errortype = True
            if errortype or rsgval < 0:
                dlg = wx.MessageDialog(self, self.localize('tempsizerulewarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return False
            rsgval = int(rsgval * 1024 ** (3 - self.rulesizegunit.GetSelection()))
        rsl = self.rulesizel.GetValue()
        if rsl:
            try:
                rslval = float(rsl)
            except:
                errortype = True
            if errortype or rslval < 0:
                dlg = wx.MessageDialog(self, self.localize('tempsizerulewarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return False
            rslval = int(rslval * 1024 ** (3 - self.rulesizelunit.GetSelection()))
        if rsg and rsl and rsgval > rslval:
            dlg = wx.MessageDialog(self, self.localize('tempsizerulesmismatch'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        curedited.description = self.tempdesc.GetValue()
        curedited.hidden = int(self.temphidden.GetValue())
        curedited.linkable = int(self.templinkable.GetValue())
        curedited.sticky = int(self.tempsticky.GetValue())
        curedited.templabelswitch = int(self.templabelswitch.GetValue())
        curedited.shortlabel = self.shortlabel.GetValue()
        curedited.tempdownloadswitch = int(self.tempdownloadswitch.GetValue())
        curedited.maxdownrate = download_rate
        curedited.prioritizedown = int(self.prioritizedown.GetValue())
        curedited.tempuploadswitch = int(self.tempuploadswitch.GetValue())
        curedited.maxupload = int(self.maxupload.getValue())
        curedited.maxuprate = upload_rate
        curedited.prioritizeup = int(self.prioritizeup.GetValue())
        curedited.tempseedingswitch = int(self.tempseedingswitch.GetValue())
        for i in xrange(4):
            if self.rb[i].GetValue():
                curedited.uploadoption = i
                break
        dtime = self.cbdtime.GetValue()
        htime = self.cbhtime.GetValue()
        mtime = self.cbmtime.GetValue()
        if not dtime:
            dtime = '0'
        if not htime:
            htime = '0'
        if not mtime:
            mtime = '0'
        dtime_int, mtime_int = divmod(1440 * int(dtime) + 60 * int(htime) + int(mtime), 1440)
        htime_int, mtime_int = divmod(mtime_int, 60)
        self.cbdtime.SetValue(str(dtime_int))
        self.cbhtime.SetValue(str(htime_int))
        self.cbmtime.SetValue(str(mtime_int))
        curedited.uploadtimeh = 24 * dtime_int + htime_int
        curedited.uploadtimem = mtime_int
        ratio = self.cbratio.GetValue()
        if not ratio:
            ratio = '0'
        curedited.uploadratio = int(ratio)
        curedited.uploadtillcopycomplete = int(self.uploadtillcopycomplete.GetValue())
        curedited.temptimeoutswitch = int(self.temptimeoutswitch.GetValue())
        curedited.timeoutswitch = int(self.timeoutswitch.GetValue())
        curedited.timeoutaction = self.timeoutaction.GetSelection()
        curedited.timeoutwork = int(self.timeoutwork.GetValue())
        curedited.timeoutworkdown = int(self.timeoutworkdown.GetValue())
        curedited.timeoutworktrack = int(self.timeoutworktrack.GetValue())
        curedited.timeoutseed = int(self.timeoutseed.GetValue())
        curedited.timeoutseedup = int(self.timeoutseedup.GetValue())
        curedited.timeoutseedtrack = int(self.timeoutseedtrack.GetValue())
        dtime = self.cb_dtracker.GetValue()
        htime = self.cb_htracker.GetValue()
        mtime = self.cb_mtracker.GetValue()
        if not dtime:
            dtime = '0'
        if not htime:
            htime = '0'
        if not mtime:
            mtime = '0'
        mtimetotal_int = 1440 * int(dtime) + 60 * int(htime) + int(mtime)
        dtime_int, mtime_int = divmod(mtimetotal_int, 1440)
        htime_int, mtime_int = divmod(mtime_int, 60)
        self.cb_dtracker.SetValue(str(dtime_int))
        self.cb_htracker.SetValue(str(htime_int))
        self.cb_mtracker.SetValue(str(mtime_int))
        curedited.timeouttracker = mtimetotal_int
        dtime = self.cb_ddownload.GetValue()
        htime = self.cb_hdownload.GetValue()
        mtime = self.cb_mdownload.GetValue()
        if not dtime:
            dtime = '0'
        if not htime:
            htime = '0'
        if not mtime:
            mtime = '0'
        mtimetotal_int = 1440 * int(dtime) + 60 * int(htime) + int(mtime)
        dtime_int, mtime_int = divmod(mtimetotal_int, 1440)
        htime_int, mtime_int = divmod(mtime_int, 60)
        self.cb_ddownload.SetValue(str(dtime_int))
        self.cb_hdownload.SetValue(str(htime_int))
        self.cb_mdownload.SetValue(str(mtime_int))
        curedited.timeoutdownload = mtimetotal_int
        dtime = self.cb_dupload.GetValue()
        htime = self.cb_hupload.GetValue()
        mtime = self.cb_mupload.GetValue()
        if not dtime:
            dtime = '0'
        if not htime:
            htime = '0'
        if not mtime:
            mtime = '0'
        mtimetotal_int = 1440 * int(dtime) + 60 * int(htime) + int(mtime)
        dtime_int, mtime_int = divmod(mtimetotal_int, 1440)
        htime_int, mtime_int = divmod(mtime_int, 60)
        self.cb_dupload.SetValue(str(dtime_int))
        self.cb_hupload.SetValue(str(htime_int))
        self.cb_mupload.SetValue(str(mtime_int))
        curedited.timeoutupload = mtimetotal_int
        curedited.tempmoveswitch = int(self.tempmoveswitch.GetValue())
        curedited.movefolder = tormovefolder
        curedited.temptrackerswitch = int(self.temptrackerswitch.GetValue())
        curedited.exttracker = int(self.exttracker.GetValue())
        curedited.exttrackerurl = self.exttrackerurl.GetValue()
        curedited.checkinttrackwait = int(self.checkinttrackwait.GetValue())
        curedited.extrainttracker = int(self.extrainttracker.GetValue())
        curedited.inttrackerurl = self.inttrackerurl.GetValue()
        if self.currentlyedited != self.templatedefault:
            curedited.defaultdownlocswitch = int(self.defaultdownlocswitch.GetValue())
            curedited.defaultdownloc = defdestfolder
        curedited.ruleactive = int(self.ruleactive.GetValue())
        curedited.ruletracker = self.ruletracker.GetValue()
        curedited.ruletrackersw = int(self.ruletrackerbtn.GetValue())
        curedited.ruletorrent = self.ruletorrent.GetValue()
        curedited.ruletorrentsw = int(self.ruletorrentbtn.GetValue())
        curedited.ruletorrentfile = self.ruletorrentfile.GetValue()
        curedited.ruletorrentfilesw = int(self.ruletorrentfilebtn.GetValue())
        curedited.rulereceived = self.rulereceived.GetValue()
        curedited.rulereceivedsw = int(self.rulereceivedbtn.GetValue())
        if rsg:
            curedited.rulesizeg = str(rsgval)
        else:
            curedited.rulesizeg = ''
        if rsl:
            curedited.rulesizel = str(rslval)
        else:
            curedited.rulesizel = ''
        return True

    def onMoveDirBrowseDir(self, event):
        foldername = wx.DirDialog(self, self.localize('choosemovefolder'), 
                                 style = wx.DD_DEFAULT_STYLE | wx.DD_NEW_DIR_BUTTON)
        if foldername.ShowModal() == wx.ID_OK:
            self.movefolder.SetValue(foldername.GetPath())
        foldername.Destroy()

    def onTempLabelSwitch(self, event):
        event.Skip()
        if event.IsChecked():
            self.notebook.SetPageText(0, self.localize('chtemplabel'))
        else:
            self.notebook.SetPageText(0, self.localize('templabel'))

    def onTempDownloadSwitch(self, event):
        event.Skip()
        if event.IsChecked():
            self.notebook.SetPageText(1, self.localize('chtempdownloadsetting'))
        else:
            self.notebook.SetPageText(1, self.localize('tempdownloadsetting'))

    def onTempUploadSwitch(self, event):
        event.Skip()
        if event.IsChecked():
            self.notebook.SetPageText(2, self.localize('chtempuploadsetting'))
        else:
            self.notebook.SetPageText(2, self.localize('tempuploadsetting'))

    def onTempSeedingSwitch(self, event):
        event.Skip()
        if event.IsChecked():
            self.notebook.SetPageText(3, self.localize('chtempseedingsetting'))
        else:
            self.notebook.SetPageText(3, self.localize('tempseedingsetting'))

    def onTempTimeoutSwitch(self, event):
        event.Skip()
        if event.IsChecked():
            self.notebook.SetPageText(4, self.localize('chtemptimeout'))
        else:
            self.notebook.SetPageText(4, self.localize('temptimeout'))

    def onTempMoveSwitch(self, event):
        event.Skip()
        if event.IsChecked():
            self.notebook.SetPageText(5, self.localize('chtempmove'))
        else:
            self.notebook.SetPageText(5, self.localize('tempmove'))

    def onTempTrackerSwitch(self, event):
        event.Skip()
        if event.IsChecked():
            self.notebook.SetPageText(6, self.localize('chtemptracker'))
        else:
            self.notebook.SetPageText(6, self.localize('temptracker'))

    def onCancel(self, event = None):
        self.EndModal(wx.ID_CANCEL)

    def moveUpDownInList(self, index, direction):
        keytomove = self.templist.GetItemText(index)
        colour = self.templist.GetItemTextColour(index)
        if self.triggerbtn.GetValue():
            self.editedtempbytrigrank.insert(index + direction, self.editedtempbytrigrank.pop(index))
        else:
            self.editedtempbyindex.insert(index + direction, self.editedtempbyindex.pop(index))
        keytoflip = self.templist.GetItemText(index + direction)
        colourtoflip =  self.templist.GetItemTextColour(index + direction)
        if colourtoflip == wx.NullColour:
            colourtoflip = (0, 0, 0)
        self.templist.SetItemTextColour(index, colourtoflip)
        self.templist.SetStringItem(index, 0, keytoflip)
        self.templist.SetStringItem(index, 1, self.editedtemplates[keytoflip].shortlabel)
        index += direction
        self.templist.SetItemTextColour(index, colour)
        self.templist.SetStringItem(index, 0, keytomove)
        self.templist.SetStringItem(index, 1, self.editedtemplates[keytomove].shortlabel)
        self.selectedindex = index

    def onUpInList(self, event):
        if self.selectedindex != -1:
            if self.selectedindex > 0:
                self.moveUpDownInList(self.selectedindex, -1)
                self.templist.Select(self.selectedindex)
            self.templist.Focus(self.selectedindex)
        self.templist.SetFocus()

    def onDownInList(self, event):
        if self.selectedindex != -1:
            if self.selectedindex < len(self.editedtemplates) - 1:
                self.moveUpDownInList(self.selectedindex, 1)
                self.templist.Select(self.selectedindex)
            self.templist.Focus(self.selectedindex)
        self.templist.SetFocus()

    def onAddTemplate(self, event):
        dialog = wx.TextEntryDialog(self,
                                    self.localize('entertempname'),
                                    self.localize('entertempname_short'))
        wx.Dialog.SetWindowStyle(dialog, wx.CAPTION | wx.CLOSE_BOX | wx.TAB_TRAVERSAL | wx.RESIZE_BORDER)
        dialog.SetSize((int(self.abcparams['templatenamew']), -1))
        height = dialog.GetSize()[1]
        dialog.SetMinSize((300, height))
        dialog.SetMaxSize((-1, height))
        dialog.Centre()
        result = dialog.ShowModal()
        name = dialog.GetValue().translate({124: None, 1: None})
        self.abcparams['templatenamew'] = str(dialog.GetSizeTuple()[0])
        dialog.Destroy()
        if result != wx.ID_OK or name == '':
            return

        if name in self.editedtemplates:
            dlg = wx.MessageDialog(self, self.localize('errortempexists'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return

        if name in self.bufferedmodif:
            del self.bufferedmodif[name]

        index = self.templist.GetItemCount()
        self.tempmanager.createTemplate(self.editedtemplates, self.editedtempbyindex, self.editedtempbytrigrank, name, self.templatedefault)
        self.templist.InsertStringItem(index, name)
        self.templist.SetStringItem(index, 1, self.editedtemplates[name].shortlabel)
        self.templist.SetFocus()

    def onCopyTemplate(self, event):
        if self.currentlyedited == None:
            return
        newname = self.currentlyedited + '_001'
        i = 1
        while newname in self.editedtemplates:
            i += 1
            if i == 1000:
                break
            newname = newname[:-3] + ('%03u' % i)
        if i == 1000:
            # Can't find an automatic new name ; ask user for one
            dialog = wx.TextEntryDialog(self,
                                        self.localize('entertempcopyname'),
                                        self.localize('entertempcopyname_short'))
            wx.Dialog.SetWindowStyle(dialog, wx.CAPTION | wx.CLOSE_BOX | wx.TAB_TRAVERSAL | wx.RESIZE_BORDER)
            dialog.SetSize((int(self.abcparams['templatenamew']), -1))
            height = dialog.GetSize()[1]
            dialog.SetMinSize((300, height))
            dialog.SetMaxSize((-1, height))
            dialog.SetValue(self.currentlyedited)
            dialog.Centre()
            result = dialog.ShowModal()
            newname = dialog.GetValue().translate({124: None, 1: None})
            self.abcparams['templatenamew'] = str(dialog.GetSizeTuple()[0])
            dialog.Destroy()

            if newname in self.editedtemplates:
                dlg = wx.MessageDialog(self, self.localize('errortempexists'),
                                       self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return

        if not self.readTemplateMask():
            return

        if newname in self.bufferedmodif:
            del self.bufferedmodif[newname]

        index = self.templist.GetItemCount()
        self.tempmanager.createTemplate(self.editedtemplates, self.editedtempbyindex, self.editedtempbytrigrank, newname, self.currentlyedited)
        self.templist.InsertStringItem(index, newname)
        self.templist.SetStringItem(index, 1, self.editedtemplates[newname].shortlabel)
        self.templist.SetFocus()

    def onRenameTemplate(self, event):
        if self.currentlyedited == None:
            return
        dialog = wx.TextEntryDialog(self,
                                    self.localize('entertempnewname'),
                                    self.localize('entertempnewname_short'))
        wx.Dialog.SetWindowStyle(dialog, wx.CAPTION | wx.CLOSE_BOX | wx.TAB_TRAVERSAL | wx.RESIZE_BORDER)
        dialog.SetSize((int(self.abcparams['templatenamew']), -1))
        height = dialog.GetSize()[1]
        dialog.SetMinSize((300, height))
        dialog.SetMaxSize((-1, height))
        dialog.Centre()
        dialog.SetValue(self.currentlyedited)
        result = dialog.ShowModal()
        newname = dialog.GetValue().translate({124: None, 1: None})
        self.abcparams['templatenamew'] = str(dialog.GetSizeTuple()[0])
        dialog.Destroy()
        if result != wx.ID_OK or newname == '' or newname == self.currentlyedited:
            return

        if newname in self.editedtemplates:
            dlg = wx.MessageDialog(self, self.localize('errortempexists'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return

        self.editedtemplates[newname] = self.editedtemplates[self.currentlyedited]
        del self.editedtemplates[self.currentlyedited]

        if self.triggerbtn.GetValue():
            self.editedtempbyindex[self.editedtempbyindex.index(self.currentlyedited)] = newname
            self.editedtempbytrigrank[self.selectedindex] = newname
        else:
            self.editedtempbyindex[self.selectedindex] = newname
            self.editedtempbytrigrank[self.editedtempbytrigrank.index(self.currentlyedited)] = newname

        self.templist.SetItemText(self.selectedindex, newname)

        # Remember renaming
        if newname in self.bufferedmodif:
            del self.bufferedmodif[newname]
        for tempname in self.bufferedmodif:
            if self.bufferedmodif[tempname] == self.currentlyedited:
                originaltempname = tempname
                break
        else:
            originaltempname = self.currentlyedited
        if originaltempname in self.templates:
            self.bufferedmodif[originaltempname] = newname

        if self.currentlyedited == self.templatedefault:
            self.templatedefault = newname
        self.currentlyedited = newname
        self.templist.SetFocus()

    def onDeleteTemplate(self, event):
        if self.currentlyedited == None:
            return
        if self.currentlyedited == self.templatedefault:
            dlg = wx.MessageDialog(self, self.localize('nodeletedeftemp'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return

        dlg = wx.MessageDialog(self, self.localize('confirmdeletetemplate') + self.currentlyedited,
                               self.localize('abcokcwarning'), wx.ICON_WARNING | wx.YES_NO)
        result = dlg.ShowModal()
        dlg.Destroy()
        if result == wx.ID_NO:            
            return

        del self.editedtemplates[self.currentlyedited]

        # Remember deleting
        for tempname in self.bufferedmodif:
            if self.bufferedmodif[tempname] == self.currentlyedited:
                originaltempname = tempname
                break
        else:
            originaltempname = self.currentlyedited
        if originaltempname in self.templates:
            self.bufferedmodif[originaltempname] = None

        self.templist.DeleteItem(self.selectedindex)
        self.tempdesc.Disable()
        self.temphidden.Disable()
        self.templinkable.Disable()
        self.tempsticky.Disable()
        self.parampanel.Disable()
        self.triggerpanel.Disable()
        self.editedtempbyindex.remove(self.currentlyedited)
        self.editedtempbytrigrank.remove(self.currentlyedited)
        self.currentlyedited = None
        self.selectedindex = -1
        self.clearTemplateMask()
        self.templist.SetFocus()

    def onTrigger(self, event):
        self.templist.DeleteAllItems()
        index = 0
        if self.triggerbtn.GetValue():
            self.parampanel.Hide()
            self.triggerpanel.Show()
            self.templistbx.SetLabel(self.localize('templisttrig'))
            for key in self.editedtempbytrigrank:
                self.templist.InsertStringItem(index, "")
                self.templist.SetStringItem(index, 0, key)
                self.templist.SetStringItem(index, 1, self.editedtemplates[key].shortlabel)
                if not self.editedtemplates[key].isTriggerRuleActive():
                    self.templist.SetItemTextColour(index, wx.Colour(255, 0, 0))
                index += 1
            if self.selectedindex != -1:
                self.selectedindex = self.editedtempbytrigrank.index(self.currentlyedited)
        else:
            self.triggerpanel.Hide()
            self.parampanel.Show()
            self.templistbx.SetLabel(self.localize('templist'))
            for key in self.editedtempbyindex:
                self.templist.InsertStringItem(index, "")
                self.templist.SetStringItem(index, 0, key)
                self.templist.SetStringItem(index, 1, self.editedtemplates[key].shortlabel)
                if key == self.templatedefault:
                    self.templist.SetItemTextColour(index, wx.Colour(255, 0, 0))
                index += 1
            if self.selectedindex != -1:
                self.selectedindex = self.editedtempbyindex.index(self.currentlyedited)
        if self.selectedindex != -1:
            self.templist.Select(self.selectedindex)
            self.templist.Focus(self.selectedindex)
        self.templist.SetFocus()

    def onUpdateLabel(self, event):
        event.Skip()
        if self.selectedindex >= 0:
            self.templist.SetStringItem(self.selectedindex, 1, self.shortlabel.GetValue())
        if self.currentlyedited is not None:
            self.editedtemplates[self.currentlyedited].shortlabel = self.shortlabel.GetValue()

    def onApply(self, event):
        # Save currently edited
        if self.currentlyedited is not None:
            if self.readTemplateMask():
                temp = self.editedtemplates[self.currentlyedited]
                self.displayRuleSize(temp.rulesizeg, self.rulesizeg, self.rulesizegunit)
                self.displayRuleSize(temp.rulesizel, self.rulesizel, self.rulesizelunit)
            else:
                return

        # Updating default template name
        if self.templatedefault != self.abcparams['templatedefault']:
            self.abcparams['templatedefault'] = self.templatedefault
            tcfm = TorrentConfigFileManager(path.join(self.utility.datapath, "abc.conf"), self.abcparams)
            tcfm.writeAllConfig()

        # Apply deleting and renaming in torrents
        for torrent in self.parent.window.queue.proctab:
            if torrent.label in self.bufferedmodif:
                if self.bufferedmodif[torrent.label] is None:
                    if torrent.abcengine and not torrent.abcengine.onlycheck:
                        torrent.updateLimiters(-1)
                else:
                    torrent.label = self.bufferedmodif[torrent.label]

        # Apply deleting and renaming in the connections limiters list
        limitertobesorted = []
        savelimiters = False
        for temp in self.bufferedmodif:
            modif = self.bufferedmodif[temp]
            if modif is None:
                # Deleting
                for limiter in self.templates[temp].conlimiters:
                    savelimiters = True
                    conlimiter = self.conlimiters[limiter]
                    conlimiter.templates.remove(temp)
            else:
                # Renaming
                for limiter in self.templates[temp].conlimiters:
                    savelimiters = True
                    conlimiter = self.conlimiters[limiter]
                    conlimiter.templates.remove(temp)
                    conlimiter.templates.append(modif)
                    if not conlimiter in limitertobesorted:
                        limitertobesorted.append(conlimiter)
        for conlimiter in limitertobesorted:
            conlimiter.templates.sort(key = unicode.lower)
        if savelimiters:
            # Save limiters to conlimiter.lst
            limiterfileman = ConLimiterListFileManager(self)
            limiterfileman.open(mode = 'w+')
            try:
                limiterfileman.writeList(self.parent.window.conlimitermanager.conlimiters,
                                         self.parent.window.conlimitermanager.conlimitersbyindex)
            except:
                limiterfileman.close()
            else:
                limiterfileman.close()
                try:
                    remove(limiterfileman.filename)
                except:
                    pass
                rename(limiterfileman.filename + '.part', limiterfileman.filename)

        self.bufferedmodif.clear()

        # Updating templates
        self.templates.clear()
        self.templates.update(self.editedtemplates)
        self.tempbyindex[:] = self.editedtempbyindex
        self.tempbytrigrank[:] = self.editedtempbytrigrank

        # Save templates to template.lst
        tempfileman = TemplateListFileManager(self)
        tempfileman.open(mode = 'w+')
        try:
            tempfileman.writeList(self.templates, self.tempbyindex, self.tempbytrigrank)
        except:
            tempfileman.close()
        else:
            tempfileman.close()
            try:
                remove(tempfileman.filename)
            except:
                pass
            rename(tempfileman.filename + '.part', tempfileman.filename)

        self.sortdir = 2
        self.lastsortingcol = -1
        self.sortdirtrig = 2
        self.lastsortingcoltrig = -1

        #print '=========================================================================='
        #print 'TEMPLATES :'
        #for t in self.templates:
        #    print t, ':', self.templates[t].conlimiters
        #print 'LIMITERS :'
        #for l in self.parent.window.conlimitermanager.conlimiters:
        #    print l, ':', self.parent.window.conlimitermanager.conlimiters[l].templates

        return True

    def onOK(self, event):
        if self.onApply(event):
            self.EndModal(wx.ID_OK)
