##############################################################################
# Module : setdestdlg.py
# Author : Old King Cole
# Date   : 10/15/2005
#
# Description : Dialog for setting the download destination of a torrent
#
##############################################################################
import sys, wx
from os import path
from string import whitespace

from BitTornado.bencode import bdecode

from Dialogs.addsamedestdlg import AddSameDestDialog


class SetDestDialog(wx.Dialog):
    def __init__(self, parent, ID, torrent, queue, panel, multitorrent, message1, message2 = None, destloc = None, destname = None, torfilename = None,
                 origtorname = None, desttype = None, magnet = 0, pos = wx.DefaultPosition, size = wx.DefaultSize,
                 style = wx.DEFAULT_DIALOG_STYLE | wx.RESIZE_BORDER):
        # May be called with a torrent, or with explicit destination location and destination name,
        # current torrent name and torrent file name (in this case torrent must be set to None)
        # This dialog is used :
        # 1 - to change the destination (location and name) of an existing torrent :
        #     In this case torrent will be set to the torrent to be changed
        # 2 - to choose a new destination for a new torrent because the destination is duplicate or badly named :
        #     In this case torrent will be set to None
        # Destination name length is only checked in case 1 ; in case 2, the global name checking will later check
        # paths including destination.
        self.queue = queue
        self.panel = panel
        self.multitorrent = multitorrent
        self.utility = parent.utility
        self.localize = self.utility.lang.get
        self.torrent = torrent
        self.movedata_prev = False
        if self.multitorrent:
            title = self.localize('choosedowndestmulti') + message1
        else:
            title = self.localize('choosedowndest') + message1
        pre = wx.PreDialog()
        pre.Create(parent, ID, title, pos, size, style)
        self.this = pre.this

        if self.torrent is None:
            self.fixedlength = None
            self.magnet = magnet
            self.newdest = path.join(destloc, destname)
            magnetname = currenttorname = origtorname
            torfilename = path.split(torfilename)[1]
            torrentstringindex = torfilename.lower().rfind('.torrent')
            if torrentstringindex != -1:
                torfilename = torfilename[:torrentstringindex]
        else:
            self.magnet = self.torrent.magnet
            self.newdest = self.torrent.dest
            destloc = path.split(self.torrent.dest)[0]
            if self.multitorrent:
                destname = origtorname = magnetname = currenttorname = torfilename = ''
            else:
                if self.magnet == 1:
                    self.fixedlength = None
                    destname = origtorname = self.localize('notorrentinfo')
                elif self.magnet == 2:
                    self.fixedlength = None
                    destname = path.split(self.torrent.dest)[1]
                    origtorname = self.localize('notorrentinfo')
                else:
                    if self.torrent.singlefile:
                        self.fixedlength = None
                    else:
                        self.fixedlength = max([len(f) for f in self.torrent.getFileNames()])
                    destname = path.split(self.torrent.dest)[1]
                    metainfo_file = open(self.torrent.src, 'rb')
                    metainfo = bdecode(metainfo_file.read(), sloppy = 1)
                    metainfo_file.close()
                    self.info = metainfo['info']
                    if self.info.has_key('name.utf-8'):
                        namekey = 'name.utf-8'
                    else:
                        namekey = 'name'
                    origtorname = self.utility.decodeString(self.info[namekey])
                magnetname = self.torrent.magnetname
                currenttorname = self.torrent.name
                torfilename = path.split(self.torrent.src)[1]
                torrentstringindex = torfilename.lower().rfind('.torrent')
                if torrentstringindex != -1:
                    torfilename = torfilename[:torrentstringindex]
        # True : file ; False : dir ; None : unknown
        self.desttype = desttype

        outerbox = wx.BoxSizer(wx.VERTICAL)

        globalbox = wx.StaticBoxSizer(wx.StaticBox(self, -1, ''), wx.VERTICAL)

        if message2:
            globalbox.Add(wx.StaticText(self, -1, message2), 0, wx.ALIGN_CENTER_VERTICAL | wx.TOP, 3)

        buttonlabel = self.localize('browse')
        buttonwidth = self.GetTextExtent(buttonlabel)[0] + 12
        buttonlabel = buttonlabel.replace('&', '&&')
        button1label = self.localize('dir')
        button1width = self.GetTextExtent(button1label)[0] + 12
        button1label = button1label.replace('&', '&&')
        button2label = self.localize('fil')
        button2width = self.GetTextExtent(button2label)[0] + 12
        button2label = button2label.replace('&', '&&')

        if self.multitorrent:
            downdestlochead = self.localize('downdestlocmulti')
        else:
            downdestlochead = self.localize('downdestloc')
        downdestlocbox = wx.StaticBoxSizer(wx.StaticBox(self, -1, downdestlochead), wx.VERTICAL)
        downdestloc = wx.BoxSizer(wx.HORIZONTAL)
        self.downdestloctext = wx.TextCtrl(self, -1, destloc, (-1, -1), (400, -1))        
        downdestloc.Add(self.downdestloctext, 1)
        downdestlocbtn = wx.Button(self, -1, buttonlabel, (-1, -1), (buttonwidth, self.utility.buttonheight))
        downdestloc.Add(downdestlocbtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        downdestlocbox.Add(downdestloc, 0, wx.EXPAND | wx.TOP, 0)

        if not self.multitorrent:
            if desttype:
                downdestnamehead = self.localize('downfilename')
            elif desttype is None:
                downdestnamehead = self.localize('downname')
            else:
                downdestnamehead = self.localize('downdirname')
            downdestnamebox = wx.StaticBoxSizer(wx.StaticBox(self, -1, downdestnamehead), wx.VERTICAL)
            downdestname = wx.BoxSizer(wx.HORIZONTAL)
            self.downdestnametext = wx.TextCtrl(self, -1, destname, (-1, -1), (400, -1))        
            downdestname.Add(self.downdestnametext, 1)
            if desttype is None:
                # Unknown dest type -> 2 buttons (dir and file)
                downdestnamebtn1 = wx.Button(self, -1, button1label, (-1, -1), (button1width, self.utility.buttonheight))
                downdestname.Add(downdestnamebtn1, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
                downdestnamebtn2 = wx.Button(self, -1, button2label, (-1, -1), (button2width, self.utility.buttonheight))
                downdestname.Add(downdestnamebtn2, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            else:
                downdestnamebtn = wx.Button(self, -1, buttonlabel, (-1, -1), (buttonwidth, self.utility.buttonheight))
                downdestname.Add(downdestnamebtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            downdestnamebox.Add(downdestname, 0, wx.EXPAND | wx.TOP, 0)

            self.pathlength = wx.StaticText(self, -1, self.buildLengthString(len(self.downdestnametext.GetValue()),
                                                                             len(self.utility.completePath(destloc)) + 1,
                                                                             self.fixedlength + 1 if self.fixedlength else None))
            downdestnamebox.Add(self.pathlength, 0, wx.TOP, 3)

            usenamefrombox = wx.StaticBoxSizer(wx.StaticBox(self, -1, self.localize('usenamefrom')), wx.VERTICAL)

            usenamefrombox.Add(wx.StaticText(self, -1, self.localize('origtorname')), 0, wx.TOP, -1)
            origtornamebox = wx.BoxSizer(wx.HORIZONTAL)
            self.origtornametext = wx.TextCtrl(self, -1, origtorname, (-1, -1), (-1, -1), wx.TE_READONLY)
            origtornamebox.Add(self.origtornametext, 1, wx.EXPAND)
            origtornamebtn = wx.Button(self, -1, self.localize('copybtn'), size = (-1, self.utility.buttonheight), style = wx.BU_EXACTFIT)
            origtornamebox.Add(origtornamebtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            usenamefrombox.Add(origtornamebox, 1, wx.EXPAND | wx.TOP, 3)

            if self.torrent and self.torrent.magnetname:
                usenamefrombox.Add(wx.StaticText(self, -1, self.localize('magnetname')), 0, wx.TOP, 5)
                magnetnamebox = wx.BoxSizer(wx.HORIZONTAL)
                self.magnetnametext = wx.TextCtrl(self, -1, magnetname, (-1, -1), (-1, -1), wx.TE_READONLY)
                magnetnamebox.Add(self.magnetnametext, 1, wx.EXPAND)
                magnetnamebtn = wx.Button(self, -1, self.localize('copybtn'), size = (-1, self.utility.buttonheight), style = wx.BU_EXACTFIT)
                magnetnamebox.Add(magnetnamebtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
                usenamefrombox.Add(magnetnamebox, 1, wx.EXPAND | wx.TOP, 3)

            usenamefrombox.Add(wx.StaticText(self, -1, self.localize('currenttorname')), 0, wx.TOP, 5)
            currenttornamebox = wx.BoxSizer(wx.HORIZONTAL)
            self.currenttornametext = wx.TextCtrl(self, -1, currenttorname, (-1, -1), (-1, -1), wx.TE_READONLY)
            currenttornamebox.Add(self.currenttornametext, 1, wx.EXPAND)
            currenttornamebtn = wx.Button(self, -1, self.localize('copybtn'), size = (-1, self.utility.buttonheight), style = wx.BU_EXACTFIT)
            currenttornamebox.Add(currenttornamebtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            usenamefrombox.Add(currenttornamebox, 1, wx.EXPAND | wx.TOP, 3)

            usenamefrombox.Add(wx.StaticText(self, -1, self.localize('torfilename')), 0, wx.TOP, 5)
            torfilenamebox = wx.BoxSizer(wx.HORIZONTAL)
            self.torfilenametext = wx.TextCtrl(self, -1, torfilename, (-1, -1), (-1, -1), wx.TE_READONLY)
            torfilenamebox.Add(self.torfilenametext, 1, wx.EXPAND)
            torfilenamebtn = wx.Button(self, -1, self.localize('copybtn'), size = (-1, self.utility.buttonheight), style = wx.BU_EXACTFIT)
            torfilenamebox.Add(torfilenamebtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            usenamefrombox.Add(torfilenamebox, 1, wx.EXPAND | wx.TOP, 3)
            downdestnamebox.Add(usenamefrombox, 1, wx.EXPAND | wx.TOP, 5)

            self.rentorwithdest = wx.CheckBox(self, -1, self.localize('rentorwithdest'))
            downdestnamebox.Add(self.rentorwithdest, 0, wx.TOP, 3)

        else:
            self.resetmagnetdestname = wx.CheckBox(self, -1, self.localize('resetmagnetdestname'))

        self.movedata = wx.CheckBox(self, -1, self.localize('movedata'))
        self.dontmovewhencomp = wx.CheckBox(self, -1, self.localize('dontmovewhencomp'))

        globalbox.Add(downdestlocbox, 0, wx.TOP | wx.EXPAND, 5)
        if not self.multitorrent:
            globalbox.Add(downdestnamebox, 0, wx.TOP | wx.EXPAND, 5)
        else:
            globalbox.Add(self.resetmagnetdestname, 0, wx.TOP, 3)
        globalbox.Add(self.movedata, 0, wx.TOP, 3)
        globalbox.Add(self.dontmovewhencomp, 0, wx.TOP, 3)

        outerbox.Add(globalbox, 0, wx.EXPAND | wx.TOP, -4)

        buttonbox = wx.BoxSizer(wx.HORIZONTAL)
        self.okbtn = wx.Button(self, -1, self.localize('ok'), size = (60, -1))
        self.cancelbtn = wx.Button(self, -1, self.localize('cancel'), size = (60, -1))
        buttonbox.Add(self.okbtn, 0, wx.ALL, 5)
        buttonbox.Add(self.cancelbtn, 0, wx.ALL, 5)

        outerbox.Add(buttonbox, 0, wx.ALIGN_CENTER)

        self.SetAutoLayout(True)
        self.SetSizer(outerbox)
        self.Fit()
        self.SetSize((int(self.utility.abcparams['abcsetdestdlgw']), -1))
        height = self.GetSize()[1]
        self.SetMinSize((300, height))
        self.SetMaxSize((-1, height))

        # Add events
        self.Bind(wx.EVT_BUTTON, self.onChangeLocation, downdestlocbtn)
        if not self.multitorrent:
            if self.magnet:
                self.Bind(wx.EVT_BUTTON, self.onChangeDestDir, downdestnamebtn1)
                self.Bind(wx.EVT_BUTTON, self.onChangeDestFile, downdestnamebtn2)
            else:
                self.Bind(wx.EVT_BUTTON, self.onChangeDest, downdestnamebtn)
            self.Bind(wx.EVT_BUTTON, self.onCopyCurName, currenttornamebtn)
            self.Bind(wx.EVT_BUTTON, self.onCopyOrigName, origtornamebtn)
            if self.torrent and self.torrent.magnetname:
                self.Bind(wx.EVT_BUTTON, self.onCopyMagnetName, magnetnamebtn)
            self.Bind(wx.EVT_BUTTON, self.onCopyTorFileName, torfilenamebtn)
            self.downdestloctext.Bind(wx.EVT_TEXT, self.onChangeDownDestLoc)
            self.downdestnametext.Bind(wx.EVT_TEXT, self.onChangeDownDestName)
        self.Bind(wx.EVT_BUTTON, self.onOK, self.okbtn)
        self.Bind(wx.EVT_BUTTON, self.onCancel, self.cancelbtn)
        self.Bind(wx.EVT_CLOSE, self.onCancel)

        if self.utility.abcparams['abcsetdestdlgx'] != '-1':
            self.MoveXY(int(self.utility.abcparams['abcsetdestdlgx']), int(self.utility.abcparams['abcsetdestdlgy']))

        if not self.multitorrent:
            if self.magnet:
                self.movedata.Disable()
            if self.magnet == 1:
                self.rentorwithdest.Disable()
                self.rentorwithdest_prev = self.utility.abcparams['defrentorwithdest'] == "1"
            elif self.utility.abcparams['defrentorwithdest'] == "1":
                self.rentorwithdest.SetValue(True)

    def buildLengthString(self, destlen, loclen, fixedlen):
        if fixedlen:
            return '/'.join([str(destlen), str(destlen + loclen), str(destlen + loclen + fixedlen)])
        return '/'.join([str(destlen), str(destlen + loclen)])

    def setLengthString(self):
        fixedlength = self.fixedlength
        destloc = self.utility.completePath(self.downdestloctext.GetValue())
        destname = self.downdestnametext.GetValue()
        if destloc[-1] == '\\':
            destloclength = len(destloc)
        else:
            destloclength = len(destloc) + 1
        if fixedlength:
            if destname and destname[-1] != '\\':
                fixedlength += 1
        self.pathlength.SetLabel(self.buildLengthString(len(destname), destloclength, fixedlength))

    def onChangeDownDestLoc(self, event):
        wx.CallAfter(self.setLengthString)
        event.Skip()

    def onChangeDownDestName(self, event):
        wx.CallAfter(self.setLengthString)
        if self.magnet:
            if self.downdestnametext.GetValue() == self.localize('notorrentinfo'):
                if self.rentorwithdest.IsEnabled():
                    self.rentorwithdest_prev = self.rentorwithdest.GetValue()
                    self.rentorwithdest.SetValue(False)
                    self.rentorwithdest.Disable()
                if self.magnet == 2 and self.movedata.IsEnabled():
                    self.movedata_prev = self.movedata.GetValue()
                    self.movedata.SetValue(False)
                    self.movedata.Disable()
            else:
                if not self.rentorwithdest.IsEnabled():
                    self.rentorwithdest.Enable()
                    self.rentorwithdest.SetValue(self.rentorwithdest_prev)
                if self.magnet == 2 and not self.movedata.IsEnabled():
                    self.movedata.Enable()
                    self.movedata.SetValue(self.movedata_prev)
        event.Skip()

    def getResult(self):
        # To be called only when torrent is None to get results
        return self.newdest, self.magnet

    def getRenTorWithDest(self):
        return self.rentorwithdest.GetValue()

    def onChangeLocation(self, event):
        dl = wx.DirDialog(self, self.localize('choosenewdestloc'), self.downdestloctext.GetValue(),
                          style = wx.DD_DEFAULT_STYLE | wx.DD_NEW_DIR_BUTTON)
        result = dl.ShowModal()
        if result != wx.ID_OK:
            dl.Destroy()
            return
        dest = dl.GetPath()
        dl.Destroy()
        self.downdestloctext.SetValue(dest)

    def onChangeDestDir(self, event):
        self.desttype = False
        self.onChangeDest(event)

    def onChangeDestFile(self, event):
        self.desttype = True
        self.onChangeDest(event)

    def onChangeDest(self, event):
        if self.desttype:
            dl = wx.FileDialog(self, self.localize('choosenewfilename'), self.downdestloctext.GetValue(),
                               self.downdestnametext.GetValue(), '*.*', wx.SAVE)                
        else:
            dl = wx.DirDialog(self, self.localize('choosenewdirname'),
                              path.join(self.downdestloctext.GetValue(), self.downdestnametext.GetValue()),
                              style = wx.DD_DEFAULT_STYLE | wx.DD_NEW_DIR_BUTTON)
        result = dl.ShowModal()
        if result != wx.ID_OK:
            dl.Destroy()
            return
        dest = dl.GetPath()
        dl.Destroy()
        
        
        self.downdestloctext.SetValue(path.split(dest)[0])
        self.downdestnametext.SetValue(path.split(dest)[1])

    def onCopyOrigName(self, event):
        self.downdestnametext.SetValue(self.origtornametext.GetValue())

    def onCopyMagnetName(self, event):
        self.downdestnametext.SetValue(self.magnetnametext.GetValue())

    def onCopyCurName(self, event):
        self.downdestnametext.SetValue(self.currenttornametext.GetValue())

    def onCopyTorFileName(self, event):
        self.downdestnametext.SetValue(self.torfilenametext.GetValue())

    def onCancel(self, event = None):
        self.EndModal(wx.ID_CANCEL)

    def onOK(self, event):
        newdowndestloc = self.downdestloctext.GetValue()

        # Check if location name is valid in Windows
        if sys.platform == 'win32':
            # We erase the final '\' except for a path like 'X:\'
            if newdowndestloc and newdowndestloc[-1] == '\\' and (len(newdowndestloc) < 2 or newdowndestloc[-2] != ':'):
                newdowndestloc = newdowndestloc[:-1]
            newdowndestloc = newdowndestloc.rstrip(whitespace + '.')
            if not self.utility.checkWinPath(self, newdowndestloc):
                return

        selectedtorrents = {}

        if self.multitorrent:
            # Just update the location and possibly reset magnet 2 to 1 for all selected torrents
            resetmagnetdestname = self.resetmagnetdestname.GetValue()
            for index in self.panel.getSelected():
                torrent = self.queue.proctab[index]
                magnet = torrent.magnet
                # New test because status or mode could have been changed by web service or command line
                if torrent.abcengine \
                   or ((torrent.status == 'queue' or torrent.status == 'standby') and self.utility.abcparams['mode'] == '1') \
                   or torrent.ismovingdata:
                    continue
                self.newdest = path.join(newdowndestloc, path.split(torrent.dest)[1])
                if resetmagnetdestname and magnet == 2:
                    magnet = 1
                completedest = self.utility.completePath(self.newdest)
                samedest = completedest.lower() == self.utility.completePath(torrent.dest).lower()
                pathstatus = []
                if magnet != 1:
                    if not samedest:
                        destlen = len(completedest)
                        if torrent.singlefile:
                            if destlen > self.utility.filepathmaxlength or len(path.split(completedest)[0]) > self.utility.pathmaxlength:
                                pathstatus.append(1)
                            else:
                                pathstatus.append(0)
                        else:
                            # Check path length for each file of the torrent
                            for f in torrent.getFileNames():
                                if len(f) + destlen >= self.utility.filepathmaxlength or len(path.split(f)[0]) + destlen >= self.utility.pathmaxlength:
                                    pathstatus.append(1)
                                else:
                                    pathstatus.append(0)
                selectedtorrents[torrent] = (self.newdest, pathstatus, magnet, samedest)
        else :
            newdowndestname = self.downdestnametext.GetValue()
            if self.magnet and newdowndestname == self.localize('notorrentinfo'):
                if self.magnet == 2:
                    self.magnet = 1
                if self.torrent is None:
                    self.newdest = path.join(newdowndestloc, destname)
                else:
                    self.newdest = path.join(newdowndestloc, path.split(self.torrent.dest)[1])
                    samedest = self.utility.completePath(self.newdest).lower() == self.utility.completePath(self.torrent.dest).lower()
                    # No name length checking necessary for magnet 1
                    selectedtorrents[self.torrent] = (self.newdest, [], self.magnet, samedest)
            else:
                if self.magnet == 1:
                    self.magnet = 2
                # Check if file and folder names are valid in Windows
                newdowndestname = newdowndestname.rstrip(whitespace + '.')
                fixedname = self.utility.fixWindowsName(newdowndestname)
                if fixedname:
                    dlg = wx.MessageDialog(self, newdowndestname + '\n' + self.localize('errorinvalidwinname') + fixedname,
                                           self.localize('abcokcerror'), wx.ICON_ERROR)
                    dlg.ShowModal()
                    dlg.Destroy()
                    return
                self.newdest = path.join(newdowndestloc, newdowndestname)

                if self.torrent is not None and not (self.torrent.abcengine \
                   or ((self.torrent.status == 'queue' or self.torrent.status == 'standby') and self.utility.abcparams['mode'] == '1') \
                   or self.torrent.ismovingdata):
                    completedest = self.utility.completePath(self.newdest)
                    samedest = completedest.lower() == self.utility.completePath(self.torrent.dest).lower()
                    pathstatus = []
                    if not samedest:
                        destlen = len(completedest)
                        if self.torrent.singlefile:
                            if destlen > self.utility.filepathmaxlength or len(path.split(completedest)[0]) > self.utility.pathmaxlength:
                                pathstatus.append(1)
                            else:
                                pathstatus.append(0)
                        else:
                            # Check path length for each file of the torrent
                            for f in self.torrent.getFileNames(filesinfo = self.info['files']):
                                if len(f) + destlen >= self.utility.filepathmaxlength or len(path.split(f)[0]) + destlen >= self.utility.pathmaxlength:
                                    pathstatus.append(1)
                                else:
                                    pathstatus.append(0)
                    selectedtorrents[self.torrent] = (self.newdest, pathstatus, self.magnet, samedest)

        # Check for too long paths in dest and for duplicate dest
        if selectedtorrents:
            if self.multitorrent:
                renamewithdest = False
            else:
                if self.magnet == 1:
                    renamewithdest = False
                else:
                    renamewithdest = self.rentorwithdest.GetValue()
        if not self.multitorrent and (selectedtorrents or self.torrent is None) and self.rentorwithdest.GetValue():
            # Update current torrent name field in dialog
            self.currenttornametext.SetValue(newdowndestname)
        movedata = self.movedata.GetValue()
        dontmovewhencomp = self.dontmovewhencomp.GetValue()
        for t in selectedtorrents:
            nd, ps, m, sd = selectedtorrents[t]
            if m != 1:
                # Too long file path ?
                # Initially this was always allowed, but it forbids moving already received data
                if 1 in ps:
                    dlg = wx.MessageDialog(self, self.localize('torrentname') + t.name
                                           + '\n' + self.localize('errortoolongdestpath'),
                                           self.localize('abcokcwarning'), wx.ICON_WARNING)
                    dlg.ShowModal()
                    dlg.Destroy()
                    if movedata:
                        # Return to dialog because moving data will not be possible
                        return False
                # Search for duplicate destination
                keepdup = False
                if self.multitorrent:
                    # Search in selected torrents
                    newdestname = path.split(nd)[1].lower()
                    for t2 in selectedtorrents:
                        if t2 is not t:
                            nd2, ps2, m2, sd2 = selectedtorrents[t2]
                            if m2 != 1 and path.split(nd2)[1].lower() == newdestname:
                                dlg = AddSameDestDialog(self, -1, self.localize('duplicatedestination'),
                                                        t.name, t.src, False, loading = False,
                                                        pos = self.queue.addtorrentwarningpos)
                                result = dlg.ShowModal()
                                self.queue.addtorrentwarningpos = dlg.GetPosition()
                                dlg.Destroy()
                                if result == 0:
                                    # Return to dialog
                                    return False
                                # Keep changing dest with duplicate dest
                                keepdup = True
                                break
                if not keepdup:
                    # Search in all torrents except selected ones
                    destlowercase = self.utility.completePath(nd).lower()
                    for t2 in self.queue.proctab:
                        if t2 not in selectedtorrents \
                           and t2.magnet != 1 and self.utility.completePath(t2.dest).lower() == destlowercase:
                            dlg = AddSameDestDialog(self, -1, self.localize('duplicatedestination'),
                                                    t.name, t.src, False, loading = False,
                                                    pos = self.queue.addtorrentwarningpos)
                            result = dlg.ShowModal()
                            self.queue.addtorrentwarningpos = dlg.GetPosition()
                            dlg.Destroy()
                            if result == 0:
                                # Return to dialog
                                return False
                            # Keep changing dest with duplicate dest
                            break

        # All torrents are OK
        for t in selectedtorrents:
            nd, ps, m, sd = selectedtorrents[t]
            # Update file name status
            if not t.singlefile and ps:
                # Set bit 4 (too long path) in file name status
                t.setAllFileNameStatus(ps, mask = 8)
            # Update magnet
            t.magnet = m
            # Update move folder
            if dontmovewhencomp:
                t.movefolder = ""
            # Update destination
            olddest = self.utility.completePath(t.dest)
            # Performed even if destination is not changed, to reflect possible changes in letter case 
            self.queue.changeProcDest(t, nd, renamewithdest)
            # Only data move is excluded if destination is not changed
            if movedata and m == 0 and not sd:
                self.queue.dataMovingToNewDestThread(t, olddest)

        self.EndModal(wx.ID_OK)
