##############################################################################
# Module : scrapedlg.py
# Author : Old King Cole
# Date   : 10/15/2005
#
# Description : Dialog for displaying scraping results
#
##############################################################################
import wx


class ScrapeDialog(wx.Dialog):
    def __init__(self, parent, ID, title, torrent, status, seed, peer,
                 pos = wx.DefaultPosition, size = wx.DefaultSize,
                 style = wx.DEFAULT_DIALOG_STYLE):
        pre = wx.PreDialog()
        pre.Create(parent, ID, title, pos, size, style)
        self.this = pre.this
        self.utility = parent.utility
        self.localize = self.utility.lang.get

        outerbox = wx.BoxSizer(wx.VERTICAL)

        scrapebox = wx.StaticBoxSizer(wx.StaticBox(self, -1, ''), wx.VERTICAL)

        filename = wx.BoxSizer(wx.HORIZONTAL)
        filename.Add(wx.StaticText(self, -1, self.localize('scrapetorrent')), 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
        filename.Add(wx.StaticText(self, -1, torrent.name), 0, wx.ALIGN_CENTER_VERTICAL)

        scrapebox.Add(filename, 0)

        currentvalues = wx.BoxSizer(wx.HORIZONTAL)
        currentvalues.Add(wx.StaticText(self, -1, self.localize('seed')), 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
        self.currentseed = wx.TextCtrl(self, -1, seed, (-1, -1), (30, -1), wx.TE_READONLY)
        currentvalues.Add(self.currentseed, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 10)

        currentvalues.Add(wx.StaticText(self, -1, self.localize('peer')), 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
        self.currentpeer = wx.TextCtrl(self, -1, peer, (-1, -1), (30, -1), wx.TE_READONLY)
        currentvalues.Add(self.currentpeer, 0, wx.ALIGN_CENTER_VERTICAL)

        scrapebox.Add(currentvalues, 0, wx.ALIGN_CENTER | wx.TOP, 5)

        statusbox = wx.BoxSizer(wx.HORIZONTAL)
        statusbox.Add(wx.StaticText(self, -1, self.localize('status')), 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
        self.displaystatus = wx.StaticText(self, -1, status)
        statusbox.Add(self.displaystatus, 0, wx.ALIGN_CENTER_VERTICAL)

        scrapebox.Add(statusbox, 0, wx.ALIGN_CENTER | wx.TOP, 5)

        outerbox.Add(scrapebox, 0, wx.TOP, -4)

        closebtn = wx.Button(self, wx.ID_OK, self.localize('close'))
        self.Bind(wx.EVT_BUTTON, self.onClose, closebtn)
        self.Bind(wx.EVT_CLOSE, self.onClose)

        outerbox.Add(closebtn, 0, wx.ALIGN_CENTER | wx.ALL, 5)

        self.SetAutoLayout(True)
        self.SetSizer(outerbox)
        self.Fit()

    def onClose(self, event):
        self.EndModal(wx.ID_OK)
