##############################################################################
# Module : rssscanfreqdlg.py
# Author : Old King Cole
# Date   : 10/15/2005
#
# Description : Dialog for tweaking RSS scanning frequency
#
##############################################################################
import wx


class RSSScanFreqDialog(wx.Dialog):
    def __init__(self, parent, ID, title,
                 pos = wx.DefaultPosition, size = wx.DefaultSize,
                 style = wx.DEFAULT_DIALOG_STYLE):
        pre = wx.PreDialog()
        pre.Create(parent, ID, title, pos, size, style)
        self.this = pre.this
        self.parent = parent
        self.utility = self.parent.utility
        self.localize = self.utility.lang.get

        p = wx.Panel(self, -1)
        outerbox = wx.BoxSizer(wx.VERTICAL)

        rssscanfreqsection = wx.StaticBoxSizer(wx.StaticBox(p, -1, ''), wx.VERTICAL)

        dtime, mtime = divmod(int(self.utility.abcparams['rssscanfreq']), 1440)
        htime, mtime = divmod(mtime, 60)

        rssscanfreqbox = wx.BoxSizer(wx.HORIZONTAL)
        rssscanfreqbox.Add(wx.StaticText(p, -1, self.localize('rssscanfreq')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.drssscanfreq = wx.TextCtrl(p, -1, str(dtime), (-1, -1), (31, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.drssscanfreq.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.drssscanfreq.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        rssscanfreqbox.Add(self.drssscanfreq, 0, wx.LEFT, 5)
        rssscanfreqbox.Add(wx.StaticText(p, -1, self.localize('l_day')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.hrssscanfreq = wx.TextCtrl(p, -1, str(htime), (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.hrssscanfreq.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.hrssscanfreq.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        rssscanfreqbox.Add(self.hrssscanfreq, 0, wx.LEFT, 3)
        rssscanfreqbox.Add(wx.StaticText(p, -1, self.localize('l_hour')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.mrssscanfreq = wx.TextCtrl(p, -1, str(mtime), (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.mrssscanfreq.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.mrssscanfreq.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        rssscanfreqbox.Add(self.mrssscanfreq, 0, wx.LEFT, 3)
        rssscanfreqbox.Add(wx.StaticText(p, -1, self.localize('l_minute')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)

        rssscanfreqsection.Add(rssscanfreqbox, 0, wx.ALIGN_CENTER_VERTICAL | wx.TOP, 3)

        outerbox.Add(rssscanfreqsection, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.TOP, -4)

        applybtn = wx.Button(p, -1, self.localize('apply'), size = (60, -1))
        okbtn = wx.Button(p, -1, self.localize('ok'), size = (60, -1))
        cancelbtn = wx.Button(p, -1, self.localize('cancel'), size = (60, -1))

        buttonbox = wx.BoxSizer(wx.HORIZONTAL)
        buttonbox.Add(applybtn, 0, wx.ALL, 5)
        buttonbox.Add(okbtn, 0, wx.ALL, 5)
        buttonbox.Add(cancelbtn, 0, wx.ALL, 5)

        outerbox.Add(buttonbox, 0, wx.ALIGN_CENTER)

        p.SetAutoLayout(True)
        p.SetSizer(outerbox)
        p.Fit()
        self.SetClientSize(p.GetSize())

        # Add events
        self.Bind(wx.EVT_BUTTON, self.onOK, okbtn)
        self.Bind(wx.EVT_BUTTON, self.onApply, applybtn)
        self.Bind(wx.EVT_BUTTON, self.onCancel, cancelbtn)
        self.Bind(wx.EVT_CLOSE, self.onCancel)

        if self.utility.abcparams['rssscanfreqdlgx'] != '-1':
            self.MoveXY(int(self.utility.abcparams['rssscanfreqdlgx']), int(self.utility.abcparams['rssscanfreqdlgy']))

    def onRightButtonText(self, event):
        pass

    def onCancel(self, event = None):
        self.EndModal(wx.ID_CANCEL)

    def onApply(self, event):
        dtime = self.drssscanfreq.GetValue()
        htime = self.hrssscanfreq.GetValue()
        mtime = self.mrssscanfreq.GetValue()
        if not dtime:
            dtime = '0'
        if not htime:
            htime = '0'
        if not mtime:
            mtime = '0'
        timererr = False
        try:
            dtime_int = int(dtime)
            htime_int = int(htime)
            mtime_int = int(mtime)
        except:
            timererr = True
        if timererr or dtime_int < 0 or htime_int < 0 or mtime_int < 0:
            dlg = wx.MessageDialog(self, self.localize('errorfeedertimer'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False
        mtimetotal_int = 1440 * dtime_int + 60 * htime_int + mtime_int
        if mtimetotal_int < 5:
            dlg = wx.MessageDialog(self, self.localize('rssscanfreqwarning'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False
        dtime_int, mtime_int = divmod(mtimetotal_int, 1440)
        htime_int, mtime_int = divmod(mtime_int, 60)
        self.drssscanfreq.SetValue(str(dtime_int))
        self.hrssscanfreq.SetValue(str(htime_int))
        self.mrssscanfreq.SetValue(str(mtime_int))
        self.utility.abcparams['rssscanfreq'] = str(mtimetotal_int)
        self.parent.parent.resetGlobalTimer()
        return True

    def onOK(self, event):
        if self.onApply(event):
            self.EndModal(wx.ID_OK)
