##############################################################################
# Module : conlimiterdlg.py
# Author : Old King Cole
# Date   : 02/12/2007
#
# Description : Dialog for connections limiters
#
##############################################################################
import wx
import wx.lib.scrolledpanel
from os import path, remove, rename
from copy import deepcopy
from filemanager import ConLimiterListFileManager


class ConLimiterDialog(wx.Dialog):
    def __init__(self, parent, ID, title, conlimitermanager,
                 pos = wx.DefaultPosition, size = wx.DefaultSize,
                 style = wx.DEFAULT_DIALOG_STYLE):
        pre = wx.PreDialog()
        pre.Create(parent, ID, title, pos, size, style)
        self.this = pre.this
        self.parent = parent
        self.utility = self.parent.utility
        self.localize = self.utility.lang.get
        self.conlimitermanager = conlimitermanager
        self.limiters = conlimitermanager.conlimiters
        self.templates = conlimitermanager.templates
        self.limitersbyindex = conlimitermanager.conlimitersbyindex
        self.sortdir = 2

        outerbox = wx.BoxSizer(wx.VERTICAL)

        conlimiterlistbox = wx.StaticBoxSizer(wx.StaticBox(self, -1, self.localize('conlimiterlist')), wx.HORIZONTAL)

        self.conlimiterlist = wx.ListCtrl(self, -1, size = (-1, 131),
                                          style = wx.LC_REPORT | wx.LC_SINGLE_SEL | wx.LC_HRULES | wx.LC_VRULES)
        self.conlimiterlist.SetMinSize((191, -1))
        self.conlimiterlist.InsertColumn(0, self.localize('conlimiterlistname'))
        self.conlimiterlist.SetColumnWidth(0, 200)

        conlimiterlistbox.Add(self.conlimiterlist, 1, wx.EXPAND | wx.ALIGN_CENTER | wx.RIGHT, 4)

        addbtn = wx.Button(self, -1, self.localize('conlimiteradd'), size = (48, -1))
        copybtn = wx.Button(self, -1, self.localize('conlimitercopy'), size = (48, -1))
        renamebtn = wx.Button(self, -1, self.localize('conlimiterrename'), size = (48, -1))
        deletebtn = wx.Button(self, -1, self.localize('conlimiterdelete'), size = (48, -1))

        buttonbox1 = wx.BoxSizer(wx.VERTICAL)
        buttonbox1.Add(addbtn, 0, wx.TOP, 0)
        buttonbox1.Add(copybtn, 0, wx.TOP, 5)
        buttonbox1.Add(renamebtn, 0, wx.TOP, 5)
        buttonbox1.Add(deletebtn, 0, wx.TOP, 5)

        conlimiterlistbox.Add(buttonbox1, 0, wx.ALIGN_CENTER_VERTICAL | wx.TOP, -5)

        outerbox.Add(conlimiterlistbox, 0, wx.EXPAND | wx.ALL, 5)

        self.selectedlimiterparambox = wx.StaticBoxSizer(wx.StaticBox(self, -1, self.localize('selectedlimiterparam')), wx.VERTICAL)

        # Choose templates
        self.selectedlimiterparambox.Add(wx.StaticText(self, -1, self.localize('limitertemplates')), 0, wx.EXPAND | wx.ALL, 0)

        templatesbox = wx.BoxSizer(wx.HORIZONTAL)
        self.limitedtemplates = [] 
        self.templatechoosebox = wx.ListBox(self, -1, choices = self.limitedtemplates,
                                            style = wx.CB_READONLY | wx.LB_HSCROLL, size = (-1, 57))
        templatesbox.Add(self.templatechoosebox, 1, wx.EXPAND | wx.ALIGN_CENTER_VERTICAL)
        self.templatebtn = wx.Button(self, -1, self.localize('limitertemplatebtn'))
        templatesbox.Add(self.templatebtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 3)
        self.Bind(wx.EVT_BUTTON, self.onTemplateButton, self.templatebtn)
        self.selectedlimiterparambox.Add(templatesbox, 0, wx.EXPAND | wx.TOP, 3)

        # Limiter max values
        limitermaxvalbox = wx.StaticBoxSizer(wx.StaticBox(self, -1, self.localize('limitermaxval')), wx.VERTICAL)
        self.maxseeding = wx.TextCtrl(self, -1, '', (-1, -1), (25, self.utility.digitheight), wx.TE_RIGHT)
        self.maxseeding.SetToolTipString(self.localize('0isnolimittt'))
        self.maxseeding.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.maxseeding.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        h = self.maxseeding.GetSize().height
        self.maxseedingspin = wx.SpinButton(self, -1, (-1, -1), (h * 2 / 3, h), wx.SP_ARROW_KEYS | wx.SP_VERTICAL)
        self.maxseedingspin.SetRange(0, 99)
        self.Bind(wx.EVT_SPIN_UP, self.onMaxSeedingSpinUp, self.maxseedingspin)
        self.Bind(wx.EVT_SPIN_DOWN, self.onMaxSeedingSpinDown, self.maxseedingspin)
        maxseedingbox = wx.BoxSizer(wx.HORIZONTAL)
        maxseedingbox.Add(wx.StaticText(self, -1, self.localize('maxseeding')), 0, wx.ALIGN_CENTER_VERTICAL)
        maxseedingbox.Add(self.maxseeding, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        maxseedingbox.Add(self.maxseedingspin, 0, wx.ALIGN_CENTER_VERTICAL)
        limitermaxvalbox.Add(maxseedingbox, 0, wx.TOP, 0)

        self.maxworking = wx.TextCtrl(self, -1, '', (-1, -1), (25, self.utility.digitheight), wx.TE_RIGHT)
        self.maxworking.SetToolTipString(self.localize('0isnolimittt'))
        self.maxworking.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.maxworking.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        h = self.maxworking.GetSize().height
        self.maxworkingspin = wx.SpinButton(self, -1, (-1, -1), (h * 2 / 3, h), wx.SP_ARROW_KEYS | wx.SP_VERTICAL)
        self.maxworkingspin.SetRange(0, 99)
        self.Bind(wx.EVT_SPIN_UP, self.onMaxWorkingSpinUp, self.maxworkingspin)
        self.Bind(wx.EVT_SPIN_DOWN, self.onMaxWorkingSpinDown, self.maxworkingspin)
        maxworkingbox = wx.BoxSizer(wx.HORIZONTAL)
        maxworkingbox.Add(wx.StaticText(self, -1, self.localize('maxworking')), 0, wx.ALIGN_CENTER_VERTICAL)
        maxworkingbox.Add(self.maxworking, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        maxworkingbox.Add(self.maxworkingspin, 0, wx.ALIGN_CENTER_VERTICAL)
        limitermaxvalbox.Add(maxworkingbox, 0, wx.TOP, 3)

        self.maxoverall = wx.TextCtrl(self, -1, '', (-1, -1), (25, self.utility.digitheight), wx.TE_RIGHT)
        self.maxoverall.SetToolTipString(self.localize('0isnolimittt'))
        self.maxoverall.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.maxoverall.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        h = self.maxoverall.GetSize().height
        self.maxoverallspin = wx.SpinButton(self, -1, (-1, -1), (h * 2 / 3, h), wx.SP_ARROW_KEYS | wx.SP_VERTICAL)
        self.maxoverallspin.SetRange(0, 99)
        self.Bind(wx.EVT_SPIN_UP, self.onMaxOverallSpinUp, self.maxoverallspin)
        self.Bind(wx.EVT_SPIN_DOWN, self.onMaxOverallSpinDown, self.maxoverallspin)
        maxoverallbox = wx.BoxSizer(wx.HORIZONTAL)
        maxoverallbox.Add(wx.StaticText(self, -1, self.localize('maxoverall')), 0, wx.ALIGN_CENTER_VERTICAL)
        maxoverallbox.Add(self.maxoverall, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        maxoverallbox.Add(self.maxoverallspin, 0, wx.ALIGN_CENTER_VERTICAL)
        limitermaxvalbox.Add(maxoverallbox, 0, wx.TOP, 3)

        self.selectedlimiterparambox.Add(limitermaxvalbox, 0, wx.EXPAND | wx.TOP, 3)

        outerbox.Add(self.selectedlimiterparambox, 0, wx.EXPAND | wx.LEFT | wx.RIGHT, 5)

        applybtn = wx.Button(self, -1, self.localize('apply'), size = (60, -1))
        okbtn = wx.Button(self, -1, self.localize('ok'), size = (60, -1))
        cancelbtn = wx.Button(self, -1, self.localize('cancel'), size = (60, -1))

        buttonbox2 = wx.BoxSizer(wx.HORIZONTAL)
        buttonbox2.Add(applybtn, 0, wx.LEFT, 0)
        buttonbox2.Add(okbtn, 0, wx.LEFT, 20)
        buttonbox2.Add(cancelbtn, 0, wx.LEFT, 20)

        outerbox.Add(buttonbox2, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.BOTTOM | wx.TOP, 6)

        self.SetAutoLayout(True)
        self.SetSizer(outerbox)
        self.Fit()

        # Add events
        ###########################
        self.Bind(wx.EVT_BUTTON, self.onAddLimiter, addbtn)
        self.Bind(wx.EVT_BUTTON, self.onCopyLimiter, copybtn)
        self.Bind(wx.EVT_BUTTON, self.onRenameLimiter, renamebtn)
        self.Bind(wx.EVT_BUTTON, self.onDeleteLimiter, deletebtn)
        self.Bind(wx.EVT_BUTTON, self.onOK, okbtn)
        self.Bind(wx.EVT_BUTTON, self.onApply, applybtn)
        self.Bind(wx.EVT_BUTTON, self.onCancel, cancelbtn)
        self.Bind(wx.EVT_CLOSE, self.onCancel)
        self.conlimiterlist.Bind(wx.EVT_LEFT_DOWN, self.onListLeftClick)
        self.conlimiterlist.Bind(wx.EVT_LIST_COL_CLICK, self.onColLeftClick)
        self.conlimiterlist.Bind(wx.EVT_KEY_DOWN, self.onKeyInList)
        self.templatechoosebox.Bind(wx.EVT_LEFT_DOWN, self.onTemplateListLeftClick)
        self.templatechoosebox.Bind(wx.EVT_LEFT_DCLICK, self.onTemplateListDblLeftClick)

        self.editedlimiters = deepcopy(self.limiters)
        self.editedlimitersbyindex = self.limitersbyindex[:]

        index = 0
        for key in self.editedlimitersbyindex:
            self.conlimiterlist.InsertStringItem(index, key)
            self.editedlimiters[key].previndex = index
            index += 1

        self.templatechoosebox.Disable()
        self.templatebtn.Disable()
        self.maxseeding.Disable()
        self.maxseedingspin.Disable()
        self.maxworking.Disable()
        self.maxworkingspin.Disable()
        self.maxoverall.Disable()
        self.maxoverallspin.Disable()
        self.currentlyedited = None
        self.selectedindex = -1
        self.clearLimiterMask()

        if self.utility.abcparams['conlimiterdlgx'] != '-1':
            self.MoveXY(int(self.utility.abcparams['conlimiterdlgx']), int(self.utility.abcparams['conlimiterdlgy']))

        self.conlimiterlist.SetFocus()

    def onRightButtonText(self, event):
        pass

    def onTemplateButton(self, event):
        dialog = ChooseTemplatesDialog(self)
        dialog.ShowModal()
        dialog.Destroy()

    # Sort list column
    def onColLeftClick(self, event):
        self.utility.sortcol = []
        if self.sortdir == 2:
            index = 0
            for key in self.editedlimitersbyindex:
                self.editedlimiters[key].previndex = index
                index += 1
            self.sortdir = 0
        else:
            self.sortdir += 1

        if self.sortdir == 2:
            index = 0
            for key in self.editedlimitersbyindex:
                self.utility.sortcol.append(self.editedlimiters[key].previndex)
                self.conlimiterlist.SetItemData(index, index)
                index += 1
        else:
            for index in xrange(self.conlimiterlist.GetItemCount()):
                self.utility.sortcol.append(self.conlimiterlist.GetItem(index, 0).GetText().lower())
                self.conlimiterlist.SetItemData(index, index)
        if self.sortdir == 0 or self.sortdir == 2:
            self.conlimiterlist.SortItems(self.utility.sortList)
        else:
            self.conlimiterlist.SortItems(self.utility.sortListReverse)

        if self.selectedindex != -1:
            self.selectedindex = self.conlimiterlist.GetNextItem(-1, wx.LIST_NEXT_ALL, wx.LIST_STATE_SELECTED)
        self.editedlimitersbyindex = [self.conlimiterlist.GetItemText(index) for index in xrange(self.conlimiterlist.GetItemCount())]

    def onKeyInList(self, event):
        if not self.conlimiterlist.GetItemCount():
            return
        keycode = event.GetKeyCode()
        if keycode == wx.WXK_UP:
            self.onListLeftClick(index = max(0, self.selectedindex - 1))
        elif keycode == wx.WXK_DOWN:
            self.onListLeftClick(index = min(self.conlimiterlist.GetItemCount() - 1, self.selectedindex + 1))
        elif keycode == wx.WXK_PRIOR:
            self.onListLeftClick(index = max(0, self.selectedindex - self.conlimiterlist.GetCountPerPage()))
        elif keycode == wx.WXK_NEXT:
            self.onListLeftClick(index = min(self.conlimiterlist.GetItemCount() - 1, self.selectedindex + self.conlimiterlist.GetCountPerPage()))
        elif keycode == wx.WXK_HOME:
            self.onListLeftClick(index = 0)
        elif keycode == wx.WXK_END:
            self.onListLeftClick(index = self.conlimiterlist.GetItemCount() - 1)
        elif event.ControlDown() and keycode == wx.WXK_NUMPAD_DECIMAL:
            self.sortdir = 2
            self.parent.window.displayStatusTextTemp(self.localize('listsortingstatusunsorted'))
        else:
            event.Skip()

    def onListLeftClick(self, event = None, index = None):
        if index is None:
            clickedindex = self.conlimiterlist.HitTest(wx.Point(event.GetX(), event.GetY()))[0]
        else:
            clickedindex = index
        if clickedindex == self.selectedindex:
            if event is not None:
                event.Skip()
            return
        if self.currentlyedited is not None:
            self.readLimiterMask()
        if clickedindex < 0:
            if event is not None:
                event.Skip()
            self.templatechoosebox.Disable()
            self.templatebtn.Disable()
            self.maxseeding.Disable()
            self.maxseedingspin.Disable()
            self.maxworking.Disable()
            self.maxworkingspin.Disable()
            self.maxoverall.Disable()
            self.maxoverallspin.Disable()
            self.currentlyedited = None
            self.selectedindex = -1
            self.clearLimiterMask()
        else:
            self.selectedindex = clickedindex
            self.conlimiterlist.SetFocus()
            self.conlimiterlist.Select(self.selectedindex)
            self.conlimiterlist.Focus(self.selectedindex)
            self.currentlyedited = self.conlimiterlist.GetItem(self.selectedindex, 0).GetText()
            self.templatechoosebox.Enable()
            self.templatebtn.Enable()
            self.maxseeding.Enable()
            self.maxseedingspin.Enable()
            self.maxworking.Enable()
            self.maxworkingspin.Enable()
            self.maxoverall.Enable()
            self.maxoverallspin.Enable()
            self.fillLimiterMask(self.editedlimiters[self.currentlyedited])

    def onTemplateListLeftClick(self, event):
        pass

    def onTemplateListDblLeftClick(self, event):
        pass

    def clearLimiterMask(self):
        self.templatechoosebox.Clear()
        self.maxseeding.SetValue('')
        self.maxworking.SetValue('')
        self.maxoverall.SetValue('')

    def fillLimiterMask(self, editedlimiter):
        self.limitedtemplates = editedlimiter.templates[:]
        self.templatechoosebox.Set(self.limitedtemplates)
        self.populateTemplateList()
        self.maxseedingspin.SetValue(editedlimiter.maxseeding)
        self.maxseeding.SetValue(str(editedlimiter.maxseeding))
        self.maxworkingspin.SetValue(editedlimiter.maxworking)
        self.maxworking.SetValue(str(editedlimiter.maxworking))
        self.maxoverallspin.SetValue(editedlimiter.maxoverall)
        self.maxoverall.SetValue(str(editedlimiter.maxoverall))

    def readLimiterMask(self):
        curedited = self.editedlimiters[self.currentlyedited]
        curedited.templates = self.limitedtemplates[:]
        curedited.maxseeding = int(self.maxseeding.GetValue())
        if curedited.maxseeding > 99:
            curedited.maxseeding = 99
        curedited.maxworking = int(self.maxworking.GetValue())
        if curedited.maxworking > 99:
            curedited.maxworking = 99
        curedited.maxoverall = int(self.maxoverall.GetValue())
        if curedited.maxoverall > 99:
            curedited.maxoverall = 99
        maxformaxoverall = curedited.maxseeding + curedited.maxworking
        if curedited.maxoverall > maxformaxoverall:
            curedited.maxoverall = maxformaxoverall
        return True

    def onMaxSeedingSpinUp(self, event):
        try:
            val = int(self.maxseeding.GetValue())
        except:
            # Not integer
            self.maxseedingspin.SetValue(0)
            self.maxseeding.SetValue('0')
            return
        if val >= 99:
            self.maxseedingspin.SetValue(99)
            self.maxseeding.SetValue('99')
            return
        if val < 0:
            self.maxseedingspin.SetValue(0)
            self.maxseeding.SetValue('0')
            return
        val += 1
        self.maxseedingspin.SetValue(val)
        self.maxseeding.SetValue(str(val))

    def onMaxSeedingSpinDown(self, event):
        try:
            val = int(self.maxseeding.GetValue())
        except:
            # Not integer
            self.maxseedingspin.SetValue(0)
            self.maxseeding.SetValue('0')
            return
        if val > 99:
            self.maxseedingspin.SetValue(99)
            self.maxseeding.SetValue('99')
            return
        if val <= 0:
            self.maxseedingspin.SetValue(0)
            self.maxseeding.SetValue('0')
            return
        val -= 1
        self.maxseedingspin.SetValue(val)
        self.maxseeding.SetValue(str(val))

    def onMaxWorkingSpinUp(self, event):
        try:
            val = int(self.maxworking.GetValue())
        except:
            # Not integer
            self.maxworkingspin.SetValue(0)
            self.maxworking.SetValue('0')
            return
        if val >= 99:
            self.maxworkingspin.SetValue(99)
            self.maxworking.SetValue('99')
            return
        if val < 0:
            self.maxworkingspin.SetValue(0)
            self.maxworking.SetValue('0')
            return
        val += 1
        self.maxworkingspin.SetValue(val)
        self.maxworking.SetValue(str(val))

    def onMaxWorkingSpinDown(self, event):
        try:
            val = int(self.maxworking.GetValue())
        except:
            # Not integer
            self.maxworkingspin.SetValue(0)
            self.maxworking.SetValue('0')
            return
        if val > 99:
            self.maxworkingspin.SetValue(99)
            self.maxworking.SetValue('99')
            return
        if val <= 0:
            self.maxworkingspin.SetValue(0)
            self.maxworking.SetValue('0')
            return
        val -= 1
        self.maxworkingspin.SetValue(val)
        self.maxworking.SetValue(str(val))

    def onMaxOverallSpinUp(self, event):
        try:
            val = int(self.maxoverall.GetValue())
        except:
            # Not integer
            self.maxoverallspin.SetValue(0)
            self.maxoverall.SetValue('0')
            return
        if val >= 99:
            self.maxoverallspin.SetValue(99)
            self.maxoverall.SetValue('99')
            return
        if val < 0:
            self.maxoverallspin.SetValue(0)
            self.maxoverall.SetValue('0')
            return
        val += 1
        self.maxoverallspin.SetValue(val)
        self.maxoverall.SetValue(str(val))

    def onMaxOverallSpinDown(self, event):
        try:
            val = int(self.maxoverall.GetValue())
        except:
            # Not integer
            self.maxoverallspin.SetValue(0)
            self.maxoverall.SetValue('0')
            return
        if val > 99:
            self.maxoverallspin.SetValue(99)
            self.maxoverall.SetValue('99')
            return
        if val <= 0:
            self.maxoverallspin.SetValue(0)
            self.maxoverall.SetValue('0')
            return
        val -= 1
        self.maxoverallspin.SetValue(val)
        self.maxoverall.SetValue(str(val))

    def populateTemplateList(self):
        self.templatechoosebox.Set(self.limitedtemplates)

    def onCancel(self, event = None):
        self.EndModal(wx.ID_CANCEL)

    def onAddLimiter(self, event):
        dialog = wx.TextEntryDialog(self,
                                    self.localize('enterlimitername'),
                                    self.localize('enterlimitername_short'))
        wx.Dialog.SetWindowStyle(dialog, wx.CAPTION | wx.CLOSE_BOX | wx.TAB_TRAVERSAL | wx.RESIZE_BORDER)
        dialog.SetSize((int(self.utility.abcparams['conlimiternamew']), -1))
        height = dialog.GetSize()[1]
        dialog.SetMinSize((300, height))
        dialog.SetMaxSize((-1, height))
        dialog.Centre()
        result = dialog.ShowModal()
        name = dialog.GetValue().translate({124: None, 1: None})
        self.utility.abcparams['conlimiternamew'] = str(dialog.GetSizeTuple()[0])
        dialog.Destroy()
        if result != wx.ID_OK or name == '':
            return

        if name in self.editedlimiters:
            dlg = wx.MessageDialog(self, self.localize('errorlimiterexists'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return

        index = self.conlimiterlist.GetItemCount()
        self.conlimitermanager.createConLimiter(self.editedlimiters, self.editedlimitersbyindex, name)
        self.conlimiterlist.InsertStringItem(index, name)
        self.conlimiterlist.SetFocus()

    def onCopyLimiter(self, event):
        if self.currentlyedited == None:
            return
        newname = self.currentlyedited + '_001'
        i = 1
        while newname in self.editedlimiters:
            i += 1
            if i == 1000:
                break
            newname = newname[:-3] + ('%03u' % i)
        if i == 1000:
            # Impossible to find an automatic new name ; ask user for one
            dialog = wx.TextEntryDialog(self,
                                        self.localize('enterlimitercopyname'),
                                        self.localize('enterlimitercopyname_short'))
            wx.Dialog.SetWindowStyle(dialog, wx.CAPTION | wx.CLOSE_BOX | wx.TAB_TRAVERSAL | wx.RESIZE_BORDER)
            dialog.SetSize((int(self.utility.abcparams['conlimiternamew']), -1))
            height = dialog.GetSize()[1]
            dialog.SetMinSize((300, height))
            dialog.SetMaxSize((-1, height))
            dialog.Centre()
            dialog.SetValue(self.currentlyedited)
            result = dialog.ShowModal()
            newname = dialog.GetValue().translate({124: None, 1: None})
            self.utility.abcparams['conlimiternamew'] = str(dialog.GetSizeTuple()[0])
            dialog.Destroy()

            if newname in self.editedlimiters:
                dlg = wx.MessageDialog(self, self.localize('errorlimiterexists'),
                                       self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return

        self.readLimiterMask()
        index = self.conlimiterlist.GetItemCount()
        self.conlimitermanager.createConLimiter(self.editedlimiters, self.editedlimitersbyindex, newname, self.currentlyedited)
        self.conlimiterlist.InsertStringItem(index, newname)
        self.conlimiterlist.SetFocus()

    def onRenameLimiter(self, event):
        if self.currentlyedited == None:
            return
        dialog = wx.TextEntryDialog(self,
                                    self.localize('enterlimiternewname'),
                                    self.localize('enterlimiternewname_short'))
        wx.Dialog.SetWindowStyle(dialog, wx.CAPTION | wx.CLOSE_BOX | wx.TAB_TRAVERSAL | wx.RESIZE_BORDER)
        dialog.SetSize((int(self.utility.abcparams['conlimiternamew']), -1))
        height = dialog.GetSize()[1]
        dialog.SetMinSize((300, height))
        dialog.SetMaxSize((-1, height))
        dialog.Centre()
        dialog.SetValue(self.currentlyedited)
        result = dialog.ShowModal()
        newname = dialog.GetValue().translate({124: None, 1: None})
        self.utility.abcparams['conlimiternamew'] = str(dialog.GetSizeTuple()[0])
        dialog.Destroy()
        if result != wx.ID_OK or newname == '' or newname == self.currentlyedited:
            return

        if newname in self.editedlimiters:
            dlg = wx.MessageDialog(self, self.localize('errorlimiterexists'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return

        self.editedlimiters[newname] = self.editedlimiters[self.currentlyedited]
        del self.editedlimiters[self.currentlyedited]

        self.editedlimitersbyindex[self.selectedindex] = newname

        self.conlimiterlist.SetItemText(self.selectedindex, newname)

        self.currentlyedited = newname
        self.conlimiterlist.SetFocus()

    def onDeleteLimiter(self, event):
        if self.currentlyedited == None:
            return

        dlg = wx.MessageDialog(self, self.localize('confirmdeletelimiter') + self.currentlyedited,
                               self.localize('abcokcwarning'), wx.ICON_WARNING | wx.YES_NO)
        result = dlg.ShowModal()
        dlg.Destroy()
        if result == wx.ID_NO:            
            return

        del self.editedlimiters[self.currentlyedited]

        self.conlimiterlist.DeleteItem(self.selectedindex)
        self.templatechoosebox.Disable()
        self.templatebtn.Disable()
        self.maxseeding.Disable()
        self.maxseedingspin.Disable()
        self.maxworking.Disable()
        self.maxworkingspin.Disable()
        self.maxoverall.Disable()
        self.maxoverallspin.Disable()
        self.editedlimitersbyindex.remove(self.currentlyedited)
        self.currentlyedited = None
        self.selectedindex = -1
        self.clearLimiterMask()
        self.conlimiterlist.SetFocus()

    def onApply(self, event):
        # Save currently edited
        if self.currentlyedited is not None:
            self.readLimiterMask()

        # Update connections limiters
        self.limiters.clear()
        self.limiters.update(self.editedlimiters)
        self.limitersbyindex[:] = self.editedlimitersbyindex

        # Update templates list
        for temp in self.templates:
            templimiters = self.templates[temp].conlimiters
            templimiters[:] = []
            for limit in self.limiters:
                if temp in self.limiters[limit].templates:
                    templimiters.append(limit)
            templimiters.sort(key = unicode.lower)

        # Compute all limiters counters
        self.conlimitermanager.computeAllCounters()

        # Save limiters to conlimiter.lst
        conlimiterfileman = ConLimiterListFileManager(self)
        conlimiterfileman.open(mode = 'w+')
        try:
            conlimiterfileman.writeList(self.limiters, self.limitersbyindex)
        except:
            conlimiterfileman.close()
        else:
            conlimiterfileman.close()
            try:
                remove(conlimiterfileman.filename)
            except:
                pass
            rename(conlimiterfileman.filename + '.part', conlimiterfileman.filename)

        self.sortdir = 2

        #print '=========================================================================='
        #print 'TEMPLATES :'
        #for t in self.templates:
        #    print t, ':', self.templates[t].conlimiters
        #print 'LIMITERS :'
        #for l in self.limiters:
        #    print l, ':', self.limiters[l].templates

        return True

    def onOK(self, event):
        if self.onApply(event):
            self.EndModal(wx.ID_OK)


class ChooseTemplatesDialog(wx.Dialog):
    def __init__(self, conlimiterdlg):
        self.conlimiterdlg = conlimiterdlg
        self.templates = self.conlimiterdlg.templates
        self.utility = self.conlimiterdlg.utility
        self.localize = self.utility.lang.get

        pre = wx.PreDialog()
        pre.Create(conlimiterdlg, -1, self.localize('choosetemplates'))
        self.this = pre.this

        p = wx.Panel(self, -1)
        outerbox = wx.BoxSizer(wx.VERTICAL)

        self.temps = self.templates.keys()
        self.temps.sort(key = unicode.lower)
        #self.checklistbox = wx.CheckListBox(p, -1, choices = self.temps, style = wx.LB_SINGLE)
        #i = 0
        #for t in self.temps:
        #    if t in self.conlimiterdlg.limitedtemplates:
        #        self.checklistbox.Check(i)
        #    i += 1
        self.checklistpanel = wx.lib.scrolledpanel.ScrolledPanel(p, -1, size = (-1, 150), style = wx.TAB_TRAVERSAL | wx.SUNKEN_BORDER)
        checklist = wx.BoxSizer(wx.VERTICAL)
        self.checkboxes = []
        for t in self.temps:
            checkbox = wx.CheckBox(self.checklistpanel, -1, t)
            if t in self.conlimiterdlg.limitedtemplates:
                checkbox.SetValue(True)
            self.checkboxes.append(checkbox)
            checklist.Add(checkbox, 0, wx.TOP | wx.LEFT, 3)
        self.checklistpanel.SetAutoLayout(True)
        self.checklistpanel.SetSizer(checklist)
        self.checklistpanel.SetupScrolling()

        selectallbtn = wx.Button(p, -1, self.localize('selectall'))
        self.Bind(wx.EVT_BUTTON, self.onSelectAll, selectallbtn)

        unselectallbtn = wx.Button(p, -1, self.localize('unselectall'))
        self.Bind(wx.EVT_BUTTON, self.onUnSelectAll, unselectallbtn)

        applybtn = wx.Button(p, -1, self.localize('apply'))
        self.Bind(wx.EVT_BUTTON, self.onApply, applybtn)

        okbtn = wx.Button(p, -1, self.localize('ok'))
        self.Bind(wx.EVT_BUTTON, self.onOK, okbtn)

        cancelbtn = wx.Button(p, wx.ID_CANCEL, self.localize('cancel'))

        selectbuttonbox = wx.BoxSizer(wx.HORIZONTAL)
        selectbuttonbox.Add(selectallbtn, 0, wx.ALL, 5)
        selectbuttonbox.Add(unselectallbtn, 0, wx.ALL, 5)

        buttonbox = wx.BoxSizer(wx.HORIZONTAL)
        buttonbox.Add(applybtn, 0, wx.ALL, 5)
        buttonbox.Add(okbtn, 0, wx.ALL, 5)
        buttonbox.Add(cancelbtn, 0, wx.ALL, 5)

        outerbox.Add(self.checklistpanel, 0, wx.EXPAND | wx.ALL, 5)
        outerbox.Add(selectbuttonbox, 0, wx.ALIGN_CENTER)
        outerbox.Add(buttonbox, 0, wx.ALIGN_CENTER)

        p.SetAutoLayout(True)
        p.SetSizer(outerbox)
        p.Fit()
        self.SetClientSize(p.GetSize())

    def onOK(self, event):
        if self.onApply():
            self.EndModal(wx.ID_OK)

    def onApply(self, event = None):
        i = 0
        self.conlimiterdlg.limitedtemplates[:] = []
        for t in self.temps:
            #if self.checklistbox.IsChecked(i):
            if self.checkboxes[i].IsChecked():
                self.conlimiterdlg.limitedtemplates.append(t)
            i += 1
        self.conlimiterdlg.populateTemplateList()
        self.checklistpanel.SetFocus()
        return True

    def onSelectAll(self, event):
        for i in xrange(len(self.temps)):
            #self.checklistbox.Check(i)
            self.checkboxes[i].SetValue(True)
        self.checklistpanel.SetFocus()

    def onUnSelectAll(self, event):
        for i in xrange(len(self.temps)):
            #self.checklistbox.Check(i, 0)
            self.checkboxes[i].SetValue(False)
        self.checklistpanel.SetFocus()
