##############################################################################
# Module : adddsamedestdlg.py
# Author : Old King Cole
# Date   : 10/15/2005
#
# Description : Dialog when torrents with same destination as torrents already in list are added
#
##############################################################################
import wx
from os import path


class AddSameDestDialog(wx.Dialog):
    def __init__(self, parent, ID, title, torrentname, filename, multifile, loading = True,
                 multibutton = True, pos = wx.DefaultPosition, size = wx.DefaultSize,
                 style = wx.DEFAULT_DIALOG_STYLE & ~ wx.CLOSE_BOX):
        pre = wx.PreDialog()
        pre.Create(parent, ID, title, pos, size, style)
        self.this = pre.this
        self.utility = parent.utility
        self.localize = self.utility.lang.get

        outerbox = wx.BoxSizer(wx.VERTICAL)

        messagebox = wx.StaticBoxSizer(wx.StaticBox(self, -1, ''), wx.VERTICAL)

        torrentnamebox = wx.BoxSizer(wx.HORIZONTAL)
        torrentnamebox.Add(wx.StaticText(self, -1, self.localize('torrentname')))
        torrentnamebox.Add(wx.StaticText(self, -1, torrentname.replace('&', '&&')), 0, wx.LEFT, 5)
        messagebox.Add(torrentnamebox, 0, wx.TOP, 3)
        filenamebox = wx.BoxSizer(wx.HORIZONTAL)
        filenamebox.Add(wx.StaticText(self, -1, self.localize('torrentfilename')))
        filenamebox.Add(wx.StaticText(self, -1, path.split(filename)[1].replace('&', '&&')), 0, wx.LEFT, 5)
        messagebox.Add(filenamebox, 0, wx.TOP, 3)
        messagebox.Add(wx.StaticText(self, -1, self.localize('duplicatedestmsg1')), 0, wx.TOP, 5)
        if loading:
            messagebox.Add(wx.StaticText(self, -1, self.localize('duplicatedestmsg2')), 0, wx.TOP | wx.BOTTOM, 3)

        outerbox.Add(messagebox, 0, wx.TOP, -4)

        if multibutton:
            if loading:
                nbbtn = 3
            else:
                nbbtn = 2
        else:
            nbbtn = 1

        buttonbox = wx.GridSizer(0, nbbtn, vgap = 5, hgap = 5)

        if multibutton:
            changedestbtn = wx.Button(self, -1, self.localize('changedest'), size = (105, -1))
            keepdestbtn = wx.Button(self, -1, self.localize('keepdest'), size = (105, -1))
            buttonbox.Add(changedestbtn)
            buttonbox.Add(keepdestbtn)
            self.Bind(wx.EVT_BUTTON, self.onChangeDest, changedestbtn)
            self.Bind(wx.EVT_BUTTON, self.onKeepDest, keepdestbtn)
            if loading:
                skipbtn = wx.Button(self, -1, self.localize('skip'), size = (105, -1))
                buttonbox.Add(skipbtn)
                self.Bind(wx.EVT_BUTTON, self.onSkip, skipbtn)
        else:
            okbtn = wx.Button(self, -1, self.localize('ok'), size = (105, -1))
            buttonbox.Add(okbtn)
            self.Bind(wx.EVT_BUTTON, self.onOK, okbtn)

        if multifile:
            keepdestallbtn = wx.Button(self, -1, self.localize('keepdestall'), size = (105, -1))
            skipallbtn = wx.Button(self, -1, self.localize('skipall'), size = (105, -1))
            buttonbox.Add(wx.StaticText(self, -1, ''))
            buttonbox.Add(keepdestallbtn)
            buttonbox.Add(skipallbtn)
            self.Bind(wx.EVT_BUTTON, self.onKeepDestAll, keepdestallbtn)
            self.Bind(wx.EVT_BUTTON, self.onSkipAll, skipallbtn)

        outerbox.Add(buttonbox, 0, wx.ALIGN_CENTER | wx.TOP | wx.BOTTOM, 5)

        self.SetAutoLayout(True)
        self.SetSizer(outerbox)
        self.Fit()

    def onChangeDest(self, event):
        self.EndModal(0)

    def onKeepDest(self, event):
        self.EndModal(1)

    def onSkip(self, event):
        self.EndModal(2)

    def onKeepDestAll(self, event):
        self.EndModal(3)

    def onSkipAll(self, event):
        self.EndModal(4)

    def onOK(self, event):
        self.EndModal(0)
