##############################################################################
# Module : addpeerdlg.py
# Author : Old King Cole
# Date   : 04/03/2009
#
# Description : Dialog for adding peers to torrents
#
##############################################################################
import wx, re


class AddPeerDialog(wx.Dialog):
    def __init__(self, parent, ID, torrent, queue, panel, title,
                 pos = wx.DefaultPosition, size = wx.DefaultSize,
                 style = wx.DEFAULT_DIALOG_STYLE):
        pre = wx.PreDialog()
        pre.Create(parent, ID, title, pos, size, style)
        self.this = pre.this
        self.utility = parent.utility
        self.abcparams = parent.abcparams
        self.localize = self.utility.lang.get
        self.torrent = torrent
        self.queue = queue
        self.panel = panel

        outerbox = wx.BoxSizer(wx.VERTICAL)

        peersbox = wx.StaticBoxSizer(wx.StaticBox(self, -1, self.localize('peers')), wx.VERTICAL)

        self.peerslistctl = wx.TextCtrl(self, -1, '\n\n\n\n\n\n\n\n\n\n', style = wx.TE_MULTILINE | wx.HSCROLL | wx.TE_DONTWRAP)
        self.peerslistctl.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        peersbox.Add(self.peerslistctl, 0, wx.EXPAND | wx.TOP, 0)

        peersbox.Add(wx.StaticText(self, -1, self.localize('peershelp')), 0, wx.EXPAND | wx.TOP, 3)

        outerbox.Add(peersbox, 0, wx.EXPAND | wx.ALL, 5)

        applybtn = wx.Button(self, -1, self.localize('apply'), size = (60, -1))
        okbtn = wx.Button(self, -1, self.localize('ok'), size = (60, -1))
        cancelbtn = wx.Button(self, -1, self.localize('cancel'), size = (60, -1))

        buttonbox = wx.BoxSizer(wx.HORIZONTAL)
        buttonbox.Add(applybtn, 0, wx.LEFT, 0)
        buttonbox.Add(okbtn, 0, wx.LEFT, 20)
        buttonbox.Add(cancelbtn, 0, wx.LEFT, 20)

        outerbox.Add(buttonbox, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.BOTTOM | wx.TOP, 6)

        self.SetAutoLayout(True)
        self.SetSizer(outerbox)
        self.Fit()

        # Add events
        ###########################
        self.Bind(wx.EVT_BUTTON, self.onOK, okbtn)
        self.Bind(wx.EVT_BUTTON, self.onApply, applybtn)
        self.Bind(wx.EVT_BUTTON, self.onCancel, cancelbtn)
        self.Bind(wx.EVT_CLOSE, self.onCancel)

        if self.abcparams['addpeerdlgx'] != '-1':
            self.MoveXY(int(self.abcparams['addpeerdlgx']), int(self.abcparams['addpeerdlgy']))

    def onCancel(self, event = None):
        self.EndModal(wx.ID_CANCEL)

    def onApply(self, event):
        rawpeerlist = [s for s in re.split(r'[ \n]', self.peerslistctl.GetValue()) if s]
        if rawpeerlist == ['']:
            rawpeerlistlen = 0
        else:
            rawpeerlistlen = len(rawpeerlist)
        if rawpeerlistlen % 2:
            dlg = wx.MessageDialog(self, message = self.localize('peerlistformaterror'), 
                                   caption = self.localize('abcokcerror'), style = wx.OK | wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False
        peerlist = []
        for i in xrange(0, rawpeerlistlen, 2):
            ip = rawpeerlist[i]
            if ip.find(':') >= 0:
                ipv6_exp = self.utility.expandIPv6(ip)
                if not ipv6_exp:
                    dlg = wx.MessageDialog(self, message = self.localize('peerlistipv6error'),
                                           caption = self.localize('abcokcerror'), style = wx.OK | wx.ICON_ERROR)
                    dlg.ShowModal()
                    dlg.Destroy()
                    return False
                rawpeerlist[i] = ipv6_exp
            peerporttypeerror = False
            try:
                peerport = int(rawpeerlist[i + 1])
            except:
                peerporttypeerror = True
            if peerporttypeerror or peerport < 0 or peerport > 65535:
                dlg = wx.MessageDialog(self, message = self.localize('peerlistporterror'),
                                       caption = self.localize('abcokcerror'), style = wx.OK | wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return False
            peerlist.append((rawpeerlist[i], peerport))

        if self.panel.commandfromlist:
            torrents = [self.queue.proctab[index] for index in self.panel.getSelected()]
        else:
            try:
                index = self.queue.proctab.index(self.torrent)
            except:
                return True
            torrents = [self.torrent]
        peers = []
        for dns in peerlist:
            ip = self.utility.getHostByName(dns[0])
            if ip is not None:
                peers.append(((ip, dns[1]), 0, None, None, 0))
        if peers:
            for t in torrents:
                if not (t.private and self.abcparams['strictprivate'] == '1') and t.abcengine:
                    t.abcengine.dow.addPeers(peers)
        return True

    def onOK(self, event):
        if self.onApply(event):
            self.EndModal(wx.ID_OK)
