##############################################################################
# Module : addduplicatedlg.py
# Author : Old King Cole
# Date   : 10/15/2005
#
# Description : Dialog when duplicate torrents are found
#
##############################################################################
import wx
from binascii import hexlify


class AddDuplicateDialog(wx.Dialog):
    def __init__(self, parent, ID, title, newtorrentname, newfilename, torrent, index, multifile,
                 pos = wx.DefaultPosition, size = wx.DefaultSize, style = wx.DEFAULT_DIALOG_STYLE & ~ wx.CLOSE_BOX):
        self.parent = parent
        self.list = parent.list
        pre = wx.PreDialog()
        pre.Create(parent, ID, title, pos, size, style)
        self.this = pre.this
        self.utility = parent.utility
        self.localize = self.utility.lang.get
        self.torrent = torrent

        outerbox = wx.BoxSizer(wx.VERTICAL)

        messagebox = wx.StaticBoxSizer(wx.StaticBox(self, -1, ''), wx.VERTICAL)

        torrentnamebox = wx.BoxSizer(wx.HORIZONTAL)
        torrentnamebox.Add(wx.StaticText(self, -1, self.localize('torrentname')))
        torrentnamebox.Add(wx.StaticText(self, -1, newtorrentname.replace('&', '&&')), 0, wx.LEFT, 5)
        messagebox.Add(torrentnamebox, 0, wx.TOP, 3)
        filenamebox = wx.BoxSizer(wx.HORIZONTAL)
        filenamebox.Add(wx.StaticText(self, -1, self.localize('torrentfilename')))
        filenamebox.Add(wx.StaticText(self, -1, newfilename.replace('&', '&&')), 0, wx.LEFT, 5)
        messagebox.Add(filenamebox, 0, wx.TOP, 3)
        messagebox.Add(wx.StaticText(self, -1, self.localize('duplicatetorrentmsg1') % (index + 1)), 0, wx.TOP, 5)
        messagebox.Add(wx.TextCtrl(self, -1, torrent.name, style = wx.TE_READONLY), 0, wx.EXPAND | wx.TOP, 3)
        infohashbox = wx.BoxSizer(wx.HORIZONTAL)
        infohashbox.Add(wx.StaticText(self, -1, self.localize('duplicatetorrentmsg2')), 0, wx.ALIGN_CENTER_VERTICAL)
        infohashbox.Add(wx.TextCtrl(self, -1, hexlify(torrent.infohash), style = wx.TE_READONLY), 1, wx.EXPAND | wx.LEFT, 5)
        messagebox.Add(infohashbox, 0, wx.EXPAND | wx.TOP | wx.BOTTOM, 3)

        locatebtn = wx.Button(self, -1, self.localize('locate'), size = (-1, self.utility.buttonheight), style = wx.BU_EXACTFIT)
        deffont = locatebtn.GetFont()
        deffont.SetPointSize(7)
        locatebtn.SetFont(deffont)
        self.Bind(wx.EVT_BUTTON, self.onLocate, locatebtn)
        messagebox.Add(locatebtn, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.BOTTOM, 5)

        messagebox.Add(wx.StaticText(self, -1, self.localize('duplicatetorrentmsg3')), 0, wx.BOTTOM, 3)

        outerbox.Add(messagebox, 0, wx.TOP, -4)

        buttonbox = wx.GridSizer(0, 2, vgap = 5, hgap = 5)
        skipbtn = wx.Button(self, -1, self.localize('skip'), size = (80, -1))
        overwritebtn = wx.Button(self, -1, self.localize('overwrite'), size = (80, -1))
        buttonbox.Add(overwritebtn)
        buttonbox.Add(skipbtn)

        self.Bind(wx.EVT_BUTTON, self.onOverwrite, overwritebtn)
        self.Bind(wx.EVT_BUTTON, self.onSkip, skipbtn)

        if multifile:
            overwriteallbtn = wx.Button(self, -1, self.localize('overwriteall'), size = (80, -1))
            skipallbtn = wx.Button(self, -1, self.localize('skipall'), size = (80, -1))
            buttonbox.Add(overwriteallbtn)
            buttonbox.Add(skipallbtn)

            self.Bind(wx.EVT_BUTTON, self.onOverwriteAll, overwriteallbtn)
            self.Bind(wx.EVT_BUTTON, self.onSkipAll, skipallbtn)

        outerbox.Add(buttonbox, 0, wx.ALIGN_CENTER | wx.TOP | wx.BOTTOM, 5)

        self.SetAutoLayout(True)
        self.SetSizer(outerbox)
        self.Fit()

    def onLocate(self, event):
        # Unselect all torrents in main ABC list
        for index in self.parent.getSelected():
            self.list.SetItemState(index, 0, wx.LIST_STATE_SELECTED)
        try:
            index = self.parent.queue.proctab.index(self.torrent)
        except:
            dlg = wx.MessageDialog(self, self.localize('errortorrentnolongerinlist'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return
        self.list.EnsureVisible(index)
        self.list.Select(index)
        if not self.parent.list.IsShown():
            self.parent.parent.tb.ToggleTool(self.parent.parent.maintoolbarids[0], True)
            self.parent.displayTransfer()

    def onOverwrite(self, event):
        self.EndModal(0)

    def onSkip(self, event):
        self.EndModal(1)

    def onOverwriteAll(self, event):
        self.EndModal(2)

    def onSkipAll(self, event):
        self.EndModal(3)
