##############################################################################
# Module : abcoption.py
# Author :
# Date   :
# Updated and modified for ABC_OKC : Old King Cole
#
# Description : ABC_OKC preferences dialog
#
##############################################################################
import sys, wx, win32con
from time import clock, time
from os import path, listdir, remove
from string import whitespace

import wx.lib.masked as masked
from win32api import RegCreateKey, RegSetValueEx, RegCloseKey

from BitTornado.natpunch import setPeerID
from BitTornado.BTcrypto import CRYPTO_OK
from BitTornado.__init__ import setUserAgent, resetPeerID, resetUserPeerID, createPeerID, updateIdRandoms, getIdRandoms
from BitTornado.buffer import PIECEREADBUFFERPOOL, GENBUFFERPOOL
from BitTornado.utility import sysencoding

from filemanager import *
from utility import SpinBox, ScrolledMessageDialog


class ABCOptionDialog(wx.Dialog):
    def __init__(self, parent, ID, title,
                 pos = wx.DefaultPosition, size = wx.DefaultSize,
                 style = wx.DEFAULT_DIALOG_STYLE, tab = None):
        pre = wx.PreDialog()
        pre.Create(parent, ID, title, pos, size, style)
        self.this = pre.this
        self.parent = parent
        self.utility = self.parent.utility
        self.localize = self.utility.lang.get
        self.queue = self.parent.window.queue
        self.list = self.parent.window.list
        self.abcparams = self.utility.abcparams
        self.numsim = 0
        self.advancedMenuBox = None
        self.listfontface = self.abcparams['listfont']
        self.listfontsize = int(self.abcparams['listfontsize'])
        self.listfontstyle = int(self.abcparams['listfontstyle'])
        self.listfontweight = int(self.abcparams['listfontweight'])
        self.tabhaschanged = False

        self.notebook = wx.Notebook(self, -1)
        self.notebook.SetPadding((4, 3))
        self.notebook.AddPage(self.makeLimitsPanel(self.notebook), self.localize('limitssetting'))
        self.notebook.AddPage(self.makeQueuePanel(self.notebook), self.localize('queuesetting'))
        self.notebook.AddPage(self.makeURMActivityPanel(self.notebook), self.localize('urmsetting'))
        self.notebook.AddPage(self.makeNetworkPanel(self.notebook), self.localize('networksetting'))
        self.notebook.AddPage(self.makeListPanel(self.notebook), self.localize('listsetting'))
        self.notebook.AddPage(self.makeInterfacePanel(self.notebook), self.localize('interfacesetting'))
        self.notebook.AddPage(self.makeMiscPanel(self.notebook), self.localize('miscsetting'))
        self.notebook.SetAutoLayout(True)

        advbtn = wx.Button(self, -1, self.localize('advsetting'))
        applybtn = wx.Button(self, -1, self.localize('apply'), size = (60, -1))
        okbtn = wx.Button(self, -1, self.localize('ok'), size = (60, -1))
        cancelbtn = wx.Button(self, -1, self.localize('cancel'), size = (60, -1))

        buttonbox = wx.BoxSizer(wx.HORIZONTAL)
        buttonbox.Add(advbtn, 0, wx.ALL, 5)
        buttonbox.Add(applybtn, 0, wx.ALL, 5)
        buttonbox.Add(okbtn, 0, wx.ALL, 5)
        buttonbox.Add(cancelbtn, 0, wx.ALL, 5)

        outerbox = wx.BoxSizer(wx.VERTICAL)
        outerbox.Add(self.notebook, 0, wx.LEFT | wx.RIGHT | wx.TOP, 5)
        outerbox.Add(buttonbox, 0, wx.ALIGN_CENTER)

        self.SetAutoLayout(True)
        self.SetSizer(outerbox)
        self.Fit()
        self.maxpage = self.notebook.GetPageCount() - 1
        if tab is None:
            opentab = min(int(self.abcparams['lastopenabcoptab']), self.maxpage)
        else:
            opentab = tab
        self.notebook.SetSelection(opentab)

        # Add events
        ###########################
        self.Bind(wx.EVT_BUTTON, self.onOK, okbtn)
        self.Bind(wx.EVT_BUTTON, self.onApply, applybtn)
        self.Bind(wx.EVT_BUTTON, self.onAdvSetting, advbtn)
        self.Bind(wx.EVT_BUTTON, self.onCancel, cancelbtn)
        self.Bind(wx.EVT_CLOSE, self.onCancel)
        self.Bind(wx.EVT_MOUSEWHEEL, self.onMouseWheel)
        self.Bind(wx.EVT_NOTEBOOK_PAGE_CHANGED, self.onPageChanged, self.notebook)

        if self.movedatastatus.GetSelection():
            self.completedresumedelaytext.Hide()
            self.completedresumedelay.Hide()
            self.completedresumedelayunit.Hide()
        else:
            self.completedresumedelaytext.Show()
            self.completedresumedelay.Show()
            self.completedresumedelayunit.Show()

        if self.abcparams['abcoptiondlgx'] != '-1':
            self.MoveXY(int(self.abcparams['abcoptiondlgx']), int(self.abcparams['abcoptiondlgy']))

    def onPageChanged(self, event):
        self.tabhaschanged = True
        event.Skip()

    def getLanguages(self):
        langpath = path.join(self.utility.abcpath, "lang")
        dirlist = listdir(langpath)
        dirlist2 = []
        for filename in dirlist:
            if filename[-5:] == '.lang':
                dirlist2.append(filename)
        dirlist2.sort()

        langfiles = []
        langnames = []
        for filename in dirlist2:
            filepath = path.join(langpath, filename)
            f = open(filepath, "r")
            firstline = True
            while True:
                configline = f.readline()
                if configline == "":
                    break
                if firstline:
                    firstline = False
                    if configline[:3] == '\xef\xbb\xbf':
                        self.encoding = 'utf_8'
                        # Skip BOM
                        configline = configline[3:]
                        if configline == "":
                            break
                        if configline == "\n" or configline[0] == '#':
                            continue
                    else:
                        self.encoding = sysencoding
                if configline == "\n" or configline[0] == '#':
                    continue
                configmap = configline.decode(self.encoding).split("=", 1)
                if configmap[0] == 'languagename':
                    langfiles.append(filename)
                    langnames.append(configmap[1][1:-2])
                break
            f.close()

        return langfiles, langnames

    # Down and up Limits Setting
    ############################
    def makeLimitsPanel(self, parent):
        p = wx.Panel(parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)

        globalbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('globallimits')), wx.VERTICAL)

        self.numsimtext = SpinBox(p, header = self.localize('maxnumsimul'), value = self.abcparams['numsimdownload'],
                                  width = 43, height = self.utility.digitheight, max = 99999)

        globalbox.Add(self.numsimtext.getSizer(), 0, wx.TOP, 0)

        self.numsimseedtext = SpinBox(p, header = self.localize('maxnumsimulseed'), value = self.abcparams['numsimseed'],
                                      width = 43, height = self.utility.digitheight, max = 99999)

        globalbox.Add(self.numsimseedtext.getSizer(), 0, wx.TOP, 10)

        numsimseednodown = wx.BoxSizer(wx.HORIZONTAL)
        self.numsimseednodowntext = SpinBox(p, header = self.localize('maxnumsimulseednodown'), value = self.abcparams['numsimseednodown'],
                                            width = 43, height = self.utility.digitheight, max = 99999)
        numsimseednodown.Add(self.numsimseednodowntext.getSizer(), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 20)

        globalbox.Add(numsimseednodown, 0, wx.ALIGN_CENTER_VERTICAL | wx.TOP, 3)

        downbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('downloadlimits')), wx.VERTICAL)

        maxoveralldownload = wx.BoxSizer(wx.HORIZONTAL)
        self.downloadrate = wx.TextCtrl(p, -1, self.abcparams['maxdownloadrate'], wx.Point(-1, -1),
                                        wx.Size(49, self.utility.digitheight), style = wx.TE_RIGHT)        
        self.downloadrate.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.downloadrate.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        self.downloadrate.SetToolTipString(self.localize('0isnolimittt'))
        maxoveralldownload.Add(wx.StaticText(p, -1, self.localize('maxoverdownloadrate')), 0, wx.ALIGN_CENTER_VERTICAL)
        maxoveralldownload.Add(self.downloadrate, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        maxoveralldownload.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL)

        downbox.Add(maxoveralldownload, 0, wx.TOP, 0)

        downvolcheckbox = wx.BoxSizer(wx.HORIZONTAL)

        self.downvolcheck = wx.CheckBox(p, -1, self.localize('downvolcheck'))
        if self.abcparams['downvolcheck'] == "1":
            self.downvolcheck.SetValue(True)
        downvolcheckbox.Add(self.downvolcheck, 0, wx.ALIGN_CENTER_VERTICAL)

        self.downvolmax = wx.TextCtrl(p, -1, self.abcparams['downvolmax'], wx.Point(-1, -1),
                                      wx.Size(40, self.utility.digitheight), style = wx.TE_RIGHT)
        self.downvolmax.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDot)
        downvolcheckbox.Add(self.downvolmax, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)

        downvolcheckbox.Add(wx.StaticText(p, -1, self.utility.gb), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        downvolcheckbox.Add(wx.StaticText(p, -1,self.localize('over')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        dtime, htime = divmod(int(self.abcparams['downvolcountdur']), 24)
        self.downvolcountdurd = wx.TextCtrl(p, -1, str(dtime), (-1, -1), (31, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.downvolcountdurd.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.downvolcountdurd.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        downvolcheckbox.Add(self.downvolcountdurd, 0, wx.LEFT, 5)
        downvolcheckbox.Add(wx.StaticText(p, -1, self.localize('l_day')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.downvolcountdurh = wx.TextCtrl(p, -1, str(htime), (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.downvolcountdurh.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.downvolcountdurh.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        downvolcheckbox.Add(self.downvolcountdurh, 0, wx.LEFT, 3)
        downvolcheckbox.Add(wx.StaticText(p, -1, self.localize('l_hour')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)

        downbox.Add(downvolcheckbox, 0, wx.TOP, 10)

        self.downvolwinsliding = wx.RadioButton(p, -1, self.localize('volwinslidingtxt'), style = wx.RB_GROUP)
        downvolwinfixed = wx.RadioButton(p, -1, self.localize('volwinfixedtxt'))
        if self.abcparams['downvolwindowtype'] == "0":
            self.downvolwinsliding.SetValue(True)
        else:
            downvolwinfixed.SetValue(True)

        downvolwinslidingbox = wx.BoxSizer(wx.HORIZONTAL)
        downvolwinslidingbox.Add(self.downvolwinsliding, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 20)
        self.downvolmargin = wx.TextCtrl(p, -1, self.abcparams['downvolmargin'], wx.Point(-1, -1),
                                         wx.Size(40, self.utility.digitheight), style = wx.TE_RIGHT)
        self.downvolmargin.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDot)
        downvolwinslidingbox.Add(self.downvolmargin, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)
        downvolwinslidingbox.Add(wx.StaticText(p, -1, self.localize('percent')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        buttonlabel = self.localize('reset')
        buttonwidth = self.GetTextExtent(buttonlabel)[0] + 12
        buttonlabel = buttonlabel.replace('&', '&&')
        downvolwinslidingresetbtn = wx.Button(p, -1, buttonlabel, size = wx.Size(buttonwidth, self.utility.buttonheight))
        self.Bind(wx.EVT_BUTTON, self.onResetDownVolSlidingWindow, downvolwinslidingresetbtn)
        downvolwinslidingbox.Add(downvolwinslidingresetbtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 8)

        downbox.Add(downvolwinslidingbox, 0, wx.TOP, 3)

        downvolwinfixedbox = wx.BoxSizer(wx.HORIZONTAL)
        downvolwinfixedbox.Add(downvolwinfixed, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 20)
        self.downvolwinfixeddatetime = DateTime(p, self.utility, self.localize, wx.DateTimeFromTimeT(int(self.abcparams['downvolchecktime'])))
        downvolwinfixedbox.Add(self.downvolwinfixeddatetime.getSizer(), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)
        downvolwinfixedresetbtn = wx.Button(p, -1, buttonlabel, size = wx.Size(buttonwidth, self.utility.buttonheight))
        self.Bind(wx.EVT_BUTTON, self.onResetDownVolFixedWindow, downvolwinfixedresetbtn)
        downvolwinfixedbox.Add(downvolwinfixedresetbtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 8)

        downbox.Add(downvolwinfixedbox, 0, wx.TOP, 3)

        nbpiecesfixbox = wx.BoxSizer(wx.HORIZONTAL)

        self.nbpiecesfix = wx.CheckBox(p, -1, self.localize('nbpiecesfix'))
        if self.abcparams['nbpiecesfix'] == "1":
            self.nbpiecesfix.SetValue(True)
        nbpiecesfixbox.Add(self.nbpiecesfix, 0, wx.ALIGN_CENTER_VERTICAL)

        self.nbpiecesfixmaxdownrate = wx.TextCtrl(p, -1, self.abcparams['nbpiecesfixmaxdownrate'], wx.Point(-1, -1),
                                      wx.Size(49, self.utility.digitheight), style = wx.TE_RIGHT)
        self.nbpiecesfixmaxdownrate.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.nbpiecesfixmaxdownrate.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        nbpiecesfixbox.Add(self.nbpiecesfixmaxdownrate, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)

        nbpiecesfixbox.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        nbpiecesfixbox.Add(wx.StaticText(p, -1,self.localize('nbpiecesfix2')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        self.nbpiecesfixtrigger = wx.TextCtrl(p, -1, self.abcparams['nbpiecesfixtrigger'], wx.Point(-1, -1),
                                  wx.Size(49, self.utility.digitheight), style = wx.TE_RIGHT)
        self.nbpiecesfixtrigger.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.nbpiecesfixtrigger.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        nbpiecesfixbox.Add(self.nbpiecesfixtrigger, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        nbpiecesfixbox.Add(wx.StaticText(p, -1,self.localize('nbpiecesfix3')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        downbox.Add(nbpiecesfixbox, 0, wx.TOP, 10)

        piecesizefixbox = wx.BoxSizer(wx.HORIZONTAL)

        piecesizefixbox.Add(wx.StaticText(p, -1, self.localize('nbpiecesfix4')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 16)

        self.piecesizefixtrigger = wx.TextCtrl(p, -1, self.abcparams['piecesizefixtrigger'], wx.Point(-1, -1),
                                   wx.Size(43, self.utility.digitheight), style = wx.TE_RIGHT)
        self.piecesizefixtrigger.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.piecesizefixtrigger.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        piecesizefixbox.Add(self.piecesizefixtrigger, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        piecesizefixbox.Add(wx.StaticText(p, -1, self.utility.kb), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        downbox.Add(piecesizefixbox, 0, wx.TOP, 3)

        upbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('uploadlimits')), wx.VERTICAL)

        statmaxuprate = wx.RadioButton(p, -1, self.localize('statmaxupratetxt'), style = wx.RB_GROUP)
        self.urmdynmaxuprate = wx.RadioButton(p, -1, self.localize('urmdynmaxupratetxt'))
        if self.abcparams['urmdynmaxuprate'] == "1":
            self.urmdynmaxuprate.SetValue(True)
        else:
            statmaxuprate.SetValue(True)

        upbox.Add(statmaxuprate, 0, wx.TOP, 0)

        maxoveralldown = wx.BoxSizer(wx.HORIZONTAL)
        self.uploadrate = wx.TextCtrl(p, -1, self.abcparams['maxuploadrate'], wx.Point(-1, -1),
                                      wx.Size(49, self.utility.digitheight), style = wx.TE_RIGHT)        
        self.uploadrate.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.uploadrate.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        self.uploadrate.SetToolTipString(self.localize('0isnolimittt'))
        maxoveralldown.Add(wx.StaticText(p, -1, self.localize('whendownload')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 20)
        maxoveralldown.Add(self.uploadrate, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        maxoveralldown.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL)

        upbox.Add(maxoveralldown, 0, wx.TOP, 3)

        maxoverallnodown = wx.BoxSizer(wx.HORIZONTAL)
        self.seeduploadrate = wx.TextCtrl(p, -1, self.abcparams['maxseeduploadrate'], wx.Point(-1, -1),
                                          wx.Size(49, self.utility.digitheight), style = wx.TE_RIGHT)
        self.seeduploadrate.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.seeduploadrate.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        self.seeduploadrate.SetToolTipString(self.localize('0isnolimittt'))
        maxoverallnodown.Add(wx.StaticText(p, -1, self.localize('whennodownload')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 20)
        maxoverallnodown.Add(self.seeduploadrate, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        maxoverallnodown.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL)

        upbox.Add(maxoverallnodown, 0, wx.TOP, 3)

        upbox.Add(self.urmdynmaxuprate, 0, wx.TOP, 3)

        urmmaxsysuprate = wx.BoxSizer(wx.HORIZONTAL)
        self.urmmaxsysupratetext = wx.TextCtrl(p, -1, self.abcparams['urmmaxsysuprate'], wx.Point(-1, -1),
                                               wx.Size(49, self.utility.digitheight), style = wx.TE_RIGHT)
        self.urmmaxsysupratetext.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.urmmaxsysupratetext.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        self.urmmaxsysupratetext.SetToolTipString(self.localize('0isnolimittt'))
        urmmaxsysuprate.Add(wx.StaticText(p, -1, self.localize('urmmaxsysuprate')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 20)
        urmmaxsysuprate.Add(self.urmmaxsysupratetext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        urmmaxsysuprate.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL)

        upbox.Add(urmmaxsysuprate, 0, wx.TOP, 3)

        upvolcheckbox = wx.BoxSizer(wx.HORIZONTAL)

        self.upvolcheck = wx.CheckBox(p, -1, self.localize('upvolcheck'))
        if self.abcparams['upvolcheck'] == "1":
            self.upvolcheck.SetValue(True)
        upvolcheckbox.Add(self.upvolcheck, 0, wx.ALIGN_CENTER_VERTICAL)

        self.upvolmax = wx.TextCtrl(p, -1, self.abcparams['upvolmax'], wx.Point(-1, -1),
                                    wx.Size(40, self.utility.digitheight), style = wx.TE_RIGHT)
        self.upvolmax.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDot)
        upvolcheckbox.Add(self.upvolmax, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)

        upvolcheckbox.Add(wx.StaticText(p, -1, self.utility.gb), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        upvolcheckbox.Add(wx.StaticText(p, -1,self.localize('over')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        dtime, htime = divmod(int(self.abcparams['upvolcountdur']), 24)
        self.upvolcountdurd = wx.TextCtrl(p, -1, str(dtime), (-1, -1), (31, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.upvolcountdurd.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.upvolcountdurd.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        upvolcheckbox.Add(self.upvolcountdurd, 0, wx.LEFT, 5)
        upvolcheckbox.Add(wx.StaticText(p, -1, self.localize('l_day')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.upvolcountdurh = wx.TextCtrl(p, -1, str(htime), (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.upvolcountdurh.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.upvolcountdurh.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        upvolcheckbox.Add(self.upvolcountdurh, 0, wx.LEFT, 3)
        upvolcheckbox.Add(wx.StaticText(p, -1, self.localize('l_hour')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)

        upbox.Add(upvolcheckbox, 0, wx.TOP, 10)

        self.upvolwinsliding = wx.RadioButton(p, -1, self.localize('volwinslidingtxt'), style = wx.RB_GROUP)
        upvolwinfixed = wx.RadioButton(p, -1, self.localize('volwinfixedtxt'))
        if self.abcparams['upvolwindowtype'] == "0":
            self.upvolwinsliding.SetValue(True)
        else:
            upvolwinfixed.SetValue(True)

        upvolwinslidingbox = wx.BoxSizer(wx.HORIZONTAL)
        upvolwinslidingbox.Add(self.upvolwinsliding, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 20)
        self.upvolmargin = wx.TextCtrl(p, -1, self.abcparams['upvolmargin'], wx.Point(-1, -1),
                                       wx.Size(40, self.utility.digitheight), style = wx.TE_RIGHT)
        self.upvolmargin.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDot)
        upvolwinslidingbox.Add(self.upvolmargin, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)
        upvolwinslidingbox.Add(wx.StaticText(p, -1, self.localize('percent')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        upvolwinslidingresetbtn = wx.Button(p, -1, buttonlabel, size = wx.Size(buttonwidth, self.utility.buttonheight))
        self.Bind(wx.EVT_BUTTON, self.onResetUpVolSlidingWindow, upvolwinslidingresetbtn)
        upvolwinslidingbox.Add(upvolwinslidingresetbtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 8)

        upbox.Add(upvolwinslidingbox, 0, wx.TOP, 3)

        upvolwinfixedbox = wx.BoxSizer(wx.HORIZONTAL)
        upvolwinfixedbox.Add(upvolwinfixed, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 20)
        self.upvolwinfixeddatetime = DateTime(p, self.utility, self.localize, wx.DateTimeFromTimeT(int(self.abcparams['upvolchecktime'])))
        upvolwinfixedbox.Add(self.upvolwinfixeddatetime.getSizer(), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)
        upvolwinfixedresetbtn = wx.Button(p, -1, buttonlabel, size = wx.Size(buttonwidth, self.utility.buttonheight))
        self.Bind(wx.EVT_BUTTON, self.onResetUpVolFixedWindow, upvolwinfixedresetbtn)
        upvolwinfixedbox.Add(upvolwinfixedresetbtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 8)

        upbox.Add(upvolwinfixedbox, 0, wx.TOP, 3)

        upbox.Add(wx.StaticText(p, -1, self.localize('upwithoutdowntitle')), 0, wx.TOP, 10)

        upwithoutdowncheckbox = wx.BoxSizer(wx.HORIZONTAL)

        self.upwithoutdown = wx.CheckBox(p, -1, self.localize('upwithoutdown'))
        if self.abcparams['upwithoutdown'] == "1":
            self.upwithoutdown.SetValue(True)
        upwithoutdowncheckbox.Add(self.upwithoutdown, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 20)

        self.upwithoutdowntime = wx.TextCtrl(p, -1, self.abcparams['upwithoutdowntime'], (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.upwithoutdowntime.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.upwithoutdowntime.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        upwithoutdowncheckbox.Add(self.upwithoutdowntime, 0, wx.LEFT, 3)
        upwithoutdowncheckbox.Add(wx.StaticText(p, -1, self.localize('l_hour')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)
        self.upwithoutdowntimemn = wx.TextCtrl(p, -1, self.abcparams['upwithoutdowntimemn'], (-1, -1), (25, self.utility.timedurationstyle[0]), style = self.utility.timedurationstyle[1])
        self.upwithoutdowntimemn.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.upwithoutdowntimemn.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        upwithoutdowncheckbox.Add(self.upwithoutdowntimemn, 0, wx.LEFT, 3)
        upwithoutdowncheckbox.Add(wx.StaticText(p, -1, self.localize('l_minute')), 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 2)

        upbox.Add(upwithoutdowncheckbox, 0, wx.TOP, 3)

        upwithoutdown2checkbox = wx.BoxSizer(wx.HORIZONTAL)

        self.upwithoutdown2 = wx.CheckBox(p, -1, self.localize('upwithoutdown2'))
        if self.abcparams['upwithoutdown2'] == "1":
            self.upwithoutdown2.SetValue(True)
        upwithoutdown2checkbox.Add(self.upwithoutdown2, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 20)

        self.upwithoutdownrate = wx.TextCtrl(p, -1, self.abcparams['upwithoutdownrate'], (-1, -1), wx.Size(49, self.utility.digitheight), style = wx.TE_RIGHT)
        self.upwithoutdownrate.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.upwithoutdownrate.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        upwithoutdown2checkbox.Add(self.upwithoutdownrate, 0, wx.LEFT, 3)
        upwithoutdown2checkbox.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        upbox.Add(upwithoutdown2checkbox, 0, wx.TOP, 3)

        sizer.Add(globalbox, 0, wx.EXPAND | wx.TOP, 3)
        sizer.Add(downbox, 0, wx.EXPAND | wx.TOP, 3)
        sizer.Add(upbox, 0, wx.EXPAND | wx.TOP, 3)

        p.SetSizer(sizer)
        p.SetAutoLayout(True)

        return p

    # Queue Setting
    ##########################
    def makeQueuePanel(self, parent):
        p = wx.Panel(parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)

        queuetopbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('mainschedulertitle')), wx.VERTICAL)

        trignextafterdown = wx.RadioButton(p, -1, self.localize('trignexttorrentafterdown'), style = wx.RB_GROUP)
        trignextafterseed = wx.RadioButton(p, -1, self.localize('trignexttorrentafterseed'))
        trignextonlyseed = wx.RadioButton(p, -1, self.localize('trignexttorrentonlyseed'))
        self.trig_finish_seed = [trignextafterdown, trignextafterseed, trignextonlyseed]
        self.trig_finish_seed[int(self.abcparams['trigwhenfinishseed'])].SetValue(True)

        queuetopbox.Add(trignextafterdown, 0, wx.TOP, 0)
        queuetopbox.Add(wx.StaticText(p, -1, self.localize('trignexttorrentafterdown2')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 16)
        queuetopbox.Add(trignextafterseed, 0, wx.TOP, 3)
        queuetopbox.Add(wx.StaticText(p, -1, self.localize('trignexttorrentafterseed2')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 16)
        queuetopbox.Add(trignextonlyseed, 0, wx.TOP, 3)

        self.defaultpriority = wx.ComboBox(p, -1, '', (-1,-1), (-1, -1),
                                           [self.localize('highest'), self.localize('high'), self.localize('normal'), self.localize('low'), self.localize('lowest')],
                                           wx.CB_DROPDOWN | wx.CB_READONLY)
        self.defaultpriority.SetSelection(int(self.abcparams['defaultpriority']))

        prio_box = wx.BoxSizer(wx.HORIZONTAL)
        prio_box.Add(wx.StaticText(p, -1, self.localize('defaultpriority')), 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
        prio_box.Add(self.defaultpriority, 0, wx.ALIGN_CENTER_VERTICAL)       

        queuetopbox.Add(prio_box, 0, wx.TOP, 10)

        prioritizelocalbox = wx.BoxSizer(wx.HORIZONTAL)

        prioritizelocalbox.Add(wx.StaticText(p, -1, self.localize('prioritizelocal')), 0, wx.ALIGN_LEFT)

        self.prioritizelocaldown = wx.CheckBox(p, -1, self.localize('prioritizelocaldown'))
        if self.abcparams['prioritizelocaldown'] == "1":
            self.prioritizelocaldown.SetValue(True)
        prioritizelocalbox.Add(self.prioritizelocaldown, 0, wx.ALIGN_LEFT | wx.LEFT, 10)

        self.prioritizelocal = wx.CheckBox(p, -1, self.localize('prioritizelocalup'))
        if self.abcparams['prioritizelocal'] == "1":
            self.prioritizelocal.SetValue(True)
        prioritizelocalbox.Add(self.prioritizelocal, 0, wx.ALIGN_LEFT | wx.LEFT, 10)

        queuetopbox.Add(prioritizelocalbox, 0, wx.TOP, 3)

        fastresumebox = wx.BoxSizer(wx.HORIZONTAL)

        fastresumebox.Add(wx.StaticText(p, -1, self.localize('fastresumetext')), 0, wx.ALIGN_LEFT)

        self.fastresume = wx.CheckBox(p, -1, self.localize('fastresume'))
        if self.abcparams['fastresume'] == "1":
            self.fastresume.SetValue(True)
        fastresumebox.Add(self.fastresume, 0, wx.ALIGN_LEFT | wx.LEFT, 10)

        self.fastresumefirst = wx.CheckBox(p, -1, self.localize('fastresumefirst'))
        if self.abcparams['fastresumefirst'] == "1":
            self.fastresumefirst.SetValue(True)
        fastresumebox.Add(self.fastresumefirst, 0, wx.ALIGN_LEFT | wx.LEFT, 10)

        queuetopbox.Add(fastresumebox, 0, wx.TOP, 3)

        self.sbqueued = wx.CheckBox(p, -1, self.localize('sbqueued'))
        if self.abcparams['sbqueued'] == "1":
            self.sbqueued.SetValue(True)

        queuetopbox.Add(self.sbqueued, 0, wx.TOP, 3)

        self.countsbasseed = wx.CheckBox(p, -1, self.localize('countsbasseed'))
        if self.abcparams['countsbasseed'] == "1":
            self.countsbasseed.SetValue(True)

        queuetopbox.Add(self.countsbasseed, 0, wx.TOP, 3)

        self.schedonhold = wx.CheckBox(p, -1, self.localize('schedonhold'))
        if self.abcparams['schedonhold'] == "1":
            self.schedonhold.SetValue(True)

        queuetopbox.Add(self.schedonhold, 0, wx.TOP, 3)

        self.schedstopsman = wx.CheckBox(p, -1, self.localize('schedstopsman'))
        if self.abcparams['schedstopsman'] == "1":
            self.schedstopsman.SetValue(True)

        queuetopbox.Add(self.schedstopsman, 0, wx.TOP, 3)

        self.scheddonthalt = wx.CheckBox(p, -1, self.localize('scheddonthalt'))
        if self.abcparams['scheddonthalt'] == "1":
            self.scheddonthalt.SetValue(True)
        self.scheddonthaltuprategap = wx.TextCtrl(p, -1, self.abcparams['scheddonthaltuprategap'], wx.Point(-1, -1),
                                                  wx.Size(49, self.utility.digitheight), style = wx.TE_RIGHT)        
        self.scheddonthaltuprategap.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.scheddonthaltuprategap.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        scheddonthaltbox = wx.BoxSizer(wx.HORIZONTAL)
        scheddonthaltbox.Add(self.scheddonthalt, 0, wx.ALIGN_CENTER_VERTICAL)
        scheddonthaltbox.Add(self.scheddonthaltuprategap, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)
        scheddonthaltbox.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        queuetopbox.Add(scheddonthaltbox, 0, wx.TOP, 3)

        self.lockedcompletedcheck = wx.CheckBox(p, -1, self.localize('lockedcompletedcheck'))
        if self.abcparams['lockedcompletedcheck'] == "1":
            self.lockedcompletedcheck.SetValue(True)
        self.lockedcompletedmaxtext = SpinBox(p, value = self.abcparams['lockedcompletedmax'],
                                              width = 43, height = self.utility.digitheight, max = 99999)
        lockedcompletedbox = wx.BoxSizer(wx.HORIZONTAL)
        lockedcompletedbox.Add(self.lockedcompletedcheck, 0, wx.ALIGN_CENTER_VERTICAL)
        lockedcompletedbox.Add(self.lockedcompletedmaxtext.getSizer(), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)
        lockedcompletedbox.Add(wx.StaticText(p, -1, self.localize('lockedcompletedmax')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        queuetopbox.Add(lockedcompletedbox, 0, wx.TOP, 3)

        self.stoprejected = wx.CheckBox(p, -1, self.localize('stoprejected'))
        if self.abcparams['stoprejected'] == "1":
            self.stoprejected.SetValue(True)

        queuetopbox.Add(self.stoprejected, 0, wx.TOP, 3)

        rejectexceptionsbox = wx.BoxSizer(wx.HORIZONTAL)
        rejectexceptionsbox.Add(wx.StaticText(p, -1, self.localize('rejectexceptions')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 20)
        self.rejectexceptions = wx.TextCtrl(p, -1, self.abcparams['rejectexceptions'])
        self.rejectexceptions.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.rejectexceptions.Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
        rejectexceptionsbox.Add(self.rejectexceptions, 1, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND | wx.LEFT, 5)

        queuetopbox.Add(rejectexceptionsbox, 0,  wx.EXPAND | wx.TOP, 3)

        sizer.Add(queuetopbox, 0, wx.EXPAND | wx.TOP, 3)

        torrenttimeoutbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('globaltorrentimeout')), wx.VERTICAL)

        self.timeoutwhenextra = wx.CheckBox(p, -1, self.localize('timeoutwhenextra'))
        if self.abcparams['timeoutwhenextra'] == "1":
            self.timeoutwhenextra.SetValue(True)

        torrenttimeoutbox.Add(self.timeoutwhenextra, 0, wx.TOP, 3)

        canceltimeoutsbox = wx.BoxSizer(wx.HORIZONTAL)
        self.canceltimeouts = wx.CheckBox(p, -1, self.localize('canceltimeouts'))
        if self.abcparams['canceltimeouts'] == "1":
            self.canceltimeouts.SetValue(True)
        canceltimeoutsbox.Add(self.canceltimeouts, 0, wx.ALIGN_CENTER_VERTICAL)

        self.canceltimeoutsmsg = wx.TextCtrl(p, -1, self.abcparams['canceltimeoutsmsg'])
        self.canceltimeoutsmsg.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.canceltimeoutsmsg.Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
        canceltimeoutsbox.Add(self.canceltimeoutsmsg, 1, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND | wx.LEFT, 2)

        torrenttimeoutbox.Add(canceltimeoutsbox, 0, wx.EXPAND | wx.TOP, 3)

        self.resettimeoutsonstart = wx.CheckBox(p, -1, self.localize('resettimeoutsonstart'))
        if self.abcparams['resettimeoutsonstart'] == "1":
            self.resettimeoutsonstart.SetValue(True)

        torrenttimeoutbox.Add(self.resettimeoutsonstart, 0, wx.TOP, 3)

        sbtimeoutbox = wx.BoxSizer(wx.HORIZONTAL)
        self.sbtimeout = wx.CheckBox(p, -1, self.localize('sbtimeout'))
        if self.abcparams['sbtimeout'] == "1":
            self.sbtimeout.SetValue(True)
        sbtimeoutbox.Add(self.sbtimeout, 0, wx.ALIGN_CENTER_VERTICAL)
        self.sbtimeoutvalue = wx.TextCtrl(p, -1, self.abcparams['sbtimeoutvalue'], wx.Point(-1, -1),
                                          wx.Size(30, self.utility.digitheight), style = wx.TE_RIGHT)
        self.sbtimeoutvalue.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.sbtimeoutvalue.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        sbtimeoutbox.Add(self.sbtimeoutvalue, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)
        sbtimeoutbox.Add(wx.StaticText(p, -1, self.localize('sbtimeoutvalue')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        sbtimeoutbox.Add(wx.StaticText(p, -1, self.localize('sbtimeoutaction')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.sbtimeoutaction = wx.ComboBox(p, -1, '', (-1, -1), (-1, -1),
                                           [self.localize('sbtimeoutactionqueue'), self.localize('sbtimeoutactionstop')],
                                           wx.CB_DROPDOWN | wx.CB_READONLY)
        self.sbtimeoutaction.SetSelection(int(self.abcparams['sbtimeoutaction']))
        sbtimeoutbox.Add(self.sbtimeoutaction, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        torrenttimeoutbox.Add(sbtimeoutbox, 0, wx.TOP, 3)
 
        sizer.Add(torrenttimeoutbox, 0, wx.EXPAND | wx.TOP, 3)

        automovesbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('automoves')), wx.VERTICAL)

        self.torrentwhencompleted = wx.ComboBox(p, -1, '', (-1, -1), (-1, -1),
                                                [self.localize('donothing'), self.localize('movetotop'), self.localize('movetotopmaxprio')],
                                                wx.CB_DROPDOWN | wx.CB_READONLY)
        self.torrentwhencompleted.SetSelection(int(self.abcparams['torrentwhencompleted']))
        twcbox = wx.BoxSizer(wx.HORIZONTAL)
        twcbox.Add(wx.StaticText(p, -1, self.localize('torrentcompleted')), 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
        twcbox.Add(self.torrentwhencompleted, 0, wx.ALIGN_CENTER_VERTICAL)       

        automovesbox.Add(twcbox, 0, wx.TOP, 0)

        self.torrentwhenfinished = wx.ComboBox(p, -1, '', (-1, -1), (-1, -1),
                                               [self.localize('donothing'), self.localize('movetotop'), self.localize('deletetorrent')],
                                               wx.CB_DROPDOWN | wx.CB_READONLY)
        self.torrentwhenfinished.SetSelection(int(self.abcparams['torrentwhenfinished']))
        twfbox = wx.BoxSizer(wx.HORIZONTAL)
        twfbox.Add(wx.StaticText(p, -1, self.localize('torrentfinished')), 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
        twfbox.Add(self.torrentwhenfinished, 0, wx.ALIGN_CENTER_VERTICAL)       

        automovesbox.Add(twfbox, 0, wx.TOP, 3)

        self.sortbytime = wx.CheckBox(p, -1, self.localize('sortbytime'))
        if self.abcparams['sortbytime'] == "1":
            self.sortbytime.SetValue(True)

        automovesbox.Add(self.sortbytime, 0, wx.TOP, 3)

        self.sorttoronclose = wx.CheckBox(p, -1, self.localize('sorttoronclose'))
        if self.abcparams['sorttoronclose'] == "1":
            self.sorttoronclose.SetValue(True)

        automovesbox.Add(self.sorttoronclose, 0, wx.TOP, 3)

        sizer.Add(automovesbox, 0, wx.EXPAND | wx.TOP, 3)

        p.SetSizer(sizer)
        p.SetAutoLayout(True)
        return p

    # URM/DRM and activity Setting
    ##############################
    def makeURMActivityPanel(self, parent):
        p = wx.Panel(parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)

        activitybox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('activitytitle')), wx.VERTICAL)

        self.activityextra = wx.CheckBox(p, -1, self.localize('activityextra'))
        if self.abcparams['activityextra'] == "1":
            self.activityextra.SetValue(True)

        activitybox.Add(self.activityextra, 0, wx.TOP, 0)

        extratobestoppedbox = wx.BoxSizer(wx.HORIZONTAL)

        self.extratobestopped = wx.CheckBox(p, -1, self.localize('extratobestopped'),
                                            style = wx.CHK_3STATE | wx.CHK_ALLOW_3RD_STATE_FOR_USER)
        self.extratobestopped.SetToolTipString(self.localize('extratobestoppedtt'))
        self.extratobestopped.Set3StateValue(int(self.abcparams['extratobestopped']))

        activitybox.Add(self.extratobestopped, 0, wx.ALIGN_CENTER_VERTICAL | wx.TOP, 3)

        extratobestoppedfailbox = wx.BoxSizer(wx.HORIZONTAL)
        self.extratobestoppedfail = wx.CheckBox(p, -1, self.localize('extratobestoppedfail'))
        if self.abcparams['extratobestoppedfail'] == "1":
            self.extratobestoppedfail.SetValue(True)
        extratobestoppedfailbox.Add(self.extratobestoppedfail, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 20)

        activitybox.Add(extratobestoppedfailbox, 0, wx.ALIGN_CENTER_VERTICAL | wx.TOP, 3)

        self.activitymaxtext = SpinBox(p, header = self.localize('activitymax'), value = self.abcparams['activitymax'],
                                       width = 43, height = self.utility.digitheight, max = 99999)

        activitybox.Add(self.activitymaxtext.getSizer(), 0, wx.TOP, 3)

        activitythbox = wx.BoxSizer(wx.HORIZONTAL)

        activitythbox.Add(wx.StaticText(p, -1, self.localize('activityth')), 0, wx.ALIGN_CENTER_VERTICAL | wx.ALIGN_LEFT)
        activitythbox.Add(wx.StaticText(p, -1, self.localize('activitythdow')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 7)
        self.activitythdown = wx.TextCtrl(p, -1, self.abcparams['activitythdown'], wx.Point(-1, -1),
                                          wx.Size(45, self.utility.digitheight), style = wx.TE_RIGHT)
        self.activitythdown.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDot)
        activitythbox.Add(self.activitythdown, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        activitythbox.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        activitythbox.Add(wx.StaticText(p, -1, self.localize('activitythup')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 9)
        self.activitythup = wx.TextCtrl(p, -1, self.abcparams['activitythup'], wx.Point(-1, -1),
                                        wx.Size(45, self.utility.digitheight), style = wx.TE_RIGHT)
        self.activitythup.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDot)
        activitythbox.Add(self.activitythup, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        activitythbox.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        activitythbox.Add(wx.StaticText(p, -1, self.localize('activitydelay')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 14)
        self.activitydelay = wx.TextCtrl(p, -1, self.abcparams['activitydelay'], wx.Point(-1, -1),
                                         wx.Size(31, self.utility.digitheight), style = wx.TE_RIGHT)
        self.activitydelay.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.activitydelay.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        activitythbox.Add(self.activitydelay, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        activitythbox.Add(wx.StaticText(p, -1, self.localize('l_second')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        activitybox.Add(activitythbox, 0, wx.TOP, 3)

        sizer.Add(activitybox, 0, wx.EXPAND | wx.TOP, 3)

        drmschedulerbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('drmschedulertitle')), wx.VERTICAL)

        self.drm = wx.CheckBox(p, -1, self.localize('drm'))
        if self.abcparams['drm'] == "1":
            self.drm.SetValue(True)
        drmschedulerbox.Add(self.drm, 0, wx.TOP, 0)

        self.drmonhold = wx.CheckBox(p, -1, self.localize('drmonhold'))
        if self.abcparams['drmonhold'] == "1":
            self.drmonhold.SetValue(True)
        drmschedulerbox.Add(self.drmonhold, 0, wx.TOP, 3)

        self.drmstopsman = wx.CheckBox(p, -1, self.localize('drmstopsman'))
        if self.abcparams['drmstopsman'] == "1":
            self.drmstopsman.SetValue(True)
        drmschedulerbox.Add(self.drmstopsman, 0, wx.TOP, 3)

        self.drmstoponpause = wx.CheckBox(p, -1, self.localize('drmstoponpause'))
        if self.abcparams['drmstoponpause'] == "1":
            self.drmstoponpause.SetValue(True)
        drmschedulerbox.Add(self.drmstoponpause, 0, wx.TOP, 3)

        self.drmmaxtorrenttext = SpinBox(p, header = self.localize('drmmaxtorrent'), value = self.abcparams['drmmaxtorrent'],
                                         width = 43, height = self.utility.digitheight, max = 99999)

        self.drmlowpriority = wx.CheckBox(p, -1, self.localize('drmlowpriority'))
        if self.abcparams['drmlowpriority'] == "1":
            self.drmlowpriority.SetValue(True)
        drmbox1 = wx.BoxSizer(wx.HORIZONTAL)
        drmbox1.Add(self.drmmaxtorrenttext.getSizer(), 0, wx.ALIGN_CENTER_VERTICAL)
        drmbox1.Add(self.drmlowpriority, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 20)
        drmschedulerbox.Add(drmbox1, 0, wx.TOP, 3)

        drmtriggerbox = wx.BoxSizer(wx.HORIZONTAL)
        drmtriggerbox.Add(wx.StaticText(p, -1, self.localize('drmtrigger')), 0, wx.ALIGN_CENTER_VERTICAL)
        drmtriggerb0 = wx.RadioButton(p, -1, self.localize('drmtriggerdownrate'), (-1, -1), (-1, -1), wx.RB_GROUP)
        drmtriggerb1 = wx.RadioButton(p, -1, "", (-1, -1), (-1, -1))
        drmtriggerbox.Add(drmtriggerb0, 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 5)
        drmtriggerbox.Add(drmtriggerb1, 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 5)
        self.drmtriggerval = wx.TextCtrl(p, -1, self.abcparams['drmtriggerval'], wx.Point(-1, -1),
                                         wx.Size(49, self.utility.digitheight), style = wx.TE_RIGHT)        
        self.drmtriggerval.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.drmtriggerval.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        drmtriggerbox.Add(self.drmtriggerval, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 3)
        drmtriggerbox.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        self.drmtrigger = [drmtriggerb0, drmtriggerb1]
        self.drmtrigger[int(self.abcparams['drmtrigger'])].SetValue(True)
        drmschedulerbox.Add(drmtriggerbox, 0, wx.TOP, 3)

        self.drmthresholdstarttext = wx.TextCtrl(p, -1, self.abcparams['drmthresholdstart'], wx.Point(-1, -1),
                                                 wx.Size(50, self.utility.digitheight), style = wx.TE_RIGHT)
        self.drmthresholdstarttext.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDotMinus)
        self.drmthresholdstoptext = wx.TextCtrl(p, -1, self.abcparams['drmthresholdstop'], wx.Point(-1, -1),
                                                wx.Size(50, self.utility.digitheight), style = wx.TE_RIGHT)
        self.drmthresholdstoptext.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDotMinus)
        self.drmthresholdstoptext.SetToolTipString(self.localize('-isnever'))
        drmthresholdstartbox = wx.BoxSizer(wx.HORIZONTAL)
        drmthresholdstartbox.Add(wx.StaticText(p, -1, self.localize('drmthresholdstart')), 0, wx.ALIGN_CENTER_VERTICAL)
        drmthresholdstartbox.Add(self.drmthresholdstarttext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        drmthresholdstartbox.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL)
        drmthresholdstopbox = wx.BoxSizer(wx.HORIZONTAL)
        drmthresholdstopbox.Add(wx.StaticText(p, -1, self.localize('drmthresholdstop')), 0, wx.ALIGN_CENTER_VERTICAL)
        drmthresholdstopbox.Add(self.drmthresholdstoptext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        drmthresholdstopbox.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL)
        drmbox2 = wx.BoxSizer(wx.HORIZONTAL)
        drmbox2.Add(wx.StaticText(p, -1, self.localize('drmthreshold')), 0, wx.ALIGN_CENTER_VERTICAL)
        drmbox2.Add(drmthresholdstartbox, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 7)
        drmbox2.Add(drmthresholdstopbox, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 9)
        drmschedulerbox.Add(drmbox2, 0, wx.TOP, 3)

        self.drmdelaystarttext = wx.TextCtrl(p, -1, self.abcparams['drmdelay'], wx.Point(-1, -1),
                                             wx.Size(31, self.utility.digitheight), style = wx.TE_RIGHT)
        self.drmdelaystarttext.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.drmdelaystarttext.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        self.drmdelaystoptext = wx.TextCtrl(p, -1, self.abcparams['drmdelaystop'], wx.Point(-1, -1),
                                            wx.Size(31, self.utility.digitheight), style = wx.TE_RIGHT)
        self.drmdelaystoptext.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.drmdelaystoptext.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        drmdelaystartbox = wx.BoxSizer(wx.HORIZONTAL)
        drmdelaystartbox.Add(wx.StaticText(p, -1, self.localize('drmdelaystart')), 0, wx.ALIGN_CENTER_VERTICAL)
        drmdelaystartbox.Add(self.drmdelaystarttext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        drmdelaystartbox.Add(wx.StaticText(p, -1, self.localize('l_second')), 0, wx.ALIGN_CENTER_VERTICAL)
        drmdelaystopbox = wx.BoxSizer(wx.HORIZONTAL)
        drmdelaystopbox.Add(wx.StaticText(p, -1, self.localize('drmdelaystop')), 0, wx.ALIGN_CENTER_VERTICAL)
        drmdelaystopbox.Add(self.drmdelaystoptext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        drmdelaystopbox.Add(wx.StaticText(p, -1, self.localize('l_second')), 0, wx.ALIGN_CENTER_VERTICAL)
        drmbox3 = wx.BoxSizer(wx.HORIZONTAL)
        drmbox3.Add(wx.StaticText(p, -1, self.localize('drmdelay')), 0, wx.ALIGN_CENTER_VERTICAL)
        drmbox3.Add(drmdelaystartbox, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 7)
        drmbox3.Add(drmdelaystopbox, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 9)
        drmschedulerbox.Add(drmbox3, 0, wx.TOP, 3)

        self.drmtorrentstartdelaytext = wx.TextCtrl(p, -1, self.abcparams['drmtorrentstartdelay'], wx.Point(-1, -1),
                                                    wx.Size(31, self.utility.digitheight), style = wx.TE_RIGHT)
        self.drmtorrentstartdelaytext.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.drmtorrentstartdelaytext.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        self.drmtorrentstopdelaytext = wx.TextCtrl(p, -1, self.abcparams['drmtorrentstopdelay'], wx.Point(-1, -1),
                                                   wx.Size(31, self.utility.digitheight), style = wx.TE_RIGHT)
        self.drmtorrentstopdelaytext.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.drmtorrentstopdelaytext.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        drmtorrentstartdelaybox = wx.BoxSizer(wx.HORIZONTAL)
        drmtorrentstartdelaybox.Add(wx.StaticText(p, -1, self.localize('drmtorrentstartdelay')), 0, wx.ALIGN_CENTER_VERTICAL)
        drmtorrentstartdelaybox.Add(self.drmtorrentstartdelaytext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        drmtorrentstartdelaybox.Add(wx.StaticText(p, -1, self.localize('l_second')), 0, wx.ALIGN_CENTER_VERTICAL)
        drmtorrentstopdelaybox = wx.BoxSizer(wx.HORIZONTAL)
        drmtorrentstopdelaybox.Add(wx.StaticText(p, -1, self.localize('drmtorrentstopdelay')), 0, wx.ALIGN_CENTER_VERTICAL)
        drmtorrentstopdelaybox.Add(self.drmtorrentstopdelaytext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        drmtorrentstopdelaybox.Add(wx.StaticText(p, -1, self.localize('l_second')), 0, wx.ALIGN_CENTER_VERTICAL)
        drmbox4 = wx.BoxSizer(wx.HORIZONTAL)
        drmbox4.Add(wx.StaticText(p, -1, self.localize('drmmindelay')), 0, wx.ALIGN_CENTER_VERTICAL)
        drmbox4.Add(drmtorrentstartdelaybox, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 7)
        drmbox4.Add(drmtorrentstopdelaybox, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 9)
        drmschedulerbox.Add(drmbox4, 0, wx.TOP, 3)

        sizer.Add(drmschedulerbox, 0, wx.EXPAND | wx.TOP, 3)

        urmschedulerbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('urmschedulertitle')), wx.VERTICAL)

        self.urm = wx.CheckBox(p, -1, self.localize('urm'))
        if self.abcparams['urm'] == "1":
            self.urm.SetValue(True)
        urmschedulerbox.Add(self.urm, 0, wx.TOP, 0)

        self.urmonhold = wx.CheckBox(p, -1, self.localize('urmonhold'))
        if self.abcparams['urmonhold'] == "1":
            self.urmonhold.SetValue(True)
        urmschedulerbox.Add(self.urmonhold, 0, wx.TOP, 3)

        self.urmstopsman = wx.CheckBox(p, -1, self.localize('urmstopsman'))
        if self.abcparams['urmstopsman'] == "1":
            self.urmstopsman.SetValue(True)
        urmschedulerbox.Add(self.urmstopsman, 0, wx.TOP, 3)

        self.urmstoponpause = wx.CheckBox(p, -1, self.localize('urmstoponpause'))
        if self.abcparams['urmstoponpause'] == "1":
            self.urmstoponpause.SetValue(True)
        urmschedulerbox.Add(self.urmstoponpause, 0, wx.TOP, 3)

        self.urmmaxtorrenttext = SpinBox(p, header = self.localize('urmmaxtorrent'), value = self.abcparams['urmmaxtorrent'],
                                         width = 43, height = self.utility.digitheight, max = 99999)

        self.urmlowpriority = wx.CheckBox(p, -1, self.localize('urmlowpriority'))
        if self.abcparams['urmlowpriority'] == "1":
            self.urmlowpriority.SetValue(True)
        urmbox1 = wx.BoxSizer(wx.HORIZONTAL)
        urmbox1.Add(self.urmmaxtorrenttext.getSizer(), 0, wx.ALIGN_CENTER_VERTICAL)
        urmbox1.Add(self.urmlowpriority, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 20)
        urmschedulerbox.Add(urmbox1, 0, wx.TOP, 3)

        urmtriggerbox = wx.BoxSizer(wx.HORIZONTAL)
        urmtriggerbox.Add(wx.StaticText(p, -1, self.localize('urmtrigger')), 0, wx.ALIGN_CENTER_VERTICAL)
        urmtriggerb0 = wx.RadioButton(p, -1, self.localize('urmtriggeruprate'), (-1, -1), (-1, -1), wx.RB_GROUP)
        urmtriggerb1 = wx.RadioButton(p, -1, "", (-1, -1), (-1, -1))
        urmtriggerbox.Add(urmtriggerb0, 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 5)
        urmtriggerbox.Add(urmtriggerb1, 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 5)
        self.urmtriggerval = wx.TextCtrl(p, -1, self.abcparams['urmtriggerval'], wx.Point(-1, -1),
                                         wx.Size(49, self.utility.digitheight), style = wx.TE_RIGHT)        
        self.urmtriggerval.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.urmtriggerval.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        urmtriggerbox.Add(self.urmtriggerval, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 3)
        urmtriggerbox.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        self.urmtrigger = [urmtriggerb0, urmtriggerb1]
        self.urmtrigger[int(self.abcparams['urmtrigger'])].SetValue(True)
        urmschedulerbox.Add(urmtriggerbox, 0, wx.TOP, 3)

        self.urmthresholdstarttext = wx.TextCtrl(p, -1, self.abcparams['urmthresholdstart'], wx.Point(-1, -1),
                                                 wx.Size(50, self.utility.digitheight), style = wx.TE_RIGHT)
        self.urmthresholdstarttext.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDotMinus)
        self.urmthresholdstoptext = wx.TextCtrl(p, -1, self.abcparams['urmthresholdstop'], wx.Point(-1, -1),
                                                wx.Size(50, self.utility.digitheight), style = wx.TE_RIGHT)
        self.urmthresholdstoptext.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDotMinus)
        self.urmthresholdstoptext.SetToolTipString(self.localize('-isnever'))
        urmthresholdstartbox = wx.BoxSizer(wx.HORIZONTAL)
        urmthresholdstartbox.Add(wx.StaticText(p, -1, self.localize('urmthresholdstart')), 0, wx.ALIGN_CENTER_VERTICAL)
        urmthresholdstartbox.Add(self.urmthresholdstarttext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        urmthresholdstartbox.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL)
        urmthresholdstopbox = wx.BoxSizer(wx.HORIZONTAL)
        urmthresholdstopbox.Add(wx.StaticText(p, -1, self.localize('urmthresholdstop')), 0, wx.ALIGN_CENTER_VERTICAL)
        urmthresholdstopbox.Add(self.urmthresholdstoptext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        urmthresholdstopbox.Add(wx.StaticText(p, -1, self.utility.kbps), 0, wx.ALIGN_CENTER_VERTICAL)
        urmbox2 = wx.BoxSizer(wx.HORIZONTAL)
        urmbox2.Add(wx.StaticText(p, -1, self.localize('urmthreshold')), 0, wx.ALIGN_CENTER_VERTICAL)
        urmbox2.Add(urmthresholdstartbox, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 7)
        urmbox2.Add(urmthresholdstopbox, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 9)
        urmschedulerbox.Add(urmbox2, 0, wx.TOP, 3)

        self.urmdelaystarttext = wx.TextCtrl(p, -1, self.abcparams['urmdelay'], wx.Point(-1, -1),
                                             wx.Size(31, self.utility.digitheight), style = wx.TE_RIGHT)
        self.urmdelaystarttext.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.urmdelaystarttext.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        self.urmdelaystoptext = wx.TextCtrl(p, -1, self.abcparams['urmdelaystop'], wx.Point(-1, -1),
                                            wx.Size(31, self.utility.digitheight), style = wx.TE_RIGHT)
        self.urmdelaystoptext.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.urmdelaystoptext.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        urmdelaystartbox = wx.BoxSizer(wx.HORIZONTAL)
        urmdelaystartbox.Add(wx.StaticText(p, -1, self.localize('urmdelaystart')), 0, wx.ALIGN_CENTER_VERTICAL)
        urmdelaystartbox.Add(self.urmdelaystarttext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        urmdelaystartbox.Add(wx.StaticText(p, -1, self.localize('l_second')), 0, wx.ALIGN_CENTER_VERTICAL)
        urmdelaystopbox = wx.BoxSizer(wx.HORIZONTAL)
        urmdelaystopbox.Add(wx.StaticText(p, -1, self.localize('urmdelaystop')), 0, wx.ALIGN_CENTER_VERTICAL)
        urmdelaystopbox.Add(self.urmdelaystoptext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        urmdelaystopbox.Add(wx.StaticText(p, -1, self.localize('l_second')), 0, wx.ALIGN_CENTER_VERTICAL)
        urmbox3 = wx.BoxSizer(wx.HORIZONTAL)
        urmbox3.Add(wx.StaticText(p, -1, self.localize('urmdelay')), 0, wx.ALIGN_CENTER_VERTICAL)
        urmbox3.Add(urmdelaystartbox, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 7)
        urmbox3.Add(urmdelaystopbox, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 9)
        urmschedulerbox.Add(urmbox3, 0, wx.TOP, 3)

        self.urmtorrentstartdelaytext = wx.TextCtrl(p, -1, self.abcparams['urmtorrentstartdelay'], wx.Point(-1, -1),
                                                    wx.Size(31, self.utility.digitheight), style = wx.TE_RIGHT)
        self.urmtorrentstartdelaytext.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.urmtorrentstartdelaytext.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        self.urmtorrentstopdelaytext = wx.TextCtrl(p, -1, self.abcparams['urmtorrentstopdelay'], wx.Point(-1, -1),
                                                   wx.Size(31, self.utility.digitheight), style = wx.TE_RIGHT)
        self.urmtorrentstopdelaytext.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.urmtorrentstopdelaytext.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        urmtorrentstartdelaybox = wx.BoxSizer(wx.HORIZONTAL)
        urmtorrentstartdelaybox.Add(wx.StaticText(p, -1, self.localize('urmtorrentstartdelay')), 0, wx.ALIGN_CENTER_VERTICAL)
        urmtorrentstartdelaybox.Add(self.urmtorrentstartdelaytext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        urmtorrentstartdelaybox.Add(wx.StaticText(p, -1, self.localize('l_second')), 0, wx.ALIGN_CENTER_VERTICAL)
        urmtorrentstopdelaybox = wx.BoxSizer(wx.HORIZONTAL)
        urmtorrentstopdelaybox.Add(wx.StaticText(p, -1, self.localize('urmtorrentstopdelay')), 0, wx.ALIGN_CENTER_VERTICAL)
        urmtorrentstopdelaybox.Add(self.urmtorrentstopdelaytext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        urmtorrentstopdelaybox.Add(wx.StaticText(p, -1, self.localize('l_second')), 0, wx.ALIGN_CENTER_VERTICAL)
        urmbox4 = wx.BoxSizer(wx.HORIZONTAL)
        urmbox4.Add(wx.StaticText(p, -1, self.localize('urmmindelay')), 0, wx.ALIGN_CENTER_VERTICAL)
        urmbox4.Add(urmtorrentstartdelaybox, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 7)
        urmbox4.Add(urmtorrentstopdelaybox, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 9)
        urmschedulerbox.Add(urmbox4, 0, wx.TOP, 3)

        sizer.Add(urmschedulerbox, 0, wx.EXPAND | wx.TOP, 3)

        if self.utility.tweakdynmaxuprate == 1:
            tweakdynmaxupratebox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('urmdynmaxupratetitle')), wx.VERTICAL)
    
            self.urmupfromdownAtext = wx.TextCtrl(p, -1, str(self.utility.urmupfromdownA), wx.Point(-1, -1),
                                                  wx.Size(45, self.utility.digitheight), style = wx.TE_RIGHT)
            self.urmupfromdownAtext.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDot)
            self.urmupfromdownBtext = wx.TextCtrl(p, -1, str(self.utility.urmupfromdownB), wx.Point(-1, -1),
                                                  wx.Size(45, self.utility.digitheight), style = wx.TE_RIGHT)
            self.urmupfromdownBtext.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDot)
            self.urmupfromdownCtext = wx.TextCtrl(p, -1, str(self.utility.urmupfromdownC), wx.Point(-1, -1),
                                                  wx.Size(45, self.utility.digitheight), style = wx.TE_RIGHT)
            self.urmupfromdownCtext.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDot)
            self.urmupfromdownDtext = wx.TextCtrl(p, -1, str(self.utility.urmupfromdownD), wx.Point(-1, -1),
                                                  wx.Size(45, self.utility.digitheight), style = wx.TE_RIGHT)
            self.urmupfromdownDtext.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDot)
            self.urmupfromdownEtext = wx.TextCtrl(p, -1, str(self.utility.urmupfromdownE), wx.Point(-1, -1),
                                                  wx.Size(45, self.utility.digitheight), style = wx.TE_RIGHT)
            self.urmupfromdownEtext.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDot)
            urmupfromdownbox1 = wx.BoxSizer(wx.HORIZONTAL)
            urmupfromdownbox1.Add(wx.StaticText(p, -1, self.localize('urmupfromdown1')), 0, wx.ALIGN_CENTER_VERTICAL)
            urmupfromdownbox1.Add(self.urmupfromdownAtext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            urmupfromdownbox1.Add(self.urmupfromdownBtext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            urmupfromdownbox1.Add(self.urmupfromdownCtext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            urmupfromdownbox1.Add(self.urmupfromdownDtext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            urmupfromdownbox1.Add(self.urmupfromdownEtext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            tweakdynmaxupratebox.Add(urmupfromdownbox1, 0, wx.TOP, 0)

            self.urmupfromdownFtext = wx.TextCtrl(p, -1, str(self.utility.urmupfromdownF), wx.Point(-1, -1),
                                                  wx.Size(45, self.utility.digitheight), style = wx.TE_RIGHT)
            self.urmupfromdownFtext.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDot)
            self.urmupfromdownGtext = wx.TextCtrl(p, -1, str(self.utility.urmupfromdownG), wx.Point(-1, -1),
                                                  wx.Size(45, self.utility.digitheight), style = wx.TE_RIGHT)
            self.urmupfromdownGtext.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDot)
            urmupfromdownbox2 = wx.BoxSizer(wx.HORIZONTAL)
            urmupfromdownbox2.Add(wx.StaticText(p, -1, self.localize('urmupfromdown2')), 0, wx.ALIGN_CENTER_VERTICAL)
            urmupfromdownbox2.Add(self.urmupfromdownFtext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            urmupfromdownbox2.Add(self.urmupfromdownGtext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            tweakdynmaxupratebox.Add(urmupfromdownbox2, 0, wx.TOP, 3)

            sizer.Add(tweakdynmaxupratebox, 0, wx.EXPAND | wx.TOP, 3)

        p.SetSizer(sizer)
        p.SetAutoLayout(True)
        return p

    # Network Setting
    ####################
    def makeNetworkPanel(self, parent):
        p = wx.Panel(parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)

        portbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('porttitle')), wx.VERTICAL)

        self.singleport = wx.RadioButton(p, -1, self.localize('singleport'), style = wx.RB_GROUP)
        multiport = wx.RadioButton(p, -1, self.localize('multiport'))
        if self.abcparams['pl'] == "1":
            self.singleport.SetValue(True)
        else:
            multiport.SetValue(True)

        singleportsizer = wx.BoxSizer(wx.HORIZONTAL)
        singleportsizer.Add(self.singleport, 0, wx.ALIGN_CENTER_VERTICAL)
        self.singleportvalue = wx.TextCtrl(p, -1, self.abcparams['plport'], wx.Point(-1, -1),
                                           wx.Size(43, self.utility.digitheight), style = wx.TE_RIGHT)
        self.singleportvalue.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.singleportvalue.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        singleportsizer.Add(self.singleportvalue, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)

        portbox.Add(singleportsizer, 0, wx.TOP, 0)

        multiportsizer = wx.BoxSizer(wx.HORIZONTAL)
        multiportsizer.Add(multiport, 0, wx.ALIGN_CENTER_VERTICAL)
        self.minport = wx.TextCtrl(p, -1, self.abcparams['minport'], wx.Point(-1, -1),
                                   wx.Size(43, self.utility.digitheight), style = wx.TE_RIGHT)
        self.minport.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.minport.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        minport_box = wx.BoxSizer(wx.HORIZONTAL)
        minport_box.Add(wx.StaticText(p, -1, self.localize('minportnumber')), 0, wx.ALIGN_CENTER_VERTICAL)
        minport_box.Add(self.minport, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        multiportsizer.Add(minport_box, 0, wx.LEFT, 10)
        self.maxport = wx.TextCtrl(p, -1, self.abcparams['maxport'], wx.Point(-1, -1),
                                   wx.Size(43, self.utility.digitheight), style = wx.TE_RIGHT)
        self.maxport.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.maxport.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        maxport_box = wx.BoxSizer(wx.HORIZONTAL)
        maxport_box.Add(wx.StaticText(p, -1, self.localize('maxportnumber')), 0, wx.ALIGN_CENTER_VERTICAL)
        maxport_box.Add(self.maxport, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        multiportsizer.Add(maxport_box, 0, wx.LEFT, 10)

        portbox.Add(multiportsizer, 0, wx.TOP, 3)

        portbox.Add(wx.StaticText(p, -1, self.localize('restartabc')), 0, wx.ALIGN_CENTER)

        sizer.Add(portbox, 0, wx.EXPAND | wx.TOP, 3)

        cryptobox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('cryptotitle')), wx.VERTICAL)

        cryptorb0 = wx.RadioButton(p, -1, self.localize('cryptooff'), (-1, -1), (-1, -1), wx.RB_GROUP)
        cryptorb1 = wx.RadioButton(p, -1, self.localize('cryptoon'), (-1, -1), (-1, -1))
        cryptorb2 = wx.RadioButton(p, -1, self.localize('cryptoonly'), (-1, -1), (-1, -1))
        cryptorb3 = wx.RadioButton(p, -1, self.localize('cryptostealth'), (-1, -1), (-1, -1))
        self.crypto = [cryptorb0, cryptorb1, cryptorb2, cryptorb3]

        cryptobox.Add(cryptorb0, 0, wx.TOP, 0)
        cryptobox.Add(cryptorb1, 0, wx.TOP, 3)
        cryptobox.Add(cryptorb2, 0, wx.TOP, 3)
        cryptobox.Add(cryptorb3, 0, wx.TOP, 3)

        sizer.Add(cryptobox, 0, wx.EXPAND | wx.TOP, 3)

        if not CRYPTO_OK:   # No crypto library in place
            cryptorb0.Enable(False)
            cryptorb1.Enable(False)
            cryptorb2.Enable(False)
            cryptorb3.Enable(False)
        else:
            self.crypto[int(self.abcparams['crypto'])].SetValue(True)

        useragentidbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('useragentid')), wx.VERTICAL)

        useragentidrb0 = wx.RadioButton(p, -1, self.localize('default'), style = wx.RB_GROUP)
        useragentidrb1 = wx.RadioButton(p, -1, '')
        useragentidrb2 = wx.RadioButton(p, -1, '')
        useragentidrb3 = wx.RadioButton(p, -1, '')
        self.useragentid = [useragentidrb0, useragentidrb1, useragentidrb2, useragentidrb3]

        uai0box = wx.BoxSizer(wx.HORIZONTAL)
        uai0box.Add(useragentidrb0, 0)
        uai0box.Add(wx.StaticText(p, -1, '[' + self.parent.defuserextended + '] [' + self.parent.defuseragent + '] [ABC_OKC ID]'), 0, wx.LEFT, 2)
        useragentidbox.Add(uai0box, 0, wx.TOP, 0)

        self.useragentctrl = [None]
        self.userextendedctrl = [None]
        self.useridctrl = [None]
        self.useridmaskbtn = [None]
        self.userid = [None]
        self.useridmask = [None]
        self._idrandoms = getIdRandoms()
        useragentidrb0.Bind(wx.EVT_RADIOBUTTON, self.onUserAgentIdRadioButton)
        buttonlabel = self.localize('useridmaskbtn')
        buttonwidth = self.GetTextExtent(buttonlabel)[0] + 12
        buttonlabel = buttonlabel.replace('&', '&&')
        for i in xrange(1, 4):
            self.userextendedctrl.append(wx.TextCtrl(p, -1, size = (90, -1)))
            self.userextendedctrl[i].Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
            self.userextendedctrl[i].Bind(wx.EVT_TEXT, self.onChangeText)
            self.userextendedctrl[i].Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
            self.userextendedctrl[i].SetValue(self.abcparams['userextended' + str(i)])
            self.useragentctrl.append(wx.TextCtrl(p, -1, size = (85, -1)))
            self.useragentctrl[i].Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
            self.useragentctrl[i].Bind(wx.EVT_TEXT, self.onChangeText)
            self.useragentctrl[i].Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
            self.useragentctrl[i].SetValue(self.abcparams['useragent' + str(i)])
            self.userid.append(self.abcparams['userid' + str(i)])
            self.useridctrl.append(wx.TextCtrl(p, -1, size = (130, -1)))
            self.useridctrl[i].Bind(wx.EVT_CHAR, self.utility.onWritePrintable)
            self.useridctrl[i].Bind(wx.EVT_TEXT, self.onWriteInUserPeerId)
            self.useridctrl[i].Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
            self.useridmask.append(self.abcparams['useridmask' + str(i)])
            self.useridmaskbtn.append(wx.ToggleButton(p, -1, buttonlabel, size = (buttonwidth, self.utility.buttonheight)))
            if self.useridmask[i]:
                self.useridmaskbtn[i].SetLabel(self.localize('useridmaskbtn2'))
            self.Bind(wx.EVT_TOGGLEBUTTON, self.onUserPeerIdMaskToggle, self.useridmaskbtn[i])
            self.useragentid[i].Bind(wx.EVT_RADIOBUTTON, self.onUserAgentIdRadioButton)
            self.useridctrl[i].SetValue(self.userid[i])
        # 2 following to avoid computing ID when applying if neither ID nor mask were changed since last generation
        self.useridlastgenerate = self.userid[:]
        self.useridmasklastgenerate = self.useridmask[:]

        uai1box = wx.BoxSizer(wx.HORIZONTAL)
        uai1box.Add(useragentidrb1, 0, wx.ALIGN_CENTER_VERTICAL)
        uai1box.Add(self.userextendedctrl[1], 90, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 3)
        uai1box.Add(self.useragentctrl[1], 85, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 1)
        uai1box.Add(self.useridctrl[1], 130, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 1)
        uai1box.Add(self.useridmaskbtn[1], 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 1)
        useragentidbox.Add(uai1box, 0, wx.EXPAND | wx.TOP, 3)

        uai2box = wx.BoxSizer(wx.HORIZONTAL)
        uai2box.Add(useragentidrb2, 0, wx.ALIGN_CENTER_VERTICAL)
        uai2box.Add(self.userextendedctrl[2], 90, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 3)
        uai2box.Add(self.useragentctrl[2], 85, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 1)
        uai2box.Add(self.useridctrl[2], 130, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 1)
        uai2box.Add(self.useridmaskbtn[2], 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 1)
        useragentidbox.Add(uai2box, 0, wx.EXPAND | wx.TOP, 3)

        uai3box = wx.BoxSizer(wx.HORIZONTAL)
        uai3box.Add(useragentidrb3, 0, wx.ALIGN_CENTER_VERTICAL)
        uai3box.Add(self.userextendedctrl[3], 90, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 3)
        uai3box.Add(self.useragentctrl[3], 85, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 1)
        uai3box.Add(self.useridctrl[3], 130, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 1)
        uai3box.Add(self.useridmaskbtn[3], 0, wx.LEFT | wx.ALIGN_CENTER_VERTICAL, 1)
        useragentidbox.Add(uai3box, 0, wx.EXPAND | wx.TOP, 3)

        self.useragentidnb = int(self.abcparams['useragentid'])
        self.useragentid[self.useragentidnb].SetValue(True)

        currentclientidbox = wx.BoxSizer(wx.HORIZONTAL)
        generateidbtn = wx.Button(p, -1, self.localize('generateidbtn'), size = (-1, self.utility.buttonheight), style = wx.BU_EXACTFIT)
        self.Bind(wx.EVT_BUTTON, self.onGenerateUserPeerId, generateidbtn)
        currentclientidbox.Add(generateidbtn, 0, wx.ALIGN_CENTER_VERTICAL)
        self.currentclientid = wx.TextCtrl(p, -1, self.utility.binToString(createPeerID(useragentidnb = self.useragentidnb)), style = wx.TE_READONLY)
        currentclientidbox.Add(self.currentclientid, 1, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        useragentidbox.Add(currentclientidbox, 0, wx.EXPAND | wx.TOP, 3)

        sizer.Add(useragentidbox, 0, wx.EXPAND | wx.TOP, 3)

        networkbottombox = wx.StaticBoxSizer(wx.StaticBox(p, -1, ''), wx.VERTICAL)

        self.utpex = wx.CheckBox(p, -1, self.localize('utpex'))
        if self.abcparams['utpex'] == "1":
            self.utpex.SetValue(True)
        networkbottombox.Add(self.utpex, 0, wx.TOP, 3)

        dht_box = wx.BoxSizer(wx.HORIZONTAL)
        self.dht = wx.CheckBox(p, -1, self.localize('dht'))
        if self.abcparams['dht'] == "1":
            self.dht.SetValue(True)
        self.dhtport = wx.TextCtrl(p, -1, self.abcparams['dhtport'], wx.Point(-1, -1),
                                   wx.Size(43, self.utility.digitheight), style = wx.TE_RIGHT)
        self.dhtport.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.dhtport.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        dht_box.Add(self.dht, 0, wx.ALIGN_CENTER_VERTICAL)
        dht_box.Add(self.dhtport, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)
        dht_box.Add(wx.StaticText(p, -1, self.localize('restartabc')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        networkbottombox.Add(dht_box, 0, wx.TOP, 3)

        self.dhtsecurityextension = wx.CheckBox(p, -1, self.localize('dhtsecurityextension'))
        if self.utility.dhtsecurityextension == 1:
            self.dhtsecurityextension.SetValue(True)
        networkbottombox.Add(self.dhtsecurityextension, 0, wx.TOP, 3)

        self.skipcertifverif = wx.CheckBox(p, -1, self.localize('skipcertifverif'))
        if self.utility.skipcertifverif == 1:
            self.skipcertifverif.SetValue(True)
        networkbottombox.Add(self.skipcertifverif, 0, wx.TOP, 3)

        if self.utility.hasipv6:
            self.ipv6 = wx.CheckBox(p, -1, self.localize('ipv6'))
            if self.abcparams['ipv6'] == "1":
                self.ipv6.SetValue(True)
            networkbottombox.Add(self.ipv6, 0, wx.TOP, 3)

        self.upnp = wx.ComboBox(p, -1, '', (-1, -1), (-1, -1),
                                [self.localize('upnpdis'), self.localize('upnptype1'), self.localize('upnptype2')],
                                wx.CB_DROPDOWN | wx.CB_READONLY)
        self.upnp.SetSelection(int(self.abcparams['upnp']))
        upnpbox = wx.BoxSizer(wx.HORIZONTAL)
        upnpbox.Add(wx.StaticText(p, -1, self.localize('upnptxt')), 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
        upnpbox.Add(self.upnp, 0, wx.ALIGN_CENTER_VERTICAL)       
        networkbottombox.Add(upnpbox, 0, wx.TOP, 3)

        self.kickban = wx.CheckBox(p, -1, self.localize('kickban'))
        if self.abcparams['kickban'] == "1":
            self.kickban.SetValue(True)
        networkbottombox.Add(self.kickban, 0, wx.TOP, 3)

        self.notsameip = wx.CheckBox(p, -1, self.localize('security'))
        if self.abcparams['notsameip'] == "1":
            self.notsameip.SetValue(True)
        networkbottombox.Add(self.notsameip, 0, wx.TOP, 3)

        self.scrape = wx.CheckBox(p, -1, self.localize('scrape'))
        if self.abcparams['scrape'] == "1":
            self.scrape.SetValue(True)
        networkbottombox.Add(self.scrape, 0, wx.TOP, 3)

        self.inttrackwhencompleted = wx.CheckBox(p, -1, self.localize('inttrackwhencompleted'))
        if self.abcparams['inttrackwhencompleted'] == "1":
            self.inttrackwhencompleted.SetValue(True)
        networkbottombox.Add(self.inttrackwhencompleted, 0, wx.TOP, 3)

        self.checkinttrack = wx.CheckBox(p, -1, self.localize('checkinttrack'),
                                         style = wx.CHK_3STATE | wx.CHK_ALLOW_3RD_STATE_FOR_USER)
        self.checkinttrack.SetToolTipString(self.localize('checkinttracktt'))
        self.checkinttrack.Set3StateValue(int(self.abcparams['checkinttrack']))
        networkbottombox.Add(self.checkinttrack, 0, wx.TOP, 3)

        self.resetdeftrackonstop = wx.CheckBox(p, -1, self.localize('resetdeftrackonstop'))
        if self.abcparams['resetdeftrackonstop'] == "1":
            self.resetdeftrackonstop.SetValue(True)
        networkbottombox.Add(self.resetdeftrackonstop, 0, wx.TOP, 3)

        sizer.Add(networkbottombox, 0, wx.EXPAND | wx.TOP, 0)

        p.SetSizer(sizer)
        p.SetAutoLayout(True)
        return p

    # Torrent list Setting
    #############################
    def makeListPanel(self, parent):
        p = wx.Panel(parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)

        listbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, ''), wx.VERTICAL)

        stripebox = wx.BoxSizer(wx.HORIZONTAL)
        self.stripedlist = wx.CheckBox(p, -1, self.localize('stripedlist'))
        if self.abcparams['stripedlist'] == "1":
            self.stripedlist.SetValue(True)
        stripebox.Add(self.stripedlist, 0, wx.ALIGN_CENTER_VERTICAL)
        self.colstripes = wx.Window(p, -1, size = (13, 13), style = wx.SIMPLE_BORDER)
        self.colstripes.SetBackgroundColour(self.utility.colstripes)
        self.colstripes.Bind(wx.EVT_LEFT_DOWN, self.onColStripes)
        stripebox.Add(self.colstripes, 0, wx.LEFT, 2)
        listbox.Add(stripebox, 0, wx.TOP, 3)

        self.keepeta = wx.CheckBox(p, -1, self.localize('keepeta'))
        if self.abcparams['keepeta'] == "1":
            self.keepeta.SetValue(True)
        listbox.Add(self.keepeta, 0, wx.TOP, 3)

        self.sizeinmb = wx.CheckBox(p, -1, self.localize('sizeinmb'))
        self.sizeinmb.Bind(wx.EVT_CHECKBOX, self.onUpdateSizeInMB)
        if self.abcparams['sizeinmb'] == "1":
            self.sizeinmb.SetValue(True)
        listbox.Add(self.sizeinmb, 0, wx.TOP, 3)

        displayunit = wx.BoxSizer(wx.HORIZONTAL)

        displayunit.Add(wx.StaticText(p, -1, self.localize('displayunit')), 0, wx.ALIGN_LEFT)

        self.displayunitsize = wx.CheckBox(p, -1, self.localize('displayunitsize'))
        if self.abcparams['sizeinmb'] == "1":
            if self.abcparams['displayunitsize'] == "1":
                self.displayunitsize.SetValue(True)
        else:
            self.displayunitsize.SetValue(True)
            self.displayunitsize.Disable()
        displayunit.Add(self.displayunitsize, 0, wx.ALIGN_LEFT | wx.LEFT, 15)

        self.displayunitrate = wx.CheckBox(p, -1, self.localize('displayunitrate'))
        if self.abcparams['displayunitrate'] == "1":
            self.displayunitrate.SetValue(True)
        displayunit.Add(self.displayunitrate, 0, wx.ALIGN_LEFT | wx.LEFT, 15)
        listbox.Add(displayunit, 0, wx.TOP, 3)

        scrolllist = wx.BoxSizer(wx.HORIZONTAL)

        scrolllist.Add(wx.StaticText(p, -1, self.localize('scrolllist')), 0, wx.ALIGN_LEFT)

        self.scrolllistud = wx.CheckBox(p, -1, self.localize('scrolllistud'))
        if self.abcparams['scrolllistud'] == "1":
            self.scrolllistud.SetValue(True)
        scrolllist.Add(self.scrolllistud, 0, wx.ALIGN_LEFT | wx.LEFT, 15)

        self.scrolllisttb = wx.CheckBox(p, -1, self.localize('scrolllisttb'))
        if self.abcparams['scrolllisttb'] == "1":
            self.scrolllisttb.SetValue(True)
        scrolllist.Add(self.scrolllisttb, 0, wx.ALIGN_LEFT | wx.LEFT, 15)
        listbox.Add(scrolllist, 0, wx.TOP, 3)

        self.mousemode = wx.CheckBox(p, -1, self.localize('mousemode'))
        if self.abcparams['mousemode'] == "1":
            self.mousemode.SetValue(True)
        listbox.Add(self.mousemode, 0, wx.TOP, 3)

        self.scrollbelowfinished = wx.CheckBox(p, -1, self.localize('scrollbelowfinished'))
        if self.abcparams['scrollbelowfinished'] == "1":
            self.scrollbelowfinished.SetValue(True)
        listbox.Add(self.scrollbelowfinished, 0, wx.TOP, 3)

        sizer.Add(listbox, 0, wx.EXPAND | wx.TOP, 3)

        messagebox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('listmessages')), wx.VERTICAL)

        rubmsgbox = wx.BoxSizer(wx.HORIZONTAL)

        self.rubmessages = wx.CheckBox(p, -1, self.localize('rubmessages'))

        if self.abcparams['rubmessages'] == "1":
            self.rubmessages.SetValue(True)
        rubmsgbox.Add(self.rubmessages, 0, wx.ALIGN_CENTER_VERTICAL)

        self.rubmsgbutton = wx.ComboBox(p, -1, '', (-1, -1), (-1, -1),
                                        [self.localize('leftbut'), self.localize('rightbut')],
                                        wx.CB_DROPDOWN | wx.CB_READONLY)
        self.rubmsgbutton.SetSelection(int(self.abcparams['rubmsgbutton']))
        rubmsgbox.Add(self.rubmsgbutton, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)       
        messagebox.Add(rubmsgbox, 0, wx.TOP, 0)

        self.keeptermevtmsg = wx.CheckBox(p, -1, self.localize('keeptermevtmsg'))
        if self.abcparams['keeptermevtmsg'] == "1":
            self.keeptermevtmsg.SetValue(True)
        messagebox.Add(self.keeptermevtmsg, 0, wx.TOP, 3)

        self.displaytrackcnxmsg = wx.CheckBox(p, -1, self.localize('displaytrackcnxmsg'))
        if self.abcparams['displaytrackcnxmsg'] == "1":
            self.displaytrackcnxmsg.SetValue(True)
        messagebox.Add(self.displaytrackcnxmsg, 0, wx.TOP, 3)

        self.displaytrackcnxwng = wx.CheckBox(p, -1, self.localize('displaytrackcnxwng'))
        if self.abcparams['displaytrackcnxwng'] == "1":
            self.displaytrackcnxwng.SetValue(True)
        messagebox.Add(self.displaytrackcnxwng, 0, wx.TOP, 3)

        self.erasetrackal = wx.CheckBox(p, -1, self.localize('erasetrackal'))
        if self.abcparams['erasetrackal'] == "1":
            self.erasetrackal.SetValue(True)
        messagebox.Add(self.erasetrackal, 0, wx.TOP, 3)

        displayscrape = wx.BoxSizer(wx.HORIZONTAL)

        displayscrape.Add(wx.StaticText(p, -1, self.localize('displayscrape')), 0, wx.ALIGN_LEFT)

        self.displayscrapingmsg = wx.CheckBox(p, -1, self.localize('displayscrapingmsg'))
        if self.abcparams['displayscrapingmsg'] == "1":
            self.displayscrapingmsg.SetValue(True)
        displayscrape.Add(self.displayscrapingmsg, 0, wx.ALIGN_LEFT | wx.LEFT, 15)

        self.displayscrapestatus = wx.CheckBox(p, -1, self.localize('displayscrapestatus'))
        if self.abcparams['displayscrapestatus'] == "1":
            self.displayscrapestatus.SetValue(True)
        displayscrape.Add(self.displayscrapestatus, 0, wx.ALIGN_LEFT | wx.LEFT, 15)
        messagebox.Add(displayscrape, 0, wx.TOP, 3)

        self.displaycheckstatus = wx.CheckBox(p, -1, self.localize('displaycheckstatus'))
        if self.abcparams['displaycheckstatus'] == "1":
            self.displaycheckstatus.SetValue(True)
        messagebox.Add(self.displaycheckstatus, 0, wx.TOP, 3)

        self.displaytimeout = wx.CheckBox(p, -1, self.localize('displaytimeout'))
        if self.abcparams['displaytimeout'] == "1":
            self.displaytimeout.SetValue(True)
        messagebox.Add(self.displaytimeout, 0, wx.TOP, 3)

        sizer.Add(messagebox, 0, wx.EXPAND | wx.TOP, 3)

        colourbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('torrentcolours')), wx.VERTICAL)
        coloursizer = wx.FlexGridSizer(rows = 3, cols = 4, hgap = 5, vgap = 3)
        coloursizer.Add(wx.StaticText(p, -1, self.localize('colok')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.colok = wx.Window(p, -1, size = (13, 13), style = wx.SIMPLE_BORDER)
        self.colok.SetBackgroundColour(self.utility.colok)
        self.colok.Bind(wx.EVT_LEFT_DOWN, self.onColOK)
        coloursizer.Add(self.colok)
        coloursizer.Add(wx.StaticText(p, -1, self.localize('colnoinc')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 30)
        self.colnoinc = wx.Window(p, -1, size = (13, 13), style = wx.SIMPLE_BORDER)
        self.colnoinc.SetBackgroundColour(self.utility.colnoinc)
        self.colnoinc.Bind(wx.EVT_LEFT_DOWN, self.onColNoInc)
        coloursizer.Add(self.colnoinc)
        coloursizer.Add(wx.StaticText(p, -1, self.localize('colnocom')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.colnocom = wx.Window(p, -1, size = (13, 13), style = wx.SIMPLE_BORDER)
        self.colnocom.SetBackgroundColour(self.utility.colnocom)
        self.colnocom.Bind(wx.EVT_LEFT_DOWN, self.onColNoCom)
        coloursizer.Add(self.colnocom)
        coloursizer.Add(wx.StaticText(p, -1, self.localize('colnocon')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 30)
        self.colnocon = wx.Window(p, -1, size = (13, 13), style = wx.SIMPLE_BORDER)
        self.colnocon.SetBackgroundColour(self.utility.colnocon)
        self.colnocon.Bind(wx.EVT_LEFT_DOWN, self.onColNoCon)
        coloursizer.Add(self.colnocon)
        coloursizer.Add(wx.StaticText(p, -1, self.localize('coldisc')), 0, wx.ALIGN_CENTER_VERTICAL)
        self.coldisc = wx.Window(p, -1, size = (13, 13), style = wx.SIMPLE_BORDER)
        self.coldisc.SetBackgroundColour(self.utility.coldisc)
        self.coldisc.Bind(wx.EVT_LEFT_DOWN, self.onColDisc)
        coloursizer.Add(self.coldisc)
        colourbox.Add(coloursizer)
        sizer.Add(colourbox, 0, wx.EXPAND | wx.TOP, 3)

        listfontbtn = wx.Button(p, -1, self.localize('listfont'), wx.Point(-1, -1), wx.Size(-1, self.utility.buttonheight), style = wx.BU_EXACTFIT)
        self.Bind(wx.EVT_BUTTON, self.onChooseListFont, listfontbtn)
        sizer.Add(listfontbtn, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.TOP | wx.BOTTOM, 6)

        p.SetSizer(sizer)
        p.SetAutoLayout(True)
        return p

    # Interface Setting
    #############################
    def makeInterfacePanel(self, parent):
        p = wx.Panel(parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)

        interfacebox = wx.StaticBoxSizer(wx.StaticBox(p, -1, ''), wx.VERTICAL)

        self.flattopbtn = wx.CheckBox(p, -1, self.localize('flattopbtn'))
        if self.abcparams['flattopbtn'] == "1":
            self.flattopbtn.SetValue(True)
        interfacebox.Add(self.flattopbtn, 0, wx.TOP, 3)

        self.mintray = wx.CheckBox(p, -1, self.localize('mintotray'))
        if self.abcparams['mintray'] == "1":
            self.mintray.SetValue(True)
        interfacebox.Add(self.mintray, 0, wx.TOP, 3)

        self.quickmetainfo = wx.ComboBox(p, -1, '', (-1, -1), (-1, -1),
                                         [self.localize('midbutnone'), self.localize('midbutsingle'), self.localize('midbutdouble')],
                                         wx.CB_DROPDOWN | wx.CB_READONLY)
        self.quickmetainfo.SetSelection(int(self.abcparams['quickmetainfo']))

        quickmetainfobox = wx.BoxSizer(wx.HORIZONTAL)
        quickmetainfobox.Add(wx.StaticText(p, -1, self.localize('quickmetainfo') + '\n' + self.localize('restartabc')),
                             0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
        quickmetainfobox.Add(self.quickmetainfo, 0, wx.ALIGN_CENTER_VERTICAL)
        interfacebox.Add(quickmetainfobox, 0, wx.TOP, 3)

        self.centerquickdetails = wx.ComboBox(p, -1, '', (-1, -1), (-1, -1),
                                              [self.localize('quickdetrightmouse'), self.localize('quickdetcentremouse'), self.localize('quickdetcentremain')],
                                              wx.CB_DROPDOWN | wx.CB_READONLY)
        self.centerquickdetails.SetSelection(int(self.abcparams['centerquickdetails']))

        centerquickdetailsbox = wx.BoxSizer(wx.HORIZONTAL)
        centerquickdetailsbox.Add(wx.StaticText(p, -1, self.localize('centerquickdetails')),
                                    0, wx.ALIGN_CENTER_VERTICAL)
        centerquickdetailsbox.Add(self.centerquickdetails, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        interfacebox.Add(centerquickdetailsbox, 0, wx.TOP, 3)

        self.centerdetoneachother = wx.CheckBox(p, -1, self.localize('centerdetoneachother'),
                                                style = wx.CHK_3STATE | wx.CHK_ALLOW_3RD_STATE_FOR_USER)
        self.centerdetoneachother.SetToolTipString(self.localize('centerdetoneachothertt'))
        self.centerdetoneachother.Set3StateValue(int(self.abcparams['centerdetoneachother']))
        interfacebox.Add(self.centerdetoneachother, 0, wx.TOP, 3)

        self.msgindetails = wx.CheckBox(p, -1, self.localize('msgindetails'))
        if self.abcparams['msgindetails'] == "1":
            self.msgindetails.SetValue(True)
        interfacebox.Add(self.msgindetails, 0, wx.TOP, 3)

        self.emptymsgindetails = wx.CheckBox(p, -1, self.localize('emptymsgindetails'))
        if self.abcparams['emptymsgindetails'] == "1":
            self.emptymsgindetails.SetValue(True)
        emptymsgindetailsbox = wx.BoxSizer(wx.HORIZONTAL)
        emptymsgindetailsbox.Add(self.emptymsgindetails, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 20)
        interfacebox.Add(emptymsgindetailsbox, 0, wx.TOP, 3)

        self.popuploaded = wx.CheckBox(p, -1, self.localize('popuploaded'))
        if self.abcparams['popuploaded'] == "1":
            self.popuploaded.SetValue(True)
        interfacebox.Add(self.popuploaded, 0, wx.TOP, 3)

        self.countonhold = wx.CheckBox(p, -1, self.localize('countonhold'))
        if self.abcparams['countonhold'] == "1":
            self.countonhold.SetValue(True)
        interfacebox.Add(self.countonhold, 0, wx.TOP, 3)

        self.showschedcounters = wx.CheckBox(p, -1, self.localize('showschedcounters'),
                                             style = wx.CHK_3STATE | wx.CHK_ALLOW_3RD_STATE_FOR_USER)
        self.showschedcounters.SetToolTipString(self.localize('showschedcounterstt'))
        self.showschedcounters.Set3StateValue(int(self.abcparams['showschedcounters']))
        interfacebox.Add(self.showschedcounters, 0, wx.TOP, 3)

        self.countonlyalive = wx.CheckBox(p, -1, self.localize('countonlyalive'))
        if self.abcparams['countonlyalive'] == "1":
            self.countonlyalive.SetValue(True)
        interfacebox.Add(self.countonlyalive, 0, wx.TOP, 3)

        displayvol = wx.BoxSizer(wx.HORIZONTAL)

        displayvol.Add(wx.StaticText(p, -1, self.localize('displayvol')), 0, wx.ALIGN_LEFT)

        self.displaydownvol = wx.CheckBox(p, -1, self.localize('displaydownvol'))
        if self.abcparams['displaydownvol'] == "1":
            self.displaydownvol.SetValue(True)
        displayvol.Add(self.displaydownvol, 0, wx.ALIGN_LEFT | wx.LEFT, 10)

        self.displayupvol = wx.CheckBox(p, -1, self.localize('displayupvol'))
        if self.abcparams['displayupvol'] == "1":
            self.displayupvol.SetValue(True)
        displayvol.Add(self.displayupvol, 0, wx.ALIGN_LEFT | wx.LEFT, 10)
        interfacebox.Add(displayvol, 0, wx.TOP, 3)

        self.savesizesonexit = wx.CheckBox(p, -1, self.localize('savesizesonexit'))
        if self.abcparams['savesizesonexit'] == "1":
            self.savesizesonexit.SetValue(True)
        interfacebox.Add(self.savesizesonexit, 0, wx.TOP, 3)

        self.exitwindow = wx.CheckBox(p, -1, self.localize('exitwindow'),
                                      style = wx.CHK_3STATE | wx.CHK_ALLOW_3RD_STATE_FOR_USER)
        self.exitwindow.SetToolTipString(self.localize('exitwindowtt'))
        self.exitwindow.Set3StateValue(int(self.abcparams['exitwindow']))
        interfacebox.Add(self.exitwindow, 0, wx.TOP, 3)

        self.abcproc = wx.CheckBox(p, -1, self.localize('abcproc'))
        if self.abcparams['abcproc'] == "1":
            self.abcproc.SetValue(True)
        interfacebox.Add(self.abcproc, 0, wx.TOP, 3)

        self.confirmonclose = wx.CheckBox(p, -1, self.localize('confirmonexit'))
        if self.abcparams['confirmonclose'] == "1":
            self.confirmonclose.SetValue(True)
        interfacebox.Add(self.confirmonclose, 0, wx.TOP, 3)

        sizer.Add(interfacebox, 0, wx.EXPAND | wx.TOP, 3)

        bottombarbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('bottombar')), wx.VERTICAL)

        bottombarsizer = wx.FlexGridSizer(rows = 3, cols = 2, hgap = 20, vgap = 3)
        self.movemidbtn = wx.CheckBox(p, -1, self.localize('movemidbtn'),
                                      style = wx.CHK_3STATE | wx.CHK_ALLOW_3RD_STATE_FOR_USER)
        self.movemidbtn.SetToolTipString(self.localize('movemidbtntt'))
        self.movemidbtn.Set3StateValue(int(self.abcparams['movemidbtn']))
        bottombarsizer.Add(self.movemidbtn)
        self.schedulerbtn = wx.CheckBox(p, -1, self.localize('schedulerbtn'))
        if self.abcparams['schedulerbtn'] == "1":
            self.schedulerbtn.SetValue(True)
        bottombarsizer.Add(self.schedulerbtn)
        self.stoptrafficbtn = wx.CheckBox(p, -1, self.localize('stoptrafficbtn'))
        if self.abcparams['stoptrafficbtn'] == "1":
            self.stoptrafficbtn.SetValue(True)
        bottombarsizer.Add(self.stoptrafficbtn)
        self.scannerbtn = wx.CheckBox(p, -1, self.localize('scannerbtn'))
        if self.abcparams['scannerbtn'] == "1":
            self.scannerbtn.SetValue(True)
        bottombarsizer.Add(self.scannerbtn)
        self.stopresallbtn = wx.CheckBox(p, -1, self.localize('stopresallbtn'))
        if self.abcparams['stopresallbtn'] == "1":
            self.stopresallbtn.SetValue(True)
        bottombarsizer.Add(self.stopresallbtn)
        self.webservbtn = wx.CheckBox(p, -1, self.localize('webservbtn'))
        if self.abcparams['webservbtn'] == "1":
            self.webservbtn.SetValue(True)
        bottombarsizer.Add(self.webservbtn)
        bottombarbox.Add(bottombarsizer, 0, wx.TOP, 0)

        self.flatbotbtn = wx.CheckBox(p, -1, self.localize('flatbotbtn'))
        if self.abcparams['flatbotbtn'] == "1":
            self.flatbotbtn.SetValue(True)
        bottombarbox.Add(self.flatbotbtn, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.TOP, 3)

        sizer.Add(bottombarbox, 0, wx.EXPAND | wx.TOP, 3)

        p.SetSizer(sizer)
        p.SetAutoLayout(True)
        return p

    # Misc Setting
    #############################
    def makeMiscPanel(self, parent):
        p = wx.Panel(parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)

        downlocbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('downlocbox')), wx.VERTICAL)

        dirbox = wx.BoxSizer(wx.HORIZONTAL)
        self.defaultfolder = wx.TextCtrl(p, -1, self.abcparams['defaultfolder'])
        buttonlabel = self.localize('browse')
        buttonwidth = self.GetTextExtent(buttonlabel)[0] + 12
        buttonlabel = buttonlabel.replace('&', '&&')
        browsebtn = wx.Button(p, -1, buttonlabel, (-1, -1), (buttonwidth, self.utility.buttonheight))
        self.Bind(wx.EVT_BUTTON, self.onBrowseDownDir, browsebtn)
        dirbox.Add(wx.StaticText(p, -1, self.localize('defaultfolder')), 0, wx.ALIGN_CENTER_VERTICAL)
        dirbox.Add(self.defaultfolder, 1, wx.EXPAND | wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        dirbox.Add(browsebtn, 0, wx.ALIGN_CENTER_VERTICAL)
        downlocbox.Add(dirbox, 0, wx.EXPAND | wx.TOP, 0)

        self.setdefaultfolder = wx.CheckBox(p, -1, self.localize('setdefaultfolder'))
        if self.abcparams['setdefaultfolder'] == "1":
            self.setdefaultfolder.SetValue(True)
        downlocbox.Add(self.setdefaultfolder, 0, wx.TOP, 3)

        self.setextdefaultfolder = wx.CheckBox(p, -1, self.localize('setextdefaultfolder'))
        if self.abcparams['setextdefaultfolder'] == "1":
            self.setextdefaultfolder.SetValue(True)
        downlocbox.Add(self.setextdefaultfolder, 0, wx.TOP, 3)
        downlocbox.Add(wx.StaticText(p, -1, self.localize('setextdefaultfolder2')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 16)

        downdestbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('downdestbox')), wx.VERTICAL)

        self.keepmagnetname = wx.CheckBox(p, -1, self.localize('keepmagnetname'))
        if self.abcparams['keepmagnetname'] == "1":
            self.keepmagnetname.SetValue(True)
        downdestbox.Add(self.keepmagnetname, 0, wx.TOP, 3)

        dupdestbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('dupdestbox')), wx.VERTICAL)

        dupdestrb0 = wx.RadioButton(p, -1, self.localize('dupdestauto'), (-1, -1), (-1, -1), wx.RB_GROUP)
        dupdestrb1 = wx.RadioButton(p, -1, self.localize('dupdestask'), (-1, -1), (-1, -1))
        dupdestbox.Add(dupdestrb0, 0, wx.TOP, 0)
        dupdestbox.Add(dupdestrb1, 0, wx.TOP, 3)
        self.dupdest = [dupdestrb0, dupdestrb1]
        self.dupdest[int(self.abcparams['askduplicatedest'])].SetValue(True)

        downdestbox.Add(dupdestbox, 0, wx.TOP | wx.EXPAND, 5)

        longpathbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('longpathbox')), wx.VERTICAL)

        longpathrb0 = wx.RadioButton(p, -1, self.localize('longpathauto'), (-1, -1), (-1, -1), wx.RB_GROUP)
        longpathrb1 = wx.RadioButton(p, -1, self.localize('longpathmanual'), (-1, -1), (-1, -1))
        longpathrb2 = wx.RadioButton(p, -1, self.localize('longpathkeep'), (-1, -1), (-1, -1))
        longpathbox.Add(longpathrb0, 0, wx.TOP, 0)
        longpathbox.Add(longpathrb1, 0, wx.TOP, 3)
        longpathbox.Add(longpathrb2, 0, wx.TOP, 3)
        self.longpath = [longpathrb0, longpathrb1, longpathrb2]
        self.longpath[int(self.abcparams['longpath'])].SetValue(True)

        movedatabox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('movedatabox')), wx.VERTICAL)

        movedatasizer = wx.BoxSizer(wx.HORIZONTAL)

        self.movedataonstatus = wx.CheckBox(p, -1, self.localize('movedataonstatus'))
        if self.abcparams['movedataonstatus'] == "1":
            self.movedataonstatus.SetValue(True)
        movedatasizer.Add(self.movedataonstatus, 0, wx.ALIGN_CENTER_VERTICAL)

        self.movedatastatus = wx.ComboBox(p, -1, '', (-1, -1), (-1, -1),
                                          [self.localize('movedatacom'), self.localize('movedatafin')],
                                          wx.CB_DROPDOWN | wx.CB_READONLY)
        self.movedatastatus.Bind(wx.EVT_COMBOBOX, self.onMoveDataStatus)
        self.movedatastatus.SetSelection(int(self.abcparams['movedatastatus']))
        movedatasizer.Add(self.movedatastatus, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)       

        self.completedresumedelaytext = wx.StaticText(p, -1, self.localize('completedresumedelay'))
        movedatasizer.Add(self.completedresumedelaytext, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 10)
        self.completedresumedelay = wx.TextCtrl(p, -1, self.abcparams['completedresumedelay'], wx.Point(-1, -1), wx.Size(30, -1))
        self.completedresumedelay.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.completedresumedelay.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        movedatasizer.Add(self.completedresumedelay, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        self.completedresumedelayunit = wx.StaticText(p, -1, self.localize('l_second'))
        movedatasizer.Add(self.completedresumedelayunit, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)

        movedatabox.Add(movedatasizer, 0, wx.TOP, 0)

        self.movedataondelete = wx.CheckBox(p, -1, self.localize('movedataondelete'))
        if self.abcparams['movedataondelete'] == "1":
            self.movedataondelete.SetValue(True)
        movedatabox.Add(self.movedataondelete, 0, wx.TOP, 3)

        freediskspacebox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('freediskspacebox')), wx.VERTICAL)

        diskfullthbox = wx.BoxSizer(wx.HORIZONTAL)
        self.diskfullth = wx.TextCtrl(p, -1, self.abcparams['diskfullth'], wx.Point(-1, -1),
                                      wx.Size(49, self.utility.digitheight), style = wx.TE_RIGHT)        
        self.diskfullth.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.diskfullth.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        diskfullthbox.Add(wx.StaticText(p, -1, self.localize('diskfullth')), 0, wx.ALIGN_CENTER_VERTICAL)
        diskfullthbox.Add(self.diskfullth, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        diskfullthbox.Add(wx.StaticText(p, -1, self.utility.mb), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        freediskspacebox.Add(diskfullthbox, 0, wx.TOP, 0)

        diskfullmanbox = wx.BoxSizer(wx.HORIZONTAL)
        self.diskfullman = wx.CheckBox(p, -1, self.localize('diskfullman1'))
        if self.abcparams['diskfullman'] == "1":
            self.diskfullman.SetValue(True)
        diskfullmanbox.Add(self.diskfullman, 0, wx.ALIGN_CENTER_VERTICAL)
        self.diskfullmode = wx.ComboBox(p, -1, '', (-1, -1), (-1, -1),
                                        [self.localize('diskfullmodeman'), self.localize('diskfullmodeseed')],
                                        wx.CB_DROPDOWN | wx.CB_READONLY)
        self.diskfullmode.SetSelection(int(self.abcparams['diskfullmode']))
        diskfullmanbox.Add(self.diskfullmode, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)
        diskfullmanbox.Add(wx.StaticText(p, -1, self.localize('diskfullman2')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        freediskspacebox.Add(diskfullmanbox, 0, wx.TOP, 3)

        miscbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, ''), wx.VERTICAL)

        self.removetorrent = wx.CheckBox(p, -1, self.localize('removetorrent'))
        if self.abcparams['removetorrent'] == "1":
            self.removetorrent.SetValue(True)
        miscbox.Add(self.removetorrent, 0, wx.TOP, 3)

        self.defrentorwithdest = wx.CheckBox(p, -1, self.localize('defrentorwithdest'))
        if self.abcparams['defrentorwithdest'] == "1":
            self.defrentorwithdest.SetValue(True)
        miscbox.Add(self.defrentorwithdest, 0, wx.TOP, 3)

        self.languagefiles, languagenames = self.getLanguages()
        if not self.languagefiles:
            # Should never get here -- this means there are no valid language files found!
            sys.stderr.write("\nNO LANGUAGE FILES FOUND ! Please add a valid language file\n")
            defaultlang = ""
        else:
            try:
                index = self.languagefiles.index(self.abcparams['language_file'])
                defaultlang = languagenames[index]
            except:
                defaultlang = ""
        self.languagechoice = wx.ComboBox(p, -1, defaultlang, (-1, -1), (-1, -1), languagenames,
                                          wx.CB_DROPDOWN | wx.CB_READONLY)

        langbox = wx.BoxSizer(wx.HORIZONTAL)
        langbox.Add(wx.StaticText(p, -1, self.localize('choose_language')), 0, wx.ALIGN_CENTER_VERTICAL)
        langbox.Add(self.languagechoice, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)
        langbox.Add(wx.StaticText(p, -1, self.localize('restartabc')), 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
        miscbox.Add(langbox, 0, wx.TOP, 3)

        sizer.Add(downlocbox, 0, wx.EXPAND | wx.TOP, 3)
        sizer.Add(downdestbox, 0, wx.EXPAND | wx.TOP, 3)
        sizer.Add(longpathbox, 0, wx.EXPAND | wx.TOP, 3)
        sizer.Add(movedatabox, 0, wx.EXPAND | wx.TOP, 3)
        sizer.Add(freediskspacebox, 0, wx.EXPAND | wx.TOP, 3)
        sizer.Add(miscbox, 0, wx.EXPAND | wx.TOP, 0)

        if self.utility.tweakbandwidthdistribution == 1:
            tweakbandwidthdistributionbox = wx.StaticBoxSizer(wx.StaticBox(p, -1, self.localize('bandwidthdistributiontitle')), wx.VERTICAL)

            calcdown = wx.BoxSizer(wx.HORIZONTAL)
            self.bdcalcdownth1 = wx.TextCtrl(p, -1, str(self.utility.bdcalcdownth1), wx.Point(-1, -1),
                                             wx.Size(45, self.utility.digitheight), style = wx.TE_RIGHT)
            self.bdcalcdownth1.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDotMinus)
            self.bdcalcdownth2 = wx.TextCtrl(p, -1, str(self.utility.bdcalcdownth2), wx.Point(-1, -1),
                                             wx.Size(45, self.utility.digitheight), style = wx.TE_RIGHT)
            self.bdcalcdownth2.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDotMinus)
            calcdown.Add(wx.StaticText(p, -1, self.localize('bandwidthdistributiondown')), 0, wx.ALIGN_CENTER_VERTICAL)
            calcdown.Add(self.bdcalcdownth1, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            calcdown.Add(self.bdcalcdownth2, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            tweakbandwidthdistributionbox.Add(calcdown, 0, wx.TOP, 0)
            calcup = wx.BoxSizer(wx.HORIZONTAL)
            self.bdcalcupth1 = wx.TextCtrl(p, -1, str(self.utility.bdcalcupth1), wx.Point(-1, -1),
                                           wx.Size(45, self.utility.digitheight), style = wx.TE_RIGHT)
            self.bdcalcupth1.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDotMinus)
            self.bdcalcupth2 = wx.TextCtrl(p, -1, str(self.utility.bdcalcupth2), wx.Point(-1, -1),
                                           wx.Size(45, self.utility.digitheight), style = wx.TE_RIGHT)
            self.bdcalcupth2.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDotMinus)
            calcup.Add(wx.StaticText(p, -1, self.localize('bandwidthdistributionup')), 0, wx.ALIGN_CENTER_VERTICAL)
            calcup.Add(self.bdcalcupth1, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            calcup.Add(self.bdcalcupth2, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 5)
            tweakbandwidthdistributionbox.Add(calcup, 0, wx.TOP, 3)

            sizer.Add(tweakbandwidthdistributionbox, 0, wx.EXPAND | wx.TOP, 3)

        fileassobtn = wx.Button(p, -1, self.localize('fileasso'), wx.Point(-1, -1), wx.Size(-1, self.utility.buttonheight), style = wx.BU_EXACTFIT)
        self.Bind(wx.EVT_BUTTON, self.onTorAssociate, fileassobtn)
        sizer.Add(fileassobtn, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.TOP, 6)

        cleantorrentdirbtn = wx.Button(p, -1, self.localize('cleantorrentdir'), wx.Point(-1, -1), wx.Size(-1, self.utility.buttonheight), style = wx.BU_EXACTFIT)
        self.Bind(wx.EVT_BUTTON, self.onCleanTorrentDir, cleantorrentdirbtn)
        sizer.Add(cleantorrentdirbtn, 0, wx.ALIGN_CENTER_HORIZONTAL | wx.TOP | wx.BOTTOM, 6)

        p.SetSizer(sizer)
        p.SetAutoLayout(True)
        return p

    def onRightButtonText(self, event):
        pass

    def onChangeText(self, event):
        textctrl = event.GetEventObject()
        textctrlval = textctrl.GetValue()
        if textctrl.GetTextExtent(textctrlval)[0] > textctrl.GetSizeTuple()[0] - 9:
            textctrl.SetToolTipString(textctrlval)
        else:
            textctrl.SetToolTipString('')
        event.Skip()

    def onMoveDataStatus(self, event):
        event.Skip()
        if event.GetSelection():
            self.completedresumedelaytext.Hide()
            self.completedresumedelay.Hide()
            self.completedresumedelayunit.Hide()
        else:
            self.completedresumedelaytext.Show()
            self.completedresumedelay.Show()
            self.completedresumedelayunit.Show()

    def onUserPeerIdMaskToggle(self, event):
        useridmaskbtn = event.GetEventObject()
        idindex = self.useridmaskbtn.index(useridmaskbtn)
        cursor = self.useridctrl[idindex].GetInsertionPoint()
        if useridmaskbtn.GetValue():
            # Edit mask
            self.userid[idindex] = self.useridctrl[idindex].GetValue()
            self.useridctrl[idindex].SetValue(self.useridmask[idindex])
            useridlen = len(self.userid[idindex]) - 1
            # Compute new cursor position
            newcursor = 0
            i = 0
            while i < cursor:
                if self.userid[idindex][i] == '\\':
                    if i != useridlen and self.userid[idindex][i + 1] == '\\':
                        newcursor += 1
                        i += 2
                    else:
                        newcursor += 1
                        i += 3
                else:
                    newcursor += 1
                    i += 1
            if i > cursor:
                newcursor -= 1
        else:
            # Edit id
            self.useridmask[idindex] = self.useridctrl[idindex].GetValue()
            self.useridctrl[idindex].SetValue(self.userid[idindex])
            useridlen = len(self.userid[idindex]) - 1
            # Compute new cursor position
            newcursor = 0
            i = 0
            while i < cursor and newcursor <= useridlen:
                if self.userid[idindex][newcursor] == '\\':
                    if newcursor != useridlen and self.userid[idindex][newcursor + 1] == '\\':
                        i += 1
                        newcursor += 2
                    else:
                        i += 1
                        newcursor += 3
                else:
                    i += 1
                    newcursor += 1
        self.useridctrl[idindex].SetInsertionPoint(newcursor)
        self.useridctrl[idindex].SetFocus()

    def onUserAgentIdRadioButton(self, event):
        for i in xrange(4):
            if self.useragentid[i].GetValue():
                self.useragentidnb = i
                break
        self.currentclientid.SetValue(self.utility.binToString(createPeerID(useragentidnb = self.useragentidnb, idrandoms = self._idrandoms)))

    def onWriteInUserPeerId(self, event):
        useridctrl = event.GetEventObject()
        useridctrlval = useridctrl.GetValue()
        if useridctrl.GetTextExtent(useridctrlval)[0] > useridctrl.GetSizeTuple()[0] - 9:
            useridctrl.SetToolTipString(useridctrlval)
        else:
            useridctrl.SetToolTipString('')
        # Change the text of the id/mask toggle button
        idindex = self.useridctrl.index(useridctrl)
        if self.useridmaskbtn[idindex].GetValue():
            if not useridctrl.GetValue():
                self.useridmaskbtn[idindex].SetLabel(self.localize('useridmaskbtn'))
            elif self.useridmaskbtn[idindex].GetLabel() != self.localize('useridmaskbtn2'):
                self.useridmaskbtn[idindex].SetLabel(self.localize('useridmaskbtn2'))
        event.Skip()

    def generateUserPeerId(self, idlist, useridlist, useridmasklist):
        status, idrandoms = resetUserPeerID(idlist, useridlist, useridmasklist)
        errormsg = ''
        for i in xrange(len(status)):
            if status[i] == 1:
                errormsg += self.localize('useridnb') + str(idlist[i]) + self.localize('useridhexerror') + '\n'
            elif status[i] == 2:
                errormsg += self.localize('useridnb') + str(idlist[i]) + self.localize('useridlengtherror') + '\n'
            elif status[i] == 3:
                errormsg += self.localize('useridnb') + str(idlist[i]) + self.localize('useridmasklengtherror') + '\n'
            elif status[i] == 4:
                errormsg += self.localize('useridnb') + str(idlist[i]) + self.localize('useridmaskerror') + '\n'
            elif status[i] == 5:
                errormsg += self.localize('useridnb') + str(idlist[i]) + self.localize('useridrandomerror') + '\n'
        if errormsg:
            dlg = wx.MessageDialog(self, errormsg[:-1], self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False
        for id in idlist:
            self._idrandoms[id] = idrandoms.pop(0)
        return True

    def onGenerateUserPeerId(self, event):
        if self.useragentidnb == 0:
            self._idrandoms[0] = resetPeerID()
            self.currentclientid.SetValue(self.utility.binToString(createPeerID(useragentidnb = 0, idrandoms = self._idrandoms)))
        else:
            if self.useridmaskbtn[self.useragentidnb].GetValue():
                self.useridmask[self.useragentidnb] = self.useridctrl[self.useragentidnb].GetValue()
            else:
                self.userid[self.useragentidnb] = self.useridctrl[self.useragentidnb].GetValue()
            if not self.userid[self.useragentidnb]:
                dlg = wx.MessageDialog(self, self.localize('selecteduseridempty'), self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
            elif self.generateUserPeerId([self.useragentidnb], [self.userid[self.useragentidnb]], [self.useridmask[self.useragentidnb]]):
                self.currentclientid.SetValue(self.utility.binToString(createPeerID(useragentidnb = self.useragentidnb, idrandoms = self._idrandoms)))
                self.useridlastgenerate[self.useragentidnb] = self.userid[self.useragentidnb]
                self.useridmasklastgenerate[self.useragentidnb] = self.useridmask[self.useragentidnb]

    def onUpdateSizeInMB(self, event):
        event.Skip()
        if event.IsChecked():
            self.displayunitsize.Enable()
        else:
            self.displayunitsize.SetValue(True)
            self.displayunitsize.Disable()

    def onColOK(self, event):
        coldata = wx.ColourData()
        for i in xrange(16):
            coldata.SetCustomColour(i, tuple(map(int, self.abcparams['colcust%02d' % (i + 1)].split(','))))
        coldata.SetChooseFull(True)
        coldata.SetColour(self.colok.GetBackgroundColour())
        dlg = wx.ColourDialog(self, coldata)
        dlg.SetTitle(self.localize('coloktitle'))
        result = dlg.ShowModal()
        coldata = dlg.GetColourData()
        if result == wx.ID_OK:
            newcolour = coldata.GetColour()
            if newcolour != self.colok.GetBackgroundColour():
                self.colok.SetBackgroundColour(newcolour)
                self.colok.Refresh()
                self.utility.colok.Set(newcolour.Red(), newcolour.Green(), newcolour.Blue())
                for tor in self.queue.proctab:
                    if tor.abcengine:
                        tor.abcengine.updateColour()
                        if tor.infowin:
                            tor.infowin.colour.Refresh()
                        if tor.detailwin:
                            tor.detailwin.colour.Refresh()
        for i in xrange(16):
            col = coldata.GetCustomColour(i)
            self.abcparams['colcust%02d' % (i + 1)] = '%d,%d,%d' % (col.Red(), col.Green(), col.Blue())
        dlg.Destroy()

    def onColNoInc(self, event):
        coldata = wx.ColourData()
        for i in xrange(16):
            coldata.SetCustomColour(i, tuple(map(int, self.abcparams['colcust%02d' % (i + 1)].split(','))))
        coldata.SetChooseFull(True)
        coldata.SetColour(self.colnoinc.GetBackgroundColour())
        dlg = wx.ColourDialog(self, coldata)
        dlg.SetTitle(self.localize('colnoinctitle'))
        result = dlg.ShowModal()
        coldata = dlg.GetColourData()
        if result == wx.ID_OK:
            newcolour = coldata.GetColour()
            if newcolour != self.colnoinc.GetBackgroundColour():
                self.colnoinc.SetBackgroundColour(newcolour)
                self.colnoinc.Refresh()
                self.utility.colnoinc.Set(newcolour.Red(), newcolour.Green(), newcolour.Blue())
                for tor in self.queue.proctab:
                    if tor.abcengine:
                        tor.abcengine.updateColour()
                        if tor.infowin:
                            tor.infowin.colour.Refresh()
                        if tor.detailwin:
                            tor.detailwin.colour.Refresh()
        for i in xrange(16):
            col = coldata.GetCustomColour(i)
            self.abcparams['colcust%02d' % (i + 1)] = '%d,%d,%d' % (col.Red(), col.Green(), col.Blue())
        dlg.Destroy()

    def onColNoCom(self, event):
        coldata = wx.ColourData()
        for i in xrange(16):
            coldata.SetCustomColour(i, tuple(map(int, self.abcparams['colcust%02d' % (i + 1)].split(','))))
        coldata.SetChooseFull(True)
        coldata.SetColour(self.colnocom.GetBackgroundColour())
        dlg = wx.ColourDialog(self, coldata)
        dlg.SetTitle(self.localize('colnocomtitle'))
        result = dlg.ShowModal()
        coldata = dlg.GetColourData()
        if result == wx.ID_OK:
            newcolour = coldata.GetColour()
            if newcolour != self.colnocom.GetBackgroundColour():
                self.colnocom.SetBackgroundColour(newcolour)
                self.colnocom.Refresh()
                self.utility.colnocom.Set(newcolour.Red(), newcolour.Green(), newcolour.Blue())
                for tor in self.queue.proctab:
                    if tor.abcengine:
                        tor.abcengine.updateColour()
                        if tor.infowin:
                            tor.infowin.colour.Refresh()
                        if tor.detailwin:
                            tor.detailwin.colour.Refresh()
        for i in xrange(16):
            col = coldata.GetCustomColour(i)
            self.abcparams['colcust%02d' % (i + 1)] = '%d,%d,%d' % (col.Red(), col.Green(), col.Blue())
        dlg.Destroy()

    def onColNoCon(self, event):
        coldata = wx.ColourData()
        for i in xrange(16):
            coldata.SetCustomColour(i, tuple(map(int, self.abcparams['colcust%02d' % (i + 1)].split(','))))
        coldata.SetChooseFull(True)
        coldata.SetColour(self.colnocon.GetBackgroundColour())
        dlg = wx.ColourDialog(self, coldata)
        dlg.SetTitle(self.localize('colnocontitle'))
        result = dlg.ShowModal()
        coldata = dlg.GetColourData()
        if result == wx.ID_OK:
            newcolour = coldata.GetColour()
            if newcolour != self.colnocon.GetBackgroundColour():
                self.colnocon.SetBackgroundColour(newcolour)
                self.colnocon.Refresh()
                self.utility.colnocon.Set(newcolour.Red(), newcolour.Green(), newcolour.Blue())
                for tor in self.queue.proctab:
                    if tor.abcengine:
                        tor.abcengine.updateColour()
                        if tor.infowin:
                            tor.infowin.colour.Refresh()
                        if tor.detailwin:
                            tor.detailwin.colour.Refresh()
        for i in xrange(16):
            col = coldata.GetCustomColour(i)
            self.abcparams['colcust%02d' % (i + 1)] = '%d,%d,%d' % (col.Red(), col.Green(), col.Blue())
        dlg.Destroy()

    def onColDisc(self, event):
        coldata = wx.ColourData()
        for i in xrange(16):
            coldata.SetCustomColour(i, tuple(map(int, self.abcparams['colcust%02d' % (i + 1)].split(','))))
        coldata.SetChooseFull(True)
        coldata.SetColour(self.coldisc.GetBackgroundColour())
        dlg = wx.ColourDialog(self, coldata)
        dlg.SetTitle(self.localize('coldisctitle'))
        result = dlg.ShowModal()
        coldata = dlg.GetColourData()
        if result == wx.ID_OK:
            newcolour = coldata.GetColour()
            if newcolour != self.coldisc.GetBackgroundColour():
                self.coldisc.SetBackgroundColour(newcolour)
                self.coldisc.Refresh()
                self.utility.coldisc.Set(newcolour.Red(), newcolour.Green(), newcolour.Blue())
                for tor in self.queue.proctab:
                    if tor.abcengine:
                        tor.abcengine.updateColour()
                        if tor.infowin:
                            tor.infowin.colour.Refresh()
                        if tor.detailwin:
                            tor.detailwin.colour.Refresh()
        for i in xrange(16):
            col = coldata.GetCustomColour(i)
            self.abcparams['colcust%02d' % (i + 1)] = '%d,%d,%d' % (col.Red(), col.Green(), col.Blue())
        dlg.Destroy()

    def onColStripes(self, event):
        coldata = wx.ColourData()
        for i in xrange(16):
            coldata.SetCustomColour(i, tuple(map(int, self.abcparams['colcust%02d' % (i + 1)].split(','))))
        coldata.SetChooseFull(True)
        coldata.SetColour(self.colstripes.GetBackgroundColour())
        dlg = wx.ColourDialog(self, coldata)
        dlg.SetTitle(self.localize('colstripestitle'))
        result = dlg.ShowModal()
        coldata = dlg.GetColourData()
        if result == wx.ID_OK:
            newcolour = coldata.GetColour()
            if newcolour != self.colstripes.GetBackgroundColour():
                self.colstripes.SetBackgroundColour(newcolour)
                self.colstripes.Refresh()
                self.utility.colstripes.Set(newcolour.Red(), newcolour.Green(), newcolour.Blue())
                if self.abcparams['stripedlist'] == '1':
                    self.queue.updateStripesColour()
        for i in xrange(16):
            col = coldata.GetCustomColour(i)
            self.abcparams['colcust%02d' % (i + 1)] = '%d,%d,%d' % (col.Red(), col.Green(), col.Blue())
        dlg.Destroy()

    def onResetDownVolSlidingWindow(self, event):
        self.queue.downvolmeasure.reset()

    def onResetDownVolFixedWindow(self, event):
        self.queue.downvolfixedwin = 0.

    def onResetUpVolSlidingWindow(self, event):
        self.queue.upvolmeasure.reset()

    def onResetUpVolFixedWindow(self, event):
        self.queue.upvolfixedwin = 0.

    def onMouseWheel(self, event):
        nextpage = self.notebook.GetSelection()
        if event.GetWheelRotation() * self.utility.mousewheelontab > 0:
            if nextpage < self.maxpage:
                nextpage += 1
            else:
                nextpage = 0
        else:
            if nextpage > 0:
                nextpage -= 1
            else:
                nextpage = self.maxpage
        self.notebook.SetSelection(nextpage)

    def onCancel(self, event = None):
        # Reset list font
        if self.listfontface != self.abcparams['listfont'] or self.listfontsize != int(self.abcparams['listfontsize']) \
           or self.listfontstyle != int(self.abcparams['listfontstyle']) or self.listfontweight != int(self.abcparams['listfontweight']):
            origfont = wx.Font(int(self.abcparams['listfontsize']), wx.DEFAULT, int(self.abcparams['listfontstyle']),
                               int(self.abcparams['listfontweight']), faceName = self.abcparams['listfont'])
            self.list.EnsureVisible(0)
            self.list.SetFont(origfont)
            self.list.Refresh()
            if self.parent.abcfind is not None:
                self.parent.abcfind.window.list.EnsureVisible(0)
                self.parent.abcfind.window.list.SetFont(origfont)
                self.parent.abcfind.window.list.Refresh()

        # Reset torrents and stripes colours
        colhaschanged = strcolhaschanged = False
        rgb = map(int, self.abcparams['colok'].split(','))
        if self.colok.GetBackgroundColour() != wx.Colour(rgb[0], rgb[1], rgb[2]):
            colhaschanged = True
            self.utility.colok.Set(rgb[0], rgb[1], rgb[2])
        rgb = map(int, self.abcparams['colnoinc'].split(','))
        if self.colnoinc.GetBackgroundColour() != wx.Colour(rgb[0], rgb[1], rgb[2]):
            colhaschanged = True
            self.utility.colnoinc.Set(rgb[0], rgb[1], rgb[2])
        rgb = map(int, self.abcparams['colnocom'].split(','))
        if self.colnocom.GetBackgroundColour() != wx.Colour(rgb[0], rgb[1], rgb[2]):
            colhaschanged = True
            self.utility.colnocom.Set(rgb[0], rgb[1], rgb[2])
        rgb = map(int, self.abcparams['colnocon'].split(','))
        if self.colnocon.GetBackgroundColour() != wx.Colour(rgb[0], rgb[1], rgb[2]):
            colhaschanged = True
            self.utility.colnocon.Set(rgb[0], rgb[1], rgb[2])
        rgb = map(int, self.abcparams['coldisc'].split(','))
        if self.coldisc.GetBackgroundColour() != wx.Colour(rgb[0], rgb[1], rgb[2]):
            colhaschanged = True
            self.utility.coldisc.Set(rgb[0], rgb[1], rgb[2])
        rgb = map(int, self.abcparams['colstripes'].split(','))
        if self.colstripes.GetBackgroundColour() != wx.Colour(rgb[0], rgb[1], rgb[2]):
            strcolhaschanged = True
            self.utility.colstripes.Set(rgb[0], rgb[1], rgb[2])
        if strcolhaschanged and self.abcparams['stripedlist'] == '1':
            if colhaschanged:
                for i in xrange(self.list.GetItemCount()):
                    self.queue.updateItemDisplay(i)
                    tor = self.queue.proctab[i]
                    if tor.abcengine:
                        if tor.infowin:
                            tor.infowin.colour.Refresh()
                        if tor.detailwin:
                            tor.detailwin.colour.Refresh()
            else:
                for i in xrange(1, self.list.GetItemCount(), 2):
                    self.queue.updateItemDisplay(i)
        elif colhaschanged:
            for tor in self.queue.proctab:
                if tor.abcengine:
                    tor.abcengine.updateColour()
                    if tor.infowin:
                        tor.infowin.colour.Refresh()
                    if tor.detailwin:
                        tor.detailwin.colour.Refresh()
        self.onClose()

    def onAdvSetting(self, event):
        if self.advancedMenuBox is not None:
            self.advancedMenuBox.Raise()
            return
        self.advancedMenuBox = ABCAdvancedOptionWindow(self)

    def onBrowseDownDir(self, event):
        folderdialog = wx.DirDialog(self, self.localize('choosedefaultdownloadfolder'), 
                                    style = wx.DD_DEFAULT_STYLE | wx.DD_NEW_DIR_BUTTON)
        if folderdialog.ShowModal() == wx.ID_OK:
            self.defaultfolder.SetValue(folderdialog.GetPath())
        folderdialog.Destroy()

    def onTorAssociate(self, event):
        if self.utility.mainport == 56666:
            commandlinemainport = ''
        else:
            commandlinemainport = ' -p ' + str(self.utility.mainport)
        # Associate .torrent files with ABC_OKC
        key = RegCreateKey(win32con.HKEY_CURRENT_USER, 'Software\\Classes\\.torrent')
        RegSetValueEx(key, '', 0, win32con.REG_SZ, 'bittorrent')
        RegSetValueEx(key, 'Content Type', 0, win32con.REG_SZ, 'application/x-bittorrent')
        RegCloseKey(key)
        # Access refused without right elevation
        # key = RegCreateKey(win32con.HKEY_CURRENT_USER, 'Software\\Classes\\MIME\\Database\\Content Type\\application/x-bittorrent')
        # RegSetValueEx(key, 'Extension', 0, win32con.REG_SZ, '.torrent')
        # RegCloseKey(key)
        key = RegCreateKey(win32con.HKEY_CURRENT_USER, 'Software\\Classes\\bittorrent')
        RegSetValueEx(key, '', 0, win32con.REG_SZ, 'TORRENT File')
        RegSetValueEx(key, 'DefaultIcon', 0, win32con.REG_SZ, path.join(self.utility.abcpath.encode(sysencoding), 'torrenticon.ico'))
        RegSetValueEx(key, 'EditFlags', 0, win32con.REG_BINARY, '\x00\x00\x01\x00')
        RegCloseKey(key)
        key = RegCreateKey(win32con.HKEY_CURRENT_USER, 'Software\\Classes\\bittorrent\\shell')
        RegSetValueEx(key, '', 0, win32con.REG_SZ, 'open')
        RegCloseKey(key)
        key = RegCreateKey(win32con.HKEY_CURRENT_USER, 'Software\\Classes\\bittorrent\\shell\\open\\command')
        RegSetValueEx(key, '', 0, win32con.REG_SZ, '"' + path.join(self.utility.abcpath.encode(sysencoding), 'abc.exe') + '"' + commandlinemainport + ' -a "%1"')
        RegCloseKey(key)

        # Associate magnet protocol with ABC_OKC
        key = RegCreateKey(win32con.HKEY_CURRENT_USER, 'Software\\Classes\\magnet')
        RegSetValueEx(key, '', 0, win32con.REG_SZ, 'URL:Magnet Protocol')
        RegSetValueEx(key, 'URL Protocol', 0, win32con.REG_SZ, '')
        RegCloseKey(key)
        key = RegCreateKey(win32con.HKEY_CURRENT_USER, 'Software\\Classes\\magnet\\DefaultIcon')
        RegSetValueEx(key, '', 0, win32con.REG_SZ, path.join(self.utility.abcpath.encode(sysencoding), 'torrenticon.ico'))
        RegCloseKey(key)
        key = RegCreateKey(win32con.HKEY_CURRENT_USER, 'Software\\Classes\\magnet\\shell\\open\\command')
        RegSetValueEx(key, '', 0, win32con.REG_SZ, '"' + path.join(self.utility.abcpath.encode(sysencoding), 'abc.exe') + '"' + commandlinemainport + ' -a "%1"')
        RegCloseKey(key)

        dlg = wx.MessageDialog(self, self.localize('fileassook'), self.localize('success'), wx.ICON_INFORMATION)
        dlg.ShowModal()
        dlg.Destroy()

    def onCleanTorrentDir(self, event):
        ctrl = wx.GetKeyState(wx.WXK_CONTROL)
        listtorfile = {}
        for torrent in self.queue.proctab:
            listtorfile[path.split(torrent.src)[1]] = 0
        tobedeleted = []
        for f in listdir(path.join(self.utility.datapath, 'torrent')):
            if f not in listtorfile:
                if f.endswith(('.pri', '.pro', '.nam', '.fns', '.prs')):
                    if f[:-4] not in listtorfile:
                        tobedeleted.append(f)
                elif not ctrl:
                    tobedeleted.append(f)
        if tobedeleted:
            dialog = ScrolledMessageDialog(self, str(len(tobedeleted)) + self.localize('cleantorrentdirtitle'), self.localize('cleantorrentdirmsg'), '\n'.join(tobedeleted))
            result = dialog.ShowModal()
            dialog.Destroy()
            if result == wx.ID_CANCEL:
                return

        nbdeletedfiles = 0
        for f in tobedeleted:
            try:
                remove(path.join(self.utility.datapath, 'torrent', f))
            except:
                pass
            else:
                nbdeletedfiles += 1
        dlg = wx.MessageDialog(self, str(nbdeletedfiles) + '/' + str(len(tobedeleted)) + self.localize('cleantorrentdirok'), self.localize('success'), wx.ICON_INFORMATION)
        dlg.ShowModal()
        dlg.Destroy()

    def onChooseListFont(self, event):
        # Choose font for lists
        data = wx.FontData()
        data.EnableEffects(False)
        data.SetInitialFont(wx.Font(self.listfontsize, wx.DEFAULT, self.listfontstyle, self.listfontweight, faceName = self.listfontface))

        dlg = wx.FontDialog(self, data)
        if dlg.ShowModal() == wx.ID_OK:
            data = dlg.GetFontData()
            font = data.GetChosenFont()
            newlistfontface = font.GetFaceName()
            newlistfontsize = font.GetPointSize()
            newlistfontstyle = font.GetStyle()
            newlistfontweight = font.GetWeight()

            if newlistfontface != self.listfontface or newlistfontsize != self.listfontsize \
               or newlistfontstyle != self.listfontstyle or newlistfontweight != self.listfontweight:
                self.listfontface = newlistfontface
                self.listfontsize = newlistfontsize
                self.listfontstyle = newlistfontstyle
                self.listfontweight = newlistfontweight
                self.list.EnsureVisible(0)
                self.list.SetFont(font)
                self.list.Refresh()
                if self.parent.abcfind is not None:
                    self.parent.abcfind.window.list.EnsureVisible(0)
                    self.parent.abcfind.window.list.SetFont(font)
                    self.parent.abcfind.window.list.Refresh()

        dlg.Destroy()

    def onApply(self, event):
        # Set new value to abcparams
        ##############################
        errortype = False

        try:
            numsim = self.numsimtext.getValue()
        except:
            dlg = wx.MessageDialog(self, self.localize('numsimintwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        try:
            numsimseed = self.numsimseedtext.getValue()
            numsimseednodown = self.numsimseednodowntext.getValue()
        except:
            dlg = wx.MessageDialog(self, self.localize('numsimseedintwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        try:
            download_rate = int(self.downloadrate.GetValue())
        except:
            errortype = True
        if errortype or download_rate and download_rate < self.utility.mindownrate:
            dlg = wx.MessageDialog(self, self.localize('downloadrateminwarning') % self.utility.mindownrate,
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        try:
            down_vol_max = float(self.downvolmax.GetValue())
        except:
            errortype = True
        if errortype or down_vol_max < 0:
            dlg = wx.MessageDialog(self, self.localize('downvolmaxwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        dtime = self.downvolcountdurd.GetValue()
        htime = self.downvolcountdurh.GetValue()
        if not dtime:
            dtime = '0'
        if not htime:
            htime = '0'
        down_vol_count_dur = 24 * int(dtime) + int(htime)
        if down_vol_count_dur < 1:
            dlg = wx.MessageDialog(self, self.localize('downvolcountdurwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False
        dtime_int, htime_int = divmod(down_vol_count_dur, 24)
        self.downvolcountdurd.SetValue(str(dtime_int))
        self.downvolcountdurh.SetValue(str(htime_int))

        try:
            down_vol_margin = float(self.downvolmargin.GetValue())
        except:
            errortype = True
        if errortype or down_vol_margin < 0  or down_vol_margin > 100:
            dlg = wx.MessageDialog(self, self.localize('downvolmarginwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        try:
            nb_pieces_fix_max_down_rate = int(self.nbpiecesfixmaxdownrate.GetValue())
        except:
            errortype = True
        if errortype or nb_pieces_fix_max_down_rate < self.utility.mindownrate and nb_pieces_fix_max_down_rate != 0:
            dlg = wx.MessageDialog(self, self.localize('downloadratefixminwarning') % self.utility.mindownrate,
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        try:
            nb_pieces_fix_trigger = int(self.nbpiecesfixtrigger.GetValue())
        except:
            errortype = True
        if errortype or nb_pieces_fix_trigger < 0:
            dlg = wx.MessageDialog(self, self.localize('nbpiecesfixtriggerintwarning'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        try:
            piece_size_fix_trigger = int(self.piecesizefixtrigger.GetValue())
        except:
            dlg = wx.MessageDialog(self, self.localize('piecesizefixtriggerintwarning'),
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        try:
            upload_rate = int(self.uploadrate.GetValue())
            seedupload_rate = int(self.seeduploadrate.GetValue())
            urmmaxsysup_rate = int(self.urmmaxsysupratetext.GetValue())
        except:
            errortype = True
        if errortype or upload_rate and upload_rate < self.utility.minuprate \
                     or seedupload_rate and seedupload_rate < self.utility.minuprate \
                     or urmmaxsysup_rate and urmmaxsysup_rate < self.utility.minuprate:
            dlg = wx.MessageDialog(self, self.localize('uploadrateminwarning') % self.utility.minuprate,
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        try:
            up_vol_max = float(self.upvolmax.GetValue())
        except:
            errortype = True
        if errortype or up_vol_max < 0:
            dlg = wx.MessageDialog(self, self.localize('upvolmaxwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        dtime = self.upvolcountdurd.GetValue()
        htime = self.upvolcountdurh.GetValue()
        if not dtime:
            dtime = '0'
        if not htime:
            htime = '0'
        up_vol_count_dur = 24 * int(dtime) + int(htime)
        if up_vol_count_dur < 1:
            dlg = wx.MessageDialog(self, self.localize('upvolcountdurwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False
        dtime_int, htime_int = divmod(up_vol_count_dur, 24)
        self.upvolcountdurd.SetValue(str(dtime_int))
        self.upvolcountdurh.SetValue(str(htime_int))

        try:
            up_vol_margin = float(self.upvolmargin.GetValue())
        except:
            errortype = True
        if errortype or up_vol_margin < 0  or up_vol_margin > 100:
            dlg = wx.MessageDialog(self, self.localize('upvolmarginwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        uwdtime = self.upwithoutdowntime.GetValue()
        uwdtimemn = self.upwithoutdowntimemn.GetValue()
        if not uwdtime:
            uwdtime = '0'
        if not uwdtimemn:
            uwdtimemn = '0'
        uwdtime_int, uwdtimemn_int = divmod(60 * int(uwdtime) + int(uwdtimemn), 60)
        uwdtime = str(uwdtime_int)
        uwdtimemn = str(uwdtimemn_int)
        self.upwithoutdowntime.SetValue(uwdtime)
        self.upwithoutdowntimemn.SetValue(uwdtimemn)

        try:
            uwdrate_int = int(self.upwithoutdownrate.GetValue())
        except:
            errortype = True
        if errortype or uwdrate_int < self.utility.minuprate:
            dlg = wx.MessageDialog(self, self.localize('upwithoutdownrateminwarning') % self.utility.minuprate,
                                   self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        try:
            lockedcompletedmax = self.lockedcompletedmaxtext.getValue()
        except:
            dlg = wx.MessageDialog(self, self.localize('lockedcompletedmaxintwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        try:
            drmtrigval = int(self.drmtriggerval.GetValue())
        except:
            dlg = wx.MessageDialog(self, self.localize('drmtriggervalwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        try:
            drmthstart = float(self.drmthresholdstarttext.GetValue())
        except:
            errortype = True
        if errortype:
            dlg = wx.MessageDialog(self, self.localize('drmthresholdwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False
        drmthstop = self.drmthresholdstoptext.GetValue()
        if drmthstop != '-':
            try:
                drmthstop = float(drmthstop)
            except:
                errortype = True
        if errortype or drmthstop != '-' and drmthstart < drmthstop:
            dlg = wx.MessageDialog(self, self.localize('drmthresholdwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        try:
            drmdel = int(self.drmdelaystarttext.GetValue())
            drmdelstop = int(self.drmdelaystoptext.GetValue())
            drmtorrentstartdel = int(self.drmtorrentstartdelaytext.GetValue())
            drmtorrentstopdel = int(self.drmtorrentstopdelaytext.GetValue())
        except:
            errortype = True
        # Check if drmdelay >= 1 s and drmdelaystop >= 1 s and drmtorrentstartdel >= 1 s and drmtorrentstopdel >= 1 s
        if errortype or drmdel < 1 or drmdelstop < 1 or drmtorrentstartdel < 1 or drmtorrentstopdel < 1:
            dlg = wx.MessageDialog(self, self.localize('drmdelayrangewarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        try:
            urmtrigval = int(self.urmtriggerval.GetValue())
        except:
            dlg = wx.MessageDialog(self, self.localize('urmtriggervalwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        try:
            urmthstart = float(self.urmthresholdstarttext.GetValue())
        except:
            errortype = True
        if errortype:
            dlg = wx.MessageDialog(self, self.localize('urmthresholdwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False
        urmthstop = self.urmthresholdstoptext.GetValue()
        if urmthstop != '-':
            try:
                urmthstop = float(urmthstop)
            except:
                errortype = True
        if errortype or urmthstop != '-' and urmthstart < urmthstop:
            dlg = wx.MessageDialog(self, self.localize('urmthresholdwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        try:
            urmdel = int(self.urmdelaystarttext.GetValue())
            urmdelstop = int(self.urmdelaystoptext.GetValue())
            urmtorrentstartdel = int(self.urmtorrentstartdelaytext.GetValue())
            urmtorrentstopdel = int(self.urmtorrentstopdelaytext.GetValue())
        except:
            errortype = True
        # Check if urmdelay >= 1 s and urmdelaystop >= 1 s and urmtorrentstartdel >= 1 s and urmtorrentstopdel < 1
        if errortype or urmdel < 1 or urmdelstop < 1 or urmtorrentstartdel < 1 or urmtorrentstopdel < 1:
            dlg = wx.MessageDialog(self, self.localize('urmdelayrangewarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        if self.singleport.GetValue() or self.singleportvalue.GetValue():
            try:
                singleportvalue = int(self.singleportvalue.GetValue())
            except:
                errortype = True
            if errortype or singleportvalue < 0 or singleportvalue > 65535:
                dlg = wx.MessageDialog(self, self.localize('singleportwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return False
        else:
            singleportvalue = ''
            
        if not self.singleport.GetValue() or self.minport.GetValue() or self.maxport.GetValue():
            try:
                minport = int(self.minport.GetValue())
                maxport = int(self.maxport.GetValue())
            except:
                errortype = True
            if errortype or minport < 0 or maxport < 0 or minport > 65535 or maxport > 65535 or minport > maxport:
                dlg = wx.MessageDialog(self, self.localize('portrangewarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return False
        else:
            minport = ''
            maxport = ''

        # Compute and check user client ids if id or mask has changed
        idlist = []
        useridlist = []
        useridmasklist = []
        for i in xrange(1, 4):
            if self.useridmaskbtn[i].GetValue():
                self.useridmask[i] = self.useridctrl[i].GetValue()
            else:
                self.userid[i] = self.useridctrl[i].GetValue()
            if self.userid[i] != self.useridlastgenerate[i] \
               or self.useridmask[i].upper() != self.useridmasklastgenerate[i].upper():
                idlist.append(i)
                useridlist.append(self.userid[i])
                useridmasklist.append(self.useridmask[i])
        if not self.generateUserPeerId(idlist, useridlist, useridmasklist):
            return False

        # Selected user id must not be empty
        if self.useragentidnb != 0 and not self.userid[self.useragentidnb]:
            dlg = wx.MessageDialog(self, self.localize('selecteduseridempty'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        if self.dht.GetValue() or self.dhtport.GetValue():
            try:
                dhtport = int(self.dhtport.GetValue())
            except:
                errortype = True
            if errortype or dhtport < 0  or dhtport > 65535:
                dlg = wx.MessageDialog(self, self.localize('dhtportrangewarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return False
        else:
            dhtport = ''

        if (self.setdefaultfolder.GetValue() or self.setextdefaultfolder.GetValue()) and self.defaultfolder.GetValue() == '':
            dlg = wx.MessageDialog(self, self.localize('nodefaultdowndirwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        # Check if default download folder is a valid Windows name
        defdestfolder = self.defaultfolder.GetValue()
        if sys.platform == 'win32' and (self.setdefaultfolder.GetValue() and self.abcparams['setdefaultfolder'] == "0" \
           or self.setextdefaultfolder.GetValue() and self.abcparams['setextdefaultfolder'] == "0" \
           or defdestfolder != self.abcparams['defaultfolder']):
            # We erase the final '\' except for a path like 'X:\'
            if defdestfolder and defdestfolder[-1] == '\\' and (len(defdestfolder) < 2 or defdestfolder[-2] != ':'):
                defdestfolder = defdestfolder[:-1]
            defdestfolder = defdestfolder.rstrip(whitespace + '.')
            if not self.utility.checkWinPath(self, defdestfolder):
                return False

        if self.utility.tweakdynmaxuprate == 1:
            try:
                urmupfromdownA = float(self.urmupfromdownAtext.GetValue())
                urmupfromdownB = float(self.urmupfromdownBtext.GetValue())
                urmupfromdownC = float(self.urmupfromdownCtext.GetValue())
                urmupfromdownD = float(self.urmupfromdownDtext.GetValue())
                urmupfromdownE = float(self.urmupfromdownEtext.GetValue())
                urmupfromdownF = float(self.urmupfromdownFtext.GetValue())
                urmupfromdownG = float(self.urmupfromdownGtext.GetValue())
            except: # not float or integer
                dlg = wx.MessageDialog(self, self.localize('urmfactrangewarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return False

        if self.utility.tweakbandwidthdistribution == 1:
            try:
                bdcalcdownth1 = float(self.bdcalcdownth1.GetValue())
                bdcalcdownth2 = float(self.bdcalcdownth2.GetValue())
                bdcalcupth1 = float(self.bdcalcupth1.GetValue())
                bdcalcupth2 = float(self.bdcalcupth2.GetValue())
            except: # not float
                dlg = wx.MessageDialog(self, self.localize('bdparamrangewarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return False

        try:
            activitymaxtor = self.activitymaxtext.getValue()
        except:
            dlg = wx.MessageDialog(self, self.localize('activitymaxtorintwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False
        try:
            drmmaxtor = self.drmmaxtorrenttext.getValue()
        except:
            dlg = wx.MessageDialog(self, self.localize('drmmaxtorintwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False
        try:
            urmmaxtor = self.urmmaxtorrenttext.getValue()
        except:
            dlg = wx.MessageDialog(self, self.localize('urmmaxtorintwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False
        # If not in single port mode :
        # Check if "max number of simultaneous downloads and seeds" + "URM number of extra torrent" (if URM is running)
        # + "DRM number of extra torrent" (if DRM is running) + "Activity number of extra torrent" is lower than the available number of ports.
        if not self.singleport.GetValue():
            totalmaxdownload = max(numsim + numsimseed, numsimseednodown)
            if self.activityextra.GetValue():
                totalmaxdownload += activitymaxtor
            if self.drm.GetValue():
                totalmaxdownload += drmmaxtor
            if self.urm.GetValue():
                totalmaxdownload += urmmaxtor
            if totalmaxdownload > maxport - minport + 1:
                dlg = wx.MessageDialog(self, self.localize('maxsimdownloadwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()
                return False

        try:
            actthdown = float(self.activitythdown.GetValue())
            actthup = float(self.activitythup.GetValue())
            actdelay = int(self.activitydelay.GetValue())
        except:
            dlg = wx.MessageDialog(self, self.localize('activityrangewarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False
        if actthdown < 0 or actthup < 0 or actdelay < 0:
            dlg = wx.MessageDialog(self, self.localize('activityrangewarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        try:
            diskfullthint = int(self.diskfullth.GetValue())
        except:
            dlg = wx.MessageDialog(self, self.localize('diskfullthintwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        if diskfullthint < 5:
            dlg = wx.MessageDialog(self, self.localize('diskfullthminwarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        ############################################### End for checkings ###################################################################"


        if download_rate > self.utility.maxdown \
           and self.queue.torrentdownloading:
            self.queue.drminitialstartingtime = clock()
        self.abcparams['maxdownloadrate'] = str(download_rate)
        self.utility.maxdown = float(download_rate)

        self.abcparams['downvolcheck'] = str(int(self.downvolcheck.GetValue()))

        self.abcparams['downvolmax'] = str(down_vol_max)
        self.queue.downvolmax = long(down_vol_max * 1073741824)

        self.abcparams['downvolcountdur'] = str(down_vol_count_dur)
        down_vol_count_dur *= 3600
        self.queue.updateDownVolWindow(down_vol_count_dur)

        if self.downvolwinsliding.GetValue():
            self.abcparams['downvolwindowtype'] = "0"
        else:
            self.abcparams['downvolwindowtype'] = "1"

        self.abcparams['downvolmargin'] = str(down_vol_margin)
        self.queue.downvolthreshold = (100 - down_vol_margin) / 100

        down_vol_check_time = int(self.downvolwinfixeddatetime.getValue())
        down_vol_check_cycle = max(-1, (int(time()) - down_vol_check_time) / down_vol_count_dur)
        if down_vol_check_cycle >= 0:
            down_vol_check_time += down_vol_check_cycle * down_vol_count_dur
            if down_vol_check_time != self.queue.downvolchecktime:
                self.queue.downvolfixedwin = 0.
                self.queue.downvolchecktime = down_vol_check_time
                self.queue.downvolcheckcycle = 0
        else:
            self.queue.downvolfixedwin = 0.
            self.queue.downvolchecktime = down_vol_check_time
            self.queue.downvolcheckcycle = -1
        self.abcparams['downvolchecktime'] = str(self.queue.downvolchecktime)

        self.abcparams['nbpiecesfix'] = str(int(self.nbpiecesfix.GetValue()))
        self.utility.nbpiecesfixmaxdownrate = nb_pieces_fix_max_down_rate
        self.abcparams['nbpiecesfixmaxdownrate'] = str(nb_pieces_fix_max_down_rate)
        self.utility.nbpiecesfixtrigger = nb_pieces_fix_trigger
        self.abcparams['nbpiecesfixtrigger'] = str(nb_pieces_fix_trigger)
        self.utility.piecesizefixtrigger = piece_size_fix_trigger * 1024
        self.abcparams['piecesizefixtrigger'] = str(piece_size_fix_trigger)

        if not self.urmdynmaxuprate.GetValue() and upload_rate > self.utility.maxup \
           and self.queue.torrentdownloading:
            self.queue.urminitialstartingtime = clock()
        self.abcparams['maxuploadrate'] = str(upload_rate)
        self.utility.maxup = float(upload_rate)

        self.abcparams['upvolcheck'] = str(int(self.upvolcheck.GetValue()))

        self.abcparams['upvolmax'] = str(up_vol_max)
        self.queue.upvolmax = long(up_vol_max * 1073741824)

        self.abcparams['upvolcountdur'] = str(up_vol_count_dur)
        self.queue.updateUpVolWindow(up_vol_count_dur * 3600)

        if self.upvolwinsliding.GetValue():
            self.abcparams['upvolwindowtype'] = "0"
        else:
            self.abcparams['upvolwindowtype'] = "1"

        self.abcparams['upvolmargin'] = str(up_vol_margin)
        self.queue.upvolthreshold = (100 - up_vol_margin) / 100

        up_vol_check_time = int(self.upvolwinfixeddatetime.getValue())
        up_vol_check_cycle = max(-1, (int(time()) - up_vol_check_time) / self.queue.upvolcountdur)
        if up_vol_check_cycle >= 0:
            up_vol_check_time += up_vol_check_cycle * self.queue.upvolcountdur
            if up_vol_check_time != self.queue.upvolchecktime:
                self.queue.upvolfixedwin = 0.
                self.queue.upvolchecktime = up_vol_check_time
                self.queue.upvolcheckcycle = 0
        else:
            self.queue.upvolfixedwin = 0.
            self.queue.upvolchecktime = up_vol_check_time
            self.queue.upvolcheckcycle = -1
        self.abcparams['upvolchecktime'] = str(self.queue.upvolchecktime)

        self.utility.upwithoutdown = int(self.upwithoutdown.GetValue())
        self.abcparams['upwithoutdown'] = str(self.utility.upwithoutdown)

        self.abcparams['upwithoutdowntime'] = uwdtime
        self.abcparams['upwithoutdowntimemn'] = uwdtimemn
        self.utility.upwithoutdowntime = uwdtime_int * 3600 + uwdtimemn_int * 60

        self.utility.upwithoutdown2 = int(self.upwithoutdown2.GetValue())
        self.abcparams['upwithoutdown2'] = str(self.utility.upwithoutdown2)

        self.utility.upwithoutdownrate = uwdrate_int
        self.abcparams['upwithoutdownrate'] = str(uwdrate_int)

        if not self.urmdynmaxuprate.GetValue() and seedupload_rate > self.utility.maxseedup \
           and not self.queue.torrentdownloading:
            self.queue.urminitialstartingtime = clock()
        self.abcparams['maxseeduploadrate'] = str(seedupload_rate)
        self.utility.maxseedup = float(seedupload_rate)

        self.abcparams['urmmaxsysuprate'] = str(urmmaxsysup_rate)
        oldurmmaxsysup_rate = self.utility.maxsysup
        self.utility.maxsysup = float(urmmaxsysup_rate)

        if self.urmdynmaxuprate.GetValue():
            if self.abcparams['urmdynmaxuprate'] == "0" or urmmaxsysup_rate > oldurmmaxsysup_rate:
                self.queue.urminitialstartingtime = clock()
            if self.abcparams['urmdynmaxuprate'] == "0":
                self.abcparams['urmdynmaxuprate'] = "1"
        elif self.abcparams['urmdynmaxuprate'] == "1":
            self.abcparams['urmdynmaxuprate'] = "0"
            self.queue.urminitialstartingtime = clock()

        if self.utility.tweakdynmaxuprate == 1:
            self.utility.urmupfromdownA = urmupfromdownA
            self.utility.urmupfromdownB = urmupfromdownB
            self.utility.urmupfromdownC = urmupfromdownC
            self.utility.urmupfromdownD = urmupfromdownD
            self.utility.urmupfromdownE = urmupfromdownE
            self.utility.urmupfromdownF = urmupfromdownF
            self.utility.urmupfromdownG = urmupfromdownG
            self.abcparams['urmupfromdownA'] = str(urmupfromdownA)
            self.abcparams['urmupfromdownB'] = str(urmupfromdownB)
            self.abcparams['urmupfromdownC'] = str(urmupfromdownC)
            self.abcparams['urmupfromdownD'] = str(urmupfromdownD)
            self.abcparams['urmupfromdownE'] = str(urmupfromdownE)
            self.abcparams['urmupfromdownF'] = str(urmupfromdownF)
            self.abcparams['urmupfromdownG'] = str(urmupfromdownG)

        if self.utility.tweakbandwidthdistribution == 1:
            self.utility.bdcalcdownth1 = bdcalcdownth1
            self.utility.bdcalcdownth2 = bdcalcdownth2
            self.utility.bdcalcupth1 = bdcalcupth1
            self.utility.bdcalcupth2 = bdcalcupth2
            self.abcparams['bdcalcdownth1'] = str(bdcalcdownth1)
            self.abcparams['bdcalcdownth2'] = str(bdcalcdownth2)
            self.abcparams['bdcalcupth1'] = str(bdcalcupth1)
            self.abcparams['bdcalcupth2'] = str(bdcalcupth2)

        self.abcparams['prioritizelocaldown'] = str(int(self.prioritizelocaldown.GetValue()))

        self.abcparams['prioritizelocal'] = str(int(self.prioritizelocal.GetValue()))

        self.abcparams['fastresume'] = str(int(self.fastresume.GetValue()))

        self.abcparams['fastresumefirst'] = str(int(self.fastresumefirst.GetValue()))

        self.abcparams['sbqueued'] = str(int(self.sbqueued.GetValue()))

        oldcountsbasseed = self.utility.countsbasseed
        self.utility.countsbasseed = int(self.countsbasseed.GetValue())
        self.abcparams['countsbasseed'] = str(self.utility.countsbasseed)
        if self.utility.countsbasseed != oldcountsbasseed:
            if self.utility.countsbasseed:
                self.queue.startStandbySeeding()
            else:
                self.queue.stopStandbySeeding()

        self.abcparams['schedonhold'] = str(int(self.schedonhold.GetValue()))

        self.abcparams['schedstopsman'] = str(int(self.schedstopsman.GetValue()))

        self.abcparams['lockedcompletedcheck'] = str(int(self.lockedcompletedcheck.GetValue()))

        self.abcparams['lockedcompletedmax'] = str(lockedcompletedmax)

        self.abcparams['stoprejected'] = str(int(self.stoprejected.GetValue()))

        self.abcparams['rejectexceptions'] = self.rejectexceptions.GetValue()
        self.queue.rejectexceptions[:] = []
        for s in self.rejectexceptions.GetValue().split():
            self.queue.rejectexceptions.append(s)

        self.abcparams['timeoutwhenextra'] = str(int(self.timeoutwhenextra.GetValue()))

        self.abcparams['canceltimeouts'] = str(int(self.canceltimeouts.GetValue()))

        self.abcparams['canceltimeoutsmsg'] = self.canceltimeoutsmsg.GetValue()
        self.queue.canceltimeoutsmsg[:] = []
        for s in self.canceltimeoutsmsg.GetValue().split():
            self.queue.canceltimeoutsmsg.append(s)

        self.utility.resettimeoutsonstart = int(self.resettimeoutsonstart.GetValue())
        self.abcparams['resettimeoutsonstart'] = str(self.utility.resettimeoutsonstart)

        self.abcparams['sbtimeout'] = str(int(self.sbtimeout.GetValue()))

        self.abcparams['sbtimeoutvalue'] = str(int(self.sbtimeoutvalue.GetValue()))

        self.abcparams['sbtimeoutaction'] = str(self.sbtimeoutaction.GetSelection())

        self.abcparams['torrentwhencompleted'] = str(self.torrentwhencompleted.GetSelection())

        self.abcparams['torrentwhenfinished'] = str(self.torrentwhenfinished.GetSelection())

        self.abcparams['sortbytime'] = str(int(self.sortbytime.GetValue()))

        self.abcparams['sorttoronclose'] = str(int(self.sorttoronclose.GetValue()))

        self.abcparams['activitythdown'] = str(actthdown)
        self.queue.activitythdown = actthdown
        self.abcparams['activitythup'] = str(actthup)
        self.queue.activitythup = actthup
        self.abcparams['activitydelay'] = str(actdelay)
        self.queue.activitydelay = actdelay

        newdrm = str(int(self.drm.GetValue()))
        if newdrm != self.abcparams['drm']:
            self.queue.resetDRMTimes()
            self.abcparams['drm'] = newdrm
        self.abcparams['drmonhold'] = str(int(self.drmonhold.GetValue()))
        self.abcparams['drmstopsman'] = str(int(self.drmstopsman.GetValue()))
        self.abcparams['drmstoponpause'] = str(int(self.drmstoponpause.GetValue()))
        self.abcparams['drmlowpriority'] = str(int(self.drmlowpriority.GetValue()))
        self.abcparams['drmtrigger'] = str(int(self.drmtrigger[1].GetValue()))
        self.abcparams['drmtriggerval'] = str(drmtrigval)
        self.abcparams['drmthresholdstart'] = str(drmthstart)
        self.utility.drmthresholdstart = drmthstart
        self.abcparams['drmthresholdstop'] = str(drmthstop)
        self.utility.drmthresholdstop = drmthstop
        self.abcparams['drmmaxtorrent'] = str(drmmaxtor)
        self.utility.drmmaxtorrent = drmmaxtor
        self.abcparams['drmdelay'] = str(drmdel)
        self.utility.drmdelay = drmdel
        self.abcparams['drmdelaystop'] = str(drmdelstop)
        self.utility.drmdelaystop = drmdelstop
        self.abcparams['drmtorrentstartdelay'] = str(drmtorrentstartdel)
        self.utility.drmtorrentstartdelay = drmtorrentstartdel
        self.abcparams['drmtorrentstopdelay'] = str(drmtorrentstopdel)
        self.utility.drmtorrentstopdelay = drmtorrentstopdel

        newurm = str(int(self.urm.GetValue()))
        if newurm != self.abcparams['urm']:
            self.queue.resetURMTimes()
            self.abcparams['urm'] = newurm
        self.abcparams['urm'] = newurm
        self.abcparams['urmonhold'] = str(int(self.urmonhold.GetValue()))
        self.abcparams['urmstopsman'] = str(int(self.urmstopsman.GetValue()))
        self.abcparams['urmstoponpause'] = str(int(self.urmstoponpause.GetValue()))
        self.abcparams['urmlowpriority'] = str(int(self.urmlowpriority.GetValue()))
        self.abcparams['urmtrigger'] = str(int(self.urmtrigger[1].GetValue()))
        self.abcparams['urmtriggerval'] = str(urmtrigval)
        self.abcparams['urmthresholdstart'] = str(urmthstart)
        self.utility.urmthresholdstart = urmthstart
        self.abcparams['urmthresholdstop'] = str(urmthstop)
        self.utility.urmthresholdstop = urmthstop
        self.abcparams['urmmaxtorrent'] = str(urmmaxtor)
        self.utility.urmmaxtorrent = urmmaxtor
        self.abcparams['urmdelay'] = str(urmdel)
        self.utility.urmdelay = urmdel
        self.abcparams['urmdelaystop'] = str(urmdelstop)
        self.utility.urmdelaystop = urmdelstop
        self.abcparams['urmtorrentstartdelay'] = str(urmtorrentstartdel)
        self.utility.urmtorrentstartdelay = urmtorrentstartdel
        self.abcparams['urmtorrentstopdelay'] = str(urmtorrentstopdel)
        self.utility.urmtorrentstopdelay = urmtorrentstopdel

        self.abcparams['scheddonthalt'] = str(int(self.scheddonthalt.GetValue()))
        self.abcparams['scheddonthaltuprategap'] = str(int(self.scheddonthaltuprategap.GetValue()))

        self.abcparams['activityextra'] = str(int(self.activityextra.GetValue()))
        self.queue.activitymax = activitymaxtor
        activitymaxseed = int(round(activitymaxtor * float(self.abcparams['activitymaxforseed'])))
        self.queue.activitymaxseed = activitymaxseed
        self.queue.activitymaxdown = activitymaxtor - activitymaxseed

        self.abcparams['activitymax'] = str(activitymaxtor)

        extratobestopped_int = self.extratobestopped.Get3StateValue()
        self.abcparams['extratobestopped'] = str(extratobestopped_int)
        self.queue.extratobestoppedmode = extratobestopped_int

        self.abcparams['extratobestoppedfail'] = str(int(self.extratobestoppedfail.GetValue()))

        self.abcparams['pl'] = str(int(self.singleport.GetValue()))
        self.abcparams['plport'] = str(singleportvalue)
        self.abcparams['minport'] = str(minport)
        self.abcparams['maxport'] = str(maxport)
        self.abcparams['upnp'] = str(self.upnp.GetSelection())

        self.abcparams['useragentid'] = str(self.useragentidnb)
        updateIdRandoms(self._idrandoms)
        self.currentclientid.SetValue(self.utility.binToString(createPeerID(useragentidnb = self.useragentidnb)))
        for i in xrange(1, 4):
            self.abcparams['useragent' + str(i)] = self.useragentctrl[i].GetValue()
            self.abcparams['userextended' + str(i)] = self.userextendedctrl[i].GetValue()            
            self.abcparams['userid' + str(i)] = self.userid[i]
            self.abcparams['useridmask' + str(i)] = self.useridmask[i]
        self.useridlastgenerate = self.userid[:]
        self.useridmasklastgenerate = self.useridmask[:]
        # Set HTTP useragent in BitTornado
        if self.useragentidnb == 0:
            useragent = self.parent.defuseragent
            userextended = self.parent.defuserextended
        else:
            useragent = self.abcparams['useragent' + str(self.useragentidnb)]
            userextended = self.abcparams['userextended' + str(self.useragentidnb)]
        setUserAgent(useragent, userextended)
        # Set peer ID in BitTornado
        setPeerID()

        if CRYPTO_OK:
            for i in xrange(4):
                if self.crypto[i].GetValue():
                    break
            self.abcparams['crypto'] = str(i)

        self.abcparams['numsimdownload'] = str(numsim)
        self.queue.maxnumsim = numsim

        self.abcparams['numsimseed'] = str(numsimseed)
        self.queue.maxnumsimseed = numsimseed

        self.abcparams['numsimseednodown'] = str(numsimseednodown)
        self.queue.maxnumsimseednodown = numsimseednodown

        self.abcparams['defaultpriority'] = str(self.defaultpriority.GetSelection())

        self.abcparams['diskfullth'] = str(diskfullthint)

        self.abcparams['completedresumedelay'] = str(int(self.completedresumedelay.GetValue()))

        selectedlanguage = self.languagechoice.GetSelection()
        if selectedlanguage > -1:
            self.abcparams['language_file'] = self.languagefiles[selectedlanguage]
        else:
            self.abcparams['language_file'] = ""

        self.abcparams['removetorrent'] = str(int(self.removetorrent.GetValue()))

        if self.keepeta.GetValue():
            if self.abcparams['keepeta'] == "0":
                self.abcparams['keepeta'] = "1"
                rank = self.parent.guiman.getRankfromID(8)
                if rank != -1:
                    for index in xrange(len(self.queue.proctab)):
                        torrent = self.queue.proctab[index]
                        if not torrent.abcengine and torrent.status != 'standby':
                            if torrent.status != 'finished':
                                if torrent.complete:
                                    if torrent.uploadoption == 0:
                                        self.list.SetStringItem(index, rank, self.localize('etaS') + '     oo')
                                    elif torrent.uploadoption == 2:
                                        self.list.SetStringItem(index, rank, self.localize('etaS') + "      ?")
                                    else:
                                        self.list.SetStringItem(index, rank, self.localize('etaS') + " "
                                                                + self.utility.eta_value(torrent.seedingtimeleft))
                                else:
                                    self.list.SetStringItem(index, rank, self.localize('etaD') + "      ?")
        elif self.abcparams['keepeta'] == "1":
            self.abcparams['keepeta'] = "0"
            rank = self.parent.guiman.getRankfromID(8)
            if rank != -1:
                for index in xrange(len(self.queue.proctab)):
                    torrent = self.queue.proctab[index]
                    if not torrent.abcengine and torrent.status != 'standby':
                        self.list.SetStringItem(index, rank, "")

        self.abcparams['defaultfolder'] = defdestfolder
        self.abcparams['setdefaultfolder'] = str(int(self.setdefaultfolder.GetValue()))
        self.abcparams['setextdefaultfolder'] = str(int(self.setextdefaultfolder.GetValue()))

        self.abcparams['movedataonstatus'] = str(int(self.movedataonstatus.GetValue()))

        self.abcparams['movedatastatus'] = str(self.movedatastatus.GetSelection())

        self.abcparams['movedataondelete'] = str(int(self.movedataondelete.GetValue()))

        self.abcparams['keepmagnetname'] = str(int(self.keepmagnetname.GetValue()))

        for i in xrange(2):
            if self.dupdest[i].GetValue():
                break
        self.abcparams['askduplicatedest'] = str(i)

        for i in xrange(3):
            if self.longpath[i].GetValue():
                break
        self.utility.initPathNameMaxLength(i)
        self.abcparams['longpath'] = str(i)

        self.abcparams['defrentorwithdest'] = str(int(self.defrentorwithdest.GetValue()))

        self.abcparams['diskfullman'] = str(int(self.diskfullman.GetValue()))
        self.abcparams['diskfullmode'] = str(self.diskfullmode.GetSelection())

        tbstyle = -1
        if self.flattopbtn.GetValue():
            if self.abcparams['flattopbtn'] == "0":
                self.abcparams['flattopbtn'] = "1"
                tbstyle = wx.TB_HORIZONTAL | wx.NO_BORDER | wx.TB_TEXT | wx.TB_FLAT
        elif self.abcparams['flattopbtn'] == "1":
            self.abcparams['flattopbtn'] = "0"
            tbstyle = wx.TB_HORIZONTAL | wx.NO_BORDER | wx.TB_TEXT
        if tbstyle != -1:
            self.parent.setToolbarStyle(tbstyle)
            self.parent.window.rsspanel.setToolbarStyle(tbstyle | wx.TB_NODIVIDER)

        self.abcparams['mintray'] = str(int(self.mintray.GetValue()))

        self.abcparams['quickmetainfo'] = str(self.quickmetainfo.GetSelection())

        self.abcparams['centerquickdetails'] = str(self.centerquickdetails.GetSelection())

        self.abcparams['centerdetoneachother'] = str(self.centerdetoneachother.Get3StateValue())

        if self.sizeinmb.GetValue() != (self.abcparams['sizeinmb'] == "1") \
           or self.displayunitsize.GetValue() != (self.abcparams['displayunitsize'] == "1"):
            self.abcparams['sizeinmb'] = str(int(self.sizeinmb.GetValue()))
            self.abcparams['displayunitsize'] = str(int(self.displayunitsize.GetValue()))
            ranksize = self.parent.guiman.getRankfromID(9)
            rankdownsize = self.parent.guiman.getRankfromID(18)
            rankupsize = self.parent.guiman.getRankfromID(19)
            for index in xrange(len(self.queue.proctab)):
                torrent = self.queue.proctab[index]
                if ranksize != -1:
                    if torrent.magnet:
                        self.list.SetStringItem(index, ranksize, '?')
                    else:
                        self.list.SetStringItem(index, ranksize, self.utility.formatedSize(torrent.requestedsize)[0])
                if not torrent.abcengine or torrent.status == 'pause' or torrent.status == 'onhold':
                    if rankdownsize != -1:
                        self.list.SetStringItem(index, rankdownsize, self.utility.formatedSize(torrent.downsize)[0])
                    if rankupsize != -1:
                        self.list.SetStringItem(index, rankupsize, self.utility.formatedSize(torrent.upsize)[0])
                    # Update display format for already opened advanced details window
                    if torrent.detailwin is not None:
                        torrent.detailwin.updateSize()

        if self.displayunitrate.GetValue():
            if self.abcparams['displayunitrate'] == "0":
                self.abcparams['displayunitrate'] = "1"
                ranktotalspeed = self.parent.guiman.getRankfromID(20)
                if ranktotalspeed != -1:
                    totalspeedunit = ' ' + self.utility.kbps
                    for index in xrange(len(self.queue.proctab)):
                        torrent = self.queue.proctab[index]
                        if torrent.status == 'pause' or torrent.status == 'onhold':
                            self.list.SetStringItem(index, ranktotalspeed, self.list.GetItem(index, ranktotalspeed).GetText() + totalspeedunit)
        elif self.abcparams['displayunitrate'] == "1":
            self.abcparams['displayunitrate'] = "0"
            ranktotalspeed = self.parent.guiman.getRankfromID(20)
            if ranktotalspeed != -1:
                totalspeedunitlength = len(self.utility.kbps) + 1
                for index in xrange(len(self.queue.proctab)):
                    torrent = self.queue.proctab[index]
                    if torrent.status == 'pause' or torrent.status == 'onhold':
                        self.list.SetStringItem(index, ranktotalspeed, self.list.GetItem(index, ranktotalspeed).GetText()[:-totalspeedunitlength])

        self.abcparams['scrolllistud'] = str(int(self.scrolllistud.GetValue()))

        self.abcparams['scrolllisttb'] = str(int(self.scrolllisttb.GetValue()))

        self.abcparams['rubmessages'] = str(int(self.rubmessages.GetValue()))

        self.abcparams['rubmsgbutton'] = str(self.rubmsgbutton.GetSelection())

        if self.msgindetails.GetValue():
            if self.abcparams['msgindetails'] == "0":
                self.abcparams['msgindetails'] = "1"
                self.abcparams['emptymsgindetails'] = str(int(self.emptymsgindetails.GetValue()))
                # Update details win if open
                for torrent in self.queue.proctab:
                    if torrent.infowin is not None and (torrent.message or self.abcparams['emptymsgindetails'] == "1"):
                        torrent.infowin.showMessage()
            elif self.emptymsgindetails.GetValue():
                if self.abcparams['emptymsgindetails'] == "0":
                    self.abcparams['emptymsgindetails'] = "1"
                    for torrent in self.queue.proctab:
                        if torrent.infowin is not None and not torrent.message:
                            torrent.infowin.showMessage()
            elif self.abcparams['emptymsgindetails'] == "1":
                self.abcparams['emptymsgindetails'] = "0"
                for torrent in self.queue.proctab:
                    if torrent.infowin is not None and not torrent.message:
                        torrent.infowin.hideMessage()
        else:
            self.abcparams['emptymsgindetails'] = str(int(self.emptymsgindetails.GetValue()))
            if self.abcparams['msgindetails'] == "1":
                self.abcparams['msgindetails'] = "0"
                # Update details win if open
                for torrent in self.queue.proctab:
                    if torrent.infowin is not None:
                        torrent.infowin.hideMessage()

        self.abcparams['keeptermevtmsg'] = str(int(self.keeptermevtmsg.GetValue()))

        self.abcparams['displaytrackcnxmsg'] = str(int(self.displaytrackcnxmsg.GetValue()))

        self.abcparams['displaytrackcnxwng'] = str(int(self.displaytrackcnxwng.GetValue()))

        self.abcparams['erasetrackal'] = str(int(self.erasetrackal.GetValue()))

        self.abcparams['displayscrapingmsg'] = str(int(self.displayscrapingmsg.GetValue()))

        self.abcparams['displayscrapestatus'] = str(int(self.displayscrapestatus.GetValue()))

        self.abcparams['displaycheckstatus'] = str(int(self.displaycheckstatus.GetValue()))

        self.abcparams['displaytimeout'] = str(int(self.displaytimeout.GetValue()))

        self.abcparams['mousemode'] = str(int(self.mousemode.GetValue()))

        self.abcparams['scrollbelowfinished'] = str(int(self.scrollbelowfinished.GetValue()))

        self.abcparams['popuploaded'] = str(int(self.popuploaded.GetValue()))

        self.abcparams['countonhold'] = str(int(self.countonhold.GetValue()))

        showschedbtnconf = self.showschedcounters.Get3StateValue()
        if showschedbtnconf == 0 or showschedbtnconf == 2 and self.abcparams['drm'] == "0" and self.abcparams['urm'] == "0":
            self.parent.abc_sb.hideCell(7)
        self.abcparams['showschedcounters'] = str(showschedbtnconf)

        self.abcparams['countonlyalive'] = str(int(self.countonlyalive.GetValue()))

        self.abcparams['displaydownvol'] = str(int(self.displaydownvol.GetValue()))

        self.abcparams['displayupvol'] = str(int(self.displayupvol.GetValue()))

        self.abcparams['savesizesonexit'] = str(int(self.savesizesonexit.GetValue()))

        self.utility.exitwindow = self.exitwindow.Get3StateValue()
        self.abcparams['exitwindow'] = str(self.utility.exitwindow)
        
        self.abcparams['abcproc'] = str(int(self.abcproc.GetValue()))

        self.abcparams['confirmonclose'] = str(int(self.confirmonclose.GetValue()))

        for i in xrange(3):
            if self.trig_finish_seed[i].GetValue():
                break
        oldtrig = self.abcparams['trigwhenfinishseed']
        if str(i) != oldtrig:
            if i == 2:
                # Only seed
                self.queue.setSchedulerModeToSeeding(oldtrig)
            self.abcparams['trigwhenfinishseed'] = str(i)
            self.abcparams['schedonlyonhold'] = '0'
            trignexttorrentonlyseedind = self.localize('schedmodeseedcap')
            if trignexttorrentonlyseedind:
                if i == 2:
                    self.utility.frame.SetTitle(self.localize('mainwindowtitle') + trignexttorrentonlyseedind)
                elif oldtrig == '2':
                    self.utility.frame.SetTitle(self.localize('mainwindowtitle'))

        needslayout = False

        movetopbtnconf = self.movemidbtn.Get3StateValue()
        if movetopbtnconf != int(self.abcparams['movemidbtn']):
            self.abcparams['movemidbtn'] = str(movetopbtnconf)
            if movetopbtnconf == 0:
                self.parent.window.buttontop.Show()
                self.parent.window.buttonmid.Hide()
            elif movetopbtnconf == 1:
                self.parent.window.buttontop.Hide()
                self.parent.window.buttonmid.Show()
            else:
                self.parent.window.buttontop.Show()
                self.parent.window.buttonmid.Show()
            needslayout = True

        if self.stopresallbtn.GetValue():
            if self.abcparams['stopresallbtn'] == "0":
                self.abcparams['stopresallbtn'] = "1"
                self.parent.window.stopallbutton.Show()
                self.parent.window.resumeallbutton.Show()
                needslayout = True
        elif self.abcparams['stopresallbtn'] == "1":
            self.abcparams['stopresallbtn'] = "0"
            self.parent.window.stopallbutton.Hide()
            self.parent.window.resumeallbutton.Hide()
            needslayout = True

        if self.stoptrafficbtn.GetValue():
            if self.abcparams['stoptrafficbtn'] == "0":
                self.abcparams['stoptrafficbtn'] = "1"
                self.parent.window.stoptrafficbutton.Show()
                needslayout = True
        elif self.abcparams['stoptrafficbtn'] == "1":
            self.abcparams['stoptrafficbtn'] = "0"
            self.parent.window.stoptrafficbutton.Hide()
            needslayout = True

        if self.schedulerbtn.GetValue():
            if self.abcparams['schedulerbtn'] == "0":
                self.abcparams['schedulerbtn'] = "1"
                self.parent.window.schedulerbutton.Show()
                needslayout = True
        elif self.abcparams['schedulerbtn'] == "1":
            self.abcparams['schedulerbtn'] = "0"
            self.parent.window.schedulerbutton.Hide()
            needslayout = True

        if self.scannerbtn.GetValue():
            if self.abcparams['scannerbtn'] == "0":
                self.abcparams['scannerbtn'] = "1"
                self.parent.window.scannerbutton.Show()
                needslayout = True
        elif self.abcparams['scannerbtn'] == "1":
            self.abcparams['scannerbtn'] = "0"
            self.parent.window.scannerbutton.Hide()
            needslayout = True

        if self.webservbtn.GetValue():
            if self.abcparams['webservbtn'] == "0":
                self.abcparams['webservbtn'] = "1"
                self.parent.window.webservicebutton.Show()
                needslayout = True
        elif self.abcparams['webservbtn'] == "1":
            self.abcparams['webservbtn'] = "0"
            self.parent.window.webservicebutton.Hide()
            needslayout = True

        needsrestyle = False
        if self.flatbotbtn.GetValue():
            if self.abcparams['flatbotbtn'] == "0":
                self.abcparams['flatbotbtn'] = "1"
                needsrestyle = True
                flat = True
        elif self.abcparams['flatbotbtn'] == "1":
            self.abcparams['flatbotbtn'] = "0"
            needsrestyle = True
            flat = False
        if needsrestyle:
            self.parent.window.buttonup.setFlat(flat)
            self.parent.window.buttondown.setFlat(flat)
            self.parent.window.buttontop.setFlat(flat)
            self.parent.window.buttonmid.setFlat(flat)
            self.parent.window.buttonbottom.setFlat(flat)
            self.parent.window.modebutton.setFlat(flat)
            self.parent.window.stoptrafficbutton.setFlat(flat)
            self.parent.window.stopallbutton.setFlat(flat)
            self.parent.window.resumeallbutton.setFlat(flat)
            self.parent.window.pauseallbutton.setFlat(flat)
            self.parent.window.clearcompletedbutton.setFlat(flat)
            self.parent.window.schedulerbutton.setFlat(flat)
            self.parent.window.scannerbutton.setFlat(flat)
            self.parent.window.webservicebutton.setFlat(flat)

        if needslayout:
            if self.abcparams['schedulerbtn'] == "0" and self.abcparams['scannerbtn'] == "0" \
               and self.abcparams['webservbtn'] == "0":
                self.parent.window.bottomlinespace.Hide()
            else:
                self.parent.window.bottomlinespace.Show()
            self.parent.window.bottomline.Layout()
            self.parent.window.bottompanel.Fit()

        if needsrestyle or needslayout:
            self.parent.window.bottompanel.Refresh()

        newutpex = self.utpex.GetValue()
        if newutpex != self.abcparams['utpex']:
            self.abcparams['utpex'] = str(int(newutpex))
            for tor in self.queue.proctab:
                if tor.abcengine and tor.abcengine.dow:
                    tor.abcengine.dow.setPex(newutpex)

        self.abcparams['dht'] = str(int(self.dht.GetValue()))
        self.abcparams['dhtport'] = str(dhtport)

        self.utility.dhtsecurityextension = int(self.dhtsecurityextension.GetValue())
        self.abcparams['dhtsecurityextension'] = str(self.utility.dhtsecurityextension)

        self.utility.skipcertifverif = int(self.skipcertifverif.GetValue())
        self.abcparams['skipcertifverif'] = str(self.utility.skipcertifverif)

        if self.utility.hasipv6:
            self.abcparams['ipv6'] = str(int(self.ipv6.GetValue()))
        else:
            self.abcparams['ipv6'] = "0"

        self.abcparams['kickban'] = str(int(self.kickban.GetValue()))

        self.abcparams['notsameip'] = str(int(self.notsameip.GetValue()))

        self.abcparams['scrape'] = str(int(self.scrape.GetValue()))

        self.abcparams['inttrackwhencompleted'] = str(int(self.inttrackwhencompleted.GetValue()))

        # oldcheckinttrack = self.utility.checkinttrack
        self.utility.checkinttrack = self.checkinttrack.Get3StateValue()
        self.abcparams['checkinttrack'] = str(self.utility.checkinttrack)

        #if oldcheckinttrack != self.utility.checkinttrack and self.utility.checkinttrack == 0:
        #    for index in xrange(len(self.queue.proctab)):
        #        tor = self.queue.proctab[index]
        #        if tor.abcengine and tor.abcengine.checkinginttrack:
        #            tor.abcengine.checkinginttrack = False
        #            tor.switchTracker(1)

        self.abcparams['resetdeftrackonstop'] = str(int(self.resetdeftrackonstop.GetValue()))

        if self.stripedlist.GetValue():
            if self.abcparams['stripedlist'] == "0":
                self.abcparams['stripedlist'] = "1"
                self.queue.updateStripesColour()
        else:
            if self.abcparams['stripedlist'] == "1":
                self.abcparams['stripedlist'] = "0"
                self.queue.updateStripesColour(clear = True)

        # Torrent and stripes colours
        col = self.colok.GetBackgroundColour()
        self.abcparams['colok'] = '%d,%d,%d' % (col.Red(), col.Green(), col.Blue())
        col = self.colnoinc.GetBackgroundColour()
        self.abcparams['colnoinc'] = '%d,%d,%d' % (col.Red(), col.Green(), col.Blue())
        col = self.colnocom.GetBackgroundColour()
        self.abcparams['colnocom'] = '%d,%d,%d' % (col.Red(), col.Green(), col.Blue())
        col = self.colnocon.GetBackgroundColour()
        self.abcparams['colnocon'] = '%d,%d,%d' % (col.Red(), col.Green(), col.Blue())
        col = self.coldisc.GetBackgroundColour()
        self.abcparams['coldisc'] = '%d,%d,%d' % (col.Red(), col.Green(), col.Blue())
        col = self.colstripes.GetBackgroundColour()
        self.abcparams['colstripes'] = '%d,%d,%d' % (col.Red(), col.Green(), col.Blue())

        # List font
        self.abcparams['listfont'] = self.listfontface
        self.abcparams['listfontsize'] = str(self.listfontsize)
        self.abcparams['listfontstyle'] = str(self.listfontstyle)
        self.abcparams['listfontweight'] = str(self.listfontweight)

        # Saving value to abc.conf
        tcfm = TorrentConfigFileManager(path.join(self.utility.datapath, "abc.conf"), self.abcparams)
        tcfm.writeAllConfig()

        self.queue.updateRunningTorrentCounters()

        if not self.parent.window.torrentlistloading:
            self.queue.invokeLater(self.queue.scheduler)

        return True

    def onOK(self, event):
        if self.onApply(event):
            self.onClose()

    def onClose(self):
        if self.advancedMenuBox is not None:
            self.advancedMenuBox.onClose()
        self.Destroy()


class DateTime():
    def __init__(self, parent, utility, localize, datetime):
        self.sizer = wx.BoxSizer(wx.HORIZONTAL)

        self.dp = wx.DatePickerCtrl(parent, size = (80, -1), dt = datetime, style = wx.DP_DROPDOWN | wx.DP_SHOWCENTURY)
        self.dp.SetFont(parent.GetFont())
        self.sizer.Add(self.dp, 0, wx.ALIGN_CENTER_VERTICAL)

        self.tc = masked.TimeCtrl(parent, -1, fmt24hr = True, display_seconds = False)
        self.tc.SetFont(parent.GetFont())
        self.sizer.Add(self.tc, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)

        height = self.tc.GetSize().height
        spin = wx.SpinButton(parent, -1, (-1, -1), (height * 2 / 3, height), wx.SP_ARROW_KEYS | wx.SP_VERTICAL)
        self.tc.BindSpinButton(spin)
        self.tc.SetValue(datetime)
        self.sizer.Add(spin, 0, wx.ALIGN_CENTER_VERTICAL)

        buttonlabel = localize('now')
        buttonwidth = parent.GetTextExtent(buttonlabel)[0] + 12
        buttonlabel = buttonlabel.replace('&', '&&')
        nowbtn = wx.Button(parent, -1, buttonlabel, size = wx.Size(buttonwidth, utility.buttonheight))
        nowbtn.Bind(wx.EVT_BUTTON, self.onNow)
        self.sizer.Add(nowbtn, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 2)

    def onNow(self, event):
        now = wx.DateTimeFromTimeT(int(time()))
        now.SetSecond(0)
        self.dp.SetValue(now)
        self.tc.SetValue(now)

    def getValue(self):
        datetime = self.dp.GetValue()
        time = self.tc.GetWxDateTime()
        datetime.SetHour(time.GetHour())
        datetime.SetMinute(time.GetMinute())
        try:
            ticks = datetime.GetTicks()
        except:
            ticks = 0
        return ticks

    def getSizer(self):
        return self.sizer


class ABCAdvancedOptionWindow(wx.Frame):
    def __init__(self, parent):
        self.parent = parent
        self.utility = self.parent.utility
        self.localize = self.utility.lang.get
        self.abcparams = self.utility.abcparams
        self.queue = self.parent.queue
        self.FONT = 8

        wx.Frame.__init__(self, None, -1, self.localize('abcadvancepref'), style = wx.DEFAULT_DIALOG_STYLE)
        if sys.platform == 'win32':
            self.SetIcon(self.parent.parent.icon)

        self.panel = wx.Panel(self, -1)

        outerbox = wx.BoxSizer(wx.VERTICAL)

        advsettingbox = wx.StaticBoxSizer(wx.StaticBox(self.panel, -1, ''), wx.VERTICAL)

        colsizer = wx.FlexGridSizer(cols = 1, hgap = 13, vgap = 10)

        self.ip_data = wx.TextCtrl(parent = self.panel, id = -1, value = self.abcparams['ip'],
                                   size = (self.FONT * 13, self.utility.digitheight))

        self.bind_data = wx.TextCtrl(parent = self.panel, id = -1, value = self.abcparams['bind'],
                                     size = (self.FONT * 13, self.utility.digitheight))

        if self.utility.hasipv6:
            self.ipv6bindsv4_data = wx.Choice(self.panel, -1, choices = [self.localize('separatesockets'), self.localize('singlesocket')])
            self.ipv6bindsv4_data.SetSelection(int(self.abcparams['ipv6_binds_v4']))

        self.minpeers_data = SpinBox(self.panel, width = 31, height = self.utility.digitheight,
                                     value = str(self.abcparams['min_peers']), min = 1, max = 255)

        self.maxconnections_data = SpinBox(self.panel, width = 31, height = self.utility.digitheight,
                                           value = str(self.abcparams['max_connections']), min = 1, max = 255)

        self.alloctype_data = wx.Choice(self.panel, -1, choices = [self.localize('normalalloc'), self.localize('background'),
                                                                   self.localize('prealloc'), self.localize('sparse1'),
                                                                   self.localize('sparse2')])
        self.alloctype_data.SetSelection(int(self.abcparams['alloc_type']))

        allocratebox = wx.BoxSizer(wx.HORIZONTAL)
        self.allocrate_data = SpinBox(self.panel, width = 31, height = self.utility.digitheight,
                                      value = str(self.abcparams['alloc_rate']), min = 1, max = 100)
        allocratebox.Add(self.allocrate_data.getSizer(), 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
        allocratebox.Add(self.staticText(self.utility.mbps), 0, wx.ALIGN_CENTER_VERTICAL)

        self.locking_data = wx.Choice(self.panel, -1, choices = [self.localize('locknever'), self.localize('lockwrite'),
                                                       self.localize('lockalways')])
        if int(self.abcparams['lock_files']):
            if int(self.abcparams['lock_while_reading']):
                self.locking_data.SetSelection(2)
            else:
                self.locking_data.SetSelection(1)
        else:
            self.locking_data.SetSelection(0)

        self.doublecheck_data = wx.Choice(self.panel, -1, choices = [self.localize('nocheck'), self.localize('dblcheck'),
                                                                self.localize('trplcheck')])
        if int(self.abcparams['double_check']):
            if int(self.abcparams['triple_check']):
                self.doublecheck_data.SetSelection(2)
            else:
                self.doublecheck_data.SetSelection(1)
        else:
            self.doublecheck_data.SetSelection(0)

        maxfilesopen_choices = ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '15', '20', '25', '30', '35', '40', '45', '50', '60', '75', '100', '150', '200', self.localize('nolimit')]
        self.maxfilesopen_data = wx.Choice(self.panel, -1, choices = maxfilesopen_choices)
        setval = int(self.abcparams['max_files_open'])
        if setval == 0:
            setval = self.localize('nolimit')
        else:
            setval = str(setval)
        if not setval in maxfilesopen_choices:
            setval = '40'
        self.maxfilesopen_data.SetStringSelection(setval)

        expirecachedata_choices = ['3 ' + self.utility.d, '5 ' + self.utility.d, '7 ' + self.utility.d,
                                   '10 ' + self.utility.d, '15 ' + self.utility.d, '30 ' + self.utility.d,
                                   '60 ' + self.utility.d, '90 ' + self.utility.d, self.localize('never')]
        self.expirecachedata_data = wx.Choice(self.panel, -1, choices = expirecachedata_choices)
        setval = int(self.abcparams['expire_cache_data'])
        if setval == 0:
            setval = self.localize('never')
        else:
            setval = str(setval) + ' ' + self.utility.d
        if not setval in expirecachedata_choices:
            setval = '10 ' + self.utility.d
        self.expirecachedata_data.SetStringSelection(setval)

        writebuffersizebox = wx.BoxSizer(wx.HORIZONTAL)
        self.writebuffersize_data = wx.TextCtrl(parent = self.panel, id = -1, value = self.abcparams['writebuffersize'],
                                                size = (self.FONT * 7, self.utility.digitheight))
        self.writebuffersize_data.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDot)
        self.writebuffersize_data.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        writebuffersizebox.Add(self.writebuffersize_data, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
        writebuffersizebox.Add(self.staticText(self.utility.mb), 0, wx.ALIGN_CENTER_VERTICAL)

        readbuffersizebox = wx.BoxSizer(wx.HORIZONTAL)
        self.readbuffersize_data = wx.TextCtrl(parent = self.panel, id = -1, value = self.abcparams['readbuffersize'],
                                               size = (self.FONT * 7, self.utility.digitheight))
        self.readbuffersize_data.Bind(wx.EVT_CHAR, self.utility.onWriteDigitsDot)
        self.readbuffersize_data.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        readbuffersizebox.Add(self.readbuffersize_data, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
        readbuffersizebox.Add(self.staticText(self.utility.mb), 0, wx.ALIGN_CENTER_VERTICAL)

        self.readbuffermemorysaving_data = wx.Choice(self.panel, -1, choices = [self.localize('loweruploads'), self.localize('stopbuffering')])
        self.readbuffermemorysaving_data.SetSelection(int(self.abcparams['readbuffermemorysaving']))

        readbuffermaxglobalsizebox1 = wx.BoxSizer(wx.HORIZONTAL)
        self.readbuffermaxglobalsize_data = wx.TextCtrl(parent = self.panel, id = -1, value = self.abcparams['readbuffermaxglobalsize'],
                                                        size = (self.FONT * 7, self.utility.digitheight))
        self.readbuffermaxglobalsize_data.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.readbuffermaxglobalsize_data.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        self.readbuffermaxglobalnumber_data = wx.TextCtrl(parent = self.panel, id = -1, value = self.abcparams['readbuffermaxglobalnumber'],
                                                          size = (self.FONT * 5, self.utility.digitheight))
        self.readbuffermaxglobalnumber_data.Bind(wx.EVT_CHAR, self.utility.onWriteDigits)
        self.readbuffermaxglobalnumber_data.Bind(wx.EVT_RIGHT_UP, self.onRightButtonText)
        self.readbuffermaxglobalnumber_data.SetToolTipString(self.localize('0isnolimittt'))
        if PIECEREADBUFFERPOOL.overloaded:
            rbgscolour = 'Red'
        else:
            rbgscolour = None
        readbuffermaxglobalsizebox1.Add(self.readbuffermaxglobalsize_data, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
        readbuffermaxglobalsizebox1.Add(self.staticText(self.utility.mb), 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 10)
        readbuffermaxglobalsizebox1.Add(self.staticText(self.localize('and')), 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 10)
        readbuffermaxglobalsizebox1.Add(self.readbuffermaxglobalnumber_data, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
        readbuffermaxglobalsizebox1.Add(self.staticText(self.localize('buffers')), 0, wx.ALIGN_CENTER_VERTICAL)

        readbuffermaxglobalsizebox2 = wx.BoxSizer(wx.HORIZONTAL)
        self.readbufferglobalsize = self.staticText('%.1f' % (PIECEREADBUFFERPOOL.totalSize() / 1048576.), size = (self.FONT * 5, -1), color = rbgscolour)
        readbuffermaxglobalsizebox2.Add(self.staticText(self.localize('current')), 0, wx.ALIGN_CENTER_VERTICAL)
        readbuffermaxglobalsizebox2.Add(self.readbufferglobalsize, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT | wx.RIGHT, 5)
        readbuffermaxglobalsizebox2.Add(self.staticText(self.utility.mb), 0, wx.ALIGN_CENTER_VERTICAL)

        twocolsizer = wx.FlexGridSizer(cols = 2, hgap = 20)
        datasizer = wx.FlexGridSizer(cols = 2, hgap = 5, vgap = 2)
        datasizer.Add(self.staticText(self.localize('localip')), 1, wx.ALIGN_CENTER_VERTICAL)
        datasizer.Add(self.ip_data)
        datasizer.Add(self.staticText(self.localize('iptobindto')), 1, wx.ALIGN_CENTER_VERTICAL)
        datasizer.Add(self.bind_data)
        if self.utility.hasipv6:
            datasizer.Add(self.staticText(self.localize('ipv6sockethandling')), 1, wx.ALIGN_CENTER_VERTICAL)
            datasizer.Add(self.ipv6bindsv4_data)
        datasizer.Add(self.staticText(self.localize('minnumberofpeer')), 1, wx.ALIGN_CENTER_VERTICAL)
        datasizer.Add(self.minpeers_data.getSizer())
        datasizer.Add(self.staticText(self.localize('maxpeerconnection')), 1, wx.ALIGN_CENTER_VERTICAL)
        datasizer.Add(self.maxconnections_data.getSizer())
        datasizer.Add(self.staticText(self.localize('diskalloctype')), 1, wx.ALIGN_CENTER_VERTICAL)
        datasizer.Add(self.alloctype_data)
        datasizer.Add(self.staticText(self.localize('allocrate')), 1, wx.ALIGN_CENTER_VERTICAL)
        datasizer.Add(allocratebox)
        datasizer.Add(self.staticText(self.localize('filelocking')), 1, wx.ALIGN_CENTER_VERTICAL)
        datasizer.Add(self.locking_data)
        datasizer.Add(self.staticText(self.localize('extradatachecking')), 1, wx.ALIGN_CENTER_VERTICAL)
        datasizer.Add(self.doublecheck_data)
        datasizer.Add(self.staticText(self.localize('maxfileopen')), 1, wx.ALIGN_CENTER_VERTICAL)
        datasizer.Add(self.maxfilesopen_data)
        datasizer.Add(self.staticText(self.localize('expirecachedata')), 1, wx.ALIGN_CENTER_VERTICAL)
        datasizer.Add(self.expirecachedata_data)
        datasizer.Add(self.staticText(self.localize('writebuffersize')), 1, wx.ALIGN_CENTER_VERTICAL)
        datasizer.Add(writebuffersizebox)
        datasizer.Add(self.staticText(self.localize('readbuffersize')), 1, wx.ALIGN_CENTER_VERTICAL)
        datasizer.Add(readbuffersizebox)
        datasizer.Add(self.staticText(self.localize('readbuffermemorysaving')), 1, wx.ALIGN_CENTER_VERTICAL)
        datasizer.Add(self.readbuffermemorysaving_data)
        datasizer.Add(self.staticText(self.localize('readbuffermaxglobalsize')), 1, wx.ALIGN_CENTER_VERTICAL)
        datasizer.Add(readbuffermaxglobalsizebox1)
        datasizer.Add((0, -1))
        datasizer.Add(readbuffermaxglobalsizebox2)

        twocolsizer.Add(datasizer)

        infosizer = wx.FlexGridSizer(cols = 1)
        self.hinttext = self.staticText('', self.FONT, False, 'Blue')
        infosizer.Add(self.hinttext, 1, wx.ALIGN_LEFT | wx.ALIGN_CENTER_VERTICAL)
        infosizer.SetMinSize((180, 100))
        twocolsizer.Add(infosizer, 1, wx.EXPAND)

        colsizer.Add(twocolsizer)

        colsizer.Add(self.staticText(self.localize('advsettingwarning1'), self.FONT - 1), 1, wx.ALIGN_CENTER)
        colsizer.Add(self.staticText(self.localize('advsettingwarning2'), self.FONT - 1), 1, wx.ALIGN_CENTER)

        advsettingbox.Add(colsizer, 1, wx.EXPAND)
        outerbox.Add(advsettingbox, 0, wx.EXPAND | wx.TOP, -4)

        button_box = wx.BoxSizer(wx.HORIZONTAL)

        defaultsbutton = wx.Button(self.panel, -1, self.localize('reverttodefault'))
        button_box.Add(defaultsbutton, 0, wx.ALL, 5)

        applybutton = wx.Button(self.panel, -1, self.localize('apply'), size = (60, -1))
        button_box.Add(applybutton, 0, wx.ALL, 5)

        okbutton = wx.Button(self.panel, -1, self.localize('ok'), size = (60, -1))
        button_box.Add(okbutton, 0, wx.ALL, 5)

        cancelbutton = wx.Button(self.panel, -1, self.localize('cancel'), size = (60, -1))
        button_box.Add(cancelbutton, 0, wx.ALL, 5)

        outerbox.Add(button_box, 0, wx.ALIGN_CENTER)

        self.panel.SetAutoLayout(True)
        self.panel.SetSizer(outerbox)
        self.panel.Fit()
        self.SetClientSize(self.panel.GetSize())

        wx.EVT_LEFT_DOWN(self.readbufferglobalsize, self.resetReadBufferGlobalSizeOverload)
        wx.EVT_RIGHT_UP(self.readbufferglobalsize, self.showReadBufferGlobalSizeStatus)
        wx.EVT_BUTTON(self, applybutton.GetId(), self.onApply)
        wx.EVT_BUTTON(self, okbutton.GetId(), self.onOK)
        wx.EVT_BUTTON(self, cancelbutton.GetId(), self.onCancel)
        wx.EVT_BUTTON(self, defaultsbutton.GetId(), self.setDefaults)        
        wx.EVT_CLOSE(self, self.onClose)
        self.ip_data.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.ip_data.Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
        self.bind_data.Bind(wx.EVT_CHAR, self.utility.onWriteFilteredText)
        self.bind_data.Bind(wx.EVT_TEXT_PASTE, self.utility.onPasteText)
        wx.EVT_ENTER_WINDOW(self.ip_data, self.ip_hint)
        wx.EVT_ENTER_WINDOW(self.bind_data, self.bind_hint)
        if self.utility.hasipv6:
            wx.EVT_ENTER_WINDOW(self.ipv6bindsv4_data, self.ipv6bindsv4_hint)
        wx.EVT_ENTER_WINDOW(self.minpeers_data.getTextWindow(), self.minpeers_hint)
        wx.EVT_ENTER_WINDOW(self.minpeers_data.getSpinWindow(), self.minpeers_hint)
        wx.EVT_ENTER_WINDOW(self.maxconnections_data.getTextWindow(), self.maxconnections_hint)
        wx.EVT_ENTER_WINDOW(self.maxconnections_data.getSpinWindow(), self.maxconnections_hint)
        wx.EVT_ENTER_WINDOW(self.alloctype_data, self.alloctype_hint)
        wx.EVT_ENTER_WINDOW(self.allocrate_data.getTextWindow(), self.allocrate_hint)
        wx.EVT_ENTER_WINDOW(self.allocrate_data.getSpinWindow(), self.allocrate_hint)
        wx.EVT_ENTER_WINDOW(self.locking_data, self.locking_hint)
        wx.EVT_ENTER_WINDOW(self.doublecheck_data, self.doublecheck_hint)        
        wx.EVT_ENTER_WINDOW(self.maxfilesopen_data, self.maxfilesopen_hint)
        wx.EVT_ENTER_WINDOW(self.expirecachedata_data, self.expirecachedata_hint)
        wx.EVT_ENTER_WINDOW(self.writebuffersize_data, self.writebuffersize_hint)
        wx.EVT_ENTER_WINDOW(self.readbuffersize_data, self.readbuffersize_hint)
        wx.EVT_ENTER_WINDOW(self.readbuffermemorysaving_data, self.readbuffermemorysaving_hint)
        wx.EVT_ENTER_WINDOW(self.readbuffermaxglobalsize_data, self.readbuffermaxglobalsize_hint)
        wx.EVT_ENTER_WINDOW(self.readbuffermaxglobalnumber_data, self.readbuffermaxglobalsize_hint)

        xoptions, yoptions = self.parent.GetPosition()
        xadv = xoptions + (self.parent.GetSize()[0] - self.GetSize()[0]) / 2
        yadv = yoptions + 22
        if xadv < 0:
            xadv = 0
        if yadv < 0:
            yadv = 0
        self.SetPosition((xadv, yadv))
        self.Show()

    def onRightButtonText(self, event):
        pass

    def staticText(self, text, font = None, underline = False, color = None, size = (-1, -1)):
        if font is None:
            font = self.FONT
        x = wx.StaticText(self.panel, -1, text, style = wx.ALIGN_LEFT, size = size)
        x.SetFont(wx.Font(font, wx.DEFAULT, wx.NORMAL, wx.NORMAL, underline))
        if color is not None:
            x.SetForegroundColour(color)
        return x

    def setDefaults(self, event):
        self.ip_data.SetValue('')
        self.bind_data.SetValue('')
        if self.utility.hasipv6:
            self.ipv6bindsv4_data.SetSelection(1)
        self.minpeers_data.setValue(15)
        self.maxconnections_data.setValue(15)
        self.alloctype_data.SetStringSelection(self.localize('sparse1'))
        self.allocrate_data.setValue(2)
        self.locking_data.SetSelection(0)
        self.doublecheck_data.SetSelection(0)
        self.maxfilesopen_data.SetStringSelection('75')
        self.expirecachedata_data.SetStringSelection('15 ' + self.utility.d)
        self.writebuffersize_data.SetValue('4.0')
        self.readbuffersize_data.SetValue('0.5')
        self.readbuffermemorysaving_data.SetStringSelection(self.localize('stopbuffering'))
        self.readbuffermaxglobalsize_data.SetValue('100')
        self.readbuffermaxglobalnumber_data.SetValue('100')

    def resetReadBufferGlobalSizeOverload(self, event):
        PIECEREADBUFFERPOOL.overloaded = False
        self.readbufferglobalsize.SetForegroundColour(wx.NullColour)
        self.readbufferglobalsize.Refresh()

    def showReadBufferGlobalSizeStatus(self, event):
        if PIECEREADBUFFERPOOL.overloaded:
            status = self.localize('readbufferoverloaded')
        else:
            status = self.localize('readbuffernotoverloaded')
        report1, total1 = PIECEREADBUFFERPOOL.report()
        report2, total2 = GENBUFFERPOOL.report()
        dlg = wx.MessageDialog(self, '%s\n%s\nTOTAL ---> %.2f Mb' % (report1, report2, total1 + total2),
                               self.localize('abcokcreadbufferstatus') + status, style = wx.OK )
        dlg.ShowModal()
        dlg.Destroy()

    def onApply(self, event):
        errortype = False
        try:
            readbuffersize_float = float(self.readbuffersize_data.GetValue())
        except:
            errortype = True
        if errortype or readbuffersize_float < 0:
            dlg = wx.MessageDialog(self, self.localize('readbuffersizewarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        try:
            writebuffersize_float = float(self.writebuffersize_data.GetValue())
        except:
            errortype = True
        if errortype or writebuffersize_float < 0:
            dlg = wx.MessageDialog(self, self.localize('writebuffersizewarning'), self.localize('abcokcerror'), wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        self.abcparams['ip'] = self.ip_data.GetValue()
        self.abcparams['bind'] = self.bind_data.GetValue()
        if self.utility.hasipv6:
            self.abcparams['ipv6_binds_v4'] = str(self.ipv6bindsv4_data.GetSelection())

        try:
            min_peers = self.minpeers_data.getValue()
        except:
            min_peers = 15
            self.minpeers_data.setValue('15')
        self.abcparams['min_peers'] = str(min_peers)

        try:
            max_connections = self.maxconnections_data.getValue()
        except:
            max_connections = 15
            self.maxconnections_data.setValue('15')
        self.abcparams['max_connections'] = str(max_connections)
        if max_connections:
            self.abcparams['max_initiate'] = str(min(2 * int(self.abcparams['min_peers']), max_connections))
        else:
            self.abcparams['max_initiate'] = str(2 * int(self.abcparams['min_peers']))

        self.abcparams['alloc_type'] = str(self.alloctype_data.GetSelection())
        try:
            alloc_rate = self.allocrate_data.getValue()
        except:
            alloc_rate = 2
            self.allocrate_data.setValue('2')
        self.abcparams['alloc_rate'] = str(alloc_rate)
        self.abcparams['lock_files'] = str(int(self.locking_data.GetSelection() >= 1))
        self.abcparams['lock_while_reading'] = str(int(self.locking_data.GetSelection() > 1))
        self.abcparams['double_check'] = str(int(self.doublecheck_data.GetSelection() >= 1))
        self.abcparams['triple_check'] = str(int(self.doublecheck_data.GetSelection() > 1))

        try:
            max_files_open = int(self.maxfilesopen_data.GetStringSelection())
        except:       # If it ain't a number, it must be "no limit"
            max_files_open = 0
        self.abcparams['max_files_open'] = str(max_files_open)

        try:
            expire_cache_data = int(self.expirecachedata_data.GetStringSelection()[:-len(self.utility.d) - 1])
        except:       # If it ain't a number, it must be "never"
            expire_cache_data = 0
        if self.abcparams['expire_cache_data'] == '0':
            self.queue.expirecachecounter = 0
        self.abcparams['expire_cache_data'] = str(expire_cache_data)
        self.utility.expirecachedata = expire_cache_data * 86400

        if writebuffersize_float != float(self.abcparams['writebuffersize']):
            self.abcparams['writebuffersize'] = str(writebuffersize_float)
            for tor in self.queue.proctab:
                if tor.abcengine and tor.abcengine.dow:
                    tor.abcengine.dow.setWriteBufferSize(writebuffersize_float)

        if readbuffersize_float != float(self.abcparams['readbuffersize']):
            self.abcparams['readbuffersize'] = str(readbuffersize_float)
            for tor in self.queue.proctab:
                if tor.abcengine and tor.abcengine.dow:
                    tor.abcengine.dow.setReadBufferSize(readbuffersize_float)

        newreadbuffermemorysaving = str(self.readbuffermemorysaving_data.GetSelection())
        if newreadbuffermemorysaving != self.abcparams['readbuffermemorysaving']:
            self.abcparams['readbuffermemorysaving'] = newreadbuffermemorysaving
            for tor in self.queue.proctab:
                if tor.abcengine and tor.abcengine.dow:
                    tor.abcengine.dow.setReadBufferMemorySaving(int(newreadbuffermemorysaving))

        try:
            readbuffermaxglobalsize_int = int(self.readbuffermaxglobalsize_data.GetValue())
        except:
            newreadbuffermaxglobalsize = '100'
        else:
            newreadbuffermaxglobalsize = str(readbuffermaxglobalsize_int)
        if newreadbuffermaxglobalsize != self.abcparams['readbuffermaxglobalsize']:
            self.abcparams['readbuffermaxglobalsize'] = newreadbuffermaxglobalsize
            PIECEREADBUFFERPOOL.setCatMaxMem(int(newreadbuffermaxglobalsize) * 1048576)

        try:
            readbuffermaxglobalnumber_int = int(self.readbuffermaxglobalnumber_data.GetValue())
        except:
            newreadbuffermaxglobalnumber = '60'
        else:
            newreadbuffermaxglobalnumber = str(readbuffermaxglobalnumber_int)
        if newreadbuffermaxglobalnumber != self.abcparams['readbuffermaxglobalnumber']:
            self.abcparams['readbuffermaxglobalnumber'] = newreadbuffermaxglobalnumber
            PIECEREADBUFFERPOOL.setCatMaxNumber(int(newreadbuffermaxglobalnumber))

        # Saving value to abc.conf
        tcfm = TorrentConfigFileManager(path.join(self.utility.datapath, "abc.conf"), self.abcparams)
        tcfm.writeAllConfig()

        return True

    def onOK(self, event):
        if self.onApply(event):
            self.onClose()

    def onCancel(self, event):
        self.onClose()

    def onClose(self, event = None):
        self.parent.advancedMenuBox = None
        self.Destroy()

    def ip_hint(self, event):
        self.hinttext.SetLabel(self.localize('iphint'))

    def bind_hint(self, event):
        self.hinttext.SetLabel(self.localize('bindhint'))

    def ipv6bindsv4_hint(self, event):
        self.hinttext.SetLabel(self.localize('ipv6bindsv4hint'))

    def minpeers_hint(self, event):
        self.hinttext.SetLabel(self.localize('minpeershint'))

    def alloctype_hint(self, event):
        self.hinttext.SetLabel(self.localize('alloctypehint'))

    def allocrate_hint(self, event):
        self.hinttext.SetLabel(self.localize('allocratehint'))

    def locking_hint(self, event):
        self.hinttext.SetLabel(self.localize('lockinghint'))

    def doublecheck_hint(self, event):
        self.hinttext.SetLabel(self.localize('doublecheckhint'))

    def maxfilesopen_hint(self, event):
        self.hinttext.SetLabel(self.localize('maxfilesopenhint'))

    def maxconnections_hint(self, event):
        self.hinttext.SetLabel(self.localize('maxconnectionshint'))

    def expirecachedata_hint(self, event):
        self.hinttext.SetLabel(self.localize('expirecachedatahint'))

    def writebuffersize_hint(self, event):
        self.hinttext.SetLabel(self.localize('writebuffersizehint'))

    def readbuffersize_hint(self, event):
        self.hinttext.SetLabel(self.localize('readbuffersizehint'))

    def readbuffermemorysaving_hint(self, event):
        self.hinttext.SetLabel(self.localize('readbuffermemorysavinghint'))

    def readbuffermaxglobalsize_hint(self, event):
        self.hinttext.SetLabel(self.localize('readbuffermaxglobalsizehint'))
