# Written by John Hoffman
# see LICENSE.txt for license information
# Updated and modified for ABC_OKC : Old King Cole

import socket
from ssl import _create_unverified_context
from httplib import HTTPConnection, HTTPSConnection
from urlparse import urlparse
from gzip import GzipFile
from StringIO import StringIO
from random import getrandbits
from binascii import b2a_hex
from time import clock
from threading import Lock
from urllib import quote, unquote

from bencode import bdecode
from utility import exceptionArgsToString, getABCUtility

from __init__ import USERAGENT

MAX_REDIRECTS = 10
UNRESOLVED = {}
RESOLVESEM = Lock()

def toint(s):
    return long(b2a_hex(s), 16)

def tobinary(i):
    return (chr(i >> 24) + chr((i >> 16) & 0xFF) + 
            chr((i >> 8) & 0xFF) + chr(i & 0xFF))


class urlopen:
    def __init__(self, url, headers = None):
        self.tries = 0
        self.gzipfile = None
        if headers is None:
            headers = {}
        headers.update({'User-Agent': USERAGENT[0], 'Accept-Encoding': 'gzip', 'Cache-Control': 'no-cache'})
        if getABCUtility().skipcertifverif == 1:
            self.context = _create_unverified_context()
        else:
            self.context = None
        self._open(url.strip(), headers)

    def _open(self, url, headers):
        self.tries += 1
        if self.tries > MAX_REDIRECTS:
            raise IOError, (getABCUtility().lang.get('httperror'), 500,
                            getABCUtility().lang.get('redirrecursion'))
        up = urlparse(url)
        scheme = up.scheme
        hostname = up.hostname
        path = up.path
        params = up.params
        query = up.query
        netloc = up.netloc
        if scheme != 'http' and scheme != 'https':
            raise IOError, (getABCUtility().lang.get('urlerror'), getABCUtility().lang.get('unknownurltype'), scheme, url)

        RESOLVESEM.acquire()
        lastunresolved = UNRESOLVED.get(hostname)
        now = clock()
        if lastunresolved and now - lastunresolved < 300:
            RESOLVESEM.release()
            raise IOError, (getABCUtility().lang.get('urlerror'), getABCUtility().lang.get('delayedresolving') + hostname)
        ip = getABCUtility().getHostByName(hostname)
        if ip is None:
            UNRESOLVED[hostname] = now
            RESOLVESEM.release()
            raise IOError, (getABCUtility().lang.get('urlerror'), getABCUtility().lang.get('cantresolve') + hostname)
        if lastunresolved:
            del UNRESOLVED[hostname]
        RESOLVESEM.release()
        loc = path
        if not loc.startswith('/'):
            loc = '/'+ loc
        if params:
            loc += ';' + params
        if query:
            loc += '?' + query
        reqloc = quote(getABCUtility().encodeString(loc), safe=':/;?=&%')
        try:
            if scheme == 'http':
                self.connection = HTTPConnection(quote(getABCUtility().encodeString(netloc), safe=':@'), timeout = 30)
            else:
                self.connection = HTTPSConnection(quote(getABCUtility().encodeString(netloc), safe=':@'), timeout = 30, context = self.context)
            self.connection.request('GET', reqloc, None, headers)
            #print 'GET :', reqloc, headers
            self.response = self.connection.getresponse()
        except Exception, e:
            raise IOError, (getABCUtility().lang.get('httperror'), exceptionArgsToString(e))
        status = self.response.status
        #print 'STATUS :', status
        if status == 301 or status == 302:
            try:
                self.connection.close()
            except:
                pass
            rp = urlparse(self.response.getheader('Location'))
            if rp.scheme:
                scheme = rp.scheme
            if rp.path:
                path = rp.path
            if rp.params:
                params = rp.params
            if rp.query:
                query = rp.query
            if rp.netloc:
                netloc = rp.netloc
            loc = path
            if not loc.startswith('/'):
                loc = '/'+ loc
            if params:
                loc += ';' + params
            if query:
                loc += '?' + query
            self._open(scheme + '://' + netloc + loc, headers)
        elif status != 200:
            try:
                self.connection.close()
            except:
                pass
            raise IOError, (getABCUtility().lang.get('httperror'), status, self.response.reason)

    def read(self):
        try:
            data = self.response.read()
        except:
            raise IOError, (getABCUtility().lang.get('httperror'), getABCUtility().lang.get('corruptresponse'))
        if self.response.getheader('Content-Encoding', '').find('gzip') >= 0:
            try:
                self.gzipfile = GzipFile(fileobj = StringIO(data))
                data = self.gzipfile.read()
            except:
                raise IOError, (getABCUtility().lang.get('httperror'), getABCUtility().lang.get('corruptresponse'))
        return data

    def close(self):
        self.connection.close()
        if self.gzipfile:
            self.gzipfile.close()


def udpurlopen(url, request):
    # Max timeout for each request is 30 s
    up = urlparse(url.strip())
    if up.port is None:
        raise IOError, (getABCUtility().lang.get('urlerror'), getABCUtility().lang.get('noport'))

    RESOLVESEM.acquire()
    lastunresolved = UNRESOLVED.get(up.hostname)
    now = clock()
    if lastunresolved and now - lastunresolved < 300:
        RESOLVESEM.release()
        raise IOError, (getABCUtility().lang.get('urlerror'), getABCUtility().lang.get('delayedresolving') + up.hostname)
    ip = getABCUtility().getHostByName(up.hostname)
    if ip is None:
        UNRESOLVED[up.hostname] = now
        RESOLVESEM.release()
        raise IOError, (getABCUtility().lang.get('urlerror'), getABCUtility().lang.get('cantresolve') + up.hostname)
    if lastunresolved:
        del UNRESOLVED[up.hostname]
    RESOLVESEM.release()
    # Get connection ID
    sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    sock.settimeout(15)
    reqnumber = 0
    while True:
        reqnumber += 1
        transactionid = tobinary(getrandbits(32))
        sock.sendto("\x00\x00\x04\x17'\x10\x19\x80" + tobinary(0) + transactionid, 0, (ip, up.port))
        try:
            data = sock.recv(512)
        except socket.timeout:
            if reqnumber < 2:
                continue
            sock.close()
            raise IOError, (getABCUtility().lang.get('udperror'), getABCUtility().lang.get('timeout'))
        break
    if len(data) < 16:
        sock.close()
        raise IOError, (getABCUtility().lang.get('udperror'), getABCUtility().lang.get('corruptresponse'))
    receivedaction = toint(data[0:4])
    receivedtransactionid = data[4:8]
    if receivedtransactionid == transactionid and receivedaction == 3:
        sock.close()
        raise IOError, (getABCUtility().lang.get('udperror'), data[8:])
    if receivedtransactionid != transactionid or receivedaction != 0:
        sock.close()
        raise IOError, (getABCUtility().lang.get('udperror'), getABCUtility().lang.get('corruptresponse'))
    connectionid = data[8:16]

    # Send request
    for reqnumber in xrange(2):
        transactionid = tobinary(getrandbits(32))
        sock.sendto(connectionid + tobinary(request[0]) + transactionid + request[1], 0, (ip, up.port))
        try:
            data = sock.recv(4096)
        except socket.timeout:
            if reqnumber == 0:
                continue
            sock.close()
            raise IOError, (getABCUtility().lang.get('udperror'), getABCUtility().lang.get('timeout'))
        break
    sock.close()
    receivedaction = toint(data[0:4])
    receivedtransactionid = data[4:8]
    if receivedtransactionid == transactionid and receivedaction == 3:
        raise IOError, (getABCUtility().lang.get('udperror'), data[8:])
    if receivedtransactionid != transactionid or receivedaction != request[0]:
        raise IOError, (getABCUtility().lang.get('udperror'), getABCUtility().lang.get('corruptresponse'))

    return data
