##############################################################################
# Module : bitfield.py
# Author : Old King Cole
# Date   : 07/11/2007
#
# Description : Bitfields
#
##############################################################################

class Bitfield:
    def __init__(self, nbbit = None, string = None, boollist = None, copyfrom = None):
        # Can be created with "nbbit" zero bits
        # or initialized with the "nbbit" first bits from a string "string"
        # or initialized from a list of booleans "boollist"
        # or duplicated from an existing Bitfield "copyfrom"
        if copyfrom is not None:
            self.nbbit = copyfrom.nbbit
            self.field = bytearray(copyfrom.field)
            self.nbzero = copyfrom.nbzero
        else:
            if boollist is None:
                if nbbit is None:
                    raise ValueError, "number of bits is mandatory"
                self.nbbit = nbbit
            else:
                self.nbbit = len(boollist)

            nbchar, lastchar = divmod(self.nbbit, 8)
            if lastchar:
                nbchar += 1
            self.nbzero = self.nbbit
            if boollist is None:
                if string is None:
                    self.field = bytearray(nbchar)
                else:
                    if self.nbbit > len(string) << 3:
                        raise ValueError, "number of bits does not fit string length"
                    self.field = bytearray(string)
                    self.nbzero -= sum(self)
            else:
                self.field = bytearray(nbchar)
                for c in xrange(nbchar):
                    coord = c << 3
                    val = 0
                    for i in xrange(8):
                        boolnumber = coord + i
                        if boolnumber == self.nbbit:
                            break
                        if boollist[boolnumber]:
                            val += 128 >> i
                            self.nbzero -= 1
                    self.field[c] = val

    def getCoordinates(self, index):
        if index >= self.nbbit or index < 0:
            raise IndexError, "index out of range"
        return divmod(index, 8)

    def __setitem__(self, index, value):
        if index < 0:
            index = self.nbbit + index
        char, bit = self.getCoordinates(index)
        oldvalue = self.field[char] & 128 >> bit
        if value:
            if not oldvalue:
                self.field[char] |= 128 >> bit
                self.nbzero -= 1
        elif oldvalue:
            self.field[char] &= ~(128 >> bit)
            self.nbzero += 1

    def __getitem__(self, index):
        if index < 0:
            index = self.nbbit + index
        char, bit = self.getCoordinates(index)
        return 1 if self.field[char] & 128 >> bit else 0

    def __len__(self):
        return self.nbbit

    def __repr__(self):
        return ''.join([''.join(["1" if c & 128 >> i else "0" for i in xrange(8)]) for c in self.field])[:self.nbbit]

    def tostring(self):
        return str(self.field)

    def complete(self):
        return not self.nbzero

    def empty(self):
        return self.nbzero == self.nbbit
